/** Interfaces and types for management code GS 1 */
import { DateValue } from '@sage/xtrem-date-time';
import { fields } from '@sage/xtrem-ui';
import { DataTitle } from '../shared-functions/index';
export declare const compositeCodePrefix: RegExp;
export type BarcodeManagerSupportedFields = fields.Reference | fields.Date | fields.Text | fields.Numeric | fields.FilterSelect;
export type ElementTypeSupported = string | DateValue | number | undefined;
export type AsyncVoidFunction = () => Promise<void>;
export type VoidFunction = () => void;
export type AsyncAndVoidFunction = AsyncVoidFunction | VoidFunction;
export interface FieldSupported {
    mainField: BarcodeManagerSupportedFields;
    onChangeMainField?: AsyncVoidFunction;
    unitField?: BarcodeManagerSupportedFields;
    onChangeUnitField?: AsyncVoidFunction;
}
export type DictionaryFieldSupported = Record<DataTitle, FieldSupported>;
/**
 * This composite item is used in storage and service
 */
export type DataComposite = {
    DataTitle: DataTitle;
    data: ElementTypeSupported;
    unit?: ElementTypeSupported;
};
/**
 * All composite data have stored in dictionary.
 */
export type DictionaryDataComposite = Record<DataTitle, DataComposite>;
/**
 * This asynchronous function signature is used only for specifying
 * a call back to check composite data before continuous
 * @param dictionaryDataComposite : current dictionary  (may be empty)
 * @return true when dispatching is allowing to continue action
 *         false when dispatching must clear all composites and exiting
 */
export type AsyncCompositeAllowed = (dictionaryDataComposite: DictionaryDataComposite) => Promise<boolean>;
//# sourceMappingURL=screen-management-gs-1.d.ts.map