// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/index.d.ts
declare module '@sage/x3-structure/index' {
	export * from '@sage/x3-structure/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/index.d.ts
declare module '@sage/x3-structure/lib/index' {
	export * as enums from '@sage/x3-structure/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-structure/lib/node-extensions/index';
	export * as nodes from '@sage/x3-structure/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-structure/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/service-options/index.d.ts
declare module '@sage/x3-structure/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/nodes/site-groupings.d.ts
declare module '@sage/x3-structure/lib/nodes/site-groupings' {
	import { Node } from '@sage/xtrem-core';
	export class SiteGroupings extends Node {
	    readonly group: Promise<string>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly groupOfCompany: Promise<boolean>;
	    readonly legalCompany: Promise<boolean>;
	}
	//# sourceMappingURL=site-groupings.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/nodes/postal-code.d.ts
declare module '@sage/x3-structure/lib/nodes/postal-code' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3Structure from '@sage/x3-structure/lib/index';
	export class PostalCode extends Node {
	    readonly country: Reference<sageX3Structure.nodes.Country>;
	    readonly postal: Promise<string>;
	    readonly city: Promise<string>;
	    readonly municipality: Promise<string>;
	}
	//# sourceMappingURL=postal-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/nodes/index.d.ts
declare module '@sage/x3-structure/lib/nodes/index' {
	export * from '@sage/x3-structure/lib/nodes/country';
	export * from '@sage/x3-structure/lib/nodes/postal-code';
	export * from '@sage/x3-structure/lib/nodes/site-groupings';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/nodes/country.d.ts
declare module '@sage/x3-structure/lib/nodes/country' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer } from '@sage/xtrem-core';
	export class Country extends Node {
	    readonly code: Promise<string>;
	    readonly countryName: Promise<string>;
	    readonly intrastatCountry: Promise<string>;
	    readonly federalId: Promise<string>;
	    readonly iso31661Alpha2: Promise<string>;
	    readonly iso31661Alpha3: Promise<string>;
	    readonly iso31661Numeric: Promise<string>;
	    readonly language: Reference<sageX3System.nodes.Language | null>;
	    readonly euCountry: Promise<boolean>;
	    readonly euEntryDate: Promise<date | null>;
	    readonly text57363: Promise<date | null>;
	    readonly controlScript: Promise<string>;
	    readonly sicCodeFormat: Promise<string>;
	    readonly phoneNumberFormat: Promise<string>;
	    readonly postalCodeFormat: Promise<string>;
	    readonly postalCodeFormat1: Promise<string>;
	    readonly cityFormat: Promise<string>;
	    readonly upperCaseLetters: Promise<boolean>;
	    readonly cityCodeFormat: Promise<string>;
	    readonly addressFormat: Promise<string>;
	    readonly controlledLength: Promise<integer | null>;
	    readonly bankIdFormat: Promise<string>;
	    readonly domicileFormat: Promise<string>;
	    readonly printFormat: Promise<string>;
	    readonly companyTaxIdNoForm: Promise<string>;
	    readonly siteTaxIdNumberFormat: Promise<string>;
	    readonly identificationFormat: Promise<string>;
	    readonly vatFormat: Promise<string>;
	    readonly companyTaxIdNoForm1: Promise<boolean>;
	    readonly siteTaxIdNumberFormat1: Promise<boolean>;
	    readonly identFormat: Promise<boolean>;
	    readonly vatFormat1: Promise<boolean>;
	    readonly sicCodeFormat1: Promise<boolean>;
	    readonly stateFormat: Promise<string>;
	    readonly taxNumber: Promise<string>;
	    readonly subdivision1: Promise<boolean>;
	    readonly subdivision2: Promise<boolean>;
	    readonly subdivisionFormat: Promise<string>;
	    readonly subdivisionFormat2: Promise<string>;
	    readonly subdivisionTitle: Promise<string>;
	    readonly subdivisionTitle2: Promise<string>;
	    readonly subdivisionControl: Promise<boolean>;
	    readonly postalCodeControl: Promise<boolean>;
	    readonly bankControl: Promise<boolean>;
	    readonly lengthOfBank: Promise<integer | null>;
	    readonly ibanManagement: Promise<boolean>;
	    readonly mandatoryPostal: Promise<boolean>;
	    readonly companyTaxIdMandatory: Promise<boolean>;
	    readonly siteTaxIdNoMandator: Promise<boolean>;
	    readonly countryCodeControl: Promise<string>;
	    readonly regionCountryControl: Promise<string>;
	    readonly sepaArea: Promise<boolean>;
	    readonly localBidWindow: Promise<string>;
	}
	//# sourceMappingURL=country.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/node-extensions/miscellaneous-table-extension.d.ts
declare module '@sage/x3-structure/lib/node-extensions/miscellaneous-table-extension' {
	import * as sageX3System from '@sage/x3-system';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3Structure from '@sage/x3-structure/lib/index';
	export class MiscellaneousTableExtension extends NodeExtension<sageX3System.nodes.MiscellaneousTable> {
	    readonly groupOfCompany: Reference<sageX3Structure.nodes.SiteGroupings | null>;
	}
	declare module '@sage/x3-system/lib/nodes/miscellaneous-table' {
	    interface MiscellaneousTable extends MiscellaneousTableExtension {
	    }
	}
	//# sourceMappingURL=miscellaneous-table-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-structure/lib/node-extensions/index' {
	export * from '@sage/x3-structure/lib/node-extensions/miscellaneous-table-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/enums/index.d.ts
declare module '@sage/x3-structure/lib/enums/index' {
	export * from '@sage/x3-structure/lib/enums/entity-type';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-structure/build/lib/enums/entity-type.d.ts
declare module '@sage/x3-structure/lib/enums/entity-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntityTypeEnum {
	    businessPartner = 1,
	    company = 2,
	    site = 3,
	    user = 4,
	    accounts = 5,
	    leads = 6,
	    building = 7,
	    place = 8
	}
	export interface EntityType$EnumInterface {
	    businessPartner: 1;
	    company: 2;
	    site: 3;
	    user: 4;
	    accounts: 5;
	    leads: 6;
	    building: 7;
	    place: 8;
	}
	export type EntityType = keyof EntityType$EnumInterface;
	export const entityTypeDatatype: X3EnumDataType<keyof EntityType$EnumInterface, unknown>;
	//# sourceMappingURL=entity-type.d.ts.map
}
declare module '@sage/x3-structure' {
	export * from '@sage/x3-structure/index';
}
