declare module '@sage/x3-structure-api-partial' {
    import type {
        Language,
        MiscellaneousTable,
        MiscellaneousTableInput,
        MiscellaneousTables,
        Package as SageX3System$Package,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface EntityType$Enum {
        businessPartner: 1;
        company: 2;
        site: 3;
        user: 4;
        accounts: 5;
        leads: 6;
        building: 7;
        place: 8;
    }
    export type EntityType = keyof EntityType$Enum;
    export interface Country extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        countryName: string;
        intrastatCountry: string;
        federalId: string;
        iso31661Alpha2: string;
        iso31661Alpha3: string;
        iso31661Numeric: string;
        language: Language;
        euCountry: boolean;
        euEntryDate: string;
        text57363: string;
        controlScript: string;
        sicCodeFormat: string;
        phoneNumberFormat: string;
        postalCodeFormat: string;
        postalCodeFormat1: string;
        cityFormat: string;
        upperCaseLetters: boolean;
        cityCodeFormat: string;
        addressFormat: string;
        controlledLength: integer;
        bankIdFormat: string;
        domicileFormat: string;
        printFormat: string;
        companyTaxIdNoForm: string;
        siteTaxIdNumberFormat: string;
        identificationFormat: string;
        vatFormat: string;
        companyTaxIdNoForm1: boolean;
        siteTaxIdNumberFormat1: boolean;
        identFormat: boolean;
        vatFormat1: boolean;
        sicCodeFormat1: boolean;
        stateFormat: string;
        taxNumber: string;
        subdivision1: boolean;
        subdivision2: boolean;
        subdivisionFormat: string;
        subdivisionFormat2: string;
        subdivisionTitle: string;
        subdivisionTitle2: string;
        subdivisionControl: boolean;
        postalCodeControl: boolean;
        bankControl: boolean;
        lengthOfBank: integer;
        ibanManagement: boolean;
        mandatoryPostal: boolean;
        companyTaxIdMandatory: boolean;
        siteTaxIdNoMandator: boolean;
        countryCodeControl: string;
        regionCountryControl: string;
        sepaArea: boolean;
        localBidWindow: string;
    }
    export interface CountryInput extends ClientNodeInput {
        code?: string;
        countryName?: string;
        intrastatCountry?: string;
        federalId?: string;
        iso31661Alpha2?: string;
        iso31661Alpha3?: string;
        iso31661Numeric?: string;
        language?: string;
        euCountry?: boolean | string;
        euEntryDate?: string;
        text57363?: string;
        controlScript?: string;
        sicCodeFormat?: string;
        phoneNumberFormat?: string;
        postalCodeFormat?: string;
        postalCodeFormat1?: string;
        cityFormat?: string;
        upperCaseLetters?: boolean | string;
        cityCodeFormat?: string;
        addressFormat?: string;
        controlledLength?: integer | string;
        bankIdFormat?: string;
        domicileFormat?: string;
        printFormat?: string;
        companyTaxIdNoForm?: string;
        siteTaxIdNumberFormat?: string;
        identificationFormat?: string;
        vatFormat?: string;
        companyTaxIdNoForm1?: boolean | string;
        siteTaxIdNumberFormat1?: boolean | string;
        identFormat?: boolean | string;
        vatFormat1?: boolean | string;
        sicCodeFormat1?: boolean | string;
        stateFormat?: string;
        taxNumber?: string;
        subdivision1?: boolean | string;
        subdivision2?: boolean | string;
        subdivisionFormat?: string;
        subdivisionFormat2?: string;
        subdivisionTitle?: string;
        subdivisionTitle2?: string;
        subdivisionControl?: boolean | string;
        postalCodeControl?: boolean | string;
        bankControl?: boolean | string;
        lengthOfBank?: integer | string;
        ibanManagement?: boolean | string;
        mandatoryPostal?: boolean | string;
        companyTaxIdMandatory?: boolean | string;
        siteTaxIdNoMandator?: boolean | string;
        countryCodeControl?: string;
        regionCountryControl?: string;
        sepaArea?: boolean | string;
        localBidWindow?: string;
    }
    export interface CountryBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        countryName: string;
        intrastatCountry: string;
        federalId: string;
        iso31661Alpha2: string;
        iso31661Alpha3: string;
        iso31661Numeric: string;
        language: Language;
        euCountry: boolean;
        euEntryDate: string;
        text57363: string;
        controlScript: string;
        sicCodeFormat: string;
        phoneNumberFormat: string;
        postalCodeFormat: string;
        postalCodeFormat1: string;
        cityFormat: string;
        upperCaseLetters: boolean;
        cityCodeFormat: string;
        addressFormat: string;
        controlledLength: integer;
        bankIdFormat: string;
        domicileFormat: string;
        printFormat: string;
        companyTaxIdNoForm: string;
        siteTaxIdNumberFormat: string;
        identificationFormat: string;
        vatFormat: string;
        companyTaxIdNoForm1: boolean;
        siteTaxIdNumberFormat1: boolean;
        identFormat: boolean;
        vatFormat1: boolean;
        sicCodeFormat1: boolean;
        stateFormat: string;
        taxNumber: string;
        subdivision1: boolean;
        subdivision2: boolean;
        subdivisionFormat: string;
        subdivisionFormat2: string;
        subdivisionTitle: string;
        subdivisionTitle2: string;
        subdivisionControl: boolean;
        postalCodeControl: boolean;
        bankControl: boolean;
        lengthOfBank: integer;
        ibanManagement: boolean;
        mandatoryPostal: boolean;
        companyTaxIdMandatory: boolean;
        siteTaxIdNoMandator: boolean;
        countryCodeControl: string;
        regionCountryControl: string;
        sepaArea: boolean;
        localBidWindow: string;
    }
    export interface Country$Lookups {
        language: QueryOperation<Language>;
    }
    export interface Country$Operations {
        query: QueryOperation<Country>;
        read: ReadOperation<Country>;
        aggregate: {
            read: AggregateReadOperation<Country>;
            query: AggregateQueryOperation<Country>;
        };
        lookups(dataOrId: string | { data: CountryInput }): Country$Lookups;
        getDefaults: GetDefaultsOperation<Country>;
    }
    export interface PostalCode extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        country: Country;
        postal: string;
        city: string;
        municipality: string;
    }
    export interface PostalCodeInput extends ClientNodeInput {
        country?: string;
        postal?: string;
        city?: string;
        municipality?: string;
    }
    export interface PostalCodeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        country: Country;
        postal: string;
        city: string;
        municipality: string;
    }
    export interface PostalCode$Lookups {
        country: QueryOperation<Country>;
    }
    export interface PostalCode$Operations {
        query: QueryOperation<PostalCode>;
        read: ReadOperation<PostalCode>;
        aggregate: {
            read: AggregateReadOperation<PostalCode>;
            query: AggregateQueryOperation<PostalCode>;
        };
        lookups(dataOrId: string | { data: PostalCodeInput }): PostalCode$Lookups;
        getDefaults: GetDefaultsOperation<PostalCode>;
    }
    export interface SiteGroupings extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        group: string;
        description: string;
        shortDescription: string;
        groupOfCompany: boolean;
        legalCompany: boolean;
    }
    export interface SiteGroupingsInput extends ClientNodeInput {
        group?: string;
        description?: string;
        shortDescription?: string;
        groupOfCompany?: boolean | string;
        legalCompany?: boolean | string;
    }
    export interface SiteGroupingsBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        group: string;
        description: string;
        shortDescription: string;
        groupOfCompany: boolean;
        legalCompany: boolean;
    }
    export interface SiteGroupings$Operations {
        query: QueryOperation<SiteGroupings>;
        read: ReadOperation<SiteGroupings>;
        aggregate: {
            read: AggregateReadOperation<SiteGroupings>;
            query: AggregateQueryOperation<SiteGroupings>;
        };
        getDefaults: GetDefaultsOperation<SiteGroupings>;
    }
    export interface MiscellaneousTableExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        glossaryId: MiscellaneousTables;
        code: string;
        alpha1: string;
        alpha2: string;
        alpha3: string;
        alpha4: string;
        alpha5: string;
        alpha6: string;
        alpha7: string;
        alpha8: string;
        alpha9: string;
        alpha10: string;
        alpha11: string;
        alpha12: string;
        alpha13: string;
        alpha14: string;
        alpha15: string;
        numeric1: string;
        numeric2: string;
        numeric3: string;
        numeric4: string;
        numeric5: string;
        numeric6: string;
        numeric7: string;
        numeric8: string;
        numeric9: string;
        numeric10: string;
        numeric11: string;
        numeric12: string;
        numeric13: string;
        numeric14: string;
        numeric15: string;
        description: string;
        shortDescription: string;
        defaultValue: boolean;
        dependency: MiscellaneousTable;
        legislation: MiscellaneousTable;
        activeFlag: boolean;
        groupOfCompany: SiteGroupings;
    }
    export interface MiscellaneousTableInputExtension {
        glossaryId?: integer | string;
        code?: string;
        alpha1?: string;
        alpha2?: string;
        alpha3?: string;
        alpha4?: string;
        alpha5?: string;
        alpha6?: string;
        alpha7?: string;
        alpha8?: string;
        alpha9?: string;
        alpha10?: string;
        alpha11?: string;
        alpha12?: string;
        alpha13?: string;
        alpha14?: string;
        alpha15?: string;
        numeric1?: decimal | string;
        numeric2?: decimal | string;
        numeric3?: decimal | string;
        numeric4?: decimal | string;
        numeric5?: decimal | string;
        numeric6?: decimal | string;
        numeric7?: decimal | string;
        numeric8?: decimal | string;
        numeric9?: decimal | string;
        numeric10?: decimal | string;
        numeric11?: decimal | string;
        numeric12?: decimal | string;
        numeric13?: decimal | string;
        numeric14?: decimal | string;
        numeric15?: decimal | string;
        description?: string;
        shortDescription?: string;
        defaultValue?: boolean | string;
        dependency?: string;
        legislation?: string;
        activeFlag?: boolean | string;
        groupOfCompany?: string;
    }
    export interface MiscellaneousTableBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        glossaryId: MiscellaneousTables;
        code: string;
        alpha1: string;
        alpha2: string;
        alpha3: string;
        alpha4: string;
        alpha5: string;
        alpha6: string;
        alpha7: string;
        alpha8: string;
        alpha9: string;
        alpha10: string;
        alpha11: string;
        alpha12: string;
        alpha13: string;
        alpha14: string;
        alpha15: string;
        numeric1: string;
        numeric2: string;
        numeric3: string;
        numeric4: string;
        numeric5: string;
        numeric6: string;
        numeric7: string;
        numeric8: string;
        numeric9: string;
        numeric10: string;
        numeric11: string;
        numeric12: string;
        numeric13: string;
        numeric14: string;
        numeric15: string;
        description: string;
        shortDescription: string;
        defaultValue: boolean;
        dependency: MiscellaneousTable;
        legislation: MiscellaneousTable;
        activeFlag: boolean;
        groupOfCompany: SiteGroupings;
    }
    export interface MiscellaneousTableExtension$Lookups {
        groupOfCompany: QueryOperation<SiteGroupings>;
    }
    export interface MiscellaneousTableExtension$Operations {
        lookups(dataOrId: string | { data: MiscellaneousTableInput }): MiscellaneousTableExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-structure/Country': Country$Operations;
        '@sage/x3-structure/PostalCode': PostalCode$Operations;
        '@sage/x3-structure/SiteGroupings': SiteGroupings$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-structure-api' {
    export type * from '@sage/x3-structure-api-partial';
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-structure-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-structure-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-structure-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type {
        MiscellaneousTableBindingExtension,
        MiscellaneousTableExtension,
        MiscellaneousTableExtension$Lookups,
        MiscellaneousTableExtension$Operations,
        MiscellaneousTableInputExtension,
    } from '@sage/x3-structure-api';
    export interface MiscellaneousTable extends MiscellaneousTableExtension {}
    export interface MiscellaneousTableBinding extends MiscellaneousTableBindingExtension {}
    export interface MiscellaneousTableInput extends MiscellaneousTableInputExtension {}
    export interface MiscellaneousTable$Lookups extends MiscellaneousTableExtension$Lookups {}
    export interface MiscellaneousTable$Operations extends MiscellaneousTableExtension$Operations {}
}
