// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/index.d.ts
declare module '@sage/x3-stock/index' {
	export * from '@sage/x3-stock/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/index.d.ts
declare module '@sage/x3-stock/lib/index' {
	export * as enums from '@sage/x3-stock/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-stock/lib/node-extensions/index';
	export * as nodeFunctions from '@sage/x3-stock/lib/node-functions/index';
	export * as nodes from '@sage/x3-stock/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-stock/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/service-options/index.d.ts
declare module '@sage/x3-stock/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/storage.d.ts
declare module '@sage/x3-stock/lib/nodes/storage' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, decimal, integer, Reference, date } from '@sage/xtrem-core';
	export class Storage extends Node {
	    readonly stockId: Promise<decimal | null>;
	    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentNumber: Promise<string>;
	    readonly documentLineNumber: Promise<integer | null>;
	    readonly storageSite: Reference<sageX3System.nodes.Site>;
	    readonly originOfPutaway: Promise<sageX3StockData.enums.OriginOfPutAwayPlan | null>;
	    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly sourceDocumentNumber: Promise<string>;
	    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
	    readonly allocationDate: Promise<date | null>;
	    readonly status: Reference<sageX3StockData.nodes.StockStatus | null>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly activeQuantityInStockUnit: Promise<decimal | null>;
	    readonly putawayStatus: Promise<sageX3StockData.enums.PutAwayPlanSituation | null>;
	    readonly storageListNumber: Promise<string>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly storageListDate: Promise<date | null>;
	    readonly movementDescription: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly isQualityControlManagement: Promise<sageX3MasterData.enums.SubjectToControl | null>;
	    readonly qualityControlFrequency: Promise<integer | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	}
	//# sourceMappingURL=storage.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/storage-details.d.ts
declare module '@sage/x3-stock/lib/nodes/storage-details' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, decimal, integer, Reference, date, Context } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StorageDetails extends Node {
	    readonly stockId: Promise<decimal | null>;
	    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentNumber: Promise<string>;
	    readonly documentLineNumber: Promise<integer | null>;
	    readonly storageSequenceNumber: Promise<integer | null>;
	    readonly storageTWSSequenceNumber: Promise<integer | null>;
	    readonly storageSite: Reference<sageX3System.nodes.Site>;
	    readonly originSource: Promise<sageX3StockData.enums.OriginOfPutAwayPlan | null>;
	    readonly storageListNumber: Promise<string>;
	    readonly storageDetailsListDate: Promise<date | null>;
	    readonly supplierLot: Promise<string>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
	    readonly locationType: Promise<string>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly startingSerialNumber: Promise<string>;
	    readonly endingSerialNumber: Promise<string>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly expirationDate: Promise<date | null>;
	    readonly entryOkIndicator: Promise<integer | null>;
	    readonly lotSource: Promise<string>;
	    readonly potency: Promise<decimal | null>;
	    readonly internationalUnitPotency: Promise<decimal | null>;
	    readonly expirationReference: Promise<date | null>;
	    readonly shelfLife: Promise<integer | null>;
	    readonly lotUserArea1: Promise<string>;
	    readonly lotUserArea2: Promise<string>;
	    readonly lotUserArea3: Promise<decimal | null>;
	    readonly lotUserArea4: Promise<date | null>;
	    readonly activeQuantity: Promise<decimal | null>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly stockUserArea1: Promise<string>;
	    readonly stockUserArea2: Promise<string>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorVersion: Promise<string>;
	    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly storage: Reference<sageX3Stock.nodes.Storage | null>;
	    static processPutaway(context: Context, parameters: {
	        stockEntryTransaction: string;
	        storageSite: string;
	        stockId: decimal;
	        documentType: sageX3StockData.enums.EntryTypeEnum;
	        documentNumber: string;
	        documentLineNumber: number;
	        storageSequenceNumber: number;
	        quantityInPackingUnit: decimal;
	        lot: string;
	        sublot: string;
	        startingSerialNumber: string;
	        endingSerialNumber: string;
	        status: string;
	        container: string;
	        licensePlateNumber: string;
	        location: string;
	        locationType: string;
	        quantityInStockUnit: decimal;
	        labelDestination: string;
	    }): Promise<{
	        stockEntryTransaction: string;
	        storageSite: string;
	        stockId: decimal;
	        documentType: sageX3StockData.enums.EntryTypeEnum;
	        documentNumber: string;
	        documentLineNumber: number;
	        storageSequenceNumber: number;
	        quantityInPackingUnit: decimal;
	        lot: string;
	        sublot: string;
	        startingSerialNumber: string;
	        endingSerialNumber: string;
	        status: string;
	        container: string;
	        licensePlateNumber: string;
	        location: string;
	        locationType: string;
	        quantityInStockUnit: decimal;
	        labelDestination: string;
	    }>;
	}
	//# sourceMappingURL=storage-details.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-reorder.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-reorder' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, date, Context } from '@sage/xtrem-core';
	export class StockReorder extends Node {
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly destinationLocation: Promise<string>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly category: Promise<sageX3StockData.enums.LocationCategory | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentNumber: Promise<string>;
	    readonly documentLineNumber: Promise<integer | null>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly potencyDefault: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly activeQuantityInStockUnit: Promise<decimal | null>;
	    readonly requirementDate: Promise<date | null>;
	    readonly status: Promise<sageX3StockData.enums.ReorderSituation | null>;
	    readonly activeOriginalStockQuantity: Promise<decimal | null>;
	    readonly isClosed: Promise<boolean>;
	    readonly processingTime: Promise<string>;
	    readonly movementDescription: Promise<string>;
	    static processReorder(context: Context, parameters: {
	        stockEntryTransaction: string;
	        documentNumber: string;
	        documentLine: number;
	        stockSite: string;
	        destinationLocation: string;
	        source: number;
	        stockId: number;
	        stockSequence: number;
	        product: string;
	        fromLocation: string;
	        lot: string;
	        sublot: string;
	        serialNumber: string;
	        status: string;
	        identifier1: string;
	        identifier2: string;
	        licensePlateNumber: string;
	        packingUnit: string;
	        packingUnitToStockUnitConversionFactor: decimal;
	        packingQuantity: decimal;
	    }): Promise<{
	        stockEntryTransaction: string;
	        documentNumber: string;
	        documentLine: number;
	        stockSite: string;
	        destinationLocation: string;
	        source: number;
	        stockId: number;
	        stockSequence: number;
	        product: string;
	        fromLocation: string;
	        lot: string;
	        sublot: string;
	        serialNumber: string;
	        status: string;
	        identifier1: string;
	        identifier2: string;
	        licensePlateNumber: string;
	        packingUnit: string;
	        packingUnitToStockUnitConversionFactor: decimal;
	        packingQuantity: decimal;
	    }>;
	}
	//# sourceMappingURL=stock-reorder.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-entry-transaction.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-entry-transaction' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3Structure from '@sage/x3-structure';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class StockEntryTransaction extends Node {
	    readonly transactionType: Promise<sageX3StockData.enums.TypeOfStockTransaction | null>;
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly document: Reference<sageX3System.nodes.GenericPrintReport | null>;
	    readonly isAutomaticallyPrinted: Promise<boolean>;
	    readonly defaultStockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly supplierLot: Promise<sageX3System.enums.EntryMode | null>;
	    readonly identifier1Detail: Promise<sageX3System.enums.EntryMode | null>;
	    readonly identifier2Detail: Promise<sageX3System.enums.EntryMode | null>;
	    readonly printingMode: Promise<sageX3StockData.enums.LabelPrinting | null>;
	    readonly isLotExpirationDateAllowed: Promise<boolean>;
	    readonly isLotPotencyAllowed: Promise<boolean>;
	    readonly isLotCustomField1Allowed: Promise<boolean>;
	    readonly isLotCustomField2Allowed: Promise<boolean>;
	    readonly isLotCustomField3Allowed: Promise<boolean>;
	    readonly isLotCustomField4Allowed: Promise<boolean>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly isActive: Promise<boolean>;
	    readonly companyOrSiteGroup: Reference<sageX3Structure.nodes.SiteGroupings | null>;
	    readonly isAutomaticDetermination: Promise<boolean>;
	    readonly stockChangeDestination: Promise<sageX3StockData.enums.DestinationChoice | null>;
	    readonly isLocationChange: Promise<boolean>;
	    readonly isStatusChange: Promise<boolean>;
	    readonly isUnitChange: Promise<boolean>;
	    readonly ischangeInMass: Promise<boolean>;
	    readonly preloadedQuantity: Promise<sageX3StockData.enums.QtyPreCharged | null>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly identifier1Destination: Promise<sageX3System.enums.EntryMode | null>;
	    readonly identifier2Destination: Promise<sageX3System.enums.EntryMode | null>;
	    readonly isLocationReplenishable: Promise<boolean>;
	    readonly isConsumptionArea: Promise<boolean>;
	    readonly isShortages: Promise<boolean>;
	    readonly identifier1Entry: Promise<sageX3System.enums.EntryMode | null>;
	    readonly identifier2Entry: Promise<sageX3System.enums.EntryMode | null>;
	    readonly isEnterableDestinationLocation: Promise<boolean>;
	    readonly isEnterableDestinationWarehouse: Promise<boolean>;
	    readonly stockChangeAccessMode: Promise<sageX3StockData.enums.StockChangeAccess | null>;
	}
	//# sourceMappingURL=stock-entry-transaction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-count-session.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-count-session' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, date, integer, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockCountSession extends Node {
	    readonly stockCountSession: Promise<string>;
	    readonly stockCountSessionDescription: Promise<string>;
	    readonly stockCountSessionType: Promise<sageX3StockData.enums.StockCountType | null>;
	    readonly stockCountSessionMode: Promise<sageX3StockData.enums.StockCountListChoice | null>;
	    readonly stockCountSessionStatus: Promise<sageX3StockData.enums.StockCountSessionStatus | null>;
	    readonly stockCountDate: Promise<date | null>;
	    readonly stockCountSortCode: Promise<sageX3StockData.enums.StockTakeSequence | null>;
	    readonly isGlobal: Promise<boolean>;
	    readonly maximumNumberOfLines: Promise<integer | null>;
	    readonly maximumPercentLimit: Promise<integer | null>;
	    readonly numberOfProducts: Promise<integer | null>;
	    readonly numberOfPositionsInLocationCode: Promise<integer | null>;
	    readonly productFormula: Promise<string>;
	    readonly fromProduct: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly toProduct: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly isNonUsableProductSelected: Promise<boolean>;
	    readonly fromLocationType: Promise<string>;
	    readonly toLocationType: Promise<string>;
	    readonly fromLocation: Reference<sageX3StockData.nodes.Location | null>;
	    readonly toLocation: Reference<sageX3StockData.nodes.Location | null>;
	    readonly fromCategory: Reference<sageX3MasterData.nodes.ProductCategory | null>;
	    readonly toCategory: Reference<sageX3MasterData.nodes.ProductCategory | null>;
	    readonly fromBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly toBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly fromBuyer: Reference<sageX3System.nodes.User | null>;
	    readonly toBuyer: Reference<sageX3System.nodes.User | null>;
	    readonly fromLot: Promise<string>;
	    readonly toLot: Promise<string>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly stockCycleCountClassA: Promise<boolean>;
	    readonly numberOfProductsSelectedInClassA: Promise<integer | null>;
	    readonly numberOfCountsInClassA: Promise<integer | null>;
	    readonly stockCycleCountClassB: Promise<boolean>;
	    readonly numberOfProductsSelectedInClassB: Promise<integer | null>;
	    readonly numberOfCountsInClassB: Promise<integer | null>;
	    readonly stockCycleCountClassC: Promise<boolean>;
	    readonly numberOfProductsSelectedInClassC: Promise<integer | null>;
	    readonly numberOfCountsInClassC: Promise<integer | null>;
	    readonly stockCycleCountClassD: Promise<boolean>;
	    readonly numberOfProductsSelectedInClassD: Promise<integer | null>;
	    readonly numberOfCountsInClassD: Promise<integer | null>;
	    readonly isReceiptLocation: Promise<boolean>;
	    readonly isStorageLocation: Promise<boolean>;
	    readonly isPickingLocation: Promise<boolean>;
	    readonly isWorkStationLocation: Promise<boolean>;
	    readonly isDockLocation: Promise<boolean>;
	    readonly isShopLocation: Promise<boolean>;
	    readonly isReturnLocation: Promise<boolean>;
	    readonly productsWithZeroStock: Promise<boolean>;
	    readonly isMultilist: Promise<boolean>;
	    readonly productFormula2: Promise<string>;
	    readonly stockFormula: Promise<string>;
	    readonly locationFormula: Promise<string>;
	    readonly warehouseFormula: Promise<string>;
	    readonly productWarehouseFormula: Promise<string>;
	    readonly fromWarehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly toWarehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly productWarehouse: Promise<boolean>;
	    readonly isMultipleCount: Promise<boolean>;
	    readonly fromStatisticalGroups: Collection<sageX3Stock.nodes.StockCountSessionFromStatisticalGroups>;
	    readonly toStatisticalGroups: Collection<sageX3Stock.nodes.StockCountSessionToStatisticalGroups>;
	}
	//# sourceMappingURL=stock-count-session.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-count-session-to-statistical-groups.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-count-session-to-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockCountSessionToStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockCountSession: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Stock.nodes.StockCountSession>;
	    readonly toStatisticalGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=stock-count-session-to-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-count-session-from-statistical-groups.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-count-session-from-statistical-groups' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockCountSessionFromStatisticalGroups extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockCountSession: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Stock.nodes.StockCountSession>;
	    readonly fromStatisticalGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=stock-count-session-from-statistical-groups.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-count-serial-number.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-count-serial-number' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockCountSerialNumber extends Node {
	    readonly stockCountSessionNumber: Promise<string>;
	    readonly stockCountListNumber: Reference<sageX3Stock.nodes.StockCountList | null>;
	    readonly serialNumberSequenceNumber: Promise<integer | null>;
	    readonly serialNumberIndexNumber: Promise<integer | null>;
	    readonly startingSerialNumber: Promise<string>;
	    readonly endingSerialNumber: Promise<string>;
	    readonly quantity: Promise<integer | null>;
	    readonly stockCountVariance: Promise<string>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	}
	//# sourceMappingURL=stock-count-serial-number.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-count-list.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-count-list' {
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, date, Reference, integer } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockCountList extends Node {
	    readonly stockCountSessionNumber: Promise<string>;
	    readonly stockCountListNumber: Promise<string>;
	    readonly stockCountListDescription: Promise<string>;
	    readonly stockCountDate: Promise<date | null>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly stockCountListStatus: Promise<sageX3StockData.enums.StockCountStatusList | null>;
	    readonly stockCountListStatusDate: Promise<date | null>;
	    readonly isStockCountLocked: Promise<sageX3StockData.enums.BlockedStock | null>;
	    readonly numberOfLines: Promise<integer | null>;
	    readonly stockCountOperator: Promise<string>;
	    readonly allocationDate: Promise<date | null>;
	    readonly movementDescription: Promise<string>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly lastAllocationDate: Promise<date | null>;
	    readonly stockCountSession: Reference<sageX3Stock.nodes.StockCountSession | null>;
	}
	//# sourceMappingURL=stock-count-list.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-count-list-detail.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-count-list-detail' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection, Context } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockCountListDetail extends Node {
	    readonly stockCountSessionNumber: Promise<string>;
	    readonly stockCountList: Reference<sageX3Stock.nodes.StockCountList | null>;
	    readonly productRankNumber: Promise<integer | null>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly owner: Promise<string>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly status: Promise<string>;
	    readonly abcClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
	    readonly stockCountDate: Promise<date | null>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly countedStockInPackingUnit: Promise<decimal | null>;
	    readonly countedStockInStockUnit: Promise<decimal | null>;
	    readonly isZeroStock: Promise<boolean>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly isOriginOfLineNote: Promise<sageX3StockData.enums.EnteredStockLineStatus | null>;
	    readonly stockId: Promise<decimal | null>;
	    readonly stockCountCostCode: Promise<sageX3StockData.enums.CostSource | null>;
	    readonly stockCountUnitCost: Promise<decimal | null>;
	    readonly stockCountNetCost: Promise<decimal | null>;
	    readonly allocationDate: Promise<date | null>;
	    readonly serialNumber: Promise<string>;
	    readonly isStockCountLocked: Promise<sageX3StockData.enums.BlockedStock | null>;
	    readonly stockCountListStatus: Promise<sageX3StockData.enums.StockCountDetailStatus | null>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly qualityAnalysisRequestId: Promise<string>;
	    readonly orderPrice: Promise<decimal | null>;
	    readonly potency: Promise<decimal | null>;
	    readonly expirationReferenceDate: Promise<date | null>;
	    readonly expirationDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly recontrolDate: Promise<date | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorVersion: Promise<string>;
	    readonly stockUserArea1: Promise<string>;
	    readonly stockUserArea2: Promise<string>;
	    readonly countedStockInPackingUnit1: Promise<decimal | null>;
	    readonly countedStockInStockUnit1: Promise<decimal | null>;
	    readonly isZeroStock1: Promise<boolean>;
	    readonly countedStockInPackingUnit2: Promise<decimal | null>;
	    readonly countedStockInStockUnit2: Promise<decimal | null>;
	    readonly isZeroStock2: Promise<boolean>;
	    readonly serialNumberSequenceNumber: Promise<integer | null>;
	    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly serialNumberLines: Collection<sageX3Stock.nodes.StockCountSerialNumber>;
	    readonly stockCountSession: Reference<sageX3Stock.nodes.StockCountSession | null>;
	    readonly stockLine: Reference<sageX3StockData.nodes.Stock | null>;
	    static processCount(context: Context, parameters: {
	        stockCountSessionNumber: string;
	        stockCountListNumber: string;
	        productRankNumber: number;
	        product: string;
	        licensePlateNumber: string;
	        location: string;
	        lot: string;
	        sublot: string;
	        serialNumber: string;
	        status: string;
	        majorVersion: string;
	        minorVersion: string;
	        packingUnit: string;
	        countedStockInPackingUnit: decimal;
	        packingUnitToStockUnitConversionFactor: decimal;
	        multiCountNumber: number;
	        serialNumberQuantity: decimal[];
	        startingSerialNumber: string[];
	        endingSerialNumber: string[];
	        serialNumberVariance: string[];
	    }): Promise<{
	        stockCountSessionNumber: string;
	        stockCountListNumber: string;
	    }>;
	    static renumberCountList(context: Context, parameters: {
	        stockCountSessionNumber: string;
	        stockCountListNumber: string;
	    }): Promise<{
	        stockCountSessionNumber: string;
	        stockCountListNumber: string;
	    }>;
	}
	//# sourceMappingURL=stock-count-list-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-change.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-change' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, Collection, Context } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockChange extends Node {
	    readonly id: Promise<string>;
	    readonly stockChangeDestination: Promise<sageX3StockData.enums.DestinationChoice | null>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly stockSiteDestination: Reference<sageX3System.nodes.Site | null>;
	    readonly purchaseSite: Reference<sageX3System.nodes.Site | null>;
	    readonly salesSite: Reference<sageX3System.nodes.Site | null>;
	    readonly receiptStockSiteAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly subcontractor: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly subcontractorAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly subcontractLocation: Reference<sageX3StockData.nodes.Location | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly customerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly mustBeInvoiced: Promise<boolean>;
	    readonly isInvoiced: Promise<boolean>;
	    readonly salesInvoiceNumber: Promise<string>;
	    readonly effectiveDate: Promise<date | null>;
	    readonly documentDescription: Promise<string>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly importLine: Promise<integer | null>;
	    readonly isSigned: Promise<boolean>;
	    readonly transportDocumentType: Promise<string>;
	    readonly temporaryDocumentId: Promise<string>;
	    readonly manualDocument: Promise<string>;
	    readonly atCode: Promise<string>;
	    readonly departureDate: Promise<date | null>;
	    readonly departureTime: Promise<string>;
	    readonly arrivalDate: Promise<date | null>;
	    readonly arrivalTime: Promise<string>;
	    readonly registration: Promise<string>;
	    readonly trailerRegistration: Promise<string>;
	    readonly licensePlateNumberOperationMode: Promise<integer | null>;
	    readonly stockChangeByLicencePlateNumberOrigin: Promise<integer | null>;
	    readonly licensePlateNumberDestination: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly locationDestination: Promise<string>;
	    readonly stockChangeLines: Collection<sageX3Stock.nodes.StockChangeLine>;
	    readonly destination: Promise<string>;
	    readonly printingMode: Promise<string>;
	    readonly transaction: Promise<string>;
	    static intersiteTransfer(context: Context, parameter: StockChange): Promise<StockChange>;
	    static stockChange(context: Context, parameter: StockChange): Promise<StockChange>;
	    static subcontractTransfer(context: Context, parameter: StockChange): Promise<StockChange>;
	}
	//# sourceMappingURL=stock-change.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-change-line.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-change-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockChangeLine extends Node {
	    readonly stockChangeId: Promise<string>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescription: Promise<string>;
	    readonly owner: Promise<string>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
	    readonly locationType: Promise<string>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly serialNumber: Promise<string>;
	    readonly endingSerialNumber: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly qualityAnalysisRequestId: Promise<string>;
	    readonly packingUnitDestination: Promise<string>;
	    readonly quantityInPackingUnitDestination: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactorDestination: Promise<decimal | null>;
	    readonly quantityInStockUnitDestination: Promise<decimal | null>;
	    readonly isQualityAnalysisRequested: Promise<boolean>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly importLine: Promise<integer | null>;
	    readonly stockCustomField1: Promise<string>;
	    readonly stockCustomField2: Promise<string>;
	    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly stockChange: Reference<sageX3Stock.nodes.StockChange>;
	    readonly stockDetails: Collection<sageX3StockData.nodes.StockJournal>;
	    readonly identifier1Destination: Promise<string>;
	    readonly identifier2Destination: Promise<string>;
	    readonly licensePlateNumberDestination: Promise<string>;
	    readonly locationDestination: Promise<string>;
	    readonly movementDescription: Promise<string>;
	    readonly statusDestination: Promise<string>;
	    readonly stockId: Promise<decimal | null>;
	    readonly stockSite: Promise<string>;
	}
	//# sourceMappingURL=stock-change-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-change-line-by-lpn.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-change-line-by-lpn' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockChangeLineByLpn extends Node {
	    readonly stockChangeId: Promise<string>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescription: Promise<string>;
	    readonly owner: Promise<string>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
	    readonly locationType: Promise<string>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly serialNumber: Promise<string>;
	    readonly endingSerialNumber: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly qualityAnalysisRequestId: Promise<string>;
	    readonly packingUnitDestination: Promise<string>;
	    readonly quantityInPackingUnitDestination: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactorDestination: Promise<decimal | null>;
	    readonly quantityInStockUnitDestination: Promise<decimal | null>;
	    readonly isQualityAnalysisRequested: Promise<boolean>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly importLine: Promise<integer | null>;
	    readonly stockCustomField1: Promise<string>;
	    readonly stockCustomField2: Promise<string>;
	    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly stockChangeByLpn: Reference<sageX3Stock.nodes.StockChangeByLpn>;
	    readonly stockDetails: Collection<sageX3StockData.nodes.StockJournal>;
	    readonly stockId: Promise<string>;
	    readonly stockSite: Promise<string>;
	}
	//# sourceMappingURL=stock-change-line-by-lpn.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/stock-change-by-lpn.d.ts
declare module '@sage/x3-stock/lib/nodes/stock-change-by-lpn' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, Collection, Context } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class StockChangeByLpn extends Node {
	    readonly id: Promise<string>;
	    readonly stockChangeDestination: Promise<sageX3StockData.enums.DestinationChoice | null>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly stockSiteDestination: Reference<sageX3System.nodes.Site | null>;
	    readonly purchaseSite: Reference<sageX3System.nodes.Site | null>;
	    readonly salesSite: Reference<sageX3System.nodes.Site | null>;
	    readonly receiptStockSiteAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly subcontractor: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly subcontractorAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly subcontractLocation: Reference<sageX3StockData.nodes.Location | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly customerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly mustBeInvoiced: Promise<boolean>;
	    readonly isInvoiced: Promise<boolean>;
	    readonly salesInvoiceNumber: Promise<string>;
	    readonly effectiveDate: Promise<date | null>;
	    readonly documentDescription: Promise<string>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly importLine: Promise<integer | null>;
	    readonly isSigned: Promise<boolean>;
	    readonly transportDocumentType: Promise<string>;
	    readonly temporaryDocumentId: Promise<string>;
	    readonly manualDocument: Promise<string>;
	    readonly atCode: Promise<string>;
	    readonly departureDate: Promise<date | null>;
	    readonly departureTime: Promise<string>;
	    readonly arrivalDate: Promise<date | null>;
	    readonly arrivalTime: Promise<string>;
	    readonly registration: Promise<string>;
	    readonly trailerRegistration: Promise<string>;
	    readonly licensePlateNumberOperationMode: Promise<integer | null>;
	    readonly stockChangeByLicencePlateNumberOrigin: Promise<integer | null>;
	    readonly licensePlateNumberDestination: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly locationDestination: Promise<string>;
	    readonly stockChangeLines: Collection<sageX3Stock.nodes.StockChangeLineByLpn>;
	    readonly destination: Promise<string>;
	    readonly transaction: Promise<string>;
	    static lpnGrouping(context: Context, parameter: StockChangeByLpn): Promise<StockChangeByLpn>;
	    static stockChangeByLpn(context: Context, parameter: StockChangeByLpn): Promise<StockChangeByLpn>;
	}
	//# sourceMappingURL=stock-change-by-lpn.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/pick-ticket.d.ts
declare module '@sage/x3-stock/lib/nodes/pick-ticket' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class PickTicket extends Node {
	    readonly id: Promise<string>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly sourcePickTicket: Promise<sageX3StockData.enums.PickingNoteSource | null>;
	    readonly pickListNumber: Promise<string>;
	    readonly salesDelivery: Promise<string>;
	    readonly deliveryType: Reference<sageX3SalesData.nodes.SalesDeliveryType | null>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress | null>;
	    readonly shipmentDate: Promise<date>;
	    readonly deliveryDate: Promise<date | null>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
	    readonly preparationCode: Promise<string>;
	    readonly pickTicketStatus: Promise<sageX3StockData.enums.PickingNoteStatus | null>;
	    readonly isPacked: Promise<boolean>;
	    readonly numberOfPackages: Promise<integer | null>;
	    readonly isPickTicketPrinted: Promise<boolean>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly grossWeight: Promise<decimal | null>;
	    readonly netWeight: Promise<decimal | null>;
	    readonly pickTicketHeaderText: Promise<string>;
	    readonly pickTicketFooterText: Promise<string>;
	    readonly picker: Reference<sageX3System.nodes.User | null>;
	    readonly pickTicketLines: Collection<sageX3Stock.nodes.PickTicketLine>;
	}
	//# sourceMappingURL=pick-ticket.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/pick-ticket-line.d.ts
declare module '@sage/x3-stock/lib/nodes/pick-ticket-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference, decimal, Collection, Context, DateValue } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class PickTicketLine extends Node {
	    readonly pickTicket: Promise<string>;
	    readonly pickTicketLine: Promise<integer | null>;
	    readonly sourcePickTicketType: Promise<sageX3StockData.enums.PreparationSource | null>;
	    readonly sourcePickTicket: Promise<string>;
	    readonly sourcePickTicketLine: Promise<integer | null>;
	    readonly sourcePickTicketSequenceNumber: Promise<integer | null>;
	    readonly sourcePickTicketSubcontractType: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescription: Promise<string>;
	    readonly subcontractReorderLocation: Promise<string>;
	    readonly allocationSequence: Promise<integer | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly packedQuantityInStockUnit: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly allocatedQuantity: Promise<decimal | null>;
	    readonly shortageQuantity: Promise<decimal | null>;
	    readonly allocationType: Promise<sageX3MasterData.enums.TypeOfAllocation | null>;
	    readonly quantityAllocatedOnSalesOrderInStockUnit: Promise<decimal | null>;
	    readonly stockManagementMode: Promise<sageX3MasterData.enums.StockManagement | null>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly destinationLocation: Promise<string>;
	    readonly destinationLocationType: Promise<string>;
	    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
	    readonly packagingCapacity: Promise<decimal | null>;
	    readonly pickTicketLineText: Promise<string>;
	    readonly adcPickedLine: Promise<integer | null>;
	    readonly canceledLine: Promise<integer | null>;
	    readonly isPacked: Promise<boolean>;
	    readonly allocatedLines: Collection<sageX3Stock.nodes.Allocation>;
	    static updatePickTicketLine(context: Context, parameters: {
	        entryTransaction: string;
	        pickTicket: string;
	        pickTicketLine: number;
	        destinationLocation: string;
	        product: string;
	        shortPick: boolean;
	        deliverable: boolean;
	        documentDestination: string;
	        packingUnit: string[];
	        packingUnitToStockUnitConversionFactor: decimal[];
	        quantityInPackingUnit: decimal[];
	        quantityInStockUnit: decimal[];
	        location: string[];
	        lot: string[];
	        sublot: string[];
	        serialNumber: string[];
	        status: string[];
	        stockId: number[];
	        customBoolean: boolean;
	        customDecimal: decimal;
	        customString: string;
	        customDate: DateValue;
	    }): Promise<{
	        pickTicket: string;
	        pickTicketLine: number;
	    }>;
	}
	//# sourceMappingURL=pick-ticket-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/pick-list.d.ts
declare module '@sage/x3-stock/lib/nodes/pick-list' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, date, decimal } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class PickList extends Node {
	    readonly preparationList: Promise<string>;
	    readonly preparationListSequenceNumber: Promise<integer | null>;
	    readonly pickTicket: Reference<sageX3Stock.nodes.PickTicket | null>;
	    readonly pickTicketLine: Reference<sageX3Stock.nodes.PickTicketLine | null>;
	    readonly sourcePickTicketType: Promise<sageX3StockData.enums.PreparationSource | null>;
	    readonly sourcePickTicket: Promise<string>;
	    readonly sourcePickTicketLine: Promise<integer | null>;
	    readonly sourcePickTicketSequenceNumber: Promise<integer | null>;
	    readonly lineType: Promise<sageX3SalesData.enums.LineType | null>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly subcontractReorderLocation: Promise<string>;
	    readonly allocationSequence: Promise<integer | null>;
	    readonly requirementDate: Promise<date | null>;
	    readonly deliveryDate: Promise<date | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly deliveryAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
	    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
	    readonly packagingCapacity: Promise<decimal | null>;
	    readonly picker: Reference<sageX3System.nodes.User | null>;
	    readonly isPacked: Promise<boolean>;
	}
	//# sourceMappingURL=pick-list.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/miscellaneous-receipt.d.ts
declare module '@sage/x3-stock/lib/nodes/miscellaneous-receipt' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class MiscellaneousReceipt extends Node {
	    readonly entryType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly id: Promise<string>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly effectiveDate: Promise<date | null>;
	    readonly documentDescription: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly sourceDocumentId: Promise<string>;
	    readonly isDisassembly: Promise<boolean>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly disassemblyValue: Promise<decimal | null>;
	    readonly miscellaneousReceiptLines: Collection<sageX3Stock.nodes.MiscellaneousReceiptLine>;
	    readonly destination: Promise<string>;
	    readonly transaction: Promise<string>;
	    readonly dimensions: Collection<sageX3Stock.nodes.MiscellaneousReceiptDimensions>;
	}
	//# sourceMappingURL=miscellaneous-receipt.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/miscellaneous-receipt-line.d.ts
declare module '@sage/x3-stock/lib/nodes/miscellaneous-receipt-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class MiscellaneousReceiptLine extends Node {
	    readonly entryType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly id: Promise<string>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescription: Promise<string>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly price: Promise<decimal | null>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorVersion: Promise<string>;
	    readonly miscellaneousReceipt: Reference<sageX3Stock.nodes.MiscellaneousReceipt>;
	    readonly stockDetails: Collection<sageX3StockData.nodes.StockJournal>;
	    readonly container: Promise<string>;
	}
	//# sourceMappingURL=miscellaneous-receipt-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/miscellaneous-receipt-dimensions.d.ts
declare module '@sage/x3-stock/lib/nodes/miscellaneous-receipt-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class MiscellaneousReceiptDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entryType: Promise<sageX3StockData.enums.EntryTypeEnum>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Stock.nodes.MiscellaneousReceipt>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=miscellaneous-receipt-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/miscellaneous-issue.d.ts
declare module '@sage/x3-stock/lib/nodes/miscellaneous-issue' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class MiscellaneousIssue extends Node {
	    readonly entryType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly id: Promise<string>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly effectiveDate: Promise<date | null>;
	    readonly documentDescription: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly sourceDocumentId: Promise<string>;
	    readonly isDisassembly: Promise<boolean>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly disassemblyValue: Promise<decimal | null>;
	    readonly miscellaneousIssueLines: Collection<sageX3Stock.nodes.MiscellaneousIssueLine>;
	    readonly destination: Promise<string>;
	    readonly transaction: Promise<string>;
	    readonly dimensions: Collection<sageX3Stock.nodes.MiscellaneousIssueDimensions>;
	}
	//# sourceMappingURL=miscellaneous-issue.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/miscellaneous-issue-line.d.ts
declare module '@sage/x3-stock/lib/nodes/miscellaneous-issue-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class MiscellaneousIssueLine extends Node {
	    readonly entryType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly id: Promise<string>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescription: Promise<string>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly price: Promise<decimal | null>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorVersion: Promise<string>;
	    readonly miscellaneousIssue: Reference<sageX3Stock.nodes.MiscellaneousIssue>;
	    readonly stockDetails: Collection<sageX3StockData.nodes.StockJournal>;
	    readonly container: Promise<string>;
	}
	//# sourceMappingURL=miscellaneous-issue-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/miscellaneous-issue-dimensions.d.ts
declare module '@sage/x3-stock/lib/nodes/miscellaneous-issue-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class MiscellaneousIssueDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly entryType: Promise<sageX3StockData.enums.EntryTypeEnum>;
	    readonly id: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Stock.nodes.MiscellaneousIssue>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=miscellaneous-issue-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/lpn-operations.d.ts
declare module '@sage/x3-stock/lib/nodes/lpn-operations' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, Collection, Context } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class LpnOperations extends Node {
	    readonly id: Promise<string>;
	    readonly stockChangeDestination: Promise<sageX3StockData.enums.DestinationChoice | null>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly stockSiteDestination: Reference<sageX3System.nodes.Site | null>;
	    readonly purchaseSite: Reference<sageX3System.nodes.Site | null>;
	    readonly salesSite: Reference<sageX3System.nodes.Site | null>;
	    readonly receiptStockSiteAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly subcontractor: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly subcontractorAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly subcontractLocation: Reference<sageX3StockData.nodes.Location | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly customerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly isIntercompany: Promise<boolean>;
	    readonly mustBeInvoiced: Promise<boolean>;
	    readonly isInvoiced: Promise<boolean>;
	    readonly salesInvoiceNumber: Promise<string>;
	    readonly effectiveDate: Promise<date | null>;
	    readonly documentDescription: Promise<string>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
	    readonly importLine: Promise<integer | null>;
	    readonly isSigned: Promise<boolean>;
	    readonly transportDocumentType: Promise<string>;
	    readonly temporaryDocumentId: Promise<string>;
	    readonly manualDocument: Promise<string>;
	    readonly atCode: Promise<string>;
	    readonly departureDate: Promise<date | null>;
	    readonly departureTime: Promise<string>;
	    readonly arrivalDate: Promise<date | null>;
	    readonly arrivalTime: Promise<string>;
	    readonly registration: Promise<string>;
	    readonly trailerRegistration: Promise<string>;
	    readonly licensePlateNumberOperationMode: Promise<integer | null>;
	    readonly stockChangeByLicencePlateNumberOrigin: Promise<integer | null>;
	    readonly licensePlateNumberDestination: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly locationDestination: Promise<string>;
	    readonly stockChangeLines: Collection<sageX3Stock.nodes.LpnOperationsLine>;
	    static lpnOperations(context: Context, parameter: LpnOperations): Promise<LpnOperations>;
	}
	//# sourceMappingURL=lpn-operations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/lpn-operations-line.d.ts
declare module '@sage/x3-stock/lib/nodes/lpn-operations-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class LpnOperationsLine extends Node {
	    readonly stockChangeId: Promise<string>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescription: Promise<string>;
	    readonly owner: Promise<string>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
	    readonly locationType: Promise<string>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly serialNumber: Promise<string>;
	    readonly endingSerialNumber: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly qualityAnalysisRequestId: Promise<string>;
	    readonly packingUnitDestination: Promise<string>;
	    readonly quantityInPackingUnitDestination: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactorDestination: Promise<decimal | null>;
	    readonly quantityInStockUnitDestination: Promise<decimal | null>;
	    readonly isQualityAnalysisRequested: Promise<boolean>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly importLine: Promise<integer | null>;
	    readonly stockCustomField1: Promise<string>;
	    readonly stockCustomField2: Promise<string>;
	    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly lpnOperations: Reference<sageX3Stock.nodes.LpnOperations>;
	    readonly stockDetails: Collection<sageX3StockData.nodes.StockJournal>;
	    readonly stockId: Promise<string>;
	    readonly stockSite: Promise<string>;
	}
	//# sourceMappingURL=lpn-operations-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/index.d.ts
declare module '@sage/x3-stock/lib/nodes/index' {
	export * from '@sage/x3-stock/lib/nodes/allocation';
	export * from '@sage/x3-stock/lib/nodes/lpn-operations-line';
	export * from '@sage/x3-stock/lib/nodes/lpn-operations';
	export * from '@sage/x3-stock/lib/nodes/miscellaneous-issue-dimensions';
	export * from '@sage/x3-stock/lib/nodes/miscellaneous-issue-line';
	export * from '@sage/x3-stock/lib/nodes/miscellaneous-issue';
	export * from '@sage/x3-stock/lib/nodes/miscellaneous-receipt-dimensions';
	export * from '@sage/x3-stock/lib/nodes/miscellaneous-receipt-line';
	export * from '@sage/x3-stock/lib/nodes/miscellaneous-receipt';
	export * from '@sage/x3-stock/lib/nodes/pick-list';
	export * from '@sage/x3-stock/lib/nodes/pick-ticket-line';
	export * from '@sage/x3-stock/lib/nodes/pick-ticket';
	export * from '@sage/x3-stock/lib/nodes/stock-change-by-lpn';
	export * from '@sage/x3-stock/lib/nodes/stock-change-line-by-lpn';
	export * from '@sage/x3-stock/lib/nodes/stock-change-line';
	export * from '@sage/x3-stock/lib/nodes/stock-change';
	export * from '@sage/x3-stock/lib/nodes/stock-count-list-detail';
	export * from '@sage/x3-stock/lib/nodes/stock-count-list';
	export * from '@sage/x3-stock/lib/nodes/stock-count-serial-number';
	export * from '@sage/x3-stock/lib/nodes/stock-count-session-from-statistical-groups';
	export * from '@sage/x3-stock/lib/nodes/stock-count-session-to-statistical-groups';
	export * from '@sage/x3-stock/lib/nodes/stock-count-session';
	export * from '@sage/x3-stock/lib/nodes/stock-entry-transaction';
	export * from '@sage/x3-stock/lib/nodes/stock-reorder';
	export * from '@sage/x3-stock/lib/nodes/storage-details';
	export * from '@sage/x3-stock/lib/nodes/storage';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/nodes/allocation.d.ts
declare module '@sage/x3-stock/lib/nodes/allocation' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, integer, date, Collection } from '@sage/xtrem-core';
	import * as sageX3Stock from '@sage/x3-stock/lib/index';
	export class Allocation extends Node {
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly stockId: Promise<decimal | null>;
	    readonly sequenceNumber: Promise<integer | null>;
	    readonly allocationEndDate: Promise<date | null>;
	    readonly allocationType: Promise<sageX3MasterData.enums.TypeOfAllocation | null>;
	    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentNumber: Promise<string>;
	    readonly documentLineNumber: Promise<integer | null>;
	    readonly documentSequenceNumber: Promise<integer | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly activeQuantityInStockUnit: Promise<decimal | null>;
	    readonly warehouse: Promise<string>;
	    readonly location: Promise<string>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly status: Promise<string>;
	    readonly serialNumber: Promise<string>;
	    readonly consumptionLocation: Promise<string>;
	    readonly defaultWarehouse: Promise<string>;
	    readonly defaultLocation: Promise<string>;
	    readonly defaultLocationType: Promise<string>;
	    readonly storageQuantityInStockUnit: Promise<decimal | null>;
	    readonly storageListNumber: Promise<string>;
	    readonly storageListLineNumber: Promise<integer | null>;
	    readonly pickingNumber: Promise<string>;
	    readonly requirementDate: Promise<date | null>;
	    readonly transactionDescription: Promise<string>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly deliveryAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress | null>;
	    readonly typeOfSupply: Promise<sageX3MasterData.enums.MaterialReplenishType | null>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly stockLine: Reference<sageX3StockData.nodes.Stock | null>;
	    readonly reorderLine: Collection<sageX3Stock.nodes.StockReorder>;
	}
	//# sourceMappingURL=allocation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/node-functions/product-site-functions.d.ts
declare module '@sage/x3-stock/lib/node-functions/product-site-functions' {
	import * as x3MasterData from '@sage/x3-master-data';
	import { decimal, ExtensionMembers } from '@sage/xtrem-core';
	import * as x3Stock from '@sage/x3-stock/lib/index';
	export function getCountOfStockRecords(productSite: ExtensionMembers<x3Stock.nodeExtensions.ProductSiteExtension & x3MasterData.nodes.ProductSite>): Promise<number>;
	export function getDistinctCountOfStockQuantity(productSite: ExtensionMembers<x3Stock.nodeExtensions.ProductSiteExtension & x3MasterData.nodes.ProductSite>): Promise<decimal>;
	export function getDistinctCountOfLocations(productSite: ExtensionMembers<x3Stock.nodeExtensions.ProductSiteExtension & x3MasterData.nodes.ProductSite>): Promise<number>;
	export function getDistinctCountOfLots(productSite: ExtensionMembers<x3Stock.nodeExtensions.ProductSiteExtension & x3MasterData.nodes.ProductSite>): Promise<number>;
	export function getDistinctCountOfSublots(productSite: ExtensionMembers<x3Stock.nodeExtensions.ProductSiteExtension & x3MasterData.nodes.ProductSite>): Promise<number>;
	export function getStockUnitCode(productSite: ExtensionMembers<x3Stock.nodeExtensions.ProductSiteExtension & x3MasterData.nodes.ProductSite>): Promise<string>;
	//# sourceMappingURL=product-site-functions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/node-functions/index.d.ts
declare module '@sage/x3-stock/lib/node-functions/index' {
	export * from '@sage/x3-stock/lib/node-functions/product-site-functions';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/node-extensions/ship-to-customer-address-extension.d.ts
declare module '@sage/x3-stock/lib/node-extensions/ship-to-customer-address-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	export class ShipToCustomerAddressExtension extends NodeExtension<sageX3MasterData.nodes.ShipToCustomerAddress> {
	    readonly loanLocation: Reference<sageX3StockData.nodes.Location | null>;
	    readonly subcontractLocation: Reference<sageX3StockData.nodes.Location | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/ship-to-customer-address' {
	    interface ShipToCustomerAddress extends ShipToCustomerAddressExtension {
	    }
	}
	//# sourceMappingURL=ship-to-customer-address-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/node-extensions/product-site-extension.d.ts
declare module '@sage/x3-stock/lib/node-extensions/product-site-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { NodeExtension, Reference, Collection, integer, decimal } from '@sage/xtrem-core';
	export class ProductSiteExtension extends NodeExtension<sageX3MasterData.nodes.ProductSite> {
	    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
	    readonly stock: Collection<sageX3StockData.nodes.Stock>;
	    readonly countOfStockRecords: Promise<integer | null>;
	    readonly distinctCountOfLocations: Promise<integer | null>;
	    readonly distinctCountOfLots: Promise<integer | null>;
	    readonly distinctCountOfStockQuantity: Promise<decimal | null>;
	    readonly distinctCountOfSublots: Promise<integer | null>;
	    readonly stockUnitCode: Promise<string>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product-site' {
	    interface ProductSite extends ProductSiteExtension {
	    }
	}
	//# sourceMappingURL=product-site-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-stock/lib/node-extensions/index' {
	export * from '@sage/x3-stock/lib/node-extensions/product-site-extension';
	export * from '@sage/x3-stock/lib/node-extensions/ship-to-customer-address-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/enums/stock-identifier-selection.d.ts
declare module '@sage/x3-stock/lib/enums/stock-identifier-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockIdentifierSelectionEnum {
	    productLotSublot = 1,
	    productLot = 2,
	    lotSublot = 3,
	    lot = 4,
	    productSerialNumber = 5,
	    serialNumber = 6,
	    productLocation = 7,
	    location = 8,
	    productIdentifier1 = 9,
	    identifier1 = 10,
	    productLicensePlateNumber = 11,
	    licensePlateNumber = 12
	}
	export interface StockIdentifierSelection$EnumInterface {
	    productLotSublot: 1;
	    productLot: 2;
	    lotSublot: 3;
	    lot: 4;
	    productSerialNumber: 5;
	    serialNumber: 6;
	    productLocation: 7;
	    location: 8;
	    productIdentifier1: 9;
	    identifier1: 10;
	    productLicensePlateNumber: 11;
	    licensePlateNumber: 12;
	}
	export type StockIdentifierSelection = keyof StockIdentifierSelection$EnumInterface;
	export const stockIdentifierSelectionDatatype: X3EnumDataType<keyof StockIdentifierSelection$EnumInterface, unknown>;
	//# sourceMappingURL=stock-identifier-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-stock/build/lib/enums/index.d.ts
declare module '@sage/x3-stock/lib/enums/index' {
	export * from '@sage/x3-stock/lib/enums/stock-identifier-selection';
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/x3-stock' {
	export * from '@sage/x3-stock/index';
}
