/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/pages/mobile-view-stock-by-product-site-select-location.ts":
/*!************************************************************************!*\
  !*** ./lib/pages/mobile-view-stock-by-product-site-select-location.ts ***!
  \************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileViewStockByProductSiteSelectLocation = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n// TODO: use lot management enum. See Jira ticket X3-162570.\nconst lotNotManaged = 'notManaged';\nlet MobileViewStockByProductSiteSelectLocation = class MobileViewStockByProductSiteSelectLocation extends ui.Page {\n    generateAggregateStockRequest(selector, filter, numberOfRecords = 500) {\n        const tempAggregateRequest = (0, xtrem_client_1.aggregateEdgesSelector)(selector, filter);\n        tempAggregateRequest.__args.first = numberOfRecords; // (X3-197381) TODO: Have to set some sort of hard limit. To be superseded in non-transient way\n        return this.$.graph.node('@sage/x3-stock-data/Stock').aggregate.query(tempAggregateRequest);\n    }\n    async batchAggregateRequests() {\n        const groupByLocation = {\n            location: {\n                code: {\n                    _by: 'value',\n                },\n            },\n            product: {\n                product: {\n                    stockUnit: {\n                        code: {\n                            _by: 'value',\n                        },\n                    },\n                },\n            },\n        };\n        const filterByProduct = {\n            product: { product: { code: this.product.value } },\n            stockSite: this.$.storage.get('mobile-selected-stock-site'),\n        };\n        // Separate aggregate calls in order to exclude blank lots from distinct count\n        const requests = {\n            aggregateSumStockQuantity: this.generateAggregateStockRequest({\n                group: groupByLocation,\n                values: {\n                    quantityInStockUnit: { sum: true },\n                },\n            }, {\n                filter: filterByProduct,\n            }),\n            aggregateDistinctLots: this.generateAggregateStockRequest({\n                group: groupByLocation,\n                values: {\n                    lot: { distinctCount: true },\n                },\n            }, {\n                filter: {\n                    ...filterByProduct,\n                    lot: { _ne: ' ' },\n                },\n            }),\n            aggregateDistinctLpn: this.generateAggregateStockRequest({\n                group: groupByLocation,\n                values: {\n                    licensePlateNumber: { code: { distinctCount: true } },\n                },\n            }, {\n                filter: {\n                    ...filterByProduct,\n                    licensePlateNumber: { code: { _ne: ' ' } },\n                },\n            }),\n        };\n        return await new ui.queryUtils.BatchRequest(requests).execute();\n    }\n    async confirmLicensePlates(product, location) {\n        const response = await this.$.graph\n            .node('@sage/x3-stock-data/Stock')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            product: {\n                product: {\n                    code: true,\n                },\n            },\n            location: {\n                code: true,\n            },\n            licensePlateNumber: {\n                code: true,\n            },\n        }, {\n            filter: {\n                location: {\n                    code: location,\n                },\n                product: {\n                    product: {\n                        code: product,\n                    },\n                },\n                stockSite: {\n                    code: this.site.value,\n                },\n            },\n        }))\n            .execute();\n        for (const currentRecord of response.edges) {\n            if (typesLib.strictNe((currentRecord.node.licensePlateNumber?.code ?? ''), '')) {\n                // if there is atleast one stock record with a license plate number then return true to go to the lpn page\n                return true;\n            }\n        }\n        return false; // if all returned stock records for the product and location don't have an lpn then return false to go to the product details page\n    }\n    async _getProductSite() {\n        const _productSite = await this.$.graph\n            .node('@sage/x3-master-data/ProductSite')\n            .read({\n            _id: true,\n            isLocationManaged: true,\n            isLicensePlateNumberManaged: true,\n            distinctCountOfLocations: true,\n            countOfStockRecords: true,\n            distinctCountOfStockQuantity: true,\n            distinctCountOfLots: true,\n            distinctCountOfSublots: true,\n            stockUnitCode: true,\n            product: {\n                code: true,\n                localizedDescription1: true,\n                upc: true,\n                lotManagementMode: true,\n            },\n            stockSite: {\n                code: true,\n            },\n        }, \n        // TODO: find a better way if possible\n        `${this.product.value}|${this.site.value}`)\n            .execute();\n        if (typesLib.strictEq(_productSite.product.lotManagementMode, 'lotAndSublot')) {\n            this.lotsAndSublots.value = `${ui.localize('@sage/x3-stock/stock-by-product-site-lot', 'Lots: {{code}}', {\n                code: _productSite.distinctCountOfLots,\n            })} ${ui.localize('@sage/x3-stock/stock-by-product-site-sublots', 'Sublots: {{code}}', {\n                code: _productSite.distinctCountOfSublots,\n            })}`;\n        }\n        else if (typesLib.strictEq(_productSite.product.lotManagementMode, 'notManaged')) {\n            this.lotsAndSublots.value = '';\n        }\n        else {\n            this.lotsAndSublots.value = `${ui.localize('@sage/x3-stock/stock-by-product-site-lot', 'Lots: {{code}}', {\n                code: _productSite.distinctCountOfLots,\n            })}`;\n        }\n        this.distinctLocations.value = ui.localize('@sage/x3-stock/location-title', 'Locations: {{code}}', {\n            code: String(_productSite.distinctCountOfLocations),\n        });\n    }\n};\nexports.MobileViewStockByProductSiteSelectLocation = MobileViewStockByProductSiteSelectLocation;\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: false,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"distinctLocations\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"lotsAndSublots\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"locationTitleLpnCounter\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"distinctLots\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"isLicensePlateNumberManaged\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"lotManagementMode\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.mainBlock;\n        },\n        canSelect: false,\n        canUserHideColumns: false,\n        canFilter: false,\n        isTransient: true,\n        displayMode: ui.fields.TableDisplayMode.comfortable,\n        mobileCard: undefined,\n        async onRowClick(_id, rowItem) {\n            if (typesLib.strictEq(this.isLicensePlateNumberManaged.value, 'true') &&\n                (await this.confirmLicensePlates(this.product.value, rowItem.location))) {\n                this.$.router.goTo(`@sage/x3-stock/MobileViewStockByProductSiteSelectALpn`, {\n                    site: this.site.value,\n                    product: this.product.value,\n                    location: rowItem.location,\n                    stockUnit: rowItem.stockUnit,\n                    lotManagementMode: this.lotManagementMode.value,\n                });\n            }\n            else if (typesLib.strictEq(this.lotManagementMode.value, lotNotManaged)) {\n                this.$.router.goTo(`@sage/x3-stock/MobileViewStockByProductSiteProductDetails`, {\n                    site: this.site.value,\n                    product: this.product.value,\n                    location: rowItem.location,\n                    stockUnit: rowItem.stockUnit,\n                    licensePlateNumber: '',\n                });\n            }\n            else {\n                this.$.router.goTo(`@sage/x3-stock/MobileViewStockByProductSiteProductDetails`, {\n                    site: this.site.value,\n                    product: this.product.value,\n                    location: rowItem.location,\n                    stockUnit: rowItem.stockUnit,\n                    licensePlateNumber: '',\n                });\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'location',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockQuantity',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockUnit',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'distinctLotCount',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'numberOfLPN',\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileViewStockByProductSiteSelectLocation.prototype, \"locations\", void 0);\nexports.MobileViewStockByProductSiteSelectLocation = MobileViewStockByProductSiteSelectLocation = __decorate([\n    ui.decorators.page({\n        node: '@sage/x3-master-data/ProductSite',\n        mode: 'default',\n        isTitleHidden: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_product_site_select_location____title\", \"Stock by product-site\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_product_site_select_location____subtitle\", \"Select a location\"),\n        skipDirtyCheck: true,\n        navigationPanel: undefined,\n        headerCard() {\n            return {\n                title: this.product,\n                titleRight: this.distinctLocations,\n                line2: this.lotsAndSublots,\n                line2Right: this.locationTitleLpnCounter,\n            };\n        },\n        async onLoad() {\n            // Requires a selected product in the query parameters.  This should not occur unless user manually\n            // directs themselves to this page\n            const productParameter = this.$.queryParameters.product;\n            const mess = ui.localize('@sage/x3-stock/product-required', 'Selected product is required');\n            if (!productParameter) {\n                this.$.showToast(mess, { type: 'warning' });\n                this.$.router.goTo(`@sage/x3-stock/MobileViewStockByProductSite`);\n                return;\n            }\n            this.product.value = productParameter.toString();\n            this.site.value = String(this.$.queryParameters.site);\n            await this._getProductSite();\n            this.isLicensePlateNumberManaged.value = String(this.$.queryParameters.isLicensePlateNumberManaged);\n            this.lotManagementMode.value = String(this.$.queryParameters.lotManagementMode);\n            this.mainBlock.title = this.distinctLocations.value;\n            const aggregatedResults = await this.batchAggregateRequests();\n            // Redirect user to first page if selected product yields no records.  User should not get to this page\n            // if no stock records unless manually entering page.\n            if (!aggregatedResults.aggregateSumStockQuantity.edges) {\n                this.$.showToast(ui.localize('@sage/x3-stock/notification-warning-product-inquiry-zero-products', 'Product {{code}} has zero locations(s)', { code: this.product.value }), { type: 'error' });\n                this.$.router.goTo('@sage/x3-stock/MobileViewStockByProductSite');\n                return;\n            }\n            // initialize data structure map (aka. dictionary) to consolidate and store aggregated values to the corresponding location\n            const aggregationsLocationMap = new Map();\n            // populate map with all existing locations (+ products' stock units) in stock node given selected default site & product\n            (0, xtrem_client_1.extractEdges)(aggregatedResults.aggregateSumStockQuantity).forEach(aggregation => {\n                aggregationsLocationMap.set(aggregation.group.location.code, {\n                    stockUnit: aggregation.group.product.product.stockUnit.code,\n                    stockQuantity: Number(aggregation.values.quantityInStockUnit.sum),\n                    distinctLotCount: 0,\n                    distinctLpnCount: 0,\n                });\n            });\n            // make all forEach() calls optional because there can be no stock records with any lots for a location\n            (0, xtrem_client_1.extractEdges)(aggregatedResults.aggregateDistinctLots)?.forEach(aggregation => {\n                if (aggregationsLocationMap.has(aggregation.group.location.code)) {\n                    aggregationsLocationMap.get(aggregation.group.location.code).distinctLotCount =\n                        aggregation.values.lot.distinctCount;\n                }\n            });\n            let lpnCounter = 0;\n            (0, xtrem_client_1.extractEdges)(aggregatedResults.aggregateDistinctLpn)?.forEach(aggregation => {\n                if (aggregationsLocationMap.has(aggregation.group.location.code)) {\n                    aggregationsLocationMap.get(aggregation.group.location.code).distinctLpnCount =\n                        aggregation.values.licensePlateNumber.code.distinctCount;\n                    lpnCounter = typesLib.add(lpnCounter, aggregation.values.licensePlateNumber.code.distinctCount);\n                }\n            });\n            if (typesLib.strictEq(this.isLicensePlateNumberManaged.value, 'true')) {\n                this.locationTitleLpnCounter.value = ui.localize('@sage/x3-stock/locations-title', 'LPNs: {{counter}}', {\n                    counter: lpnCounter,\n                });\n            }\n            const locationsValue = new Array();\n            aggregationsLocationMap.forEach((value, key) => {\n                locationsValue.push({\n                    _id: key, // this is required, otherwise during onRowClick, rowItem will be blank\n                    location: key,\n                    stockQuantity: `${value.stockQuantity.toString()} ${value.stockUnit}`,\n                    stockUnit: value.stockUnit,\n                    distinctLotCount: value.distinctLotCount,\n                    numberOfLPN: typesLib.gt(value.distinctLpnCount, 0) ? ui.localize('@sage/x3-stock/number-of-lpn', '{{distinctLpnCount}} LPN', {\n                        distinctLpnCount: value.distinctLpnCount,\n                    })\n                        : '',\n                });\n            });\n            if (typesLib.strictEq(locationsValue.length, 0)) {\n                setTimeout(() => this.$.showToast(ui.localize('@sage/x3-stock/selected-product-no-results', 'Product {{code}} has no stock records.', {\n                    code: productParameter,\n                }), { type: 'info' }), 10);\n                this.$.router.goTo(`@sage/x3-stock/MobileViewStockByProductSite`);\n                return;\n            }\n            this.locations.value = locationsValue;\n        },\n    })\n], MobileViewStockByProductSiteSelectLocation);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-view-stock-by-product-site-select-location.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-view-stock-by-product-site-select-location.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;