/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/pages/mobile-view-stock-by-location-select-product.ts":
/*!*******************************************************************!*\
  !*** ./lib/pages/mobile-view-stock-by-location-select-product.ts ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileViewStockByLocationSelectProduct = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n// TODO: use lot management enum. See Jira ticket X3-162570.\nconst notManaged = 'notManaged';\nconst lotAndSublot = 'lotAndSublot';\nlet MobileViewStockByLocationSelectProduct = class MobileViewStockByLocationSelectProduct extends ui.Page {\n};\nexports.MobileViewStockByLocationSelectProduct = MobileViewStockByLocationSelectProduct;\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileViewStockByLocationSelectProduct.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileViewStockByLocationSelectProduct.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: false,\n        //bind: 'code', //TODO Issue: if this is specified, then it will prevent the value field from being manually set during onLoad()\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationSelectProduct.prototype, \"code\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationSelectProduct.prototype, \"distinctProductCount\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.mainBlock;\n        },\n        canSelect: false,\n        canUserHideColumns: false,\n        canFilter: false,\n        isTransient: true,\n        displayMode: ui.fields.TableDisplayMode.comfortable,\n        onRowClick(_id, rowItem) {\n            if (typesLib.strictNe(rowItem.lpnCount, 0)) {\n                this.$.router.goTo('@sage/x3-stock/MobileViewStockByLocationSelectLPN', {\n                    _id: this._id.value, // this is the id of the location record, not the selection of the product\n                    product: rowItem.product,\n                    localizedDescription1: rowItem.localizedDescription1,\n                    stockQuantity: rowItem.stockQuantity,\n                    stockUnit: rowItem.stockUnit,\n                    lotManagementMode: rowItem.lotManagementMode,\n                });\n            }\n            else {\n                // otherwise skip level 3 if selected product has no license plate numbers\n                const lotCount = typesLib.strictNe(rowItem.lotManagementMode, notManaged) ? ui.localize('@sage/x3-stock/lots-title', 'Lots: {{code}}', {\n                    code: rowItem.lotCount,\n                })\n                    : '';\n                this.$.router.goTo('@sage/x3-stock/MobileViewStockByLocationProductDetails', {\n                    _id: this._id.value,\n                    product: rowItem.product,\n                    lotCount: lotCount,\n                    stockQuantity: rowItem.stockQuantity,\n                    stockUnit: rowItem.stockUnit,\n                });\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                isReadOnly: true,\n                canFilter: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockQuantity',\n                isReadOnly: true,\n                postfix(value, rowData) {\n                    return rowData?.stockUnit;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'lotAndSublot',\n                isReadOnly: true,\n            }),\n        ],\n        cardView: true,\n        mobileCard: {\n            title: ui.nestedFields.text({\n                bind: 'product',\n                isReadOnly: true,\n                canFilter: true,\n            }),\n            titleRight: ui.nestedFields.text({\n                bind: 'stockQuantity',\n                isReadOnly: true,\n                postfix(value, rowData) {\n                    return rowData?.stockUnit;\n                },\n            }),\n            line2: ui.nestedFields.text({\n                bind: 'localizedDescription1',\n                isReadOnly: true,\n            }),\n            line3: ui.nestedFields.text({\n                bind: 'lotAndSublot',\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value;\n                },\n            }),\n        },\n    })\n], MobileViewStockByLocationSelectProduct.prototype, \"productLines\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        isTransient: false,\n        isHidden: true,\n        //bind: '_id', //TODO Issue: if this is specified, then it will prevent the value field from being manually set during onLoad()\n    })\n], MobileViewStockByLocationSelectProduct.prototype, \"_id\", void 0);\nexports.MobileViewStockByLocationSelectProduct = MobileViewStockByLocationSelectProduct = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_select_product____title\", \"Stock by location\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_select_product____subtitle\", \"Select a product\"),\n        isTitleHidden: true, // hide the page's title and render that title only in the feature header instead of in both places (see X3-177000 & https://github.com/Sage-ERP-X3/etna/pull/1785)\n        node: '@sage/x3-stock-data/Location',\n        mode: 'default',\n        skipDirtyCheck: true,\n        navigationPanel: undefined,\n        headerCard() {\n            return {\n                title: this.code,\n                titleRight: this.distinctProductCount,\n            };\n        },\n        async onLoad() {\n            const aggregateResult = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .aggregate.query((0, xtrem_client_1.aggregateEdgesSelector)({\n                group: {\n                    product: {\n                        product: {\n                            code: {\n                                _by: 'value',\n                            },\n                            lotManagementMode: {\n                                _by: 'value',\n                            },\n                            stockUnit: {\n                                code: {\n                                    _by: 'value',\n                                },\n                            },\n                        },\n                    },\n                },\n                values: {\n                    quantityInStockUnit: { sum: true },\n                    lot: { distinctCount: true },\n                    sublot: { distinctCount: true },\n                    licensePlateNumber: { code: { distinctCount: true } },\n                },\n            }, {\n                first: 500, // (X3-197381) TODO: Have to set some sort of hard limit. To be superseded in non-transient way\n                filter: {\n                    location: { code: this.code.value },\n                    stockSite: { code: this.$.storage.get('mobile-selected-stock-site') },\n                },\n                orderBy: { product: { product: { code: +1 } } },\n            }))\n                .execute());\n            this.distinctProductCount.value = aggregateResult.length.toString();\n            this.distinctProductCount.prefix = ui.localize('@sage/x3-stock/location-inquiry-product', 'Products:');\n            this.mainBlock.title = `${this.distinctProductCount.prefix} ${this.distinctProductCount.value} `;\n            // Verify if selected location yields at least one result by checking the existence of any aggregated stock quantity sum\n            // if not, automatically redirect the user back previous screen\n            // (practically should never occur as long as user isn't trying to manually direct himself/herself to this screen)\n            if (typesLib.strictEq(aggregateResult.length, 0)) {\n                this.$.showToast(ui.localize('@sage/x3-stock/notification-warning-location-inquiry-zero-products', 'The {{code}} location has no products.', { code: this.code.value }), { type: 'error' });\n                this.$.router.goTo('@sage/x3-stock/MobileViewStockByLocation');\n                return;\n            }\n            // TODO Issue: By simply adding localizedDescription1 to the aggregate request, the error 'Error: ORA-22818: subquery expressions not allowed here' occurs\n            // So implementing this workaround to retrieve localizedDescription1 in another request\n            const localizedDescriptions = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-master-data/Product')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n                localizedDescription1: true,\n            }, {\n                first: 500, // TODO Issue: Need a table-like ui component that can bind & aggregate on a collection property in a non-transient way\n                filter: {\n                    code: {\n                        _in: aggregateResult.map(record => record.group.product.product.code),\n                    }, //group\n                },\n                orderBy: { code: +1 },\n            }))\n                .execute());\n            aggregateResult.forEach((record, index) => {\n                record.group.product.product.localizedDescription1 =\n                    localizedDescriptions[index].localizedDescription1;\n            });\n            this.productLines.value = aggregateResult.map((value) => {\n                let lotAndSublotCount = '';\n                switch (value.group.product.product.lotManagementMode) {\n                    case lotAndSublot:\n                        lotAndSublotCount = `${ui.localize('@sage/x3-stock/location-inquiry-lot', 'Lots: {{code}}', {\n                            code: value.values.lot.distinctCount,\n                        })} and ${ui.localize('@sage/x3-stock/location-inquiry-sublot', 'Sublots: {{code}}', {\n                            code: value.values.sublot.distinctCount,\n                        })}`;\n                        break;\n                    case notManaged:\n                        lotAndSublotCount = '';\n                        break;\n                    default:\n                        lotAndSublotCount = ui.localize('@sage/x3-stock/location-inquiry-lot', 'Lots: {{code}}', {\n                            code: value.values.lot.distinctCount,\n                        });\n                }\n                return {\n                    _id: value.group.product.product.code, // this is required, otherwise during onRowClick, rowItem will be blank\n                    product: value.group.product.product.code,\n                    localizedDescription1: value.group.product.product.localizedDescription1,\n                    lotManagementMode: value.group.product.product.lotManagementMode,\n                    stockQuantity: value.values.quantityInStockUnit.sum,\n                    stockUnit: value.group.product.product.stockUnit.code,\n                    lotAndSublot: lotAndSublotCount,\n                    lotCount: value.values.lot.distinctCount,\n                    lpnCount: value.values.licensePlateNumber.code.distinctCount,\n                };\n            });\n        },\n    })\n], MobileViewStockByLocationSelectProduct);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-view-stock-by-location-select-product.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-view-stock-by-location-select-product.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;