/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/get-unit-number-decimals.ts":
/*!**********************************************************!*\
  !*** ./lib/client-functions/get-unit-number-decimals.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GetNumberOfDecimals = exports.getNumberOfDecimal = exports.getUnitNumberOfDecimalList = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function getUnitNumberOfDecimalList(pageInstance) {\n    try {\n        const numberOfDecimalList = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n            numberOfDecimals: true,\n        }, {\n            first: 1000,\n        }))\n            .execute());\n        return numberOfDecimalList;\n    }\n    catch (e) {\n        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-stock/pages__utils__get_unit_number_decimals_error', 'Error loading unit'), String(e));\n        return [];\n    }\n}\nexports.getUnitNumberOfDecimalList = getUnitNumberOfDecimalList;\nfunction getNumberOfDecimal(list, unit) {\n    if (unit && list) {\n        const _unitOfMeasure = list.filter(uom => typesLib.strictEq(uom.code, unit));\n        return _unitOfMeasure[0]?.numberOfDecimals ?? 0;\n    }\n    return 0;\n}\nexports.getNumberOfDecimal = getNumberOfDecimal;\nfunction GetNumberOfDecimals(pageInstance, Unit) {\n    try {\n        const numberOfDecimals = pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .read({\n            _id: true,\n            numberOfDecimals: true,\n        }, `${Unit}`)\n            .execute();\n        return numberOfDecimals.numberOfDecimals;\n    }\n    catch (e) {\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-unit', 'Error loading unit'), String(e));\n    }\n}\nexports.GetNumberOfDecimals = GetNumberOfDecimals;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/get-unit-number-decimals.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-view-stock-by-location-product-details.ts":
/*!********************************************************************!*\
  !*** ./lib/pages/mobile-view-stock-by-location-product-details.ts ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileViewStockByLocationProductDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst get_unit_number_decimals_1 = __webpack_require__(/*! ../client-functions/get-unit-number-decimals */ \"./lib/client-functions/get-unit-number-decimals.ts\");\nlet MobileViewStockByLocationProductDetails = class MobileViewStockByLocationProductDetails extends ui.Page {\n};\nexports.MobileViewStockByLocationProductDetails = MobileViewStockByLocationProductDetails;\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"lpnOrLocation\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"lotCount\", void 0);\n__decorate([\n    ui.decorators.imageField({\n        parent() {\n            return this.mainBlock;\n        },\n        isTransient: true,\n        isReadOnly: true,\n        width: 'medium',\n        height: 'medium',\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"image\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"stockQuantity\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"globalSerial\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"otherSerial\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"lotManaged\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"sublotManaged\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"localizedDescription1\", void 0);\n__decorate([\n    ui.decorators.detailListField({\n        parent() {\n            return this.mainBlock;\n        },\n        isTransient: true,\n        fields: [\n            ui.nestedFields.numeric({\n                bind: 'stockId',\n                isHidden: true,\n                isTransient: true,\n            }),\n            //display a blank line at the top\n            ui.nestedFields.text({\n                bind: '_spacerColumn',\n                isReadOnly: true,\n                isTransient: true,\n            }),\n            // Blank header when no serial or lot\n            ui.nestedFields.text({\n                bind: 'lot',\n                isReadOnly: true,\n                isTransient: false,\n                isHidden() {\n                    return typesLib.strictEq(this.lotManaged.value, 1) || typesLib.strictEq(this.otherSerial.value, 1) || typesLib.strictEq(this.globalSerial.value, 1);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title\", \"Lot\"),\n                isReadOnly: true,\n                isTransient: false,\n                isHidden() {\n                    return typesLib.strictEq(this.lotManaged.value, 0);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__2\", \"Sublot\"),\n                isReadOnly: true,\n                isTransient: false,\n                isHidden() {\n                    return typesLib.strictEq(this.sublotManaged.value, 0);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'majorVersion',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__3\", \"Major version\"),\n                isReadOnly: true,\n                isTransient: false,\n                isHidden() {\n                    return typesLib.strictEq(this.lotManaged.value, 0);\n                },\n            }),\n            ui.nestedFields.date({\n                bind: 'expirationDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__4\", \"Expiration date\"),\n                isReadOnly: true,\n                isTransient: false,\n                isHidden() {\n                    return typesLib.strictEq(this.lotManaged.value, 0);\n                },\n            }),\n            ui.nestedFields.date({\n                bind: 'useByDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__5\", \"Use-by date\"),\n                isReadOnly: true,\n                isTransient: false,\n                isHidden() {\n                    return typesLib.strictEq(this.lotManaged.value, 0);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'custom1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__6\", \"Lot custom field 1\"),\n                isReadOnly: true,\n                isTransient: false,\n                isHidden() {\n                    return typesLib.strictEq(this.lotManaged.value, 0);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'custom2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__7\", \"Lot custom field 2\"),\n                isReadOnly: true,\n                isTransient: false,\n                isHidden() {\n                    return typesLib.strictEq(this.lotManaged.value, 0);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__8\", \"Serial no.\"),\n                isReadOnly: true,\n                isTransient: false,\n                isHidden() {\n                    return typesLib.strictEq(this.otherSerial.value, 0);\n                },\n            }),\n            ui.nestedFields.link({\n                bind: 'globalSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__9\", \"Serial no.\"),\n                isHidden() {\n                    return typesLib.strictEq(this.globalSerial.value, 0);\n                },\n                async onClick(_id, rowData) {\n                    this.$.setPageClean();\n                    this.$.router.goTo('@sage/x3-stock/MobileGlobalSerialDetails', {\n                        product: this.product.value,\n                        stockId: rowData.stockId,\n                        subtitle: this.localizedDescription1.value,\n                    });\n                },\n            }),\n            ui.nestedFields.text({\n                // TODO Issue: No way to bind to multiple node fields to display packing unit or set postfix in a dynamic way\n                bind: 'quantityInPackingUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__10\", \"Packing qty.\"),\n                isTransient: false,\n            }),\n            ui.nestedFields.text({\n                // TODO Issue: No way to bind to multiple node fields to display stock unit or set postfix in a dynamic way\n                bind: 'quantityInStockUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__11\", \"Stock qty.\"),\n                isTransient: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'allocatedQuantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__12\", \"Allocated qty.\"),\n                isTransient: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__13\", \"Status\"),\n                isReadOnly: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__14\", \"Identifier 1\"),\n                isReadOnly: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__15\", \"Identifier 2\"),\n                isReadOnly: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'qualityAnalysisRequestId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__16\", \"Analysis req.\"),\n                isReadOnly: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'countInProgress',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__17\", \"Count in progress\"),\n                isReadOnly: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'owner',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details__stockDetailLines____fields__title__18\", \"Owner\"),\n                isReadOnly: true,\n                isTransient: false,\n            }),\n        ],\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"stockDetailLines\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: false,\n        isReadOnly: true,\n        isHidden: true,\n    })\n], MobileViewStockByLocationProductDetails.prototype, \"code\", void 0);\nexports.MobileViewStockByLocationProductDetails = MobileViewStockByLocationProductDetails = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details____title\", \"Stock by location\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_product_details____subtitle\", \"Product details\"),\n        isTitleHidden: true, // hide the page's title and render that title only in the feature header instead of in both places (see X3-177000 & https://github.com/Sage-ERP-X3/etna/pull/1785)\n        node: '@sage/x3-stock-data/Location',\n        mode: 'default',\n        skipDirtyCheck: true,\n        navigationPanel: undefined,\n        headerCard() {\n            // TODO Issue: Header Card doesn't support Reference or Numeric control\n            return {\n                title: this.product,\n                titleRight: this.stockQuantity,\n                line2: this.localizedDescription1,\n                line3: this.lpnOrLocation,\n                line3Right: this.lotCount,\n            };\n        },\n        async onLoad() {\n            // Requires a selected location, product, & lpn in the query parameters\n            const productParameter = this.$.queryParameters['product'];\n            const lotCountParameter = this.$.queryParameters['lotCount'];\n            const stockQuantityParameter = this.$.queryParameters['stockQuantity'];\n            const stockUnitParameter = this.$.queryParameters['stockUnit'];\n            if (!this.code.value ||\n                !productParameter || typesLib.strictEq(lotCountParameter, null) || // because we want to allow possibility of 0 lot count\n             typesLib.strictEq(// because we want to allow possibility of 0 lot count\n            lotCountParameter, undefined) ||\n                !stockQuantityParameter ||\n                !stockUnitParameter) {\n                this.$.showToast(ui.localize('@sage/x3-stock/notification-error-location-inquiry-level4-missing-params', 'A selected location, product, & license plate number are required'), { type: 'error' });\n                this.$.router.goTo('@sage/x3-stock/MobileViewStockByLocation');\n                return;\n            }\n            // Fill out header card\n            this._numberOfDecimalList = await (0, get_unit_number_decimals_1.getUnitNumberOfDecimalList)(this);\n            const numberDecimal = (0, get_unit_number_decimals_1.getNumberOfDecimal)(this._numberOfDecimalList, stockUnitParameter.toString());\n            this.product.value = productParameter.toString();\n            this.stockQuantity.value = Number(stockQuantityParameter).toFixed(numberDecimal);\n            this.stockQuantity.postfix = stockUnitParameter.toString();\n            this.lotCount.value = lotCountParameter.toString();\n            const lpnParameter = this.$.queryParameters['licensePlateNumber'];\n            if (lpnParameter) {\n                this.lpnOrLocation.prefix = ui.localize('@sage/x3-stock/location-inquiry-license-plate-number-prefix', 'LPN');\n                this.lpnOrLocation.value = String(lpnParameter);\n            }\n            else {\n                this.lpnOrLocation.prefix = ui.localize('@sage/x3-stock/location-inquiry-location-prefix', 'Location');\n                this.lpnOrLocation.value = this.code.value;\n            }\n            // Apply filter to the detailed list component\n            // TODO Issue: Unnecessary non-transient call is made when trying to apply a filter in a dynamic way\n            const response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .query(ui.queryUtils.edgesSelector({\n                _id: true,\n                lot: true,\n                sublot: true,\n                quantityInPackingUnit: true,\n                packingUnit: {\n                    code: true,\n                },\n                quantityInStockUnit: true,\n                product: {\n                    product: {\n                        stockUnit: {\n                            code: true,\n                        },\n                        serialNumberManagementMode: true,\n                        lotManagementMode: true,\n                        code: true,\n                        localizedDescription1: true,\n                        expirationManagementMode: true,\n                    },\n                },\n                allocatedQuantity: true,\n                serialNumber: true,\n                status: {\n                    code: true,\n                },\n                identifier1: true,\n                identifier2: true,\n                qualityAnalysisRequestId: true,\n                owner: true,\n                isBeingCounted: true,\n                packingUnitToStockUnitConversionFactor: true,\n                stockId: true,\n                lotReference: {\n                    expirationDate: true,\n                    useByDate: true,\n                    lotCustomField1: true,\n                    lotCustomField2: true,\n                    majorVersion: { code: true },\n                },\n            }, {\n                first: 500,\n                filter: {\n                    stockSite: { code: this.$.storage.get('mobile-selected-stock-site') },\n                    location: { code: this.code.value },\n                    product: { product: productParameter },\n                    licensePlateNumber: lpnParameter ? lpnParameter : '',\n                },\n                orderBy: {\n                    lot: 1,\n                    serialNumber: 1,\n                },\n            }))\n                .execute());\n            // Should never happen\n            if (typesLib.strictEq(response.length, 0)) {\n                return;\n            }\n            this.globalSerial.value =\n                typesLib.strictEq(response[0].product.product.serialNumberManagementMode, 'globalReceivedIssued') ? 1\n                    : 0;\n            this.otherSerial.value =\n                typesLib.strictEq(response[0].product.product.serialNumberManagementMode, 'receivedIssued') || typesLib.strictEq(response[0].product.product.serialNumberManagementMode, 'issued')\n                    ? 1\n                    : 0;\n            this.lotManaged.value =\n                typesLib.strictEq(response[0].product.product.lotManagementMode, 'notManaged') ? 0 : 1;\n            this.sublotManaged.value =\n                typesLib.strictEq(response[0].product.product.lotManagementMode, 'lotAndSublot') ? 1 : 0;\n            this.localizedDescription1.value = response[0].product.product.localizedDescription1;\n            // Display product picture\n            const productPicture = await this.$.graph\n                .node('@sage/x3-master-data/Product')\n                .read({ picture: { value: true } }, `${this.product.value}| `)\n                .execute();\n            this.image.value = productPicture?.picture ?? undefined;\n            this.$.setPageClean();\n            this.stockDetailLines.value = await response.map((currentRecord) => {\n                return {\n                    _id: currentRecord._id,\n                    stockId: currentRecord.stockId,\n                    lot: currentRecord.lot,\n                    sublot: currentRecord.sublot,\n                    majorVersion: currentRecord.lotReference?.majorVersion\n                        ? currentRecord.lotReference.majorVersion?.code\n                        : null,\n                    expirationDate: typesLib.strictEq(currentRecord.product.product.expirationManagementMode, 'notManaged') ? null\n                        : currentRecord.lotReference?.expirationDate,\n                    useByDate: typesLib.strictEq(currentRecord.product.product.expirationManagementMode, 'notManaged') ? null\n                        : currentRecord.lotReference?.useByDate,\n                    custom1: currentRecord.lotReference?.lotCustomField1,\n                    custom2: currentRecord.lotReference?.lotCustomField2,\n                    quantityInPackingUnit: `${currentRecord.quantityInPackingUnit} ${currentRecord.packingUnit.code}`,\n                    quantityInStockUnit: `${currentRecord.quantityInStockUnit} ${currentRecord.product.product.stockUnit.code}`,\n                    allocatedQuantity: `${typesLib.strictEq(currentRecord.allocatedQuantity, null) ? 0 : currentRecord.allocatedQuantity} ${currentRecord.product.product.stockUnit.code}`,\n                    serialNumber: currentRecord.serialNumber,\n                    globalSerialNumber: ui.localize('@sage/x3-stock/label-view-all', 'View list'),\n                    status: currentRecord.status.code,\n                    identifier1: currentRecord.identifier1,\n                    identifier2: currentRecord.identifier2,\n                    qualityAnalysisRequestId: currentRecord.qualityAnalysisRequestId,\n                    countInProgress: currentRecord.isBeingCounted\n                        ? ui.localize('@sage/x3-stock/label-yes', 'Yes')\n                        : ui.localize('@sage/x3-stock/label-no', 'No'),\n                    owner: currentRecord.owner,\n                };\n            });\n        },\n    })\n], MobileViewStockByLocationProductDetails);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-view-stock-by-location-product-details.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-view-stock-by-location-product-details.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;