import { StockChangeByLpnInput, StockEntryTransaction } from '@sage/x3-stock-api';
import { LicensePlateNumberInput } from '@sage/x3-stock-data-api';
import * as ui from '@sage/xtrem-ui';
type DeepPartial<T> = T extends Object ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : T;
type PartialStockTransaction = DeepPartial<StockEntryTransaction>;
export type inputsStockChangeByLpn = {
    stockChangeByLpn: StockChangeByLpnInput & {
        id?: string;
    };
    username: string;
    currentLine?: number;
    started: boolean;
    selectedTransaction?: PartialStockTransaction;
    selectedLicensePlateNumber?: LicensePlateNumberInput;
    destination?: string;
    printingMode?: string;
};
export declare class MobileStockChangeByLpn extends ui.Page {
    savedObject: inputsStockChangeByLpn;
    private _transactions;
    private _notifier;
    stockSite: ui.fields.Text;
    createButton: ui.PageAction;
    mainSection: ui.containers.Section;
    firstLineBlock: ui.containers.Block;
    effectiveDate: ui.fields.Date;
    transaction: ui.fields.DropdownList;
    thirdBlock: ui.containers.Block;
    licensePlateNumber: ui.fields.Reference;
    stockChangeLinesBlock: ui.containers.Block;
    stockChangeLines: ui.fields.Table<any>;
    private _init;
    private _disablePage;
    private _initSite;
    private _initDestination;
    private _initTransaction;
    private _setTransaction;
    private _readSavedObject;
    private _checkStorage;
    private _reInitStorage;
    private _initStorage;
    private _saveStockChangeByLpn;
    private _mapStockChange;
    private _initStockChangeLines;
    private _postInitStockChangeLines;
    prepareDataMutation(): StockChangeByLpnInput;
    private _callCreationAPI;
}
export {};
//# sourceMappingURL=mobile-stock-change-by-lpn.d.ts.map