import { GraphApi, StockChangeInput, StockEntryTransaction } from '@sage/x3-stock-api';
import * as ui from '@sage/xtrem-ui';
type DeepPartial<T> = T extends Object ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : T;
type PartialStockEntryTransaction = DeepPartial<StockEntryTransaction>;
export type inputsStockChange = {
    stockChange: StockChangeInput & {
        id?: string;
    };
    username: string;
    started: boolean;
    selectedTransaction?: PartialStockEntryTransaction;
    destination?: string;
    printingMode?: string;
    selectedIdentifier?: string;
    selectedIdentifierValues?: string;
};
export declare enum PrintingModeEnum {
    noPrint = 1,
    stockLabel = 2,
    substituteValue3 = 3,
    transfertDocument = 4,
    analysisDocument = 5,
    createdContainerLabel = 6,
    stockLabelAndCreatedContainerLabel = 7
}
export declare class MobileStockChangeByIdentifier extends ui.Page<GraphApi> {
    savedObject: inputsStockChange;
    private _transactions;
    private _notifier;
    private _numberOfDecimalList;
    stockSite: ui.fields.Text;
    createButton: ui.PageAction;
    nextButton: ui.PageAction;
    mainSection: ui.containers.Section;
    transactionBlock: ui.containers.Block;
    effectiveDate: ui.fields.Date;
    transaction: ui.fields.DropdownList;
    thirdBlock: ui.containers.Block;
    identifier: ui.fields.DropdownList;
    stockChangeLinesBlock: ui.containers.Block;
    stockChangeLines: ui.fields.Table<any>;
    private _init;
    private _disablePage;
    private _initSite;
    private _initDestination;
    private _initTransaction;
    private _setTransaction;
    private _readSavedObject;
    private _checkStorage;
    private _reInitStorage;
    private _initStorage;
    private _saveStockChange;
    private _initStockChangeLines;
    private _postInitStockChangeLines;
    /**
     * return a clean copy ready for the translation
     * @returns
     */
    prepareDataMutation(): StockChangeInput;
    private _callCreationAPI;
    private goToDetailsPage;
    private _filterIdentifierList;
}
export {};
//# sourceMappingURL=mobile-stock-change-by-identifier.d.ts.map