/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/control.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/control.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.controlLotReceipt = exports.renumberStockCountList = exports.validateWithDetails = exports.validatePage = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nfunction validate(pageInstance, isPageValid, fieldsData) {\n    const fieldErrors = new Array();\n    let areAllFieldsValid = true;\n    fieldsData.forEach(field => {\n        if (!_validateField(field)) {\n            areAllFieldsValid = false;\n            fieldErrors.push(field.fieldName ?? '');\n        }\n    });\n    if (typesLib.gte(fieldErrors.length, 1))\n        _notifyFieldNotValid(pageInstance, fieldErrors);\n    return isPageValid && areAllFieldsValid;\n}\nexports.validate = validate;\nfunction _validateField(data) {\n    return !data.validate ? true : false;\n}\nfunction _notifyFieldNotValid(pageInstance, fields) {\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fields.map(field => pageInstance[field].title) }), { type: 'error', timeout: 5000 });\n}\nasync function validatePage(pageInstance) {\n    const errors = await pageInstance.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(`${ui.localize('@sage/x3-stock/notification-validation-error', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validatePage = validatePage;\nasync function validateWithDetails(pageInstance) {\n    // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n// Decision made to not present an error to the user if one occurs during renumbering\nasync function renumberStockCountList(stockCountSessionNumber, stockCountListNumber, page) {\n    try {\n        const _renumberListArgs = {\n            stockCountSessionNumber: stockCountSessionNumber,\n            stockCountListNumber: stockCountListNumber,\n        };\n        await page.$.graph\n            .node('@sage/x3-stock/StockCountListDetail')\n            .mutations.renumberCountList({\n            stockCountSessionNumber: true,\n            stockCountListNumber: true,\n        }, {\n            parameters: _renumberListArgs,\n        })\n            .execute();\n    }\n    catch (e) {\n        ui.console.error(`renumberCountList :\\n${JSON.stringify(e)}`);\n    }\n}\nexports.renumberStockCountList = renumberStockCountList;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock/StockJournal')\n        .query(ui.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast(ui.localize('@sage/x3-stock/notification-error-receipt-lot', 'The lot number {{ lot }} already exists for this product.', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/control.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-putaway-detail.ts":
/*!********************************************!*\
  !*** ./lib/pages/mobile-putaway-detail.ts ***!
  \********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobilePutawayDetail = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_decimal_2 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst control_1 = __webpack_require__(/*! ../client-functions/control */ \"./lib/client-functions/control.ts\");\nlet MobilePutawayDetail = class MobilePutawayDetail extends ui.Page {\n    async _initializePage(stockTransaction, storageDetails) {\n        if (!stockTransaction)\n            throw new Error('Invalid Stock Transaction');\n        this._stockTransaction = stockTransaction;\n        this._storageDetails = storageDetails;\n        this._site.value = storageDetails.storageSite;\n        // header card\n        this._storageListNumber.value = storageDetails.storageListNumber;\n        this._product.value = storageDetails.storage.product;\n        this.headerProduct.value = this._product.value.code;\n        this._localizedDescription1.value = storageDetails.storage.product.localizedDescription1;\n        // main block\n        this.packingUnit.value = storageDetails.packingUnit;\n        this.quantityInPackingUnit.value = this.quantityInPackingUnit.max = Number(storageDetails.quantityInPackingUnit);\n        this.quantityInPackingUnit.scale = storageDetails.packingUnit.numberOfDecimals; // enforce precision based on packing unit\n        this.fromStatus.value = storageDetails.storage.status.code;\n        this.toStatus.options = await this._fetchStatuses();\n        this.toStatus.value = storageDetails.status.code;\n        this.fromLocation.value = storageDetails.storage.location;\n        this.toLocation.value = storageDetails.location; // no need to worry about products that are not location managed\n        this.lot.isHidden = typesLib.strictEq(storageDetails.storage.product.lotManagementMode, 'notManaged'); // lot is hidden if product is not lot managed\n        this.lot.isMandatory =\n            !this.lot.isHidden &&\n                !storageDetails.storage.product.lotSequenceNumber && typesLib.strictNe(storageDetails.storage.product.lotManagementMode, 'optionalLot'); // lot is mandatory only if lot is NOT hidden, does NOT have lot seq # & product is lot managed, but NOT optional\n        if (!this.lot.isHidden)\n            this.lot.value = storageDetails.lot;\n        this.lot.isDisabled = !!this.lot.value; // disable lot if this storage detail line already has a lot specified\n        this.sublot.isHidden = typesLib.strictNe(storageDetails.storage.product.lotManagementMode, 'lotAndSublot'); // sublot is hidden if product is not both lot & sublot managed\n        this.sublot.isMandatory = !this.sublot.isHidden; // sublot is mandatory only if it is not hidden\n        if (!this.sublot.isHidden)\n            this.sublot.value = storageDetails.sublot;\n        this.sublot.isDisabled = !!this.sublot.value; // disable sublot if this storage detail line already has a sublot specified\n        this.serialNumber.isHidden = ['notManaged', 'issued'].includes(storageDetails.storage.product.serialNumberManagementMode); // serial is hidden if product is not serial managed or issued\n        this.serialNumber.isMandatory =\n            !this.serialNumber.isHidden && !storageDetails.storage.product.serialSequenceNumber; // serial is mandatory only if serial is NOT hidden, does NOT have serial seq #\n        if (!this.serialNumber.isHidden)\n            this.serialNumber.value = storageDetails.startingSerialNumber;\n        this.serialNumber.isDisabled = !!this.serialNumber.value; // disable serial if this storage detail line already has a serial number specified\n        this.licensePlateNumber.isHidden = this.container.isHidden = !Boolean(storageDetails.storage.product.productSites?.[0]?.isLicensePlateNumberManaged);\n        if (!this.licensePlateNumber.isHidden) {\n            this.licensePlateNumber.value = storageDetails.licensePlateNumber;\n            this.container.value = storageDetails.licensePlateNumber?.container;\n            // if provided lpn in storage worksheet (detail) line and...\n            // 1) lpn has status 'inStock' (which is always associated to a location), then toLocation must be disabled\n            // 2) lpn has status 'free' but no location associated, then toLocation must be enabled\n            // 3) lpn has status 'free' but has a location associated, then toLocation must be disabled\n            // NOTE: toLocation provided in storage worksheet (detail) line should be the same as provided lpn's location\n            this.toLocation.isDisabled = !!this.licensePlateNumber.value?.location?.code;\n        }\n        this.licensePlateNumber.isDisabled = !!this.licensePlateNumber.value; // if lpn is provided, disable\n        this.quantityInPackingUnit.focus();\n    }\n    async _fetchStatuses() {\n        return (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-stock-data/StockStatus')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n        }))\n            .execute()).map(status => status.code);\n    }\n    async _callProcessAPI() {\n        // Populate required arguments\n        const putawayArgs = {\n            stockEntryTransaction: this._stockTransaction,\n            storageSite: this._storageDetails.storageSite.code,\n            stockId: this._storageDetails.stockId,\n            documentType: this._storageDetails.documentType,\n            documentNumber: this._storageDetails.documentNumber,\n            documentLineNumber: this._storageDetails.documentLineNumber,\n            storageSequenceNumber: this._storageDetails.storageSequenceNumber,\n            quantityInPackingUnit: this.quantityInPackingUnit.value,\n            quantityInStockUnit: xtrem_decimal_2.Decimal.make(this.quantityInPackingUnit.value)\n                .mul(this._storageDetails.packingUnitToStockUnitConversionFactor)\n                .toNumber(),\n            status: this.toStatus.value,\n            location: this.toLocation.value.code,\n            locationType: this.toLocation.value.type,\n        };\n        // (X3-237016) TODO Issue: Have to specify all optional parameters in the processPutaway mutation due to a bug\n        // Populate situational arguments\n        // if (!this.lot.isHidden && this.lot.value) putawayArgs.lot = this.lot.value;\n        // if (!this.sublot.isHidden && this.sublot.value) putawayArgs.sublot = this.sublot.value;\n        // if (!this.serialNumber.isHidden && this.serialNumber.value) {\n        //     putawayArgs.startingSerialNumber = this.serialNumber.value;\n        //     putawayArgs.endingSerialNumber = this._storageDetails.endingSerialNumber;\n        // }\n        // if (!this.licensePlateNumber.isHidden && this.licensePlateNumber.value?.code) {\n        //     putawayArgs.licensePlateNumber = this.licensePlateNumber.value.code;\n        //     if (this.container.value?.code) putawayArgs.container = this.container.value.code;\n        // }\n        // let labelDestination: string = this.$.storage.get('adc-label-destination') as string;\n        // if (labelDestination) {\n        //     putawayArgs.labelDestination = labelDestination;\n        // }\n        // (X3-237016) TODO Issue: Have to specify ALL optional parameters in the processPutaway mutation due to a bug\n        putawayArgs.lot = !this.lot.isHidden && this.lot.value ? this.lot.value : '';\n        putawayArgs.sublot = !this.sublot.isHidden && this.sublot.value ? this.sublot.value : '';\n        putawayArgs.startingSerialNumber =\n            !this.serialNumber.isHidden && this.serialNumber.value ? this.serialNumber.value : '';\n        putawayArgs.endingSerialNumber =\n            !this.serialNumber.isHidden &&\n                this.serialNumber.value &&\n                // if product is serial tracked & globalReceivedIssued and the user is attempting to do a partial quantity, then do not pass any ending serial number from this storage worksheet (detail) line\n                (typesLib.strictNe(this._storageDetails.storage.product.serialNumberManagementMode, 'globalReceivedIssued') || typesLib.strictEq(this.quantityInPackingUnit.value, this.quantityInPackingUnit.max))\n                ? this._storageDetails.endingSerialNumber\n                : '';\n        putawayArgs.licensePlateNumber =\n            !this.licensePlateNumber.isHidden && this.licensePlateNumber.value?.code\n                ? this.licensePlateNumber.value.code\n                : '';\n        putawayArgs.container =\n            !!putawayArgs.licensePlateNumber && this.container.value?.code ? this.container.value.code : '';\n        putawayArgs.labelDestination = this.$.storage.get('mobile-label-destination') ?? '';\n        // Generate Putaway mutation request\n        try {\n            return await this.$.graph\n                .node('@sage/x3-stock/StorageDetails')\n                .mutations.processPutaway({\n                stockEntryTransaction: true,\n                storageSite: true,\n                stockId: true,\n                documentType: true,\n                documentNumber: true,\n                documentLineNumber: true,\n                storageSequenceNumber: true,\n                quantityInPackingUnit: true,\n                lot: true,\n                sublot: true,\n                startingSerialNumber: true,\n                endingSerialNumber: true,\n                status: true,\n                container: true,\n                licensePlateNumber: true,\n                location: true,\n                locationType: true,\n                quantityInStockUnit: true,\n                labelDestination: true,\n            }, {\n                parameters: putawayArgs,\n            })\n                .execute();\n        }\n        catch (error) {\n            return error;\n        }\n    }\n    /** @internal */\n    isWebServiceError(error) {\n        // errors contains a array or undefined when is not class ClientError\n        // diagnoses contains a array or undefined when is not class ApiError\n        // TODO:  See to increase this feature\n        const diagnoses = error?.diagnoses;\n        const errors = error?.errors;\n        return (error instanceof Error &&\n            ((diagnoses && typesLib.strictEq(diagnoses.length, 0)) ||\n                (errors && typesLib.gt(errors.length, 0) &&\n                    errors.some(detail => typesLib.strictEq(detail?.extensions?.code, 'business-rule-error') &&\n                        (detail.message.startsWith('Failed to get description for web service') ||\n                            detail.message.endsWith('Channel allocation refused'))))));\n    }\n};\nexports.MobilePutawayDetail = MobilePutawayDetail;\n__decorate([\n    ui.decorators.referenceField({\n        isTransient: true,\n        isHidden: true,\n        node: '@sage/x3-system/Site',\n        valueField: 'code',\n        canFilter: false,\n    })\n], MobilePutawayDetail.prototype, \"_site\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isHidden: false,\n        isReadOnly: true,\n    })\n], MobilePutawayDetail.prototype, \"_storageListNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        isTransient: true,\n        isHidden: false,\n        isReadOnly: true,\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        canFilter: false,\n    })\n], MobilePutawayDetail.prototype, \"_product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isHidden: false,\n        isReadOnly: true,\n    })\n], MobilePutawayDetail.prototype, \"headerProduct\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isHidden: false,\n        isReadOnly: true,\n        // node: '@sage/xtrem-x3-master-data/Product',\n        // valueField: 'localizedDescription1',\n    })\n], MobilePutawayDetail.prototype, \"_localizedDescription1\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__previousButton____title\", \"Previous\"),\n        shortcut: ['f4'],\n        buttonType: 'secondary',\n        onClick() {\n            this.$.router.goTo('@sage/x3-stock/MobilePutawayTodo', {\n                site: this._site.value.code,\n                storageListNumber: this._storageListNumber.value,\n                stockTransaction: this._stockTransaction,\n            });\n        },\n    })\n], MobilePutawayDetail.prototype, \"previousButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__submitButton____title\", \"Submit\"),\n        shortcut: ['f2'],\n        buttonType: 'primary',\n        async onClick() {\n            // perform client-side validation\n            if (!(await (0, control_1.validateWithDetails)(this)))\n                return;\n            // to prevent extreme scenarios from rapidly clicking the update button multiple times\n            this.submitButton.isDisabled = true;\n            this.previousButton.isDisabled = true;\n            this.$.loader.isHidden = false;\n            const result = await this._callProcessAPI();\n            this.submitButton.isDisabled = false;\n            this.previousButton.isDisabled = false;\n            this.$.loader.isHidden = true;\n            if ((!result.errors || !result.errors.length) && result instanceof Error) {\n                await this.$.sound.error();\n                if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.'), {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                    },\n                    size: 'small',\n                })) {\n                    await this.$.router.refresh();\n                }\n                else {\n                    await this.$.router.emptyPage();\n                    this.$.router.goTo('@sage/x3-stock/MobilePutaway');\n                }\n                return;\n            }\n            if ((!result.errors || !result.errors.length || typesLib.strictEq(result.errors.length, 0)) && !result.message) {\n                this.$.setPageClean();\n                if (typesLib.strictEq(\n                // to handle the edgy case of directing user back to 2nd, not 1st, page if user is doing a partial update\n                this.quantityInPackingUnit.value, this.quantityInPackingUnit.max)) {\n                    var _v;\n                    _v = this._totalCount, this._totalCount = typesLib.sub(this._totalCount, 1), _v;\n                }\n            }\n            else {\n                //severity 3 and 4 - error\n                if (typesLib.strictNe(result.errors[0].extensions.diagnoses.filter((d) => typesLib.gt(d.severity, 2) && d.message).length, 0)) {\n                    await this.$.sound.error();\n                    const messageArray = result.errors[0].extensions.diagnoses[0].message.split(`\\n`);\n                    let message = `**${ui.localize('@sage/x3-stock/dialog-error-putaway-update', 'An error has occurred during Putaway update')}**\\n\\n`;\n                    if (typesLib.strictEq(messageArray.length, 1)) {\n                        message = typesLib.add(message, `${messageArray[0]}`);\n                    }\n                    else {\n                        message = typesLib.add(message, messageArray.map(item => `* ${item}`).join('\\n'));\n                    }\n                    if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), `${message}`, {\n                        fullScreen: true,\n                        acceptButton: {\n                            text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                        },\n                        cancelButton: {\n                            text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                        },\n                        size: 'small',\n                        mdContent: true,\n                    })) {\n                        return;\n                    }\n                }\n                else {\n                    await this.$.sound.success();\n                    const messageArray = result.errors[0].extensions.diagnoses[0].message.split(`\\n`);\n                    let message = `**${ui.localize('@sage/x3-stock/dialog-warning-title', 'Warning')}**\\n\\n`;\n                    if (typesLib.strictEq(messageArray.length, 1)) {\n                        message = typesLib.add(message, `${messageArray[0]}`);\n                    }\n                    else {\n                        message = typesLib.add(message, messageArray.map(item => `* ${item}`).join('\\n'));\n                    }\n                    await (0, dialogs_1.dialogMessage)(this, 'warn', ui.localize('@sage/x3-stock/dialog-warning-title', 'Warning'), `${message}`, {\n                        acceptButton: {\n                            text: ui.localize('@sage/x3-stock/button-accept-ok', 'OK'),\n                        },\n                        size: 'small',\n                        mdContent: true,\n                    });\n                    if (typesLib.strictEq(\n                    // to handle the edgy case of directing user back to 2nd, not 1st, page if user is doing a partial update\n                    this.quantityInPackingUnit.value, this.quantityInPackingUnit.max)) {\n                        var _v;\n                        _v = this._totalCount, this._totalCount = typesLib.sub(this._totalCount, 1), _v;\n                    }\n                }\n            }\n            if (typesLib.gt(this._totalCount, 0)) {\n                this.$.router.goTo('@sage/x3-stock/MobilePutawayTodo', {\n                    site: this._site.value.code,\n                    storageListNumber: this._storageListNumber.value,\n                    stockTransaction: this._stockTransaction,\n                });\n            }\n            else {\n                await (0, dialogs_1.dialogMessage)(this, 'success', ui.localize('@sage/x3-stock/dialog-success-title', 'Success'), ui.localize('@sage/x3-stock/dialog-success-putaway-complete', 'Putaway complete'));\n                this.$.router.goTo('@sage/x3-stock/MobilePutaway');\n            }\n        },\n    })\n], MobilePutawayDetail.prototype, \"submitButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobilePutawayDetail.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobilePutawayDetail.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__fromLocation____title\", \"From location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isTransient: true,\n        isReadOnly: true,\n        canFilter: false,\n    })\n], MobilePutawayDetail.prototype, \"fromLocation\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__fromStatus____title\", \"From status\"),\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobilePutawayDetail.prototype, \"fromStatus\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__packingUnit____title\", \"Packing unit\"),\n        node: '@sage/x3-master-data/UnitOfMeasure',\n        valueField: 'code',\n        isTransient: true,\n        isReadOnly: true,\n        canFilter: false,\n    })\n], MobilePutawayDetail.prototype, \"packingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__quantityInPackingUnit____title\", \"Packing quantity\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__quantityInPackingUnit____placeholder\", \"Enter quantity\"),\n        isTransient: true,\n        isMandatory: true,\n        isNotZero: true,\n        min: 0,\n    })\n], MobilePutawayDetail.prototype, \"quantityInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__toStatus____title\", \"To status\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__toStatus____placeholder\", \"Enter status\"),\n        isMandatory: true,\n        isFullWidth: true,\n        onChange() {\n            this.toStatus.getNextField(true)?.focus();\n        },\n    })\n], MobilePutawayDetail.prototype, \"toStatus\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__licensePlateNumber____title\", \"To license plate number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        valueField: 'code',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        // (X3-237456) TODO Issue: Lookup panel's load more button does not work for licensePlateNumber reference field\n        filter() {\n            const filter = {\n                stockSite: { code: this._site.value.code },\n                location: { category: { _nin: ['dock'] } }, // location category must not be a dock type\n                isActive: { _eq: true },\n                // TODO: LPN filter criteria on single-product & single-lot managed lpns\n                _and: [\n                    {\n                        _or: [\n                            { isSingleProduct: { _eq: false } },\n                            {\n                                isSingleProduct: { _eq: true }, // to not imply isSingleProduct is true here because this property is nullable\n                                stock: { _atLeast: 1, product: this._product?.value?.code },\n                            },\n                            {\n                                isSingleProduct: { _eq: true }, // to not imply isSingleProduct is true here because this property is nullable\n                                stock: { _none: true },\n                            },\n                        ],\n                    },\n                ],\n            };\n            // TODO: Add the container filter\n            // if (this.container.value?.code) {\n            //     filter.container = { code: this.container.value.code };\n            // }\n            if (this.toLocation.value?.code) {\n                filter._and.push({\n                    _or: [\n                        {\n                            location: { code: this.toLocation.value.code },\n                        },\n                        {\n                            // to also include entries without location that have 'free' status\n                            _and: [{ location: { code: null } }, { status: 'free' }],\n                        },\n                    ],\n                });\n            }\n            return filter;\n        },\n        async onChange() {\n            if (!this.licensePlateNumber.value) {\n                this.toLocation.isDisabled = false;\n                this.toLocation.value = null;\n                this.container.value = null;\n                await this.$.commitValueAndPropertyChanges(); // without this, when you clear out LPN and then, without tabbing out, click Location's lookup button directly, nothing will happen\n                return;\n            }\n            // Populate and disable To Location field if selected LPN is associated with a location\n            // if location is NOT populated manually by the user\n            if (!this.toLocation.value) {\n                this.toLocation.value = this.licensePlateNumber.value.location;\n            }\n            this.toLocation.isDisabled = !!this.licensePlateNumber.value.location;\n            if (this.licensePlateNumber.value?.container) {\n                this.container.value = this.licensePlateNumber.value.container;\n            }\n            await this.$.commitValueAndPropertyChanges();\n            this.licensePlateNumber.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__licensePlateNumber____columns__title__code\", \"License Plate Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Location',\n                bind: 'location',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__licensePlateNumber____columns__title__location__code\", \"Location\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Container',\n                bind: 'container',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__licensePlateNumber____columns__title__container__code\", \"Container\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.label({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__licensePlateNumber____columns__title__status\", \"Status\"),\n                map(value, rowData) {\n                    switch (value) {\n                        case 'free':\n                            return 'Free';\n                        case 'inStock':\n                            return 'In Stock';\n                        default:\n                            return '';\n                    }\n                },\n                borderColor: ui.tokens.colorsYang100,\n                optionType: '@sage/x3-stock/ContainerStatus',\n            }),\n            // hidden location type column in order to auto-populate toLocation field with BOTH code & type during onChange()\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Location',\n                bind: 'location',\n                valueField: 'type',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePutawayDetail.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__container____title\", \"To container\"),\n        node: '@sage/x3-master-data/Container',\n        valueField: 'code',\n        isTransient: true,\n        isReadOnly: true,\n        isMandatory: false,\n        isFullWidth: true,\n        canFilter: false,\n    })\n], MobilePutawayDetail.prototype, \"container\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__toLocation____title\", \"To location\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__toLocation____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        //minLookupCharacters: 1,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: { code: this._site.value.code },\n                // TODO Issue: Not sure why this is having build-time errors. There exist working filter criteria on enum using _ne operator...\n                //category: { _ne: 'dock' },\n                category: { _nin: ['dock'] }, // cannot be a dock location\n            };\n        },\n        onChange() {\n            try {\n                if (this.toLocation.value)\n                    this.toLocation.getNextField(true)?.focus();\n            }\n            catch (e) { }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__toLocation____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__toLocation____columns__title__type\", \"Type\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePutawayDetail.prototype, \"toLocation\", void 0);\n__decorate([\n    ui.decorators.filterSelectField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__lot____title\", \"Lot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__lot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/Lot',\n        valueField: 'code',\n        //helperText: 'sublot', // TODO: Preload sublot based on selected lot\n        isHelperTextHidden: true,\n        isTransient: true,\n        isFullWidth: true,\n        isNewEnabled: true,\n        validation: /^$|^[^|a-z]+$/, // added a check for negating lower-case characters to avoid edge cases\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this._product.value.code },\n            };\n        },\n        async onChange() {\n            if (!this.lot.value) {\n                // if lot is manually cleared out, then clear out sublot as well ONLY if this storage detail line doesn't have a pre-populated sublot\n                if (!this.sublot.isHidden && !this._storageDetails.sublot) {\n                    this.sublot.value = null;\n                    this.sublot.isDisabled = false;\n                }\n                return;\n            }\n            this.lot.value = this.lot.value.toUpperCase();\n            await this.$.commitValueAndPropertyChanges();\n            await this.lot.validate();\n            this.lot.getNextField(true)?.focus();\n            // TODO: Preload sublot based on selected lot\n            // if (this.lot.helperText) {\n            //     // if lot has an associated sublot, then populate sublot and disable it\n            //     this.sublot.value = this.lot.helperText;\n            //     this.sublot.isDisabled = true;\n            // }\n        },\n    })\n], MobilePutawayDetail.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__sublot____title\", \"Sublot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__sublot____placeholder\", \"Scan a sublot\"),\n        isTransient: true,\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n        onChange() {\n            if (this.sublot.value)\n                this.sublot.value = this.sublot.value.toUpperCase();\n        },\n    })\n], MobilePutawayDetail.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__serialNumber____title\", \"Serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail__serialNumber____placeholder\", \"Scan a serial number\"),\n        isTransient: true,\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n    })\n], MobilePutawayDetail.prototype, \"serialNumber\", void 0);\nexports.MobilePutawayDetail = MobilePutawayDetail = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail____title\", \"Putaway\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_detail____subtitle\", \"Enter details\"),\n        isTitleHidden: true,\n        isTransient: true, // make this a fully transient page by deriving all necessary data from current session\n        mode: 'default',\n        async onLoad() {\n            try {\n                this._totalCount = this.$.queryParameters.totalCount ?? 0;\n                // TODO Issue: The serialized object is actually of type ExtractEdges<StorageDetails>, not StorageDetails\n                await this._initializePage(this.$.queryParameters.stockTransaction, JSON.parse(this.$.storage.get('MobilePutawayTodo')));\n            }\n            catch (e) {\n                // If session got corrupted or retired, then return back to 1st page\n                ui.console.log(`Missing required parameters due to\\\\n${e}`);\n                this.$.showToast(ui.localize('@sage/x3-stock/notification-error-missing-params', 'Missing required parameters'), { type: 'error' });\n                this.$.router.goTo('@sage/x3-stock/MobilePutaway');\n                return;\n            }\n        },\n        headerCard() {\n            return {\n                title: this._storageListNumber,\n                line2: this.headerProduct,\n                line3: this._localizedDescription1,\n            };\n        },\n        businessActions() {\n            return [this.previousButton, this.submitButton];\n        },\n    })\n], MobilePutawayDetail);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9saWIvcGFnZXMvbW9iaWxlLXB1dGF3YXktZGV0YWlsLnRzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFDQSw4SkFBc0c7QUFJdEcsMkZBQXlHO0FBQ3pHLDhGQUE4QztBQUU5Qyx1RUFBcUM7QUFDckMsOEdBQWtFO0FBdUMzRCxJQUFNLG1CQUFtQixHQUF6QixNQUFNLG1CQUFvQixTQUFRLEVBQUUsQ0FBQyxJQUFjO0lBOGlCOUMsS0FBSyxDQUFDLGVBQWUsQ0FBQyxnQkFBd0IsRUFBRSxjQUFtRDtRQUN2RyxJQUFJLENBQUMsZ0JBQWdCO1lBQUUsTUFBTSxJQUFJLEtBQUssQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBRXBFLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxnQkFBZ0IsQ0FBQztRQUMxQyxJQUFJLENBQUMsZUFBZSxHQUFHLGNBQWMsQ0FBQztRQUN0QyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxjQUFjLENBQUMsV0FBVyxDQUFDO1FBRTlDLGNBQWM7UUFDZCxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxHQUFHLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssR0FBRyxjQUFjLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQztRQUNyRCxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDcEQsSUFBSSxDQUFDLHNCQUFzQixDQUFDLEtBQUssR0FBRyxjQUFjLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQztRQUV6RixhQUFhO1FBQ2IsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEdBQUcsY0FBYyxDQUFDLFdBQVcsQ0FBQztRQUNwRCxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxHQUFHLEdBQUcsTUFBTSxDQUN0RSxjQUFjLENBQUMscUJBQXFCLENBQ3ZDLENBQUM7UUFDRixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFHLGNBQWMsQ0FBQyxXQUFXLENBQUMsZ0JBQWdCLENBQUMsQ0FBQywwQ0FBMEM7UUFDMUgsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLEdBQUcsY0FBYyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQzNELElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxHQUFHLE1BQU0sSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1FBQ3BELElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxHQUFHLGNBQWMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ2pELElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxHQUFHLGNBQWMsQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDO1FBQzFELElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxHQUFHLGNBQWMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxnRUFBZ0U7UUFFakgsSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLHFCQUFHLGNBQWMsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLGlCQUFpQixFQUFLLFlBQVksRUFBQyxDQUFDLDhDQUE4QztRQUNySSxJQUFJLENBQUMsR0FBRyxDQUFDLFdBQVc7WUFDaEIsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLFFBQVE7Z0JBQ2xCLENBQUMsY0FBYyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsaUJBQWlCLHNCQUNqRCxjQUFjLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsRUFBSyxhQUFhLEVBQUMsQ0FBQyxpSEFBaUg7UUFDekwsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsUUFBUTtZQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxHQUFHLGNBQWMsQ0FBQyxHQUFHLENBQUM7UUFDNUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUMsc0VBQXNFO1FBRTlHLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxxQkFBRyxjQUFjLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsRUFBSyxjQUFjLEVBQUMsQ0FBQywrREFBK0Q7UUFDM0osSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLEdBQUcsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxDQUFDLCtDQUErQztRQUNoRyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRO1lBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEdBQUcsY0FBYyxDQUFDLE1BQU0sQ0FBQztRQUNyRSxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyw0RUFBNEU7UUFFMUgsSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRLEdBQUcsQ0FBQyxZQUFZLEVBQUUsUUFBUSxDQUFDLENBQUMsUUFBUSxDQUMxRCxjQUFjLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQywwQkFBMEIsQ0FDNUQsQ0FBQyxDQUFDLDhEQUE4RDtRQUNqRSxJQUFJLENBQUMsWUFBWSxDQUFDLFdBQVc7WUFDekIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsSUFBSSxDQUFDLGNBQWMsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLG9CQUFvQixDQUFDLENBQUMsK0VBQStFO1FBQ3hLLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVE7WUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUssR0FBRyxjQUFjLENBQUMsb0JBQW9CLENBQUM7UUFDL0YsSUFBSSxDQUFDLFlBQVksQ0FBQyxVQUFVLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLENBQUMsbUZBQW1GO1FBRTdJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLEdBQUcsQ0FBQyxPQUFPLENBQ2pFLGNBQWMsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLDJCQUEyQixDQUNoRixDQUFDO1FBQ0YsSUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUNwQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxHQUFHLGNBQWMsQ0FBQyxrQkFBa0IsQ0FBQztZQUNsRSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRyxjQUFjLENBQUMsa0JBQWtCLEVBQUUsU0FBUyxDQUFDO1lBRXBFLDREQUE0RDtZQUM1RCwyR0FBMkc7WUFDM0csdUZBQXVGO1lBQ3ZGLDJGQUEyRjtZQUMzRiw2R0FBNkc7WUFDN0csSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFLElBQUksQ0FBQztRQUNqRixDQUFDO1FBQ0QsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxDQUFDLDhCQUE4QjtRQUVwRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLENBQUM7SUFDdkMsQ0FBQztJQUVPLEtBQUssQ0FBQyxjQUFjO1FBQ3hCLE9BQU8sK0JBQVksRUFDZixNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSzthQUNiLElBQUksQ0FBQyxpQ0FBaUMsQ0FBQzthQUN2QyxLQUFLLENBQ0YsRUFBRSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7WUFDeEIsSUFBSSxFQUFFLElBQUk7U0FDYixDQUFDLENBQ0w7YUFDQSxPQUFPLEVBQUUsQ0FDakIsQ0FBQyxHQUFHLENBQUMsTUFBTSxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDakMsQ0FBQztJQUVPLEtBQUssQ0FBQyxlQUFlO1FBQ3pCLDhCQUE4QjtRQUM5QixNQUFNLFdBQVcsR0FBUTtZQUNyQixxQkFBcUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQzdDLFdBQVcsRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQyxJQUFJO1lBQ2xELE9BQU8sRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU87WUFDckMsWUFBWSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsWUFBWTtZQUMvQyxjQUFjLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxjQUFjO1lBQ25ELGtCQUFrQixFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsa0JBQWtCO1lBQzNELHFCQUFxQixFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMscUJBQXFCO1lBQ2pFLHFCQUFxQixFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLO1lBQ3ZELG1CQUFtQixFQUFFLHVCQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLENBQUM7aUJBQzlELEdBQUcsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLHNDQUFzQyxDQUFDO2lCQUNoRSxRQUFRLEVBQUU7WUFDZixNQUFNLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLO1lBQzNCLFFBQVEsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJO1lBQ3BDLFlBQVksRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJO1NBQzNDLENBQUM7UUFFRiw4R0FBOEc7UUFDOUcsaUNBQWlDO1FBQ2pDLDhFQUE4RTtRQUM5RSwwRkFBMEY7UUFDMUYsZ0VBQWdFO1FBQ2hFLGtFQUFrRTtRQUNsRSxnRkFBZ0Y7UUFDaEYsSUFBSTtRQUNKLGtGQUFrRjtRQUNsRiwyRUFBMkU7UUFDM0UseUZBQXlGO1FBQ3pGLElBQUk7UUFDSix3RkFBd0Y7UUFDeEYsMEJBQTBCO1FBQzFCLHVEQUF1RDtRQUN2RCxJQUFJO1FBRUosOEdBQThHO1FBQzlHLFdBQVcsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLFFBQVEsSUFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUM3RSxXQUFXLENBQUMsTUFBTSxHQUFHLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7UUFDekYsV0FBVyxDQUFDLG9CQUFvQjtZQUM1QixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO1FBQzFGLFdBQVcsQ0FBQyxrQkFBa0I7WUFDMUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVE7Z0JBQzNCLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSztnQkFDdkIsK0xBQStMO2dCQUMvTCxDQUFDLHNCQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsMEJBQTBCLEVBQUssc0JBQXNCLHVCQUN2RixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFLLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxHQUFHLEVBQUM7Z0JBQ3BFLENBQUMsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLGtCQUFrQjtnQkFDekMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUNiLFdBQVcsQ0FBQyxrQkFBa0I7WUFDMUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxJQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLEVBQUUsSUFBSTtnQkFDcEUsQ0FBQyxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsSUFBSTtnQkFDcEMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUNiLFdBQVcsQ0FBQyxTQUFTO1lBQ2pCLENBQUMsQ0FBQyxXQUFXLENBQUMsa0JBQWtCLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztRQUNwRyxXQUFXLENBQUMsZ0JBQWdCLEdBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLDBCQUEwQixDQUFZLElBQUksRUFBRSxDQUFDO1FBRWhHLG9DQUFvQztRQUNwQyxJQUFJLENBQUM7WUFDRCxPQUFPLE1BQU0sSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLO2lCQUNwQixJQUFJLENBQUMsK0JBQStCLENBQUM7aUJBQ3JDLFNBQVMsQ0FBQyxjQUFjLENBQ3JCO2dCQUNJLHFCQUFxQixFQUFFLElBQUk7Z0JBQzNCLFdBQVcsRUFBRSxJQUFJO2dCQUNqQixPQUFPLEVBQUUsSUFBSTtnQkFDYixZQUFZLEVBQUUsSUFBSTtnQkFDbEIsY0FBYyxFQUFFLElBQUk7Z0JBQ3BCLGtCQUFrQixFQUFFLElBQUk7Z0JBQ3hCLHFCQUFxQixFQUFFLElBQUk7Z0JBQzNCLHFCQUFxQixFQUFFLElBQUk7Z0JBQzNCLEdBQUcsRUFBRSxJQUFJO2dCQUNULE1BQU0sRUFBRSxJQUFJO2dCQUNaLG9CQUFvQixFQUFFLElBQUk7Z0JBQzFCLGtCQUFrQixFQUFFLElBQUk7Z0JBQ3hCLE1BQU0sRUFBRSxJQUFJO2dCQUNaLFNBQVMsRUFBRSxJQUFJO2dCQUNmLGtCQUFrQixFQUFFLElBQUk7Z0JBQ3hCLFFBQVEsRUFBRSxJQUFJO2dCQUNkLFlBQVksRUFBRSxJQUFJO2dCQUNsQixtQkFBbUIsRUFBRSxJQUFJO2dCQUN6QixnQkFBZ0IsRUFBRSxJQUFJO2FBQ3pCLEVBQ0Q7Z0JBQ0ksVUFBVSxFQUFFLFdBQVc7YUFDMUIsQ0FDSjtpQkFDQSxPQUFPLEVBQUUsQ0FBQztRQUNuQixDQUFDO1FBQUMsT0FBTyxLQUFLLEVBQUUsQ0FBQztZQUNiLE9BQU8sS0FBSyxDQUFDO1FBQ2pCLENBQUM7SUFDTCxDQUFDO0lBRUQsZ0JBQWdCO0lBQ1IsaUJBQWlCLENBQUMsS0FBVTtRQUNoQyxxRUFBcUU7UUFDckUscUVBQXFFO1FBQ3JFLHNDQUFzQztRQUN0QyxNQUFNLFNBQVMsR0FBYyxLQUFNLEVBQUUsU0FBUyxDQUFDO1FBQy9DLE1BQU0sTUFBTSxHQUFnQyxLQUFNLEVBQUUsTUFBTSxDQUFDO1FBRTNELE9BQU8sQ0FDSCxLQUFLLFlBQVksS0FBSztZQUN0QixDQUFDLENBQUMsU0FBUyxzQkFBSSxTQUFTLENBQUMsTUFBTSxFQUFLLENBQUMsRUFBQztnQkFDbEMsQ0FBQyxNQUFNLGdCQUNILE1BQU0sQ0FBQyxNQUFNLEVBQUcsQ0FBQztvQkFDakIsTUFBTSxDQUFDLElBQUksQ0FDUCxNQUFNLENBQUMsRUFBRSxDQUNMLHdCQUFNLEVBQUUsVUFBVSxFQUFFLElBQUksRUFBSyxxQkFBcUI7d0JBQ2xELENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsMkNBQTJDLENBQUM7NEJBQ25FLE1BQU0sQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLDRCQUE0QixDQUFDLENBQUMsQ0FDakUsQ0FBQyxDQUFDLENBQ2QsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQTl1Qlksa0RBQW1CO0FBWTVCO0lBUEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQTRCO1FBQ3JELFdBQVcsRUFBRSxJQUFJO1FBQ2pCLFFBQVEsRUFBRSxJQUFJO1FBQ2QsSUFBSSxFQUFFLHNCQUFzQjtRQUM1QixVQUFVLEVBQUUsTUFBTTtRQUNsQixTQUFTLEVBQUUsS0FBSztLQUNuQixDQUFDO2tEQUMrQjtBQU9qQztJQUxDLEVBQUUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFzQjtRQUMxQyxXQUFXLEVBQUUsSUFBSTtRQUNqQixRQUFRLEVBQUUsS0FBSztRQUNmLFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7K0RBQ2lDO0FBVW5DO0lBUkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQStCO1FBQ3hELFdBQVcsRUFBRSxJQUFJO1FBQ2pCLFFBQVEsRUFBRSxLQUFLO1FBQ2YsVUFBVSxFQUFFLElBQUk7UUFDaEIsSUFBSSxFQUFFLDhCQUE4QjtRQUNwQyxVQUFVLEVBQUUsTUFBTTtRQUNsQixTQUFTLEVBQUUsS0FBSztLQUNuQixDQUFDO3FEQUNxQztBQU92QztJQUxDLEVBQUUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFzQjtRQUMxQyxXQUFXLEVBQUUsSUFBSTtRQUNqQixRQUFRLEVBQUUsS0FBSztRQUNmLFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7MERBQzRCO0FBUzlCO0lBUEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXNCO1FBQzFDLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLFFBQVEsRUFBRSxLQUFLO1FBQ2YsVUFBVSxFQUFFLElBQUk7UUFDaEIsOENBQThDO1FBQzlDLHVDQUF1QztLQUMxQyxDQUFDO21FQUNxQztBQW9CdkM7SUFaQyxFQUFFLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBc0I7UUFDM0MsS0FBSyxpR0FBWTtRQUNqQixRQUFRLEVBQUUsQ0FBQyxJQUFJLENBQUM7UUFDaEIsVUFBVSxFQUFFLFdBQVc7UUFDdkIsT0FBTztZQUNILElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxrQ0FBa0MsRUFBRTtnQkFDbkQsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLElBQUk7Z0JBQzNCLGlCQUFpQixFQUFFLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLO2dCQUNoRCxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsaUJBQWlCO2FBQzNDLENBQUMsQ0FBQztRQUNQLENBQUM7S0FDSixDQUFDOzJEQUM0QjtBQW9KOUI7SUFsSkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQXNCO1FBQzNDLEtBQUssNkZBQVU7UUFDZixRQUFRLEVBQUUsQ0FBQyxJQUFJLENBQUM7UUFDaEIsVUFBVSxFQUFFLFNBQVM7UUFDckIsS0FBSyxDQUFDLE9BQU87WUFDVCxpQ0FBaUM7WUFDakMsSUFBSSxDQUFDLENBQUMsTUFBTSxpQ0FBbUIsRUFBQyxJQUFJLENBQUMsQ0FBQztnQkFBRSxPQUFPO1lBRS9DLHNGQUFzRjtZQUN0RixJQUFJLENBQUMsWUFBWSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7WUFDcEMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1lBQ3RDLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7WUFDL0IsTUFBTSxNQUFNLEdBQUcsTUFBTSxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7WUFDNUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO1lBQ3JDLElBQUksQ0FBQyxjQUFjLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztZQUN2QyxJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1lBRTlCLElBQUksQ0FBQyxDQUFDLE1BQU0sQ0FBQyxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLE1BQU0sWUFBWSxLQUFLLEVBQUUsQ0FBQztnQkFDdkUsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDM0IsSUFDSSxNQUFNLGdDQUFrQixFQUNwQixJQUFJLEVBQ0osT0FBTyxFQUNQLEVBQUUsQ0FBQyxRQUFRLENBQUMsbUNBQW1DLEVBQUUsT0FBTyxDQUFDLEVBQ3pELEVBQUUsQ0FBQyxRQUFRLENBQ1AsZ0ZBQWdGLEVBQ2hGLDRGQUE0RixDQUMvRixFQUNEO29CQUNJLFlBQVksRUFBRTt3QkFDVixJQUFJLEVBQUUsRUFBRSxDQUFDLFFBQVEsQ0FBQyw4QkFBOEIsRUFBRSxTQUFTLENBQUM7cUJBQy9EO29CQUNELFlBQVksRUFBRTt3QkFDVixJQUFJLEVBQUUsRUFBRSxDQUFDLFFBQVEsQ0FBQyw4QkFBOEIsRUFBRSxRQUFRLENBQUM7cUJBQzlEO29CQUNELElBQUksRUFBRSxPQUFPO2lCQUNoQixDQUNKLEVBQ0gsQ0FBQztvQkFDQyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxDQUFDO2dCQUNsQyxDQUFDO3FCQUFNLENBQUM7b0JBQ0osTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxTQUFTLEVBQUUsQ0FBQztvQkFDaEMsSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLDhCQUE4QixDQUFDLENBQUM7Z0JBQ3ZELENBQUM7Z0JBQ0QsT0FBTztZQUNYLENBQUM7WUFFRCxJQUFJLENBQUMsQ0FBQyxNQUFNLENBQUMsTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxNQUFNLHNCQUFJLE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBTSxFQUFLLENBQUMsRUFBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxDQUFDO2dCQUM3RixJQUFJLENBQUMsQ0FBQyxDQUFDLFlBQVksRUFBRSxDQUFDO2dCQUN0QjtnQkFDSSx5R0FBeUc7Z0JBQ3pHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUssSUFBSSxDQUFDLHFCQUFxQixDQUFDLEdBQUcsR0FDckUsQ0FBQzs7b0JBQ0MsMkRBQUksQ0FBQyxXQUFXLFNBQUc7aUJBQ3RCO1lBQ0wsQ0FBQztpQkFBTSxDQUFDO2dCQUNKLDBCQUEwQjtnQkFDMUIsc0JBQ0ksTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FDeEMsQ0FBQyxDQUFxQyxFQUFFLEVBQUUsQ0FBQyxhQUFDLENBQUMsUUFBUSxFQUFHLENBQUMsS0FBSSxDQUFDLENBQUMsT0FBTyxDQUN6RSxDQUFDLE1BQU0sRUFBSyxDQUFDLEdBQ2hCLENBQUM7b0JBQ0MsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztvQkFFM0IsTUFBTSxZQUFZLEdBQWEsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7b0JBQzVGLElBQUksT0FBTyxHQUFHLEtBQUssRUFBRSxDQUFDLFFBQVEsQ0FDMUIsNENBQTRDLEVBQzVDLDZDQUE2QyxDQUNoRCxRQUFRLENBQUM7b0JBQ1Ysc0JBQUksWUFBWSxDQUFDLE1BQU0sRUFBSyxDQUFDLEdBQUUsQ0FBQzt3QkFDNUIsOEJBQU8sRUFBSSxHQUFHLFlBQVksQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFDO29CQUNwQyxDQUFDO3lCQUFNLENBQUM7d0JBQ0osOEJBQU8sRUFBSSxZQUFZLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsS0FBSyxJQUFJLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBQztvQkFDaEUsQ0FBQztvQkFFRCxJQUNJLE1BQU0sZ0NBQWtCLEVBQ3BCLElBQUksRUFDSixPQUFPLEVBQ1AsRUFBRSxDQUFDLFFBQVEsQ0FBQyxtQ0FBbUMsRUFBRSxPQUFPLENBQUMsRUFDekQsR0FBRyxPQUFPLEVBQUUsRUFDWjt3QkFDSSxVQUFVLEVBQUUsSUFBSTt3QkFDaEIsWUFBWSxFQUFFOzRCQUNWLElBQUksRUFBRSxFQUFFLENBQUMsUUFBUSxDQUFDLDhCQUE4QixFQUFFLFNBQVMsQ0FBQzt5QkFDL0Q7d0JBQ0QsWUFBWSxFQUFFOzRCQUNWLElBQUksRUFBRSxFQUFFLENBQUMsUUFBUSxDQUFDLDhCQUE4QixFQUFFLFFBQVEsQ0FBQzt5QkFDOUQ7d0JBQ0QsSUFBSSxFQUFFLE9BQU87d0JBQ2IsU0FBUyxFQUFFLElBQUk7cUJBQ2xCLENBQ0osRUFDSCxDQUFDO3dCQUNDLE9BQU87b0JBQ1gsQ0FBQztnQkFDTCxDQUFDO3FCQUFNLENBQUM7b0JBQ0osTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsQ0FBQztvQkFFN0IsTUFBTSxZQUFZLEdBQWEsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7b0JBQzVGLElBQUksT0FBTyxHQUFHLEtBQUssRUFBRSxDQUFDLFFBQVEsQ0FBQyxxQ0FBcUMsRUFBRSxTQUFTLENBQUMsUUFBUSxDQUFDO29CQUN6RixzQkFBSSxZQUFZLENBQUMsTUFBTSxFQUFLLENBQUMsR0FBRSxDQUFDO3dCQUM1Qiw4QkFBTyxFQUFJLEdBQUcsWUFBWSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUM7b0JBQ3BDLENBQUM7eUJBQU0sQ0FBQzt3QkFDSiw4QkFBTyxFQUFJLFlBQVksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxLQUFLLElBQUksRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFDO29CQUNoRSxDQUFDO29CQUVELE1BQU0sMkJBQWEsRUFDZixJQUFJLEVBQ0osTUFBTSxFQUNOLEVBQUUsQ0FBQyxRQUFRLENBQUMscUNBQXFDLEVBQUUsU0FBUyxDQUFDLEVBQzdELEdBQUcsT0FBTyxFQUFFLEVBQ1o7d0JBQ0ksWUFBWSxFQUFFOzRCQUNWLElBQUksRUFBRSxFQUFFLENBQUMsUUFBUSxDQUFDLGlDQUFpQyxFQUFFLElBQUksQ0FBQzt5QkFDN0Q7d0JBQ0QsSUFBSSxFQUFFLE9BQU87d0JBQ2IsU0FBUyxFQUFFLElBQUk7cUJBQ2xCLENBQ0osQ0FBQztvQkFFRjtvQkFDSSx5R0FBeUc7b0JBQ3pHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUssSUFBSSxDQUFDLHFCQUFxQixDQUFDLEdBQUcsR0FDckUsQ0FBQzs7d0JBQ0MsMkRBQUksQ0FBQyxXQUFXLFNBQUc7cUJBQ3RCO2dCQUNMLENBQUM7WUFDTCxDQUFDO1lBQ0QsZ0JBQUksSUFBSSxDQUFDLFdBQVcsRUFBRyxDQUFDLEdBQUUsQ0FBQztnQkFDdkIsSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGtDQUFrQyxFQUFFO29CQUNuRCxJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsSUFBSTtvQkFDM0IsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUs7b0JBQ2hELGdCQUFnQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7aUJBQzNDLENBQUMsQ0FBQztZQUNQLENBQUM7aUJBQU0sQ0FBQztnQkFDSixNQUFNLDJCQUFhLEVBQ2YsSUFBSSxFQUNKLFNBQVMsRUFDVCxFQUFFLENBQUMsUUFBUSxDQUFDLHFDQUFxQyxFQUFFLFNBQVMsQ0FBQyxFQUM3RCxFQUFFLENBQUMsUUFBUSxDQUFDLGdEQUFnRCxFQUFFLGtCQUFrQixDQUFDLENBQ3BGLENBQUM7Z0JBQ0YsSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLDhCQUE4QixDQUFDLENBQUM7WUFDdkQsQ0FBQztRQUNMLENBQUM7S0FDSixDQUFDO3lEQUMwQjtBQUs1QjtJQUhDLEVBQUUsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFzQjtRQUN4QyxhQUFhLEVBQUUsSUFBSTtLQUN0QixDQUFDO3dEQUNpQztBQVFuQztJQU5DLEVBQUUsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFzQjtRQUN0QyxhQUFhLEVBQUUsSUFBSTtRQUNuQixNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQzVCLENBQUM7S0FDSixDQUFDO3NEQUM2QjtBQWEvQjtJQVhDLEVBQUUsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFnQztRQUN6RCxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQzFCLENBQUM7UUFDRCxLQUFLLG9HQUFpQjtRQUN0QixJQUFJLEVBQUUsOEJBQThCO1FBQ3BDLFVBQVUsRUFBRSxNQUFNO1FBQ2xCLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLFVBQVUsRUFBRSxJQUFJO1FBQ2hCLFNBQVMsRUFBRSxLQUFLO0tBQ25CLENBQUM7eURBQzBDO0FBVTVDO0lBUkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXNCO1FBQzFDLE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7UUFDMUIsQ0FBQztRQUNELEtBQUssZ0dBQWU7UUFDcEIsV0FBVyxFQUFFLElBQUk7UUFDakIsVUFBVSxFQUFFLElBQUk7S0FDbkIsQ0FBQzt1REFDeUI7QUFhM0I7SUFYQyxFQUFFLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBcUM7UUFDOUQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztRQUMxQixDQUFDO1FBQ0QsS0FBSyxrR0FBZ0I7UUFDckIsSUFBSSxFQUFFLG9DQUFvQztRQUMxQyxVQUFVLEVBQUUsTUFBTTtRQUNsQixXQUFXLEVBQUUsSUFBSTtRQUNqQixVQUFVLEVBQUUsSUFBSTtRQUNoQixTQUFTLEVBQUUsS0FBSztLQUNuQixDQUFDO3dEQUM4QztBQWFoRDtJQVhDLEVBQUUsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFzQjtRQUM3QyxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQzFCLENBQUM7UUFDRCxLQUFLLGdIQUFvQjtRQUN6QixXQUFXLG9IQUFrQjtRQUM3QixXQUFXLEVBQUUsSUFBSTtRQUNqQixXQUFXLEVBQUUsSUFBSTtRQUNqQixTQUFTLEVBQUUsSUFBSTtRQUNmLEdBQUcsRUFBRSxDQUFDO0tBQ1QsQ0FBQztrRUFDdUM7QUFjekM7SUFaQyxFQUFFLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBc0I7UUFDNUMsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztRQUMxQixDQUFDO1FBQ0QsS0FBSyw0RkFBYTtRQUNsQixXQUFXLHFHQUFnQjtRQUMzQixXQUFXLEVBQUUsSUFBSTtRQUNqQixXQUFXLEVBQUUsSUFBSTtRQUNqQixRQUFRO1lBQ0osSUFBSSxDQUFDLFFBQVEsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUM7UUFDOUMsQ0FBQztLQUNKLENBQUM7cURBQ3lCO0FBaUkzQjtJQS9IQyxFQUFFLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBMEM7UUFDbkUsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztRQUMxQixDQUFDO1FBQ0QsS0FBSyxvSEFBMkI7UUFDaEMsV0FBVyxvSEFBcUI7UUFDaEMsSUFBSSxFQUFFLHdDQUF3QztRQUM5QyxVQUFVLEVBQUUsTUFBTTtRQUNsQixXQUFXLEVBQUUsSUFBSTtRQUNqQixXQUFXLEVBQUUsS0FBSztRQUNsQixXQUFXLEVBQUUsSUFBSTtRQUNqQixtQkFBbUIsRUFBRSxJQUFJO1FBQ3pCLCtCQUErQixFQUFFLElBQUk7UUFDckMsU0FBUyxFQUFFLEtBQUs7UUFDaEIsK0dBQStHO1FBQy9HLE1BQU07WUFDRixNQUFNLE1BQU0sR0FBK0I7Z0JBQ3ZDLFNBQVMsRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUU7Z0JBQzFDLFFBQVEsRUFBRSxFQUFFLFFBQVEsRUFBRSxFQUFFLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxFQUFFLEVBQUUsRUFBRSw0Q0FBNEM7Z0JBQ3hGLFFBQVEsRUFBRSxFQUFFLEdBQUcsRUFBRSxJQUFJLEVBQUU7Z0JBQ3ZCLHdFQUF3RTtnQkFDeEUsSUFBSSxFQUFFO29CQUNGO3dCQUNJLEdBQUcsRUFBRTs0QkFDRCxFQUFFLGVBQWUsRUFBRSxFQUFFLEdBQUcsRUFBRSxLQUFLLEVBQUUsRUFBRTs0QkFDbkM7Z0NBQ0ksZUFBZSxFQUFFLEVBQUUsR0FBRyxFQUFFLElBQUksRUFBRSxFQUFFLDhFQUE4RTtnQ0FDOUcsS0FBSyxFQUFFLEVBQUUsUUFBUSxFQUFFLENBQUMsRUFBRSxPQUFPLEVBQUUsSUFBSSxDQUFDLFFBQVEsRUFBRSxLQUFLLEVBQUUsSUFBSSxFQUFFOzZCQUM5RDs0QkFDRDtnQ0FDSSxlQUFlLEVBQUUsRUFBRSxHQUFHLEVBQUUsSUFBSSxFQUFFLEVBQUUsOEVBQThFO2dDQUM5RyxLQUFLLEVBQUUsRUFBRSxLQUFLLEVBQUUsSUFBSSxFQUFFOzZCQUN6Qjt5QkFDSjtxQkFDSjtpQkFDSjthQUNKLENBQUM7WUFFRixpQ0FBaUM7WUFDakMsb0NBQW9DO1lBQ3BDLDhEQUE4RDtZQUM5RCxJQUFJO1lBRUosSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUUsQ0FBQztnQkFDOUIsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7b0JBQ2IsR0FBRyxFQUFFO3dCQUNEOzRCQUNJLFFBQVEsRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUU7eUJBQ2pEO3dCQUNEOzRCQUNJLG1FQUFtRTs0QkFDbkUsSUFBSSxFQUFFLENBQUMsRUFBRSxRQUFRLEVBQUUsRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLEVBQUUsRUFBRSxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsQ0FBQzt5QkFDM0Q7cUJBQ0o7aUJBQ0osQ0FBQyxDQUFDO1lBQ1AsQ0FBQztZQUVELE9BQU8sTUFBTSxDQUFDO1FBQ2xCLENBQUM7UUFDRCxLQUFLLENBQUMsUUFBUTtZQUNWLElBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ2pDLElBQUksQ0FBQyxVQUFVLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztnQkFDbkMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDO2dCQUM3QixJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUM7Z0JBQzVCLE1BQU0sSUFBSSxDQUFDLENBQUMsQ0FBQyw2QkFBNkIsRUFBRSxDQUFDLENBQUMsbUlBQW1JO2dCQUNqTCxPQUFPO1lBQ1gsQ0FBQztZQUVELHVGQUF1RjtZQUN2RixvREFBb0Q7WUFDcEQsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ3pCLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDO1lBQ25FLENBQUM7WUFDRCxJQUFJLENBQUMsVUFBVSxDQUFDLFVBQVUsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUM7WUFFdEUsSUFBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSxDQUFDO2dCQUMzQyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQztZQUNuRSxDQUFDO1lBRUQsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLDZCQUE2QixFQUFFLENBQUM7WUFDN0MsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQztRQUN4RCxDQUFDO1FBQ0QsT0FBTyxFQUFFO1lBQ0wsRUFBRSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUM7Z0JBQ2pCLElBQUksRUFBRSxNQUFNO2dCQUNaLEtBQUssZ0lBQXdCO2dCQUM3QixVQUFVLEVBQUUsSUFBSTthQUNuQixDQUFDO1lBQ0YsRUFBRSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUM7Z0JBQ3RCLElBQUksRUFBRSw4QkFBOEI7Z0JBQ3BDLElBQUksRUFBRSxVQUFVO2dCQUNoQixVQUFVLEVBQUUsTUFBTTtnQkFDbEIsS0FBSyw4SEFBWTtnQkFDakIsVUFBVSxFQUFFLElBQUk7YUFDbkIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDO2dCQUN0QixJQUFJLEVBQUUsZ0NBQWdDO2dCQUN0QyxJQUFJLEVBQUUsV0FBVztnQkFDakIsVUFBVSxFQUFFLE1BQU07Z0JBQ2xCLEtBQUssZ0lBQWE7Z0JBQ2xCLFVBQVUsRUFBRSxJQUFJO2FBQ25CLENBQUM7WUFDRixFQUFFLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDbEIsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsS0FBSyxvSEFBVTtnQkFDZixHQUFHLENBQUMsS0FBVSxFQUFFLE9BQTJCO29CQUN2QyxRQUFRLEtBQUssRUFBRSxDQUFDO3dCQUNaLEtBQUssTUFBTTs0QkFDUCxPQUFPLE1BQU0sQ0FBQzt3QkFDbEIsS0FBSyxTQUFTOzRCQUNWLE9BQU8sVUFBVSxDQUFDO3dCQUN0Qjs0QkFDSSxPQUFPLEVBQUUsQ0FBQztvQkFDbEIsQ0FBQztnQkFDTCxDQUFDO2dCQUNELFdBQVcsRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLGFBQWE7Z0JBQ3BDLFVBQVUsRUFBRSxnQ0FBZ0M7YUFDL0MsQ0FBQztZQUNGLGlIQUFpSDtZQUNqSCxFQUFFLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBb0Q7Z0JBQ3pFLElBQUksRUFBRSw4QkFBOEI7Z0JBQ3BDLElBQUksRUFBRSxVQUFVO2dCQUNoQixVQUFVLEVBQUUsTUFBTTtnQkFDbEIsUUFBUSxFQUFFLElBQUk7YUFDakIsQ0FBQztTQUNMO0tBQ0osQ0FBQzsrREFDMEQ7QUFlNUQ7SUFiQyxFQUFFLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBaUM7UUFDMUQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztRQUMxQixDQUFDO1FBQ0QsS0FBSyxnR0FBZ0I7UUFDckIsSUFBSSxFQUFFLGdDQUFnQztRQUN0QyxVQUFVLEVBQUUsTUFBTTtRQUNsQixXQUFXLEVBQUUsSUFBSTtRQUNqQixVQUFVLEVBQUUsSUFBSTtRQUNoQixXQUFXLEVBQUUsS0FBSztRQUNsQixXQUFXLEVBQUUsSUFBSTtRQUNqQixTQUFTLEVBQUUsS0FBSztLQUNuQixDQUFDO3NEQUN3QztBQWtEMUM7SUFoREMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQWdDO1FBQ3pELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7UUFDMUIsQ0FBQztRQUNELEtBQUssZ0dBQWU7UUFDcEIsV0FBVyw0R0FBcUI7UUFDaEMsSUFBSSxFQUFFLDhCQUE4QjtRQUNwQyxVQUFVLEVBQUUsTUFBTTtRQUNsQixXQUFXLEVBQUUsSUFBSTtRQUNqQixXQUFXLEVBQUUsSUFBSTtRQUNqQixXQUFXLEVBQUUsSUFBSTtRQUNqQixtQkFBbUIsRUFBRSxJQUFJO1FBQ3pCLHlCQUF5QjtRQUN6QiwrQkFBK0IsRUFBRSxJQUFJO1FBQ3JDLFNBQVMsRUFBRSxLQUFLO1FBQ2hCLE1BQU07WUFDRixPQUFPO2dCQUNILFNBQVMsRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUU7Z0JBQzFDLCtIQUErSDtnQkFDL0gsNEJBQTRCO2dCQUM1QixRQUFRLEVBQUUsRUFBRSxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsRUFBRSxFQUFFLDRCQUE0QjthQUM3RCxDQUFDO1FBQ04sQ0FBQztRQUNELFFBQVE7WUFDSixJQUFJLENBQUM7Z0JBQ0QsSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUs7b0JBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUM7WUFDM0UsQ0FBQztZQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsRUFBQztRQUNsQixDQUFDO1FBQ0QsT0FBTyxFQUFFO1lBQ0wsRUFBRSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUM7Z0JBQ2pCLElBQUksRUFBRSxNQUFNO2dCQUNaLEtBQUssd0dBQVE7Z0JBQ2IsVUFBVSxFQUFFLElBQUk7YUFDbkIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNqQixJQUFJLEVBQUUsTUFBTTtnQkFDWixLQUFLLHdHQUFRO2dCQUNiLFVBQVUsRUFBRSxJQUFJO2FBQ25CLENBQUM7WUFDRiw0R0FBNEc7WUFDNUcsRUFBRSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQXNDO2dCQUMzRCxJQUFJLEVBQUUsc0JBQXNCO2dCQUM1QixJQUFJLEVBQUUsV0FBVztnQkFDakIsVUFBVSxFQUFFLE1BQU07Z0JBQ2xCLFFBQVEsRUFBRSxJQUFJO2FBQ2pCLENBQUM7U0FDTDtLQUNKLENBQUM7dURBQ3dDO0FBOEMxQztJQTVDQyxFQUFFLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUEyQjtRQUN2RCxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQzFCLENBQUM7UUFDRCxLQUFLLGlGQUFPO1FBQ1osV0FBVyxxR0FBcUI7UUFDaEMsSUFBSSxFQUFFLHlCQUF5QjtRQUMvQixVQUFVLEVBQUUsTUFBTTtRQUNsQixxRUFBcUU7UUFDckUsa0JBQWtCLEVBQUUsSUFBSTtRQUN4QixXQUFXLEVBQUUsSUFBSTtRQUNqQixXQUFXLEVBQUUsSUFBSTtRQUNqQixZQUFZLEVBQUUsSUFBSTtRQUNsQixVQUFVLEVBQUUsZUFBZSxFQUFFLHVFQUF1RTtRQUNwRyxtQkFBbUIsRUFBRSxDQUFDO1FBQ3RCLFNBQVMsRUFBRSxLQUFLO1FBQ2hCLE1BQU07WUFDRixPQUFPO2dCQUNILE9BQU8sRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUU7YUFDOUMsQ0FBQztRQUNOLENBQUM7UUFDRCxLQUFLLENBQUMsUUFBUTtZQUNWLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUNsQixxSUFBcUk7Z0JBQ3JJLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsTUFBTSxFQUFFLENBQUM7b0JBQ3hELElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztvQkFDekIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO2dCQUNuQyxDQUFDO2dCQUNELE9BQU87WUFDWCxDQUFDO1lBRUQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7WUFDOUMsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLDZCQUE2QixFQUFFLENBQUM7WUFDN0MsTUFBTSxJQUFJLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBRSxDQUFDO1lBQzFCLElBQUksQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxFQUFFLEtBQUssRUFBRSxDQUFDO1lBRXJDLDZDQUE2QztZQUM3Qyw2QkFBNkI7WUFDN0IsOEVBQThFO1lBQzlFLCtDQUErQztZQUMvQyxxQ0FBcUM7WUFDckMsSUFBSTtRQUNSLENBQUM7S0FDSixDQUFDO2dEQUMrQjtBQWVqQztJQWJDLEVBQUUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFzQjtRQUMxQyxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQzFCLENBQUM7UUFDRCxLQUFLLHVGQUFVO1FBQ2YsV0FBVyxvR0FBaUI7UUFDNUIsV0FBVyxFQUFFLElBQUk7UUFDakIsV0FBVyxFQUFFLElBQUk7UUFDakIsVUFBVSxFQUFFLFlBQVk7UUFDeEIsUUFBUTtZQUNKLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLO2dCQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLFdBQVcsRUFBRSxDQUFDO1FBQy9FLENBQUM7S0FDSixDQUFDO21EQUNxQjtBQVl2QjtJQVZDLEVBQUUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFzQjtRQUMxQyxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQzFCLENBQUM7UUFDRCxLQUFLLG9HQUFpQjtRQUN0QixXQUFXLGlIQUF3QjtRQUNuQyxXQUFXLEVBQUUsSUFBSTtRQUNqQixXQUFXLEVBQUUsSUFBSTtRQUNqQixVQUFVLEVBQUUsWUFBWTtLQUMzQixDQUFDO3lEQUMyQjs4QkE1aUJwQixtQkFBbUI7SUFyQy9CLEVBQUUsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFzQjtRQUNyQyxLQUFLLGdGQUFXO1FBQ2hCLFFBQVEseUZBQWlCO1FBQ3pCLGFBQWEsRUFBRSxJQUFJO1FBQ25CLFdBQVcsRUFBRSxJQUFJLEVBQUUsdUZBQXVGO1FBQzFHLElBQUksRUFBRSxTQUFTO1FBQ2YsS0FBSyxDQUFDLE1BQU07WUFDUixJQUFJLENBQUM7Z0JBQ0QsSUFBSSxDQUFDLFdBQVcsR0FBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxVQUFxQixJQUFJLENBQUMsQ0FBQztnQkFDdEUseUdBQXlHO2dCQUN6RyxNQUFNLElBQUksQ0FBQyxlQUFlLENBQ3RCLElBQUksQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLGdCQUEwQixFQUNqRCxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBVyxDQUFDLENBQ2hFLENBQUM7WUFDTixDQUFDO1lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztnQkFDVCxvRUFBb0U7Z0JBQ3BFLEVBQUUsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLHdDQUF3QyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2dCQUU1RCxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FDWixFQUFFLENBQUMsUUFBUSxDQUFDLGtEQUFrRCxFQUFFLDZCQUE2QixDQUFDLEVBQzlGLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxDQUNwQixDQUFDO2dCQUNGLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO2dCQUNuRCxPQUFPO1lBQ1gsQ0FBQztRQUNMLENBQUM7UUFDRCxVQUFVO1lBQ04sT0FBTztnQkFDSCxLQUFLLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtnQkFDOUIsS0FBSyxFQUFFLElBQUksQ0FBQyxhQUFhO2dCQUN6QixLQUFLLEVBQUUsSUFBSSxDQUFDLHNCQUFzQjthQUNyQyxDQUFDO1FBQ04sQ0FBQztRQUNELGVBQWU7WUFDWCxPQUFPLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDcEQsQ0FBQztLQUNKLENBQUM7R0FDVyxtQkFBbUIsQ0E4dUIvQiIsInNvdXJjZXMiOlsid2VicGFjazovL3h0cmVtQXJ0aWZhY3QvLi9saWIvcGFnZXMvbW9iaWxlLXB1dGF3YXktZGV0YWlsLnRzP2FhZWIiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29udGFpbmVyLCBQcm9kdWN0LCBVbml0T2ZNZWFzdXJlIH0gZnJvbSAnQHNhZ2UveDMtbWFzdGVyLWRhdGEtYXBpJztcbmltcG9ydCB7IGRpYWxvZ0NvbmZpcm1hdGlvbiwgZGlhbG9nTWVzc2FnZSB9IGZyb20gJ0BzYWdlL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL2RpYWxvZ3MnO1xuaW1wb3J0IHsgR3JhcGhBcGksIFN0b3JhZ2VEZXRhaWxzIH0gZnJvbSAnQHNhZ2UveDMtc3RvY2stYXBpJztcbmltcG9ydCB7IExpY2Vuc2VQbGF0ZU51bWJlciwgTG9jYXRpb24sIExvdCwgU3RvY2tTdGF0dXNJbnB1dCB9IGZyb20gJ0BzYWdlL3gzLXN0b2NrLWRhdGEtYXBpJztcbmltcG9ydCB7IFNpdGUgfSBmcm9tICdAc2FnZS94My1zeXN0ZW0tYXBpJztcbmltcG9ydCB7IENsaWVudEVycm9yLCBFcnJvckRldGFpbCwgRXh0cmFjdEVkZ2VzUGFydGlhbCwgRmlsdGVyLCBleHRyYWN0RWRnZXMgfSBmcm9tICdAc2FnZS94dHJlbS1jbGllbnQnO1xuaW1wb3J0IHsgRGVjaW1hbCB9IGZyb20gJ0BzYWdlL3h0cmVtLWRlY2ltYWwnO1xuaW1wb3J0IHsgQXBpRXJyb3IgfSBmcm9tICdAc2FnZS94dHJlbS1zaGFyZWQnO1xuaW1wb3J0ICogYXMgdWkgZnJvbSAnQHNhZ2UveHRyZW0tdWknO1xuaW1wb3J0IHsgdmFsaWRhdGVXaXRoRGV0YWlscyB9IGZyb20gJy4uL2NsaWVudC1mdW5jdGlvbnMvY29udHJvbCc7XG5cbkB1aS5kZWNvcmF0b3JzLnBhZ2U8TW9iaWxlUHV0YXdheURldGFpbD4oe1xuICAgIHRpdGxlOiAnUHV0YXdheScsXG4gICAgc3VidGl0bGU6ICdFbnRlciBkZXRhaWxzJyxcbiAgICBpc1RpdGxlSGlkZGVuOiB0cnVlLFxuICAgIGlzVHJhbnNpZW50OiB0cnVlLCAvLyBtYWtlIHRoaXMgYSBmdWxseSB0cmFuc2llbnQgcGFnZSBieSBkZXJpdmluZyBhbGwgbmVjZXNzYXJ5IGRhdGEgZnJvbSBjdXJyZW50IHNlc3Npb25cbiAgICBtb2RlOiAnZGVmYXVsdCcsXG4gICAgYXN5bmMgb25Mb2FkKCkge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgdGhpcy5fdG90YWxDb3VudCA9ICh0aGlzLiQucXVlcnlQYXJhbWV0ZXJzLnRvdGFsQ291bnQgYXMgbnVtYmVyKSA/PyAwO1xuICAgICAgICAgICAgLy8gVE9ETyBJc3N1ZTogVGhlIHNlcmlhbGl6ZWQgb2JqZWN0IGlzIGFjdHVhbGx5IG9mIHR5cGUgRXh0cmFjdEVkZ2VzPFN0b3JhZ2VEZXRhaWxzPiwgbm90IFN0b3JhZ2VEZXRhaWxzXG4gICAgICAgICAgICBhd2FpdCB0aGlzLl9pbml0aWFsaXplUGFnZShcbiAgICAgICAgICAgICAgICB0aGlzLiQucXVlcnlQYXJhbWV0ZXJzLnN0b2NrVHJhbnNhY3Rpb24gYXMgc3RyaW5nLFxuICAgICAgICAgICAgICAgIEpTT04ucGFyc2UodGhpcy4kLnN0b3JhZ2UuZ2V0KCdNb2JpbGVQdXRhd2F5VG9kbycpIGFzIHN0cmluZyksXG4gICAgICAgICAgICApO1xuICAgICAgICB9IGNhdGNoIChlKSB7XG4gICAgICAgICAgICAvLyBJZiBzZXNzaW9uIGdvdCBjb3JydXB0ZWQgb3IgcmV0aXJlZCwgdGhlbiByZXR1cm4gYmFjayB0byAxc3QgcGFnZVxuICAgICAgICAgICAgdWkuY29uc29sZS5sb2coYE1pc3NpbmcgcmVxdWlyZWQgcGFyYW1ldGVycyBkdWUgdG9cXFxcbiR7ZX1gKTtcblxuICAgICAgICAgICAgdGhpcy4kLnNob3dUb2FzdChcbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svbm90aWZpY2F0aW9uLWVycm9yLW1pc3NpbmctcGFyYW1zJywgJ01pc3NpbmcgcmVxdWlyZWQgcGFyYW1ldGVycycpLFxuICAgICAgICAgICAgICAgIHsgdHlwZTogJ2Vycm9yJyB9LFxuICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIHRoaXMuJC5yb3V0ZXIuZ29UbygnQHNhZ2UveDMtc3RvY2svTW9iaWxlUHV0YXdheScpO1xuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG4gICAgfSxcbiAgICBoZWFkZXJDYXJkKCkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgdGl0bGU6IHRoaXMuX3N0b3JhZ2VMaXN0TnVtYmVyLFxuICAgICAgICAgICAgbGluZTI6IHRoaXMuaGVhZGVyUHJvZHVjdCxcbiAgICAgICAgICAgIGxpbmUzOiB0aGlzLl9sb2NhbGl6ZWREZXNjcmlwdGlvbjEsXG4gICAgICAgIH07XG4gICAgfSxcbiAgICBidXNpbmVzc0FjdGlvbnMoKSB7XG4gICAgICAgIHJldHVybiBbdGhpcy5wcmV2aW91c0J1dHRvbiwgdGhpcy5zdWJtaXRCdXR0b25dO1xuICAgIH0sXG59KVxuZXhwb3J0IGNsYXNzIE1vYmlsZVB1dGF3YXlEZXRhaWwgZXh0ZW5kcyB1aS5QYWdlPEdyYXBoQXBpPiB7XG4gICAgcHJpdmF0ZSBfdG90YWxDb3VudDogbnVtYmVyOyAvLyB0b3RhbCByZW1haW5pbmcgc3RvcmFnZSB3b3Jrc2hlZXQgbGluZXMgdG8gcHJvY2VzcywgaW5jbHVkaW5nIHRoaXMgb25lIGN1cnJlbnRseSBzaG93biB0byB0aGUgdXNlclxuICAgIHByaXZhdGUgX3N0b2NrVHJhbnNhY3Rpb246IHN0cmluZztcbiAgICBwcml2YXRlIF9zdG9yYWdlRGV0YWlsczogRXh0cmFjdEVkZ2VzUGFydGlhbDxTdG9yYWdlRGV0YWlscz47XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5yZWZlcmVuY2VGaWVsZDxNb2JpbGVQdXRhd2F5RGV0YWlsLCBTaXRlPih7XG4gICAgICAgIGlzVHJhbnNpZW50OiB0cnVlLFxuICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICAgICAgbm9kZTogJ0BzYWdlL3gzLXN5c3RlbS9TaXRlJyxcbiAgICAgICAgdmFsdWVGaWVsZDogJ2NvZGUnLFxuICAgICAgICBjYW5GaWx0ZXI6IGZhbHNlLFxuICAgIH0pXG4gICAgX3NpdGU6IHVpLmZpZWxkcy5SZWZlcmVuY2U8U2l0ZT47XG5cbiAgICBAdWkuZGVjb3JhdG9ycy50ZXh0RmllbGQ8TW9iaWxlUHV0YXdheURldGFpbD4oe1xuICAgICAgICBpc1RyYW5zaWVudDogdHJ1ZSxcbiAgICAgICAgaXNIaWRkZW46IGZhbHNlLFxuICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgIH0pXG4gICAgX3N0b3JhZ2VMaXN0TnVtYmVyOiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnJlZmVyZW5jZUZpZWxkPE1vYmlsZVB1dGF3YXlEZXRhaWwsIFByb2R1Y3Q+KHtcbiAgICAgICAgaXNUcmFuc2llbnQ6IHRydWUsXG4gICAgICAgIGlzSGlkZGVuOiBmYWxzZSxcbiAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgbm9kZTogJ0BzYWdlL3gzLW1hc3Rlci1kYXRhL1Byb2R1Y3QnLFxuICAgICAgICB2YWx1ZUZpZWxkOiAnY29kZScsXG4gICAgICAgIGNhbkZpbHRlcjogZmFsc2UsXG4gICAgfSlcbiAgICBfcHJvZHVjdDogdWkuZmllbGRzLlJlZmVyZW5jZTxQcm9kdWN0PjtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQdXRhd2F5RGV0YWlsPih7XG4gICAgICAgIGlzVHJhbnNpZW50OiB0cnVlLFxuICAgICAgICBpc0hpZGRlbjogZmFsc2UsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgfSlcbiAgICBoZWFkZXJQcm9kdWN0OiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQdXRhd2F5RGV0YWlsPih7XG4gICAgICAgIGlzVHJhbnNpZW50OiB0cnVlLFxuICAgICAgICBpc0hpZGRlbjogZmFsc2UsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgIC8vIG5vZGU6ICdAc2FnZS94dHJlbS14My1tYXN0ZXItZGF0YS9Qcm9kdWN0JyxcbiAgICAgICAgLy8gdmFsdWVGaWVsZDogJ2xvY2FsaXplZERlc2NyaXB0aW9uMScsXG4gICAgfSlcbiAgICBfbG9jYWxpemVkRGVzY3JpcHRpb24xOiB1aS5maWVsZHMuVGV4dDtcblxuICAgIC8qXG4gICAgICpcbiAgICAgKiAgUGFnZSBBY3Rpb25zXG4gICAgICpcbiAgICAgKi9cblxuICAgIEB1aS5kZWNvcmF0b3JzLnBhZ2VBY3Rpb248TW9iaWxlUHV0YXdheURldGFpbD4oe1xuICAgICAgICB0aXRsZTogJ1ByZXZpb3VzJyxcbiAgICAgICAgc2hvcnRjdXQ6IFsnZjQnXSxcbiAgICAgICAgYnV0dG9uVHlwZTogJ3NlY29uZGFyeScsXG4gICAgICAgIG9uQ2xpY2soKSB7XG4gICAgICAgICAgICB0aGlzLiQucm91dGVyLmdvVG8oJ0BzYWdlL3gzLXN0b2NrL01vYmlsZVB1dGF3YXlUb2RvJywge1xuICAgICAgICAgICAgICAgIHNpdGU6IHRoaXMuX3NpdGUudmFsdWUuY29kZSxcbiAgICAgICAgICAgICAgICBzdG9yYWdlTGlzdE51bWJlcjogdGhpcy5fc3RvcmFnZUxpc3ROdW1iZXIudmFsdWUsXG4gICAgICAgICAgICAgICAgc3RvY2tUcmFuc2FjdGlvbjogdGhpcy5fc3RvY2tUcmFuc2FjdGlvbixcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9LFxuICAgIH0pXG4gICAgcHJldmlvdXNCdXR0b246IHVpLlBhZ2VBY3Rpb247XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5wYWdlQWN0aW9uPE1vYmlsZVB1dGF3YXlEZXRhaWw+KHtcbiAgICAgICAgdGl0bGU6ICdTdWJtaXQnLFxuICAgICAgICBzaG9ydGN1dDogWydmMiddLFxuICAgICAgICBidXR0b25UeXBlOiAncHJpbWFyeScsXG4gICAgICAgIGFzeW5jIG9uQ2xpY2soKSB7XG4gICAgICAgICAgICAvLyBwZXJmb3JtIGNsaWVudC1zaWRlIHZhbGlkYXRpb25cbiAgICAgICAgICAgIGlmICghKGF3YWl0IHZhbGlkYXRlV2l0aERldGFpbHModGhpcykpKSByZXR1cm47XG5cbiAgICAgICAgICAgIC8vIHRvIHByZXZlbnQgZXh0cmVtZSBzY2VuYXJpb3MgZnJvbSByYXBpZGx5IGNsaWNraW5nIHRoZSB1cGRhdGUgYnV0dG9uIG11bHRpcGxlIHRpbWVzXG4gICAgICAgICAgICB0aGlzLnN1Ym1pdEJ1dHRvbi5pc0Rpc2FibGVkID0gdHJ1ZTtcbiAgICAgICAgICAgIHRoaXMucHJldmlvdXNCdXR0b24uaXNEaXNhYmxlZCA9IHRydWU7XG4gICAgICAgICAgICB0aGlzLiQubG9hZGVyLmlzSGlkZGVuID0gZmFsc2U7XG4gICAgICAgICAgICBjb25zdCByZXN1bHQgPSBhd2FpdCB0aGlzLl9jYWxsUHJvY2Vzc0FQSSgpO1xuICAgICAgICAgICAgdGhpcy5zdWJtaXRCdXR0b24uaXNEaXNhYmxlZCA9IGZhbHNlO1xuICAgICAgICAgICAgdGhpcy5wcmV2aW91c0J1dHRvbi5pc0Rpc2FibGVkID0gZmFsc2U7XG4gICAgICAgICAgICB0aGlzLiQubG9hZGVyLmlzSGlkZGVuID0gdHJ1ZTtcblxuICAgICAgICAgICAgaWYgKCghcmVzdWx0LmVycm9ycyB8fCAhcmVzdWx0LmVycm9ycy5sZW5ndGgpICYmIHJlc3VsdCBpbnN0YW5jZW9mIEVycm9yKSB7XG4gICAgICAgICAgICAgICAgYXdhaXQgdGhpcy4kLnNvdW5kLmVycm9yKCk7XG4gICAgICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgICAgICBhd2FpdCBkaWFsb2dDb25maXJtYXRpb24oXG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgICAgICAgICAgICAgJ2Vycm9yJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctZXJyb3ItdGl0bGUnLCAnRXJyb3InKSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1zdG9jay9wYWdlc19jcmVhdGlvbl9lcnJvcl9jb25uZXhpb25fd2Vic2VydmljZV9jb250YWN0X2FkbWluaXN0cmF0b3InLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICdBbiBlcnJvciBoYXMgb2NjdXJyZWQgKGNvbm5lY3Rpb24gb3Igd2Vic2VydmljZSBlcnJvcikuIFBsZWFzZSBjb250YWN0IHlvdXIgYWRtaW5pc3RyYXRvci4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBhY2NlcHRCdXR0b246IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGV4dDogdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2J1dHRvbi1nb2JhY2snLCAnR28gYmFjaycpLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY2FuY2VsQnV0dG9uOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRleHQ6IHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9idXR0b24tY2FuY2VsJywgJ0NhbmNlbCcpLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgc2l6ZTogJ3NtYWxsJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIClcbiAgICAgICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICAgICAgYXdhaXQgdGhpcy4kLnJvdXRlci5yZWZyZXNoKCk7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgYXdhaXQgdGhpcy4kLnJvdXRlci5lbXB0eVBhZ2UoKTtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy4kLnJvdXRlci5nb1RvKCdAc2FnZS94My1zdG9jay9Nb2JpbGVQdXRhd2F5Jyk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKCghcmVzdWx0LmVycm9ycyB8fCAhcmVzdWx0LmVycm9ycy5sZW5ndGggfHwgcmVzdWx0LmVycm9ycy5sZW5ndGggPT09IDApICYmICFyZXN1bHQubWVzc2FnZSkge1xuICAgICAgICAgICAgICAgIHRoaXMuJC5zZXRQYWdlQ2xlYW4oKTtcbiAgICAgICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgICAgIC8vIHRvIGhhbmRsZSB0aGUgZWRneSBjYXNlIG9mIGRpcmVjdGluZyB1c2VyIGJhY2sgdG8gMm5kLCBub3QgMXN0LCBwYWdlIGlmIHVzZXIgaXMgZG9pbmcgYSBwYXJ0aWFsIHVwZGF0ZVxuICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9PT0gdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQubWF4XG4gICAgICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuX3RvdGFsQ291bnQtLTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIC8vc2V2ZXJpdHkgMyBhbmQgNCAtIGVycm9yXG4gICAgICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgICAgICByZXN1bHQuZXJyb3JzWzBdLmV4dGVuc2lvbnMuZGlhZ25vc2VzLmZpbHRlcihcbiAgICAgICAgICAgICAgICAgICAgICAgIChkOiB7IHNldmVyaXR5OiBudW1iZXI7IG1lc3NhZ2U6IGFueSB9KSA9PiBkLnNldmVyaXR5ID4gMiAmJiBkLm1lc3NhZ2UsXG4gICAgICAgICAgICAgICAgICAgICkubGVuZ3RoICE9PSAwXG4gICAgICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuJC5zb3VuZC5lcnJvcigpO1xuXG4gICAgICAgICAgICAgICAgICAgIGNvbnN0IG1lc3NhZ2VBcnJheTogc3RyaW5nW10gPSByZXN1bHQuZXJyb3JzWzBdLmV4dGVuc2lvbnMuZGlhZ25vc2VzWzBdLm1lc3NhZ2Uuc3BsaXQoYFxcbmApO1xuICAgICAgICAgICAgICAgICAgICBsZXQgbWVzc2FnZSA9IGAqKiR7dWkubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICAnQHNhZ2UveDMtc3RvY2svZGlhbG9nLWVycm9yLXB1dGF3YXktdXBkYXRlJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICdBbiBlcnJvciBoYXMgb2NjdXJyZWQgZHVyaW5nIFB1dGF3YXkgdXBkYXRlJyxcbiAgICAgICAgICAgICAgICAgICAgKX0qKlxcblxcbmA7XG4gICAgICAgICAgICAgICAgICAgIGlmIChtZXNzYWdlQXJyYXkubGVuZ3RoID09PSAxKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBtZXNzYWdlICs9IGAke21lc3NhZ2VBcnJheVswXX1gO1xuICAgICAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgbWVzc2FnZSArPSBtZXNzYWdlQXJyYXkubWFwKGl0ZW0gPT4gYCogJHtpdGVtfWApLmpvaW4oJ1xcbicpO1xuICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgICAgICAgICAgYXdhaXQgZGlhbG9nQ29uZmlybWF0aW9uKFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgJ2Vycm9yJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svZGlhbG9nLWVycm9yLXRpdGxlJywgJ0Vycm9yJyksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYCR7bWVzc2FnZX1gLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZnVsbFNjcmVlbjogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYWNjZXB0QnV0dG9uOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0ZXh0OiB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svYnV0dG9uLWdvYmFjaycsICdHbyBiYWNrJyksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhbmNlbEJ1dHRvbjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGV4dDogdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2J1dHRvbi1jYW5jZWwnLCAnQ2FuY2VsJyksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHNpemU6ICdzbWFsbCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG1kQ29udGVudDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgKVxuICAgICAgICAgICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuJC5zb3VuZC5zdWNjZXNzKCk7XG5cbiAgICAgICAgICAgICAgICAgICAgY29uc3QgbWVzc2FnZUFycmF5OiBzdHJpbmdbXSA9IHJlc3VsdC5lcnJvcnNbMF0uZXh0ZW5zaW9ucy5kaWFnbm9zZXNbMF0ubWVzc2FnZS5zcGxpdChgXFxuYCk7XG4gICAgICAgICAgICAgICAgICAgIGxldCBtZXNzYWdlID0gYCoqJHt1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svZGlhbG9nLXdhcm5pbmctdGl0bGUnLCAnV2FybmluZycpfSoqXFxuXFxuYDtcbiAgICAgICAgICAgICAgICAgICAgaWYgKG1lc3NhZ2VBcnJheS5sZW5ndGggPT09IDEpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIG1lc3NhZ2UgKz0gYCR7bWVzc2FnZUFycmF5WzBdfWA7XG4gICAgICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBtZXNzYWdlICs9IG1lc3NhZ2VBcnJheS5tYXAoaXRlbSA9PiBgKiAke2l0ZW19YCkuam9pbignXFxuJyk7XG4gICAgICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgICAgICBhd2FpdCBkaWFsb2dNZXNzYWdlKFxuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcyxcbiAgICAgICAgICAgICAgICAgICAgICAgICd3YXJuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctd2FybmluZy10aXRsZScsICdXYXJuaW5nJyksXG4gICAgICAgICAgICAgICAgICAgICAgICBgJHttZXNzYWdlfWAsXG4gICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYWNjZXB0QnV0dG9uOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRleHQ6IHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9idXR0b24tYWNjZXB0LW9rJywgJ09LJyksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBzaXplOiAnc21hbGwnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIG1kQ29udGVudDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICk7XG5cbiAgICAgICAgICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgICAgICAgICAgLy8gdG8gaGFuZGxlIHRoZSBlZGd5IGNhc2Ugb2YgZGlyZWN0aW5nIHVzZXIgYmFjayB0byAybmQsIG5vdCAxc3QsIHBhZ2UgaWYgdXNlciBpcyBkb2luZyBhIHBhcnRpYWwgdXBkYXRlXG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9PT0gdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQubWF4XG4gICAgICAgICAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5fdG90YWxDb3VudC0tO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMuX3RvdGFsQ291bnQgPiAwKSB7XG4gICAgICAgICAgICAgICAgdGhpcy4kLnJvdXRlci5nb1RvKCdAc2FnZS94My1zdG9jay9Nb2JpbGVQdXRhd2F5VG9kbycsIHtcbiAgICAgICAgICAgICAgICAgICAgc2l0ZTogdGhpcy5fc2l0ZS52YWx1ZS5jb2RlLFxuICAgICAgICAgICAgICAgICAgICBzdG9yYWdlTGlzdE51bWJlcjogdGhpcy5fc3RvcmFnZUxpc3ROdW1iZXIudmFsdWUsXG4gICAgICAgICAgICAgICAgICAgIHN0b2NrVHJhbnNhY3Rpb246IHRoaXMuX3N0b2NrVHJhbnNhY3Rpb24sXG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIGF3YWl0IGRpYWxvZ01lc3NhZ2UoXG4gICAgICAgICAgICAgICAgICAgIHRoaXMsXG4gICAgICAgICAgICAgICAgICAgICdzdWNjZXNzJyxcbiAgICAgICAgICAgICAgICAgICAgdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1zdWNjZXNzLXRpdGxlJywgJ1N1Y2Nlc3MnKSxcbiAgICAgICAgICAgICAgICAgICAgdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1zdWNjZXNzLXB1dGF3YXktY29tcGxldGUnLCAnUHV0YXdheSBjb21wbGV0ZScpLFxuICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICAgICAgdGhpcy4kLnJvdXRlci5nb1RvKCdAc2FnZS94My1zdG9jay9Nb2JpbGVQdXRhd2F5Jyk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgfSlcbiAgICBzdWJtaXRCdXR0b246IHVpLlBhZ2VBY3Rpb247XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5zZWN0aW9uPE1vYmlsZVB1dGF3YXlEZXRhaWw+KHtcbiAgICAgICAgaXNUaXRsZUhpZGRlbjogdHJ1ZSxcbiAgICB9KVxuICAgIG1haW5TZWN0aW9uOiB1aS5jb250YWluZXJzLlNlY3Rpb247XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5ibG9jazxNb2JpbGVQdXRhd2F5RGV0YWlsPih7XG4gICAgICAgIGlzVGl0bGVIaWRkZW46IHRydWUsXG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLm1haW5TZWN0aW9uO1xuICAgICAgICB9LFxuICAgIH0pXG4gICAgbWFpbkJsb2NrOiB1aS5jb250YWluZXJzLkJsb2NrO1xuXG4gICAgQHVpLmRlY29yYXRvcnMucmVmZXJlbmNlRmllbGQ8TW9iaWxlUHV0YXdheURldGFpbCwgTG9jYXRpb24+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMubWFpbkJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ0Zyb20gbG9jYXRpb24nLFxuICAgICAgICBub2RlOiAnQHNhZ2UveDMtc3RvY2stZGF0YS9Mb2NhdGlvbicsXG4gICAgICAgIHZhbHVlRmllbGQ6ICdjb2RlJyxcbiAgICAgICAgaXNUcmFuc2llbnQ6IHRydWUsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgIGNhbkZpbHRlcjogZmFsc2UsXG4gICAgfSlcbiAgICBmcm9tTG9jYXRpb246IHVpLmZpZWxkcy5SZWZlcmVuY2U8TG9jYXRpb24+O1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVB1dGF3YXlEZXRhaWw+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMubWFpbkJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ0Zyb20gc3RhdHVzJyxcbiAgICAgICAgaXNUcmFuc2llbnQ6IHRydWUsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgfSlcbiAgICBmcm9tU3RhdHVzOiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnJlZmVyZW5jZUZpZWxkPE1vYmlsZVB1dGF3YXlEZXRhaWwsIFVuaXRPZk1lYXN1cmU+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMubWFpbkJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ1BhY2tpbmcgdW5pdCcsXG4gICAgICAgIG5vZGU6ICdAc2FnZS94My1tYXN0ZXItZGF0YS9Vbml0T2ZNZWFzdXJlJyxcbiAgICAgICAgdmFsdWVGaWVsZDogJ2NvZGUnLFxuICAgICAgICBpc1RyYW5zaWVudDogdHJ1ZSxcbiAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgY2FuRmlsdGVyOiBmYWxzZSxcbiAgICB9KVxuICAgIHBhY2tpbmdVbml0OiB1aS5maWVsZHMuUmVmZXJlbmNlPFVuaXRPZk1lYXN1cmU+O1xuXG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVB1dGF3YXlEZXRhaWw+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMubWFpbkJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ1BhY2tpbmcgcXVhbnRpdHknLFxuICAgICAgICBwbGFjZWhvbGRlcjogJ0VudGVyIHF1YW50aXR5JyxcbiAgICAgICAgaXNUcmFuc2llbnQ6IHRydWUsXG4gICAgICAgIGlzTWFuZGF0b3J5OiB0cnVlLFxuICAgICAgICBpc05vdFplcm86IHRydWUsXG4gICAgICAgIG1pbjogMCxcbiAgICB9KVxuICAgIHF1YW50aXR5SW5QYWNraW5nVW5pdDogdWkuZmllbGRzLk51bWVyaWM7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5zZWxlY3RGaWVsZDxNb2JpbGVQdXRhd2F5RGV0YWlsPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLm1haW5CbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdUbyBzdGF0dXMnLFxuICAgICAgICBwbGFjZWhvbGRlcjogJ0VudGVyIHN0YXR1cycsXG4gICAgICAgIGlzTWFuZGF0b3J5OiB0cnVlLFxuICAgICAgICBpc0Z1bGxXaWR0aDogdHJ1ZSxcbiAgICAgICAgb25DaGFuZ2UoKSB7XG4gICAgICAgICAgICB0aGlzLnRvU3RhdHVzLmdldE5leHRGaWVsZCh0cnVlKT8uZm9jdXMoKTtcbiAgICAgICAgfSxcbiAgICB9KVxuICAgIHRvU3RhdHVzOiB1aS5maWVsZHMuU2VsZWN0O1xuXG4gICAgQHVpLmRlY29yYXRvcnMucmVmZXJlbmNlRmllbGQ8TW9iaWxlUHV0YXdheURldGFpbCwgTGljZW5zZVBsYXRlTnVtYmVyPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLm1haW5CbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdUbyBsaWNlbnNlIHBsYXRlIG51bWJlcicsXG4gICAgICAgIHBsYWNlaG9sZGVyOiAnU2NhbiBvciBzZWxlY3QuLi4nLFxuICAgICAgICBub2RlOiAnQHNhZ2UveDMtc3RvY2stZGF0YS9MaWNlbnNlUGxhdGVOdW1iZXInLFxuICAgICAgICB2YWx1ZUZpZWxkOiAnY29kZScsXG4gICAgICAgIGlzVHJhbnNpZW50OiB0cnVlLFxuICAgICAgICBpc01hbmRhdG9yeTogZmFsc2UsXG4gICAgICAgIGlzRnVsbFdpZHRoOiB0cnVlLFxuICAgICAgICBpc0F1dG9TZWxlY3RFbmFibGVkOiB0cnVlLFxuICAgICAgICBzaG91bGRTdWdnZXN0aW9uc0luY2x1ZGVDb2x1bW5zOiB0cnVlLFxuICAgICAgICBjYW5GaWx0ZXI6IGZhbHNlLFxuICAgICAgICAvLyAoWDMtMjM3NDU2KSBUT0RPIElzc3VlOiBMb29rdXAgcGFuZWwncyBsb2FkIG1vcmUgYnV0dG9uIGRvZXMgbm90IHdvcmsgZm9yIGxpY2Vuc2VQbGF0ZU51bWJlciByZWZlcmVuY2UgZmllbGRcbiAgICAgICAgZmlsdGVyKCkge1xuICAgICAgICAgICAgY29uc3QgZmlsdGVyOiBGaWx0ZXI8TGljZW5zZVBsYXRlTnVtYmVyPiA9IHtcbiAgICAgICAgICAgICAgICBzdG9ja1NpdGU6IHsgY29kZTogdGhpcy5fc2l0ZS52YWx1ZS5jb2RlIH0sXG4gICAgICAgICAgICAgICAgbG9jYXRpb246IHsgY2F0ZWdvcnk6IHsgX25pbjogWydkb2NrJ10gfSB9LCAvLyBsb2NhdGlvbiBjYXRlZ29yeSBtdXN0IG5vdCBiZSBhIGRvY2sgdHlwZVxuICAgICAgICAgICAgICAgIGlzQWN0aXZlOiB7IF9lcTogdHJ1ZSB9LFxuICAgICAgICAgICAgICAgIC8vIFRPRE86IExQTiBmaWx0ZXIgY3JpdGVyaWEgb24gc2luZ2xlLXByb2R1Y3QgJiBzaW5nbGUtbG90IG1hbmFnZWQgbHBuc1xuICAgICAgICAgICAgICAgIF9hbmQ6IFtcbiAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgX29yOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgeyBpc1NpbmdsZVByb2R1Y3Q6IHsgX2VxOiBmYWxzZSB9IH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpc1NpbmdsZVByb2R1Y3Q6IHsgX2VxOiB0cnVlIH0sIC8vIHRvIG5vdCBpbXBseSBpc1NpbmdsZVByb2R1Y3QgaXMgdHJ1ZSBoZXJlIGJlY2F1c2UgdGhpcyBwcm9wZXJ0eSBpcyBudWxsYWJsZVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBzdG9jazogeyBfYXRMZWFzdDogMSwgcHJvZHVjdDogdGhpcy5fcHJvZHVjdD8udmFsdWU/LmNvZGUgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaXNTaW5nbGVQcm9kdWN0OiB7IF9lcTogdHJ1ZSB9LCAvLyB0byBub3QgaW1wbHkgaXNTaW5nbGVQcm9kdWN0IGlzIHRydWUgaGVyZSBiZWNhdXNlIHRoaXMgcHJvcGVydHkgaXMgbnVsbGFibGVcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgc3RvY2s6IHsgX25vbmU6IHRydWUgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgfTtcblxuICAgICAgICAgICAgLy8gVE9ETzogQWRkIHRoZSBjb250YWluZXIgZmlsdGVyXG4gICAgICAgICAgICAvLyBpZiAodGhpcy5jb250YWluZXIudmFsdWU/LmNvZGUpIHtcbiAgICAgICAgICAgIC8vICAgICBmaWx0ZXIuY29udGFpbmVyID0geyBjb2RlOiB0aGlzLmNvbnRhaW5lci52YWx1ZS5jb2RlIH07XG4gICAgICAgICAgICAvLyB9XG5cbiAgICAgICAgICAgIGlmICh0aGlzLnRvTG9jYXRpb24udmFsdWU/LmNvZGUpIHtcbiAgICAgICAgICAgICAgICBmaWx0ZXIuX2FuZC5wdXNoKHtcbiAgICAgICAgICAgICAgICAgICAgX29yOiBbXG4gICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9jYXRpb246IHsgY29kZTogdGhpcy50b0xvY2F0aW9uLnZhbHVlLmNvZGUgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gdG8gYWxzbyBpbmNsdWRlIGVudHJpZXMgd2l0aG91dCBsb2NhdGlvbiB0aGF0IGhhdmUgJ2ZyZWUnIHN0YXR1c1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIF9hbmQ6IFt7IGxvY2F0aW9uOiB7IGNvZGU6IG51bGwgfSB9LCB7IHN0YXR1czogJ2ZyZWUnIH1dLFxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgcmV0dXJuIGZpbHRlcjtcbiAgICAgICAgfSxcbiAgICAgICAgYXN5bmMgb25DaGFuZ2UoKSB7XG4gICAgICAgICAgICBpZiAoIXRoaXMubGljZW5zZVBsYXRlTnVtYmVyLnZhbHVlKSB7XG4gICAgICAgICAgICAgICAgdGhpcy50b0xvY2F0aW9uLmlzRGlzYWJsZWQgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICB0aGlzLnRvTG9jYXRpb24udmFsdWUgPSBudWxsO1xuICAgICAgICAgICAgICAgIHRoaXMuY29udGFpbmVyLnZhbHVlID0gbnVsbDtcbiAgICAgICAgICAgICAgICBhd2FpdCB0aGlzLiQuY29tbWl0VmFsdWVBbmRQcm9wZXJ0eUNoYW5nZXMoKTsgLy8gd2l0aG91dCB0aGlzLCB3aGVuIHlvdSBjbGVhciBvdXQgTFBOIGFuZCB0aGVuLCB3aXRob3V0IHRhYmJpbmcgb3V0LCBjbGljayBMb2NhdGlvbidzIGxvb2t1cCBidXR0b24gZGlyZWN0bHksIG5vdGhpbmcgd2lsbCBoYXBwZW5cbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIC8vIFBvcHVsYXRlIGFuZCBkaXNhYmxlIFRvIExvY2F0aW9uIGZpZWxkIGlmIHNlbGVjdGVkIExQTiBpcyBhc3NvY2lhdGVkIHdpdGggYSBsb2NhdGlvblxuICAgICAgICAgICAgLy8gaWYgbG9jYXRpb24gaXMgTk9UIHBvcHVsYXRlZCBtYW51YWxseSBieSB0aGUgdXNlclxuICAgICAgICAgICAgaWYgKCF0aGlzLnRvTG9jYXRpb24udmFsdWUpIHtcbiAgICAgICAgICAgICAgICB0aGlzLnRvTG9jYXRpb24udmFsdWUgPSB0aGlzLmxpY2Vuc2VQbGF0ZU51bWJlci52YWx1ZS5sb2NhdGlvbjtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHRoaXMudG9Mb2NhdGlvbi5pc0Rpc2FibGVkID0gISF0aGlzLmxpY2Vuc2VQbGF0ZU51bWJlci52YWx1ZS5sb2NhdGlvbjtcblxuICAgICAgICAgICAgaWYgKHRoaXMubGljZW5zZVBsYXRlTnVtYmVyLnZhbHVlPy5jb250YWluZXIpIHtcbiAgICAgICAgICAgICAgICB0aGlzLmNvbnRhaW5lci52YWx1ZSA9IHRoaXMubGljZW5zZVBsYXRlTnVtYmVyLnZhbHVlLmNvbnRhaW5lcjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgYXdhaXQgdGhpcy4kLmNvbW1pdFZhbHVlQW5kUHJvcGVydHlDaGFuZ2VzKCk7XG4gICAgICAgICAgICB0aGlzLmxpY2Vuc2VQbGF0ZU51bWJlci5nZXROZXh0RmllbGQodHJ1ZSk/LmZvY3VzKCk7XG4gICAgICAgIH0sXG4gICAgICAgIGNvbHVtbnM6IFtcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAnY29kZScsXG4gICAgICAgICAgICAgICAgdGl0bGU6ICdMaWNlbnNlIFBsYXRlIE51bWJlcicsXG4gICAgICAgICAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnJlZmVyZW5jZSh7XG4gICAgICAgICAgICAgICAgbm9kZTogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvTG9jYXRpb24nLFxuICAgICAgICAgICAgICAgIGJpbmQ6ICdsb2NhdGlvbicsXG4gICAgICAgICAgICAgICAgdmFsdWVGaWVsZDogJ2NvZGUnLFxuICAgICAgICAgICAgICAgIHRpdGxlOiAnTG9jYXRpb24nLFxuICAgICAgICAgICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy5yZWZlcmVuY2Uoe1xuICAgICAgICAgICAgICAgIG5vZGU6ICdAc2FnZS94My1tYXN0ZXItZGF0YS9Db250YWluZXInLFxuICAgICAgICAgICAgICAgIGJpbmQ6ICdjb250YWluZXInLFxuICAgICAgICAgICAgICAgIHZhbHVlRmllbGQ6ICdjb2RlJyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ0NvbnRhaW5lcicsXG4gICAgICAgICAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLmxhYmVsKHtcbiAgICAgICAgICAgICAgICBiaW5kOiAnc3RhdHVzJyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ1N0YXR1cycsXG4gICAgICAgICAgICAgICAgbWFwKHZhbHVlOiBhbnksIHJvd0RhdGE6IExpY2Vuc2VQbGF0ZU51bWJlcikge1xuICAgICAgICAgICAgICAgICAgICBzd2l0Y2ggKHZhbHVlKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBjYXNlICdmcmVlJzpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gJ0ZyZWUnO1xuICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAnaW5TdG9jayc6XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuICdJbiBTdG9jayc7XG4gICAgICAgICAgICAgICAgICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiAnJztcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgYm9yZGVyQ29sb3I6IHVpLnRva2Vucy5jb2xvcnNZYW5nMTAwLFxuICAgICAgICAgICAgICAgIG9wdGlvblR5cGU6ICdAc2FnZS94My1zdG9jay9Db250YWluZXJTdGF0dXMnLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICAvLyBoaWRkZW4gbG9jYXRpb24gdHlwZSBjb2x1bW4gaW4gb3JkZXIgdG8gYXV0by1wb3B1bGF0ZSB0b0xvY2F0aW9uIGZpZWxkIHdpdGggQk9USCBjb2RlICYgdHlwZSBkdXJpbmcgb25DaGFuZ2UoKVxuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnJlZmVyZW5jZTxNb2JpbGVQdXRhd2F5RGV0YWlsLCBMaWNlbnNlUGxhdGVOdW1iZXIsIExvY2F0aW9uPih7XG4gICAgICAgICAgICAgICAgbm9kZTogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvTG9jYXRpb24nLFxuICAgICAgICAgICAgICAgIGJpbmQ6ICdsb2NhdGlvbicsXG4gICAgICAgICAgICAgICAgdmFsdWVGaWVsZDogJ3R5cGUnLFxuICAgICAgICAgICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgIF0sXG4gICAgfSlcbiAgICBsaWNlbnNlUGxhdGVOdW1iZXI6IHVpLmZpZWxkcy5SZWZlcmVuY2U8TGljZW5zZVBsYXRlTnVtYmVyPjtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnJlZmVyZW5jZUZpZWxkPE1vYmlsZVB1dGF3YXlEZXRhaWwsIENvbnRhaW5lcj4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5tYWluQmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnVG8gY29udGFpbmVyJyxcbiAgICAgICAgbm9kZTogJ0BzYWdlL3gzLW1hc3Rlci1kYXRhL0NvbnRhaW5lcicsXG4gICAgICAgIHZhbHVlRmllbGQ6ICdjb2RlJyxcbiAgICAgICAgaXNUcmFuc2llbnQ6IHRydWUsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgIGlzTWFuZGF0b3J5OiBmYWxzZSxcbiAgICAgICAgaXNGdWxsV2lkdGg6IHRydWUsXG4gICAgICAgIGNhbkZpbHRlcjogZmFsc2UsXG4gICAgfSlcbiAgICBjb250YWluZXI6IHVpLmZpZWxkcy5SZWZlcmVuY2U8Q29udGFpbmVyPjtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnJlZmVyZW5jZUZpZWxkPE1vYmlsZVB1dGF3YXlEZXRhaWwsIExvY2F0aW9uPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLm1haW5CbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdUbyBsb2NhdGlvbicsXG4gICAgICAgIHBsYWNlaG9sZGVyOiAnU2NhbiBvciBzZWxlY3QuLi4nLFxuICAgICAgICBub2RlOiAnQHNhZ2UveDMtc3RvY2stZGF0YS9Mb2NhdGlvbicsXG4gICAgICAgIHZhbHVlRmllbGQ6ICdjb2RlJyxcbiAgICAgICAgaXNUcmFuc2llbnQ6IHRydWUsXG4gICAgICAgIGlzTWFuZGF0b3J5OiB0cnVlLFxuICAgICAgICBpc0Z1bGxXaWR0aDogdHJ1ZSxcbiAgICAgICAgaXNBdXRvU2VsZWN0RW5hYmxlZDogdHJ1ZSxcbiAgICAgICAgLy9taW5Mb29rdXBDaGFyYWN0ZXJzOiAxLFxuICAgICAgICBzaG91bGRTdWdnZXN0aW9uc0luY2x1ZGVDb2x1bW5zOiB0cnVlLFxuICAgICAgICBjYW5GaWx0ZXI6IGZhbHNlLFxuICAgICAgICBmaWx0ZXIoKSB7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIHN0b2NrU2l0ZTogeyBjb2RlOiB0aGlzLl9zaXRlLnZhbHVlLmNvZGUgfSxcbiAgICAgICAgICAgICAgICAvLyBUT0RPIElzc3VlOiBOb3Qgc3VyZSB3aHkgdGhpcyBpcyBoYXZpbmcgYnVpbGQtdGltZSBlcnJvcnMuIFRoZXJlIGV4aXN0IHdvcmtpbmcgZmlsdGVyIGNyaXRlcmlhIG9uIGVudW0gdXNpbmcgX25lIG9wZXJhdG9yLi4uXG4gICAgICAgICAgICAgICAgLy9jYXRlZ29yeTogeyBfbmU6ICdkb2NrJyB9LFxuICAgICAgICAgICAgICAgIGNhdGVnb3J5OiB7IF9uaW46IFsnZG9jayddIH0sIC8vIGNhbm5vdCBiZSBhIGRvY2sgbG9jYXRpb25cbiAgICAgICAgICAgIH07XG4gICAgICAgIH0sXG4gICAgICAgIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICBpZiAodGhpcy50b0xvY2F0aW9uLnZhbHVlKSB0aGlzLnRvTG9jYXRpb24uZ2V0TmV4dEZpZWxkKHRydWUpPy5mb2N1cygpO1xuICAgICAgICAgICAgfSBjYXRjaCAoZSkge31cbiAgICAgICAgfSxcbiAgICAgICAgY29sdW1uczogW1xuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnRleHQoe1xuICAgICAgICAgICAgICAgIGJpbmQ6ICdjb2RlJyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ0NvZGUnLFxuICAgICAgICAgICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAndHlwZScsXG4gICAgICAgICAgICAgICAgdGl0bGU6ICdUeXBlJyxcbiAgICAgICAgICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICAvLyAoWDMtMjI3MzQ3KSBUT0RPIE9ic29sZXRlOiBIYXZpbmcgdG8gc3BlY2lmeSAmIGhpZGUgZmllbGRzIHVzZWQgaW4gZmlsdGVyIHRoYXQgZG9uJ3QgbmVlZCB0byBiZSBkaXNwbGF5ZWRcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy5yZWZlcmVuY2U8TW9iaWxlUHV0YXdheURldGFpbCwgTG9jYXRpb24sIFNpdGU+KHtcbiAgICAgICAgICAgICAgICBub2RlOiAnQHNhZ2UveDMtc3lzdGVtL1NpdGUnLFxuICAgICAgICAgICAgICAgIGJpbmQ6ICdzdG9ja1NpdGUnLFxuICAgICAgICAgICAgICAgIHZhbHVlRmllbGQ6ICdjb2RlJyxcbiAgICAgICAgICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICBdLFxuICAgIH0pXG4gICAgdG9Mb2NhdGlvbjogdWkuZmllbGRzLlJlZmVyZW5jZTxMb2NhdGlvbj47XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5maWx0ZXJTZWxlY3RGaWVsZDxNb2JpbGVQdXRhd2F5RGV0YWlsLCBMb3Q+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMubWFpbkJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ0xvdCcsXG4gICAgICAgIHBsYWNlaG9sZGVyOiAnU2NhbiBvciBzZWxlY3QuLi4nLFxuICAgICAgICBub2RlOiAnQHNhZ2UveDMtc3RvY2stZGF0YS9Mb3QnLFxuICAgICAgICB2YWx1ZUZpZWxkOiAnY29kZScsXG4gICAgICAgIC8vaGVscGVyVGV4dDogJ3N1YmxvdCcsIC8vIFRPRE86IFByZWxvYWQgc3VibG90IGJhc2VkIG9uIHNlbGVjdGVkIGxvdFxuICAgICAgICBpc0hlbHBlclRleHRIaWRkZW46IHRydWUsXG4gICAgICAgIGlzVHJhbnNpZW50OiB0cnVlLFxuICAgICAgICBpc0Z1bGxXaWR0aDogdHJ1ZSxcbiAgICAgICAgaXNOZXdFbmFibGVkOiB0cnVlLFxuICAgICAgICB2YWxpZGF0aW9uOiAvXiR8XltefGEtel0rJC8sIC8vIGFkZGVkIGEgY2hlY2sgZm9yIG5lZ2F0aW5nIGxvd2VyLWNhc2UgY2hhcmFjdGVycyB0byBhdm9pZCBlZGdlIGNhc2VzXG4gICAgICAgIG1pbkxvb2t1cENoYXJhY3RlcnM6IDEsXG4gICAgICAgIGNhbkZpbHRlcjogZmFsc2UsXG4gICAgICAgIGZpbHRlcigpIHtcbiAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgcHJvZHVjdDogeyBjb2RlOiB0aGlzLl9wcm9kdWN0LnZhbHVlLmNvZGUgfSxcbiAgICAgICAgICAgIH07XG4gICAgICAgIH0sXG4gICAgICAgIGFzeW5jIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgaWYgKCF0aGlzLmxvdC52YWx1ZSkge1xuICAgICAgICAgICAgICAgIC8vIGlmIGxvdCBpcyBtYW51YWxseSBjbGVhcmVkIG91dCwgdGhlbiBjbGVhciBvdXQgc3VibG90IGFzIHdlbGwgT05MWSBpZiB0aGlzIHN0b3JhZ2UgZGV0YWlsIGxpbmUgZG9lc24ndCBoYXZlIGEgcHJlLXBvcHVsYXRlZCBzdWJsb3RcbiAgICAgICAgICAgICAgICBpZiAoIXRoaXMuc3VibG90LmlzSGlkZGVuICYmICF0aGlzLl9zdG9yYWdlRGV0YWlscy5zdWJsb3QpIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5zdWJsb3QudmFsdWUgPSBudWxsO1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnN1YmxvdC5pc0Rpc2FibGVkID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgdGhpcy5sb3QudmFsdWUgPSB0aGlzLmxvdC52YWx1ZS50b1VwcGVyQ2FzZSgpO1xuICAgICAgICAgICAgYXdhaXQgdGhpcy4kLmNvbW1pdFZhbHVlQW5kUHJvcGVydHlDaGFuZ2VzKCk7XG4gICAgICAgICAgICBhd2FpdCB0aGlzLmxvdC52YWxpZGF0ZSgpO1xuICAgICAgICAgICAgdGhpcy5sb3QuZ2V0TmV4dEZpZWxkKHRydWUpPy5mb2N1cygpO1xuXG4gICAgICAgICAgICAvLyBUT0RPOiBQcmVsb2FkIHN1YmxvdCBiYXNlZCBvbiBzZWxlY3RlZCBsb3RcbiAgICAgICAgICAgIC8vIGlmICh0aGlzLmxvdC5oZWxwZXJUZXh0KSB7XG4gICAgICAgICAgICAvLyAgICAgLy8gaWYgbG90IGhhcyBhbiBhc3NvY2lhdGVkIHN1YmxvdCwgdGhlbiBwb3B1bGF0ZSBzdWJsb3QgYW5kIGRpc2FibGUgaXRcbiAgICAgICAgICAgIC8vICAgICB0aGlzLnN1YmxvdC52YWx1ZSA9IHRoaXMubG90LmhlbHBlclRleHQ7XG4gICAgICAgICAgICAvLyAgICAgdGhpcy5zdWJsb3QuaXNEaXNhYmxlZCA9IHRydWU7XG4gICAgICAgICAgICAvLyB9XG4gICAgICAgIH0sXG4gICAgfSlcbiAgICBsb3Q6IHVpLmZpZWxkcy5GaWx0ZXJTZWxlY3Q8TG90PjtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQdXRhd2F5RGV0YWlsPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLm1haW5CbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdTdWJsb3QnLFxuICAgICAgICBwbGFjZWhvbGRlcjogJ1NjYW4gYSBzdWJsb3QnLFxuICAgICAgICBpc1RyYW5zaWVudDogdHJ1ZSxcbiAgICAgICAgaXNGdWxsV2lkdGg6IHRydWUsXG4gICAgICAgIHZhbGlkYXRpb246IC9eJHxeW158XSskLyxcbiAgICAgICAgb25DaGFuZ2UoKSB7XG4gICAgICAgICAgICBpZiAodGhpcy5zdWJsb3QudmFsdWUpIHRoaXMuc3VibG90LnZhbHVlID0gdGhpcy5zdWJsb3QudmFsdWUudG9VcHBlckNhc2UoKTtcbiAgICAgICAgfSxcbiAgICB9KVxuICAgIHN1YmxvdDogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy50ZXh0RmllbGQ8TW9iaWxlUHV0YXdheURldGFpbD4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5tYWluQmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnU2VyaWFsIG51bWJlcicsXG4gICAgICAgIHBsYWNlaG9sZGVyOiAnU2NhbiBhIHNlcmlhbCBudW1iZXInLFxuICAgICAgICBpc1RyYW5zaWVudDogdHJ1ZSxcbiAgICAgICAgaXNGdWxsV2lkdGg6IHRydWUsXG4gICAgICAgIHZhbGlkYXRpb246IC9eJHxeW158XSskLyxcbiAgICB9KVxuICAgIHNlcmlhbE51bWJlcjogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBwcml2YXRlIGFzeW5jIF9pbml0aWFsaXplUGFnZShzdG9ja1RyYW5zYWN0aW9uOiBzdHJpbmcsIHN0b3JhZ2VEZXRhaWxzOiBFeHRyYWN0RWRnZXNQYXJ0aWFsPFN0b3JhZ2VEZXRhaWxzPikge1xuICAgICAgICBpZiAoIXN0b2NrVHJhbnNhY3Rpb24pIHRocm93IG5ldyBFcnJvcignSW52YWxpZCBTdG9jayBUcmFuc2FjdGlvbicpO1xuXG4gICAgICAgIHRoaXMuX3N0b2NrVHJhbnNhY3Rpb24gPSBzdG9ja1RyYW5zYWN0aW9uO1xuICAgICAgICB0aGlzLl9zdG9yYWdlRGV0YWlscyA9IHN0b3JhZ2VEZXRhaWxzO1xuICAgICAgICB0aGlzLl9zaXRlLnZhbHVlID0gc3RvcmFnZURldGFpbHMuc3RvcmFnZVNpdGU7XG5cbiAgICAgICAgLy8gaGVhZGVyIGNhcmRcbiAgICAgICAgdGhpcy5fc3RvcmFnZUxpc3ROdW1iZXIudmFsdWUgPSBzdG9yYWdlRGV0YWlscy5zdG9yYWdlTGlzdE51bWJlcjtcbiAgICAgICAgdGhpcy5fcHJvZHVjdC52YWx1ZSA9IHN0b3JhZ2VEZXRhaWxzLnN0b3JhZ2UucHJvZHVjdDtcbiAgICAgICAgdGhpcy5oZWFkZXJQcm9kdWN0LnZhbHVlID0gdGhpcy5fcHJvZHVjdC52YWx1ZS5jb2RlO1xuICAgICAgICB0aGlzLl9sb2NhbGl6ZWREZXNjcmlwdGlvbjEudmFsdWUgPSBzdG9yYWdlRGV0YWlscy5zdG9yYWdlLnByb2R1Y3QubG9jYWxpemVkRGVzY3JpcHRpb24xO1xuXG4gICAgICAgIC8vIG1haW4gYmxvY2tcbiAgICAgICAgdGhpcy5wYWNraW5nVW5pdC52YWx1ZSA9IHN0b3JhZ2VEZXRhaWxzLnBhY2tpbmdVbml0O1xuICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9IHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0Lm1heCA9IE51bWJlcihcbiAgICAgICAgICAgIHN0b3JhZ2VEZXRhaWxzLnF1YW50aXR5SW5QYWNraW5nVW5pdCxcbiAgICAgICAgKTtcbiAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQuc2NhbGUgPSBzdG9yYWdlRGV0YWlscy5wYWNraW5nVW5pdC5udW1iZXJPZkRlY2ltYWxzOyAvLyBlbmZvcmNlIHByZWNpc2lvbiBiYXNlZCBvbiBwYWNraW5nIHVuaXRcbiAgICAgICAgdGhpcy5mcm9tU3RhdHVzLnZhbHVlID0gc3RvcmFnZURldGFpbHMuc3RvcmFnZS5zdGF0dXMuY29kZTtcbiAgICAgICAgdGhpcy50b1N0YXR1cy5vcHRpb25zID0gYXdhaXQgdGhpcy5fZmV0Y2hTdGF0dXNlcygpO1xuICAgICAgICB0aGlzLnRvU3RhdHVzLnZhbHVlID0gc3RvcmFnZURldGFpbHMuc3RhdHVzLmNvZGU7XG4gICAgICAgIHRoaXMuZnJvbUxvY2F0aW9uLnZhbHVlID0gc3RvcmFnZURldGFpbHMuc3RvcmFnZS5sb2NhdGlvbjtcbiAgICAgICAgdGhpcy50b0xvY2F0aW9uLnZhbHVlID0gc3RvcmFnZURldGFpbHMubG9jYXRpb247IC8vIG5vIG5lZWQgdG8gd29ycnkgYWJvdXQgcHJvZHVjdHMgdGhhdCBhcmUgbm90IGxvY2F0aW9uIG1hbmFnZWRcblxuICAgICAgICB0aGlzLmxvdC5pc0hpZGRlbiA9IHN0b3JhZ2VEZXRhaWxzLnN0b3JhZ2UucHJvZHVjdC5sb3RNYW5hZ2VtZW50TW9kZSA9PT0gJ25vdE1hbmFnZWQnOyAvLyBsb3QgaXMgaGlkZGVuIGlmIHByb2R1Y3QgaXMgbm90IGxvdCBtYW5hZ2VkXG4gICAgICAgIHRoaXMubG90LmlzTWFuZGF0b3J5ID1cbiAgICAgICAgICAgICF0aGlzLmxvdC5pc0hpZGRlbiAmJlxuICAgICAgICAgICAgIXN0b3JhZ2VEZXRhaWxzLnN0b3JhZ2UucHJvZHVjdC5sb3RTZXF1ZW5jZU51bWJlciAmJlxuICAgICAgICAgICAgc3RvcmFnZURldGFpbHMuc3RvcmFnZS5wcm9kdWN0LmxvdE1hbmFnZW1lbnRNb2RlICE9PSAnb3B0aW9uYWxMb3QnOyAvLyBsb3QgaXMgbWFuZGF0b3J5IG9ubHkgaWYgbG90IGlzIE5PVCBoaWRkZW4sIGRvZXMgTk9UIGhhdmUgbG90IHNlcSAjICYgcHJvZHVjdCBpcyBsb3QgbWFuYWdlZCwgYnV0IE5PVCBvcHRpb25hbFxuICAgICAgICBpZiAoIXRoaXMubG90LmlzSGlkZGVuKSB0aGlzLmxvdC52YWx1ZSA9IHN0b3JhZ2VEZXRhaWxzLmxvdDtcbiAgICAgICAgdGhpcy5sb3QuaXNEaXNhYmxlZCA9ICEhdGhpcy5sb3QudmFsdWU7IC8vIGRpc2FibGUgbG90IGlmIHRoaXMgc3RvcmFnZSBkZXRhaWwgbGluZSBhbHJlYWR5IGhhcyBhIGxvdCBzcGVjaWZpZWRcblxuICAgICAgICB0aGlzLnN1YmxvdC5pc0hpZGRlbiA9IHN0b3JhZ2VEZXRhaWxzLnN0b3JhZ2UucHJvZHVjdC5sb3RNYW5hZ2VtZW50TW9kZSAhPT0gJ2xvdEFuZFN1YmxvdCc7IC8vIHN1YmxvdCBpcyBoaWRkZW4gaWYgcHJvZHVjdCBpcyBub3QgYm90aCBsb3QgJiBzdWJsb3QgbWFuYWdlZFxuICAgICAgICB0aGlzLnN1YmxvdC5pc01hbmRhdG9yeSA9ICF0aGlzLnN1YmxvdC5pc0hpZGRlbjsgLy8gc3VibG90IGlzIG1hbmRhdG9yeSBvbmx5IGlmIGl0IGlzIG5vdCBoaWRkZW5cbiAgICAgICAgaWYgKCF0aGlzLnN1YmxvdC5pc0hpZGRlbikgdGhpcy5zdWJsb3QudmFsdWUgPSBzdG9yYWdlRGV0YWlscy5zdWJsb3Q7XG4gICAgICAgIHRoaXMuc3VibG90LmlzRGlzYWJsZWQgPSAhIXRoaXMuc3VibG90LnZhbHVlOyAvLyBkaXNhYmxlIHN1YmxvdCBpZiB0aGlzIHN0b3JhZ2UgZGV0YWlsIGxpbmUgYWxyZWFkeSBoYXMgYSBzdWJsb3Qgc3BlY2lmaWVkXG5cbiAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXIuaXNIaWRkZW4gPSBbJ25vdE1hbmFnZWQnLCAnaXNzdWVkJ10uaW5jbHVkZXMoXG4gICAgICAgICAgICBzdG9yYWdlRGV0YWlscy5zdG9yYWdlLnByb2R1Y3Quc2VyaWFsTnVtYmVyTWFuYWdlbWVudE1vZGUsXG4gICAgICAgICk7IC8vIHNlcmlhbCBpcyBoaWRkZW4gaWYgcHJvZHVjdCBpcyBub3Qgc2VyaWFsIG1hbmFnZWQgb3IgaXNzdWVkXG4gICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyLmlzTWFuZGF0b3J5ID1cbiAgICAgICAgICAgICF0aGlzLnNlcmlhbE51bWJlci5pc0hpZGRlbiAmJiAhc3RvcmFnZURldGFpbHMuc3RvcmFnZS5wcm9kdWN0LnNlcmlhbFNlcXVlbmNlTnVtYmVyOyAvLyBzZXJpYWwgaXMgbWFuZGF0b3J5IG9ubHkgaWYgc2VyaWFsIGlzIE5PVCBoaWRkZW4sIGRvZXMgTk9UIGhhdmUgc2VyaWFsIHNlcSAjXG4gICAgICAgIGlmICghdGhpcy5zZXJpYWxOdW1iZXIuaXNIaWRkZW4pIHRoaXMuc2VyaWFsTnVtYmVyLnZhbHVlID0gc3RvcmFnZURldGFpbHMuc3RhcnRpbmdTZXJpYWxOdW1iZXI7XG4gICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyLmlzRGlzYWJsZWQgPSAhIXRoaXMuc2VyaWFsTnVtYmVyLnZhbHVlOyAvLyBkaXNhYmxlIHNlcmlhbCBpZiB0aGlzIHN0b3JhZ2UgZGV0YWlsIGxpbmUgYWxyZWFkeSBoYXMgYSBzZXJpYWwgbnVtYmVyIHNwZWNpZmllZFxuXG4gICAgICAgIHRoaXMubGljZW5zZVBsYXRlTnVtYmVyLmlzSGlkZGVuID0gdGhpcy5jb250YWluZXIuaXNIaWRkZW4gPSAhQm9vbGVhbihcbiAgICAgICAgICAgIHN0b3JhZ2VEZXRhaWxzLnN0b3JhZ2UucHJvZHVjdC5wcm9kdWN0U2l0ZXM/LlswXT8uaXNMaWNlbnNlUGxhdGVOdW1iZXJNYW5hZ2VkLFxuICAgICAgICApO1xuICAgICAgICBpZiAoIXRoaXMubGljZW5zZVBsYXRlTnVtYmVyLmlzSGlkZGVuKSB7XG4gICAgICAgICAgICB0aGlzLmxpY2Vuc2VQbGF0ZU51bWJlci52YWx1ZSA9IHN0b3JhZ2VEZXRhaWxzLmxpY2Vuc2VQbGF0ZU51bWJlcjtcbiAgICAgICAgICAgIHRoaXMuY29udGFpbmVyLnZhbHVlID0gc3RvcmFnZURldGFpbHMubGljZW5zZVBsYXRlTnVtYmVyPy5jb250YWluZXI7XG5cbiAgICAgICAgICAgIC8vIGlmIHByb3ZpZGVkIGxwbiBpbiBzdG9yYWdlIHdvcmtzaGVldCAoZGV0YWlsKSBsaW5lIGFuZC4uLlxuICAgICAgICAgICAgLy8gMSkgbHBuIGhhcyBzdGF0dXMgJ2luU3RvY2snICh3aGljaCBpcyBhbHdheXMgYXNzb2NpYXRlZCB0byBhIGxvY2F0aW9uKSwgdGhlbiB0b0xvY2F0aW9uIG11c3QgYmUgZGlzYWJsZWRcbiAgICAgICAgICAgIC8vIDIpIGxwbiBoYXMgc3RhdHVzICdmcmVlJyBidXQgbm8gbG9jYXRpb24gYXNzb2NpYXRlZCwgdGhlbiB0b0xvY2F0aW9uIG11c3QgYmUgZW5hYmxlZFxuICAgICAgICAgICAgLy8gMykgbHBuIGhhcyBzdGF0dXMgJ2ZyZWUnIGJ1dCBoYXMgYSBsb2NhdGlvbiBhc3NvY2lhdGVkLCB0aGVuIHRvTG9jYXRpb24gbXVzdCBiZSBkaXNhYmxlZFxuICAgICAgICAgICAgLy8gTk9URTogdG9Mb2NhdGlvbiBwcm92aWRlZCBpbiBzdG9yYWdlIHdvcmtzaGVldCAoZGV0YWlsKSBsaW5lIHNob3VsZCBiZSB0aGUgc2FtZSBhcyBwcm92aWRlZCBscG4ncyBsb2NhdGlvblxuICAgICAgICAgICAgdGhpcy50b0xvY2F0aW9uLmlzRGlzYWJsZWQgPSAhIXRoaXMubGljZW5zZVBsYXRlTnVtYmVyLnZhbHVlPy5sb2NhdGlvbj8uY29kZTtcbiAgICAgICAgfVxuICAgICAgICB0aGlzLmxpY2Vuc2VQbGF0ZU51bWJlci5pc0Rpc2FibGVkID0gISF0aGlzLmxpY2Vuc2VQbGF0ZU51bWJlci52YWx1ZTsgLy8gaWYgbHBuIGlzIHByb3ZpZGVkLCBkaXNhYmxlXG5cbiAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQuZm9jdXMoKTtcbiAgICB9XG5cbiAgICBwcml2YXRlIGFzeW5jIF9mZXRjaFN0YXR1c2VzKCk6IFByb21pc2U8c3RyaW5nW10+IHtcbiAgICAgICAgcmV0dXJuIGV4dHJhY3RFZGdlczxTdG9ja1N0YXR1c0lucHV0PihcbiAgICAgICAgICAgIGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgICAgIC5ub2RlKCdAc2FnZS94My1zdG9jay1kYXRhL1N0b2NrU3RhdHVzJylcbiAgICAgICAgICAgICAgICAucXVlcnkoXG4gICAgICAgICAgICAgICAgICAgIHVpLnF1ZXJ5VXRpbHMuZWRnZXNTZWxlY3Rvcih7XG4gICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICB9KSxcbiAgICAgICAgICAgICAgICApXG4gICAgICAgICAgICAgICAgLmV4ZWN1dGUoKSxcbiAgICAgICAgKS5tYXAoc3RhdHVzID0+IHN0YXR1cy5jb2RlKTtcbiAgICB9XG5cbiAgICBwcml2YXRlIGFzeW5jIF9jYWxsUHJvY2Vzc0FQSSgpOiBQcm9taXNlPGFueT4ge1xuICAgICAgICAvLyBQb3B1bGF0ZSByZXF1aXJlZCBhcmd1bWVudHNcbiAgICAgICAgY29uc3QgcHV0YXdheUFyZ3M6IGFueSA9IHtcbiAgICAgICAgICAgIHN0b2NrRW50cnlUcmFuc2FjdGlvbjogdGhpcy5fc3RvY2tUcmFuc2FjdGlvbixcbiAgICAgICAgICAgIHN0b3JhZ2VTaXRlOiB0aGlzLl9zdG9yYWdlRGV0YWlscy5zdG9yYWdlU2l0ZS5jb2RlLFxuICAgICAgICAgICAgc3RvY2tJZDogdGhpcy5fc3RvcmFnZURldGFpbHMuc3RvY2tJZCxcbiAgICAgICAgICAgIGRvY3VtZW50VHlwZTogdGhpcy5fc3RvcmFnZURldGFpbHMuZG9jdW1lbnRUeXBlLFxuICAgICAgICAgICAgZG9jdW1lbnROdW1iZXI6IHRoaXMuX3N0b3JhZ2VEZXRhaWxzLmRvY3VtZW50TnVtYmVyLFxuICAgICAgICAgICAgZG9jdW1lbnRMaW5lTnVtYmVyOiB0aGlzLl9zdG9yYWdlRGV0YWlscy5kb2N1bWVudExpbmVOdW1iZXIsXG4gICAgICAgICAgICBzdG9yYWdlU2VxdWVuY2VOdW1iZXI6IHRoaXMuX3N0b3JhZ2VEZXRhaWxzLnN0b3JhZ2VTZXF1ZW5jZU51bWJlcixcbiAgICAgICAgICAgIHF1YW50aXR5SW5QYWNraW5nVW5pdDogdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUsXG4gICAgICAgICAgICBxdWFudGl0eUluU3RvY2tVbml0OiBEZWNpbWFsLm1ha2UodGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUpXG4gICAgICAgICAgICAgICAgLm11bCh0aGlzLl9zdG9yYWdlRGV0YWlscy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3RvcilcbiAgICAgICAgICAgICAgICAudG9OdW1iZXIoKSxcbiAgICAgICAgICAgIHN0YXR1czogdGhpcy50b1N0YXR1cy52YWx1ZSxcbiAgICAgICAgICAgIGxvY2F0aW9uOiB0aGlzLnRvTG9jYXRpb24udmFsdWUuY29kZSxcbiAgICAgICAgICAgIGxvY2F0aW9uVHlwZTogdGhpcy50b0xvY2F0aW9uLnZhbHVlLnR5cGUsXG4gICAgICAgIH07XG5cbiAgICAgICAgLy8gKFgzLTIzNzAxNikgVE9ETyBJc3N1ZTogSGF2ZSB0byBzcGVjaWZ5IGFsbCBvcHRpb25hbCBwYXJhbWV0ZXJzIGluIHRoZSBwcm9jZXNzUHV0YXdheSBtdXRhdGlvbiBkdWUgdG8gYSBidWdcbiAgICAgICAgLy8gUG9wdWxhdGUgc2l0dWF0aW9uYWwgYXJndW1lbnRzXG4gICAgICAgIC8vIGlmICghdGhpcy5sb3QuaXNIaWRkZW4gJiYgdGhpcy5sb3QudmFsdWUpIHB1dGF3YXlBcmdzLmxvdCA9IHRoaXMubG90LnZhbHVlO1xuICAgICAgICAvLyBpZiAoIXRoaXMuc3VibG90LmlzSGlkZGVuICYmIHRoaXMuc3VibG90LnZhbHVlKSBwdXRhd2F5QXJncy5zdWJsb3QgPSB0aGlzLnN1YmxvdC52YWx1ZTtcbiAgICAgICAgLy8gaWYgKCF0aGlzLnNlcmlhbE51bWJlci5pc0hpZGRlbiAmJiB0aGlzLnNlcmlhbE51bWJlci52YWx1ZSkge1xuICAgICAgICAvLyAgICAgcHV0YXdheUFyZ3Muc3RhcnRpbmdTZXJpYWxOdW1iZXIgPSB0aGlzLnNlcmlhbE51bWJlci52YWx1ZTtcbiAgICAgICAgLy8gICAgIHB1dGF3YXlBcmdzLmVuZGluZ1NlcmlhbE51bWJlciA9IHRoaXMuX3N0b3JhZ2VEZXRhaWxzLmVuZGluZ1NlcmlhbE51bWJlcjtcbiAgICAgICAgLy8gfVxuICAgICAgICAvLyBpZiAoIXRoaXMubGljZW5zZVBsYXRlTnVtYmVyLmlzSGlkZGVuICYmIHRoaXMubGljZW5zZVBsYXRlTnVtYmVyLnZhbHVlPy5jb2RlKSB7XG4gICAgICAgIC8vICAgICBwdXRhd2F5QXJncy5saWNlbnNlUGxhdGVOdW1iZXIgPSB0aGlzLmxpY2Vuc2VQbGF0ZU51bWJlci52YWx1ZS5jb2RlO1xuICAgICAgICAvLyAgICAgaWYgKHRoaXMuY29udGFpbmVyLnZhbHVlPy5jb2RlKSBwdXRhd2F5QXJncy5jb250YWluZXIgPSB0aGlzLmNvbnRhaW5lci52YWx1ZS5jb2RlO1xuICAgICAgICAvLyB9XG4gICAgICAgIC8vIGxldCBsYWJlbERlc3RpbmF0aW9uOiBzdHJpbmcgPSB0aGlzLiQuc3RvcmFnZS5nZXQoJ2FkYy1sYWJlbC1kZXN0aW5hdGlvbicpIGFzIHN0cmluZztcbiAgICAgICAgLy8gaWYgKGxhYmVsRGVzdGluYXRpb24pIHtcbiAgICAgICAgLy8gICAgIHB1dGF3YXlBcmdzLmxhYmVsRGVzdGluYXRpb24gPSBsYWJlbERlc3RpbmF0aW9uO1xuICAgICAgICAvLyB9XG5cbiAgICAgICAgLy8gKFgzLTIzNzAxNikgVE9ETyBJc3N1ZTogSGF2ZSB0byBzcGVjaWZ5IEFMTCBvcHRpb25hbCBwYXJhbWV0ZXJzIGluIHRoZSBwcm9jZXNzUHV0YXdheSBtdXRhdGlvbiBkdWUgdG8gYSBidWdcbiAgICAgICAgcHV0YXdheUFyZ3MubG90ID0gIXRoaXMubG90LmlzSGlkZGVuICYmIHRoaXMubG90LnZhbHVlID8gdGhpcy5sb3QudmFsdWUgOiAnJztcbiAgICAgICAgcHV0YXdheUFyZ3Muc3VibG90ID0gIXRoaXMuc3VibG90LmlzSGlkZGVuICYmIHRoaXMuc3VibG90LnZhbHVlID8gdGhpcy5zdWJsb3QudmFsdWUgOiAnJztcbiAgICAgICAgcHV0YXdheUFyZ3Muc3RhcnRpbmdTZXJpYWxOdW1iZXIgPVxuICAgICAgICAgICAgIXRoaXMuc2VyaWFsTnVtYmVyLmlzSGlkZGVuICYmIHRoaXMuc2VyaWFsTnVtYmVyLnZhbHVlID8gdGhpcy5zZXJpYWxOdW1iZXIudmFsdWUgOiAnJztcbiAgICAgICAgcHV0YXdheUFyZ3MuZW5kaW5nU2VyaWFsTnVtYmVyID1cbiAgICAgICAgICAgICF0aGlzLnNlcmlhbE51bWJlci5pc0hpZGRlbiAmJlxuICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXIudmFsdWUgJiZcbiAgICAgICAgICAgIC8vIGlmIHByb2R1Y3QgaXMgc2VyaWFsIHRyYWNrZWQgJiBnbG9iYWxSZWNlaXZlZElzc3VlZCBhbmQgdGhlIHVzZXIgaXMgYXR0ZW1wdGluZyB0byBkbyBhIHBhcnRpYWwgcXVhbnRpdHksIHRoZW4gZG8gbm90IHBhc3MgYW55IGVuZGluZyBzZXJpYWwgbnVtYmVyIGZyb20gdGhpcyBzdG9yYWdlIHdvcmtzaGVldCAoZGV0YWlsKSBsaW5lXG4gICAgICAgICAgICAodGhpcy5fc3RvcmFnZURldGFpbHMuc3RvcmFnZS5wcm9kdWN0LnNlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlICE9PSAnZ2xvYmFsUmVjZWl2ZWRJc3N1ZWQnIHx8XG4gICAgICAgICAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgPT09IHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0Lm1heClcbiAgICAgICAgICAgICAgICA/IHRoaXMuX3N0b3JhZ2VEZXRhaWxzLmVuZGluZ1NlcmlhbE51bWJlclxuICAgICAgICAgICAgICAgIDogJyc7XG4gICAgICAgIHB1dGF3YXlBcmdzLmxpY2Vuc2VQbGF0ZU51bWJlciA9XG4gICAgICAgICAgICAhdGhpcy5saWNlbnNlUGxhdGVOdW1iZXIuaXNIaWRkZW4gJiYgdGhpcy5saWNlbnNlUGxhdGVOdW1iZXIudmFsdWU/LmNvZGVcbiAgICAgICAgICAgICAgICA/IHRoaXMubGljZW5zZVBsYXRlTnVtYmVyLnZhbHVlLmNvZGVcbiAgICAgICAgICAgICAgICA6ICcnO1xuICAgICAgICBwdXRhd2F5QXJncy5jb250YWluZXIgPVxuICAgICAgICAgICAgISFwdXRhd2F5QXJncy5saWNlbnNlUGxhdGVOdW1iZXIgJiYgdGhpcy5jb250YWluZXIudmFsdWU/LmNvZGUgPyB0aGlzLmNvbnRhaW5lci52YWx1ZS5jb2RlIDogJyc7XG4gICAgICAgIHB1dGF3YXlBcmdzLmxhYmVsRGVzdGluYXRpb24gPSAodGhpcy4kLnN0b3JhZ2UuZ2V0KCdtb2JpbGUtbGFiZWwtZGVzdGluYXRpb24nKSBhcyBzdHJpbmcpID8/ICcnO1xuXG4gICAgICAgIC8vIEdlbmVyYXRlIFB1dGF3YXkgbXV0YXRpb24gcmVxdWVzdFxuICAgICAgICB0cnkge1xuICAgICAgICAgICAgcmV0dXJuIGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgICAgIC5ub2RlKCdAc2FnZS94My1zdG9jay9TdG9yYWdlRGV0YWlscycpXG4gICAgICAgICAgICAgICAgLm11dGF0aW9ucy5wcm9jZXNzUHV0YXdheShcbiAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgc3RvY2tFbnRyeVRyYW5zYWN0aW9uOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgc3RvcmFnZVNpdGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBzdG9ja0lkOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgZG9jdW1lbnRUeXBlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgZG9jdW1lbnROdW1iZXI6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBkb2N1bWVudExpbmVOdW1iZXI6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBzdG9yYWdlU2VxdWVuY2VOdW1iZXI6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBxdWFudGl0eUluUGFja2luZ1VuaXQ6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBsb3Q6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBzdWJsb3Q6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBzdGFydGluZ1NlcmlhbE51bWJlcjogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGVuZGluZ1NlcmlhbE51bWJlcjogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHN0YXR1czogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGNvbnRhaW5lcjogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGxpY2Vuc2VQbGF0ZU51bWJlcjogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvY2F0aW9uOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgbG9jYXRpb25UeXBlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgcXVhbnRpdHlJblN0b2NrVW5pdDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGxhYmVsRGVzdGluYXRpb246IHRydWUsXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHBhcmFtZXRlcnM6IHB1dGF3YXlBcmdzLFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIClcbiAgICAgICAgICAgICAgICAuZXhlY3V0ZSgpO1xuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgcmV0dXJuIGVycm9yO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLyoqIEBpbnRlcm5hbCAqL1xuICAgIHByaXZhdGUgaXNXZWJTZXJ2aWNlRXJyb3IoZXJyb3I6IGFueSk6IGJvb2xlYW4ge1xuICAgICAgICAvLyBlcnJvcnMgY29udGFpbnMgYSBhcnJheSBvciB1bmRlZmluZWQgd2hlbiBpcyBub3QgY2xhc3MgQ2xpZW50RXJyb3JcbiAgICAgICAgLy8gZGlhZ25vc2VzIGNvbnRhaW5zIGEgYXJyYXkgb3IgdW5kZWZpbmVkIHdoZW4gaXMgbm90IGNsYXNzIEFwaUVycm9yXG4gICAgICAgIC8vIFRPRE86ICBTZWUgdG8gaW5jcmVhc2UgdGhpcyBmZWF0dXJlXG4gICAgICAgIGNvbnN0IGRpYWdub3NlcyA9ICg8QXBpRXJyb3I+ZXJyb3IpPy5kaWFnbm9zZXM7XG4gICAgICAgIGNvbnN0IGVycm9yczogRXJyb3JEZXRhaWxbXSA9ICg8Q2xpZW50RXJyb3I+ZXJyb3IpPy5lcnJvcnM7XG5cbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgIGVycm9yIGluc3RhbmNlb2YgRXJyb3IgJiZcbiAgICAgICAgICAgICgoZGlhZ25vc2VzICYmIGRpYWdub3Nlcy5sZW5ndGggPT09IDApIHx8XG4gICAgICAgICAgICAgICAgKGVycm9ycyAmJlxuICAgICAgICAgICAgICAgICAgICBlcnJvcnMubGVuZ3RoID4gMCAmJlxuICAgICAgICAgICAgICAgICAgICBlcnJvcnMuc29tZShcbiAgICAgICAgICAgICAgICAgICAgICAgIGRldGFpbCA9PlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRldGFpbD8uZXh0ZW5zaW9ucz8uY29kZSA9PT0gJ2J1c2luZXNzLXJ1bGUtZXJyb3InICYmXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgKGRldGFpbC5tZXNzYWdlLnN0YXJ0c1dpdGgoJ0ZhaWxlZCB0byBnZXQgZGVzY3JpcHRpb24gZm9yIHdlYiBzZXJ2aWNlJykgfHxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZGV0YWlsLm1lc3NhZ2UuZW5kc1dpdGgoJ0NoYW5uZWwgYWxsb2NhdGlvbiByZWZ1c2VkJykpLFxuICAgICAgICAgICAgICAgICAgICApKSlcbiAgICAgICAgKTtcbiAgICB9XG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./lib/pages/mobile-putaway-detail.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-putaway-detail.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;