/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/control.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/control.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.controlLotReceipt = exports.renumberStockCountList = exports.validateWithDetails = exports.validatePage = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nfunction validate(pageInstance, isPageValid, fieldsData) {\n    const fieldErrors = new Array();\n    let areAllFieldsValid = true;\n    fieldsData.forEach(field => {\n        if (!_validateField(field)) {\n            areAllFieldsValid = false;\n            fieldErrors.push(field.fieldName ?? '');\n        }\n    });\n    if (typesLib.gte(fieldErrors.length, 1))\n        _notifyFieldNotValid(pageInstance, fieldErrors);\n    return isPageValid && areAllFieldsValid;\n}\nexports.validate = validate;\nfunction _validateField(data) {\n    return !data.validate ? true : false;\n}\nfunction _notifyFieldNotValid(pageInstance, fields) {\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fields.map(field => pageInstance[field].title) }), { type: 'error', timeout: 5000 });\n}\nasync function validatePage(pageInstance) {\n    const errors = await pageInstance.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(`${ui.localize('@sage/x3-stock/notification-validation-error', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validatePage = validatePage;\nasync function validateWithDetails(pageInstance) {\n    // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n// Decision made to not present an error to the user if one occurs during renumbering\nasync function renumberStockCountList(stockCountSessionNumber, stockCountListNumber, page) {\n    try {\n        const _renumberListArgs = {\n            stockCountSessionNumber: stockCountSessionNumber,\n            stockCountListNumber: stockCountListNumber,\n        };\n        await page.$.graph\n            .node('@sage/x3-stock/StockCountListDetail')\n            .mutations.renumberCountList({\n            stockCountSessionNumber: true,\n            stockCountListNumber: true,\n        }, {\n            parameters: _renumberListArgs,\n        })\n            .execute();\n    }\n    catch (e) {\n        ui.console.error(`renumberCountList :\\n${JSON.stringify(e)}`);\n    }\n}\nexports.renumberStockCountList = renumberStockCountList;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock/StockJournal')\n        .query(ui.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast(ui.localize('@sage/x3-stock/notification-error-receipt-lot', 'The lot number {{ lot }} already exists for this product.', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/control.ts\n");

/***/ }),

/***/ "./lib/client-functions/display.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/display.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.NotifyAndWait = void 0;\nclass NotifyAndWait {\n    constructor(instance) {\n        this.pageInstance = instance;\n    }\n    async showAndWait(message, type, timeout) {\n        await _notifyAndWait(this.pageInstance, message, type, timeout);\n    }\n    show(message, type, timeout) {\n        _notify(this.pageInstance, message, type, timeout);\n    }\n}\nexports.NotifyAndWait = NotifyAndWait;\nfunction _notifyAndWait(pageInstance, localizedNotificationText, type, timeout) {\n    return new Promise(resolve => {\n        _notify(pageInstance, localizedNotificationText, type, timeout);\n        setTimeout(resolve, timeout);\n    });\n}\nfunction _notify(pageInstance, localizedNotificationText, type, timeout = 5000) {\n    pageInstance.$.showToast(localizedNotificationText, { type: type, timeout });\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/display.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-pick-ticket-view-pick-ticket-line.ts":
/*!***************************************************************!*\
  !*** ./lib/pages/mobile-pick-ticket-view-pick-ticket-line.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nvar MobilePickTicketViewPickTicketLine_1;\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobilePickTicketViewPickTicketLine = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst control_1 = __webpack_require__(/*! ../client-functions/control */ \"./lib/client-functions/control.ts\");\nconst display_1 = __webpack_require__(/*! ../client-functions/display */ \"./lib/client-functions/display.ts\");\nlet MobilePickTicketViewPickTicketLine = class MobilePickTicketViewPickTicketLine extends ui.Page {\n    constructor() {\n        super(...arguments);\n        /*\n         *\n         *  Technical properties\n         *\n         */\n        this._notifier = new display_1.NotifyAndWait(this);\n    }\n    static { MobilePickTicketViewPickTicketLine_1 = this; }\n    /*\n     *  Technical fields\n     */\n    static { this.TRANSACTION_KEY = 'mobile-pick-ticket-entry-transaction'; }\n    static { this.DESTINATION_KEY = 'mobile-pick-ticket-destination-location'; }\n    static { this.DESTINATION_DISPLAY_KEY = 'mobile-pick-ticket-destination-location-display'; }\n    static { this.PICK_LIST_KEY = 'mobile-pick-ticket-pick-list'; }\n    static { this.PICK_TICKET_KEY = 'mobile-pick-ticket'; }\n    static { this.PICK_TICKET_LINE_KEY = 'mobile-pick-ticket-line'; }\n    static { this.PICK_TICKET_LINE_TEXT = 'mobile-pick-ticket-line-text'; }\n    _disablePage() {\n        this.nextButton.isHidden = true;\n        this.pickButton.isHidden = true;\n        this.shortageButton.isHidden = true;\n        this.chooseStockButton.isHidden = true;\n        this.quantityPicked.isHidden = true;\n        this.quantityToPick.isHidden = true;\n        this.quantityInPackingUnit.isHidden = true;\n        this.quantityInStockUnit.isHidden = true;\n        this.location.isHidden = true;\n        this.lot.isHidden = true;\n        this.sublot.isHidden = true;\n        this.serialNumber.isHidden = true;\n        this.serialNumberReceived.isHidden = true;\n        this.packingUnit.isHidden = true;\n        this.packingUnitToStockUnitConversionFactor.isHidden = true;\n        this.status.isHidden = true;\n        this.destinationLocation.isHidden = true;\n        this.licensePlateNumber.isHidden = true;\n        this.identifier1.isHidden = true;\n        this.identifier2.isHidden = true;\n        this.$.finish();\n    }\n    /*\n     *  Init functions\n     */\n    async _init() {\n        /*\n         * Retrieve storage parameters\n         */\n        this.pickTicket.value = this.$.storage.get(MobilePickTicketViewPickTicketLine_1.PICK_TICKET_KEY).toString();\n        this.pickTicketLine.value = this.$.storage\n            .get(MobilePickTicketViewPickTicketLine_1.PICK_TICKET_LINE_KEY)\n            .toString();\n        this.destinationLocation.isHidden =\n            typesLib.strictEq(this.$.storage.get(MobilePickTicketViewPickTicketLine_1.DESTINATION_DISPLAY_KEY).toString(), '0') ? true\n                : false;\n        this.destinationLocation.value = {\n            code: this.$.storage.get(MobilePickTicketViewPickTicketLine_1.DESTINATION_KEY).toString(),\n        };\n        this.stockSite.value = this.$.storage.get('mobile-selected-stock-site').toString();\n        this.pickList.value = this.$.storage.get(MobilePickTicketViewPickTicketLine_1.PICK_LIST_KEY).toString();\n        this.transaction.value = this.$.storage.get(MobilePickTicketViewPickTicketLine_1.TRANSACTION_KEY).toString();\n        this._mobileSettings = JSON.parse(this.$.queryParameters?.mobileSettings);\n        this._allPicks = [];\n        this.confirmedPicks = 0;\n        this.quantityToPick.value = 0;\n        this.quantityPicked.value = 0;\n        this.currentPick = 0;\n        this.numberOfPicks = 0;\n        this.newPick = false;\n        this._unitsOfMeasure = [];\n        this.status.options = await this._getStockStatus();\n        if (this.pickTicket.value) {\n            try {\n                await this._initTicketLine(); // populate array of picks\n            }\n            catch (e) {\n                ui.console.error(e);\n            }\n        }\n        if (typesLib.strictEq(this._allPicks.length, 0)) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-pick-ticket-no-picks', 'No pick list to process.'));\n            this.$.finish();\n        }\n        else {\n            try {\n                this.packingUnit.options = await this._initUnits();\n            }\n            catch (e) {\n                ui.console.error(e);\n            }\n        }\n    }\n    /*\n     * Load All the Picks based on the Pick Ticket Line\n     */\n    async _initTicketLine() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/PickTicketLine')\n            .query(ui.queryUtils.edgesSelector({\n            pickTicket: true,\n            pickTicketLine: true,\n            product: {\n                code: true,\n                localizedDescription1: true,\n                lotManagementMode: true,\n                serialNumberManagementMode: true,\n            },\n            quantityInStockUnit: true,\n            stockUnit: {\n                code: true,\n                numberOfDecimals: true,\n            },\n            packingUnitToStockUnitConversionFactor: true,\n            packingUnit: {\n                code: true,\n                numberOfDecimals: true,\n            },\n            allocatedQuantity: true,\n            shortageQuantity: true,\n            adcPickedLine: true,\n            allocatedLines: {\n                query: {\n                    edges: {\n                        node: {\n                            stockId: true,\n                            quantityInStockUnit: true,\n                            serialNumber: true,\n                            allocationType: true,\n                            stockLine: {\n                                lot: true,\n                                status: { code: true },\n                                sublot: true,\n                                serialNumber: true,\n                                location: {\n                                    code: true,\n                                },\n                                quantityInPackingUnit: true,\n                                quantityInStockUnit: true,\n                                packingUnitToStockUnitConversionFactor: true,\n                                packingUnit: {\n                                    code: true,\n                                },\n                                licensePlateNumber: { code: true },\n                                identifier1: true,\n                                identifier2: true,\n                            },\n                        },\n                    },\n                    __args: {\n                        first: 500,\n                    },\n                },\n            },\n            sourcePickTicketType: true,\n            sourcePickTicket: true,\n            sourcePickTicketLine: true,\n            sourcePickTicketSequenceNumber: true,\n            sourcePickTicketSubcontractType: true,\n            subcontractReorderLocation: true,\n        }, {\n            filter: {\n                pickTicket: { _eq: this.pickTicket.value },\n                pickTicketLine: Number(this.pickTicketLine.value),\n            },\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/notification-error-no-pick-ticket-line', 'Pick ticket line does not exist'));\n        }\n        /*\n         * Capture all the picks for the pick ticket line\n         */\n        let detailed = 0;\n        const ticketLine = response.edges[0];\n        this.product.value = ticketLine.node.product.code;\n        this.localizedDescription1.value = ticketLine.node.product.localizedDescription1;\n        this.stockUnit.value = ticketLine.node.stockUnit.code;\n        this.quantityInPackingUnit.scale = ticketLine.node.packingUnit.numberOfDecimals;\n        this.quantityInStockUnit.scale = ticketLine.node.stockUnit.numberOfDecimals;\n        this.displayQuantityToBePicked.value = typesLib.add(typesLib.add(Number(ticketLine.node.quantityInStockUnit).toFixed(ticketLine.node.stockUnit.numberOfDecimals), ' '), this.stockUnit.value);\n        this.textQuantityToBePicked.value = ui.localize('@sage/x3-stock/quantityToPick', 'Quantity to pick: ');\n        this.displayQuantityPicked.value = typesLib.add(typesLib.add(typesLib.add(ui.localize('@sage/x3-stock/pickedQuantity', 'Picked quantity: '), Number(this.quantityPicked.value).toFixed(ticketLine.node.stockUnit.numberOfDecimals)), ' '), this.stockUnit.value);\n        this.sourcePickTicketType.value = ticketLine.node.sourcePickTicketType;\n        this.sourcePickTicket.value = ticketLine.node.sourcePickTicket;\n        this.sourcePickTicketLine.value = ticketLine.node.sourcePickTicketLine;\n        this.sourcePickTicketSequenceNumber.value = ticketLine.node.sourcePickTicketSequenceNumber;\n        this.sourcePickTicketSubcontractType.value = ticketLine.node.sourcePickTicketSubcontractType;\n        this.subcontractReorderLocation.value = ticketLine.node.subcontractReorderLocation;\n        await this._readProductData(ticketLine.node.product.code);\n        if (typesLib.strictEq(this._product.stockManagementMode, 'notManaged')) {\n            this._lotManagementMode = this._product.lotManagementMode;\n            this._serialNumberManagementMode = this._product.serialNumberManagementMode;\n            this._isLocationManaged = false;\n            this._stockManagementMode = this._product.stockManagementMode;\n            this._isLicensePlateNumberManaged = false;\n            this._isNegativeStockAuthorized = this._product.isNegativeStockAuthorized;\n        }\n        else {\n            await this._readProductSiteData(ticketLine.node.product.code);\n            this._lotManagementMode = this._productSite.product.lotManagementMode;\n            this._serialNumberManagementMode = this._productSite.product.serialNumberManagementMode;\n            this._isLocationManaged = this._productSite.isLocationManaged;\n            this._stockManagementMode = this._productSite.product.stockManagementMode;\n            this._isLicensePlateNumberManaged = this._productSite.isLicensePlateNumberManaged;\n            this._isNegativeStockAuthorized = this._productSite.product.isNegativeStockAuthorized;\n        }\n        this.quantityToPick.value = Number(ticketLine.node.quantityInStockUnit);\n        /*\n         * Loop through the allocations for this ticket line and populate the picks array\n         *\n         */\n        for (const lineAllocations of ticketLine.node.allocatedLines.query.edges) {\n            if (typesLib.ne(String(lineAllocations.node.allocationType), 'shortagesDetailed')) {\n                detailed = lineAllocations.node.stockLine ? 1 : 0;\n                this._allPicks.push({\n                    adcPickedLine: ticketLine.node.adcPickedLine,\n                    detailedAllocation: detailed,\n                    allocatedQuantity: Number(ticketLine.node.allocatedQuantity),\n                    shortageQuantity: Number(ticketLine.node.shortageQuantity),\n                    quantityInStockUnit: detailed\n                        ? Number(lineAllocations.node.quantityInStockUnit)\n                        : Number(ticketLine.node.quantityInStockUnit),\n                    stockId: Number(lineAllocations.node.stockId),\n                    packingUnit: detailed\n                        ? lineAllocations.node.stockLine.packingUnit.code\n                        : ticketLine.node.stockUnit.code,\n                    packingUnitCode: detailed\n                        ? lineAllocations.node.stockLine.packingUnit.code\n                        : ticketLine.node.stockUnit.code,\n                    packingUnitToStockUnitConversionFactor: detailed\n                        ? Number(lineAllocations.node.stockLine.packingUnitToStockUnitConversionFactor)\n                        : 1,\n                    quantityInPackingUnit: detailed\n                        ? Number.parseFloat(Number(typesLib.div(Number(lineAllocations.node.quantityInStockUnit), Number(lineAllocations.node.stockLine.packingUnitToStockUnitConversionFactor))).toFixed(this.quantityInPackingUnit.scale))\n                        : Number(ticketLine.node.quantityInStockUnit),\n                    lot: detailed ? lineAllocations.node.stockLine.lot : null,\n                    sublot: detailed ? lineAllocations.node.stockLine.sublot : null,\n                    serialNumber: detailed\n                        ? typesLib.strictEq(this._serialNumberManagementMode, 'globalReceivedIssued') ? lineAllocations.node.serialNumber\n                            : lineAllocations.node.stockLine.serialNumber\n                        : null,\n                    status: detailed ? lineAllocations.node.stockLine.status?.code : null,\n                    location: detailed && lineAllocations.node.stockLine.location\n                        ? lineAllocations.node.stockLine.location?.code\n                        : null,\n                    confirmed: 0,\n                    licensePlateNumber: detailed ? lineAllocations.node.stockLine.licensePlateNumber?.code : null,\n                    identifier1: detailed ? lineAllocations.node.stockLine.identifier1 : null,\n                    identifier2: detailed ? lineAllocations.node.stockLine.identifier2 : null,\n                });\n                this.numberOfPicks = typesLib.add(this.numberOfPicks, 1);\n            }\n        }\n        if (typesLib.strictEq(this.numberOfPicks, 0)) {\n            this._allPicks.push({\n                adcPickedLine: ticketLine.node.adcPickedLine,\n                detailedAllocation: 0,\n                allocatedQuantity: Number(ticketLine.node.allocatedQuantity),\n                shortageQuantity: Number(ticketLine.node.shortageQuantity),\n                quantityInStockUnit: Number(ticketLine.node.quantityInStockUnit),\n                stockId: 0,\n                packingUnit: ticketLine.node.stockUnit?.code,\n                packingUnitCode: ticketLine.node.stockUnit?.code,\n                packingUnitToStockUnitConversionFactor: 1,\n                quantityInPackingUnit: Number(ticketLine.node.quantityInStockUnit),\n                lot: null,\n                sublot: null,\n                serialNumber: null,\n                status: null,\n                location: null,\n                confirmed: 0,\n                licensePlateNumber: null,\n            });\n            this.numberOfPicks = typesLib.add(this.numberOfPicks, 1);\n        }\n    }\n    /*\n     * Get all the units for this product\n     */\n    async _initUnits() {\n        this._unitsOfMeasure.push({\n            unit: this._product.stockUnit.code,\n            unitToStockUnitConversionFactor: 1,\n            numberOfDecimals: this._product.stockUnit.numberOfDecimals,\n            isPackingFactorEntryAllowed: false,\n        });\n        this.quantityToPick.scale =\n            this.quantityPicked.scale =\n                this.quantityInStockUnit.scale =\n                    this._product.stockUnit.numberOfDecimals;\n        for (const packUnits of this._product.packingUnits.query.edges) {\n            if (packUnits.node.packingUnit && typesLib.eq(this._unitsOfMeasure.filter(unit => typesLib.eq(unit.unit, packUnits.node.packingUnit.code)).length, 0)) {\n                this._unitsOfMeasure.push({\n                    unit: packUnits.node.packingUnit.code,\n                    unitToStockUnitConversionFactor: Number(packUnits.node.packingUnitToStockUnitConversionFactor),\n                    numberOfDecimals: packUnits.node.packingUnit.numberOfDecimals,\n                    isPackingFactorEntryAllowed: true,\n                });\n            }\n        }\n        if (typesLib.strictEq(this.packingUnit.value, this.stockUnit.value)) {\n            this.quantityInPackingUnit.scale = this.quantityInStockUnit.scale;\n        }\n        else {\n            let unitPosition = this._unitsOfMeasure\n                .map(function (e) {\n                return e.unit;\n            })\n                .indexOf(this.packingUnit.value);\n            if (typesLib.strictNe(unitPosition, -1)) {\n                this.quantityInPackingUnit.scale = this._unitsOfMeasure[unitPosition].numberOfDecimals;\n            }\n        }\n        return this._unitsOfMeasure.map((theUnits) => {\n            return theUnits.unit;\n        });\n    }\n    /*\n     * Move to the next unconfirmed pick in the pick array\n     */\n    async _nextPick() {\n        let startingPosition = this.currentPick;\n        let lookForPicks = true;\n        while (lookForPicks) {\n            if (typesLib.gt(typesLib.sub(this._allPicks.length, 1), this.currentPick)) {\n                this.currentPick = typesLib.add(this.currentPick, 1);\n            }\n            else {\n                this.currentPick = 0;\n            }\n            if (typesLib.strictEq(this._allPicks[this.currentPick].confirmed, 0)) {\n                lookForPicks = false;\n            }\n            if (typesLib.strictEq(this.currentPick, startingPosition)) {\n                lookForPicks = false;\n                this.nextButton.isDisabled = true;\n            }\n        }\n        await this._displayPick();\n        this.quantityInPackingUnit.focus();\n    }\n    /*\n     * If they haven't picked the full quantity we need to create a new pick\n     * for them to finish or to initiate a shortage\n     */\n    _createNewPick(newQuantity) {\n        this._allPicks.push({\n            adcPickedLine: 0,\n            detailedAllocation: 0,\n            allocatedQuantity: 0,\n            shortageQuantity: 0,\n            stockUnit: this.stockUnit.value,\n            stockId: 0,\n            packingUnit: this.stockUnit.value,\n            packingUnitCode: this.stockUnit.value,\n            packingUnitToStockUnitConversionFactor: 1,\n            quantityInStockUnit: Number.parseFloat(newQuantity.toFixed(this.quantityInStockUnit.scale)),\n            quantityInPackingUnit: Number.parseFloat(newQuantity.toFixed(this.quantityInStockUnit.scale)),\n            lot: null,\n            sublot: null,\n            serialNumber: null,\n            status: null,\n            location: null,\n            confirmed: 0,\n            licensePlateNumber: null,\n        });\n        this.numberOfPicks = typesLib.add(this.numberOfPicks, 1);\n        this.newPick = true;\n        this.quantityInPackingUnit.scale = this.quantityInStockUnit.scale;\n        this._computeQuantityMax();\n    }\n    _computeQuantityMax() {\n        this.quantityInStockUnit.max = typesLib.sub(this.quantityToPick.value, this.quantityPicked.value);\n        if (typesLib.strictEq(this.packingUnit.value, this.stockUnit.value)) {\n            this.quantityInPackingUnit.max = this.quantityInStockUnit.max;\n        }\n        else {\n            let unroundedMax = typesLib.div(this.quantityInStockUnit.max, this.packingUnitToStockUnitConversionFactor.value);\n            this.quantityInPackingUnit.max = Number.parseFloat(unroundedMax.toFixed(this.quantityInPackingUnit.scale));\n        }\n    }\n    /*\n     * Display current pick on the page (disabling/hiding when appropriate)\n     */\n    async _displayPick() {\n        // reset old values X3-269771\n        this.location.value = null;\n        this.packingUnit.value = null;\n        this.currentPackingUnitCode.value = null;\n        this.packingUnitToStockUnitConversionFactor.value = null;\n        this.lot.value = null;\n        this.sublot.value = null;\n        if (typesLib.strictEq(this._serialNumberManagementMode, 'receivedIssued')) {\n            this.serialNumberReceived.value = null;\n        }\n        else if (typesLib.strictEq(this._serialNumberManagementMode, 'globalReceivedIssued')) {\n            this.serialNumber.value = null;\n        }\n        this.status.value = null;\n        this.identifier1.value = null;\n        this.identifier2.value = null;\n        await this.$.commitValueAndPropertyChanges();\n        //\n        const currentPick = this._allPicks[this.currentPick];\n        this.location.value = currentPick.location ? { code: currentPick.location } : null;\n        this.packingUnit.isReadOnly = false;\n        this.packingUnit.value = this._allPicks[this.currentPick].packingUnit;\n        this.currentPackingUnitCode.value = this._allPicks[this.currentPick].packingUnitCode;\n        this.packingUnitToStockUnitConversionFactor.value =\n            this._allPicks[this.currentPick].packingUnitToStockUnitConversionFactor;\n        this.quantityInStockUnit.value = this._allPicks[this.currentPick].quantityInStockUnit;\n        this.quantityInPackingUnit.value = this._allPicks[this.currentPick].quantityInPackingUnit;\n        this.lot.value = this._allPicks[this.currentPick].lot ? { lot: this._allPicks[this.currentPick].lot } : null;\n        this.sublot.value = this._allPicks[this.currentPick].sublot\n            ? { sublot: this._allPicks[this.currentPick].sublot }\n            : null;\n        if (typesLib.strictEq(this._serialNumberManagementMode, 'receivedIssued')) {\n            this.serialNumberReceived.value = this._allPicks[this.currentPick].serialNumber\n                ? { serialNumber: this._allPicks[this.currentPick].serialNumber }\n                : null;\n        }\n        else if (typesLib.strictEq(this._serialNumberManagementMode, 'globalReceivedIssued')) {\n            this.serialNumber.value = this._allPicks[this.currentPick].serialNumber\n                ? { code: this._allPicks[this.currentPick].serialNumber }\n                : null;\n        }\n        if (this._allPicks[this.currentPick].status) {\n            var index = this.status.options.indexOf(this._allPicks[this.currentPick].status);\n            if (typesLib.gte(index, 0)) {\n                this.status.value = this.status.options[index];\n            }\n        }\n        if (!this.packingUnit.value) {\n            this.packingUnitToStockUnitConversionFactor.value = 1;\n            this.packingUnit.value = this.stockUnit.value;\n        }\n        this.licensePlateNumber.value = this._allPicks[this.currentPick].licensePlateNumber;\n        this.identifier1.value = this._allPicks[this.currentPick].identifier1;\n        this.identifier2.value = this._allPicks[this.currentPick].identifier2;\n        this.shortageButton.isDisabled = typesLib.strictNe(this.quantityInPackingUnit.value, 0);\n        await this.$.commitValueAndPropertyChanges();\n        if (typesLib.strictEq(this._stockManagementMode, 'notManaged')) {\n            this.location.isHidden = true;\n            this.destinationLocation.isHidden = true;\n            this.lot.isHidden = true;\n            this.sublot.isHidden = true;\n            this.serialNumber.isHidden = true;\n            this.serialNumberReceived.isHidden = true;\n            this.status.isHidden = true;\n            this.licensePlateNumber.isHidden = true;\n            this.identifier1.isHidden = true;\n            this.identifier2.isHidden = true;\n        }\n        else {\n            if (typesLib.strictEq(currentPick.detailedAllocation, 1)) {\n                this.lot.isReadOnly = true;\n                this.sublot.isReadOnly = true;\n                this.serialNumber.isReadOnly = true;\n                this.serialNumberReceived.isReadOnly = true;\n                this.status.isReadOnly = true;\n                this.location.isReadOnly = true;\n                this.packingUnit.isReadOnly = true;\n                this.packingUnitToStockUnitConversionFactor.isReadOnly = true;\n                this.identifier1.isReadOnly = true;\n                this.identifier2.isReadOnly = true;\n            }\n            else {\n                this.lot.isReadOnly = false;\n                this.sublot.isReadOnly = false;\n                this.serialNumber.isReadOnly = false;\n                this.serialNumberReceived.isReadOnly = false;\n                this.status.isReadOnly = false;\n                this.location.isReadOnly = false;\n                this.packingUnit.isReadOnly = false;\n                this.packingUnitToStockUnitConversionFactor.isDisabled = typesLib.strictEq(this.packingUnit.value, this.stockUnit.value);\n            }\n            this.lot.isHidden = typesLib.strictEq(this._lotManagementMode, 'notManaged');\n            this.sublot.isHidden =\n                typesLib.strictEq(this._lotManagementMode, 'notManaged') || typesLib.strictEq(this._lotManagementMode, 'optionalLot') || typesLib.strictEq(this._lotManagementMode, 'mandatoryLot');\n            this.lot.isMandatory =\n                typesLib.strictEq(this._lotManagementMode, 'mandatoryLot') || typesLib.strictEq(this._lotManagementMode, 'lotAndSublot');\n            this.sublot.isMandatory = this.lot.isMandatory;\n            this.serialNumber.isHidden =\n                typesLib.strictEq(this._serialNumberManagementMode, 'notManaged') || typesLib.strictEq(this._serialNumberManagementMode, 'issued') || typesLib.strictEq(this._serialNumberManagementMode, 'receivedIssued');\n            this.serialNumberReceived.isHidden =\n                typesLib.strictEq(this._serialNumberManagementMode, 'notManaged') || typesLib.strictEq(this._serialNumberManagementMode, 'issued') || typesLib.strictEq(this._serialNumberManagementMode, 'globalReceivedIssued');\n            this.location.isHidden = !this._isLocationManaged;\n            this.licensePlateNumber.isHidden = !(typesLib.strictEq(currentPick.detailedAllocation, 1) && this._isLicensePlateNumberManaged);\n            this.identifier1.isHidden = !(typesLib.strictEq(currentPick.detailedAllocation, 1) && this.identifier1.value);\n            this.identifier2.isHidden = !(typesLib.strictEq(currentPick.detailedAllocation, 1) && this.identifier2.value);\n        }\n        if (typesLib.strictEq(typesLib.add(this.confirmedPicks, 1), this.numberOfPicks)) {\n            this.nextButton.isDisabled = true;\n        }\n        this._computeQuantityMax();\n    }\n    /*\n     * Copy page values to the Pick array\n     */\n    _updatePickFromPage() {\n        this._allPicks[this.currentPick].location = this.location.value ? this.location.value.code : null;\n        this._allPicks[this.currentPick].lot = this.lot.value ? this.lot.value.lot : null;\n        this._allPicks[this.currentPick].sublot = this.sublot.value ? this.sublot.value.sublot : null;\n        if (typesLib.strictEq(this._serialNumberManagementMode, 'globalReceivedIssued')) {\n            this._allPicks[this.currentPick].serialNumber = this.serialNumber.value\n                ? this.serialNumber.value.code\n                : null;\n        }\n        else {\n            this._allPicks[this.currentPick].serialNumber = this.serialNumberReceived.value\n                ? this.serialNumberReceived.value.serialNumber\n                : null;\n        }\n        this._allPicks[this.currentPick].status = this.status.value;\n        this._allPicks[this.currentPick].quantityInStockUnit = this.quantityInStockUnit.value;\n        this._allPicks[this.currentPick].packingUnitCode = this.currentPackingUnitCode.value;\n        this._allPicks[this.currentPick].packingUnit = this.packingUnit.value;\n        this._allPicks[this.currentPick].packingUnitToStockUnitConversionFactor =\n            this.packingUnitToStockUnitConversionFactor.value;\n        this._allPicks[this.currentPick].quantityInPackingUnit = this.quantityInPackingUnit.value;\n        this._allPicks[this.currentPick].identifier1 = this.identifier1.value;\n        this._allPicks[this.currentPick].identifier2 = this.identifier2.value;\n    }\n    /*\n     * Read the stock node to ensure there is some inventory for the entered details\n     */\n    async _validateStock(pageField, stockId) {\n        try {\n            const stockFilter = {\n                stockSite: this.stockSite.value,\n                product: this.product.value,\n            };\n            if (stockId && typesLib.gt(stockId, 0)) {\n                stockFilter.stockId = stockId;\n            }\n            if (this.location.value && this.location.value.code) {\n                stockFilter.location = this.location.value.code;\n            }\n            if (this.status.value) {\n                stockFilter.status = this.status.value;\n            }\n            if (this.lot.value && this.lot.value.lot) {\n                stockFilter.lot = this.lot.value.lot;\n            }\n            if (this.sublot.value && this.sublot.value.sublot) {\n                stockFilter.sublot = this.sublot.value.sublot;\n            }\n            if (this.serialNumberReceived.value && this.serialNumberReceived.value.serialNumber) {\n                stockFilter.serialNumber = this.serialNumberReceived.value.serialNumber;\n            }\n            const result = await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .query(ui.queryUtils.edgesSelector({\n                product: {\n                    product: {\n                        code: true,\n                    },\n                },\n                packingUnit: {\n                    code: true,\n                },\n                packingUnitToStockUnitConversionFactor: true,\n                status: {\n                    code: true,\n                },\n                location: {\n                    code: true,\n                },\n                lot: true,\n                sublot: true,\n                serialNumber: true,\n                identifier1: true,\n                identifier2: true,\n            }, {\n                filter: stockFilter,\n            }))\n                .execute();\n            if (typesLib.strictEq(result.edges.length, 0)) {\n                if (typesLib.strictEq(pageField, this.location.title)) {\n                    this.location.value.code = null;\n                }\n                else if (typesLib.strictEq(pageField, this.status.title)) {\n                    this.status.value = null;\n                }\n                else if (typesLib.strictEq(pageField, this.lot.title)) {\n                    this.lot.value.lot = null;\n                }\n                else if (typesLib.strictEq(pageField, this.sublot.title)) {\n                    this.sublot.value.sublot = null;\n                }\n                else if (typesLib.strictEq(pageField, this.serialNumber.title) && stockId && typesLib.gt(stockId, 0)) {\n                    this.serialNumber.value.code = null;\n                }\n                else if (typesLib.strictEq(pageField, this.serialNumber.title)) {\n                    this.serialNumberReceived.value.serialNumber = null;\n                }\n                this.$.removeToasts();\n                this.$.showToast(ui.localize('@sage/x3-stock/dialog-error-stock-availability', 'No stock matching the entry'), { type: 'error' });\n                return false;\n            }\n            if (typesLib.strictEq(result.edges.length, 1) &&\n                (typesLib.strictEq(pageField, this.lot.title) || typesLib.strictEq(pageField, this.sublot.title) || typesLib.strictEq(pageField, this.serialNumber.title))) {\n                if (typesLib.strictEq(this.status.value, null)) {\n                    this.status.value = result.edges[0].node.status?.code;\n                }\n                if (typesLib.strictEq(this.location.value, null) || typesLib.strictEq(this.location.value.code, null)) {\n                    this.location.value = { code: result.edges[0].node.location?.code };\n                }\n                if (typesLib.strictEq(this.sublot.value, null) || typesLib.strictEq(this.sublot.value.sublot, null)) {\n                    this.sublot.value = { sublot: result.edges[0].node.sublot };\n                }\n                if (typesLib.strictEq(this.lot.value, null) || typesLib.strictEq(this.lot.value.lot, null)) {\n                    this.lot.value = { lot: result.edges[0].node.lot };\n                }\n                this.identifier1.value = result.edges[0].node.identifier1;\n                this.identifier2.value = result.edges[0].node.identifier2;\n                await this.$.commitValueAndPropertyChanges();\n            }\n            return true;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), typesLib.add(ui.localize('@sage/x3-stock/dialog-error-reading-stock', 'Reading stock record: '), String(e)));\n            return false;\n        }\n    }\n    /*\n     * Read the stock node to ensure there is some inventory for the entered details\n     */\n    async _checkStockQuantity(stockId) {\n        try {\n            const stockFilter = {\n                stockSite: this.stockSite.value,\n                product: this.product.value,\n            };\n            if (stockId) {\n                stockFilter.stockId = stockId;\n            }\n            if (this.location.value && this.location.value.code) {\n                stockFilter.location = this.location.value.code;\n            }\n            if (this.status.value) {\n                stockFilter.status = this.status.value;\n            }\n            if (this.lot.value && this.lot.value.lot) {\n                stockFilter.lot = this.lot.value.lot;\n            }\n            if (this.sublot.value && this.sublot.value.sublot) {\n                stockFilter.sublot = this.sublot.value.sublot;\n            }\n            if (this.serialNumberReceived.value && this.serialNumberReceived.value.serialNumber) {\n                stockFilter.serialNumber = this.serialNumberReceived.value.serialNumber;\n            }\n            const result = await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .aggregate.query((0, xtrem_client_1.aggregateEdgesSelector)({\n                group: {\n                    product: {\n                        product: {\n                            code: {\n                                _by: 'value',\n                            },\n                        },\n                    },\n                },\n                values: {\n                    quantityInStockUnit: {\n                        min: false,\n                        max: false,\n                        sum: true,\n                        avg: false,\n                        distinctCount: false,\n                    },\n                },\n            }, {\n                filter: stockFilter,\n            }))\n                .execute();\n            if (typesLib.strictEq(result.edges.length, 0)) {\n                return false;\n            }\n            else if (typesLib.strictEq(this._allPicks[this.currentPick].detailedAllocation, 0) &&\n                this.serialNumberReceived.value &&\n                this.serialNumberReceived.value.serialNumber && typesLib.gt(Number(result.edges[0].node.values.quantityInStockUnit.sum), 0)) {\n                return true;\n            }\n            else if (typesLib.lt(Number(result.edges[0].node.values.quantityInStockUnit.sum), this.quantityInStockUnit.value)) {\n                return false;\n            }\n            return true;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), typesLib.add(ui.localize('@sage/x3-stock/dialog-error-reading-stock', 'Reading stock record: '), String(e)));\n            return false;\n        }\n    }\n    /*\n     * Read the product site node to get critical parameterization\n     */\n    async _readProductSiteData(productCode) {\n        try {\n            const productSiteData = await this.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .read({\n                isLicensePlateNumberManaged: true,\n                isLocationManaged: true,\n                stockSite: {\n                    code: true,\n                },\n                product: {\n                    code: true,\n                    serialNumberManagementMode: true,\n                    localizedDescription1: true,\n                    lotManagementMode: true,\n                    stockUnit: {\n                        code: true,\n                        numberOfDecimals: true,\n                    },\n                    isNegativeStockAuthorized: true,\n                    packingUnits: {\n                        query: {\n                            edges: {\n                                node: {\n                                    packingUnit: {\n                                        code: true,\n                                        numberOfDecimals: true,\n                                    },\n                                    packingUnitToStockUnitConversionFactor: true,\n                                    isPackingFactorEntryAllowed: true,\n                                },\n                            },\n                        },\n                    },\n                },\n            }, `${productCode}|${this.stockSite.value}`)\n                .execute();\n            // If an error occurred during the API call\n            if (!productSiteData) {\n                await this._notifier.showAndWait(ui.localize('@sage/x3-stock/pages__adc_notification__invalid_product_site_error', `Could not retrieve your product {{ productCode }} for the site {{ siteCode }}`, {\n                    productCode: this.product.value,\n                    siteCode: this.stockSite.value,\n                }), 'error');\n                return this.$.router.goTo('@sage/x3-stock/MobilePickTicket');\n            }\n            this._productSite = productSiteData;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), typesLib.add(ui.localize('@sage/x3-stock/dialog-error-reading-product-site', 'reading product site record'), String(e)));\n        }\n    }\n    async _readProductData(productCode) {\n        try {\n            const productData = await this.$.graph\n                .node('@sage/x3-master-data/Product')\n                .read({\n                code: true,\n                serialNumberManagementMode: true,\n                stockManagementMode: true,\n                localizedDescription1: true,\n                lotManagementMode: true,\n                isNegativeStockAuthorized: true,\n                stockUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                packingUnits: {\n                    query: {\n                        edges: {\n                            node: {\n                                packingUnit: {\n                                    code: true,\n                                    numberOfDecimals: true,\n                                },\n                                packingUnitToStockUnitConversionFactor: true,\n                                isPackingFactorEntryAllowed: true,\n                            },\n                        },\n                    },\n                },\n            }, `${productCode}`)\n                .execute();\n            // If an error occurred during the API call\n            if (!productData) {\n                await this._notifier.showAndWait(ui.localize('@sage/x3-stock/pages__adc_notification__invalid_product_error', `Could not retrieve your product {{ productCode }}`, {\n                    productCode: this.product.value,\n                }), 'error');\n                return this.$.router.goTo('@sage/x3-stock/MobilePickTicket');\n            }\n            this._product = productData;\n            this._unitStockNumberOfDecimals = productData.stockUnit.numberOfDecimals;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), typesLib.add(ui.localize('@sage/x3-stock/dialog-error-reading-product', 'reading product record'), String(e)));\n        }\n    }\n    async _getStockStatus() {\n        const response = await this.$.graph\n            // with 'provides' property defined in accessCode of this node, should automatically return only transactions that are accessible for the current user\n            .node('@sage/x3-stock-data/StockStatus')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/pages__adc_miscellaneous_receipt_details__notification__invalid_stock_status_error', 'No stock status'));\n        }\n        // transform Stock status response into a string array\n        return response.edges.map((stockStatus) => {\n            return stockStatus.node.code;\n        });\n    }\n    async _getShortage() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/PickTicketLine')\n            .aggregate.read({\n            _id: {\n                distinctCount: true,\n            },\n        }, {\n            filter: {\n                pickTicket: { _eq: this.pickTicket.value },\n                shortageQuantity: { _ne: '0' },\n            },\n        })\n            .execute();\n        return typesLib.strictNe(response._id?.distinctCount, 0);\n    }\n    async onSubmit(isShortage) {\n        if (isShortage) {\n            this.quantityInStockUnit.value = 0;\n            this.quantityInPackingUnit.value = 0;\n        }\n        if (!isShortage && (typesLib.gt(this.quantityInStockUnit.value, 0) || typesLib.gt(this.quantityInPackingUnit.value, 0))) {\n            // perform client-side validation\n            if (!(await (0, control_1.validateWithDetails)(this)))\n                return;\n        }\n        /*\n         * Check for over picking\n         */\n        if (typesLib.gt(typesLib.add(Number(this.quantityInStockUnit.value), this.quantityPicked.value), this.quantityToPick.value) ||\n            (typesLib.strictEq(this.packingUnit.value, this.stockUnit.value) && typesLib.gt(typesLib.add(Number(this.quantityInPackingUnit.value), this.quantityPicked.value), this.quantityToPick.value))) {\n            this.$.removeToasts();\n            await this.$.sound.error();\n            this.$.showToast(ui.localize('@sage/x3-stock/dialog-error-quantity-pick', 'Quantity greater than quantity to be picked'), { type: 'error', timeout: 5000 });\n            return;\n        }\n        /*\n         * Check for \"enough\" inventory\n         */\n        if (typesLib.strictEq(this._allPicks[this.currentPick].detailedAllocation, 0) && typesLib.gt(this.quantityInStockUnit.value, 0) && typesLib.strictNe(this._stockManagementMode, 'notManaged')) {\n            const enoughStock = await this._checkStockQuantity(this.serialNumber.value ? this.serialNumber.value.stockId : 0);\n            if (enoughStock instanceof Error || !enoughStock) {\n                this.$.removeToasts();\n                await this.$.sound.error();\n                this.$.showToast(ui.localize('@sage/x3-stock/dialog-error-insufficient-stock-quantity', 'Insufficient stock matching the entry'), { type: 'error', timeout: 5000 });\n                return;\n            }\n        }\n        this._updatePickFromPage(); // Update array\n        this.shortPick = false;\n        /*\n         * Special case where it appears they want to short pick\n         */\n        if (isShortage && typesLib.lt(this.quantityPicked.value, this.quantityToPick.value)) {\n            this.shortPick = await (0, dialogs_1.dialogConfirmation)(this, 'info', ui.localize('@sage/x3-stock/dialog-information-title', 'Information'), ui.localize('@sage/x3-stock/dialog-confirmation-pick-ticket-shortage-message', 'Create a shortage?'), {\n                fullScreen: true,\n                acceptButton: {\n                    text: ui.localize('@sage/x3-stock/button-accept-yes', 'Yes'),\n                },\n                cancelButton: {\n                    text: ui.localize('@sage/x3-stock/button-cancel-no', 'No'),\n                },\n            });\n            if (!this.shortPick) {\n                return;\n            }\n        }\n        if (!this.shortPick) {\n            this._allPicks[this.currentPick].confirmed = 1;\n            this.confirmedPicks = typesLib.add(this.confirmedPicks, 1);\n        }\n        /*\n         * See if even after this pick is confirmed do we still have more to pick\n         * There is a special case:  Short picks cannot be made deliverable, so don't ask\n         */\n        if (!this.shortPick && typesLib.lt(typesLib.add(Number(this.quantityInStockUnit.value), this.quantityPicked.value), this.quantityToPick.value)) {\n            this.quantityPicked.value = typesLib.add(this.quantityPicked.value, this.quantityInStockUnit.value);\n            this.displayQuantityPicked.value = typesLib.add(ui.localize('@sage/x3-stock/quantityPrepared', 'Picked quantity: '), `${ui.formatNumberToCurrentLocale(Number(this.quantityPicked.value), Number(this._unitStockNumberOfDecimals))} ${this.stockUnit.value}`);\n            if (typesLib.strictEq(this.numberOfPicks, this.confirmedPicks)) {\n                this._createNewPick(typesLib.sub(this.quantityToPick.value, this.quantityPicked.value));\n            }\n            await this._nextPick();\n        }\n        else {\n            // Ready to process the pick\n            let result;\n            let isDeliverable = false;\n            let isNotSetDelivrable = false;\n            let lastLine = 0;\n            // aggregate all lines from this pick ticket except the user's selected line for the minimum adcPickedLine (0 = at least 1 is not picked)\n            const aggregatedAdcPickedLine = await this.$.graph\n                .node('@sage/x3-stock/PickTicketLine')\n                .aggregate.read({\n                adcPickedLine: {\n                    min: true,\n                    distinctCount: true, // to handle edgy case of pick ticket containing only 1 line, which in this case this will aggregate 0 records\n                },\n            }, {\n                filter: {\n                    // get all lines from this pick ticket except the user's selected line\n                    pickTicket: { _eq: this.pickTicket.value },\n                    pickTicketLine: { _ne: Number(this.pickTicketLine.value) },\n                },\n            })\n                .execute();\n            if (typesLib.strictEq(aggregatedAdcPickedLine.adcPickedLine.distinctCount, 0) || // deliverable if this is the only line in this pick ticket\n             typesLib.strictNe(// deliverable if this is the only line in this pick ticket\n            aggregatedAdcPickedLine.adcPickedLine.min, 0) // deliverable if all other pick ticket lines have adcPickedLine = 1\n            ) {\n                lastLine = 1;\n                isDeliverable = await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-stock/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-stock/dialog-confirmation-set-the-pick-ticket-to-deliverable', `Set the pick ticket to 'Deliverable' ?`), {\n                    fullScreen: true,\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-stock/button-accept-yes', 'Yes'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-stock/button-cancel-no', 'No'),\n                    },\n                });\n            }\n            if (isDeliverable) {\n                if (!this._isNegativeStockAuthorized && (this.shortPick || (await this._getShortage()))) {\n                    await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_lines__the_picking_line_is_in_shortage_and_negative_stock_is_prohibited', 'The picking line is in shortage and negative stock is prohibited.'));\n                    isDeliverable = false;\n                    isNotSetDelivrable = true;\n                }\n                else if (this.shortPick &&\n                    this.destinationLocation.value && typesLib.ne(this.destinationLocation.value.code, '')) {\n                    await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_lines__a_location_can_not_be_modified_for_a_stock_out_line', 'A location can not be modified for a stock-out line.'));\n                    isDeliverable = false;\n                    isNotSetDelivrable = true;\n                }\n            }\n            result = await this._callProcessPickAPI(isDeliverable); // Call API\n            this.$.loader.isHidden = true;\n            // Special case unable to connect check type of error :\n            if (!result || result instanceof Error) {\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                    },\n                    size: 'small',\n                    mdContent: true,\n                };\n                let message = '';\n                if (!result?.message) {\n                    await this.$.sound.error();\n                    if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.'), options)) {\n                        await this.$.router.refresh();\n                    }\n                    else {\n                        await this.$.router.emptyPage();\n                        this.$.router.goTo('@sage/x3-stock/MobilePickTicket');\n                    }\n                    return;\n                }\n                else {\n                    const _messages = [];\n                    const _results = result;\n                    let _diagnoses = _results?.diagnoses;\n                    if (typesLib.gt(_diagnoses?.length, 1)) {\n                        _diagnoses = _diagnoses.splice(0, typesLib.sub(_diagnoses.length, 1));\n                    }\n                    ((_results?.errors\n                        ? _results.errors[0]?.extensions?.diagnoses\n                        : (_results?.innerError?.errors[0]?.extensions?.diagnoses ??\n                            _results.extensions?.diagnoses ??\n                            _diagnoses)) ?? [])\n                        .filter((d) => typesLib.gt(d.severity, 2) && d.message)\n                        .forEach((d) => {\n                        const _message = d.message.split(`\\n`);\n                        _messages.push(..._message);\n                    });\n                    const _result = _messages.length ? _messages : result.message.split(`\\n`);\n                    message = `**${ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_line__notification__update_error', 'An error has occurred')}**\\n\\n`;\n                    if (typesLib.strictEq(_result.length, 1)) {\n                        message = typesLib.add(message, `${_result[0]}`);\n                    }\n                    else {\n                        message = typesLib.add(message, _result.map(item => `* ${item}`).join('\\n'));\n                    }\n                    if (result instanceof Error) {\n                        this._allPicks.forEach(function (pick) {\n                            pick.confirmed = 0;\n                        });\n                        this.confirmedPicks = 0;\n                        this.quantityPicked.value = 0;\n                        this.displayQuantityPicked.value = typesLib.add(ui.localize('@sage/x3-stock/quantityPrepared', 'Picked quantity: '), `${ui.formatNumberToCurrentLocale(Number(this.quantityPicked.value), Number(this._unitStockNumberOfDecimals))} ${this.stockUnit.value}`);\n                        if (typesLib.gt(this._allPicks.length, 1)) {\n                            this.nextButton.isDisabled = false;\n                        }\n                        this.$.loader.isHidden = true;\n                    }\n                }\n                await this.$.sound.error();\n                if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), message, options)) {\n                    return;\n                }\n            }\n            // If we came from preparation list see if the list is done\n            // Change lastLine to 0 if it is not done\n            if (lastLine && typesLib.ne(this.pickList.value, '')) {\n                const aggregatedList = await this.$.graph\n                    .node('@sage/x3-stock/PickList')\n                    .aggregate.read({\n                    preparationListSequenceNumber: {\n                        distinctCount: true,\n                    },\n                }, {\n                    filter: {\n                        preparationList: this.pickList.value,\n                        pickTicketLine: { adcPickedLine: 0 },\n                    },\n                })\n                    .execute();\n                if (typesLib.strictNe(aggregatedList.preparationListSequenceNumber.distinctCount, 0)) {\n                    lastLine = 0;\n                }\n            }\n            this.$.storage.remove(MobilePickTicketViewPickTicketLine_1.PICK_TICKET_LINE_KEY);\n            /*\n             * Display information when pick ticket is or not deliverable\n             */\n            if (lastLine && typesLib.strictNe(isDeliverable, undefined)) {\n                await (0, dialogs_1.dialogMessage)(this, 'info', ui.localize('@sage/x3-stock/dialog-information-title', 'Information'), isNotSetDelivrable\n                    ? ui.localize('@sage/x3-stock/dialog-message-pick-ticket-has-been-submitted-but-not-set-as-deliverable', 'The pick ticket has been updated but it is not set as deliverable.')\n                    : isDeliverable\n                        ? ui.localize('@sage/x3-stock/dialog-message-pick-ticket-is-deliverable', 'The pick ticket is now set as deliverable.')\n                        : ui.localize('@sage/x3-stock/dialog-message-pick-ticket-not-deliverable', 'The pick ticket is not set as deliverable.'));\n            }\n            /*\n             * Return to get another pick ticket line or go back to page one\n             */\n            this.$.setPageClean();\n            await this.$.sound.success();\n            if (lastLine) {\n                this.$.router.goTo('@sage/x3-stock/MobilePickTicket');\n            }\n            else if (typesLib.strictEq(this.pickList.value, '')) {\n                this.$.router.goTo('@sage/x3-stock/MobilePickTicketSelectFromTicket', {\n                    mobileSettings: JSON.stringify(this._mobileSettings),\n                });\n            }\n            else {\n                this.$.router.goTo('@sage/x3-stock/MobilePickTicketSelectFromList', {\n                    mobileSettings: JSON.stringify(this._mobileSettings),\n                });\n            }\n        }\n    }\n    /*\n     * Call the updatePickTicketLine mutation on the Pick Ticket Line node\n     */\n    async _callProcessPickAPI(isDeliverable) {\n        this.$.loader.isHidden = false;\n        /*\n         * push the picks to the pickLines array\n         */\n        const _packingUnit = [];\n        const _packingUnitToStockUnitConversionFactor = [];\n        const _quantityInPackingUnit = [];\n        const _quantityInStockUnit = [];\n        const _location = [];\n        const _lot = [];\n        const _sublot = [];\n        const _serialNumber = [];\n        const _status = [];\n        const _stockId = [];\n        for (const pick of this._allPicks) {\n            if (pick.confirmed && typesLib.gt(pick.quantityInStockUnit, 0)) {\n                _packingUnit.push(pick.packingUnitCode);\n                _packingUnitToStockUnitConversionFactor.push(pick.packingUnitToStockUnitConversionFactor);\n                _quantityInPackingUnit.push(pick.quantityInPackingUnit);\n                _quantityInStockUnit.push(pick.quantityInStockUnit);\n                _location.push(pick.location ?? '');\n                _lot.push(pick.lot ?? '');\n                _sublot.push(pick.sublot ?? '');\n                _serialNumber.push(pick.serialNumber ?? '');\n                _status.push(pick.status);\n                _stockId.push(pick.stockId);\n            }\n        }\n        /*\n         * Make the mutation call\n         */\n        const pickTicketArgs = {\n            entryTransaction: this.transaction.value,\n            pickTicket: this.pickTicket.value,\n            pickTicketLine: this.pickTicketLine.value,\n            destinationLocation: this.destinationLocation.value ? this.destinationLocation.value.code : '',\n            product: this.product.value,\n            shortPick: this.shortPick,\n            deliverable: isDeliverable,\n            documentDestination: this.$.storage.get('mobile-document-destination') ?? '',\n            packingUnit: _packingUnit,\n            packingUnitToStockUnitConversionFactor: _packingUnitToStockUnitConversionFactor,\n            quantityInPackingUnit: _quantityInPackingUnit,\n            quantityInStockUnit: _quantityInStockUnit,\n            location: _location,\n            lot: _lot,\n            sublot: _sublot,\n            serialNumber: _serialNumber,\n            status: _status,\n            stockId: _stockId,\n            customBoolean: this.customBoolean.value ? this.customBoolean.value : null,\n            customDecimal: this.customDecimal.value ? this.customDecimal.value : null,\n            customString: this.customString.value ? this.customString.value : null,\n            customDate: this.customDate.value ? this.customDate.value : null,\n        };\n        try {\n            return await this.$.graph\n                .node('@sage/x3-stock/PickTicketLine')\n                .mutations.updatePickTicketLine({ pickTicket: true, pickTicketLine: true }, { parameters: pickTicketArgs })\n                .execute();\n        }\n        catch (error) {\n            return error;\n        }\n    }\n};\nexports.MobilePickTicketViewPickTicketLine = MobilePickTicketViewPickTicketLine;\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"stockSite\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"transaction\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"pickList\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__pickButton____title\", \"Submit\"),\n        shortcut: ['f2'],\n        buttonType: 'primary',\n        async onClick() {\n            await this.onSubmit(false);\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"pickButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__nextButton____title\", \"Next\"),\n        shortcut: ['f3'],\n        buttonType: 'secondary',\n        async onClick() {\n            await this.$.commitValueAndPropertyChanges();\n            await this._nextPick();\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__shortageButton____title\", \"Shortage\"),\n        shortcut: ['f4'],\n        buttonType: 'secondary',\n        isDisabled: true,\n        async onClick() {\n            await this.onSubmit(true);\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"shortageButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__chooseStockButton____title\", \"Choose stock\"),\n        shortcut: ['f2'],\n        buttonType: 'secondary',\n        async onClick() {\n            const pickStockLines = this._allPicks\n                .filter(allPick => allPick.confirmed)\n                .map(allPick => {\n                return {\n                    packingUnit: allPick.packingUnit,\n                    quantityInPackingUnit: allPick.quantityInPackingUnit,\n                    packingUnitToStockUnitConversionFactor: allPick.packingUnitToStockUnitConversionFactor,\n                    quantityInStockUnit: allPick.quantityInStockUnit,\n                    location: allPick.location,\n                    lot: allPick.lot,\n                    sublot: allPick.sublot,\n                    serialNumber: allPick.serialNumber,\n                    status: allPick.status,\n                    stockId: allPick.stockId,\n                };\n            });\n            this.packingUnit.isDirty = false;\n            this.quantityInPackingUnit.isDirty = false;\n            this.packingUnitToStockUnitConversionFactor.isDirty = false;\n            this.stockUnit.isDirty = false;\n            this.quantityInStockUnit.isDirty = false;\n            this.licensePlateNumber.isDirty = false;\n            this.location.isDirty = false;\n            this.lot.isDirty = false;\n            this.sublot.isDirty = false;\n            this.serialNumber.isDirty = false;\n            this.serialNumberReceived.isDirty = false;\n            this.status.isDirty = false;\n            this.identifier1.isDirty = false;\n            this.identifier2.isDirty = false;\n            this.destinationLocation.isDirty = false;\n            this.$.router.goTo(`@sage/x3-stock/MobilePickTicketViewPickTicketLineGlobal`, {\n                _id: `${this.product.value}|${String(this.$.storage.get('mobile-selected-stock-site'))}`,\n                mobileSettings: JSON.stringify(this._mobileSettings),\n                pickStockLines: JSON.stringify(pickStockLines),\n            });\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"chooseStockButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"detailBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__stockPickedBlock____title\", \"Stock picked\"),\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"stockPickedBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__destinationBlock____title\", \"To location\"),\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"destinationBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__pickTicket____title\", \"Pick ticket\"),\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"pickTicket\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__pickTicketLine____title\", \"Line\"),\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"pickTicketLine\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__product____title\", \"Product\"),\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"localizedDescription1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__displayQuantityToBePicked____title\", \"Line quantity in stock unit\"),\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"displayQuantityToBePicked\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__textQuantityToBePicked____title\", \"Line quantity in stock unit\"),\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"textQuantityToBePicked\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isReadOnly: true,\n        parent() {\n            return this.detailBlock;\n        },\n        isFullWidth: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"displayQuantityPicked\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.detailBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__quantityToPick____title\", \"Quantity to pick\"),\n        isReadOnly: true,\n        isFullWidth: false,\n        isHidden: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"quantityToPick\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.detailBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__quantityPicked____title\", \"Quantity picked\"),\n        isReadOnly: true,\n        isFullWidth: false,\n        isHidden: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"quantityPicked\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__packingUnit____title\", \"PAC Unit\"),\n        isMandatory: true,\n        async onChange() {\n            if (this.packingUnit.value) {\n                let pos = 0;\n                let oldConversionFactor = this.packingUnitToStockUnitConversionFactor.value;\n                const selectedValue = this.packingUnit.value;\n                pos = this._unitsOfMeasure\n                    .map(function (e) {\n                    return e.unit;\n                })\n                    .indexOf(selectedValue);\n                if (typesLib.strictNe(pos, -1)) {\n                    this.quantityInPackingUnit.scale = this._unitsOfMeasure[pos].numberOfDecimals;\n                    this.packingUnitToStockUnitConversionFactor.value =\n                        this._unitsOfMeasure[pos].unitToStockUnitConversionFactor;\n                    if (typesLib.eq(this.currentPackingUnitCode.value, this.stockUnit.value)) {\n                        this.quantityInPackingUnit.value = typesLib.div(this.quantityInPackingUnit.value, this.packingUnitToStockUnitConversionFactor.value);\n                    }\n                    else {\n                        if (typesLib.eq(this.packingUnit.value, this.stockUnit.value)) {\n                            this.quantityInPackingUnit.value = typesLib.mul(this.quantityInPackingUnit.value, oldConversionFactor);\n                        }\n                        else {\n                            this.quantityInPackingUnit.value = typesLib.div((typesLib.mul(this.quantityInPackingUnit.value, oldConversionFactor)), this.packingUnitToStockUnitConversionFactor.value);\n                        }\n                    }\n                    let unroundedQuantity = this.quantityInPackingUnit.value;\n                    this.quantityInPackingUnit.value = Number.parseFloat(this.quantityInPackingUnit.value.toFixed(this._unitsOfMeasure[pos].numberOfDecimals));\n                    if (typesLib.gt(typesLib.sub(this.quantityInPackingUnit.value, unroundedQuantity), 0)) {\n                        switch (this._unitsOfMeasure[pos].numberOfDecimals) {\n                            case 0:\n                                this.quantityInPackingUnit.value = typesLib.sub(this.quantityInPackingUnit.value, 1);\n                                break;\n                            case 1:\n                                this.quantityInPackingUnit.value = typesLib.sub(this.quantityInPackingUnit.value, typesLib.newDecimal(\"0.1\"));\n                                break;\n                            case 2:\n                                this.quantityInPackingUnit.value = typesLib.sub(this.quantityInPackingUnit.value, typesLib.newDecimal(\"0.01\"));\n                                break;\n                            case 3:\n                                this.quantityInPackingUnit.value = typesLib.sub(this.quantityInPackingUnit.value, typesLib.newDecimal(\"0.001\"));\n                                break;\n                            case 4:\n                                this.quantityInPackingUnit.value = typesLib.sub(this.quantityInPackingUnit.value, typesLib.newDecimal(\"0.0001\"));\n                                break;\n                            case 5:\n                                this.quantityInPackingUnit.value = typesLib.sub(this.quantityInPackingUnit.value, typesLib.newDecimal(\"0.00001\"));\n                                break;\n                            case 6:\n                                this.quantityInPackingUnit.value = typesLib.sub(this.quantityInPackingUnit.value, typesLib.newDecimal(\"0.000001\"));\n                                break;\n                        }\n                    }\n                    this.quantityInStockUnit.value = Number.parseFloat((typesLib.mul(this.quantityInPackingUnit.value, this.packingUnitToStockUnitConversionFactor.value)).toFixed(this._unitsOfMeasure[pos].numberOfDecimals));\n                    this.packingUnitToStockUnitConversionFactor.isDisabled =\n                        typesLib.strictEq(this.packingUnit.value, this.stockUnit.value) ||\n                            !this._unitsOfMeasure[pos].isPackingFactorEntryAllowed;\n                    this.currentPackingUnitCode.value = selectedValue;\n                    this._computeQuantityMax();\n                }\n                else {\n                    this.packingUnit.value = this.currentPackingUnitCode.value;\n                }\n            }\n            this.shortageButton.isDisabled = typesLib.strictNe(this.quantityInPackingUnit.value, 0);\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"packingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__quantityInPackingUnit____title\", \"PAC Qty\"),\n        isMandatory: true,\n        isFullWidth: false,\n        validation: /^([0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals)\n        min: 0,\n        scale() {\n            const pos = this._unitsOfMeasure\n                .map(function (e) {\n                return e.unit;\n            })\n                .indexOf(this.stockUnit?.value);\n            return this._unitsOfMeasure[pos]?.numberOfDecimals ?? 0;\n        },\n        onChange() {\n            if (typesLib.ne(this.quantityInPackingUnit.value, null)) {\n                let pos = this._unitsOfMeasure\n                    .map(function (e) {\n                    return e.unit;\n                })\n                    .indexOf(this.stockUnit.value);\n                // Calculate the new stock quantity\n                let newStockUnitQuantity = Number.parseFloat((typesLib.mul(this.quantityInPackingUnit.value, this.packingUnitToStockUnitConversionFactor.value)).toFixed(this._unitsOfMeasure[pos].numberOfDecimals));\n                if (typesLib.strictEq(this.quantityInStockUnit.max, undefined) || typesLib.lte(newStockUnitQuantity, this.quantityInStockUnit.max)) {\n                    this.quantityInStockUnit.value = newStockUnitQuantity;\n                }\n            }\n            this.shortageButton.isDisabled = typesLib.strictNe(this.quantityInPackingUnit.value, 0);\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"quantityInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__packingUnitToStockUnitConversionFactor____title\", \"Conversion factor\"),\n        isMandatory: true,\n        scale: 6,\n        validation: /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals) except 0\n        min: typesLib.newDecimal(\"0.000001\"),\n        isFullWidth: true,\n        onChange() {\n            if (this.packingUnitToStockUnitConversionFactor.value) {\n                let pos = this._unitsOfMeasure\n                    .map(function (e) {\n                    return e.unit;\n                })\n                    .indexOf(this.stockUnit.value);\n                let oldQuantityInStockUnit = this.quantityInStockUnit.value;\n                this.quantityInStockUnit.value = Number.parseFloat((typesLib.mul(this.quantityInPackingUnit.value, this.packingUnitToStockUnitConversionFactor.value)).toFixed(this._unitsOfMeasure[pos].numberOfDecimals));\n                if (typesLib.gt(typesLib.add(this.quantityInStockUnit.value, this.quantityPicked.value), this.quantityToPick.value)) {\n                    this.$.removeToasts();\n                    this.$.showToast(ui.localize('@sage/x3-stock/dialog-error-quantity-pick', 'Quantity greater than quantity to be picked'), { type: 'error' });\n                    this.quantityInStockUnit.value = oldQuantityInStockUnit;\n                    this.packingUnitToStockUnitConversionFactor.focus();\n                }\n                this._computeQuantityMax();\n            }\n            this.shortageButton.isDisabled = typesLib.strictNe(this.quantityInPackingUnit.value, 0);\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"packingUnitToStockUnitConversionFactor\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        isHidden: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"currentPackingUnitCode\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__stockUnit____title\", \"Stock unit\"),\n        isReadOnly: true,\n        parent() {\n            return this.stockPickedBlock;\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"stockUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__quantityInStockUnit____title\", \"Stock quantity\"),\n        isMandatory: true,\n        isFullWidth: false,\n        validation: /^([0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals)\n        min: 0,\n        scale() {\n            const pos = this._unitsOfMeasure\n                .map(function (e) {\n                return e.unit;\n            })\n                .indexOf(String(this.currentPackingUnitCode.value) ?? '');\n            return this._unitsOfMeasure[pos]?.numberOfDecimals ?? 0;\n        },\n        onChange() {\n            if (typesLib.ne(this.quantityInStockUnit.value, null) && typesLib.lte(this.quantityInStockUnit.value, this.quantityInStockUnit.max)) {\n                if (typesLib.gt(this.packingUnitToStockUnitConversionFactor.value, 0)) {\n                    let pos = this._unitsOfMeasure\n                        .map(function (e) {\n                        return e.unit;\n                    })\n                        .indexOf(this.currentPackingUnitCode.value);\n                    this.quantityInPackingUnit.value = typesLib.div(this.quantityInStockUnit.value, this.packingUnitToStockUnitConversionFactor.value);\n                    this.quantityInPackingUnit.value = Number.parseFloat(this.quantityInPackingUnit.value.toFixed(this._unitsOfMeasure[pos].numberOfDecimals));\n                }\n            }\n            this.shortageButton.isDisabled = typesLib.strictNe(this.quantityInStockUnit.value, 0);\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"quantityInStockUnit\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__licensePlateNumber____title\", \"License Plate Number\"),\n        isReadOnly: true,\n        isFullWidth: true,\n        parent() {\n            return this.stockPickedBlock;\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__location____title\", \"Location\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__location____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isAutoSelectEnabled: true,\n        minLookupCharacters: 1,\n        isFullWidth: true,\n        isMandatory: true,\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: { code: this.stockSite.value },\n                stock: {\n                    _atLeast: 1,\n                    product: {\n                        product: { code: this.product.value },\n                    },\n                },\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__location____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__location____columns__title__type\", \"Type\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n        async onChange() {\n            if (await this.location.value?.code) {\n                if (!(await this._validateStock(this.location?.title ?? ''))) {\n                    this.location.focus();\n                }\n                else {\n                    this.location.getNextField(true)?.focus();\n                }\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__lot____title\", \"Lot\"),\n        isMandatory: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__lot____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/Stock',\n        valueField: 'lot',\n        canFilter: false,\n        filter() {\n            const filter = {\n                stockSite: { code: this.stockSite.value },\n                product: { product: { code: this.product.value } },\n                isBeingCounted: false,\n            };\n            if (this.location.value?.code) {\n                filter.location = { code: this.location.value.code };\n            }\n            if (this.sublot.value?.sublot) {\n                filter.sublot = this.sublot.value.sublot;\n            }\n            return filter;\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__lot____columns__title__lot\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__lot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/StockStatus',\n                bind: 'status',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__lot____columns__title__identifier1\", \"Identifier 1\"),\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__lot____columns__title__identifier2\", \"Identifier 2\"),\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__lot____columns__title__stockId\", \"Stock Id\"),\n                isHidden: true,\n            }),\n        ],\n        async onChange() {\n            if (await this.lot.value?.lot) {\n                if (!this.sublot.isHidden) {\n                    this.sublot.value = { sublot: this.lot.value.sublot };\n                }\n                if (!(await this._validateStock(this.lot.title))) {\n                    this.lot.value = null;\n                    if (!this.sublot.isHidden) {\n                        this.sublot.value = null;\n                    }\n                    this.lot.focus();\n                }\n                else {\n                    this.lot.getNextField(true)?.focus();\n                }\n            }\n            else {\n                this.lot.value = null;\n                if (!this.sublot.isHidden) {\n                    this.sublot.value = null;\n                }\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__sublot____title\", \"Sublot\"),\n        isMandatory: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__sublot____placeholder\", \"Scan or select a sublot\"),\n        node: '@sage/x3-stock-data/Stock',\n        valueField: 'sublot',\n        canFilter: false,\n        filter() {\n            const filter = {\n                stockSite: { code: this.stockSite.value },\n                product: { product: { code: this.product.value } },\n                isBeingCounted: false,\n            };\n            if (this.lot.value?.lot) {\n                filter.lot = this.lot.value.lot;\n            }\n            if (this.location.value?.code) {\n                filter.location = { code: this.location.value.code };\n            }\n            return filter;\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__sublot____columns__title__lot\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__sublot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/StockStatus',\n                bind: 'status',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__sublot____columns__title__identifier1\", \"Identifier 1\"),\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__sublot____columns__title__identifier2\", \"Identifier 2\"),\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__sublot____columns__title__stockId\", \"Stock Id\"),\n                isHidden: true,\n            }),\n        ],\n        async onChange() {\n            if (await this.sublot.value?.sublot) {\n                if (!(await this._validateStock(this.sublot.title))) {\n                    this.sublot.value = null;\n                    this.sublot.focus();\n                }\n                else {\n                    this.sublot.getNextField(true)?.focus();\n                }\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumber____title\", \"Serial number\"),\n        isMandatory: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumber____placeholder\", \"Scan a serial number\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        canFilter: false,\n        filter() {\n            const filter = {\n                product: { code: this.product.value },\n                stockSite: { code: this.stockSite.value },\n            };\n            if (this.location.value?.code) {\n                filter.stockLine = { location: { code: this.location.value.code } };\n            }\n            return filter;\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumber____columns__title__code\", \"Serial number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Stock',\n                bind: 'stockLine',\n                valueField: 'status.code',\n                isHidden: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumber____columns__title__stockId\", \"Stock Id\"),\n                isHidden: true,\n            }),\n        ],\n        async onChange() {\n            if (await this.serialNumber.value?.code) {\n                if (!(await this._validateStock(this.serialNumber.title, this.serialNumber.value.stockId))) {\n                    this.serialNumber.value = null;\n                    this.serialNumber.focus();\n                }\n                else {\n                    this.serialNumber.getNextField(true)?.focus();\n                }\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumberReceived____title\", \"Serial number\"),\n        isMandatory: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumberReceived____placeholder\", \"Scan a serial number\"),\n        node: '@sage/x3-stock-data/Stock',\n        valueField: 'serialNumber',\n        canFilter: false,\n        filter() {\n            const filter = {\n                stockSite: { code: this.stockSite.value },\n                product: { product: { code: this.product.value } },\n                isBeingCounted: false,\n                allocatedQuantity: '0',\n            };\n            if (this.location.value?.code) {\n                filter.location = { code: this.location.value.code };\n            }\n            if (this.lot.value?.lot) {\n                filter.lot = this.lot.value.lot;\n            }\n            if (this.sublot.value?.sublot) {\n                filter.sublot = this.sublot.value.sublot;\n            }\n            return filter;\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumberReceived____columns__title__serialNumber\", \"Serial number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/StockStatus',\n                bind: 'status',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumberReceived____columns__title__identifier1\", \"Identifier 1\"),\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumberReceived____columns__title__identifier2\", \"Identifier 2\"),\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__serialNumberReceived____columns__title__stockId\", \"Stock Id\"),\n                isHidden: true,\n            }),\n        ],\n        async onChange() {\n            if (await this.serialNumberReceived.value?.serialNumber) {\n                if (!(await this._validateStock(this.serialNumberReceived.title))) {\n                    this.serialNumberReceived.value = null;\n                    this.serialNumberReceived.focus();\n                }\n                else {\n                    this.serialNumberReceived.getNextField(true)?.focus();\n                }\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"serialNumberReceived\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__status____title\", \"Status\"),\n        isMandatory: true,\n        async onChange() {\n            if (this.status.value) {\n                if (!(await this._validateStock(this.status.title))) {\n                    this.status.focus();\n                }\n                else {\n                    this.status.getNextField(true)?.focus();\n                }\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__identifier1____title\", \"Identifier 1\"),\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__identifier2____title\", \"Identifier 2\"),\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"identifier2\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__destinationLocation____title\", \"Destination location\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__destinationLocation____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        canFilter: false,\n        isAutoSelectEnabled: true,\n        isTitleHidden: true,\n        filter() {\n            return {\n                stockSite: { code: this.stockSite.value },\n                category: 'internal',\n                isBlocked: { _eq: false },\n                isBeingCounted: { _eq: false },\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__destinationLocation____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__destinationLocation____columns__title__type\", \"Type\"),\n                isReadOnly: true,\n            }),\n        ],\n        minLookupCharacters: 1,\n        isMandatory: false,\n        isFullWidth: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"destinationLocation\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"sourcePickTicketType\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"sourcePickTicket\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isHidden: true,\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"sourcePickTicketLine\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isHidden: true,\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"sourcePickTicketSequenceNumber\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isHidden: true,\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"sourcePickTicketSubcontractType\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n        isReadOnly: true,\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"subcontractReorderLocation\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        isHidden: true,\n        isReadOnly: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__customBoolean____title\", \"custom boolean\"),\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"customBoolean\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        isHidden: true,\n        isReadOnly: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__customDecimal____title\", \"custom decimal\"),\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"customDecimal\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        isHidden: true,\n        isReadOnly: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__customString____title\", \"custom text\"),\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"customString\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.stockPickedBlock;\n        },\n        isHidden: true,\n        isReadOnly: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line__customDate____title\", \"custom date\"),\n    })\n], MobilePickTicketViewPickTicketLine.prototype, \"customDate\", void 0);\nexports.MobilePickTicketViewPickTicketLine = MobilePickTicketViewPickTicketLine = MobilePickTicketViewPickTicketLine_1 = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line____title\", \"Pick ticket\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line____subtitle\", \"Enter line details\"),\n        mode: 'default',\n        isTransient: true,\n        isTitleHidden: true,\n        headerCard() {\n            return {\n                title: this.pickTicket,\n                titleRight: this.pickTicketLine,\n                line2: this.product,\n                line2Right: this.localizedDescription1,\n                line3: this.textQuantityToBePicked,\n                line3Right: this.displayQuantityToBePicked,\n            };\n        },\n        async onLoad() {\n            let ticketLine = this.$.storage.get(MobilePickTicketViewPickTicketLine.PICK_TICKET_LINE_KEY);\n            if (ticketLine) {\n                await this._init();\n                if (typesLib.lte(this._allPicks.length, 1)) {\n                    this.nextButton.isDisabled = true;\n                }\n                await this._displayPick();\n            }\n            else {\n                this._disablePage();\n            }\n        },\n        businessActions() {\n            return [this.pickButton, this.nextButton, this.shortageButton, this.chooseStockButton];\n        },\n    })\n], MobilePickTicketViewPickTicketLine);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9saWIvcGFnZXMvbW9iaWxlLXBpY2stdGlja2V0LXZpZXctcGljay10aWNrZXQtbGluZS50cyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUNBLDhKQUFzRztBQUd0RywyRkFBcUg7QUFDckgsdUVBQXFDO0FBQ3JDLDhHQUFrRTtBQUNsRSw4R0FBNEQ7QUE2RnJELElBQU0sa0NBQWtDLEdBQXhDLE1BQU0sa0NBQW1DLFNBQVEsRUFBRSxDQUFDLElBQWM7SUFBbEU7O1FBQ0g7Ozs7V0FJRztRQUNLLGNBQVMsR0FBRyxJQUFJLHVCQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7SUFvd0VoRCxDQUFDOztJQWh2RUc7O09BRUc7YUFDcUIsb0JBQWUsR0FBVyxzQ0FBc0MsQ0FBQzthQUNqRSxvQkFBZSxHQUFXLHlDQUF5QyxDQUFDO2FBQ3BFLDRCQUF1QixHQUFXLGlEQUFpRCxDQUFDO2FBQ3BGLGtCQUFhLEdBQVcsOEJBQThCLENBQUM7YUFDdkQsb0JBQWUsR0FBVyxvQkFBb0IsQ0FBQzthQUMvQyx5QkFBb0IsR0FBVyx5QkFBeUIsQ0FBQzthQUN6RCwwQkFBcUIsR0FBVyw4QkFBOEIsQ0FBQztJQTA1Qi9FLFlBQVk7UUFDaEIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1FBQ2hDLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUNoQyxJQUFJLENBQUMsY0FBYyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7UUFDcEMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7UUFDdkMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1FBQ3BDLElBQUksQ0FBQyxjQUFjLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUNwQyxJQUFJLENBQUMscUJBQXFCLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUMzQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUN6QyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7UUFDOUIsSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUM1QixJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7UUFDbEMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7UUFDMUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1FBQzVELElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUM1QixJQUFJLENBQUMsbUJBQW1CLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUN6QyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUN4QyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7UUFDakMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxFQUFFLENBQUM7SUFDcEIsQ0FBQztJQUVEOztPQUVHO0lBRUssS0FBSyxDQUFDLEtBQUs7UUFDZjs7V0FFRztRQUVILElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxvQ0FBa0MsQ0FBQyxlQUFlLENBQUMsQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUMxRyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU87YUFDckMsR0FBRyxDQUFDLG9DQUFrQyxDQUFDLG9CQUFvQixDQUFDO2FBQzVELFFBQVEsRUFBRSxDQUFDO1FBQ2hCLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxRQUFRO1lBQzdCLHNCQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsb0NBQWtDLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxRQUFRLEVBQUUsRUFBSyxHQUFHLEVBQzdGLENBQUMsQ0FBQyxJQUFJO2dCQUNOLENBQUMsQ0FBQyxLQUFLLENBQUM7UUFDaEIsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssR0FBRztZQUM3QixJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLG9DQUFrQyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFFBQVEsRUFBRTtTQUMxRixDQUFDO1FBQ0YsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLDRCQUE0QixDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDbkYsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLG9DQUFrQyxDQUFDLGFBQWEsQ0FBQyxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQ3RHLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxvQ0FBa0MsQ0FBQyxlQUFlLENBQUMsQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUMzRyxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxlQUFlLEVBQUUsY0FBd0IsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFDO1FBQ3BCLElBQUksQ0FBQyxjQUFjLEdBQUcsQ0FBQyxDQUFDO1FBQ3hCLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUM5QixJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUM7UUFDOUIsSUFBSSxDQUFDLFdBQVcsR0FBRyxDQUFDLENBQUM7UUFDckIsSUFBSSxDQUFDLGFBQWEsR0FBRyxDQUFDLENBQUM7UUFDdkIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7UUFDckIsSUFBSSxDQUFDLGVBQWUsR0FBRyxFQUFFLENBQUM7UUFDMUIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPLEdBQUcsTUFBTSxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7UUFDbkQsSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxDQUFDO1lBQ3hCLElBQUksQ0FBQztnQkFDRCxNQUFNLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQyxDQUFDLDBCQUEwQjtZQUM1RCxDQUFDO1lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztnQkFDVCxFQUFFLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUN4QixDQUFDO1FBQ0wsQ0FBQztRQUNELHNCQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFLLENBQUMsR0FBRSxDQUFDO1lBQzlCLE1BQU0sMkJBQWEsRUFDZixJQUFJLEVBQ0osT0FBTyxFQUNQLEVBQUUsQ0FBQyxRQUFRLENBQUMsbUNBQW1DLEVBQUUsT0FBTyxDQUFDLEVBQ3pELEVBQUUsQ0FBQyxRQUFRLENBQUMsa0RBQWtELEVBQUUsMEJBQTBCLENBQUMsQ0FDOUYsQ0FBQztZQUNGLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxFQUFFLENBQUM7UUFDcEIsQ0FBQzthQUFNLENBQUM7WUFDSixJQUFJLENBQUM7Z0JBQ0QsSUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLEdBQUcsTUFBTSxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7WUFDdkQsQ0FBQztZQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7Z0JBQ1QsRUFBRSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDeEIsQ0FBQztRQUNMLENBQUM7SUFDTCxDQUFDO0lBRUQ7O09BRUc7SUFDSyxLQUFLLENBQUMsZUFBZTtRQUN6QixNQUFNLFFBQVEsR0FBRyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSzthQUM5QixJQUFJLENBQUMsK0JBQStCLENBQUM7YUFDckMsS0FBSyxDQUNGLEVBQUUsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUN2QjtZQUNJLFVBQVUsRUFBRSxJQUFJO1lBQ2hCLGNBQWMsRUFBRSxJQUFJO1lBQ3BCLE9BQU8sRUFBRTtnQkFDTCxJQUFJLEVBQUUsSUFBSTtnQkFDVixxQkFBcUIsRUFBRSxJQUFJO2dCQUMzQixpQkFBaUIsRUFBRSxJQUFJO2dCQUN2QiwwQkFBMEIsRUFBRSxJQUFJO2FBQ25DO1lBQ0QsbUJBQW1CLEVBQUUsSUFBSTtZQUN6QixTQUFTLEVBQUU7Z0JBQ1AsSUFBSSxFQUFFLElBQUk7Z0JBQ1YsZ0JBQWdCLEVBQUUsSUFBSTthQUN6QjtZQUNELHNDQUFzQyxFQUFFLElBQUk7WUFDNUMsV0FBVyxFQUFFO2dCQUNULElBQUksRUFBRSxJQUFJO2dCQUNWLGdCQUFnQixFQUFFLElBQUk7YUFDekI7WUFDRCxpQkFBaUIsRUFBRSxJQUFJO1lBQ3ZCLGdCQUFnQixFQUFFLElBQUk7WUFDdEIsYUFBYSxFQUFFLElBQUk7WUFDbkIsY0FBYyxFQUFFO2dCQUNaLEtBQUssRUFBRTtvQkFDSCxLQUFLLEVBQUU7d0JBQ0gsSUFBSSxFQUFFOzRCQUNGLE9BQU8sRUFBRSxJQUFJOzRCQUNiLG1CQUFtQixFQUFFLElBQUk7NEJBQ3pCLFlBQVksRUFBRSxJQUFJOzRCQUNsQixjQUFjLEVBQUUsSUFBSTs0QkFDcEIsU0FBUyxFQUFFO2dDQUNQLEdBQUcsRUFBRSxJQUFJO2dDQUNULE1BQU0sRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUU7Z0NBQ3RCLE1BQU0sRUFBRSxJQUFJO2dDQUNaLFlBQVksRUFBRSxJQUFJO2dDQUNsQixRQUFRLEVBQUU7b0NBQ04sSUFBSSxFQUFFLElBQUk7aUNBQ2I7Z0NBQ0QscUJBQXFCLEVBQUUsSUFBSTtnQ0FDM0IsbUJBQW1CLEVBQUUsSUFBSTtnQ0FDekIsc0NBQXNDLEVBQUUsSUFBSTtnQ0FDNUMsV0FBVyxFQUFFO29DQUNULElBQUksRUFBRSxJQUFJO2lDQUNiO2dDQUNELGtCQUFrQixFQUFFLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRTtnQ0FDbEMsV0FBVyxFQUFFLElBQUk7Z0NBQ2pCLFdBQVcsRUFBRSxJQUFJOzZCQUNwQjt5QkFDSjtxQkFDSjtvQkFDRCxNQUFNLEVBQUU7d0JBQ0osS0FBSyxFQUFFLEdBQUc7cUJBQ2I7aUJBQ0o7YUFDSjtZQUNELG9CQUFvQixFQUFFLElBQUk7WUFDMUIsZ0JBQWdCLEVBQUUsSUFBSTtZQUN0QixvQkFBb0IsRUFBRSxJQUFJO1lBQzFCLDhCQUE4QixFQUFFLElBQUk7WUFDcEMsK0JBQStCLEVBQUUsSUFBSTtZQUNyQywwQkFBMEIsRUFBRSxJQUFJO1NBQ25DLEVBQ0Q7WUFDSSxNQUFNLEVBQUU7Z0JBQ0osVUFBVSxFQUFFLEVBQUUsR0FBRyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFO2dCQUMxQyxjQUFjLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDO2FBQ3BEO1NBQ0osQ0FDSixDQUNKO2FBQ0EsT0FBTyxFQUFFLENBQUM7UUFFZixJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssc0JBQUksUUFBUSxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUssQ0FBQyxHQUFFLENBQUM7WUFDakQsTUFBTSxJQUFJLEtBQUssQ0FDWCxFQUFFLENBQUMsUUFBUSxDQUFDLHVEQUF1RCxFQUFFLGlDQUFpQyxDQUFDLENBQzFHLENBQUM7UUFDTixDQUFDO1FBRUQ7O1dBRUc7UUFDSCxJQUFJLFFBQVEsR0FBRyxDQUFDLENBQUM7UUFDakIsTUFBTSxVQUFVLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNyQyxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssR0FBRyxVQUFVLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUM7UUFDbEQsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssR0FBRyxVQUFVLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQztRQUNqRixJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRyxVQUFVLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUM7UUFDdEQsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssR0FBRyxVQUFVLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQztRQUNoRixJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLGdCQUFnQixDQUFDO1FBQzVFLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxLQUFLLDZCQUNoQyxNQUFNLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxnQkFBZ0IsQ0FBQyxFQUMvRixHQUFHLEdBQ0gsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUM7UUFDekIsSUFBSSxDQUFDLHNCQUFzQixDQUFDLEtBQUssR0FBRyxFQUFFLENBQUMsUUFBUSxDQUFDLCtCQUErQixFQUFFLG9CQUFvQixDQUFDLENBQUM7UUFDdkcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssMENBQzVCLEVBQUUsQ0FBQyxRQUFRLENBQUMsK0JBQStCLEVBQUUsbUJBQW1CLENBQUMsRUFDakUsTUFBTSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLGdCQUFnQixDQUFDLEdBQ3JGLEdBQUcsR0FDSCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBQztRQUN6QixJQUFJLENBQUMsb0JBQW9CLENBQUMsS0FBSyxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7UUFDdkUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssR0FBRyxVQUFVLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQy9ELElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLEdBQUcsVUFBVSxDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztRQUN2RSxJQUFJLENBQUMsOEJBQThCLENBQUMsS0FBSyxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUMsOEJBQThCLENBQUM7UUFDM0YsSUFBSSxDQUFDLCtCQUErQixDQUFDLEtBQUssR0FBRyxVQUFVLENBQUMsSUFBSSxDQUFDLCtCQUErQixDQUFDO1FBQzdGLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxLQUFLLEdBQUcsVUFBVSxDQUFDLElBQUksQ0FBQywwQkFBMEIsQ0FBQztRQUVuRixNQUFNLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUUxRCxzQkFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLG1CQUFtQixFQUFLLFlBQVksR0FBRSxDQUFDO1lBQ3JELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGlCQUFpQixDQUFDO1lBQzFELElBQUksQ0FBQywyQkFBMkIsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLDBCQUEwQixDQUFDO1lBQzVFLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7WUFDaEMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsbUJBQW1CLENBQUM7WUFDOUQsSUFBSSxDQUFDLDRCQUE0QixHQUFHLEtBQUssQ0FBQztZQUMxQyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyx5QkFBeUIsQ0FBQztRQUM5RSxDQUFDO2FBQU0sQ0FBQztZQUNKLE1BQU0sSUFBSSxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQzlELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQztZQUN0RSxJQUFJLENBQUMsMkJBQTJCLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUMsMEJBQTBCLENBQUM7WUFDeEYsSUFBSSxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsaUJBQWlCLENBQUM7WUFDOUQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLG1CQUFtQixDQUFDO1lBQzFFLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLDJCQUEyQixDQUFDO1lBQ2xGLElBQUksQ0FBQywwQkFBMEIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyx5QkFBeUIsQ0FBQztRQUMxRixDQUFDO1FBQ0QsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUV4RTs7O1dBR0c7UUFDSCxLQUFLLE1BQU0sZUFBZSxJQUFJLFVBQVUsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztZQUN2RSxnQkFBSSxNQUFNLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsRUFBSSxtQkFBbUIsR0FBRSxDQUFDO2dCQUNyRSxRQUFRLEdBQUcsZUFBZSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUNsRCxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQztvQkFDaEIsYUFBYSxFQUFFLFVBQVUsQ0FBQyxJQUFJLENBQUMsYUFBYTtvQkFDNUMsa0JBQWtCLEVBQUUsUUFBUTtvQkFDNUIsaUJBQWlCLEVBQUUsTUFBTSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7b0JBQzVELGdCQUFnQixFQUFFLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO29CQUMxRCxtQkFBbUIsRUFBRSxRQUFRO3dCQUN6QixDQUFDLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7d0JBQ2xELENBQUMsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztvQkFDakQsT0FBTyxFQUFFLE1BQU0sQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztvQkFDN0MsV0FBVyxFQUFFLFFBQVE7d0JBQ2pCLENBQUMsQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsSUFBSTt3QkFDakQsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUk7b0JBQ3BDLGVBQWUsRUFBRSxRQUFRO3dCQUNyQixDQUFDLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDLElBQUk7d0JBQ2pELENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJO29CQUNwQyxzQ0FBc0MsRUFBRSxRQUFRO3dCQUM1QyxDQUFDLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLHNDQUFzQyxDQUFDO3dCQUMvRSxDQUFDLENBQUMsQ0FBQztvQkFDUCxxQkFBcUIsRUFBRSxRQUFRO3dCQUMzQixDQUFDLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FDYixNQUFNLGNBQ0YsTUFBTSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsRUFDNUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLHNDQUFzQyxDQUFDLEVBQ3BGLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLENBQUMsQ0FDOUM7d0JBQ0gsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDO29CQUNqRCxHQUFHLEVBQUUsUUFBUSxDQUFDLENBQUMsQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLElBQUk7b0JBQ3pELE1BQU0sRUFBRSxRQUFRLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsSUFBSTtvQkFDL0QsWUFBWSxFQUFFLFFBQVE7d0JBQ2xCLENBQUMsQ0FBQyxzQkFBSSxDQUFDLDJCQUEyQixFQUFLLHNCQUFzQixFQUN6RCxDQUFDLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxZQUFZOzRCQUNuQyxDQUFDLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWTt3QkFDakQsQ0FBQyxDQUFDLElBQUk7b0JBQ1YsTUFBTSxFQUFFLFFBQVEsQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSTtvQkFDckUsUUFBUSxFQUNKLFFBQVEsSUFBSSxlQUFlLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRO3dCQUMvQyxDQUFDLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxFQUFFLElBQUk7d0JBQy9DLENBQUMsQ0FBQyxJQUFJO29CQUNkLFNBQVMsRUFBRSxDQUFDO29CQUNaLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxDQUFDLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJO29CQUM3RixXQUFXLEVBQUUsUUFBUSxDQUFDLENBQUMsQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLElBQUk7b0JBQ3pFLFdBQVcsRUFBRSxRQUFRLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUMsSUFBSTtpQkFDNUUsQ0FBQyxDQUFDO2dCQUNILHNDQUFJLENBQUMsYUFBYSxFQUFJLENBQUMsRUFBQztZQUM1QixDQUFDO1FBQ0wsQ0FBQztRQUNELHNCQUFJLElBQUksQ0FBQyxhQUFhLEVBQUssQ0FBQyxHQUFFLENBQUM7WUFDM0IsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUM7Z0JBQ2hCLGFBQWEsRUFBRSxVQUFVLENBQUMsSUFBSSxDQUFDLGFBQWE7Z0JBQzVDLGtCQUFrQixFQUFFLENBQUM7Z0JBQ3JCLGlCQUFpQixFQUFFLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO2dCQUM1RCxnQkFBZ0IsRUFBRSxNQUFNLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDMUQsbUJBQW1CLEVBQUUsTUFBTSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7Z0JBQ2hFLE9BQU8sRUFBRSxDQUFDO2dCQUNWLFdBQVcsRUFBRSxVQUFVLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxJQUFJO2dCQUM1QyxlQUFlLEVBQUUsVUFBVSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSTtnQkFDaEQsc0NBQXNDLEVBQUUsQ0FBQztnQkFDekMscUJBQXFCLEVBQUUsTUFBTSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7Z0JBQ2xFLEdBQUcsRUFBRSxJQUFJO2dCQUNULE1BQU0sRUFBRSxJQUFJO2dCQUNaLFlBQVksRUFBRSxJQUFJO2dCQUNsQixNQUFNLEVBQUUsSUFBSTtnQkFDWixRQUFRLEVBQUUsSUFBSTtnQkFDZCxTQUFTLEVBQUUsQ0FBQztnQkFDWixrQkFBa0IsRUFBRSxJQUFJO2FBQzNCLENBQUMsQ0FBQztZQUNILHNDQUFJLENBQUMsYUFBYSxFQUFJLENBQUMsRUFBQztRQUM1QixDQUFDO0lBQ0wsQ0FBQztJQUVEOztPQUVHO0lBQ0ssS0FBSyxDQUFDLFVBQVU7UUFDcEIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUM7WUFDdEIsSUFBSSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLElBQUk7WUFDbEMsK0JBQStCLEVBQUUsQ0FBQztZQUNsQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxnQkFBZ0I7WUFDMUQsMkJBQTJCLEVBQUUsS0FBSztTQUNyQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUs7WUFDckIsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLO2dCQUN6QixJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSztvQkFDMUIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsZ0JBQWdCLENBQUM7UUFDakQsS0FBSyxNQUFNLFNBQVMsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDN0QsSUFDSSxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsZ0JBQzFCLElBQUksQ0FBQyxlQUFlLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFLGFBQUMsSUFBSSxDQUFDLElBQUksRUFBSSxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUMsQ0FBQyxNQUFNLEVBQUksQ0FBQyxHQUMvRixDQUFDO2dCQUNDLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDO29CQUN0QixJQUFJLEVBQUUsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSTtvQkFDckMsK0JBQStCLEVBQUUsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsc0NBQXNDLENBQUM7b0JBQzlGLGdCQUFnQixFQUFFLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLGdCQUFnQjtvQkFDN0QsMkJBQTJCLEVBQUUsSUFBSTtpQkFDcEMsQ0FBQyxDQUFDO1lBQ1AsQ0FBQztRQUNMLENBQUM7UUFDRCxzQkFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBSyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRSxDQUFDO1lBQ2xELElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQztRQUN0RSxDQUFDO2FBQU0sQ0FBQztZQUNKLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxlQUFlO2lCQUNsQyxHQUFHLENBQUMsVUFBVSxDQUFDO2dCQUNaLE9BQU8sQ0FBQyxDQUFDLElBQUksQ0FBQztZQUNsQixDQUFDLENBQUM7aUJBQ0QsT0FBTyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDckMsc0JBQUksWUFBWSxFQUFLLENBQUMsQ0FBQyxHQUFFLENBQUM7Z0JBQ3RCLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQztZQUMzRixDQUFDO1FBQ0wsQ0FBQztRQUVELE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxRQUFhLEVBQUUsRUFBRTtZQUM5QyxPQUFPLFFBQVEsQ0FBQyxJQUFJLENBQUM7UUFDekIsQ0FBQyxDQUFDLENBQUM7SUFDUCxDQUFDO0lBRUQ7O09BRUc7SUFDSyxLQUFLLENBQUMsU0FBUztRQUNuQixJQUFJLGdCQUFnQixHQUFHLElBQUksQ0FBQyxXQUFXLENBQUM7UUFDeEMsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDO1FBQ3hCLE9BQU8sWUFBWSxFQUFFLENBQUM7WUFDbEIsNkJBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLEVBQUcsQ0FBQyxHQUFHLElBQUksQ0FBQyxXQUFXLEdBQUUsQ0FBQztnQkFDL0Msb0NBQUksQ0FBQyxXQUFXLEVBQUksQ0FBQyxFQUFDO1lBQzFCLENBQUM7aUJBQU0sQ0FBQztnQkFDSixJQUFJLENBQUMsV0FBVyxHQUFHLENBQUMsQ0FBQztZQUN6QixDQUFDO1lBQ0Qsc0JBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsU0FBUyxFQUFLLENBQUMsR0FBRSxDQUFDO2dCQUNuRCxZQUFZLEdBQUcsS0FBSyxDQUFDO1lBQ3pCLENBQUM7WUFDRCxzQkFBSSxJQUFJLENBQUMsV0FBVyxFQUFLLGdCQUFnQixHQUFFLENBQUM7Z0JBQ3hDLFlBQVksR0FBRyxLQUFLLENBQUM7Z0JBQ3JCLElBQUksQ0FBQyxVQUFVLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztZQUN0QyxDQUFDO1FBQ0wsQ0FBQztRQUNELE1BQU0sSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO1FBQzFCLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUUsQ0FBQztJQUN2QyxDQUFDO0lBRUQ7OztPQUdHO0lBQ0ssY0FBYyxDQUFDLFdBQW1CO1FBQ3RDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDO1lBQ2hCLGFBQWEsRUFBRSxDQUFDO1lBQ2hCLGtCQUFrQixFQUFFLENBQUM7WUFDckIsaUJBQWlCLEVBQUUsQ0FBQztZQUNwQixnQkFBZ0IsRUFBRSxDQUFDO1lBQ25CLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUs7WUFDL0IsT0FBTyxFQUFFLENBQUM7WUFDVixXQUFXLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLO1lBQ2pDLGVBQWUsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUs7WUFDckMsc0NBQXNDLEVBQUUsQ0FBQztZQUN6QyxtQkFBbUIsRUFBRSxNQUFNLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQzNGLHFCQUFxQixFQUFFLE1BQU0sQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDN0YsR0FBRyxFQUFFLElBQUk7WUFDVCxNQUFNLEVBQUUsSUFBSTtZQUNaLFlBQVksRUFBRSxJQUFJO1lBQ2xCLE1BQU0sRUFBRSxJQUFJO1lBQ1osUUFBUSxFQUFFLElBQUk7WUFDZCxTQUFTLEVBQUUsQ0FBQztZQUNaLGtCQUFrQixFQUFFLElBQUk7U0FDM0IsQ0FBQyxDQUFDO1FBQ0gsc0NBQUksQ0FBQyxhQUFhLEVBQUksQ0FBQyxFQUFDO1FBQ3hCLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDO1FBQ3BCLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQztRQUNsRSxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztJQUMvQixDQUFDO0lBRU8sbUJBQW1CO1FBQ3ZCLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxHQUFHLGdCQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFDO1FBQ3JGLHNCQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFLLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxHQUFFLENBQUM7WUFDbEQsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEdBQUcsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsR0FBRyxDQUFDO1FBQ2xFLENBQUM7YUFBTSxDQUFDO1lBQ0osSUFBSSxZQUFZLGdCQUFHLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxHQUFHLEVBQUcsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssRUFBQztZQUNwRyxJQUFJLENBQUMscUJBQXFCLENBQUMsR0FBRyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUMvRyxDQUFDO0lBQ0wsQ0FBQztJQUNEOztPQUVHO0lBQ0ssS0FBSyxDQUFDLFlBQVk7UUFDdEIsNkJBQTZCO1FBQzdCLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztRQUMzQixJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUM7UUFDOUIsSUFBSSxDQUFDLHNCQUFzQixDQUFDLEtBQUssR0FBRyxJQUFJLENBQUM7UUFDekMsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUM7UUFDekQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDO1FBQ3RCLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztRQUN6QixzQkFBSSxJQUFJLENBQUMsMkJBQTJCLEVBQUssZ0JBQWdCLEdBQUUsQ0FBQztZQUN4RCxJQUFJLENBQUMsb0JBQW9CLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztRQUMzQyxDQUFDO2FBQU0sc0JBQUksSUFBSSxDQUFDLDJCQUEyQixFQUFLLHNCQUFzQixHQUFFLENBQUM7WUFDckUsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDO1FBQ25DLENBQUM7UUFDRCxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDO1FBQzlCLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztRQUM5QixNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsNkJBQTZCLEVBQUUsQ0FBQztRQUM3QyxFQUFFO1FBQ0YsTUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDckQsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEdBQUcsV0FBVyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsRUFBRSxJQUFJLEVBQUUsV0FBVyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDbkYsSUFBSSxDQUFDLFdBQVcsQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLFdBQVcsQ0FBQztRQUN0RSxJQUFJLENBQUMsc0JBQXNCLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLGVBQWUsQ0FBQztRQUNyRixJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSztZQUM3QyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxzQ0FBc0MsQ0FBQztRQUU1RSxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLG1CQUFtQixDQUFDO1FBQ3RGLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMscUJBQXFCLENBQUM7UUFDMUYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQzdHLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLE1BQU07WUFDdkQsQ0FBQyxDQUFDLEVBQUUsTUFBTSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLE1BQU0sRUFBRTtZQUNyRCxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ1gsc0JBQUksSUFBSSxDQUFDLDJCQUEyQixFQUFLLGdCQUFnQixHQUFFLENBQUM7WUFDeEQsSUFBSSxDQUFDLG9CQUFvQixDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxZQUFZO2dCQUMzRSxDQUFDLENBQUMsRUFBRSxZQUFZLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsWUFBWSxFQUFFO2dCQUNqRSxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ2YsQ0FBQzthQUFNLHNCQUFJLElBQUksQ0FBQywyQkFBMkIsRUFBSyxzQkFBc0IsR0FBRSxDQUFDO1lBQ3JFLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLFlBQVk7Z0JBQ25FLENBQUMsQ0FBQyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxZQUFZLEVBQUU7Z0JBQ3pELENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDZixDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUMxQyxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDakYsaUJBQUksS0FBSyxFQUFJLENBQUMsR0FBRSxDQUFDO2dCQUNiLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ25ELENBQUM7UUFDTCxDQUFDO1FBQ0QsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDMUIsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUM7WUFDdEQsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUM7UUFDbEQsQ0FBQztRQUNELElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsa0JBQWtCLENBQUM7UUFDcEYsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsV0FBVyxDQUFDO1FBQ3RFLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLFdBQVcsQ0FBQztRQUN0RSxJQUFJLENBQUMsY0FBYyxDQUFDLFVBQVUscUJBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBSyxDQUFDLEVBQUM7UUFDeEUsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLDZCQUE2QixFQUFFLENBQUM7UUFDN0Msc0JBQUksSUFBSSxDQUFDLG9CQUFvQixFQUFLLFlBQVksR0FBRSxDQUFDO1lBQzdDLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztZQUM5QixJQUFJLENBQUMsbUJBQW1CLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztZQUN6QyxJQUFJLENBQUMsR0FBRyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7WUFDekIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1lBQzVCLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztZQUNsQyxJQUFJLENBQUMsb0JBQW9CLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztZQUMxQyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7WUFDNUIsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUM7WUFDeEMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1lBQ2pDLElBQUksQ0FBQyxXQUFXLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUNyQyxDQUFDO2FBQU0sQ0FBQztZQUNKLHNCQUFJLFdBQVcsQ0FBQyxrQkFBa0IsRUFBSyxDQUFDLEdBQUUsQ0FBQztnQkFDdkMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO2dCQUMzQixJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7Z0JBQzlCLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztnQkFDcEMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7Z0JBQzVDLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztnQkFDOUIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO2dCQUNoQyxJQUFJLENBQUMsV0FBVyxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7Z0JBQ25DLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO2dCQUM5RCxJQUFJLENBQUMsV0FBVyxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7Z0JBQ25DLElBQUksQ0FBQyxXQUFXLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztZQUN2QyxDQUFDO2lCQUFNLENBQUM7Z0JBQ0osSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO2dCQUM1QixJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7Z0JBQy9CLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztnQkFDckMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7Z0JBQzdDLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztnQkFDL0IsSUFBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO2dCQUNqQyxJQUFJLENBQUMsV0FBVyxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7Z0JBQ3BDLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxVQUFVLHFCQUNsRCxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBSyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBQztZQUN4RCxDQUFDO1lBQ0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxRQUFRLHFCQUFHLElBQUksQ0FBQyxrQkFBa0IsRUFBSyxZQUFZLEVBQUM7WUFDN0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRO2dCQUNoQixzQkFBSSxDQUFDLGtCQUFrQixFQUFLLFlBQVksdUJBQ3hDLElBQUksQ0FBQyxrQkFBa0IsRUFBSyxhQUFhLHVCQUN6QyxJQUFJLENBQUMsa0JBQWtCLEVBQUssY0FBYyxFQUFDO1lBQy9DLElBQUksQ0FBQyxHQUFHLENBQUMsV0FBVztnQkFDaEIsc0JBQUksQ0FBQyxrQkFBa0IsRUFBSyxjQUFjLHVCQUFJLElBQUksQ0FBQyxrQkFBa0IsRUFBSyxjQUFjLEVBQUM7WUFDN0YsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxXQUFXLENBQUM7WUFDL0MsSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRO2dCQUN0QixzQkFBSSxDQUFDLDJCQUEyQixFQUFLLFlBQVksdUJBQ2pELElBQUksQ0FBQywyQkFBMkIsRUFBSyxRQUFRLHVCQUM3QyxJQUFJLENBQUMsMkJBQTJCLEVBQUssZ0JBQWdCLEVBQUM7WUFDMUQsSUFBSSxDQUFDLG9CQUFvQixDQUFDLFFBQVE7Z0JBQzlCLHNCQUFJLENBQUMsMkJBQTJCLEVBQUssWUFBWSx1QkFDakQsSUFBSSxDQUFDLDJCQUEyQixFQUFLLFFBQVEsdUJBQzdDLElBQUksQ0FBQywyQkFBMkIsRUFBSyxzQkFBc0IsRUFBQztZQUNoRSxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsR0FBRyxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztZQUNsRCxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxHQUFHLENBQUMsQ0FDaEMsNkJBQVcsQ0FBQyxrQkFBa0IsRUFBSyxDQUFDLEtBQUksSUFBSSxDQUFDLDRCQUE0QixDQUM1RSxDQUFDO1lBQ0YsSUFBSSxDQUFDLFdBQVcsQ0FBQyxRQUFRLEdBQUcsQ0FBQyxDQUFDLDZCQUFXLENBQUMsa0JBQWtCLEVBQUssQ0FBQyxLQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDOUYsSUFBSSxDQUFDLFdBQVcsQ0FBQyxRQUFRLEdBQUcsQ0FBQyxDQUFDLDZCQUFXLENBQUMsa0JBQWtCLEVBQUssQ0FBQyxLQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbEcsQ0FBQztRQUNELG1DQUFJLElBQUksQ0FBQyxjQUFjLEVBQUcsQ0FBQyxHQUFLLElBQUksQ0FBQyxhQUFhLEdBQUUsQ0FBQztZQUNqRCxJQUFJLENBQUMsVUFBVSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7UUFDdEMsQ0FBQztRQUNELElBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO0lBQy9CLENBQUM7SUFFRDs7T0FFRztJQUNLLG1CQUFtQjtRQUN2QixJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ2xHLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLEdBQUcsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDbEYsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUM5RixzQkFBSSxJQUFJLENBQUMsMkJBQTJCLEVBQUssc0JBQXNCLEdBQUUsQ0FBQztZQUM5RCxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLO2dCQUNuRSxDQUFDLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsSUFBSTtnQkFDOUIsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUNmLENBQUM7YUFBTSxDQUFDO1lBQ0osSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLO2dCQUMzRSxDQUFDLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxZQUFZO2dCQUM5QyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ2YsQ0FBQztRQUNELElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQztRQUM1RCxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUFDO1FBQ3RGLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsc0JBQXNCLENBQUMsS0FBSyxDQUFDO1FBQ3JGLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQztRQUN0RSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxzQ0FBc0M7WUFDbkUsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssQ0FBQztRQUN0RCxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxDQUFDO1FBQzFGLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQztRQUN0RSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUM7SUFDMUUsQ0FBQztJQUVEOztPQUVHO0lBQ0ssS0FBSyxDQUFDLGNBQWMsQ0FBQyxTQUFpQixFQUFFLE9BQWdCO1FBQzVELElBQUksQ0FBQztZQUNELE1BQU0sV0FBVyxHQUFRO2dCQUNyQixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLO2dCQUMvQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLO2FBQzlCLENBQUM7WUFDRixJQUFJLE9BQU8sZ0JBQUksT0FBTyxFQUFHLENBQUMsR0FBRSxDQUFDO2dCQUN6QixXQUFXLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztZQUNsQyxDQUFDO1lBQ0QsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQztnQkFDbEQsV0FBVyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUM7WUFDcEQsQ0FBQztZQUNELElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDcEIsV0FBVyxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQztZQUMzQyxDQUFDO1lBQ0QsSUFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsQ0FBQztnQkFDdkMsV0FBVyxDQUFDLEdBQUcsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUM7WUFDekMsQ0FBQztZQUNELElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUM7Z0JBQ2hELFdBQVcsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQ2xELENBQUM7WUFDRCxJQUFJLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxZQUFZLEVBQUUsQ0FBQztnQkFDbEYsV0FBVyxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQztZQUM1RSxDQUFDO1lBRUQsTUFBTSxNQUFNLEdBQUcsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUs7aUJBQzVCLElBQUksQ0FBQywyQkFBMkIsQ0FBQztpQkFDakMsS0FBSyxDQUNGLEVBQUUsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUN2QjtnQkFDSSxPQUFPLEVBQUU7b0JBQ0wsT0FBTyxFQUFFO3dCQUNMLElBQUksRUFBRSxJQUFJO3FCQUNiO2lCQUNKO2dCQUNELFdBQVcsRUFBRTtvQkFDVCxJQUFJLEVBQUUsSUFBSTtpQkFDYjtnQkFDRCxzQ0FBc0MsRUFBRSxJQUFJO2dCQUM1QyxNQUFNLEVBQUU7b0JBQ0osSUFBSSxFQUFFLElBQUk7aUJBQ2I7Z0JBQ0QsUUFBUSxFQUFFO29CQUNOLElBQUksRUFBRSxJQUFJO2lCQUNiO2dCQUNELEdBQUcsRUFBRSxJQUFJO2dCQUNULE1BQU0sRUFBRSxJQUFJO2dCQUNaLFlBQVksRUFBRSxJQUFJO2dCQUNsQixXQUFXLEVBQUUsSUFBSTtnQkFDakIsV0FBVyxFQUFFLElBQUk7YUFDcEIsRUFDRDtnQkFDSSxNQUFNLEVBQUUsV0FBVzthQUN0QixDQUNKLENBQ0o7aUJBQ0EsT0FBTyxFQUFFLENBQUM7WUFDZixzQkFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBSyxDQUFDLEdBQUUsQ0FBQztnQkFDNUIsc0JBQUksU0FBUyxFQUFLLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxHQUFFLENBQUM7b0JBQ3BDLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7Z0JBQ3BDLENBQUM7cUJBQU0sc0JBQUksU0FBUyxFQUFLLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFFLENBQUM7b0JBQ3pDLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztnQkFDN0IsQ0FBQztxQkFBTSxzQkFBSSxTQUFTLEVBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUUsQ0FBQztvQkFDdEMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQztnQkFDOUIsQ0FBQztxQkFBTSxzQkFBSSxTQUFTLEVBQUssSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEdBQUUsQ0FBQztvQkFDekMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQztnQkFDcEMsQ0FBQztxQkFBTSxJQUFJLDJCQUFTLEVBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEtBQUksT0FBTyxnQkFBSSxPQUFPLEVBQUcsQ0FBQyxHQUFFLENBQUM7b0JBQ3pFLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7Z0JBQ3hDLENBQUM7cUJBQU0sc0JBQUksU0FBUyxFQUFLLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxHQUFFLENBQUM7b0JBQy9DLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQztnQkFDeEQsQ0FBQztnQkFDRCxJQUFJLENBQUMsQ0FBQyxDQUFDLFlBQVksRUFBRSxDQUFDO2dCQUN0QixJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FDWixFQUFFLENBQUMsUUFBUSxDQUFDLGdEQUFnRCxFQUFFLDZCQUE2QixDQUFDLEVBQzVGLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxDQUNwQixDQUFDO2dCQUNGLE9BQU8sS0FBSyxDQUFDO1lBQ2pCLENBQUM7WUFDRCxJQUNJLHdCQUFNLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBSyxDQUFDO2dCQUN6QixDQUFDLDJCQUFTLEVBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLHVCQUN6QixTQUFTLEVBQUssSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLHVCQUMvQixTQUFTLEVBQUssSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUMsRUFDNUMsQ0FBQztnQkFDQyxzQkFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBSyxJQUFJLEdBQUUsQ0FBQztvQkFDN0IsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQztnQkFDMUQsQ0FBQztnQkFDRCxJQUFJLHNCQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBSyxJQUFJLHVCQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksRUFBSyxJQUFJLEdBQUUsQ0FBQztvQkFDcEUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEdBQUcsRUFBRSxJQUFJLEVBQUUsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLElBQUksRUFBRSxDQUFDO2dCQUN4RSxDQUFDO2dCQUNELElBQUksc0JBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFLLElBQUksdUJBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFLLElBQUksR0FBRSxDQUFDO29CQUNsRSxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssR0FBRyxFQUFFLE1BQU0sRUFBRSxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDaEUsQ0FBQztnQkFDRCxJQUFJLHNCQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBSyxJQUFJLHVCQUFJLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBSyxJQUFJLEdBQUUsQ0FBQztvQkFDekQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUcsRUFBRSxHQUFHLEVBQUUsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLENBQUM7Z0JBQ3ZELENBQUM7Z0JBQ0QsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO2dCQUMxRCxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUM7Z0JBRTFELE1BQU0sSUFBSSxDQUFDLENBQUMsQ0FBQyw2QkFBNkIsRUFBRSxDQUFDO1lBQ2pELENBQUM7WUFDRCxPQUFPLElBQUksQ0FBQztRQUNoQixDQUFDO1FBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztZQUNULE1BQU0sMkJBQWEsRUFDZixJQUFJLEVBQ0osT0FBTyxFQUNQLEVBQUUsQ0FBQyxRQUFRLENBQUMsbUNBQW1DLEVBQUUsT0FBTyxDQUFDLGVBQ3pELEVBQUUsQ0FBQyxRQUFRLENBQUMsMkNBQTJDLEVBQUUsd0JBQXdCLENBQUMsRUFBRyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQ2pHLENBQUM7WUFDRixPQUFPLEtBQUssQ0FBQztRQUNqQixDQUFDO0lBQ0wsQ0FBQztJQUVEOztPQUVHO0lBQ0ssS0FBSyxDQUFDLG1CQUFtQixDQUFDLE9BQWdCO1FBQzlDLElBQUksQ0FBQztZQUNELE1BQU0sV0FBVyxHQUFRO2dCQUNyQixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLO2dCQUMvQixPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLO2FBQzlCLENBQUM7WUFDRixJQUFJLE9BQU8sRUFBRSxDQUFDO2dCQUNWLFdBQVcsQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO1lBQ2xDLENBQUM7WUFDRCxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDO2dCQUNsRCxXQUFXLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQztZQUNwRCxDQUFDO1lBQ0QsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUNwQixXQUFXLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDO1lBQzNDLENBQUM7WUFDRCxJQUFJLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxJQUFJLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxDQUFDO2dCQUN2QyxXQUFXLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQztZQUN6QyxDQUFDO1lBQ0QsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDaEQsV0FBVyxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUM7WUFDbEQsQ0FBQztZQUNELElBQUksSUFBSSxDQUFDLG9CQUFvQixDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsb0JBQW9CLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRSxDQUFDO2dCQUNsRixXQUFXLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDO1lBQzVFLENBQUM7WUFFRCxNQUFNLE1BQU0sR0FBRyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSztpQkFDNUIsSUFBSSxDQUFDLDJCQUEyQixDQUFDO2lCQUNqQyxTQUFTLENBQUMsS0FBSyxDQUNaLHlDQUFzQixFQUNsQjtnQkFDSSxLQUFLLEVBQUU7b0JBQ0gsT0FBTyxFQUFFO3dCQUNMLE9BQU8sRUFBRTs0QkFDTCxJQUFJLEVBQUU7Z0NBQ0YsR0FBRyxFQUFFLE9BQU87NkJBQ2Y7eUJBQ0o7cUJBQ0o7aUJBQ0o7Z0JBQ0QsTUFBTSxFQUFFO29CQUNKLG1CQUFtQixFQUFFO3dCQUNqQixHQUFHLEVBQUUsS0FBSzt3QkFDVixHQUFHLEVBQUUsS0FBSzt3QkFDVixHQUFHLEVBQUUsSUFBSTt3QkFDVCxHQUFHLEVBQUUsS0FBSzt3QkFDVixhQUFhLEVBQUUsS0FBSztxQkFDdkI7aUJBQ0o7YUFDSixFQUNEO2dCQUNJLE1BQU0sRUFBRSxXQUFXO2FBQ3RCLENBQ0osQ0FDSjtpQkFDQSxPQUFPLEVBQUUsQ0FBQztZQUNmLHNCQUFJLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFLLENBQUMsR0FBRSxDQUFDO2dCQUM1QixPQUFPLEtBQUssQ0FBQztZQUNqQixDQUFDO2lCQUFNLElBQ0gsc0JBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDLGtCQUFrQixFQUFLLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLO2dCQUMvQixJQUFJLENBQUMsb0JBQW9CLENBQUMsS0FBSyxDQUFDLFlBQVksZ0JBQzVDLE1BQU0sQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsbUJBQW1CLENBQUMsR0FBRyxDQUFDLEVBQUcsQ0FBQyxHQUNqRSxDQUFDO2dCQUNDLE9BQU8sSUFBSSxDQUFDO1lBQ2hCLENBQUM7aUJBQU0sZ0JBQUksTUFBTSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxHQUFHLENBQUMsRUFBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxHQUFFLENBQUM7Z0JBQ3RHLE9BQU8sS0FBSyxDQUFDO1lBQ2pCLENBQUM7WUFDRCxPQUFPLElBQUksQ0FBQztRQUNoQixDQUFDO1FBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztZQUNULE1BQU0sMkJBQWEsRUFDZixJQUFJLEVBQ0osT0FBTyxFQUNQLEVBQUUsQ0FBQyxRQUFRLENBQUMsbUNBQW1DLEVBQUUsT0FBTyxDQUFDLGVBQ3pELEVBQUUsQ0FBQyxRQUFRLENBQUMsMkNBQTJDLEVBQUUsd0JBQXdCLENBQUMsRUFBRyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQ2pHLENBQUM7WUFDRixPQUFPLEtBQUssQ0FBQztRQUNqQixDQUFDO0lBQ0wsQ0FBQztJQUNEOztPQUVHO0lBQ0ssS0FBSyxDQUFDLG9CQUFvQixDQUFDLFdBQW1CO1FBQ2xELElBQUksQ0FBQztZQUNELE1BQU0sZUFBZSxHQUFHLE1BQU0sSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLO2lCQUNyQyxJQUFJLENBQUMsa0NBQWtDLENBQUM7aUJBQ3hDLElBQUksQ0FDRDtnQkFDSSwyQkFBMkIsRUFBRSxJQUFJO2dCQUNqQyxpQkFBaUIsRUFBRSxJQUFJO2dCQUN2QixTQUFTLEVBQUU7b0JBQ1AsSUFBSSxFQUFFLElBQUk7aUJBQ2I7Z0JBQ0QsT0FBTyxFQUFFO29CQUNMLElBQUksRUFBRSxJQUFJO29CQUNWLDBCQUEwQixFQUFFLElBQUk7b0JBQ2hDLHFCQUFxQixFQUFFLElBQUk7b0JBQzNCLGlCQUFpQixFQUFFLElBQUk7b0JBQ3ZCLFNBQVMsRUFBRTt3QkFDUCxJQUFJLEVBQUUsSUFBSTt3QkFDVixnQkFBZ0IsRUFBRSxJQUFJO3FCQUN6QjtvQkFDRCx5QkFBeUIsRUFBRSxJQUFJO29CQUMvQixZQUFZLEVBQUU7d0JBQ1YsS0FBSyxFQUFFOzRCQUNILEtBQUssRUFBRTtnQ0FDSCxJQUFJLEVBQUU7b0NBQ0YsV0FBVyxFQUFFO3dDQUNULElBQUksRUFBRSxJQUFJO3dDQUNWLGdCQUFnQixFQUFFLElBQUk7cUNBQ3pCO29DQUNELHNDQUFzQyxFQUFFLElBQUk7b0NBQzVDLDJCQUEyQixFQUFFLElBQUk7aUNBQ3BDOzZCQUNKO3lCQUNKO3FCQUNKO2lCQUNKO2FBQ0osRUFDRCxHQUFHLFdBQVcsSUFBSSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRSxDQUMzQztpQkFDQSxPQUFPLEVBQUUsQ0FBQztZQUNmLDJDQUEyQztZQUMzQyxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7Z0JBQ25CLE1BQU0sSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQzVCLEVBQUUsQ0FBQyxRQUFRLENBQ1Asb0VBQW9FLEVBQ3BFLCtFQUErRSxFQUMvRTtvQkFDSSxXQUFXLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLO29CQUMvQixRQUFRLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLO2lCQUNqQyxDQUNKLEVBQ0QsT0FBTyxDQUNWLENBQUM7Z0JBQ0YsT0FBTyxJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsaUNBQWlDLENBQUMsQ0FBQztZQUNqRSxDQUFDO1lBQ0QsSUFBSSxDQUFDLFlBQVksR0FBRyxlQUFzQixDQUFDO1FBQy9DLENBQUM7UUFBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1lBQ1QsTUFBTSwyQkFBYSxFQUNmLElBQUksRUFDSixPQUFPLEVBQ1AsRUFBRSxDQUFDLFFBQVEsQ0FBQyxtQ0FBbUMsRUFBRSxPQUFPLENBQUMsZUFDekQsRUFBRSxDQUFDLFFBQVEsQ0FBQyxrREFBa0QsRUFBRSw2QkFBNkIsQ0FBQyxFQUMxRixNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQ2hCLENBQUM7UUFDTixDQUFDO0lBQ0wsQ0FBQztJQUNPLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFtQjtRQUM5QyxJQUFJLENBQUM7WUFDRCxNQUFNLFdBQVcsR0FBRyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSztpQkFDakMsSUFBSSxDQUFDLDhCQUE4QixDQUFDO2lCQUNwQyxJQUFJLENBQ0Q7Z0JBQ0ksSUFBSSxFQUFFLElBQUk7Z0JBQ1YsMEJBQTBCLEVBQUUsSUFBSTtnQkFDaEMsbUJBQW1CLEVBQUUsSUFBSTtnQkFDekIscUJBQXFCLEVBQUUsSUFBSTtnQkFDM0IsaUJBQWlCLEVBQUUsSUFBSTtnQkFDdkIseUJBQXlCLEVBQUUsSUFBSTtnQkFDL0IsU0FBUyxFQUFFO29CQUNQLElBQUksRUFBRSxJQUFJO29CQUNWLGdCQUFnQixFQUFFLElBQUk7aUJBQ3pCO2dCQUNELFlBQVksRUFBRTtvQkFDVixLQUFLLEVBQUU7d0JBQ0gsS0FBSyxFQUFFOzRCQUNILElBQUksRUFBRTtnQ0FDRixXQUFXLEVBQUU7b0NBQ1QsSUFBSSxFQUFFLElBQUk7b0NBQ1YsZ0JBQWdCLEVBQUUsSUFBSTtpQ0FDekI7Z0NBQ0Qsc0NBQXNDLEVBQUUsSUFBSTtnQ0FDNUMsMkJBQTJCLEVBQUUsSUFBSTs2QkFDcEM7eUJBQ0o7cUJBQ0o7aUJBQ0o7YUFDSixFQUNELEdBQUcsV0FBVyxFQUFFLENBQ25CO2lCQUNBLE9BQU8sRUFBRSxDQUFDO1lBQ2YsMkNBQTJDO1lBQzNDLElBQUksQ0FBQyxXQUFXLEVBQUUsQ0FBQztnQkFDZixNQUFNLElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUM1QixFQUFFLENBQUMsUUFBUSxDQUNQLCtEQUErRCxFQUMvRCxtREFBbUQsRUFDbkQ7b0JBQ0ksV0FBVyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSztpQkFDbEMsQ0FDSixFQUNELE9BQU8sQ0FDVixDQUFDO2dCQUNGLE9BQU8sSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGlDQUFpQyxDQUFDLENBQUM7WUFDakUsQ0FBQztZQUNELElBQUksQ0FBQyxRQUFRLEdBQUcsV0FBa0IsQ0FBQztZQUNuQyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsV0FBVyxDQUFDLFNBQVMsQ0FBQyxnQkFBZ0IsQ0FBQztRQUM3RSxDQUFDO1FBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztZQUNULE1BQU0sMkJBQWEsRUFDZixJQUFJLEVBQ0osT0FBTyxFQUNQLEVBQUUsQ0FBQyxRQUFRLENBQUMsbUNBQW1DLEVBQUUsT0FBTyxDQUFDLGVBQ3pELEVBQUUsQ0FBQyxRQUFRLENBQUMsNkNBQTZDLEVBQUUsd0JBQXdCLENBQUMsRUFBRyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQ25HLENBQUM7UUFDTixDQUFDO0lBQ0wsQ0FBQztJQUNPLEtBQUssQ0FBQyxlQUFlO1FBQ3pCLE1BQU0sUUFBUSxHQUFHLE1BQU0sSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLO1lBQy9CLHNKQUFzSjthQUNySixJQUFJLENBQUMsaUNBQWlDLENBQUM7YUFDdkMsS0FBSyxDQUNGLEVBQUUsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO1lBQ3hCLEdBQUcsRUFBRSxJQUFJO1lBQ1QsSUFBSSxFQUFFLElBQUk7U0FDYixDQUFDLENBQ0w7YUFDQSxPQUFPLEVBQUUsQ0FBQztRQUVmLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxzQkFBSSxRQUFRLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBSyxDQUFDLEdBQUUsQ0FBQztZQUNqRCxNQUFNLElBQUksS0FBSyxDQUNYLEVBQUUsQ0FBQyxRQUFRLENBQ1AsbUdBQW1HLEVBQ25HLGlCQUFpQixDQUNwQixDQUNKLENBQUM7UUFDTixDQUFDO1FBRUQsc0RBQXNEO1FBQ3RELE9BQU8sUUFBUSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxXQUFnQixFQUFFLEVBQUU7WUFDM0MsT0FBTyxXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztRQUNqQyxDQUFDLENBQUMsQ0FBQztJQUNQLENBQUM7SUFFTyxLQUFLLENBQUMsWUFBWTtRQUN0QixNQUFNLFFBQVEsR0FBRyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSzthQUM5QixJQUFJLENBQUMsK0JBQStCLENBQUM7YUFDckMsU0FBUyxDQUFDLElBQUksQ0FDWDtZQUNJLEdBQUcsRUFBRTtnQkFDRCxhQUFhLEVBQUUsSUFBSTthQUN0QjtTQUNKLEVBQ0Q7WUFDSSxNQUFNLEVBQUU7Z0JBQ0osVUFBVSxFQUFFLEVBQUUsR0FBRyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFO2dCQUMxQyxnQkFBZ0IsRUFBRSxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUU7YUFDakM7U0FDSixDQUNKO2FBQ0EsT0FBTyxFQUFFLENBQUM7UUFFZix5QkFBTyxRQUFRLENBQUMsR0FBRyxFQUFFLGFBQWEsRUFBSyxDQUFDLEVBQUM7SUFDN0MsQ0FBQztJQUVPLEtBQUssQ0FBQyxRQUFRLENBQUMsVUFBbUI7UUFDdEMsSUFBSSxVQUFVLEVBQUUsQ0FBQztZQUNiLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1lBQ25DLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1FBQ3pDLENBQUM7UUFFRCxJQUFJLENBQUMsVUFBVSxJQUFJLENBQUMsZ0JBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUcsQ0FBQyxpQkFBSSxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFHLENBQUMsRUFBQyxFQUFFLENBQUM7WUFDOUYsaUNBQWlDO1lBQ2pDLElBQUksQ0FBQyxDQUFDLE1BQU0saUNBQW1CLEVBQUMsSUFBSSxDQUFDLENBQUM7Z0JBQUUsT0FBTztRQUNuRCxDQUFDO1FBRUQ7O1dBRUc7UUFDSCxJQUNJLCtCQUFNLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxFQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSztZQUM5RixDQUFDLHNCQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBSyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssOEJBQzVDLE1BQU0sQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxDQUFDLEVBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUMsRUFDdkcsQ0FBQztZQUNDLElBQUksQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDdEIsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztZQUMzQixJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FDWixFQUFFLENBQUMsUUFBUSxDQUFDLDJDQUEyQyxFQUFFLDZDQUE2QyxDQUFDLEVBQ3ZHLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQ25DLENBQUM7WUFDRixPQUFPO1FBQ1gsQ0FBQztRQUVEOztXQUVHO1FBQ0gsSUFDSSxzQkFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsa0JBQWtCLEVBQUssQ0FBQyxpQkFDekQsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBRyxDQUFDLHVCQUNsQyxJQUFJLENBQUMsb0JBQW9CLEVBQUssWUFBWSxHQUM1QyxDQUFDO1lBQ0MsTUFBTSxXQUFXLEdBQUcsTUFBTSxJQUFJLENBQUMsbUJBQW1CLENBQzlDLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FDaEUsQ0FBQztZQUNGLElBQUksV0FBVyxZQUFZLEtBQUssSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO2dCQUMvQyxJQUFJLENBQUMsQ0FBQyxDQUFDLFlBQVksRUFBRSxDQUFDO2dCQUN0QixNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUMzQixJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FDWixFQUFFLENBQUMsUUFBUSxDQUNQLHlEQUF5RCxFQUN6RCx1Q0FBdUMsQ0FDMUMsRUFDRCxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxDQUNuQyxDQUFDO2dCQUNGLE9BQU87WUFDWCxDQUFDO1FBQ0wsQ0FBQztRQUVELElBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFDLENBQUMsZUFBZTtRQUMzQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztRQUV2Qjs7V0FFRztRQUNILElBQUksVUFBVSxnQkFBSSxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssR0FBRSxDQUFDO1lBQ3RFLElBQUksQ0FBQyxTQUFTLEdBQUcsTUFBTSxnQ0FBa0IsRUFDckMsSUFBSSxFQUNKLE1BQU0sRUFDTixFQUFFLENBQUMsUUFBUSxDQUFDLHlDQUF5QyxFQUFFLGFBQWEsQ0FBQyxFQUNyRSxFQUFFLENBQUMsUUFBUSxDQUFDLGlFQUFpRSxFQUFFLG9CQUFvQixDQUFDLEVBQ3BHO2dCQUNJLFVBQVUsRUFBRSxJQUFJO2dCQUNoQixZQUFZLEVBQUU7b0JBQ1YsSUFBSSxFQUFFLEVBQUUsQ0FBQyxRQUFRLENBQUMsa0NBQWtDLEVBQUUsS0FBSyxDQUFDO2lCQUMvRDtnQkFDRCxZQUFZLEVBQUU7b0JBQ1YsSUFBSSxFQUFFLEVBQUUsQ0FBQyxRQUFRLENBQUMsaUNBQWlDLEVBQUUsSUFBSSxDQUFDO2lCQUM3RDthQUNKLENBQ0osQ0FBQztZQUNGLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7Z0JBQ2xCLE9BQU87WUFDWCxDQUFDO1FBQ0wsQ0FBQztRQUVELElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7WUFDbEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsU0FBUyxHQUFHLENBQUMsQ0FBQztZQUMvQyx1Q0FBSSxDQUFDLGNBQWMsRUFBSSxDQUFDLEVBQUM7UUFDN0IsQ0FBQztRQUVEOzs7V0FHRztRQUNILElBQ0ksQ0FBQyxJQUFJLENBQUMsU0FBUyw2QkFDZixNQUFNLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxFQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxHQUNoRyxDQUFDO1lBQ0MsNkNBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFJLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUM7WUFDNUQsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssZ0JBQzVCLEVBQUUsQ0FBQyxRQUFRLENBQUMsaUNBQWlDLEVBQUUsbUJBQW1CLENBQUMsRUFDbkUsR0FBRyxFQUFFLENBQUMsMkJBQTJCLENBQzdCLE1BQU0sQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxFQUNqQyxNQUFNLENBQUMsSUFBSSxDQUFDLDBCQUEwQixDQUFDLENBQzFDLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsRUFBQztZQUNoQyxzQkFBSSxJQUFJLENBQUMsYUFBYSxFQUFLLElBQUksQ0FBQyxjQUFjLEdBQUUsQ0FBQztnQkFDN0MsSUFBSSxDQUFDLGNBQWMsY0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBRyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssRUFBQyxDQUFDO1lBQy9FLENBQUM7WUFDRCxNQUFNLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUMzQixDQUFDO2FBQU0sQ0FBQztZQUNKLDRCQUE0QjtZQUM1QixJQUFJLE1BQU0sQ0FBQztZQUNYLElBQUksYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMxQixJQUFJLGtCQUFrQixHQUFHLEtBQUssQ0FBQztZQUMvQixJQUFJLFFBQVEsR0FBRyxDQUFDLENBQUM7WUFFakIseUlBQXlJO1lBQ3pJLE1BQU0sdUJBQXVCLEdBQUcsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUs7aUJBQzdDLElBQUksQ0FBQywrQkFBK0IsQ0FBQztpQkFDckMsU0FBUyxDQUFDLElBQUksQ0FDWDtnQkFDSSxhQUFhLEVBQUU7b0JBQ1gsR0FBRyxFQUFFLElBQUk7b0JBQ1QsYUFBYSxFQUFFLElBQUksRUFBRSw4R0FBOEc7aUJBQ3RJO2FBQ0osRUFDRDtnQkFDSSxNQUFNLEVBQUU7b0JBQ0osc0VBQXNFO29CQUN0RSxVQUFVLEVBQUUsRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLEVBQUU7b0JBQzFDLGNBQWMsRUFBRSxFQUFFLEdBQUcsRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsRUFBRTtpQkFDN0Q7YUFDSixDQUNKO2lCQUNBLE9BQU8sRUFBRSxDQUFDO1lBRWYsSUFDSSx5Q0FBdUIsQ0FBQyxhQUFhLENBQUMsYUFBYSxFQUFLLENBQUMsS0FBSSwyREFBMkQ7K0JBQTNELDJEQUEyRDtZQUN4SCx1QkFBdUIsQ0FBQyxhQUFhLENBQUMsR0FBRyxFQUFLLENBQUMsRUFBQyxvRUFBb0U7Y0FDdEgsQ0FBQztnQkFDQyxRQUFRLEdBQUcsQ0FBQyxDQUFDO2dCQUNiLGFBQWEsR0FBRyxNQUFNLGdDQUFrQixFQUNwQyxJQUFJLEVBQ0osTUFBTSxFQUNOLEVBQUUsQ0FBQyxRQUFRLENBQUMscUNBQXFDLEVBQUUsU0FBUyxDQUFDLEVBQzdELEVBQUUsQ0FBQyxRQUFRLENBQ1AsdUVBQXVFLEVBQ3ZFLHdDQUF3QyxDQUMzQyxFQUNEO29CQUNJLFVBQVUsRUFBRSxJQUFJO29CQUNoQixZQUFZLEVBQUU7d0JBQ1YsSUFBSSxFQUFFLEVBQUUsQ0FBQyxRQUFRLENBQUMsa0NBQWtDLEVBQUUsS0FBSyxDQUFDO3FCQUMvRDtvQkFDRCxZQUFZLEVBQUU7d0JBQ1YsSUFBSSxFQUFFLEVBQUUsQ0FBQyxRQUFRLENBQUMsaUNBQWlDLEVBQUUsSUFBSSxDQUFDO3FCQUM3RDtpQkFDSixDQUNKLENBQUM7WUFDTixDQUFDO1lBQ0QsSUFBSSxhQUFhLEVBQUUsQ0FBQztnQkFDaEIsSUFBSSxDQUFDLElBQUksQ0FBQywwQkFBMEIsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLElBQUksQ0FBQyxNQUFNLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQztvQkFDdEYsTUFBTSwyQkFBYSxFQUNmLElBQUksRUFDSixPQUFPLEVBQ1AsRUFBRSxDQUFDLFFBQVEsQ0FBQyxtQ0FBbUMsRUFBRSxPQUFPLENBQUMsRUFDekQsRUFBRSxDQUFDLFFBQVEsQ0FDUCxrSEFBa0gsRUFDbEgsbUVBQW1FLENBQ3RFLENBQ0osQ0FBQztvQkFDRixhQUFhLEdBQUcsS0FBSyxDQUFDO29CQUN0QixrQkFBa0IsR0FBRyxJQUFJLENBQUM7Z0JBQzlCLENBQUM7cUJBQU0sSUFDSCxJQUFJLENBQUMsU0FBUztvQkFDZCxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxnQkFDOUIsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUksRUFBRSxHQUMzQyxDQUFDO29CQUNDLE1BQU0sMkJBQWEsRUFDZixJQUFJLEVBQ0osT0FBTyxFQUNQLEVBQUUsQ0FBQyxRQUFRLENBQUMsbUNBQW1DLEVBQUUsT0FBTyxDQUFDLEVBQ3pELEVBQUUsQ0FBQyxRQUFRLENBQ1AscUdBQXFHLEVBQ3JHLHNEQUFzRCxDQUN6RCxDQUNKLENBQUM7b0JBQ0YsYUFBYSxHQUFHLEtBQUssQ0FBQztvQkFDdEIsa0JBQWtCLEdBQUcsSUFBSSxDQUFDO2dCQUM5QixDQUFDO1lBQ0wsQ0FBQztZQUVELE1BQU0sR0FBRyxNQUFNLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLFdBQVc7WUFDbkUsSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztZQUU5Qix1REFBdUQ7WUFDdkQsSUFBSSxDQUFDLE1BQU0sSUFBSSxNQUFNLFlBQVksS0FBSyxFQUFFLENBQUM7Z0JBQ3JDLE1BQU0sT0FBTyxHQUE2QjtvQkFDdEMsWUFBWSxFQUFFO3dCQUNWLElBQUksRUFBRSxFQUFFLENBQUMsUUFBUSxDQUFDLDhCQUE4QixFQUFFLFNBQVMsQ0FBQztxQkFDL0Q7b0JBQ0QsWUFBWSxFQUFFO3dCQUNWLElBQUksRUFBRSxFQUFFLENBQUMsUUFBUSxDQUFDLDhCQUE4QixFQUFFLFFBQVEsQ0FBQztxQkFDOUQ7b0JBQ0QsSUFBSSxFQUFFLE9BQU87b0JBQ2IsU0FBUyxFQUFFLElBQUk7aUJBQ2xCLENBQUM7Z0JBQ0YsSUFBSSxPQUFPLEdBQUcsRUFBRSxDQUFDO2dCQUVqQixJQUFJLENBQUMsTUFBTSxFQUFFLE9BQU8sRUFBRSxDQUFDO29CQUNuQixNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO29CQUMzQixJQUNJLE1BQU0sZ0NBQWtCLEVBQ3BCLElBQUksRUFDSixPQUFPLEVBQ1AsRUFBRSxDQUFDLFFBQVEsQ0FBQyxtQ0FBbUMsRUFBRSxPQUFPLENBQUMsRUFDekQsRUFBRSxDQUFDLFFBQVEsQ0FDUCxnRkFBZ0YsRUFDaEYsNEZBQTRGLENBQy9GLEVBQ0QsT0FBTyxDQUNWLEVBQ0gsQ0FBQzt3QkFDQyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLE9BQU8sRUFBRSxDQUFDO29CQUNsQyxDQUFDO3lCQUFNLENBQUM7d0JBQ0osTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxTQUFTLEVBQUUsQ0FBQzt3QkFDaEMsSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGlDQUFpQyxDQUFDLENBQUM7b0JBQzFELENBQUM7b0JBQ0QsT0FBTztnQkFDWCxDQUFDO3FCQUFNLENBQUM7b0JBQ0osTUFBTSxTQUFTLEdBQWEsRUFBRSxDQUFDO29CQUMvQixNQUFNLFFBQVEsR0FBUSxNQUFNLENBQUM7b0JBQzdCLElBQUksVUFBVSxHQUFHLFFBQVEsRUFBRSxTQUFTLENBQUM7b0JBQ3JDLGdCQUFJLFVBQVUsRUFBRSxNQUFNLEVBQUcsQ0FBQyxHQUFFLENBQUM7d0JBQ3pCLFVBQVUsR0FBRyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsZUFBRSxVQUFVLENBQUMsTUFBTSxFQUFHLENBQUMsRUFBQyxDQUFDO29CQUM3RCxDQUFDO29CQUVELENBQ0ksQ0FBQyxRQUFRLEVBQUUsTUFBTTt3QkFDYixDQUFDLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxVQUFVLEVBQUUsU0FBUzt3QkFDM0MsQ0FBQyxDQUFDLENBQUMsUUFBUSxFQUFFLFVBQVUsRUFBRSxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsVUFBVSxFQUFFLFNBQVM7NEJBQ3ZELFFBQVEsQ0FBQyxVQUFVLEVBQUUsU0FBUzs0QkFDOUIsVUFBVSxDQUFDLENBQUMsSUFBSSxFQUFFLENBQzNCO3lCQUNJLE1BQU0sQ0FBQyxDQUFDLENBQXFDLEVBQUUsRUFBRSxDQUFDLGFBQUMsQ0FBQyxRQUFRLEVBQUcsQ0FBQyxLQUFJLENBQUMsQ0FBQyxPQUFPLENBQUM7eUJBQzlFLE9BQU8sQ0FBQyxDQUFDLENBQW1CLEVBQUUsRUFBRTt3QkFDN0IsTUFBTSxRQUFRLEdBQUcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7d0JBQ3ZDLFNBQVMsQ0FBQyxJQUFJLENBQUMsR0FBRyxRQUFRLENBQUMsQ0FBQztvQkFDaEMsQ0FBQyxDQUFDLENBQUM7b0JBRVAsTUFBTSxPQUFPLEdBQUcsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQVcsU0FBUyxDQUFDLENBQUMsQ0FBVyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztvQkFFOUYsT0FBTyxHQUFHLEtBQUssRUFBRSxDQUFDLFFBQVEsQ0FDdEIsMkVBQTJFLEVBQzNFLHVCQUF1QixDQUMxQixRQUFRLENBQUM7b0JBRVYsc0JBQUksT0FBTyxDQUFDLE1BQU0sRUFBSyxDQUFDLEdBQUUsQ0FBQzt3QkFDdkIsOEJBQU8sRUFBSSxHQUFHLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFDO29CQUMvQixDQUFDO3lCQUFNLENBQUM7d0JBQ0osOEJBQU8sRUFBSSxPQUFPLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsS0FBSyxJQUFJLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBQztvQkFDM0QsQ0FBQztvQkFFRCxJQUFJLE1BQU0sWUFBWSxLQUFLLEVBQUUsQ0FBQzt3QkFDMUIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsVUFBVSxJQUFJOzRCQUNqQyxJQUFJLENBQUMsU0FBUyxHQUFHLENBQUMsQ0FBQzt3QkFDdkIsQ0FBQyxDQUFDLENBQUM7d0JBQ0gsSUFBSSxDQUFDLGNBQWMsR0FBRyxDQUFDLENBQUM7d0JBQ3hCLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQzt3QkFDOUIsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssZ0JBQzVCLEVBQUUsQ0FBQyxRQUFRLENBQUMsaUNBQWlDLEVBQUUsbUJBQW1CLENBQUMsRUFDbkUsR0FBRyxFQUFFLENBQUMsMkJBQTJCLENBQzdCLE1BQU0sQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxFQUNqQyxNQUFNLENBQUMsSUFBSSxDQUFDLDBCQUEwQixDQUFDLENBQzFDLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsRUFBQzt3QkFDaEMsZ0JBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLEVBQUcsQ0FBQyxHQUFFLENBQUM7NEJBQzVCLElBQUksQ0FBQyxVQUFVLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQzt3QkFDdkMsQ0FBQzt3QkFDRCxJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO29CQUNsQyxDQUFDO2dCQUNMLENBQUM7Z0JBRUQsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDM0IsSUFDSSxNQUFNLGdDQUFrQixFQUNwQixJQUFJLEVBQ0osT0FBTyxFQUNQLEVBQUUsQ0FBQyxRQUFRLENBQUMsbUNBQW1DLEVBQUUsT0FBTyxDQUFDLEVBQ3pELE9BQU8sRUFDUCxPQUFPLENBQ1YsRUFDSCxDQUFDO29CQUNDLE9BQU87Z0JBQ1gsQ0FBQztZQUNMLENBQUM7WUFFRCwyREFBMkQ7WUFDM0QseUNBQXlDO1lBQ3pDLElBQUksUUFBUSxnQkFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBSSxFQUFFLEdBQUUsQ0FBQztnQkFDeEMsTUFBTSxjQUFjLEdBQUcsTUFBTSxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUs7cUJBQ3BDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztxQkFDL0IsU0FBUyxDQUFDLElBQUksQ0FDWDtvQkFDSSw2QkFBNkIsRUFBRTt3QkFDM0IsYUFBYSxFQUFFLElBQUk7cUJBQ3RCO2lCQUNKLEVBQ0Q7b0JBQ0ksTUFBTSxFQUFFO3dCQUNKLGVBQWUsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUs7d0JBQ3BDLGNBQWMsRUFBRSxFQUFFLGFBQWEsRUFBRSxDQUFDLEVBQUU7cUJBQ3ZDO2lCQUNKLENBQ0o7cUJBQ0EsT0FBTyxFQUFFLENBQUM7Z0JBQ2Ysc0JBQUksY0FBYyxDQUFDLDZCQUE2QixDQUFDLGFBQWEsRUFBSyxDQUFDLEdBQUUsQ0FBQztvQkFDbkUsUUFBUSxHQUFHLENBQUMsQ0FBQztnQkFDakIsQ0FBQztZQUNMLENBQUM7WUFDRCxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsb0NBQWtDLENBQUMsb0JBQW9CLENBQUMsQ0FBQztZQUUvRTs7ZUFFRztZQUVILElBQUksUUFBUSxzQkFBSSxhQUFhLEVBQUssU0FBUyxHQUFFLENBQUM7Z0JBQzFDLE1BQU0sMkJBQWEsRUFDZixJQUFJLEVBQ0osTUFBTSxFQUNOLEVBQUUsQ0FBQyxRQUFRLENBQUMseUNBQXlDLEVBQUUsYUFBYSxDQUFDLEVBQ3JFLGtCQUFrQjtvQkFDZCxDQUFDLENBQUMsRUFBRSxDQUFDLFFBQVEsQ0FDUCx5RkFBeUYsRUFDekYsb0VBQW9FLENBQ3ZFO29CQUNILENBQUMsQ0FBQyxhQUFhO3dCQUNiLENBQUMsQ0FBQyxFQUFFLENBQUMsUUFBUSxDQUNQLDBEQUEwRCxFQUMxRCw0Q0FBNEMsQ0FDL0M7d0JBQ0gsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQ1AsMkRBQTJELEVBQzNELDRDQUE0QyxDQUMvQyxDQUNaLENBQUM7WUFDTixDQUFDO1lBRUQ7O2VBRUc7WUFDSCxJQUFJLENBQUMsQ0FBQyxDQUFDLFlBQVksRUFBRSxDQUFDO1lBQ3RCLE1BQU0sSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLENBQUM7WUFFN0IsSUFBSSxRQUFRLEVBQUUsQ0FBQztnQkFDWCxJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsaUNBQWlDLENBQUMsQ0FBQztZQUMxRCxDQUFDO2lCQUFNLHNCQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFLLEVBQUUsR0FBRSxDQUFDO2dCQUNwQyxJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsaURBQWlELEVBQUU7b0JBQ2xFLGNBQWMsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7aUJBQ3ZELENBQUMsQ0FBQztZQUNQLENBQUM7aUJBQU0sQ0FBQztnQkFDSixJQUFJLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsK0NBQStDLEVBQUU7b0JBQ2hFLGNBQWMsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7aUJBQ3ZELENBQUMsQ0FBQztZQUNQLENBQUM7UUFDTCxDQUFDO0lBQ0wsQ0FBQztJQUVEOztPQUVHO0lBQ0ssS0FBSyxDQUFDLG1CQUFtQixDQUFDLGFBQXNCO1FBQ3BELElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7UUFDL0I7O1dBRUc7UUFDSCxNQUFNLFlBQVksR0FBMkIsRUFBRSxDQUFDO1FBQ2hELE1BQU0sdUNBQXVDLEdBQTJCLEVBQUUsQ0FBQztRQUMzRSxNQUFNLHNCQUFzQixHQUEyQixFQUFFLENBQUM7UUFDMUQsTUFBTSxvQkFBb0IsR0FBMkIsRUFBRSxDQUFDO1FBQ3hELE1BQU0sU0FBUyxHQUEyQixFQUFFLENBQUM7UUFDN0MsTUFBTSxJQUFJLEdBQTJCLEVBQUUsQ0FBQztRQUN4QyxNQUFNLE9BQU8sR0FBMkIsRUFBRSxDQUFDO1FBQzNDLE1BQU0sYUFBYSxHQUEyQixFQUFFLENBQUM7UUFDakQsTUFBTSxPQUFPLEdBQTJCLEVBQUUsQ0FBQztRQUMzQyxNQUFNLFFBQVEsR0FBMkIsRUFBRSxDQUFDO1FBQzVDLEtBQUssTUFBTSxJQUFJLElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQ2hDLElBQUksSUFBSSxDQUFDLFNBQVMsZ0JBQUksSUFBSSxDQUFDLG1CQUFtQixFQUFHLENBQUMsR0FBRSxDQUFDO2dCQUNqRCxZQUFZLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsQ0FBQztnQkFDeEMsdUNBQXVDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDO2dCQUMxRixzQkFBc0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLENBQUM7Z0JBQ3hELG9CQUFvQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQztnQkFDcEQsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxJQUFJLEVBQUUsQ0FBQyxDQUFDO2dCQUNwQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLElBQUksRUFBRSxDQUFDLENBQUM7Z0JBQzFCLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sSUFBSSxFQUFFLENBQUMsQ0FBQztnQkFDaEMsYUFBYSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxJQUFJLEVBQUUsQ0FBQyxDQUFDO2dCQUM1QyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztnQkFDMUIsUUFBUSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7WUFDaEMsQ0FBQztRQUNMLENBQUM7UUFFRDs7V0FFRztRQUNILE1BQU0sY0FBYyxHQUFRO1lBQ3hCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSztZQUN4QyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLO1lBQ2pDLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUs7WUFDekMsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUU7WUFDOUYsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSztZQUMzQixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsV0FBVyxFQUFFLGFBQWE7WUFDMUIsbUJBQW1CLEVBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLDZCQUE2QixDQUFZLElBQUksRUFBRTtZQUN4RixXQUFXLEVBQUUsWUFBWTtZQUN6QixzQ0FBc0MsRUFBRSx1Q0FBdUM7WUFDL0UscUJBQXFCLEVBQUUsc0JBQXNCO1lBQzdDLG1CQUFtQixFQUFFLG9CQUFvQjtZQUN6QyxRQUFRLEVBQUUsU0FBUztZQUNuQixHQUFHLEVBQUUsSUFBSTtZQUNULE1BQU0sRUFBRSxPQUFPO1lBQ2YsWUFBWSxFQUFFLGFBQWE7WUFDM0IsTUFBTSxFQUFFLE9BQU87WUFDZixPQUFPLEVBQUUsUUFBUTtZQUNqQixhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJO1lBQ3pFLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUk7WUFDekUsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSTtZQUN0RSxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJO1NBQ25FLENBQUM7UUFFRixJQUFJLENBQUM7WUFDRCxPQUFPLE1BQU0sSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLO2lCQUNwQixJQUFJLENBQUMsK0JBQStCLENBQUM7aUJBQ3JDLFNBQVMsQ0FBQyxvQkFBb0IsQ0FDM0IsRUFBRSxVQUFVLEVBQUUsSUFBSSxFQUFFLGNBQWMsRUFBRSxJQUFJLEVBQUUsRUFDMUMsRUFBRSxVQUFVLEVBQUUsY0FBYyxFQUFFLENBQ2pDO2lCQUNBLE9BQU8sRUFBRSxDQUFDO1FBQ25CLENBQUM7UUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1lBQ2IsT0FBTyxLQUFLLENBQUM7UUFDakIsQ0FBQztJQUNMLENBQUM7O0FBendFUSxnRkFBa0M7QUF3QzNDO0lBSEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7cUVBQ3dCO0FBSzFCO0lBSEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7dUVBQzBCO0FBSzVCO0lBSEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7b0VBQ3VCO0FBYXpCO0lBUkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQXFDO1FBQzFELEtBQUssOEdBQVU7UUFDZixRQUFRLEVBQUUsQ0FBQyxJQUFJLENBQUM7UUFDaEIsVUFBVSxFQUFFLFNBQVM7UUFDckIsS0FBSyxDQUFDLE9BQU87WUFDVCxNQUFNLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDL0IsQ0FBQztLQUNKLENBQUM7c0VBQ3dCO0FBVzFCO0lBVEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQXFDO1FBQzFELEtBQUssNEdBQVE7UUFDYixRQUFRLEVBQUUsQ0FBQyxJQUFJLENBQUM7UUFDaEIsVUFBVSxFQUFFLFdBQVc7UUFDdkIsS0FBSyxDQUFDLE9BQU87WUFDVCxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsNkJBQTZCLEVBQUUsQ0FBQztZQUM3QyxNQUFNLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUMzQixDQUFDO0tBQ0osQ0FBQztzRUFDd0I7QUFXMUI7SUFUQyxFQUFFLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBcUM7UUFDMUQsS0FBSyxvSEFBWTtRQUNqQixRQUFRLEVBQUUsQ0FBQyxJQUFJLENBQUM7UUFDaEIsVUFBVSxFQUFFLFdBQVc7UUFDdkIsVUFBVSxFQUFFLElBQUk7UUFDaEIsS0FBSyxDQUFDLE9BQU87WUFDVCxNQUFNLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDOUIsQ0FBQztLQUNKLENBQUM7MEVBQzRCO0FBNkM5QjtJQTNDQyxFQUFFLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBcUM7UUFDMUQsS0FBSywySEFBZ0I7UUFDckIsUUFBUSxFQUFFLENBQUMsSUFBSSxDQUFDO1FBQ2hCLFVBQVUsRUFBRSxXQUFXO1FBQ3ZCLEtBQUssQ0FBQyxPQUFPO1lBQ1QsTUFBTSxjQUFjLEdBQW9CLElBQUksQ0FBQyxTQUFTO2lCQUNqRCxNQUFNLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDO2lCQUNwQyxHQUFHLENBQUMsT0FBTyxDQUFDLEVBQUU7Z0JBQ1gsT0FBTztvQkFDSCxXQUFXLEVBQUUsT0FBTyxDQUFDLFdBQVc7b0JBQ2hDLHFCQUFxQixFQUFFLE9BQU8sQ0FBQyxxQkFBcUI7b0JBQ3BELHNDQUFzQyxFQUFFLE9BQU8sQ0FBQyxzQ0FBc0M7b0JBQ3RGLG1CQUFtQixFQUFFLE9BQU8sQ0FBQyxtQkFBbUI7b0JBQ2hELFFBQVEsRUFBRSxPQUFPLENBQUMsUUFBUTtvQkFDMUIsR0FBRyxFQUFFLE9BQU8sQ0FBQyxHQUFHO29CQUNoQixNQUFNLEVBQUUsT0FBTyxDQUFDLE1BQU07b0JBQ3RCLFlBQVksRUFBRSxPQUFPLENBQUMsWUFBWTtvQkFDbEMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxNQUFNO29CQUN0QixPQUFPLEVBQUUsT0FBTyxDQUFDLE9BQU87aUJBQzNCLENBQUM7WUFDTixDQUFDLENBQUMsQ0FBQztZQUNQLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztZQUNqQyxJQUFJLENBQUMscUJBQXFCLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztZQUMzQyxJQUFJLENBQUMsc0NBQXNDLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztZQUM1RCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7WUFDL0IsSUFBSSxDQUFDLG1CQUFtQixDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7WUFDekMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7WUFDeEMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1lBQzlCLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztZQUN6QixJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7WUFDNUIsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1lBQ2xDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1lBQzFDLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztZQUM1QixJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7WUFDakMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1lBQ2pDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1lBQ3pDLElBQUksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyx5REFBeUQsRUFBRTtnQkFDMUUsR0FBRyxFQUFFLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDLEVBQUU7Z0JBQ3hGLGNBQWMsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7Z0JBQ3BELGNBQWMsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQzthQUNqRCxDQUFDLENBQUM7UUFDUCxDQUFDO0tBQ0osQ0FBQzs2RUFDK0I7QUFRakM7SUFIQyxFQUFFLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBcUM7UUFDdkQsYUFBYSxFQUFFLElBQUk7S0FDdEIsQ0FBQzt1RUFDaUM7QUFXbkM7SUFOQyxFQUFFLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBcUM7UUFDckQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztRQUM1QixDQUFDO1FBQ0QsYUFBYSxFQUFFLElBQUk7S0FDdEIsQ0FBQzt1RUFDK0I7QUFRakM7SUFOQyxFQUFFLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBcUM7UUFDckQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztRQUM1QixDQUFDO1FBQ0QsS0FBSywwSEFBZ0I7S0FDeEIsQ0FBQzs0RUFDb0M7QUFRdEM7SUFOQyxFQUFFLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBcUM7UUFDckQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztRQUM1QixDQUFDO1FBQ0QsS0FBSyx5SEFBZTtLQUN2QixDQUFDOzRFQUNvQztBQVN0QztJQUpDLEVBQUUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFxQztRQUN6RCxLQUFLLG1IQUFlO1FBQ3BCLFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7c0VBQ3lCO0FBTTNCO0lBSkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELEtBQUssZ0hBQVE7UUFDYixVQUFVLEVBQUUsSUFBSTtLQUNuQixDQUFDOzBFQUM2QjtBQU0vQjtJQUpDLEVBQUUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFxQztRQUN6RCxLQUFLLDRHQUFXO1FBQ2hCLFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7bUVBQ3NCO0FBS3hCO0lBSEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7aUZBQ29DO0FBTXRDO0lBSkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELEtBQUssa0pBQStCO1FBQ3BDLFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7cUZBQ3dDO0FBTTFDO0lBSkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELEtBQUssK0lBQStCO1FBQ3BDLFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7a0ZBQ3FDO0FBYXZDO0lBUEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELFVBQVUsRUFBRSxJQUFJO1FBQ2hCLE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7UUFDNUIsQ0FBQztRQUNELFdBQVcsRUFBRSxJQUFJO0tBQ3BCLENBQUM7aUZBQ29DO0FBV3RDO0lBVEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQXFDO1FBQzVELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7UUFDNUIsQ0FBQztRQUNELEtBQUssNEhBQW9CO1FBQ3pCLFVBQVUsRUFBRSxJQUFJO1FBQ2hCLFdBQVcsRUFBRSxLQUFLO1FBQ2xCLFFBQVEsRUFBRSxJQUFJO0tBQ2pCLENBQUM7MEVBQ2dDO0FBV2xDO0lBVEMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQXFDO1FBQzVELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7UUFDNUIsQ0FBQztRQUNELEtBQUssMkhBQW1CO1FBQ3hCLFVBQVUsRUFBRSxJQUFJO1FBQ2hCLFdBQVcsRUFBRSxLQUFLO1FBQ2xCLFFBQVEsRUFBRSxJQUFJO0tBQ2pCLENBQUM7MEVBQ2dDO0FBaUZsQztJQS9FQyxFQUFFLENBQUMsVUFBVSxDQUFDLGlCQUFpQixDQUFxQztRQUNqRSxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDakMsQ0FBQztRQUNELEtBQUssaUhBQVk7UUFDakIsV0FBVyxFQUFFLElBQUk7UUFDakIsS0FBSyxDQUFDLFFBQVE7WUFDVixJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ3pCLElBQUksR0FBRyxHQUFHLENBQUMsQ0FBQztnQkFDWixJQUFJLG1CQUFtQixHQUFHLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxLQUFLLENBQUM7Z0JBQzVFLE1BQU0sYUFBYSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDO2dCQUM3QyxHQUFHLEdBQUcsSUFBSSxDQUFDLGVBQWU7cUJBQ3JCLEdBQUcsQ0FBQyxVQUFVLENBQUM7b0JBQ1osT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDO2dCQUNsQixDQUFDLENBQUM7cUJBQ0QsT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDO2dCQUM1QixzQkFBSSxHQUFHLEVBQUssQ0FBQyxDQUFDLEdBQUUsQ0FBQztvQkFDYixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxDQUFDLENBQUMsZ0JBQWdCLENBQUM7b0JBQzlFLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxLQUFLO3dCQUM3QyxJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDLCtCQUErQixDQUFDO29CQUM5RCxnQkFBSSxJQUFJLENBQUMsc0JBQXNCLENBQUMsS0FBSyxFQUFJLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxHQUFFLENBQUM7d0JBQzVELElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLGdCQUM1QixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFHLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxLQUFLLEVBQUM7b0JBQzdGLENBQUM7eUJBQU0sQ0FBQzt3QkFDSixnQkFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBSSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssR0FBRSxDQUFDOzRCQUNqRCxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxnQkFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFHLG1CQUFtQixFQUFDO3dCQUM5RixDQUFDOzZCQUFNLENBQUM7NEJBQ0osSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssZ0JBQzVCLGNBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBRyxtQkFBbUIsRUFBQyxFQUN4RCxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxFQUFDO3dCQUMxRCxDQUFDO29CQUNMLENBQUM7b0JBQ0QsSUFBSSxpQkFBaUIsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxDQUFDO29CQUN6RCxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQ2hELElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxDQUFDLENBQUMsZ0JBQWdCLENBQUMsQ0FDdkYsQ0FBQztvQkFDRiw2QkFBSSxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFHLGlCQUFpQixHQUFHLENBQUMsR0FBRSxDQUFDO3dCQUMzRCxRQUFRLElBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxDQUFDLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQzs0QkFDakQsS0FBSyxDQUFDO2dDQUNGLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLGdCQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUcsQ0FBQyxFQUFDO2dDQUN4RSxNQUFNOzRCQUNWLEtBQUssQ0FBQztnQ0FDRixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxnQkFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyw2QkFBTSxDQUFDO2dDQUMxRSxNQUFNOzRCQUNWLEtBQUssQ0FBQztnQ0FDRixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxnQkFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyw4QkFBTyxDQUFDO2dDQUMzRSxNQUFNOzRCQUNWLEtBQUssQ0FBQztnQ0FDRixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxnQkFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSywrQkFBUSxDQUFDO2dDQUM1RSxNQUFNOzRCQUNWLEtBQUssQ0FBQztnQ0FDRixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxnQkFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxnQ0FBUyxDQUFDO2dDQUM3RSxNQUFNOzRCQUNWLEtBQUssQ0FBQztnQ0FDRixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxnQkFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxpQ0FBVSxDQUFDO2dDQUM5RSxNQUFNOzRCQUNWLEtBQUssQ0FBQztnQ0FDRixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxnQkFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxrQ0FBVyxDQUFDO2dDQUMvRSxNQUFNO3dCQUNkLENBQUM7b0JBQ0wsQ0FBQztvQkFFRCxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQzlDLGNBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBRyxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxFQUFDLENBQUMsT0FBTyxDQUMxRixJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDLGdCQUFnQixDQUM3QyxDQUNKLENBQUM7b0JBQ0YsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLFVBQVU7d0JBQ2xELHNCQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBSyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUs7NEJBQy9DLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxHQUFHLENBQUMsQ0FBQywyQkFBMkIsQ0FBQztvQkFDM0QsSUFBSSxDQUFDLHNCQUFzQixDQUFDLEtBQUssR0FBRyxhQUFhLENBQUM7b0JBQ2xELElBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO2dCQUMvQixDQUFDO3FCQUFNLENBQUM7b0JBQ0osSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLHNCQUFzQixDQUFDLEtBQUssQ0FBQztnQkFDL0QsQ0FBQztZQUNMLENBQUM7WUFDRCxJQUFJLENBQUMsY0FBYyxDQUFDLFVBQVUscUJBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBSyxDQUFDLEVBQUM7UUFDNUUsQ0FBQztLQUNKLENBQUM7dUVBQ2tDO0FBMENwQztJQXhDQyxFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBcUM7UUFDNUQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pDLENBQUM7UUFDRCxLQUFLLDBIQUFXO1FBQ2hCLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLFdBQVcsRUFBRSxLQUFLO1FBQ2xCLFVBQVUsRUFBRSwrQ0FBK0MsRUFBRSx5REFBeUQ7UUFDdEgsR0FBRyxFQUFFLENBQUM7UUFDTixLQUFLO1lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLGVBQWU7aUJBQzNCLEdBQUcsQ0FBQyxVQUFVLENBQUM7Z0JBQ1osT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDO1lBQ2xCLENBQUMsQ0FBQztpQkFDRCxPQUFPLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxLQUFLLENBQUMsQ0FBQztZQUNwQyxPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxDQUFDLEVBQUUsZ0JBQWdCLElBQUksQ0FBQyxDQUFDO1FBQzVELENBQUM7UUFDRCxRQUFRO1lBQ0osZ0JBQUksSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBSSxJQUFJLEdBQUUsQ0FBQztnQkFDM0MsSUFBSSxHQUFHLEdBQUcsSUFBSSxDQUFDLGVBQWU7cUJBQ3pCLEdBQUcsQ0FBQyxVQUFVLENBQUM7b0JBQ1osT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDO2dCQUNsQixDQUFDLENBQUM7cUJBQ0QsT0FBTyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUM7Z0JBQ25DLG1DQUFtQztnQkFDbkMsSUFBSSxvQkFBb0IsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUN4QyxjQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxLQUFLLEVBQUcsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssRUFBQyxDQUFDLE9BQU8sQ0FDMUYsSUFBSSxDQUFDLGVBQWUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxnQkFBZ0IsQ0FDN0MsQ0FDSixDQUFDO2dCQUNGLElBQ0ksc0JBQUksQ0FBQyxtQkFBbUIsQ0FBQyxHQUFHLEVBQUssU0FBUyxrQkFDMUMsb0JBQW9CLEVBQUksSUFBSSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsR0FDdEQsQ0FBQztvQkFDQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxHQUFHLG9CQUFvQixDQUFDO2dCQUMxRCxDQUFDO1lBQ0wsQ0FBQztZQUNELElBQUksQ0FBQyxjQUFjLENBQUMsVUFBVSxxQkFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFLLENBQUMsRUFBQztRQUM1RSxDQUFDO0tBQ0osQ0FBQztpRkFDdUM7QUEwQ3pDO0lBeENDLEVBQUUsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFxQztRQUM1RCxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDakMsQ0FBQztRQUNELEtBQUsscUpBQXFCO1FBQzFCLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLEtBQUssRUFBRSxDQUFDO1FBQ1IsVUFBVSxFQUFFLG9EQUFvRCxFQUFFLGtFQUFrRTtRQUNwSSxHQUFHLGlDQUFVO1FBQ2IsV0FBVyxFQUFFLElBQUk7UUFDakIsUUFBUTtZQUNKLElBQUksSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUNwRCxJQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsZUFBZTtxQkFDekIsR0FBRyxDQUFDLFVBQVUsQ0FBQztvQkFDWixPQUFPLENBQUMsQ0FBQyxJQUFJLENBQUM7Z0JBQ2xCLENBQUMsQ0FBQztxQkFDRCxPQUFPLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztnQkFDbkMsSUFBSSxzQkFBc0IsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQzlDLGNBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssRUFBRyxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxFQUFDLENBQUMsT0FBTyxDQUMxRixJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDLGdCQUFnQixDQUM3QyxDQUNKLENBQUM7Z0JBQ0YsNkJBQUksSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBRyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLEtBQUssR0FBRSxDQUFDO29CQUN6RixJQUFJLENBQUMsQ0FBQyxDQUFDLFlBQVksRUFBRSxDQUFDO29CQUN0QixJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FDWixFQUFFLENBQUMsUUFBUSxDQUNQLDJDQUEyQyxFQUMzQyw2Q0FBNkMsQ0FDaEQsRUFDRCxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsQ0FDcEIsQ0FBQztvQkFDRixJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxHQUFHLHNCQUFzQixDQUFDO29CQUN4RCxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ3hELENBQUM7Z0JBQ0QsSUFBSSxDQUFDLG1CQUFtQixFQUFFLENBQUM7WUFDL0IsQ0FBQztZQUNELElBQUksQ0FBQyxjQUFjLENBQUMsVUFBVSxxQkFBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFLLENBQUMsRUFBQztRQUM1RSxDQUFDO0tBQ0osQ0FBQztrR0FDd0Q7QUFRMUQ7SUFOQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBcUM7UUFDekQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pDLENBQUM7UUFDRCxRQUFRLEVBQUUsSUFBSTtLQUNqQixDQUFDO2tGQUNxQztBQVN2QztJQVBDLEVBQUUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFxQztRQUN6RCxLQUFLLGlIQUFjO1FBQ25CLFVBQVUsRUFBRSxJQUFJO1FBQ2hCLE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqQyxDQUFDO0tBQ0osQ0FBQztxRUFDd0I7QUF3QzFCO0lBdENDLEVBQUUsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFxQztRQUM1RCxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDakMsQ0FBQztRQUNELEtBQUssK0hBQWtCO1FBQ3ZCLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLFdBQVcsRUFBRSxLQUFLO1FBQ2xCLFVBQVUsRUFBRSwrQ0FBK0MsRUFBRSx5REFBeUQ7UUFDdEgsR0FBRyxFQUFFLENBQUM7UUFDTixLQUFLO1lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxDQUFDLGVBQWU7aUJBQzNCLEdBQUcsQ0FBQyxVQUFVLENBQUM7Z0JBQ1osT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDO1lBQ2xCLENBQUMsQ0FBQztpQkFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztZQUM5RCxPQUFPLElBQUksQ0FBQyxlQUFlLENBQUMsR0FBRyxDQUFDLEVBQUUsZ0JBQWdCLElBQUksQ0FBQyxDQUFDO1FBQzVELENBQUM7UUFDRCxRQUFRO1lBQ0osSUFDSSxnQkFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBSSxJQUFJLGtCQUN0QyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxFQUFJLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxHQUFHLEdBQ2hFLENBQUM7Z0JBQ0MsZ0JBQUksSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssRUFBRyxDQUFDLEdBQUUsQ0FBQztvQkFDeEQsSUFBSSxHQUFHLEdBQUcsSUFBSSxDQUFDLGVBQWU7eUJBQ3pCLEdBQUcsQ0FBQyxVQUFVLENBQUM7d0JBQ1osT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDO29CQUNsQixDQUFDLENBQUM7eUJBQ0QsT0FBTyxDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDaEQsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssZ0JBQzVCLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLEVBQUcsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssRUFBQztvQkFDdkYsSUFBSSxDQUFDLHFCQUFxQixDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsVUFBVSxDQUNoRCxJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQ3ZGLENBQUM7Z0JBQ04sQ0FBQztZQUNMLENBQUM7WUFDRCxJQUFJLENBQUMsY0FBYyxDQUFDLFVBQVUscUJBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssRUFBSyxDQUFDLEVBQUM7UUFDMUUsQ0FBQztLQUNKLENBQUM7K0VBQ3FDO0FBVXZDO0lBUkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELEtBQUssb0lBQXdCO1FBQzdCLFVBQVUsRUFBRSxJQUFJO1FBQ2hCLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqQyxDQUFDO0tBQ0osQ0FBQzs4RUFDaUM7QUF1RG5DO0lBckRDLEVBQUUsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUErQztRQUN4RSxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDakMsQ0FBQztRQUNELEtBQUssOEdBQVk7UUFDakIsV0FBVyw2SEFBcUI7UUFDaEMsSUFBSSxFQUFFLDhCQUE4QjtRQUNwQyxVQUFVLEVBQUUsTUFBTTtRQUNsQixtQkFBbUIsRUFBRSxJQUFJO1FBQ3pCLG1CQUFtQixFQUFFLENBQUM7UUFDdEIsV0FBVyxFQUFFLElBQUk7UUFDakIsV0FBVyxFQUFFLElBQUk7UUFDakIsU0FBUyxFQUFFLEtBQUs7UUFDaEIsTUFBTTtZQUNGLE9BQU87Z0JBQ0gsU0FBUyxFQUFFLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFO2dCQUN6QyxLQUFLLEVBQUU7b0JBQ0gsUUFBUSxFQUFFLENBQUM7b0JBQ1gsT0FBTyxFQUFFO3dCQUNMLE9BQU8sRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRTtxQkFDeEM7aUJBQ0o7YUFDSixDQUFDO1FBQ04sQ0FBQztRQUNELE9BQU8sRUFBRTtZQUNMLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNqQixJQUFJLEVBQUUsTUFBTTtnQkFDWixLQUFLLHlIQUFRO2dCQUNiLFVBQVUsRUFBRSxJQUFJO2FBQ25CLENBQUM7WUFDRixFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztnQkFDakIsSUFBSSxFQUFFLE1BQU07Z0JBQ1osS0FBSyx5SEFBUTtnQkFDYixVQUFVLEVBQUUsSUFBSTthQUNuQixDQUFDO1lBQ0YsNEdBQTRHO1lBQzVHLEVBQUUsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDO2dCQUN0QixJQUFJLEVBQUUsc0JBQXNCO2dCQUM1QixJQUFJLEVBQUUsV0FBVztnQkFDakIsVUFBVSxFQUFFLE1BQU07Z0JBQ2xCLFFBQVEsRUFBRSxJQUFJO2FBQ2pCLENBQUM7U0FDTDtRQUNELEtBQUssQ0FBQyxRQUFRO1lBQ1YsSUFBSSxNQUFNLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxDQUFDO2dCQUNsQyxJQUFJLENBQUMsQ0FBQyxNQUFNLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxLQUFLLElBQUksRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDO29CQUMzRCxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUMxQixDQUFDO3FCQUFNLENBQUM7b0JBQ0osSUFBSSxDQUFDLFFBQVEsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUM7Z0JBQzlDLENBQUM7WUFDTCxDQUFDO1FBQ0wsQ0FBQztLQUNKLENBQUM7b0VBQzRCO0FBbUY5QjtJQWpGQyxFQUFFLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBNEM7UUFDckUsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pDLENBQUM7UUFDRCxLQUFLLG9HQUFPO1FBQ1osV0FBVyxFQUFFLElBQUk7UUFDakIsV0FBVyxFQUFFLElBQUk7UUFDakIsbUJBQW1CLEVBQUUsSUFBSTtRQUN6QixXQUFXLDJIQUFtQjtRQUM5QixJQUFJLEVBQUUsMkJBQTJCO1FBQ2pDLFVBQVUsRUFBRSxLQUFLO1FBQ2pCLFNBQVMsRUFBRSxLQUFLO1FBQ2hCLE1BQU07WUFDRixNQUFNLE1BQU0sR0FBa0I7Z0JBQzFCLFNBQVMsRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRTtnQkFDekMsT0FBTyxFQUFFLEVBQUUsT0FBTyxFQUFFLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEVBQUU7Z0JBQ2xELGNBQWMsRUFBRSxLQUFLO2FBQ3hCLENBQUM7WUFDRixJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxDQUFDO2dCQUM1QixNQUFNLENBQUMsUUFBUSxHQUFHLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ3pELENBQUM7WUFDRCxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxDQUFDO2dCQUM1QixNQUFNLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQztZQUM3QyxDQUFDO1lBQ0QsT0FBTyxNQUFNLENBQUM7UUFDbEIsQ0FBQztRQUNELE9BQU8sRUFBRTtZQUNMLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNqQixJQUFJLEVBQUUsS0FBSztnQkFDWCxLQUFLLGtIQUFPO2dCQUNaLFVBQVUsRUFBRSxJQUFJO2FBQ25CLENBQUM7WUFDRixFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztnQkFDakIsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsS0FBSyx3SEFBVTtnQkFDZixVQUFVLEVBQUUsSUFBSTthQUNuQixDQUFDO1lBQ0YsRUFBRSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUM7Z0JBQ3RCLElBQUksRUFBRSxpQ0FBaUM7Z0JBQ3ZDLElBQUksRUFBRSxRQUFRO2dCQUNkLFVBQVUsRUFBRSxNQUFNO2dCQUNsQixRQUFRLEVBQUUsSUFBSTthQUNqQixDQUFDO1lBQ0YsRUFBRSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUM7Z0JBQ2pCLElBQUksRUFBRSxhQUFhO2dCQUNuQixLQUFLLG1JQUFnQjtnQkFDckIsUUFBUSxFQUFFLElBQUk7YUFDakIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNqQixJQUFJLEVBQUUsYUFBYTtnQkFDbkIsS0FBSyxtSUFBZ0I7Z0JBQ3JCLFFBQVEsRUFBRSxJQUFJO2FBQ2pCLENBQUM7WUFDRixFQUFFLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQztnQkFDcEIsSUFBSSxFQUFFLFNBQVM7Z0JBQ2YsS0FBSywySEFBWTtnQkFDakIsUUFBUSxFQUFFLElBQUk7YUFDakIsQ0FBQztTQUNMO1FBQ0QsS0FBSyxDQUFDLFFBQVE7WUFDVixJQUFJLE1BQU0sSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsR0FBRyxFQUFFLENBQUM7Z0JBQzVCLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsRUFBRSxDQUFDO29CQUN4QixJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssR0FBRyxFQUFFLE1BQU0sRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUUsQ0FBQztnQkFDMUQsQ0FBQztnQkFDRCxJQUFJLENBQUMsQ0FBQyxNQUFNLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUM7b0JBQy9DLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztvQkFDdEIsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxFQUFFLENBQUM7d0JBQ3hCLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztvQkFDN0IsQ0FBQztvQkFDRCxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUNyQixDQUFDO3FCQUFNLENBQUM7b0JBQ0osSUFBSSxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUM7Z0JBQ3pDLENBQUM7WUFDTCxDQUFDO2lCQUFNLENBQUM7Z0JBQ0osSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDO2dCQUN0QixJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRLEVBQUUsQ0FBQztvQkFDeEIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDO2dCQUM3QixDQUFDO1lBQ0wsQ0FBQztRQUNMLENBQUM7S0FDSixDQUFDOytEQUN1QjtBQXdFekI7SUF0RUMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQTRDO1FBQ3JFLE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqQyxDQUFDO1FBQ0QsS0FBSywwR0FBVTtRQUNmLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLG1CQUFtQixFQUFFLElBQUk7UUFDekIsV0FBVyxpSUFBMkI7UUFDdEMsSUFBSSxFQUFFLDJCQUEyQjtRQUNqQyxVQUFVLEVBQUUsUUFBUTtRQUNwQixTQUFTLEVBQUUsS0FBSztRQUNoQixNQUFNO1lBQ0YsTUFBTSxNQUFNLEdBQWtCO2dCQUMxQixTQUFTLEVBQUUsRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUU7Z0JBQ3pDLE9BQU8sRUFBRSxFQUFFLE9BQU8sRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFO2dCQUNsRCxjQUFjLEVBQUUsS0FBSzthQUN4QixDQUFDO1lBQ0YsSUFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxHQUFHLEVBQUUsQ0FBQztnQkFDdEIsTUFBTSxDQUFDLEdBQUcsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUM7WUFDcEMsQ0FBQztZQUNELElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFLENBQUM7Z0JBQzVCLE1BQU0sQ0FBQyxRQUFRLEdBQUcsRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDekQsQ0FBQztZQUNELE9BQU8sTUFBTSxDQUFDO1FBQ2xCLENBQUM7UUFDRCxPQUFPLEVBQUU7WUFDTCxFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztnQkFDakIsSUFBSSxFQUFFLEtBQUs7Z0JBQ1gsS0FBSyxxSEFBTztnQkFDWixVQUFVLEVBQUUsSUFBSTthQUNuQixDQUFDO1lBQ0YsRUFBRSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUM7Z0JBQ2pCLElBQUksRUFBRSxRQUFRO2dCQUNkLEtBQUssMkhBQVU7Z0JBQ2YsVUFBVSxFQUFFLElBQUk7YUFDbkIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDO2dCQUN0QixJQUFJLEVBQUUsaUNBQWlDO2dCQUN2QyxJQUFJLEVBQUUsUUFBUTtnQkFDZCxVQUFVLEVBQUUsTUFBTTtnQkFDbEIsUUFBUSxFQUFFLElBQUk7YUFDakIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNqQixJQUFJLEVBQUUsYUFBYTtnQkFDbkIsS0FBSyxzSUFBZ0I7Z0JBQ3JCLFFBQVEsRUFBRSxJQUFJO2FBQ2pCLENBQUM7WUFDRixFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztnQkFDakIsSUFBSSxFQUFFLGFBQWE7Z0JBQ25CLEtBQUssc0lBQWdCO2dCQUNyQixRQUFRLEVBQUUsSUFBSTthQUNqQixDQUFDO1lBQ0YsRUFBRSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUM7Z0JBQ3BCLElBQUksRUFBRSxTQUFTO2dCQUNmLEtBQUssOEhBQVk7Z0JBQ2pCLFFBQVEsRUFBRSxJQUFJO2FBQ2pCLENBQUM7U0FDTDtRQUNELEtBQUssQ0FBQyxRQUFRO1lBQ1YsSUFBSSxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxDQUFDO2dCQUNsQyxJQUFJLENBQUMsQ0FBQyxNQUFNLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUM7b0JBQ2xELElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztvQkFDekIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDeEIsQ0FBQztxQkFBTSxDQUFDO29CQUNKLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxFQUFFLEtBQUssRUFBRSxDQUFDO2dCQUM1QyxDQUFDO1lBQ0wsQ0FBQztRQUNMLENBQUM7S0FDSixDQUFDO2tFQUMwQjtBQXFENUI7SUFuREMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQW1EO1FBQzVFLE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqQyxDQUFDO1FBQ0QsS0FBSyx1SEFBaUI7UUFDdEIsV0FBVyxFQUFFLElBQUk7UUFDakIsV0FBVyxFQUFFLElBQUk7UUFDakIsbUJBQW1CLEVBQUUsSUFBSTtRQUN6QixXQUFXLG9JQUF3QjtRQUNuQyxJQUFJLEVBQUUsa0NBQWtDO1FBQ3hDLFVBQVUsRUFBRSxNQUFNO1FBQ2xCLFNBQVMsRUFBRSxLQUFLO1FBQ2hCLE1BQU07WUFDRixNQUFNLE1BQU0sR0FBeUI7Z0JBQ2pDLE9BQU8sRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRTtnQkFDckMsU0FBUyxFQUFFLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFO2FBQzVDLENBQUM7WUFDRixJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxDQUFDO2dCQUM1QixNQUFNLENBQUMsU0FBUyxHQUFHLEVBQUUsUUFBUSxFQUFFLEVBQUUsSUFBSSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUM7WUFDeEUsQ0FBQztZQUNELE9BQU8sTUFBTSxDQUFDO1FBQ2xCLENBQUM7UUFDRCxPQUFPLEVBQUU7WUFDTCxFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztnQkFDakIsSUFBSSxFQUFFLE1BQU07Z0JBQ1osS0FBSyxzSUFBaUI7Z0JBQ3RCLFVBQVUsRUFBRSxJQUFJO2FBQ25CLENBQUM7WUFDRixFQUFFLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQztnQkFDdEIsSUFBSSxFQUFFLDJCQUEyQjtnQkFDakMsSUFBSSxFQUFFLFdBQVc7Z0JBQ2pCLFVBQVUsRUFBRSxhQUFhO2dCQUN6QixRQUFRLEVBQUUsS0FBSzthQUNsQixDQUFDO1lBQ0YsRUFBRSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUM7Z0JBQ3BCLElBQUksRUFBRSxTQUFTO2dCQUNmLEtBQUssb0lBQVk7Z0JBQ2pCLFFBQVEsRUFBRSxJQUFJO2FBQ2pCLENBQUM7U0FDTDtRQUNELEtBQUssQ0FBQyxRQUFRO1lBQ1YsSUFBSSxNQUFNLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxDQUFDO2dCQUN0QyxJQUFJLENBQUMsQ0FBQyxNQUFNLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsRUFBRSxDQUFDO29CQUN6RixJQUFJLENBQUMsWUFBWSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUM7b0JBQy9CLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQzlCLENBQUM7cUJBQU0sQ0FBQztvQkFDSixJQUFJLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQztnQkFDbEQsQ0FBQztZQUNMLENBQUM7UUFDTCxDQUFDO0tBQ0osQ0FBQzt3RUFDZ0M7QUF1RWxDO0lBckVDLEVBQUUsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUE0QztRQUNyRSxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDakMsQ0FBQztRQUNELEtBQUssK0hBQWlCO1FBQ3RCLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLFdBQVcsRUFBRSxJQUFJO1FBQ2pCLG1CQUFtQixFQUFFLElBQUk7UUFDekIsV0FBVyw0SUFBd0I7UUFDbkMsSUFBSSxFQUFFLDJCQUEyQjtRQUNqQyxVQUFVLEVBQUUsY0FBYztRQUMxQixTQUFTLEVBQUUsS0FBSztRQUNoQixNQUFNO1lBQ0YsTUFBTSxNQUFNLEdBQWtCO2dCQUMxQixTQUFTLEVBQUUsRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUU7Z0JBQ3pDLE9BQU8sRUFBRSxFQUFFLE9BQU8sRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFO2dCQUNsRCxjQUFjLEVBQUUsS0FBSztnQkFDckIsaUJBQWlCLEVBQUUsR0FBRzthQUN6QixDQUFDO1lBQ0YsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUUsQ0FBQztnQkFDNUIsTUFBTSxDQUFDLFFBQVEsR0FBRyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUN6RCxDQUFDO1lBQ0QsSUFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxHQUFHLEVBQUUsQ0FBQztnQkFDdEIsTUFBTSxDQUFDLEdBQUcsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUM7WUFDcEMsQ0FBQztZQUNELElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFLENBQUM7Z0JBQzVCLE1BQU0sQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzdDLENBQUM7WUFDRCxPQUFPLE1BQU0sQ0FBQztRQUNsQixDQUFDO1FBQ0QsT0FBTyxFQUFFO1lBQ0wsRUFBRSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUM7Z0JBQ2pCLElBQUksRUFBRSxjQUFjO2dCQUNwQixLQUFLLHNKQUFpQjtnQkFDdEIsVUFBVSxFQUFFLElBQUk7YUFDbkIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDO2dCQUN0QixJQUFJLEVBQUUsaUNBQWlDO2dCQUN2QyxJQUFJLEVBQUUsUUFBUTtnQkFDZCxVQUFVLEVBQUUsTUFBTTtnQkFDbEIsUUFBUSxFQUFFLElBQUk7YUFDakIsQ0FBQztZQUNGLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDO2dCQUNqQixJQUFJLEVBQUUsYUFBYTtnQkFDbkIsS0FBSyxvSkFBZ0I7Z0JBQ3JCLFFBQVEsRUFBRSxJQUFJO2FBQ2pCLENBQUM7WUFDRixFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztnQkFDakIsSUFBSSxFQUFFLGFBQWE7Z0JBQ25CLEtBQUssb0pBQWdCO2dCQUNyQixRQUFRLEVBQUUsSUFBSTthQUNqQixDQUFDO1lBQ0YsRUFBRSxDQUFDLFlBQVksQ0FBQyxPQUFPLENBQUM7Z0JBQ3BCLElBQUksRUFBRSxTQUFTO2dCQUNmLEtBQUssNElBQVk7Z0JBQ2pCLFFBQVEsRUFBRSxJQUFJO2FBQ2pCLENBQUM7U0FDTDtRQUNELEtBQUssQ0FBQyxRQUFRO1lBQ1YsSUFBSSxNQUFNLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLEVBQUUsWUFBWSxFQUFFLENBQUM7Z0JBQ3RELElBQUksQ0FBQyxDQUFDLE1BQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDO29CQUNoRSxJQUFJLENBQUMsb0JBQW9CLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztvQkFDdkMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUN0QyxDQUFDO3FCQUFNLENBQUM7b0JBQ0osSUFBSSxDQUFDLG9CQUFvQixDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsRUFBRSxLQUFLLEVBQUUsQ0FBQztnQkFDMUQsQ0FBQztZQUNMLENBQUM7UUFDTCxDQUFDO0tBQ0osQ0FBQztnRkFDd0M7QUFrQjFDO0lBaEJDLEVBQUUsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFxQztRQUMzRCxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDakMsQ0FBQztRQUNELEtBQUssMEdBQVU7UUFDZixXQUFXLEVBQUUsSUFBSTtRQUNqQixLQUFLLENBQUMsUUFBUTtZQUNWLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDcEIsSUFBSSxDQUFDLENBQUMsTUFBTSxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDO29CQUNsRCxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUN4QixDQUFDO3FCQUFNLENBQUM7b0JBQ0osSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUM7Z0JBQzVDLENBQUM7WUFDTCxDQUFDO1FBQ0wsQ0FBQztLQUNKLENBQUM7a0VBQ3VCO0FBUXpCO0lBTkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqQyxDQUFDO1FBQ0QsS0FBSyxxSEFBZ0I7S0FDeEIsQ0FBQzt1RUFDMEI7QUFRNUI7SUFOQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBcUM7UUFDekQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pDLENBQUM7UUFDRCxLQUFLLHFIQUFnQjtLQUN4QixDQUFDO3VFQUMwQjtBQXdDNUI7SUFuQ0MsRUFBRSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQStDO1FBQ3hFLE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqQyxDQUFDO1FBQ0QsS0FBSyxxSUFBd0I7UUFDN0IsV0FBVyx3SUFBcUI7UUFDaEMsSUFBSSxFQUFFLDhCQUE4QjtRQUNwQyxVQUFVLEVBQUUsTUFBTTtRQUNsQixTQUFTLEVBQUUsS0FBSztRQUNoQixtQkFBbUIsRUFBRSxJQUFJO1FBQ3pCLGFBQWEsRUFBRSxJQUFJO1FBQ25CLE1BQU07WUFDRixPQUFPO2dCQUNILFNBQVMsRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRTtnQkFDekMsUUFBUSxFQUFFLFVBQVU7Z0JBQ3BCLFNBQVMsRUFBRSxFQUFFLEdBQUcsRUFBRSxLQUFLLEVBQUU7Z0JBQ3pCLGNBQWMsRUFBRSxFQUFFLEdBQUcsRUFBRSxLQUFLLEVBQUU7YUFDakMsQ0FBQztRQUNOLENBQUM7UUFDRCxPQUFPLEVBQUU7WUFDTCxFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztnQkFDakIsSUFBSSxFQUFFLE1BQU07Z0JBQ1osS0FBSyxvSUFBUTtnQkFDYixVQUFVLEVBQUUsSUFBSTthQUNuQixDQUFDO1lBQ0YsRUFBRSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUM7Z0JBQ2pCLElBQUksRUFBRSxNQUFNO2dCQUNaLEtBQUssb0lBQVE7Z0JBQ2IsVUFBVSxFQUFFLElBQUk7YUFDbkIsQ0FBQztTQUNMO1FBQ0QsbUJBQW1CLEVBQUUsQ0FBQztRQUN0QixXQUFXLEVBQUUsS0FBSztRQUNsQixXQUFXLEVBQUUsSUFBSTtLQUNwQixDQUFDOytFQUN1QztBQVN6QztJQUpDLEVBQUUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFxQztRQUN6RCxRQUFRLEVBQUUsSUFBSTtRQUNkLFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7Z0ZBQ21DO0FBTXJDO0lBSkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELFFBQVEsRUFBRSxJQUFJO1FBQ2QsVUFBVSxFQUFFLElBQUk7S0FDbkIsQ0FBQzs0RUFDK0I7QUFNakM7SUFKQyxFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBcUM7UUFDNUQsUUFBUSxFQUFFLElBQUk7UUFDZCxVQUFVLEVBQUUsSUFBSTtLQUNuQixDQUFDO2dGQUNzQztBQU14QztJQUpDLEVBQUUsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFxQztRQUM1RCxRQUFRLEVBQUUsSUFBSTtRQUNkLFVBQVUsRUFBRSxJQUFJO0tBQ25CLENBQUM7MEZBQ2dEO0FBTWxEO0lBSkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQXFDO1FBQzVELFFBQVEsRUFBRSxJQUFJO1FBQ2QsVUFBVSxFQUFFLElBQUk7S0FDbkIsQ0FBQzsyRkFDaUQ7QUFNbkQ7SUFKQyxFQUFFLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBcUM7UUFDekQsUUFBUSxFQUFFLElBQUk7UUFDZCxVQUFVLEVBQUUsSUFBSTtLQUNuQixDQUFDO3NGQUN5QztBQVczQztJQVJDLEVBQUUsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFxQztRQUM3RCxNQUFNO1lBQ0YsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDakMsQ0FBQztRQUNELFFBQVEsRUFBRSxJQUFJO1FBQ2QsVUFBVSxFQUFFLElBQUk7UUFDaEIsS0FBSyx5SEFBa0I7S0FDMUIsQ0FBQzt5RUFDZ0M7QUFTbEM7SUFSQyxFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBcUM7UUFDNUQsTUFBTTtZQUNGLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pDLENBQUM7UUFDRCxRQUFRLEVBQUUsSUFBSTtRQUNkLFVBQVUsRUFBRSxJQUFJO1FBQ2hCLEtBQUsseUhBQWtCO0tBQzFCLENBQUM7eUVBQytCO0FBU2pDO0lBUkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqQyxDQUFDO1FBQ0QsUUFBUSxFQUFFLElBQUk7UUFDZCxVQUFVLEVBQUUsSUFBSTtRQUNoQixLQUFLLHFIQUFlO0tBQ3ZCLENBQUM7d0VBQzJCO0FBUzdCO0lBUkMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQXFDO1FBQ3pELE1BQU07WUFDRixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqQyxDQUFDO1FBQ0QsUUFBUSxFQUFFLElBQUk7UUFDZCxVQUFVLEVBQUUsSUFBSTtRQUNoQixLQUFLLG1IQUFlO0tBQ3ZCLENBQUM7c0VBQ3lCOzZDQTM3QmxCLGtDQUFrQztJQWhDOUMsRUFBRSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQXFDO1FBQ3BELEtBQUssdUdBQWU7UUFDcEIsUUFBUSxpSEFBc0I7UUFDOUIsSUFBSSxFQUFFLFNBQVM7UUFDZixXQUFXLEVBQUUsSUFBSTtRQUNqQixhQUFhLEVBQUUsSUFBSTtRQUNuQixVQUFVO1lBQ04sT0FBTztnQkFDSCxLQUFLLEVBQUUsSUFBSSxDQUFDLFVBQVU7Z0JBQ3RCLFVBQVUsRUFBRSxJQUFJLENBQUMsY0FBYztnQkFDL0IsS0FBSyxFQUFFLElBQUksQ0FBQyxPQUFPO2dCQUNuQixVQUFVLEVBQUUsSUFBSSxDQUFDLHFCQUFxQjtnQkFDdEMsS0FBSyxFQUFFLElBQUksQ0FBQyxzQkFBc0I7Z0JBQ2xDLFVBQVUsRUFBRSxJQUFJLENBQUMseUJBQXlCO2FBQzdDLENBQUM7UUFDTixDQUFDO1FBQ0QsS0FBSyxDQUFDLE1BQU07WUFDUixJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsa0NBQWtDLENBQUMsb0JBQW9CLENBQUMsQ0FBQztZQUM3RixJQUFJLFVBQVUsRUFBRSxDQUFDO2dCQUNiLE1BQU0sSUFBSSxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUNuQixpQkFBSSxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sRUFBSSxDQUFDLEdBQUUsQ0FBQztvQkFDN0IsSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO2dCQUN0QyxDQUFDO2dCQUNELE1BQU0sSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO1lBQzlCLENBQUM7aUJBQU0sQ0FBQztnQkFDSixJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDeEIsQ0FBQztRQUNMLENBQUM7UUFDRCxlQUFlO1lBQ1gsT0FBTyxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVUsRUFBRSxJQUFJLENBQUMsY0FBYyxFQUFFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQzNGLENBQUM7S0FDSixDQUFDO0dBQ1csa0NBQWtDLENBMHdFOUMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly94dHJlbUFydGlmYWN0Ly4vbGliL3BhZ2VzL21vYmlsZS1waWNrLXRpY2tldC12aWV3LXBpY2stdGlja2V0LWxpbmUudHM/YzMyNCJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQcm9kdWN0LCBQcm9kdWN0U2l0ZSwgU2VyaWFsTnVtYmVyTWFuYWdlbWVudCwgU3RvY2tNYW5hZ2VtZW50IH0gZnJvbSAnQHNhZ2UveDMtbWFzdGVyLWRhdGEtYXBpJztcbmltcG9ydCB7IGRpYWxvZ0NvbmZpcm1hdGlvbiwgZGlhbG9nTWVzc2FnZSB9IGZyb20gJ0BzYWdlL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL2RpYWxvZ3MnO1xuaW1wb3J0IHsgR3JhcGhBcGkgfSBmcm9tICdAc2FnZS94My1zdG9jay1hcGknO1xuaW1wb3J0IHsgTG9jYXRpb24sIExvdE1hbmFnZW1lbnRNb2RlLCBNb2JpbGVTZXR0aW5ncywgU2VyaWFsTnVtYmVyLCBTdG9jayB9IGZyb20gJ0BzYWdlL3gzLXN0b2NrLWRhdGEtYXBpJztcbmltcG9ydCB7IEFnZ3JlZ2F0ZUdyb3VwU2VsZWN0b3IsIEFnZ3JlZ2F0ZVZhbHVlc1NlbGVjdG9yLCBGaWx0ZXIsIGFnZ3JlZ2F0ZUVkZ2VzU2VsZWN0b3IgfSBmcm9tICdAc2FnZS94dHJlbS1jbGllbnQnO1xuaW1wb3J0ICogYXMgdWkgZnJvbSAnQHNhZ2UveHRyZW0tdWknO1xuaW1wb3J0IHsgdmFsaWRhdGVXaXRoRGV0YWlscyB9IGZyb20gJy4uL2NsaWVudC1mdW5jdGlvbnMvY29udHJvbCc7XG5pbXBvcnQgeyBOb3RpZnlBbmRXYWl0IH0gZnJvbSAnLi4vY2xpZW50LWZ1bmN0aW9ucy9kaXNwbGF5JztcblxuaW50ZXJmYWNlIFBpY2tzIHtcbiAgICBkZXRhaWxlZEFsbG9jYXRpb24/OiBudW1iZXI7XG4gICAgYWxsb2NhdGVkUXVhbnRpdHk/OiBudW1iZXI7XG4gICAgc2hvcnRhZ2VRdWFudGl0eT86IG51bWJlcjtcbiAgICBhZGNQaWNrZWRMaW5lPzogbnVtYmVyO1xuICAgIHNob3J0UGljaz86IGJvb2xlYW47XG4gICAgc3RvY2tVbml0Pzogc3RyaW5nO1xuICAgIHF1YW50aXR5SW5TdG9ja1VuaXQ/OiBudW1iZXI7XG4gICAgcXVhbnRpdHlJblBhY2tpbmdVbml0PzogbnVtYmVyO1xuICAgIHBhY2tpbmdVbml0Pzogc3RyaW5nO1xuICAgIHBhY2tpbmdVbml0Q29kZTogc3RyaW5nO1xuICAgIHBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yPzogbnVtYmVyO1xuICAgIHN0b2NrSWQ/OiBudW1iZXI7XG4gICAgbG9jYXRpb24/OiBzdHJpbmc7XG4gICAgbG90Pzogc3RyaW5nO1xuICAgIHN1YmxvdD86IHN0cmluZztcbiAgICBzdGF0dXM/OiBzdHJpbmc7XG4gICAgc2VyaWFsTnVtYmVyPzogc3RyaW5nO1xuICAgIGNvbmZpcm1lZD86IG51bWJlcjtcbiAgICBsaWNlbnNlUGxhdGVOdW1iZXI6IHN0cmluZyB8IG51bGw7XG4gICAgaWRlbnRpZmllcjE/OiBzdHJpbmc7XG4gICAgaWRlbnRpZmllcjI/OiBzdHJpbmc7XG59XG5pbnRlcmZhY2UgUGlja0xpbmVzIHtcbiAgICBxdWFudGl0eUluU3RvY2tVbml0PzogbnVtYmVyO1xuICAgIHN0b2NrSWQ/OiBudW1iZXI7XG4gICAgbG9jYXRpb24/OiBzdHJpbmc7XG4gICAgbG90Pzogc3RyaW5nO1xuICAgIHN1YmxvdD86IHN0cmluZztcbiAgICBzdGF0dXM/OiBzdHJpbmc7XG4gICAgc2VyaWFsTnVtYmVyPzogc3RyaW5nO1xuICAgIHF1YW50aXR5SW5QYWNraW5nVW5pdD86IG51bWJlcjtcbiAgICBwYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvcj86IG51bWJlcjtcbiAgICBwYWNraW5nVW5pdDogc3RyaW5nO1xuICAgIGxpY2Vuc2VQbGF0ZU51bWJlcj86IHN0cmluZztcbiAgICBpZGVudGlmaWVyMT86IHN0cmluZztcbiAgICBpZGVudGlmaWVyMj86IHN0cmluZztcbn1cblxuaW50ZXJmYWNlIFVuaXRzT2ZNZWFzdXJlIHtcbiAgICB1bml0OiBzdHJpbmc7XG4gICAgbnVtYmVyT2ZEZWNpbWFscz86IG51bWJlcjtcbiAgICB1bml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yPzogbnVtYmVyO1xuICAgIGlzUGFja2luZ0ZhY3RvckVudHJ5QWxsb3dlZD86IGJvb2xlYW47XG59XG5cbnR5cGUgUGlja1N0b2NrTGluZSA9IHtcbiAgICBwYWNraW5nVW5pdD86IHN0cmluZztcbiAgICBxdWFudGl0eUluUGFja2luZ1VuaXQ6IG51bWJlcjtcbiAgICBwYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3RvcjogbnVtYmVyO1xuICAgIHF1YW50aXR5SW5TdG9ja1VuaXQ6IG51bWJlcjtcbiAgICBsb2NhdGlvbj86IHN0cmluZztcbiAgICBsb3Q/OiBzdHJpbmc7XG4gICAgc3VibG90Pzogc3RyaW5nO1xuICAgIHNlcmlhbE51bWJlcj86IHN0cmluZztcbiAgICBzdGF0dXM/OiBzdHJpbmc7XG4gICAgc3RvY2tJZDogbnVtYmVyO1xufTtcblxuQHVpLmRlY29yYXRvcnMucGFnZTxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgdGl0bGU6ICdQaWNrIHRpY2tldCcsXG4gICAgc3VidGl0bGU6ICdFbnRlciBsaW5lIGRldGFpbHMnLFxuICAgIG1vZGU6ICdkZWZhdWx0JyxcbiAgICBpc1RyYW5zaWVudDogdHJ1ZSxcbiAgICBpc1RpdGxlSGlkZGVuOiB0cnVlLFxuICAgIGhlYWRlckNhcmQoKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICB0aXRsZTogdGhpcy5waWNrVGlja2V0LFxuICAgICAgICAgICAgdGl0bGVSaWdodDogdGhpcy5waWNrVGlja2V0TGluZSxcbiAgICAgICAgICAgIGxpbmUyOiB0aGlzLnByb2R1Y3QsXG4gICAgICAgICAgICBsaW5lMlJpZ2h0OiB0aGlzLmxvY2FsaXplZERlc2NyaXB0aW9uMSxcbiAgICAgICAgICAgIGxpbmUzOiB0aGlzLnRleHRRdWFudGl0eVRvQmVQaWNrZWQsXG4gICAgICAgICAgICBsaW5lM1JpZ2h0OiB0aGlzLmRpc3BsYXlRdWFudGl0eVRvQmVQaWNrZWQsXG4gICAgICAgIH07XG4gICAgfSxcbiAgICBhc3luYyBvbkxvYWQoKSB7XG4gICAgICAgIGxldCB0aWNrZXRMaW5lID0gdGhpcy4kLnN0b3JhZ2UuZ2V0KE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmUuUElDS19USUNLRVRfTElORV9LRVkpO1xuICAgICAgICBpZiAodGlja2V0TGluZSkge1xuICAgICAgICAgICAgYXdhaXQgdGhpcy5faW5pdCgpO1xuICAgICAgICAgICAgaWYgKHRoaXMuX2FsbFBpY2tzLmxlbmd0aCA8PSAxKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5uZXh0QnV0dG9uLmlzRGlzYWJsZWQgPSB0cnVlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgYXdhaXQgdGhpcy5fZGlzcGxheVBpY2soKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHRoaXMuX2Rpc2FibGVQYWdlKCk7XG4gICAgICAgIH1cbiAgICB9LFxuICAgIGJ1c2luZXNzQWN0aW9ucygpIHtcbiAgICAgICAgcmV0dXJuIFt0aGlzLnBpY2tCdXR0b24sIHRoaXMubmV4dEJ1dHRvbiwgdGhpcy5zaG9ydGFnZUJ1dHRvbiwgdGhpcy5jaG9vc2VTdG9ja0J1dHRvbl07XG4gICAgfSxcbn0pXG5leHBvcnQgY2xhc3MgTW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZSBleHRlbmRzIHVpLlBhZ2U8R3JhcGhBcGk+IHtcbiAgICAvKlxuICAgICAqXG4gICAgICogIFRlY2huaWNhbCBwcm9wZXJ0aWVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwcml2YXRlIF9ub3RpZmllciA9IG5ldyBOb3RpZnlBbmRXYWl0KHRoaXMpO1xuICAgIHByaXZhdGUgX2FsbFBpY2tzOiBQaWNrc1tdO1xuICAgIHByaXZhdGUgX3BpY2tMaW5lczogUGlja0xpbmVzW107XG4gICAgcHJpdmF0ZSBfcHJvZHVjdFNpdGU6IFByb2R1Y3RTaXRlO1xuICAgIHByaXZhdGUgX3Byb2R1Y3Q6IFByb2R1Y3Q7XG4gICAgcHJpdmF0ZSBfdW5pdHNPZk1lYXN1cmU6IFVuaXRzT2ZNZWFzdXJlW107XG4gICAgcHJpdmF0ZSBfbG90TWFuYWdlbWVudE1vZGU6IExvdE1hbmFnZW1lbnRNb2RlO1xuICAgIHByaXZhdGUgX3NlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlOiBTZXJpYWxOdW1iZXJNYW5hZ2VtZW50O1xuICAgIHByaXZhdGUgX3N0b2NrTWFuYWdlbWVudE1vZGU6IFN0b2NrTWFuYWdlbWVudDtcbiAgICBwcml2YXRlIF9pc0xvY2F0aW9uTWFuYWdlZDogYm9vbGVhbjtcbiAgICBwcml2YXRlIF9pc0xpY2Vuc2VQbGF0ZU51bWJlck1hbmFnZWQ6IGJvb2xlYW47XG4gICAgcHJpdmF0ZSBfaXNOZWdhdGl2ZVN0b2NrQXV0aG9yaXplZDogYm9vbGVhbjtcbiAgICBwcml2YXRlIF9tb2JpbGVTZXR0aW5nczogTW9iaWxlU2V0dGluZ3M7XG4gICAgcHJpdmF0ZSBfdW5pdFN0b2NrTnVtYmVyT2ZEZWNpbWFsczogTnVtYmVyO1xuICAgIGN1cnJlbnRQaWNrOiBudW1iZXI7XG4gICAgY29uZmlybWVkUGlja3M6IG51bWJlcjtcbiAgICBudW1iZXJPZlBpY2tzOiBudW1iZXI7XG4gICAgbmV3UGljazogYm9vbGVhbjtcbiAgICBzaG9ydFBpY2s6IGJvb2xlYW47XG5cbiAgICAvKlxuICAgICAqICBUZWNobmljYWwgZmllbGRzXG4gICAgICovXG4gICAgcHJpdmF0ZSBzdGF0aWMgcmVhZG9ubHkgVFJBTlNBQ1RJT05fS0VZOiBzdHJpbmcgPSAnbW9iaWxlLXBpY2stdGlja2V0LWVudHJ5LXRyYW5zYWN0aW9uJztcbiAgICBwcml2YXRlIHN0YXRpYyByZWFkb25seSBERVNUSU5BVElPTl9LRVk6IHN0cmluZyA9ICdtb2JpbGUtcGljay10aWNrZXQtZGVzdGluYXRpb24tbG9jYXRpb24nO1xuICAgIHByaXZhdGUgc3RhdGljIHJlYWRvbmx5IERFU1RJTkFUSU9OX0RJU1BMQVlfS0VZOiBzdHJpbmcgPSAnbW9iaWxlLXBpY2stdGlja2V0LWRlc3RpbmF0aW9uLWxvY2F0aW9uLWRpc3BsYXknO1xuICAgIHByaXZhdGUgc3RhdGljIHJlYWRvbmx5IFBJQ0tfTElTVF9LRVk6IHN0cmluZyA9ICdtb2JpbGUtcGljay10aWNrZXQtcGljay1saXN0JztcbiAgICBwcml2YXRlIHN0YXRpYyByZWFkb25seSBQSUNLX1RJQ0tFVF9LRVk6IHN0cmluZyA9ICdtb2JpbGUtcGljay10aWNrZXQnO1xuICAgIHByaXZhdGUgc3RhdGljIHJlYWRvbmx5IFBJQ0tfVElDS0VUX0xJTkVfS0VZOiBzdHJpbmcgPSAnbW9iaWxlLXBpY2stdGlja2V0LWxpbmUnO1xuICAgIHByaXZhdGUgc3RhdGljIHJlYWRvbmx5IFBJQ0tfVElDS0VUX0xJTkVfVEVYVDogc3RyaW5nID0gJ21vYmlsZS1waWNrLXRpY2tldC1saW5lLXRleHQnO1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgaXNEaXNhYmxlZDogdHJ1ZSxcbiAgICB9KVxuICAgIHN0b2NrU2l0ZTogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy50ZXh0RmllbGQ8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICBpc0Rpc2FibGVkOiB0cnVlLFxuICAgIH0pXG4gICAgdHJhbnNhY3Rpb246IHVpLmZpZWxkcy5UZXh0O1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgaXNEaXNhYmxlZDogdHJ1ZSxcbiAgICB9KVxuICAgIHBpY2tMaXN0OiB1aS5maWVsZHMuVGV4dDtcblxuICAgIC8qXG4gICAgICogIFBhZ2UgQWN0aW9uc1xuICAgICAqL1xuICAgIEB1aS5kZWNvcmF0b3JzLnBhZ2VBY3Rpb248TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICB0aXRsZTogJ1N1Ym1pdCcsXG4gICAgICAgIHNob3J0Y3V0OiBbJ2YyJ10sXG4gICAgICAgIGJ1dHRvblR5cGU6ICdwcmltYXJ5JyxcbiAgICAgICAgYXN5bmMgb25DbGljaygpIHtcbiAgICAgICAgICAgIGF3YWl0IHRoaXMub25TdWJtaXQoZmFsc2UpO1xuICAgICAgICB9LFxuICAgIH0pXG4gICAgcGlja0J1dHRvbjogdWkuUGFnZUFjdGlvbjtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnBhZ2VBY3Rpb248TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICB0aXRsZTogJ05leHQnLFxuICAgICAgICBzaG9ydGN1dDogWydmMyddLFxuICAgICAgICBidXR0b25UeXBlOiAnc2Vjb25kYXJ5JyxcbiAgICAgICAgYXN5bmMgb25DbGljaygpIHtcbiAgICAgICAgICAgIGF3YWl0IHRoaXMuJC5jb21taXRWYWx1ZUFuZFByb3BlcnR5Q2hhbmdlcygpO1xuICAgICAgICAgICAgYXdhaXQgdGhpcy5fbmV4dFBpY2soKTtcbiAgICAgICAgfSxcbiAgICB9KVxuICAgIG5leHRCdXR0b246IHVpLlBhZ2VBY3Rpb247XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5wYWdlQWN0aW9uPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgdGl0bGU6ICdTaG9ydGFnZScsXG4gICAgICAgIHNob3J0Y3V0OiBbJ2Y0J10sXG4gICAgICAgIGJ1dHRvblR5cGU6ICdzZWNvbmRhcnknLFxuICAgICAgICBpc0Rpc2FibGVkOiB0cnVlLFxuICAgICAgICBhc3luYyBvbkNsaWNrKCkge1xuICAgICAgICAgICAgYXdhaXQgdGhpcy5vblN1Ym1pdCh0cnVlKTtcbiAgICAgICAgfSxcbiAgICB9KVxuICAgIHNob3J0YWdlQnV0dG9uOiB1aS5QYWdlQWN0aW9uO1xuXG4gICAgQHVpLmRlY29yYXRvcnMucGFnZUFjdGlvbjxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHRpdGxlOiAnQ2hvb3NlIHN0b2NrJyxcbiAgICAgICAgc2hvcnRjdXQ6IFsnZjInXSxcbiAgICAgICAgYnV0dG9uVHlwZTogJ3NlY29uZGFyeScsXG4gICAgICAgIGFzeW5jIG9uQ2xpY2soKSB7XG4gICAgICAgICAgICBjb25zdCBwaWNrU3RvY2tMaW5lczogUGlja1N0b2NrTGluZVtdID0gdGhpcy5fYWxsUGlja3NcbiAgICAgICAgICAgICAgICAuZmlsdGVyKGFsbFBpY2sgPT4gYWxsUGljay5jb25maXJtZWQpXG4gICAgICAgICAgICAgICAgLm1hcChhbGxQaWNrID0+IHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHBhY2tpbmdVbml0OiBhbGxQaWNrLnBhY2tpbmdVbml0LFxuICAgICAgICAgICAgICAgICAgICAgICAgcXVhbnRpdHlJblBhY2tpbmdVbml0OiBhbGxQaWNrLnF1YW50aXR5SW5QYWNraW5nVW5pdCxcbiAgICAgICAgICAgICAgICAgICAgICAgIHBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yOiBhbGxQaWNrLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLFxuICAgICAgICAgICAgICAgICAgICAgICAgcXVhbnRpdHlJblN0b2NrVW5pdDogYWxsUGljay5xdWFudGl0eUluU3RvY2tVbml0LFxuICAgICAgICAgICAgICAgICAgICAgICAgbG9jYXRpb246IGFsbFBpY2subG9jYXRpb24sXG4gICAgICAgICAgICAgICAgICAgICAgICBsb3Q6IGFsbFBpY2subG90LFxuICAgICAgICAgICAgICAgICAgICAgICAgc3VibG90OiBhbGxQaWNrLnN1YmxvdCxcbiAgICAgICAgICAgICAgICAgICAgICAgIHNlcmlhbE51bWJlcjogYWxsUGljay5zZXJpYWxOdW1iZXIsXG4gICAgICAgICAgICAgICAgICAgICAgICBzdGF0dXM6IGFsbFBpY2suc3RhdHVzLFxuICAgICAgICAgICAgICAgICAgICAgICAgc3RvY2tJZDogYWxsUGljay5zdG9ja0lkLFxuICAgICAgICAgICAgICAgICAgICB9O1xuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgdGhpcy5wYWNraW5nVW5pdC5pc0RpcnR5ID0gZmFsc2U7XG4gICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC5pc0RpcnR5ID0gZmFsc2U7XG4gICAgICAgICAgICB0aGlzLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLmlzRGlydHkgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMuc3RvY2tVbml0LmlzRGlydHkgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC5pc0RpcnR5ID0gZmFsc2U7XG4gICAgICAgICAgICB0aGlzLmxpY2Vuc2VQbGF0ZU51bWJlci5pc0RpcnR5ID0gZmFsc2U7XG4gICAgICAgICAgICB0aGlzLmxvY2F0aW9uLmlzRGlydHkgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMubG90LmlzRGlydHkgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMuc3VibG90LmlzRGlydHkgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyLmlzRGlydHkgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQuaXNEaXJ0eSA9IGZhbHNlO1xuICAgICAgICAgICAgdGhpcy5zdGF0dXMuaXNEaXJ0eSA9IGZhbHNlO1xuICAgICAgICAgICAgdGhpcy5pZGVudGlmaWVyMS5pc0RpcnR5ID0gZmFsc2U7XG4gICAgICAgICAgICB0aGlzLmlkZW50aWZpZXIyLmlzRGlydHkgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMuZGVzdGluYXRpb25Mb2NhdGlvbi5pc0RpcnR5ID0gZmFsc2U7XG4gICAgICAgICAgICB0aGlzLiQucm91dGVyLmdvVG8oYEBzYWdlL3gzLXN0b2NrL01vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmVHbG9iYWxgLCB7XG4gICAgICAgICAgICAgICAgX2lkOiBgJHt0aGlzLnByb2R1Y3QudmFsdWV9fCR7U3RyaW5nKHRoaXMuJC5zdG9yYWdlLmdldCgnbW9iaWxlLXNlbGVjdGVkLXN0b2NrLXNpdGUnKSl9YCxcbiAgICAgICAgICAgICAgICBtb2JpbGVTZXR0aW5nczogSlNPTi5zdHJpbmdpZnkodGhpcy5fbW9iaWxlU2V0dGluZ3MpLFxuICAgICAgICAgICAgICAgIHBpY2tTdG9ja0xpbmVzOiBKU09OLnN0cmluZ2lmeShwaWNrU3RvY2tMaW5lcyksXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSxcbiAgICB9KVxuICAgIGNob29zZVN0b2NrQnV0dG9uOiB1aS5QYWdlQWN0aW9uO1xuXG4gICAgLypcbiAgICAgKiAgU2VjdGlvbnNcbiAgICAgKi9cbiAgICBAdWkuZGVjb3JhdG9ycy5zZWN0aW9uPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgaXNUaXRsZUhpZGRlbjogdHJ1ZSxcbiAgICB9KVxuICAgIG1haW5TZWN0aW9uOiB1aS5jb250YWluZXJzLlNlY3Rpb247XG5cbiAgICAvKlxuICAgICAqICBCbG9ja3NcbiAgICAgKi9cbiAgICBAdWkuZGVjb3JhdG9ycy5ibG9jazxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLm1haW5TZWN0aW9uO1xuICAgICAgICB9LFxuICAgICAgICBpc1RpdGxlSGlkZGVuOiB0cnVlLFxuICAgIH0pXG4gICAgZGV0YWlsQmxvY2s6IHVpLmNvbnRhaW5lcnMuQmxvY2s7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5ibG9jazxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLm1haW5TZWN0aW9uO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ1N0b2NrIHBpY2tlZCcsXG4gICAgfSlcbiAgICBzdG9ja1BpY2tlZEJsb2NrOiB1aS5jb250YWluZXJzLkJsb2NrO1xuXG4gICAgQHVpLmRlY29yYXRvcnMuYmxvY2s8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5tYWluU2VjdGlvbjtcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdUbyBsb2NhdGlvbicsXG4gICAgfSlcbiAgICBkZXN0aW5hdGlvbkJsb2NrOiB1aS5jb250YWluZXJzLkJsb2NrO1xuXG4gICAgLypcbiAgICAgKiAgRmllbGRzXG4gICAgICovXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgdGl0bGU6ICdQaWNrIHRpY2tldCcsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgfSlcbiAgICBwaWNrVGlja2V0OiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHRpdGxlOiAnTGluZScsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgfSlcbiAgICBwaWNrVGlja2V0TGluZTogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy50ZXh0RmllbGQ8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICB0aXRsZTogJ1Byb2R1Y3QnLFxuICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgIH0pXG4gICAgcHJvZHVjdDogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy50ZXh0RmllbGQ8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgIH0pXG4gICAgbG9jYWxpemVkRGVzY3JpcHRpb24xOiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHRpdGxlOiAnTGluZSBxdWFudGl0eSBpbiBzdG9jayB1bml0JyxcbiAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICB9KVxuICAgIGRpc3BsYXlRdWFudGl0eVRvQmVQaWNrZWQ6IHVpLmZpZWxkcy5UZXh0O1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgdGl0bGU6ICdMaW5lIHF1YW50aXR5IGluIHN0b2NrIHVuaXQnLFxuICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgIH0pXG4gICAgdGV4dFF1YW50aXR5VG9CZVBpY2tlZDogdWkuZmllbGRzLlRleHQ7XG5cbiAgICAvKlxuICAgICAqICBEZXRhaWwgYmxvY2tcbiAgICAgKi9cblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLmRldGFpbEJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICBpc0Z1bGxXaWR0aDogdHJ1ZSxcbiAgICB9KVxuICAgIGRpc3BsYXlRdWFudGl0eVBpY2tlZDogdWkuZmllbGRzLlRleHQ7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5udW1lcmljRmllbGQ8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5kZXRhaWxCbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdRdWFudGl0eSB0byBwaWNrJyxcbiAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgaXNGdWxsV2lkdGg6IGZhbHNlLFxuICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICB9KVxuICAgIHF1YW50aXR5VG9QaWNrOiB1aS5maWVsZHMuTnVtZXJpYztcblxuICAgIEB1aS5kZWNvcmF0b3JzLm51bWVyaWNGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLmRldGFpbEJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ1F1YW50aXR5IHBpY2tlZCcsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgIGlzRnVsbFdpZHRoOiBmYWxzZSxcbiAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgfSlcbiAgICBxdWFudGl0eVBpY2tlZDogdWkuZmllbGRzLk51bWVyaWM7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5kcm9wZG93bkxpc3RGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnN0b2NrUGlja2VkQmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnUEFDIFVuaXQnLFxuICAgICAgICBpc01hbmRhdG9yeTogdHJ1ZSxcbiAgICAgICAgYXN5bmMgb25DaGFuZ2UoKSB7XG4gICAgICAgICAgICBpZiAodGhpcy5wYWNraW5nVW5pdC52YWx1ZSkge1xuICAgICAgICAgICAgICAgIGxldCBwb3MgPSAwO1xuICAgICAgICAgICAgICAgIGxldCBvbGRDb252ZXJzaW9uRmFjdG9yID0gdGhpcy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZTtcbiAgICAgICAgICAgICAgICBjb25zdCBzZWxlY3RlZFZhbHVlID0gdGhpcy5wYWNraW5nVW5pdC52YWx1ZTtcbiAgICAgICAgICAgICAgICBwb3MgPSB0aGlzLl91bml0c09mTWVhc3VyZVxuICAgICAgICAgICAgICAgICAgICAubWFwKGZ1bmN0aW9uIChlKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gZS51bml0O1xuICAgICAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgICAgICAgICAuaW5kZXhPZihzZWxlY3RlZFZhbHVlKTtcbiAgICAgICAgICAgICAgICBpZiAocG9zICE9PSAtMSkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC5zY2FsZSA9IHRoaXMuX3VuaXRzT2ZNZWFzdXJlW3Bvc10ubnVtYmVyT2ZEZWNpbWFscztcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSA9XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLl91bml0c09mTWVhc3VyZVtwb3NdLnVuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I7XG4gICAgICAgICAgICAgICAgICAgIGlmICh0aGlzLmN1cnJlbnRQYWNraW5nVW5pdENvZGUudmFsdWUgPT0gdGhpcy5zdG9ja1VuaXQudmFsdWUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlID1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSAvIHRoaXMucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWU7XG4gICAgICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAodGhpcy5wYWNraW5nVW5pdC52YWx1ZSA9PSB0aGlzLnN0b2NrVW5pdC52YWx1ZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlID0gdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgKiBvbGRDb252ZXJzaW9uRmFjdG9yO1xuICAgICAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICh0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSAqIG9sZENvbnZlcnNpb25GYWN0b3IpIC9cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICBsZXQgdW5yb3VuZGVkUXVhbnRpdHkgPSB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZTtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgPSBOdW1iZXIucGFyc2VGbG9hdChcbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlLnRvRml4ZWQodGhpcy5fdW5pdHNPZk1lYXN1cmVbcG9zXS5udW1iZXJPZkRlY2ltYWxzKSxcbiAgICAgICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgICAgICAgICAgaWYgKHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlIC0gdW5yb3VuZGVkUXVhbnRpdHkgPiAwKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBzd2l0Y2ggKHRoaXMuX3VuaXRzT2ZNZWFzdXJlW3Bvc10ubnVtYmVyT2ZEZWNpbWFscykge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgMDpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgPSB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSAtIDE7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgMTpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgPSB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSAtIDAuMTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAyOlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9IHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlIC0gMC4wMTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAzOlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9IHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlIC0gMC4wMDE7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgNDpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgPSB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSAtIDAuMDAwMTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSA1OlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9IHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlIC0gMC4wMDAwMTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSA2OlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9IHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlIC0gMC4wMDAwMDE7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgdGhpcy5xdWFudGl0eUluU3RvY2tVbml0LnZhbHVlID0gTnVtYmVyLnBhcnNlRmxvYXQoXG4gICAgICAgICAgICAgICAgICAgICAgICAodGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgKiB0aGlzLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLnZhbHVlKS50b0ZpeGVkKFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuX3VuaXRzT2ZNZWFzdXJlW3Bvc10ubnVtYmVyT2ZEZWNpbWFscyxcbiAgICAgICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IuaXNEaXNhYmxlZCA9XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnBhY2tpbmdVbml0LnZhbHVlID09PSB0aGlzLnN0b2NrVW5pdC52YWx1ZSB8fFxuICAgICAgICAgICAgICAgICAgICAgICAgIXRoaXMuX3VuaXRzT2ZNZWFzdXJlW3Bvc10uaXNQYWNraW5nRmFjdG9yRW50cnlBbGxvd2VkO1xuICAgICAgICAgICAgICAgICAgICB0aGlzLmN1cnJlbnRQYWNraW5nVW5pdENvZGUudmFsdWUgPSBzZWxlY3RlZFZhbHVlO1xuICAgICAgICAgICAgICAgICAgICB0aGlzLl9jb21wdXRlUXVhbnRpdHlNYXgoKTtcbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnBhY2tpbmdVbml0LnZhbHVlID0gdGhpcy5jdXJyZW50UGFja2luZ1VuaXRDb2RlLnZhbHVlO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHRoaXMuc2hvcnRhZ2VCdXR0b24uaXNEaXNhYmxlZCA9IHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlICE9PSAwO1xuICAgICAgICB9LFxuICAgIH0pXG4gICAgcGFja2luZ1VuaXQ6IHVpLmZpZWxkcy5Ecm9wZG93bkxpc3Q7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5udW1lcmljRmllbGQ8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5zdG9ja1BpY2tlZEJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ1BBQyBRdHknLFxuICAgICAgICBpc01hbmRhdG9yeTogdHJ1ZSxcbiAgICAgICAgaXNGdWxsV2lkdGg6IGZhbHNlLFxuICAgICAgICB2YWxpZGF0aW9uOiAvXihbMC05XSooXFwuWzAtOV0rKT98WzBdK1xcLlswLTldKlsxLTldWzAtOV0qKSQvLCAvLyByZWcgZXggZm9yIGFueSBwb3NpdGl2ZSBudW1iZXJzIChpbnRlZ2VycyBvciBkZWNpbWFscylcbiAgICAgICAgbWluOiAwLFxuICAgICAgICBzY2FsZSgpIHtcbiAgICAgICAgICAgIGNvbnN0IHBvcyA9IHRoaXMuX3VuaXRzT2ZNZWFzdXJlXG4gICAgICAgICAgICAgICAgLm1hcChmdW5jdGlvbiAoZSkge1xuICAgICAgICAgICAgICAgICAgICByZXR1cm4gZS51bml0O1xuICAgICAgICAgICAgICAgIH0pXG4gICAgICAgICAgICAgICAgLmluZGV4T2YodGhpcy5zdG9ja1VuaXQ/LnZhbHVlKTtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLl91bml0c09mTWVhc3VyZVtwb3NdPy5udW1iZXJPZkRlY2ltYWxzID8/IDA7XG4gICAgICAgIH0sXG4gICAgICAgIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgaWYgKHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlICE9IG51bGwpIHtcbiAgICAgICAgICAgICAgICBsZXQgcG9zID0gdGhpcy5fdW5pdHNPZk1lYXN1cmVcbiAgICAgICAgICAgICAgICAgICAgLm1hcChmdW5jdGlvbiAoZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGUudW5pdDtcbiAgICAgICAgICAgICAgICAgICAgfSlcbiAgICAgICAgICAgICAgICAgICAgLmluZGV4T2YodGhpcy5zdG9ja1VuaXQudmFsdWUpO1xuICAgICAgICAgICAgICAgIC8vIENhbGN1bGF0ZSB0aGUgbmV3IHN0b2NrIHF1YW50aXR5XG4gICAgICAgICAgICAgICAgbGV0IG5ld1N0b2NrVW5pdFF1YW50aXR5ID0gTnVtYmVyLnBhcnNlRmxvYXQoXG4gICAgICAgICAgICAgICAgICAgICh0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSAqIHRoaXMucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWUpLnRvRml4ZWQoXG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLl91bml0c09mTWVhc3VyZVtwb3NdLm51bWJlck9mRGVjaW1hbHMsXG4gICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgICAgIHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC5tYXggPT09IHVuZGVmaW5lZCB8fFxuICAgICAgICAgICAgICAgICAgICBuZXdTdG9ja1VuaXRRdWFudGl0eSA8PSB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQubWF4XG4gICAgICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSA9IG5ld1N0b2NrVW5pdFF1YW50aXR5O1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHRoaXMuc2hvcnRhZ2VCdXR0b24uaXNEaXNhYmxlZCA9IHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlICE9PSAwO1xuICAgICAgICB9LFxuICAgIH0pXG4gICAgcXVhbnRpdHlJblBhY2tpbmdVbml0OiB1aS5maWVsZHMuTnVtZXJpYztcblxuICAgIEB1aS5kZWNvcmF0b3JzLm51bWVyaWNGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnN0b2NrUGlja2VkQmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnQ29udmVyc2lvbiBmYWN0b3InLFxuICAgICAgICBpc01hbmRhdG9yeTogdHJ1ZSxcbiAgICAgICAgc2NhbGU6IDYsXG4gICAgICAgIHZhbGlkYXRpb246IC9eKFsxLTldWzAtOV0qKFxcLlswLTldKyk/fFswXStcXC5bMC05XSpbMS05XVswLTldKikkLywgLy8gcmVnIGV4IGZvciBhbnkgcG9zaXRpdmUgbnVtYmVycyAoaW50ZWdlcnMgb3IgZGVjaW1hbHMpIGV4Y2VwdCAwXG4gICAgICAgIG1pbjogMC4wMDAwMDEsXG4gICAgICAgIGlzRnVsbFdpZHRoOiB0cnVlLFxuICAgICAgICBvbkNoYW5nZSgpIHtcbiAgICAgICAgICAgIGlmICh0aGlzLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLnZhbHVlKSB7XG4gICAgICAgICAgICAgICAgbGV0IHBvcyA9IHRoaXMuX3VuaXRzT2ZNZWFzdXJlXG4gICAgICAgICAgICAgICAgICAgIC5tYXAoZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBlLnVuaXQ7XG4gICAgICAgICAgICAgICAgICAgIH0pXG4gICAgICAgICAgICAgICAgICAgIC5pbmRleE9mKHRoaXMuc3RvY2tVbml0LnZhbHVlKTtcbiAgICAgICAgICAgICAgICBsZXQgb2xkUXVhbnRpdHlJblN0b2NrVW5pdCA9IHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZTtcbiAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQudmFsdWUgPSBOdW1iZXIucGFyc2VGbG9hdChcbiAgICAgICAgICAgICAgICAgICAgKHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlICogdGhpcy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSkudG9GaXhlZChcbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuX3VuaXRzT2ZNZWFzdXJlW3Bvc10ubnVtYmVyT2ZEZWNpbWFscyxcbiAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgICAgIGlmICh0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQudmFsdWUgKyB0aGlzLnF1YW50aXR5UGlja2VkLnZhbHVlID4gdGhpcy5xdWFudGl0eVRvUGljay52YWx1ZSkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuJC5zaG93VG9hc3QoXG4gICAgICAgICAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAnQHNhZ2UveDMtc3RvY2svZGlhbG9nLWVycm9yLXF1YW50aXR5LXBpY2snLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICdRdWFudGl0eSBncmVhdGVyIHRoYW4gcXVhbnRpdHkgdG8gYmUgcGlja2VkJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgICAgICAgICB7IHR5cGU6ICdlcnJvcicgfSxcbiAgICAgICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5xdWFudGl0eUluU3RvY2tVbml0LnZhbHVlID0gb2xkUXVhbnRpdHlJblN0b2NrVW5pdDtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci5mb2N1cygpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB0aGlzLl9jb21wdXRlUXVhbnRpdHlNYXgoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHRoaXMuc2hvcnRhZ2VCdXR0b24uaXNEaXNhYmxlZCA9IHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlICE9PSAwO1xuICAgICAgICB9LFxuICAgIH0pXG4gICAgcGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuc3RvY2tQaWNrZWRCbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgfSlcbiAgICBjdXJyZW50UGFja2luZ1VuaXRDb2RlOiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHRpdGxlOiAnU3RvY2sgdW5pdCcsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnN0b2NrUGlja2VkQmxvY2s7XG4gICAgICAgIH0sXG4gICAgfSlcbiAgICBzdG9ja1VuaXQ6IHVpLmZpZWxkcy5UZXh0O1xuXG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuc3RvY2tQaWNrZWRCbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdTdG9jayBxdWFudGl0eScsXG4gICAgICAgIGlzTWFuZGF0b3J5OiB0cnVlLFxuICAgICAgICBpc0Z1bGxXaWR0aDogZmFsc2UsXG4gICAgICAgIHZhbGlkYXRpb246IC9eKFswLTldKihcXC5bMC05XSspP3xbMF0rXFwuWzAtOV0qWzEtOV1bMC05XSopJC8sIC8vIHJlZyBleCBmb3IgYW55IHBvc2l0aXZlIG51bWJlcnMgKGludGVnZXJzIG9yIGRlY2ltYWxzKVxuICAgICAgICBtaW46IDAsXG4gICAgICAgIHNjYWxlKCkge1xuICAgICAgICAgICAgY29uc3QgcG9zID0gdGhpcy5fdW5pdHNPZk1lYXN1cmVcbiAgICAgICAgICAgICAgICAubWFwKGZ1bmN0aW9uIChlKSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiBlLnVuaXQ7XG4gICAgICAgICAgICAgICAgfSlcbiAgICAgICAgICAgICAgICAuaW5kZXhPZihTdHJpbmcodGhpcy5jdXJyZW50UGFja2luZ1VuaXRDb2RlLnZhbHVlKSA/PyAnJyk7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5fdW5pdHNPZk1lYXN1cmVbcG9zXT8ubnVtYmVyT2ZEZWNpbWFscyA/PyAwO1xuICAgICAgICB9LFxuICAgICAgICBvbkNoYW5nZSgpIHtcbiAgICAgICAgICAgIGlmIChcbiAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQudmFsdWUgIT0gbnVsbCAmJlxuICAgICAgICAgICAgICAgIHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSA8PSB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQubWF4XG4gICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICBpZiAodGhpcy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSA+IDApIHtcbiAgICAgICAgICAgICAgICAgICAgbGV0IHBvcyA9IHRoaXMuX3VuaXRzT2ZNZWFzdXJlXG4gICAgICAgICAgICAgICAgICAgICAgICAubWFwKGZ1bmN0aW9uIChlKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGUudW5pdDtcbiAgICAgICAgICAgICAgICAgICAgICAgIH0pXG4gICAgICAgICAgICAgICAgICAgICAgICAuaW5kZXhPZih0aGlzLmN1cnJlbnRQYWNraW5nVW5pdENvZGUudmFsdWUpO1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQudmFsdWUgLyB0aGlzLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLnZhbHVlO1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9IE51bWJlci5wYXJzZUZsb2F0KFxuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUudG9GaXhlZCh0aGlzLl91bml0c09mTWVhc3VyZVtwb3NdLm51bWJlck9mRGVjaW1hbHMpLFxuICAgICAgICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHRoaXMuc2hvcnRhZ2VCdXR0b24uaXNEaXNhYmxlZCA9IHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSAhPT0gMDtcbiAgICAgICAgfSxcbiAgICB9KVxuICAgIHF1YW50aXR5SW5TdG9ja1VuaXQ6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgdGl0bGU6ICdMaWNlbnNlIFBsYXRlIE51bWJlcicsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgIGlzRnVsbFdpZHRoOiB0cnVlLFxuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5zdG9ja1BpY2tlZEJsb2NrO1xuICAgICAgICB9LFxuICAgIH0pXG4gICAgbGljZW5zZVBsYXRlTnVtYmVyOiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnJlZmVyZW5jZUZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmUsIExvY2F0aW9uPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnN0b2NrUGlja2VkQmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnTG9jYXRpb24nLFxuICAgICAgICBwbGFjZWhvbGRlcjogJ1NjYW4gb3Igc2VsZWN0Li4uJyxcbiAgICAgICAgbm9kZTogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvTG9jYXRpb24nLFxuICAgICAgICB2YWx1ZUZpZWxkOiAnY29kZScsXG4gICAgICAgIGlzQXV0b1NlbGVjdEVuYWJsZWQ6IHRydWUsXG4gICAgICAgIG1pbkxvb2t1cENoYXJhY3RlcnM6IDEsXG4gICAgICAgIGlzRnVsbFdpZHRoOiB0cnVlLFxuICAgICAgICBpc01hbmRhdG9yeTogdHJ1ZSxcbiAgICAgICAgY2FuRmlsdGVyOiBmYWxzZSxcbiAgICAgICAgZmlsdGVyKCkge1xuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICBzdG9ja1NpdGU6IHsgY29kZTogdGhpcy5zdG9ja1NpdGUudmFsdWUgfSxcbiAgICAgICAgICAgICAgICBzdG9jazoge1xuICAgICAgICAgICAgICAgICAgICBfYXRMZWFzdDogMSxcbiAgICAgICAgICAgICAgICAgICAgcHJvZHVjdDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgcHJvZHVjdDogeyBjb2RlOiB0aGlzLnByb2R1Y3QudmFsdWUgfSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSxcbiAgICAgICAgY29sdW1uczogW1xuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnRleHQoe1xuICAgICAgICAgICAgICAgIGJpbmQ6ICdjb2RlJyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ0NvZGUnLFxuICAgICAgICAgICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAndHlwZScsXG4gICAgICAgICAgICAgICAgdGl0bGU6ICdUeXBlJyxcbiAgICAgICAgICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICAvLyAoWDMtMjI3MzQ3KSBUT0RPIE9ic29sZXRlOiBIYXZpbmcgdG8gc3BlY2lmeSAmIGhpZGUgZmllbGRzIHVzZWQgaW4gZmlsdGVyIHRoYXQgZG9uJ3QgbmVlZCB0byBiZSBkaXNwbGF5ZWRcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy5yZWZlcmVuY2Uoe1xuICAgICAgICAgICAgICAgIG5vZGU6ICdAc2FnZS94My1zeXN0ZW0vU2l0ZScsXG4gICAgICAgICAgICAgICAgYmluZDogJ3N0b2NrU2l0ZScsXG4gICAgICAgICAgICAgICAgdmFsdWVGaWVsZDogJ2NvZGUnLFxuICAgICAgICAgICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgIF0sXG4gICAgICAgIGFzeW5jIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgaWYgKGF3YWl0IHRoaXMubG9jYXRpb24udmFsdWU/LmNvZGUpIHtcbiAgICAgICAgICAgICAgICBpZiAoIShhd2FpdCB0aGlzLl92YWxpZGF0ZVN0b2NrKHRoaXMubG9jYXRpb24/LnRpdGxlID8/ICcnKSkpIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5sb2NhdGlvbi5mb2N1cygpO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMubG9jYXRpb24uZ2V0TmV4dEZpZWxkKHRydWUpPy5mb2N1cygpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICB9KVxuICAgIGxvY2F0aW9uOiB1aS5maWVsZHMuUmVmZXJlbmNlO1xuXG4gICAgQHVpLmRlY29yYXRvcnMucmVmZXJlbmNlRmllbGQ8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZSwgU3RvY2s+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuc3RvY2tQaWNrZWRCbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdMb3QnLFxuICAgICAgICBpc01hbmRhdG9yeTogdHJ1ZSxcbiAgICAgICAgaXNGdWxsV2lkdGg6IHRydWUsXG4gICAgICAgIGlzQXV0b1NlbGVjdEVuYWJsZWQ6IHRydWUsXG4gICAgICAgIHBsYWNlaG9sZGVyOiAnU2NhbiBvciBzZWxlY3TigKYnLFxuICAgICAgICBub2RlOiAnQHNhZ2UveDMtc3RvY2stZGF0YS9TdG9jaycsXG4gICAgICAgIHZhbHVlRmllbGQ6ICdsb3QnLFxuICAgICAgICBjYW5GaWx0ZXI6IGZhbHNlLFxuICAgICAgICBmaWx0ZXIoKSB7XG4gICAgICAgICAgICBjb25zdCBmaWx0ZXI6IEZpbHRlcjxTdG9jaz4gPSB7XG4gICAgICAgICAgICAgICAgc3RvY2tTaXRlOiB7IGNvZGU6IHRoaXMuc3RvY2tTaXRlLnZhbHVlIH0sXG4gICAgICAgICAgICAgICAgcHJvZHVjdDogeyBwcm9kdWN0OiB7IGNvZGU6IHRoaXMucHJvZHVjdC52YWx1ZSB9IH0sXG4gICAgICAgICAgICAgICAgaXNCZWluZ0NvdW50ZWQ6IGZhbHNlLFxuICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIGlmICh0aGlzLmxvY2F0aW9uLnZhbHVlPy5jb2RlKSB7XG4gICAgICAgICAgICAgICAgZmlsdGVyLmxvY2F0aW9uID0geyBjb2RlOiB0aGlzLmxvY2F0aW9uLnZhbHVlLmNvZGUgfTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh0aGlzLnN1YmxvdC52YWx1ZT8uc3VibG90KSB7XG4gICAgICAgICAgICAgICAgZmlsdGVyLnN1YmxvdCA9IHRoaXMuc3VibG90LnZhbHVlLnN1YmxvdDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBmaWx0ZXI7XG4gICAgICAgIH0sXG4gICAgICAgIGNvbHVtbnM6IFtcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAnbG90JyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ0xvdCcsXG4gICAgICAgICAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnRleHQoe1xuICAgICAgICAgICAgICAgIGJpbmQ6ICdzdWJsb3QnLFxuICAgICAgICAgICAgICAgIHRpdGxlOiAnU3VibG90JyxcbiAgICAgICAgICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICB1aS5uZXN0ZWRGaWVsZHMucmVmZXJlbmNlKHtcbiAgICAgICAgICAgICAgICBub2RlOiAnQHNhZ2UveDMtc3RvY2stZGF0YS9TdG9ja1N0YXR1cycsXG4gICAgICAgICAgICAgICAgYmluZDogJ3N0YXR1cycsXG4gICAgICAgICAgICAgICAgdmFsdWVGaWVsZDogJ2NvZGUnLFxuICAgICAgICAgICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICB1aS5uZXN0ZWRGaWVsZHMudGV4dCh7XG4gICAgICAgICAgICAgICAgYmluZDogJ2lkZW50aWZpZXIxJyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ0lkZW50aWZpZXIgMScsXG4gICAgICAgICAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAnaWRlbnRpZmllcjInLFxuICAgICAgICAgICAgICAgIHRpdGxlOiAnSWRlbnRpZmllciAyJyxcbiAgICAgICAgICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLm51bWVyaWMoe1xuICAgICAgICAgICAgICAgIGJpbmQ6ICdzdG9ja0lkJyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ1N0b2NrIElkJyxcbiAgICAgICAgICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICBdLFxuICAgICAgICBhc3luYyBvbkNoYW5nZSgpIHtcbiAgICAgICAgICAgIGlmIChhd2FpdCB0aGlzLmxvdC52YWx1ZT8ubG90KSB7XG4gICAgICAgICAgICAgICAgaWYgKCF0aGlzLnN1YmxvdC5pc0hpZGRlbikge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnN1YmxvdC52YWx1ZSA9IHsgc3VibG90OiB0aGlzLmxvdC52YWx1ZS5zdWJsb3QgfTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgaWYgKCEoYXdhaXQgdGhpcy5fdmFsaWRhdGVTdG9jayh0aGlzLmxvdC50aXRsZSkpKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMubG90LnZhbHVlID0gbnVsbDtcbiAgICAgICAgICAgICAgICAgICAgaWYgKCF0aGlzLnN1YmxvdC5pc0hpZGRlbikge1xuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5zdWJsb3QudmFsdWUgPSBudWxsO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIHRoaXMubG90LmZvY3VzKCk7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5sb3QuZ2V0TmV4dEZpZWxkKHRydWUpPy5mb2N1cygpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgdGhpcy5sb3QudmFsdWUgPSBudWxsO1xuICAgICAgICAgICAgICAgIGlmICghdGhpcy5zdWJsb3QuaXNIaWRkZW4pIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5zdWJsb3QudmFsdWUgPSBudWxsO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICB9KVxuICAgIGxvdDogdWkuZmllbGRzLlJlZmVyZW5jZTtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnJlZmVyZW5jZUZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmUsIFN0b2NrPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnN0b2NrUGlja2VkQmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnU3VibG90JyxcbiAgICAgICAgaXNNYW5kYXRvcnk6IHRydWUsXG4gICAgICAgIGlzRnVsbFdpZHRoOiB0cnVlLFxuICAgICAgICBpc0F1dG9TZWxlY3RFbmFibGVkOiB0cnVlLFxuICAgICAgICBwbGFjZWhvbGRlcjogJ1NjYW4gb3Igc2VsZWN0IGEgc3VibG90JyxcbiAgICAgICAgbm9kZTogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvU3RvY2snLFxuICAgICAgICB2YWx1ZUZpZWxkOiAnc3VibG90JyxcbiAgICAgICAgY2FuRmlsdGVyOiBmYWxzZSxcbiAgICAgICAgZmlsdGVyKCkge1xuICAgICAgICAgICAgY29uc3QgZmlsdGVyOiBGaWx0ZXI8U3RvY2s+ID0ge1xuICAgICAgICAgICAgICAgIHN0b2NrU2l0ZTogeyBjb2RlOiB0aGlzLnN0b2NrU2l0ZS52YWx1ZSB9LFxuICAgICAgICAgICAgICAgIHByb2R1Y3Q6IHsgcHJvZHVjdDogeyBjb2RlOiB0aGlzLnByb2R1Y3QudmFsdWUgfSB9LFxuICAgICAgICAgICAgICAgIGlzQmVpbmdDb3VudGVkOiBmYWxzZSxcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgICBpZiAodGhpcy5sb3QudmFsdWU/LmxvdCkge1xuICAgICAgICAgICAgICAgIGZpbHRlci5sb3QgPSB0aGlzLmxvdC52YWx1ZS5sb3Q7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAodGhpcy5sb2NhdGlvbi52YWx1ZT8uY29kZSkge1xuICAgICAgICAgICAgICAgIGZpbHRlci5sb2NhdGlvbiA9IHsgY29kZTogdGhpcy5sb2NhdGlvbi52YWx1ZS5jb2RlIH07XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gZmlsdGVyO1xuICAgICAgICB9LFxuICAgICAgICBjb2x1bW5zOiBbXG4gICAgICAgICAgICB1aS5uZXN0ZWRGaWVsZHMudGV4dCh7XG4gICAgICAgICAgICAgICAgYmluZDogJ2xvdCcsXG4gICAgICAgICAgICAgICAgdGl0bGU6ICdMb3QnLFxuICAgICAgICAgICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAnc3VibG90JyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ1N1YmxvdCcsXG4gICAgICAgICAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnJlZmVyZW5jZSh7XG4gICAgICAgICAgICAgICAgbm9kZTogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvU3RvY2tTdGF0dXMnLFxuICAgICAgICAgICAgICAgIGJpbmQ6ICdzdGF0dXMnLFxuICAgICAgICAgICAgICAgIHZhbHVlRmllbGQ6ICdjb2RlJyxcbiAgICAgICAgICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnRleHQoe1xuICAgICAgICAgICAgICAgIGJpbmQ6ICdpZGVudGlmaWVyMScsXG4gICAgICAgICAgICAgICAgdGl0bGU6ICdJZGVudGlmaWVyIDEnLFxuICAgICAgICAgICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICB1aS5uZXN0ZWRGaWVsZHMudGV4dCh7XG4gICAgICAgICAgICAgICAgYmluZDogJ2lkZW50aWZpZXIyJyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ0lkZW50aWZpZXIgMicsXG4gICAgICAgICAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy5udW1lcmljKHtcbiAgICAgICAgICAgICAgICBiaW5kOiAnc3RvY2tJZCcsXG4gICAgICAgICAgICAgICAgdGl0bGU6ICdTdG9jayBJZCcsXG4gICAgICAgICAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgXSxcbiAgICAgICAgYXN5bmMgb25DaGFuZ2UoKSB7XG4gICAgICAgICAgICBpZiAoYXdhaXQgdGhpcy5zdWJsb3QudmFsdWU/LnN1YmxvdCkge1xuICAgICAgICAgICAgICAgIGlmICghKGF3YWl0IHRoaXMuX3ZhbGlkYXRlU3RvY2sodGhpcy5zdWJsb3QudGl0bGUpKSkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnN1YmxvdC52YWx1ZSA9IG51bGw7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuc3VibG90LmZvY3VzKCk7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5zdWJsb3QuZ2V0TmV4dEZpZWxkKHRydWUpPy5mb2N1cygpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICB9KVxuICAgIHN1YmxvdDogdWkuZmllbGRzLlJlZmVyZW5jZTtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnJlZmVyZW5jZUZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmUsIFNlcmlhbE51bWJlcj4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5zdG9ja1BpY2tlZEJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ1NlcmlhbCBudW1iZXInLFxuICAgICAgICBpc01hbmRhdG9yeTogdHJ1ZSxcbiAgICAgICAgaXNGdWxsV2lkdGg6IHRydWUsXG4gICAgICAgIGlzQXV0b1NlbGVjdEVuYWJsZWQ6IHRydWUsXG4gICAgICAgIHBsYWNlaG9sZGVyOiAnU2NhbiBhIHNlcmlhbCBudW1iZXInLFxuICAgICAgICBub2RlOiAnQHNhZ2UveDMtc3RvY2stZGF0YS9TZXJpYWxOdW1iZXInLFxuICAgICAgICB2YWx1ZUZpZWxkOiAnY29kZScsXG4gICAgICAgIGNhbkZpbHRlcjogZmFsc2UsXG4gICAgICAgIGZpbHRlcigpIHtcbiAgICAgICAgICAgIGNvbnN0IGZpbHRlcjogRmlsdGVyPFNlcmlhbE51bWJlcj4gPSB7XG4gICAgICAgICAgICAgICAgcHJvZHVjdDogeyBjb2RlOiB0aGlzLnByb2R1Y3QudmFsdWUgfSxcbiAgICAgICAgICAgICAgICBzdG9ja1NpdGU6IHsgY29kZTogdGhpcy5zdG9ja1NpdGUudmFsdWUgfSxcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgICBpZiAodGhpcy5sb2NhdGlvbi52YWx1ZT8uY29kZSkge1xuICAgICAgICAgICAgICAgIGZpbHRlci5zdG9ja0xpbmUgPSB7IGxvY2F0aW9uOiB7IGNvZGU6IHRoaXMubG9jYXRpb24udmFsdWUuY29kZSB9IH07XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gZmlsdGVyO1xuICAgICAgICB9LFxuICAgICAgICBjb2x1bW5zOiBbXG4gICAgICAgICAgICB1aS5uZXN0ZWRGaWVsZHMudGV4dCh7XG4gICAgICAgICAgICAgICAgYmluZDogJ2NvZGUnLFxuICAgICAgICAgICAgICAgIHRpdGxlOiAnU2VyaWFsIG51bWJlcicsXG4gICAgICAgICAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnJlZmVyZW5jZSh7XG4gICAgICAgICAgICAgICAgbm9kZTogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvU3RvY2snLFxuICAgICAgICAgICAgICAgIGJpbmQ6ICdzdG9ja0xpbmUnLFxuICAgICAgICAgICAgICAgIHZhbHVlRmllbGQ6ICdzdGF0dXMuY29kZScsXG4gICAgICAgICAgICAgICAgaXNIaWRkZW46IGZhbHNlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICB1aS5uZXN0ZWRGaWVsZHMubnVtZXJpYyh7XG4gICAgICAgICAgICAgICAgYmluZDogJ3N0b2NrSWQnLFxuICAgICAgICAgICAgICAgIHRpdGxlOiAnU3RvY2sgSWQnLFxuICAgICAgICAgICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgIF0sXG4gICAgICAgIGFzeW5jIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgaWYgKGF3YWl0IHRoaXMuc2VyaWFsTnVtYmVyLnZhbHVlPy5jb2RlKSB7XG4gICAgICAgICAgICAgICAgaWYgKCEoYXdhaXQgdGhpcy5fdmFsaWRhdGVTdG9jayh0aGlzLnNlcmlhbE51bWJlci50aXRsZSwgdGhpcy5zZXJpYWxOdW1iZXIudmFsdWUuc3RvY2tJZCkpKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyLnZhbHVlID0gbnVsbDtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXIuZm9jdXMoKTtcbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnNlcmlhbE51bWJlci5nZXROZXh0RmllbGQodHJ1ZSk/LmZvY3VzKCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9LFxuICAgIH0pXG4gICAgc2VyaWFsTnVtYmVyOiB1aS5maWVsZHMuUmVmZXJlbmNlO1xuXG4gICAgQHVpLmRlY29yYXRvcnMucmVmZXJlbmNlRmllbGQ8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZSwgU3RvY2s+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuc3RvY2tQaWNrZWRCbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgdGl0bGU6ICdTZXJpYWwgbnVtYmVyJyxcbiAgICAgICAgaXNNYW5kYXRvcnk6IHRydWUsXG4gICAgICAgIGlzRnVsbFdpZHRoOiB0cnVlLFxuICAgICAgICBpc0F1dG9TZWxlY3RFbmFibGVkOiB0cnVlLFxuICAgICAgICBwbGFjZWhvbGRlcjogJ1NjYW4gYSBzZXJpYWwgbnVtYmVyJyxcbiAgICAgICAgbm9kZTogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvU3RvY2snLFxuICAgICAgICB2YWx1ZUZpZWxkOiAnc2VyaWFsTnVtYmVyJyxcbiAgICAgICAgY2FuRmlsdGVyOiBmYWxzZSxcbiAgICAgICAgZmlsdGVyKCkge1xuICAgICAgICAgICAgY29uc3QgZmlsdGVyOiBGaWx0ZXI8U3RvY2s+ID0ge1xuICAgICAgICAgICAgICAgIHN0b2NrU2l0ZTogeyBjb2RlOiB0aGlzLnN0b2NrU2l0ZS52YWx1ZSB9LFxuICAgICAgICAgICAgICAgIHByb2R1Y3Q6IHsgcHJvZHVjdDogeyBjb2RlOiB0aGlzLnByb2R1Y3QudmFsdWUgfSB9LFxuICAgICAgICAgICAgICAgIGlzQmVpbmdDb3VudGVkOiBmYWxzZSxcbiAgICAgICAgICAgICAgICBhbGxvY2F0ZWRRdWFudGl0eTogJzAnLFxuICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIGlmICh0aGlzLmxvY2F0aW9uLnZhbHVlPy5jb2RlKSB7XG4gICAgICAgICAgICAgICAgZmlsdGVyLmxvY2F0aW9uID0geyBjb2RlOiB0aGlzLmxvY2F0aW9uLnZhbHVlLmNvZGUgfTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh0aGlzLmxvdC52YWx1ZT8ubG90KSB7XG4gICAgICAgICAgICAgICAgZmlsdGVyLmxvdCA9IHRoaXMubG90LnZhbHVlLmxvdDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh0aGlzLnN1YmxvdC52YWx1ZT8uc3VibG90KSB7XG4gICAgICAgICAgICAgICAgZmlsdGVyLnN1YmxvdCA9IHRoaXMuc3VibG90LnZhbHVlLnN1YmxvdDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBmaWx0ZXI7XG4gICAgICAgIH0sXG4gICAgICAgIGNvbHVtbnM6IFtcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAnc2VyaWFsTnVtYmVyJyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ1NlcmlhbCBudW1iZXInLFxuICAgICAgICAgICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy5yZWZlcmVuY2Uoe1xuICAgICAgICAgICAgICAgIG5vZGU6ICdAc2FnZS94My1zdG9jay1kYXRhL1N0b2NrU3RhdHVzJyxcbiAgICAgICAgICAgICAgICBiaW5kOiAnc3RhdHVzJyxcbiAgICAgICAgICAgICAgICB2YWx1ZUZpZWxkOiAnY29kZScsXG4gICAgICAgICAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAnaWRlbnRpZmllcjEnLFxuICAgICAgICAgICAgICAgIHRpdGxlOiAnSWRlbnRpZmllciAxJyxcbiAgICAgICAgICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnRleHQoe1xuICAgICAgICAgICAgICAgIGJpbmQ6ICdpZGVudGlmaWVyMicsXG4gICAgICAgICAgICAgICAgdGl0bGU6ICdJZGVudGlmaWVyIDInLFxuICAgICAgICAgICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICAgICB1aS5uZXN0ZWRGaWVsZHMubnVtZXJpYyh7XG4gICAgICAgICAgICAgICAgYmluZDogJ3N0b2NrSWQnLFxuICAgICAgICAgICAgICAgIHRpdGxlOiAnU3RvY2sgSWQnLFxuICAgICAgICAgICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgIF0sXG4gICAgICAgIGFzeW5jIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgaWYgKGF3YWl0IHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQudmFsdWU/LnNlcmlhbE51bWJlcikge1xuICAgICAgICAgICAgICAgIGlmICghKGF3YWl0IHRoaXMuX3ZhbGlkYXRlU3RvY2sodGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC50aXRsZSkpKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQudmFsdWUgPSBudWxsO1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnNlcmlhbE51bWJlclJlY2VpdmVkLmZvY3VzKCk7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC5nZXROZXh0RmllbGQodHJ1ZSk/LmZvY3VzKCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9LFxuICAgIH0pXG4gICAgc2VyaWFsTnVtYmVyUmVjZWl2ZWQ6IHVpLmZpZWxkcy5SZWZlcmVuY2U7XG5cbiAgICBAdWkuZGVjb3JhdG9ycy5zZWxlY3RGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnN0b2NrUGlja2VkQmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnU3RhdHVzJyxcbiAgICAgICAgaXNNYW5kYXRvcnk6IHRydWUsXG4gICAgICAgIGFzeW5jIG9uQ2hhbmdlKCkge1xuICAgICAgICAgICAgaWYgKHRoaXMuc3RhdHVzLnZhbHVlKSB7XG4gICAgICAgICAgICAgICAgaWYgKCEoYXdhaXQgdGhpcy5fdmFsaWRhdGVTdG9jayh0aGlzLnN0YXR1cy50aXRsZSkpKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuc3RhdHVzLmZvY3VzKCk7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5zdGF0dXMuZ2V0TmV4dEZpZWxkKHRydWUpPy5mb2N1cygpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICB9KVxuICAgIHN0YXR1czogdWkuZmllbGRzLlNlbGVjdDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnN0b2NrUGlja2VkQmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnSWRlbnRpZmllciAxJyxcbiAgICB9KVxuICAgIGlkZW50aWZpZXIxOiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIHBhcmVudCgpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnN0b2NrUGlja2VkQmxvY2s7XG4gICAgICAgIH0sXG4gICAgICAgIHRpdGxlOiAnSWRlbnRpZmllciAyJyxcbiAgICB9KVxuICAgIGlkZW50aWZpZXIyOiB1aS5maWVsZHMuVGV4dDtcblxuICAgIC8qXG4gICAgICogRGVzdGluYXRpb24gbG9jYXRpb24gYmxvY2tcbiAgICAgKi9cbiAgICBAdWkuZGVjb3JhdG9ycy5yZWZlcmVuY2VGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lLCBMb2NhdGlvbj4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5kZXN0aW5hdGlvbkJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICB0aXRsZTogJ0Rlc3RpbmF0aW9uIGxvY2F0aW9uJyxcbiAgICAgICAgcGxhY2Vob2xkZXI6ICdTY2FuIG9yIHNlbGVjdC4uLicsXG4gICAgICAgIG5vZGU6ICdAc2FnZS94My1zdG9jay1kYXRhL0xvY2F0aW9uJyxcbiAgICAgICAgdmFsdWVGaWVsZDogJ2NvZGUnLFxuICAgICAgICBjYW5GaWx0ZXI6IGZhbHNlLFxuICAgICAgICBpc0F1dG9TZWxlY3RFbmFibGVkOiB0cnVlLFxuICAgICAgICBpc1RpdGxlSGlkZGVuOiB0cnVlLFxuICAgICAgICBmaWx0ZXIoKSB7XG4gICAgICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgICAgIHN0b2NrU2l0ZTogeyBjb2RlOiB0aGlzLnN0b2NrU2l0ZS52YWx1ZSB9LFxuICAgICAgICAgICAgICAgIGNhdGVnb3J5OiAnaW50ZXJuYWwnLFxuICAgICAgICAgICAgICAgIGlzQmxvY2tlZDogeyBfZXE6IGZhbHNlIH0sXG4gICAgICAgICAgICAgICAgaXNCZWluZ0NvdW50ZWQ6IHsgX2VxOiBmYWxzZSB9LFxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSxcbiAgICAgICAgY29sdW1uczogW1xuICAgICAgICAgICAgdWkubmVzdGVkRmllbGRzLnRleHQoe1xuICAgICAgICAgICAgICAgIGJpbmQ6ICdjb2RlJyxcbiAgICAgICAgICAgICAgICB0aXRsZTogJ0NvZGUnLFxuICAgICAgICAgICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIHVpLm5lc3RlZEZpZWxkcy50ZXh0KHtcbiAgICAgICAgICAgICAgICBiaW5kOiAndHlwZScsXG4gICAgICAgICAgICAgICAgdGl0bGU6ICdUeXBlJyxcbiAgICAgICAgICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgICAgICAgICAgfSksXG4gICAgICAgIF0sXG4gICAgICAgIG1pbkxvb2t1cENoYXJhY3RlcnM6IDEsXG4gICAgICAgIGlzTWFuZGF0b3J5OiBmYWxzZSxcbiAgICAgICAgaXNGdWxsV2lkdGg6IHRydWUsXG4gICAgfSlcbiAgICBkZXN0aW5hdGlvbkxvY2F0aW9uOiB1aS5maWVsZHMuUmVmZXJlbmNlO1xuXG4gICAgLypcbiAgICAgKiBUaGUgZm9sbG93aW5nIGZpZWxkcyBoYXZlIGJlZW4gYWRkZWQgdG8gc2ltcGxpZnkgY3VzdG9taXphdGlvbiBieSBwcm92aWRpbmcgYWNjZXNzIHRvIHRoZSBkZXRhaWxzIG9mIHRoZSBzZWxlY3RlZCBwaWNrLXRpY2tldFxuICAgICAqL1xuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgIH0pXG4gICAgc291cmNlUGlja1RpY2tldFR5cGU6IHVpLmZpZWxkcy5UZXh0O1xuXG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgfSlcbiAgICBzb3VyY2VQaWNrVGlja2V0OiB1aS5maWVsZHMuVGV4dDtcblxuICAgIEB1aS5kZWNvcmF0b3JzLm51bWVyaWNGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgIH0pXG4gICAgc291cmNlUGlja1RpY2tldExpbmU6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgfSlcbiAgICBzb3VyY2VQaWNrVGlja2V0U2VxdWVuY2VOdW1iZXI6IHVpLmZpZWxkcy5OdW1lcmljO1xuXG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgfSlcbiAgICBzb3VyY2VQaWNrVGlja2V0U3ViY29udHJhY3RUeXBlOiB1aS5maWVsZHMuTnVtZXJpYztcblxuICAgIEB1aS5kZWNvcmF0b3JzLnRleHRGaWVsZDxNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lPih7XG4gICAgICAgIGlzSGlkZGVuOiB0cnVlLFxuICAgICAgICBpc1JlYWRPbmx5OiB0cnVlLFxuICAgIH0pXG4gICAgc3ViY29udHJhY3RSZW9yZGVyTG9jYXRpb246IHVpLmZpZWxkcy5UZXh0O1xuXG4gICAgLy8gdGVjaG5pY2FsIGZpZWxkcyBmb3IgY3VzdG9taXphdGlvblxuICAgIEB1aS5kZWNvcmF0b3JzLmNoZWNrYm94RmllbGQ8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5zdG9ja1BpY2tlZEJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgdGl0bGU6ICdjdXN0b20gYm9vbGVhbicsXG4gICAgfSlcbiAgICBjdXN0b21Cb29sZWFuOiB1aS5maWVsZHMuQ2hlY2tib3g7XG4gICAgQHVpLmRlY29yYXRvcnMubnVtZXJpY0ZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuc3RvY2tQaWNrZWRCbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgIHRpdGxlOiAnY3VzdG9tIGRlY2ltYWwnLFxuICAgIH0pXG4gICAgY3VzdG9tRGVjaW1hbDogdWkuZmllbGRzLk51bWVyaWM7XG4gICAgQHVpLmRlY29yYXRvcnMudGV4dEZpZWxkPE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmU+KHtcbiAgICAgICAgcGFyZW50KCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuc3RvY2tQaWNrZWRCbG9jaztcbiAgICAgICAgfSxcbiAgICAgICAgaXNIaWRkZW46IHRydWUsXG4gICAgICAgIGlzUmVhZE9ubHk6IHRydWUsXG4gICAgICAgIHRpdGxlOiAnY3VzdG9tIHRleHQnLFxuICAgIH0pXG4gICAgY3VzdG9tU3RyaW5nOiB1aS5maWVsZHMuVGV4dDtcbiAgICBAdWkuZGVjb3JhdG9ycy5kYXRlRmllbGQ8TW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZT4oe1xuICAgICAgICBwYXJlbnQoKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5zdG9ja1BpY2tlZEJsb2NrO1xuICAgICAgICB9LFxuICAgICAgICBpc0hpZGRlbjogdHJ1ZSxcbiAgICAgICAgaXNSZWFkT25seTogdHJ1ZSxcbiAgICAgICAgdGl0bGU6ICdjdXN0b20gZGF0ZScsXG4gICAgfSlcbiAgICBjdXN0b21EYXRlOiB1aS5maWVsZHMuRGF0ZTtcblxuICAgIHByaXZhdGUgX2Rpc2FibGVQYWdlKCk6IHZvaWQge1xuICAgICAgICB0aGlzLm5leHRCdXR0b24uaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLnBpY2tCdXR0b24uaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLnNob3J0YWdlQnV0dG9uLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgdGhpcy5jaG9vc2VTdG9ja0J1dHRvbi5pc0hpZGRlbiA9IHRydWU7XG4gICAgICAgIHRoaXMucXVhbnRpdHlQaWNrZWQuaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLnF1YW50aXR5VG9QaWNrLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQuaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQuaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLmxvY2F0aW9uLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgdGhpcy5sb3QuaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLnN1YmxvdC5pc0hpZGRlbiA9IHRydWU7XG4gICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC5pc0hpZGRlbiA9IHRydWU7XG4gICAgICAgIHRoaXMucGFja2luZ1VuaXQuaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgdGhpcy5zdGF0dXMuaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLmRlc3RpbmF0aW9uTG9jYXRpb24uaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLmxpY2Vuc2VQbGF0ZU51bWJlci5pc0hpZGRlbiA9IHRydWU7XG4gICAgICAgIHRoaXMuaWRlbnRpZmllcjEuaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICB0aGlzLmlkZW50aWZpZXIyLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgdGhpcy4kLmZpbmlzaCgpO1xuICAgIH1cblxuICAgIC8qXG4gICAgICogIEluaXQgZnVuY3Rpb25zXG4gICAgICovXG5cbiAgICBwcml2YXRlIGFzeW5jIF9pbml0KCkge1xuICAgICAgICAvKlxuICAgICAgICAgKiBSZXRyaWV2ZSBzdG9yYWdlIHBhcmFtZXRlcnNcbiAgICAgICAgICovXG5cbiAgICAgICAgdGhpcy5waWNrVGlja2V0LnZhbHVlID0gdGhpcy4kLnN0b3JhZ2UuZ2V0KE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmUuUElDS19USUNLRVRfS0VZKS50b1N0cmluZygpO1xuICAgICAgICB0aGlzLnBpY2tUaWNrZXRMaW5lLnZhbHVlID0gdGhpcy4kLnN0b3JhZ2VcbiAgICAgICAgICAgIC5nZXQoTW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZS5QSUNLX1RJQ0tFVF9MSU5FX0tFWSlcbiAgICAgICAgICAgIC50b1N0cmluZygpO1xuICAgICAgICB0aGlzLmRlc3RpbmF0aW9uTG9jYXRpb24uaXNIaWRkZW4gPVxuICAgICAgICAgICAgdGhpcy4kLnN0b3JhZ2UuZ2V0KE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmUuREVTVElOQVRJT05fRElTUExBWV9LRVkpLnRvU3RyaW5nKCkgPT09ICcwJ1xuICAgICAgICAgICAgICAgID8gdHJ1ZVxuICAgICAgICAgICAgICAgIDogZmFsc2U7XG4gICAgICAgIHRoaXMuZGVzdGluYXRpb25Mb2NhdGlvbi52YWx1ZSA9IHtcbiAgICAgICAgICAgIGNvZGU6IHRoaXMuJC5zdG9yYWdlLmdldChNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lLkRFU1RJTkFUSU9OX0tFWSkudG9TdHJpbmcoKSxcbiAgICAgICAgfTtcbiAgICAgICAgdGhpcy5zdG9ja1NpdGUudmFsdWUgPSB0aGlzLiQuc3RvcmFnZS5nZXQoJ21vYmlsZS1zZWxlY3RlZC1zdG9jay1zaXRlJykudG9TdHJpbmcoKTtcbiAgICAgICAgdGhpcy5waWNrTGlzdC52YWx1ZSA9IHRoaXMuJC5zdG9yYWdlLmdldChNb2JpbGVQaWNrVGlja2V0Vmlld1BpY2tUaWNrZXRMaW5lLlBJQ0tfTElTVF9LRVkpLnRvU3RyaW5nKCk7XG4gICAgICAgIHRoaXMudHJhbnNhY3Rpb24udmFsdWUgPSB0aGlzLiQuc3RvcmFnZS5nZXQoTW9iaWxlUGlja1RpY2tldFZpZXdQaWNrVGlja2V0TGluZS5UUkFOU0FDVElPTl9LRVkpLnRvU3RyaW5nKCk7XG4gICAgICAgIHRoaXMuX21vYmlsZVNldHRpbmdzID0gSlNPTi5wYXJzZSh0aGlzLiQucXVlcnlQYXJhbWV0ZXJzPy5tb2JpbGVTZXR0aW5ncyBhcyBzdHJpbmcpO1xuICAgICAgICB0aGlzLl9hbGxQaWNrcyA9IFtdO1xuICAgICAgICB0aGlzLmNvbmZpcm1lZFBpY2tzID0gMDtcbiAgICAgICAgdGhpcy5xdWFudGl0eVRvUGljay52YWx1ZSA9IDA7XG4gICAgICAgIHRoaXMucXVhbnRpdHlQaWNrZWQudmFsdWUgPSAwO1xuICAgICAgICB0aGlzLmN1cnJlbnRQaWNrID0gMDtcbiAgICAgICAgdGhpcy5udW1iZXJPZlBpY2tzID0gMDtcbiAgICAgICAgdGhpcy5uZXdQaWNrID0gZmFsc2U7XG4gICAgICAgIHRoaXMuX3VuaXRzT2ZNZWFzdXJlID0gW107XG4gICAgICAgIHRoaXMuc3RhdHVzLm9wdGlvbnMgPSBhd2FpdCB0aGlzLl9nZXRTdG9ja1N0YXR1cygpO1xuICAgICAgICBpZiAodGhpcy5waWNrVGlja2V0LnZhbHVlKSB7XG4gICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuX2luaXRUaWNrZXRMaW5lKCk7IC8vIHBvcHVsYXRlIGFycmF5IG9mIHBpY2tzXG4gICAgICAgICAgICB9IGNhdGNoIChlKSB7XG4gICAgICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihlKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBpZiAodGhpcy5fYWxsUGlja3MubGVuZ3RoID09PSAwKSB7XG4gICAgICAgICAgICBhd2FpdCBkaWFsb2dNZXNzYWdlKFxuICAgICAgICAgICAgICAgIHRoaXMsXG4gICAgICAgICAgICAgICAgJ2Vycm9yJyxcbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svZGlhbG9nLWVycm9yLXRpdGxlJywgJ0Vycm9yJyksXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1lcnJvci1waWNrLXRpY2tldC1uby1waWNrcycsICdObyBwaWNrIGxpc3QgdG8gcHJvY2Vzcy4nKSxcbiAgICAgICAgICAgICk7XG4gICAgICAgICAgICB0aGlzLiQuZmluaXNoKCk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICB0cnkge1xuICAgICAgICAgICAgICAgIHRoaXMucGFja2luZ1VuaXQub3B0aW9ucyA9IGF3YWl0IHRoaXMuX2luaXRVbml0cygpO1xuICAgICAgICAgICAgfSBjYXRjaCAoZSkge1xuICAgICAgICAgICAgICAgIHVpLmNvbnNvbGUuZXJyb3IoZSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAvKlxuICAgICAqIExvYWQgQWxsIHRoZSBQaWNrcyBiYXNlZCBvbiB0aGUgUGljayBUaWNrZXQgTGluZVxuICAgICAqL1xuICAgIHByaXZhdGUgYXN5bmMgX2luaXRUaWNrZXRMaW5lKCkge1xuICAgICAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgLm5vZGUoJ0BzYWdlL3gzLXN0b2NrL1BpY2tUaWNrZXRMaW5lJylcbiAgICAgICAgICAgIC5xdWVyeShcbiAgICAgICAgICAgICAgICB1aS5xdWVyeVV0aWxzLmVkZ2VzU2VsZWN0b3IoXG4gICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHBpY2tUaWNrZXQ6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBwaWNrVGlja2V0TGluZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHByb2R1Y3Q6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxvY2FsaXplZERlc2NyaXB0aW9uMTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb3RNYW5hZ2VtZW50TW9kZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBzZXJpYWxOdW1iZXJNYW5hZ2VtZW50TW9kZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICBxdWFudGl0eUluU3RvY2tVbml0OiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgc3RvY2tVbml0OiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBudW1iZXJPZkRlY2ltYWxzOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgcGFja2luZ1VuaXQ6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIG51bWJlck9mRGVjaW1hbHM6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgYWxsb2NhdGVkUXVhbnRpdHk6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBzaG9ydGFnZVF1YW50aXR5OiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgYWRjUGlja2VkTGluZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGFsbG9jYXRlZExpbmVzOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcXVlcnk6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZWRnZXM6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG5vZGU6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBzdG9ja0lkOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHF1YW50aXR5SW5TdG9ja1VuaXQ6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgc2VyaWFsTnVtYmVyOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGFsbG9jYXRpb25UeXBlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHN0b2NrTGluZToge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb3Q6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHN0YXR1czogeyBjb2RlOiB0cnVlIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHN1YmxvdDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgc2VyaWFsTnVtYmVyOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb2NhdGlvbjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcXVhbnRpdHlJblBhY2tpbmdVbml0OiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBxdWFudGl0eUluU3RvY2tVbml0OiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3RvcjogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcGFja2luZ1VuaXQ6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxpY2Vuc2VQbGF0ZU51bWJlcjogeyBjb2RlOiB0cnVlIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlkZW50aWZpZXIxOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZGVudGlmaWVyMjogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgX19hcmdzOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBmaXJzdDogNTAwLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgc291cmNlUGlja1RpY2tldFR5cGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBzb3VyY2VQaWNrVGlja2V0OiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgc291cmNlUGlja1RpY2tldExpbmU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBzb3VyY2VQaWNrVGlja2V0U2VxdWVuY2VOdW1iZXI6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBzb3VyY2VQaWNrVGlja2V0U3ViY29udHJhY3RUeXBlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgc3ViY29udHJhY3RSZW9yZGVyTG9jYXRpb246IHRydWUsXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGZpbHRlcjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHBpY2tUaWNrZXQ6IHsgX2VxOiB0aGlzLnBpY2tUaWNrZXQudmFsdWUgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBwaWNrVGlja2V0TGluZTogTnVtYmVyKHRoaXMucGlja1RpY2tldExpbmUudmFsdWUpLFxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgKVxuICAgICAgICAgICAgLmV4ZWN1dGUoKTtcblxuICAgICAgICBpZiAoIXJlc3BvbnNlLmVkZ2VzIHx8IHJlc3BvbnNlLmVkZ2VzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9ub3RpZmljYXRpb24tZXJyb3Itbm8tcGljay10aWNrZXQtbGluZScsICdQaWNrIHRpY2tldCBsaW5lIGRvZXMgbm90IGV4aXN0JyksXG4gICAgICAgICAgICApO1xuICAgICAgICB9XG5cbiAgICAgICAgLypcbiAgICAgICAgICogQ2FwdHVyZSBhbGwgdGhlIHBpY2tzIGZvciB0aGUgcGljayB0aWNrZXQgbGluZVxuICAgICAgICAgKi9cbiAgICAgICAgbGV0IGRldGFpbGVkID0gMDtcbiAgICAgICAgY29uc3QgdGlja2V0TGluZSA9IHJlc3BvbnNlLmVkZ2VzWzBdO1xuICAgICAgICB0aGlzLnByb2R1Y3QudmFsdWUgPSB0aWNrZXRMaW5lLm5vZGUucHJvZHVjdC5jb2RlO1xuICAgICAgICB0aGlzLmxvY2FsaXplZERlc2NyaXB0aW9uMS52YWx1ZSA9IHRpY2tldExpbmUubm9kZS5wcm9kdWN0LmxvY2FsaXplZERlc2NyaXB0aW9uMTtcbiAgICAgICAgdGhpcy5zdG9ja1VuaXQudmFsdWUgPSB0aWNrZXRMaW5lLm5vZGUuc3RvY2tVbml0LmNvZGU7XG4gICAgICAgIHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnNjYWxlID0gdGlja2V0TGluZS5ub2RlLnBhY2tpbmdVbml0Lm51bWJlck9mRGVjaW1hbHM7XG4gICAgICAgIHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC5zY2FsZSA9IHRpY2tldExpbmUubm9kZS5zdG9ja1VuaXQubnVtYmVyT2ZEZWNpbWFscztcbiAgICAgICAgdGhpcy5kaXNwbGF5UXVhbnRpdHlUb0JlUGlja2VkLnZhbHVlID1cbiAgICAgICAgICAgIE51bWJlcih0aWNrZXRMaW5lLm5vZGUucXVhbnRpdHlJblN0b2NrVW5pdCkudG9GaXhlZCh0aWNrZXRMaW5lLm5vZGUuc3RvY2tVbml0Lm51bWJlck9mRGVjaW1hbHMpICtcbiAgICAgICAgICAgICcgJyArXG4gICAgICAgICAgICB0aGlzLnN0b2NrVW5pdC52YWx1ZTtcbiAgICAgICAgdGhpcy50ZXh0UXVhbnRpdHlUb0JlUGlja2VkLnZhbHVlID0gdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL3F1YW50aXR5VG9QaWNrJywgJ1F1YW50aXR5IHRvIHBpY2s6ICcpO1xuICAgICAgICB0aGlzLmRpc3BsYXlRdWFudGl0eVBpY2tlZC52YWx1ZSA9XG4gICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svcGlja2VkUXVhbnRpdHknLCAnUGlja2VkIHF1YW50aXR5OiAnKSArXG4gICAgICAgICAgICBOdW1iZXIodGhpcy5xdWFudGl0eVBpY2tlZC52YWx1ZSkudG9GaXhlZCh0aWNrZXRMaW5lLm5vZGUuc3RvY2tVbml0Lm51bWJlck9mRGVjaW1hbHMpICtcbiAgICAgICAgICAgICcgJyArXG4gICAgICAgICAgICB0aGlzLnN0b2NrVW5pdC52YWx1ZTtcbiAgICAgICAgdGhpcy5zb3VyY2VQaWNrVGlja2V0VHlwZS52YWx1ZSA9IHRpY2tldExpbmUubm9kZS5zb3VyY2VQaWNrVGlja2V0VHlwZTtcbiAgICAgICAgdGhpcy5zb3VyY2VQaWNrVGlja2V0LnZhbHVlID0gdGlja2V0TGluZS5ub2RlLnNvdXJjZVBpY2tUaWNrZXQ7XG4gICAgICAgIHRoaXMuc291cmNlUGlja1RpY2tldExpbmUudmFsdWUgPSB0aWNrZXRMaW5lLm5vZGUuc291cmNlUGlja1RpY2tldExpbmU7XG4gICAgICAgIHRoaXMuc291cmNlUGlja1RpY2tldFNlcXVlbmNlTnVtYmVyLnZhbHVlID0gdGlja2V0TGluZS5ub2RlLnNvdXJjZVBpY2tUaWNrZXRTZXF1ZW5jZU51bWJlcjtcbiAgICAgICAgdGhpcy5zb3VyY2VQaWNrVGlja2V0U3ViY29udHJhY3RUeXBlLnZhbHVlID0gdGlja2V0TGluZS5ub2RlLnNvdXJjZVBpY2tUaWNrZXRTdWJjb250cmFjdFR5cGU7XG4gICAgICAgIHRoaXMuc3ViY29udHJhY3RSZW9yZGVyTG9jYXRpb24udmFsdWUgPSB0aWNrZXRMaW5lLm5vZGUuc3ViY29udHJhY3RSZW9yZGVyTG9jYXRpb247XG5cbiAgICAgICAgYXdhaXQgdGhpcy5fcmVhZFByb2R1Y3REYXRhKHRpY2tldExpbmUubm9kZS5wcm9kdWN0LmNvZGUpO1xuXG4gICAgICAgIGlmICh0aGlzLl9wcm9kdWN0LnN0b2NrTWFuYWdlbWVudE1vZGUgPT09ICdub3RNYW5hZ2VkJykge1xuICAgICAgICAgICAgdGhpcy5fbG90TWFuYWdlbWVudE1vZGUgPSB0aGlzLl9wcm9kdWN0LmxvdE1hbmFnZW1lbnRNb2RlO1xuICAgICAgICAgICAgdGhpcy5fc2VyaWFsTnVtYmVyTWFuYWdlbWVudE1vZGUgPSB0aGlzLl9wcm9kdWN0LnNlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlO1xuICAgICAgICAgICAgdGhpcy5faXNMb2NhdGlvbk1hbmFnZWQgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMuX3N0b2NrTWFuYWdlbWVudE1vZGUgPSB0aGlzLl9wcm9kdWN0LnN0b2NrTWFuYWdlbWVudE1vZGU7XG4gICAgICAgICAgICB0aGlzLl9pc0xpY2Vuc2VQbGF0ZU51bWJlck1hbmFnZWQgPSBmYWxzZTtcbiAgICAgICAgICAgIHRoaXMuX2lzTmVnYXRpdmVTdG9ja0F1dGhvcml6ZWQgPSB0aGlzLl9wcm9kdWN0LmlzTmVnYXRpdmVTdG9ja0F1dGhvcml6ZWQ7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBhd2FpdCB0aGlzLl9yZWFkUHJvZHVjdFNpdGVEYXRhKHRpY2tldExpbmUubm9kZS5wcm9kdWN0LmNvZGUpO1xuICAgICAgICAgICAgdGhpcy5fbG90TWFuYWdlbWVudE1vZGUgPSB0aGlzLl9wcm9kdWN0U2l0ZS5wcm9kdWN0LmxvdE1hbmFnZW1lbnRNb2RlO1xuICAgICAgICAgICAgdGhpcy5fc2VyaWFsTnVtYmVyTWFuYWdlbWVudE1vZGUgPSB0aGlzLl9wcm9kdWN0U2l0ZS5wcm9kdWN0LnNlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlO1xuICAgICAgICAgICAgdGhpcy5faXNMb2NhdGlvbk1hbmFnZWQgPSB0aGlzLl9wcm9kdWN0U2l0ZS5pc0xvY2F0aW9uTWFuYWdlZDtcbiAgICAgICAgICAgIHRoaXMuX3N0b2NrTWFuYWdlbWVudE1vZGUgPSB0aGlzLl9wcm9kdWN0U2l0ZS5wcm9kdWN0LnN0b2NrTWFuYWdlbWVudE1vZGU7XG4gICAgICAgICAgICB0aGlzLl9pc0xpY2Vuc2VQbGF0ZU51bWJlck1hbmFnZWQgPSB0aGlzLl9wcm9kdWN0U2l0ZS5pc0xpY2Vuc2VQbGF0ZU51bWJlck1hbmFnZWQ7XG4gICAgICAgICAgICB0aGlzLl9pc05lZ2F0aXZlU3RvY2tBdXRob3JpemVkID0gdGhpcy5fcHJvZHVjdFNpdGUucHJvZHVjdC5pc05lZ2F0aXZlU3RvY2tBdXRob3JpemVkO1xuICAgICAgICB9XG4gICAgICAgIHRoaXMucXVhbnRpdHlUb1BpY2sudmFsdWUgPSBOdW1iZXIodGlja2V0TGluZS5ub2RlLnF1YW50aXR5SW5TdG9ja1VuaXQpO1xuXG4gICAgICAgIC8qXG4gICAgICAgICAqIExvb3AgdGhyb3VnaCB0aGUgYWxsb2NhdGlvbnMgZm9yIHRoaXMgdGlja2V0IGxpbmUgYW5kIHBvcHVsYXRlIHRoZSBwaWNrcyBhcnJheVxuICAgICAgICAgKlxuICAgICAgICAgKi9cbiAgICAgICAgZm9yIChjb25zdCBsaW5lQWxsb2NhdGlvbnMgb2YgdGlja2V0TGluZS5ub2RlLmFsbG9jYXRlZExpbmVzLnF1ZXJ5LmVkZ2VzKSB7XG4gICAgICAgICAgICBpZiAoU3RyaW5nKGxpbmVBbGxvY2F0aW9ucy5ub2RlLmFsbG9jYXRpb25UeXBlKSAhPSAnc2hvcnRhZ2VzRGV0YWlsZWQnKSB7XG4gICAgICAgICAgICAgICAgZGV0YWlsZWQgPSBsaW5lQWxsb2NhdGlvbnMubm9kZS5zdG9ja0xpbmUgPyAxIDogMDtcbiAgICAgICAgICAgICAgICB0aGlzLl9hbGxQaWNrcy5wdXNoKHtcbiAgICAgICAgICAgICAgICAgICAgYWRjUGlja2VkTGluZTogdGlja2V0TGluZS5ub2RlLmFkY1BpY2tlZExpbmUsXG4gICAgICAgICAgICAgICAgICAgIGRldGFpbGVkQWxsb2NhdGlvbjogZGV0YWlsZWQsXG4gICAgICAgICAgICAgICAgICAgIGFsbG9jYXRlZFF1YW50aXR5OiBOdW1iZXIodGlja2V0TGluZS5ub2RlLmFsbG9jYXRlZFF1YW50aXR5KSxcbiAgICAgICAgICAgICAgICAgICAgc2hvcnRhZ2VRdWFudGl0eTogTnVtYmVyKHRpY2tldExpbmUubm9kZS5zaG9ydGFnZVF1YW50aXR5KSxcbiAgICAgICAgICAgICAgICAgICAgcXVhbnRpdHlJblN0b2NrVW5pdDogZGV0YWlsZWRcbiAgICAgICAgICAgICAgICAgICAgICAgID8gTnVtYmVyKGxpbmVBbGxvY2F0aW9ucy5ub2RlLnF1YW50aXR5SW5TdG9ja1VuaXQpXG4gICAgICAgICAgICAgICAgICAgICAgICA6IE51bWJlcih0aWNrZXRMaW5lLm5vZGUucXVhbnRpdHlJblN0b2NrVW5pdCksXG4gICAgICAgICAgICAgICAgICAgIHN0b2NrSWQ6IE51bWJlcihsaW5lQWxsb2NhdGlvbnMubm9kZS5zdG9ja0lkKSxcbiAgICAgICAgICAgICAgICAgICAgcGFja2luZ1VuaXQ6IGRldGFpbGVkXG4gICAgICAgICAgICAgICAgICAgICAgICA/IGxpbmVBbGxvY2F0aW9ucy5ub2RlLnN0b2NrTGluZS5wYWNraW5nVW5pdC5jb2RlXG4gICAgICAgICAgICAgICAgICAgICAgICA6IHRpY2tldExpbmUubm9kZS5zdG9ja1VuaXQuY29kZSxcbiAgICAgICAgICAgICAgICAgICAgcGFja2luZ1VuaXRDb2RlOiBkZXRhaWxlZFxuICAgICAgICAgICAgICAgICAgICAgICAgPyBsaW5lQWxsb2NhdGlvbnMubm9kZS5zdG9ja0xpbmUucGFja2luZ1VuaXQuY29kZVxuICAgICAgICAgICAgICAgICAgICAgICAgOiB0aWNrZXRMaW5lLm5vZGUuc3RvY2tVbml0LmNvZGUsXG4gICAgICAgICAgICAgICAgICAgIHBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yOiBkZXRhaWxlZFxuICAgICAgICAgICAgICAgICAgICAgICAgPyBOdW1iZXIobGluZUFsbG9jYXRpb25zLm5vZGUuc3RvY2tMaW5lLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yKVxuICAgICAgICAgICAgICAgICAgICAgICAgOiAxLFxuICAgICAgICAgICAgICAgICAgICBxdWFudGl0eUluUGFja2luZ1VuaXQ6IGRldGFpbGVkXG4gICAgICAgICAgICAgICAgICAgICAgICA/IE51bWJlci5wYXJzZUZsb2F0KFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgTnVtYmVyKFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIE51bWJlcihsaW5lQWxsb2NhdGlvbnMubm9kZS5xdWFudGl0eUluU3RvY2tVbml0KSAvXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIE51bWJlcihsaW5lQWxsb2NhdGlvbnMubm9kZS5zdG9ja0xpbmUucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IpLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgKS50b0ZpeGVkKHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnNjYWxlKSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgKVxuICAgICAgICAgICAgICAgICAgICAgICAgOiBOdW1iZXIodGlja2V0TGluZS5ub2RlLnF1YW50aXR5SW5TdG9ja1VuaXQpLFxuICAgICAgICAgICAgICAgICAgICBsb3Q6IGRldGFpbGVkID8gbGluZUFsbG9jYXRpb25zLm5vZGUuc3RvY2tMaW5lLmxvdCA6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgIHN1YmxvdDogZGV0YWlsZWQgPyBsaW5lQWxsb2NhdGlvbnMubm9kZS5zdG9ja0xpbmUuc3VibG90IDogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgc2VyaWFsTnVtYmVyOiBkZXRhaWxlZFxuICAgICAgICAgICAgICAgICAgICAgICAgPyB0aGlzLl9zZXJpYWxOdW1iZXJNYW5hZ2VtZW50TW9kZSA9PT0gJ2dsb2JhbFJlY2VpdmVkSXNzdWVkJ1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgID8gbGluZUFsbG9jYXRpb25zLm5vZGUuc2VyaWFsTnVtYmVyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgOiBsaW5lQWxsb2NhdGlvbnMubm9kZS5zdG9ja0xpbmUuc2VyaWFsTnVtYmVyXG4gICAgICAgICAgICAgICAgICAgICAgICA6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgIHN0YXR1czogZGV0YWlsZWQgPyBsaW5lQWxsb2NhdGlvbnMubm9kZS5zdG9ja0xpbmUuc3RhdHVzPy5jb2RlIDogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgbG9jYXRpb246XG4gICAgICAgICAgICAgICAgICAgICAgICBkZXRhaWxlZCAmJiBsaW5lQWxsb2NhdGlvbnMubm9kZS5zdG9ja0xpbmUubG9jYXRpb25cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA/IGxpbmVBbGxvY2F0aW9ucy5ub2RlLnN0b2NrTGluZS5sb2NhdGlvbj8uY29kZVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDogbnVsbCxcbiAgICAgICAgICAgICAgICAgICAgY29uZmlybWVkOiAwLFxuICAgICAgICAgICAgICAgICAgICBsaWNlbnNlUGxhdGVOdW1iZXI6IGRldGFpbGVkID8gbGluZUFsbG9jYXRpb25zLm5vZGUuc3RvY2tMaW5lLmxpY2Vuc2VQbGF0ZU51bWJlcj8uY29kZSA6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgIGlkZW50aWZpZXIxOiBkZXRhaWxlZCA/IGxpbmVBbGxvY2F0aW9ucy5ub2RlLnN0b2NrTGluZS5pZGVudGlmaWVyMSA6IG51bGwsXG4gICAgICAgICAgICAgICAgICAgIGlkZW50aWZpZXIyOiBkZXRhaWxlZCA/IGxpbmVBbGxvY2F0aW9ucy5ub2RlLnN0b2NrTGluZS5pZGVudGlmaWVyMiA6IG51bGwsXG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgdGhpcy5udW1iZXJPZlBpY2tzICs9IDE7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHRoaXMubnVtYmVyT2ZQaWNrcyA9PT0gMCkge1xuICAgICAgICAgICAgdGhpcy5fYWxsUGlja3MucHVzaCh7XG4gICAgICAgICAgICAgICAgYWRjUGlja2VkTGluZTogdGlja2V0TGluZS5ub2RlLmFkY1BpY2tlZExpbmUsXG4gICAgICAgICAgICAgICAgZGV0YWlsZWRBbGxvY2F0aW9uOiAwLFxuICAgICAgICAgICAgICAgIGFsbG9jYXRlZFF1YW50aXR5OiBOdW1iZXIodGlja2V0TGluZS5ub2RlLmFsbG9jYXRlZFF1YW50aXR5KSxcbiAgICAgICAgICAgICAgICBzaG9ydGFnZVF1YW50aXR5OiBOdW1iZXIodGlja2V0TGluZS5ub2RlLnNob3J0YWdlUXVhbnRpdHkpLFxuICAgICAgICAgICAgICAgIHF1YW50aXR5SW5TdG9ja1VuaXQ6IE51bWJlcih0aWNrZXRMaW5lLm5vZGUucXVhbnRpdHlJblN0b2NrVW5pdCksXG4gICAgICAgICAgICAgICAgc3RvY2tJZDogMCxcbiAgICAgICAgICAgICAgICBwYWNraW5nVW5pdDogdGlja2V0TGluZS5ub2RlLnN0b2NrVW5pdD8uY29kZSxcbiAgICAgICAgICAgICAgICBwYWNraW5nVW5pdENvZGU6IHRpY2tldExpbmUubm9kZS5zdG9ja1VuaXQ/LmNvZGUsXG4gICAgICAgICAgICAgICAgcGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I6IDEsXG4gICAgICAgICAgICAgICAgcXVhbnRpdHlJblBhY2tpbmdVbml0OiBOdW1iZXIodGlja2V0TGluZS5ub2RlLnF1YW50aXR5SW5TdG9ja1VuaXQpLFxuICAgICAgICAgICAgICAgIGxvdDogbnVsbCxcbiAgICAgICAgICAgICAgICBzdWJsb3Q6IG51bGwsXG4gICAgICAgICAgICAgICAgc2VyaWFsTnVtYmVyOiBudWxsLFxuICAgICAgICAgICAgICAgIHN0YXR1czogbnVsbCxcbiAgICAgICAgICAgICAgICBsb2NhdGlvbjogbnVsbCxcbiAgICAgICAgICAgICAgICBjb25maXJtZWQ6IDAsXG4gICAgICAgICAgICAgICAgbGljZW5zZVBsYXRlTnVtYmVyOiBudWxsLFxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB0aGlzLm51bWJlck9mUGlja3MgKz0gMTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIC8qXG4gICAgICogR2V0IGFsbCB0aGUgdW5pdHMgZm9yIHRoaXMgcHJvZHVjdFxuICAgICAqL1xuICAgIHByaXZhdGUgYXN5bmMgX2luaXRVbml0cygpOiBQcm9taXNlPHN0cmluZ1tdPiB7XG4gICAgICAgIHRoaXMuX3VuaXRzT2ZNZWFzdXJlLnB1c2goe1xuICAgICAgICAgICAgdW5pdDogdGhpcy5fcHJvZHVjdC5zdG9ja1VuaXQuY29kZSxcbiAgICAgICAgICAgIHVuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I6IDEsXG4gICAgICAgICAgICBudW1iZXJPZkRlY2ltYWxzOiB0aGlzLl9wcm9kdWN0LnN0b2NrVW5pdC5udW1iZXJPZkRlY2ltYWxzLFxuICAgICAgICAgICAgaXNQYWNraW5nRmFjdG9yRW50cnlBbGxvd2VkOiBmYWxzZSxcbiAgICAgICAgfSk7XG4gICAgICAgIHRoaXMucXVhbnRpdHlUb1BpY2suc2NhbGUgPVxuICAgICAgICAgICAgdGhpcy5xdWFudGl0eVBpY2tlZC5zY2FsZSA9XG4gICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQuc2NhbGUgPVxuICAgICAgICAgICAgICAgIHRoaXMuX3Byb2R1Y3Quc3RvY2tVbml0Lm51bWJlck9mRGVjaW1hbHM7XG4gICAgICAgIGZvciAoY29uc3QgcGFja1VuaXRzIG9mIHRoaXMuX3Byb2R1Y3QucGFja2luZ1VuaXRzLnF1ZXJ5LmVkZ2VzKSB7XG4gICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgcGFja1VuaXRzLm5vZGUucGFja2luZ1VuaXQgJiZcbiAgICAgICAgICAgICAgICB0aGlzLl91bml0c09mTWVhc3VyZS5maWx0ZXIodW5pdCA9PiB1bml0LnVuaXQgPT0gcGFja1VuaXRzLm5vZGUucGFja2luZ1VuaXQuY29kZSkubGVuZ3RoID09IDBcbiAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICAgIHRoaXMuX3VuaXRzT2ZNZWFzdXJlLnB1c2goe1xuICAgICAgICAgICAgICAgICAgICB1bml0OiBwYWNrVW5pdHMubm9kZS5wYWNraW5nVW5pdC5jb2RlLFxuICAgICAgICAgICAgICAgICAgICB1bml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yOiBOdW1iZXIocGFja1VuaXRzLm5vZGUucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IpLFxuICAgICAgICAgICAgICAgICAgICBudW1iZXJPZkRlY2ltYWxzOiBwYWNrVW5pdHMubm9kZS5wYWNraW5nVW5pdC5udW1iZXJPZkRlY2ltYWxzLFxuICAgICAgICAgICAgICAgICAgICBpc1BhY2tpbmdGYWN0b3JFbnRyeUFsbG93ZWQ6IHRydWUsXG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHRoaXMucGFja2luZ1VuaXQudmFsdWUgPT09IHRoaXMuc3RvY2tVbml0LnZhbHVlKSB7XG4gICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC5zY2FsZSA9IHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC5zY2FsZTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIGxldCB1bml0UG9zaXRpb24gPSB0aGlzLl91bml0c09mTWVhc3VyZVxuICAgICAgICAgICAgICAgIC5tYXAoZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGUudW5pdDtcbiAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgICAgIC5pbmRleE9mKHRoaXMucGFja2luZ1VuaXQudmFsdWUpO1xuICAgICAgICAgICAgaWYgKHVuaXRQb3NpdGlvbiAhPT0gLTEpIHtcbiAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC5zY2FsZSA9IHRoaXMuX3VuaXRzT2ZNZWFzdXJlW3VuaXRQb3NpdGlvbl0ubnVtYmVyT2ZEZWNpbWFscztcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIHJldHVybiB0aGlzLl91bml0c09mTWVhc3VyZS5tYXAoKHRoZVVuaXRzOiBhbnkpID0+IHtcbiAgICAgICAgICAgIHJldHVybiB0aGVVbml0cy51bml0O1xuICAgICAgICB9KTtcbiAgICB9XG5cbiAgICAvKlxuICAgICAqIE1vdmUgdG8gdGhlIG5leHQgdW5jb25maXJtZWQgcGljayBpbiB0aGUgcGljayBhcnJheVxuICAgICAqL1xuICAgIHByaXZhdGUgYXN5bmMgX25leHRQaWNrKCk6IFByb21pc2U8dm9pZD4ge1xuICAgICAgICBsZXQgc3RhcnRpbmdQb3NpdGlvbiA9IHRoaXMuY3VycmVudFBpY2s7XG4gICAgICAgIGxldCBsb29rRm9yUGlja3MgPSB0cnVlO1xuICAgICAgICB3aGlsZSAobG9va0ZvclBpY2tzKSB7XG4gICAgICAgICAgICBpZiAodGhpcy5fYWxsUGlja3MubGVuZ3RoIC0gMSA+IHRoaXMuY3VycmVudFBpY2spIHtcbiAgICAgICAgICAgICAgICB0aGlzLmN1cnJlbnRQaWNrICs9IDE7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIHRoaXMuY3VycmVudFBpY2sgPSAwO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLmNvbmZpcm1lZCA9PT0gMCkge1xuICAgICAgICAgICAgICAgIGxvb2tGb3JQaWNrcyA9IGZhbHNlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMuY3VycmVudFBpY2sgPT09IHN0YXJ0aW5nUG9zaXRpb24pIHtcbiAgICAgICAgICAgICAgICBsb29rRm9yUGlja3MgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICB0aGlzLm5leHRCdXR0b24uaXNEaXNhYmxlZCA9IHRydWU7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgYXdhaXQgdGhpcy5fZGlzcGxheVBpY2soKTtcbiAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQuZm9jdXMoKTtcbiAgICB9XG5cbiAgICAvKlxuICAgICAqIElmIHRoZXkgaGF2ZW4ndCBwaWNrZWQgdGhlIGZ1bGwgcXVhbnRpdHkgd2UgbmVlZCB0byBjcmVhdGUgYSBuZXcgcGlja1xuICAgICAqIGZvciB0aGVtIHRvIGZpbmlzaCBvciB0byBpbml0aWF0ZSBhIHNob3J0YWdlXG4gICAgICovXG4gICAgcHJpdmF0ZSBfY3JlYXRlTmV3UGljayhuZXdRdWFudGl0eTogbnVtYmVyKSB7XG4gICAgICAgIHRoaXMuX2FsbFBpY2tzLnB1c2goe1xuICAgICAgICAgICAgYWRjUGlja2VkTGluZTogMCxcbiAgICAgICAgICAgIGRldGFpbGVkQWxsb2NhdGlvbjogMCxcbiAgICAgICAgICAgIGFsbG9jYXRlZFF1YW50aXR5OiAwLFxuICAgICAgICAgICAgc2hvcnRhZ2VRdWFudGl0eTogMCxcbiAgICAgICAgICAgIHN0b2NrVW5pdDogdGhpcy5zdG9ja1VuaXQudmFsdWUsXG4gICAgICAgICAgICBzdG9ja0lkOiAwLFxuICAgICAgICAgICAgcGFja2luZ1VuaXQ6IHRoaXMuc3RvY2tVbml0LnZhbHVlLFxuICAgICAgICAgICAgcGFja2luZ1VuaXRDb2RlOiB0aGlzLnN0b2NrVW5pdC52YWx1ZSxcbiAgICAgICAgICAgIHBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yOiAxLFxuICAgICAgICAgICAgcXVhbnRpdHlJblN0b2NrVW5pdDogTnVtYmVyLnBhcnNlRmxvYXQobmV3UXVhbnRpdHkudG9GaXhlZCh0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQuc2NhbGUpKSxcbiAgICAgICAgICAgIHF1YW50aXR5SW5QYWNraW5nVW5pdDogTnVtYmVyLnBhcnNlRmxvYXQobmV3UXVhbnRpdHkudG9GaXhlZCh0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQuc2NhbGUpKSxcbiAgICAgICAgICAgIGxvdDogbnVsbCxcbiAgICAgICAgICAgIHN1YmxvdDogbnVsbCxcbiAgICAgICAgICAgIHNlcmlhbE51bWJlcjogbnVsbCxcbiAgICAgICAgICAgIHN0YXR1czogbnVsbCxcbiAgICAgICAgICAgIGxvY2F0aW9uOiBudWxsLFxuICAgICAgICAgICAgY29uZmlybWVkOiAwLFxuICAgICAgICAgICAgbGljZW5zZVBsYXRlTnVtYmVyOiBudWxsLFxuICAgICAgICB9KTtcbiAgICAgICAgdGhpcy5udW1iZXJPZlBpY2tzICs9IDE7XG4gICAgICAgIHRoaXMubmV3UGljayA9IHRydWU7XG4gICAgICAgIHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnNjYWxlID0gdGhpcy5xdWFudGl0eUluU3RvY2tVbml0LnNjYWxlO1xuICAgICAgICB0aGlzLl9jb21wdXRlUXVhbnRpdHlNYXgoKTtcbiAgICB9XG5cbiAgICBwcml2YXRlIF9jb21wdXRlUXVhbnRpdHlNYXgoKSB7XG4gICAgICAgIHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC5tYXggPSB0aGlzLnF1YW50aXR5VG9QaWNrLnZhbHVlIC0gdGhpcy5xdWFudGl0eVBpY2tlZC52YWx1ZTtcbiAgICAgICAgaWYgKHRoaXMucGFja2luZ1VuaXQudmFsdWUgPT09IHRoaXMuc3RvY2tVbml0LnZhbHVlKSB7XG4gICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC5tYXggPSB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQubWF4O1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgbGV0IHVucm91bmRlZE1heCA9IHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC5tYXggLyB0aGlzLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLnZhbHVlO1xuICAgICAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQubWF4ID0gTnVtYmVyLnBhcnNlRmxvYXQodW5yb3VuZGVkTWF4LnRvRml4ZWQodGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQuc2NhbGUpKTtcbiAgICAgICAgfVxuICAgIH1cbiAgICAvKlxuICAgICAqIERpc3BsYXkgY3VycmVudCBwaWNrIG9uIHRoZSBwYWdlIChkaXNhYmxpbmcvaGlkaW5nIHdoZW4gYXBwcm9wcmlhdGUpXG4gICAgICovXG4gICAgcHJpdmF0ZSBhc3luYyBfZGlzcGxheVBpY2soKTogUHJvbWlzZTx2b2lkPiB7XG4gICAgICAgIC8vIHJlc2V0IG9sZCB2YWx1ZXMgWDMtMjY5NzcxXG4gICAgICAgIHRoaXMubG9jYXRpb24udmFsdWUgPSBudWxsO1xuICAgICAgICB0aGlzLnBhY2tpbmdVbml0LnZhbHVlID0gbnVsbDtcbiAgICAgICAgdGhpcy5jdXJyZW50UGFja2luZ1VuaXRDb2RlLnZhbHVlID0gbnVsbDtcbiAgICAgICAgdGhpcy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSA9IG51bGw7XG4gICAgICAgIHRoaXMubG90LnZhbHVlID0gbnVsbDtcbiAgICAgICAgdGhpcy5zdWJsb3QudmFsdWUgPSBudWxsO1xuICAgICAgICBpZiAodGhpcy5fc2VyaWFsTnVtYmVyTWFuYWdlbWVudE1vZGUgPT09ICdyZWNlaXZlZElzc3VlZCcpIHtcbiAgICAgICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQudmFsdWUgPSBudWxsO1xuICAgICAgICB9IGVsc2UgaWYgKHRoaXMuX3NlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlID09PSAnZ2xvYmFsUmVjZWl2ZWRJc3N1ZWQnKSB7XG4gICAgICAgICAgICB0aGlzLnNlcmlhbE51bWJlci52YWx1ZSA9IG51bGw7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5zdGF0dXMudmFsdWUgPSBudWxsO1xuICAgICAgICB0aGlzLmlkZW50aWZpZXIxLnZhbHVlID0gbnVsbDtcbiAgICAgICAgdGhpcy5pZGVudGlmaWVyMi52YWx1ZSA9IG51bGw7XG4gICAgICAgIGF3YWl0IHRoaXMuJC5jb21taXRWYWx1ZUFuZFByb3BlcnR5Q2hhbmdlcygpO1xuICAgICAgICAvL1xuICAgICAgICBjb25zdCBjdXJyZW50UGljayA9IHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdO1xuICAgICAgICB0aGlzLmxvY2F0aW9uLnZhbHVlID0gY3VycmVudFBpY2subG9jYXRpb24gPyB7IGNvZGU6IGN1cnJlbnRQaWNrLmxvY2F0aW9uIH0gOiBudWxsO1xuICAgICAgICB0aGlzLnBhY2tpbmdVbml0LmlzUmVhZE9ubHkgPSBmYWxzZTtcbiAgICAgICAgdGhpcy5wYWNraW5nVW5pdC52YWx1ZSA9IHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLnBhY2tpbmdVbml0O1xuICAgICAgICB0aGlzLmN1cnJlbnRQYWNraW5nVW5pdENvZGUudmFsdWUgPSB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5wYWNraW5nVW5pdENvZGU7XG4gICAgICAgIHRoaXMucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWUgPVxuICAgICAgICAgICAgdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10ucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I7XG5cbiAgICAgICAgdGhpcy5xdWFudGl0eUluU3RvY2tVbml0LnZhbHVlID0gdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10ucXVhbnRpdHlJblN0b2NrVW5pdDtcbiAgICAgICAgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgPSB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5xdWFudGl0eUluUGFja2luZ1VuaXQ7XG4gICAgICAgIHRoaXMubG90LnZhbHVlID0gdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10ubG90ID8geyBsb3Q6IHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLmxvdCB9IDogbnVsbDtcbiAgICAgICAgdGhpcy5zdWJsb3QudmFsdWUgPSB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5zdWJsb3RcbiAgICAgICAgICAgID8geyBzdWJsb3Q6IHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLnN1YmxvdCB9XG4gICAgICAgICAgICA6IG51bGw7XG4gICAgICAgIGlmICh0aGlzLl9zZXJpYWxOdW1iZXJNYW5hZ2VtZW50TW9kZSA9PT0gJ3JlY2VpdmVkSXNzdWVkJykge1xuICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC52YWx1ZSA9IHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLnNlcmlhbE51bWJlclxuICAgICAgICAgICAgICAgID8geyBzZXJpYWxOdW1iZXI6IHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLnNlcmlhbE51bWJlciB9XG4gICAgICAgICAgICAgICAgOiBudWxsO1xuICAgICAgICB9IGVsc2UgaWYgKHRoaXMuX3NlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlID09PSAnZ2xvYmFsUmVjZWl2ZWRJc3N1ZWQnKSB7XG4gICAgICAgICAgICB0aGlzLnNlcmlhbE51bWJlci52YWx1ZSA9IHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLnNlcmlhbE51bWJlclxuICAgICAgICAgICAgICAgID8geyBjb2RlOiB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5zZXJpYWxOdW1iZXIgfVxuICAgICAgICAgICAgICAgIDogbnVsbDtcbiAgICAgICAgfVxuICAgICAgICBpZiAodGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10uc3RhdHVzKSB7XG4gICAgICAgICAgICB2YXIgaW5kZXggPSB0aGlzLnN0YXR1cy5vcHRpb25zLmluZGV4T2YodGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10uc3RhdHVzKTtcbiAgICAgICAgICAgIGlmIChpbmRleCA+PSAwKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5zdGF0dXMudmFsdWUgPSB0aGlzLnN0YXR1cy5vcHRpb25zW2luZGV4XTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBpZiAoIXRoaXMucGFja2luZ1VuaXQudmFsdWUpIHtcbiAgICAgICAgICAgIHRoaXMucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWUgPSAxO1xuICAgICAgICAgICAgdGhpcy5wYWNraW5nVW5pdC52YWx1ZSA9IHRoaXMuc3RvY2tVbml0LnZhbHVlO1xuICAgICAgICB9XG4gICAgICAgIHRoaXMubGljZW5zZVBsYXRlTnVtYmVyLnZhbHVlID0gdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10ubGljZW5zZVBsYXRlTnVtYmVyO1xuICAgICAgICB0aGlzLmlkZW50aWZpZXIxLnZhbHVlID0gdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10uaWRlbnRpZmllcjE7XG4gICAgICAgIHRoaXMuaWRlbnRpZmllcjIudmFsdWUgPSB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5pZGVudGlmaWVyMjtcbiAgICAgICAgdGhpcy5zaG9ydGFnZUJ1dHRvbi5pc0Rpc2FibGVkID0gdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgIT09IDA7XG4gICAgICAgIGF3YWl0IHRoaXMuJC5jb21taXRWYWx1ZUFuZFByb3BlcnR5Q2hhbmdlcygpO1xuICAgICAgICBpZiAodGhpcy5fc3RvY2tNYW5hZ2VtZW50TW9kZSA9PT0gJ25vdE1hbmFnZWQnKSB7XG4gICAgICAgICAgICB0aGlzLmxvY2F0aW9uLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgICAgIHRoaXMuZGVzdGluYXRpb25Mb2NhdGlvbi5pc0hpZGRlbiA9IHRydWU7XG4gICAgICAgICAgICB0aGlzLmxvdC5pc0hpZGRlbiA9IHRydWU7XG4gICAgICAgICAgICB0aGlzLnN1YmxvdC5pc0hpZGRlbiA9IHRydWU7XG4gICAgICAgICAgICB0aGlzLnNlcmlhbE51bWJlci5pc0hpZGRlbiA9IHRydWU7XG4gICAgICAgICAgICB0aGlzLnNlcmlhbE51bWJlclJlY2VpdmVkLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgICAgIHRoaXMuc3RhdHVzLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgICAgIHRoaXMubGljZW5zZVBsYXRlTnVtYmVyLmlzSGlkZGVuID0gdHJ1ZTtcbiAgICAgICAgICAgIHRoaXMuaWRlbnRpZmllcjEuaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICAgICAgdGhpcy5pZGVudGlmaWVyMi5pc0hpZGRlbiA9IHRydWU7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBpZiAoY3VycmVudFBpY2suZGV0YWlsZWRBbGxvY2F0aW9uID09PSAxKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5sb3QuaXNSZWFkT25seSA9IHRydWU7XG4gICAgICAgICAgICAgICAgdGhpcy5zdWJsb3QuaXNSZWFkT25seSA9IHRydWU7XG4gICAgICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXIuaXNSZWFkT25seSA9IHRydWU7XG4gICAgICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC5pc1JlYWRPbmx5ID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICB0aGlzLnN0YXR1cy5pc1JlYWRPbmx5ID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICB0aGlzLmxvY2F0aW9uLmlzUmVhZE9ubHkgPSB0cnVlO1xuICAgICAgICAgICAgICAgIHRoaXMucGFja2luZ1VuaXQuaXNSZWFkT25seSA9IHRydWU7XG4gICAgICAgICAgICAgICAgdGhpcy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci5pc1JlYWRPbmx5ID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICB0aGlzLmlkZW50aWZpZXIxLmlzUmVhZE9ubHkgPSB0cnVlO1xuICAgICAgICAgICAgICAgIHRoaXMuaWRlbnRpZmllcjIuaXNSZWFkT25seSA9IHRydWU7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIHRoaXMubG90LmlzUmVhZE9ubHkgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICB0aGlzLnN1YmxvdC5pc1JlYWRPbmx5ID0gZmFsc2U7XG4gICAgICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXIuaXNSZWFkT25seSA9IGZhbHNlO1xuICAgICAgICAgICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQuaXNSZWFkT25seSA9IGZhbHNlO1xuICAgICAgICAgICAgICAgIHRoaXMuc3RhdHVzLmlzUmVhZE9ubHkgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICB0aGlzLmxvY2F0aW9uLmlzUmVhZE9ubHkgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICB0aGlzLnBhY2tpbmdVbml0LmlzUmVhZE9ubHkgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICB0aGlzLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLmlzRGlzYWJsZWQgPVxuICAgICAgICAgICAgICAgICAgICB0aGlzLnBhY2tpbmdVbml0LnZhbHVlID09PSB0aGlzLnN0b2NrVW5pdC52YWx1ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHRoaXMubG90LmlzSGlkZGVuID0gdGhpcy5fbG90TWFuYWdlbWVudE1vZGUgPT09ICdub3RNYW5hZ2VkJztcbiAgICAgICAgICAgIHRoaXMuc3VibG90LmlzSGlkZGVuID1cbiAgICAgICAgICAgICAgICB0aGlzLl9sb3RNYW5hZ2VtZW50TW9kZSA9PT0gJ25vdE1hbmFnZWQnIHx8XG4gICAgICAgICAgICAgICAgdGhpcy5fbG90TWFuYWdlbWVudE1vZGUgPT09ICdvcHRpb25hbExvdCcgfHxcbiAgICAgICAgICAgICAgICB0aGlzLl9sb3RNYW5hZ2VtZW50TW9kZSA9PT0gJ21hbmRhdG9yeUxvdCc7XG4gICAgICAgICAgICB0aGlzLmxvdC5pc01hbmRhdG9yeSA9XG4gICAgICAgICAgICAgICAgdGhpcy5fbG90TWFuYWdlbWVudE1vZGUgPT09ICdtYW5kYXRvcnlMb3QnIHx8IHRoaXMuX2xvdE1hbmFnZW1lbnRNb2RlID09PSAnbG90QW5kU3VibG90JztcbiAgICAgICAgICAgIHRoaXMuc3VibG90LmlzTWFuZGF0b3J5ID0gdGhpcy5sb3QuaXNNYW5kYXRvcnk7XG4gICAgICAgICAgICB0aGlzLnNlcmlhbE51bWJlci5pc0hpZGRlbiA9XG4gICAgICAgICAgICAgICAgdGhpcy5fc2VyaWFsTnVtYmVyTWFuYWdlbWVudE1vZGUgPT09ICdub3RNYW5hZ2VkJyB8fFxuICAgICAgICAgICAgICAgIHRoaXMuX3NlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlID09PSAnaXNzdWVkJyB8fFxuICAgICAgICAgICAgICAgIHRoaXMuX3NlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlID09PSAncmVjZWl2ZWRJc3N1ZWQnO1xuICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC5pc0hpZGRlbiA9XG4gICAgICAgICAgICAgICAgdGhpcy5fc2VyaWFsTnVtYmVyTWFuYWdlbWVudE1vZGUgPT09ICdub3RNYW5hZ2VkJyB8fFxuICAgICAgICAgICAgICAgIHRoaXMuX3NlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlID09PSAnaXNzdWVkJyB8fFxuICAgICAgICAgICAgICAgIHRoaXMuX3NlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlID09PSAnZ2xvYmFsUmVjZWl2ZWRJc3N1ZWQnO1xuICAgICAgICAgICAgdGhpcy5sb2NhdGlvbi5pc0hpZGRlbiA9ICF0aGlzLl9pc0xvY2F0aW9uTWFuYWdlZDtcbiAgICAgICAgICAgIHRoaXMubGljZW5zZVBsYXRlTnVtYmVyLmlzSGlkZGVuID0gIShcbiAgICAgICAgICAgICAgICBjdXJyZW50UGljay5kZXRhaWxlZEFsbG9jYXRpb24gPT09IDEgJiYgdGhpcy5faXNMaWNlbnNlUGxhdGVOdW1iZXJNYW5hZ2VkXG4gICAgICAgICAgICApO1xuICAgICAgICAgICAgdGhpcy5pZGVudGlmaWVyMS5pc0hpZGRlbiA9ICEoY3VycmVudFBpY2suZGV0YWlsZWRBbGxvY2F0aW9uID09PSAxICYmIHRoaXMuaWRlbnRpZmllcjEudmFsdWUpO1xuICAgICAgICAgICAgdGhpcy5pZGVudGlmaWVyMi5pc0hpZGRlbiA9ICEoY3VycmVudFBpY2suZGV0YWlsZWRBbGxvY2F0aW9uID09PSAxICYmIHRoaXMuaWRlbnRpZmllcjIudmFsdWUpO1xuICAgICAgICB9XG4gICAgICAgIGlmICh0aGlzLmNvbmZpcm1lZFBpY2tzICsgMSA9PT0gdGhpcy5udW1iZXJPZlBpY2tzKSB7XG4gICAgICAgICAgICB0aGlzLm5leHRCdXR0b24uaXNEaXNhYmxlZCA9IHRydWU7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5fY29tcHV0ZVF1YW50aXR5TWF4KCk7XG4gICAgfVxuXG4gICAgLypcbiAgICAgKiBDb3B5IHBhZ2UgdmFsdWVzIHRvIHRoZSBQaWNrIGFycmF5XG4gICAgICovXG4gICAgcHJpdmF0ZSBfdXBkYXRlUGlja0Zyb21QYWdlKCkge1xuICAgICAgICB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5sb2NhdGlvbiA9IHRoaXMubG9jYXRpb24udmFsdWUgPyB0aGlzLmxvY2F0aW9uLnZhbHVlLmNvZGUgOiBudWxsO1xuICAgICAgICB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5sb3QgPSB0aGlzLmxvdC52YWx1ZSA/IHRoaXMubG90LnZhbHVlLmxvdCA6IG51bGw7XG4gICAgICAgIHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLnN1YmxvdCA9IHRoaXMuc3VibG90LnZhbHVlID8gdGhpcy5zdWJsb3QudmFsdWUuc3VibG90IDogbnVsbDtcbiAgICAgICAgaWYgKHRoaXMuX3NlcmlhbE51bWJlck1hbmFnZW1lbnRNb2RlID09PSAnZ2xvYmFsUmVjZWl2ZWRJc3N1ZWQnKSB7XG4gICAgICAgICAgICB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5zZXJpYWxOdW1iZXIgPSB0aGlzLnNlcmlhbE51bWJlci52YWx1ZVxuICAgICAgICAgICAgICAgID8gdGhpcy5zZXJpYWxOdW1iZXIudmFsdWUuY29kZVxuICAgICAgICAgICAgICAgIDogbnVsbDtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLnNlcmlhbE51bWJlciA9IHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQudmFsdWVcbiAgICAgICAgICAgICAgICA/IHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQudmFsdWUuc2VyaWFsTnVtYmVyXG4gICAgICAgICAgICAgICAgOiBudWxsO1xuICAgICAgICB9XG4gICAgICAgIHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLnN0YXR1cyA9IHRoaXMuc3RhdHVzLnZhbHVlO1xuICAgICAgICB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5xdWFudGl0eUluU3RvY2tVbml0ID0gdGhpcy5xdWFudGl0eUluU3RvY2tVbml0LnZhbHVlO1xuICAgICAgICB0aGlzLl9hbGxQaWNrc1t0aGlzLmN1cnJlbnRQaWNrXS5wYWNraW5nVW5pdENvZGUgPSB0aGlzLmN1cnJlbnRQYWNraW5nVW5pdENvZGUudmFsdWU7XG4gICAgICAgIHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLnBhY2tpbmdVbml0ID0gdGhpcy5wYWNraW5nVW5pdC52YWx1ZTtcbiAgICAgICAgdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10ucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IgPVxuICAgICAgICAgICAgdGhpcy5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZTtcbiAgICAgICAgdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10ucXVhbnRpdHlJblBhY2tpbmdVbml0ID0gdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWU7XG4gICAgICAgIHRoaXMuX2FsbFBpY2tzW3RoaXMuY3VycmVudFBpY2tdLmlkZW50aWZpZXIxID0gdGhpcy5pZGVudGlmaWVyMS52YWx1ZTtcbiAgICAgICAgdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10uaWRlbnRpZmllcjIgPSB0aGlzLmlkZW50aWZpZXIyLnZhbHVlO1xuICAgIH1cblxuICAgIC8qXG4gICAgICogUmVhZCB0aGUgc3RvY2sgbm9kZSB0byBlbnN1cmUgdGhlcmUgaXMgc29tZSBpbnZlbnRvcnkgZm9yIHRoZSBlbnRlcmVkIGRldGFpbHNcbiAgICAgKi9cbiAgICBwcml2YXRlIGFzeW5jIF92YWxpZGF0ZVN0b2NrKHBhZ2VGaWVsZDogc3RyaW5nLCBzdG9ja0lkPzogbnVtYmVyKTogUHJvbWlzZTxib29sZWFuIHwgRXJyb3I+IHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIGNvbnN0IHN0b2NrRmlsdGVyOiBhbnkgPSB7XG4gICAgICAgICAgICAgICAgc3RvY2tTaXRlOiB0aGlzLnN0b2NrU2l0ZS52YWx1ZSxcbiAgICAgICAgICAgICAgICBwcm9kdWN0OiB0aGlzLnByb2R1Y3QudmFsdWUsXG4gICAgICAgICAgICB9O1xuICAgICAgICAgICAgaWYgKHN0b2NrSWQgJiYgc3RvY2tJZCA+IDApIHtcbiAgICAgICAgICAgICAgICBzdG9ja0ZpbHRlci5zdG9ja0lkID0gc3RvY2tJZDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh0aGlzLmxvY2F0aW9uLnZhbHVlICYmIHRoaXMubG9jYXRpb24udmFsdWUuY29kZSkge1xuICAgICAgICAgICAgICAgIHN0b2NrRmlsdGVyLmxvY2F0aW9uID0gdGhpcy5sb2NhdGlvbi52YWx1ZS5jb2RlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMuc3RhdHVzLnZhbHVlKSB7XG4gICAgICAgICAgICAgICAgc3RvY2tGaWx0ZXIuc3RhdHVzID0gdGhpcy5zdGF0dXMudmFsdWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAodGhpcy5sb3QudmFsdWUgJiYgdGhpcy5sb3QudmFsdWUubG90KSB7XG4gICAgICAgICAgICAgICAgc3RvY2tGaWx0ZXIubG90ID0gdGhpcy5sb3QudmFsdWUubG90O1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMuc3VibG90LnZhbHVlICYmIHRoaXMuc3VibG90LnZhbHVlLnN1YmxvdCkge1xuICAgICAgICAgICAgICAgIHN0b2NrRmlsdGVyLnN1YmxvdCA9IHRoaXMuc3VibG90LnZhbHVlLnN1YmxvdDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh0aGlzLnNlcmlhbE51bWJlclJlY2VpdmVkLnZhbHVlICYmIHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQudmFsdWUuc2VyaWFsTnVtYmVyKSB7XG4gICAgICAgICAgICAgICAgc3RvY2tGaWx0ZXIuc2VyaWFsTnVtYmVyID0gdGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC52YWx1ZS5zZXJpYWxOdW1iZXI7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGNvbnN0IHJlc3VsdCA9IGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgICAgIC5ub2RlKCdAc2FnZS94My1zdG9jay1kYXRhL1N0b2NrJylcbiAgICAgICAgICAgICAgICAucXVlcnkoXG4gICAgICAgICAgICAgICAgICAgIHVpLnF1ZXJ5VXRpbHMuZWRnZXNTZWxlY3RvcihcbiAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBwcm9kdWN0OiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHByb2R1Y3Q6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBwYWNraW5nVW5pdDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgc3RhdHVzOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb2NhdGlvbjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbG90OiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHN1YmxvdDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBzZXJpYWxOdW1iZXI6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgaWRlbnRpZmllcjE6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgaWRlbnRpZmllcjI6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZpbHRlcjogc3RvY2tGaWx0ZXIsXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgICAgIClcbiAgICAgICAgICAgICAgICAuZXhlY3V0ZSgpO1xuICAgICAgICAgICAgaWYgKHJlc3VsdC5lZGdlcy5sZW5ndGggPT09IDApIHtcbiAgICAgICAgICAgICAgICBpZiAocGFnZUZpZWxkID09PSB0aGlzLmxvY2F0aW9uLnRpdGxlKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMubG9jYXRpb24udmFsdWUuY29kZSA9IG51bGw7XG4gICAgICAgICAgICAgICAgfSBlbHNlIGlmIChwYWdlRmllbGQgPT09IHRoaXMuc3RhdHVzLnRpdGxlKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuc3RhdHVzLnZhbHVlID0gbnVsbDtcbiAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKHBhZ2VGaWVsZCA9PT0gdGhpcy5sb3QudGl0bGUpIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5sb3QudmFsdWUubG90ID0gbnVsbDtcbiAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKHBhZ2VGaWVsZCA9PT0gdGhpcy5zdWJsb3QudGl0bGUpIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5zdWJsb3QudmFsdWUuc3VibG90ID0gbnVsbDtcbiAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKHBhZ2VGaWVsZCA9PT0gdGhpcy5zZXJpYWxOdW1iZXIudGl0bGUgJiYgc3RvY2tJZCAmJiBzdG9ja0lkID4gMCkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLnNlcmlhbE51bWJlci52YWx1ZS5jb2RlID0gbnVsbDtcbiAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKHBhZ2VGaWVsZCA9PT0gdGhpcy5zZXJpYWxOdW1iZXIudGl0bGUpIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC52YWx1ZS5zZXJpYWxOdW1iZXIgPSBudWxsO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB0aGlzLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgICAgICAgICAgdGhpcy4kLnNob3dUb2FzdChcbiAgICAgICAgICAgICAgICAgICAgdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1lcnJvci1zdG9jay1hdmFpbGFiaWxpdHknLCAnTm8gc3RvY2sgbWF0Y2hpbmcgdGhlIGVudHJ5JyksXG4gICAgICAgICAgICAgICAgICAgIHsgdHlwZTogJ2Vycm9yJyB9LFxuICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgIHJlc3VsdC5lZGdlcy5sZW5ndGggPT09IDEgJiZcbiAgICAgICAgICAgICAgICAocGFnZUZpZWxkID09PSB0aGlzLmxvdC50aXRsZSB8fFxuICAgICAgICAgICAgICAgICAgICBwYWdlRmllbGQgPT09IHRoaXMuc3VibG90LnRpdGxlIHx8XG4gICAgICAgICAgICAgICAgICAgIHBhZ2VGaWVsZCA9PT0gdGhpcy5zZXJpYWxOdW1iZXIudGl0bGUpXG4gICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICBpZiAodGhpcy5zdGF0dXMudmFsdWUgPT09IG51bGwpIHtcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5zdGF0dXMudmFsdWUgPSByZXN1bHQuZWRnZXNbMF0ubm9kZS5zdGF0dXM/LmNvZGU7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGlmICh0aGlzLmxvY2F0aW9uLnZhbHVlID09PSBudWxsIHx8IHRoaXMubG9jYXRpb24udmFsdWUuY29kZSA9PT0gbnVsbCkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLmxvY2F0aW9uLnZhbHVlID0geyBjb2RlOiByZXN1bHQuZWRnZXNbMF0ubm9kZS5sb2NhdGlvbj8uY29kZSB9O1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBpZiAodGhpcy5zdWJsb3QudmFsdWUgPT09IG51bGwgfHwgdGhpcy5zdWJsb3QudmFsdWUuc3VibG90ID09PSBudWxsKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuc3VibG90LnZhbHVlID0geyBzdWJsb3Q6IHJlc3VsdC5lZGdlc1swXS5ub2RlLnN1YmxvdCB9O1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBpZiAodGhpcy5sb3QudmFsdWUgPT09IG51bGwgfHwgdGhpcy5sb3QudmFsdWUubG90ID09PSBudWxsKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMubG90LnZhbHVlID0geyBsb3Q6IHJlc3VsdC5lZGdlc1swXS5ub2RlLmxvdCB9O1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB0aGlzLmlkZW50aWZpZXIxLnZhbHVlID0gcmVzdWx0LmVkZ2VzWzBdLm5vZGUuaWRlbnRpZmllcjE7XG4gICAgICAgICAgICAgICAgdGhpcy5pZGVudGlmaWVyMi52YWx1ZSA9IHJlc3VsdC5lZGdlc1swXS5ub2RlLmlkZW50aWZpZXIyO1xuXG4gICAgICAgICAgICAgICAgYXdhaXQgdGhpcy4kLmNvbW1pdFZhbHVlQW5kUHJvcGVydHlDaGFuZ2VzKCk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfSBjYXRjaCAoZSkge1xuICAgICAgICAgICAgYXdhaXQgZGlhbG9nTWVzc2FnZShcbiAgICAgICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgICAgICdlcnJvcicsXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1lcnJvci10aXRsZScsICdFcnJvcicpLFxuICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctZXJyb3ItcmVhZGluZy1zdG9jaycsICdSZWFkaW5nIHN0b2NrIHJlY29yZDogJykgKyBTdHJpbmcoZSksXG4gICAgICAgICAgICApO1xuICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLypcbiAgICAgKiBSZWFkIHRoZSBzdG9jayBub2RlIHRvIGVuc3VyZSB0aGVyZSBpcyBzb21lIGludmVudG9yeSBmb3IgdGhlIGVudGVyZWQgZGV0YWlsc1xuICAgICAqL1xuICAgIHByaXZhdGUgYXN5bmMgX2NoZWNrU3RvY2tRdWFudGl0eShzdG9ja0lkPzogbnVtYmVyKTogUHJvbWlzZTxib29sZWFuIHwgRXJyb3I+IHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIGNvbnN0IHN0b2NrRmlsdGVyOiBhbnkgPSB7XG4gICAgICAgICAgICAgICAgc3RvY2tTaXRlOiB0aGlzLnN0b2NrU2l0ZS52YWx1ZSxcbiAgICAgICAgICAgICAgICBwcm9kdWN0OiB0aGlzLnByb2R1Y3QudmFsdWUsXG4gICAgICAgICAgICB9O1xuICAgICAgICAgICAgaWYgKHN0b2NrSWQpIHtcbiAgICAgICAgICAgICAgICBzdG9ja0ZpbHRlci5zdG9ja0lkID0gc3RvY2tJZDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh0aGlzLmxvY2F0aW9uLnZhbHVlICYmIHRoaXMubG9jYXRpb24udmFsdWUuY29kZSkge1xuICAgICAgICAgICAgICAgIHN0b2NrRmlsdGVyLmxvY2F0aW9uID0gdGhpcy5sb2NhdGlvbi52YWx1ZS5jb2RlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMuc3RhdHVzLnZhbHVlKSB7XG4gICAgICAgICAgICAgICAgc3RvY2tGaWx0ZXIuc3RhdHVzID0gdGhpcy5zdGF0dXMudmFsdWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAodGhpcy5sb3QudmFsdWUgJiYgdGhpcy5sb3QudmFsdWUubG90KSB7XG4gICAgICAgICAgICAgICAgc3RvY2tGaWx0ZXIubG90ID0gdGhpcy5sb3QudmFsdWUubG90O1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHRoaXMuc3VibG90LnZhbHVlICYmIHRoaXMuc3VibG90LnZhbHVlLnN1YmxvdCkge1xuICAgICAgICAgICAgICAgIHN0b2NrRmlsdGVyLnN1YmxvdCA9IHRoaXMuc3VibG90LnZhbHVlLnN1YmxvdDtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmICh0aGlzLnNlcmlhbE51bWJlclJlY2VpdmVkLnZhbHVlICYmIHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQudmFsdWUuc2VyaWFsTnVtYmVyKSB7XG4gICAgICAgICAgICAgICAgc3RvY2tGaWx0ZXIuc2VyaWFsTnVtYmVyID0gdGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC52YWx1ZS5zZXJpYWxOdW1iZXI7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGNvbnN0IHJlc3VsdCA9IGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgICAgIC5ub2RlKCdAc2FnZS94My1zdG9jay1kYXRhL1N0b2NrJylcbiAgICAgICAgICAgICAgICAuYWdncmVnYXRlLnF1ZXJ5KFxuICAgICAgICAgICAgICAgICAgICBhZ2dyZWdhdGVFZGdlc1NlbGVjdG9yPFN0b2NrLCBBZ2dyZWdhdGVHcm91cFNlbGVjdG9yPFN0b2NrPiwgQWdncmVnYXRlVmFsdWVzU2VsZWN0b3I8U3RvY2s+PihcbiAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBncm91cDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwcm9kdWN0OiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwcm9kdWN0OiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZToge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBfYnk6ICd2YWx1ZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YWx1ZXM6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcXVhbnRpdHlJblN0b2NrVW5pdDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbWluOiBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG1heDogZmFsc2UsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBzdW06IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBhdmc6IGZhbHNlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZGlzdGluY3RDb3VudDogZmFsc2UsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZmlsdGVyOiBzdG9ja0ZpbHRlcixcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgKVxuICAgICAgICAgICAgICAgIC5leGVjdXRlKCk7XG4gICAgICAgICAgICBpZiAocmVzdWx0LmVkZ2VzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgICAgIH0gZWxzZSBpZiAoXG4gICAgICAgICAgICAgICAgdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10uZGV0YWlsZWRBbGxvY2F0aW9uID09PSAwICYmXG4gICAgICAgICAgICAgICAgdGhpcy5zZXJpYWxOdW1iZXJSZWNlaXZlZC52YWx1ZSAmJlxuICAgICAgICAgICAgICAgIHRoaXMuc2VyaWFsTnVtYmVyUmVjZWl2ZWQudmFsdWUuc2VyaWFsTnVtYmVyICYmXG4gICAgICAgICAgICAgICAgTnVtYmVyKHJlc3VsdC5lZGdlc1swXS5ub2RlLnZhbHVlcy5xdWFudGl0eUluU3RvY2tVbml0LnN1bSkgPiAwXG4gICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgICAgIH0gZWxzZSBpZiAoTnVtYmVyKHJlc3VsdC5lZGdlc1swXS5ub2RlLnZhbHVlcy5xdWFudGl0eUluU3RvY2tVbml0LnN1bSkgPCB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQudmFsdWUpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfSBjYXRjaCAoZSkge1xuICAgICAgICAgICAgYXdhaXQgZGlhbG9nTWVzc2FnZShcbiAgICAgICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgICAgICdlcnJvcicsXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1lcnJvci10aXRsZScsICdFcnJvcicpLFxuICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctZXJyb3ItcmVhZGluZy1zdG9jaycsICdSZWFkaW5nIHN0b2NrIHJlY29yZDogJykgKyBTdHJpbmcoZSksXG4gICAgICAgICAgICApO1xuICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG4gICAgfVxuICAgIC8qXG4gICAgICogUmVhZCB0aGUgcHJvZHVjdCBzaXRlIG5vZGUgdG8gZ2V0IGNyaXRpY2FsIHBhcmFtZXRlcml6YXRpb25cbiAgICAgKi9cbiAgICBwcml2YXRlIGFzeW5jIF9yZWFkUHJvZHVjdFNpdGVEYXRhKHByb2R1Y3RDb2RlOiBzdHJpbmcpOiBQcm9taXNlPGFueSB8IEVycm9yPiB7XG4gICAgICAgIHRyeSB7XG4gICAgICAgICAgICBjb25zdCBwcm9kdWN0U2l0ZURhdGEgPSBhd2FpdCB0aGlzLiQuZ3JhcGhcbiAgICAgICAgICAgICAgICAubm9kZSgnQHNhZ2UveDMtbWFzdGVyLWRhdGEvUHJvZHVjdFNpdGUnKVxuICAgICAgICAgICAgICAgIC5yZWFkKFxuICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICBpc0xpY2Vuc2VQbGF0ZU51bWJlck1hbmFnZWQ6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBpc0xvY2F0aW9uTWFuYWdlZDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHN0b2NrU2l0ZToge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgcHJvZHVjdDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvZGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgc2VyaWFsTnVtYmVyTWFuYWdlbWVudE1vZGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9jYWxpemVkRGVzY3JpcHRpb24xOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxvdE1hbmFnZW1lbnRNb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHN0b2NrVW5pdDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBudW1iZXJPZkRlY2ltYWxzOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgaXNOZWdhdGl2ZVN0b2NrQXV0aG9yaXplZDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBwYWNraW5nVW5pdHM6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcXVlcnk6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVkZ2VzOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbm9kZToge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwYWNraW5nVW5pdDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG51bWJlck9mRGVjaW1hbHM6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpc1BhY2tpbmdGYWN0b3JFbnRyeUFsbG93ZWQ6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIGAke3Byb2R1Y3RDb2RlfXwke3RoaXMuc3RvY2tTaXRlLnZhbHVlfWAsXG4gICAgICAgICAgICAgICAgKVxuICAgICAgICAgICAgICAgIC5leGVjdXRlKCk7XG4gICAgICAgICAgICAvLyBJZiBhbiBlcnJvciBvY2N1cnJlZCBkdXJpbmcgdGhlIEFQSSBjYWxsXG4gICAgICAgICAgICBpZiAoIXByb2R1Y3RTaXRlRGF0YSkge1xuICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuX25vdGlmaWVyLnNob3dBbmRXYWl0KFxuICAgICAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1zdG9jay9wYWdlc19fYWRjX25vdGlmaWNhdGlvbl9faW52YWxpZF9wcm9kdWN0X3NpdGVfZXJyb3InLFxuICAgICAgICAgICAgICAgICAgICAgICAgYENvdWxkIG5vdCByZXRyaWV2ZSB5b3VyIHByb2R1Y3Qge3sgcHJvZHVjdENvZGUgfX0gZm9yIHRoZSBzaXRlIHt7IHNpdGVDb2RlIH19YCxcbiAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBwcm9kdWN0Q29kZTogdGhpcy5wcm9kdWN0LnZhbHVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHNpdGVDb2RlOiB0aGlzLnN0b2NrU2l0ZS52YWx1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgICAgICdlcnJvcicsXG4gICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgICAgICByZXR1cm4gdGhpcy4kLnJvdXRlci5nb1RvKCdAc2FnZS94My1zdG9jay9Nb2JpbGVQaWNrVGlja2V0Jyk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB0aGlzLl9wcm9kdWN0U2l0ZSA9IHByb2R1Y3RTaXRlRGF0YSBhcyBhbnk7XG4gICAgICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgICAgICAgIGF3YWl0IGRpYWxvZ01lc3NhZ2UoXG4gICAgICAgICAgICAgICAgdGhpcyxcbiAgICAgICAgICAgICAgICAnZXJyb3InLFxuICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctZXJyb3ItdGl0bGUnLCAnRXJyb3InKSxcbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svZGlhbG9nLWVycm9yLXJlYWRpbmctcHJvZHVjdC1zaXRlJywgJ3JlYWRpbmcgcHJvZHVjdCBzaXRlIHJlY29yZCcpICtcbiAgICAgICAgICAgICAgICAgICAgU3RyaW5nKGUpLFxuICAgICAgICAgICAgKTtcbiAgICAgICAgfVxuICAgIH1cbiAgICBwcml2YXRlIGFzeW5jIF9yZWFkUHJvZHVjdERhdGEocHJvZHVjdENvZGU6IHN0cmluZyk6IFByb21pc2U8YW55IHwgRXJyb3I+IHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgIGNvbnN0IHByb2R1Y3REYXRhID0gYXdhaXQgdGhpcy4kLmdyYXBoXG4gICAgICAgICAgICAgICAgLm5vZGUoJ0BzYWdlL3gzLW1hc3Rlci1kYXRhL1Byb2R1Y3QnKVxuICAgICAgICAgICAgICAgIC5yZWFkKFxuICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgc2VyaWFsTnVtYmVyTWFuYWdlbWVudE1vZGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBzdG9ja01hbmFnZW1lbnRNb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgbG9jYWxpemVkRGVzY3JpcHRpb24xOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgbG90TWFuYWdlbWVudE1vZGU6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBpc05lZ2F0aXZlU3RvY2tBdXRob3JpemVkOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgc3RvY2tVbml0OiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBudW1iZXJPZkRlY2ltYWxzOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHBhY2tpbmdVbml0czoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHF1ZXJ5OiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVkZ2VzOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBub2RlOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcGFja2luZ1VuaXQ6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29kZTogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbnVtYmVyT2ZEZWNpbWFsczogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlzUGFja2luZ0ZhY3RvckVudHJ5QWxsb3dlZDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIGAke3Byb2R1Y3RDb2RlfWAsXG4gICAgICAgICAgICAgICAgKVxuICAgICAgICAgICAgICAgIC5leGVjdXRlKCk7XG4gICAgICAgICAgICAvLyBJZiBhbiBlcnJvciBvY2N1cnJlZCBkdXJpbmcgdGhlIEFQSSBjYWxsXG4gICAgICAgICAgICBpZiAoIXByb2R1Y3REYXRhKSB7XG4gICAgICAgICAgICAgICAgYXdhaXQgdGhpcy5fbm90aWZpZXIuc2hvd0FuZFdhaXQoXG4gICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLXN0b2NrL3BhZ2VzX19hZGNfbm90aWZpY2F0aW9uX19pbnZhbGlkX3Byb2R1Y3RfZXJyb3InLFxuICAgICAgICAgICAgICAgICAgICAgICAgYENvdWxkIG5vdCByZXRyaWV2ZSB5b3VyIHByb2R1Y3Qge3sgcHJvZHVjdENvZGUgfX1gLFxuICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHByb2R1Y3RDb2RlOiB0aGlzLnByb2R1Y3QudmFsdWUsXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgICAgICAgICAnZXJyb3InLFxuICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHRoaXMuJC5yb3V0ZXIuZ29UbygnQHNhZ2UveDMtc3RvY2svTW9iaWxlUGlja1RpY2tldCcpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdGhpcy5fcHJvZHVjdCA9IHByb2R1Y3REYXRhIGFzIGFueTtcbiAgICAgICAgICAgIHRoaXMuX3VuaXRTdG9ja051bWJlck9mRGVjaW1hbHMgPSBwcm9kdWN0RGF0YS5zdG9ja1VuaXQubnVtYmVyT2ZEZWNpbWFscztcbiAgICAgICAgfSBjYXRjaCAoZSkge1xuICAgICAgICAgICAgYXdhaXQgZGlhbG9nTWVzc2FnZShcbiAgICAgICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgICAgICdlcnJvcicsXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1lcnJvci10aXRsZScsICdFcnJvcicpLFxuICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctZXJyb3ItcmVhZGluZy1wcm9kdWN0JywgJ3JlYWRpbmcgcHJvZHVjdCByZWNvcmQnKSArIFN0cmluZyhlKSxcbiAgICAgICAgICAgICk7XG4gICAgICAgIH1cbiAgICB9XG4gICAgcHJpdmF0ZSBhc3luYyBfZ2V0U3RvY2tTdGF0dXMoKTogUHJvbWlzZTxzdHJpbmdbXT4ge1xuICAgICAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgLy8gd2l0aCAncHJvdmlkZXMnIHByb3BlcnR5IGRlZmluZWQgaW4gYWNjZXNzQ29kZSBvZiB0aGlzIG5vZGUsIHNob3VsZCBhdXRvbWF0aWNhbGx5IHJldHVybiBvbmx5IHRyYW5zYWN0aW9ucyB0aGF0IGFyZSBhY2Nlc3NpYmxlIGZvciB0aGUgY3VycmVudCB1c2VyXG4gICAgICAgICAgICAubm9kZSgnQHNhZ2UveDMtc3RvY2stZGF0YS9TdG9ja1N0YXR1cycpXG4gICAgICAgICAgICAucXVlcnkoXG4gICAgICAgICAgICAgICAgdWkucXVlcnlVdGlscy5lZGdlc1NlbGVjdG9yKHtcbiAgICAgICAgICAgICAgICAgICAgX2lkOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgKVxuICAgICAgICAgICAgLmV4ZWN1dGUoKTtcblxuICAgICAgICBpZiAoIXJlc3BvbnNlLmVkZ2VzIHx8IHJlc3BvbnNlLmVkZ2VzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAnQHNhZ2UveDMtc3RvY2svcGFnZXNfX2FkY19taXNjZWxsYW5lb3VzX3JlY2VpcHRfZGV0YWlsc19fbm90aWZpY2F0aW9uX19pbnZhbGlkX3N0b2NrX3N0YXR1c19lcnJvcicsXG4gICAgICAgICAgICAgICAgICAgICdObyBzdG9jayBzdGF0dXMnLFxuICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICApO1xuICAgICAgICB9XG5cbiAgICAgICAgLy8gdHJhbnNmb3JtIFN0b2NrIHN0YXR1cyByZXNwb25zZSBpbnRvIGEgc3RyaW5nIGFycmF5XG4gICAgICAgIHJldHVybiByZXNwb25zZS5lZGdlcy5tYXAoKHN0b2NrU3RhdHVzOiBhbnkpID0+IHtcbiAgICAgICAgICAgIHJldHVybiBzdG9ja1N0YXR1cy5ub2RlLmNvZGU7XG4gICAgICAgIH0pO1xuICAgIH1cblxuICAgIHByaXZhdGUgYXN5bmMgX2dldFNob3J0YWdlKCk6IFByb21pc2U8Ym9vbGVhbj4ge1xuICAgICAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgLm5vZGUoJ0BzYWdlL3gzLXN0b2NrL1BpY2tUaWNrZXRMaW5lJylcbiAgICAgICAgICAgIC5hZ2dyZWdhdGUucmVhZChcbiAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgIF9pZDoge1xuICAgICAgICAgICAgICAgICAgICAgICAgZGlzdGluY3RDb3VudDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgZmlsdGVyOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwaWNrVGlja2V0OiB7IF9lcTogdGhpcy5waWNrVGlja2V0LnZhbHVlIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICBzaG9ydGFnZVF1YW50aXR5OiB7IF9uZTogJzAnIH0sXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIClcbiAgICAgICAgICAgIC5leGVjdXRlKCk7XG5cbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLl9pZD8uZGlzdGluY3RDb3VudCAhPT0gMDtcbiAgICB9XG5cbiAgICBwcml2YXRlIGFzeW5jIG9uU3VibWl0KGlzU2hvcnRhZ2U6IGJvb2xlYW4pIHtcbiAgICAgICAgaWYgKGlzU2hvcnRhZ2UpIHtcbiAgICAgICAgICAgIHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSA9IDA7XG4gICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5QYWNraW5nVW5pdC52YWx1ZSA9IDA7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoIWlzU2hvcnRhZ2UgJiYgKHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSA+IDAgfHwgdGhpcy5xdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgPiAwKSkge1xuICAgICAgICAgICAgLy8gcGVyZm9ybSBjbGllbnQtc2lkZSB2YWxpZGF0aW9uXG4gICAgICAgICAgICBpZiAoIShhd2FpdCB2YWxpZGF0ZVdpdGhEZXRhaWxzKHRoaXMpKSkgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgLypcbiAgICAgICAgICogQ2hlY2sgZm9yIG92ZXIgcGlja2luZ1xuICAgICAgICAgKi9cbiAgICAgICAgaWYgKFxuICAgICAgICAgICAgTnVtYmVyKHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSkgKyB0aGlzLnF1YW50aXR5UGlja2VkLnZhbHVlID4gdGhpcy5xdWFudGl0eVRvUGljay52YWx1ZSB8fFxuICAgICAgICAgICAgKHRoaXMucGFja2luZ1VuaXQudmFsdWUgPT09IHRoaXMuc3RvY2tVbml0LnZhbHVlICYmXG4gICAgICAgICAgICAgICAgTnVtYmVyKHRoaXMucXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlKSArIHRoaXMucXVhbnRpdHlQaWNrZWQudmFsdWUgPiB0aGlzLnF1YW50aXR5VG9QaWNrLnZhbHVlKVxuICAgICAgICApIHtcbiAgICAgICAgICAgIHRoaXMuJC5yZW1vdmVUb2FzdHMoKTtcbiAgICAgICAgICAgIGF3YWl0IHRoaXMuJC5zb3VuZC5lcnJvcigpO1xuICAgICAgICAgICAgdGhpcy4kLnNob3dUb2FzdChcbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svZGlhbG9nLWVycm9yLXF1YW50aXR5LXBpY2snLCAnUXVhbnRpdHkgZ3JlYXRlciB0aGFuIHF1YW50aXR5IHRvIGJlIHBpY2tlZCcpLFxuICAgICAgICAgICAgICAgIHsgdHlwZTogJ2Vycm9yJywgdGltZW91dDogNTAwMCB9LFxuICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIC8qXG4gICAgICAgICAqIENoZWNrIGZvciBcImVub3VnaFwiIGludmVudG9yeVxuICAgICAgICAgKi9cbiAgICAgICAgaWYgKFxuICAgICAgICAgICAgdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10uZGV0YWlsZWRBbGxvY2F0aW9uID09PSAwICYmXG4gICAgICAgICAgICB0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQudmFsdWUgPiAwICYmXG4gICAgICAgICAgICB0aGlzLl9zdG9ja01hbmFnZW1lbnRNb2RlICE9PSAnbm90TWFuYWdlZCdcbiAgICAgICAgKSB7XG4gICAgICAgICAgICBjb25zdCBlbm91Z2hTdG9jayA9IGF3YWl0IHRoaXMuX2NoZWNrU3RvY2tRdWFudGl0eShcbiAgICAgICAgICAgICAgICB0aGlzLnNlcmlhbE51bWJlci52YWx1ZSA/IHRoaXMuc2VyaWFsTnVtYmVyLnZhbHVlLnN0b2NrSWQgOiAwLFxuICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIGlmIChlbm91Z2hTdG9jayBpbnN0YW5jZW9mIEVycm9yIHx8ICFlbm91Z2hTdG9jaykge1xuICAgICAgICAgICAgICAgIHRoaXMuJC5yZW1vdmVUb2FzdHMoKTtcbiAgICAgICAgICAgICAgICBhd2FpdCB0aGlzLiQuc291bmQuZXJyb3IoKTtcbiAgICAgICAgICAgICAgICB0aGlzLiQuc2hvd1RvYXN0KFxuICAgICAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1zdG9jay9kaWFsb2ctZXJyb3ItaW5zdWZmaWNpZW50LXN0b2NrLXF1YW50aXR5JyxcbiAgICAgICAgICAgICAgICAgICAgICAgICdJbnN1ZmZpY2llbnQgc3RvY2sgbWF0Y2hpbmcgdGhlIGVudHJ5JyxcbiAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICAgICAgeyB0eXBlOiAnZXJyb3InLCB0aW1lb3V0OiA1MDAwIH0sXG4gICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLl91cGRhdGVQaWNrRnJvbVBhZ2UoKTsgLy8gVXBkYXRlIGFycmF5XG4gICAgICAgIHRoaXMuc2hvcnRQaWNrID0gZmFsc2U7XG5cbiAgICAgICAgLypcbiAgICAgICAgICogU3BlY2lhbCBjYXNlIHdoZXJlIGl0IGFwcGVhcnMgdGhleSB3YW50IHRvIHNob3J0IHBpY2tcbiAgICAgICAgICovXG4gICAgICAgIGlmIChpc1Nob3J0YWdlICYmIHRoaXMucXVhbnRpdHlQaWNrZWQudmFsdWUgPCB0aGlzLnF1YW50aXR5VG9QaWNrLnZhbHVlKSB7XG4gICAgICAgICAgICB0aGlzLnNob3J0UGljayA9IGF3YWl0IGRpYWxvZ0NvbmZpcm1hdGlvbihcbiAgICAgICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgICAgICdpbmZvJyxcbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svZGlhbG9nLWluZm9ybWF0aW9uLXRpdGxlJywgJ0luZm9ybWF0aW9uJyksXG4gICAgICAgICAgICAgICAgdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1jb25maXJtYXRpb24tcGljay10aWNrZXQtc2hvcnRhZ2UtbWVzc2FnZScsICdDcmVhdGUgYSBzaG9ydGFnZT8nKSxcbiAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgIGZ1bGxTY3JlZW46IHRydWUsXG4gICAgICAgICAgICAgICAgICAgIGFjY2VwdEJ1dHRvbjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgdGV4dDogdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2J1dHRvbi1hY2NlcHQteWVzJywgJ1llcycpLFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBjYW5jZWxCdXR0b246IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRleHQ6IHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9idXR0b24tY2FuY2VsLW5vJywgJ05vJyksXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICk7XG4gICAgICAgICAgICBpZiAoIXRoaXMuc2hvcnRQaWNrKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgaWYgKCF0aGlzLnNob3J0UGljaykge1xuICAgICAgICAgICAgdGhpcy5fYWxsUGlja3NbdGhpcy5jdXJyZW50UGlja10uY29uZmlybWVkID0gMTtcbiAgICAgICAgICAgIHRoaXMuY29uZmlybWVkUGlja3MgKz0gMTtcbiAgICAgICAgfVxuXG4gICAgICAgIC8qXG4gICAgICAgICAqIFNlZSBpZiBldmVuIGFmdGVyIHRoaXMgcGljayBpcyBjb25maXJtZWQgZG8gd2Ugc3RpbGwgaGF2ZSBtb3JlIHRvIHBpY2tcbiAgICAgICAgICogVGhlcmUgaXMgYSBzcGVjaWFsIGNhc2U6ICBTaG9ydCBwaWNrcyBjYW5ub3QgYmUgbWFkZSBkZWxpdmVyYWJsZSwgc28gZG9uJ3QgYXNrXG4gICAgICAgICAqL1xuICAgICAgICBpZiAoXG4gICAgICAgICAgICAhdGhpcy5zaG9ydFBpY2sgJiZcbiAgICAgICAgICAgIE51bWJlcih0aGlzLnF1YW50aXR5SW5TdG9ja1VuaXQudmFsdWUpICsgdGhpcy5xdWFudGl0eVBpY2tlZC52YWx1ZSA8IHRoaXMucXVhbnRpdHlUb1BpY2sudmFsdWVcbiAgICAgICAgKSB7XG4gICAgICAgICAgICB0aGlzLnF1YW50aXR5UGlja2VkLnZhbHVlICs9IHRoaXMucXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZTtcbiAgICAgICAgICAgIHRoaXMuZGlzcGxheVF1YW50aXR5UGlja2VkLnZhbHVlID1cbiAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svcXVhbnRpdHlQcmVwYXJlZCcsICdQaWNrZWQgcXVhbnRpdHk6ICcpICtcbiAgICAgICAgICAgICAgICBgJHt1aS5mb3JtYXROdW1iZXJUb0N1cnJlbnRMb2NhbGUoXG4gICAgICAgICAgICAgICAgICAgIE51bWJlcih0aGlzLnF1YW50aXR5UGlja2VkLnZhbHVlKSxcbiAgICAgICAgICAgICAgICAgICAgTnVtYmVyKHRoaXMuX3VuaXRTdG9ja051bWJlck9mRGVjaW1hbHMpLFxuICAgICAgICAgICAgICAgICl9ICR7dGhpcy5zdG9ja1VuaXQudmFsdWV9YDtcbiAgICAgICAgICAgIGlmICh0aGlzLm51bWJlck9mUGlja3MgPT09IHRoaXMuY29uZmlybWVkUGlja3MpIHtcbiAgICAgICAgICAgICAgICB0aGlzLl9jcmVhdGVOZXdQaWNrKHRoaXMucXVhbnRpdHlUb1BpY2sudmFsdWUgLSB0aGlzLnF1YW50aXR5UGlja2VkLnZhbHVlKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGF3YWl0IHRoaXMuX25leHRQaWNrKCk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAvLyBSZWFkeSB0byBwcm9jZXNzIHRoZSBwaWNrXG4gICAgICAgICAgICBsZXQgcmVzdWx0O1xuICAgICAgICAgICAgbGV0IGlzRGVsaXZlcmFibGUgPSBmYWxzZTtcbiAgICAgICAgICAgIGxldCBpc05vdFNldERlbGl2cmFibGUgPSBmYWxzZTtcbiAgICAgICAgICAgIGxldCBsYXN0TGluZSA9IDA7XG5cbiAgICAgICAgICAgIC8vIGFnZ3JlZ2F0ZSBhbGwgbGluZXMgZnJvbSB0aGlzIHBpY2sgdGlja2V0IGV4Y2VwdCB0aGUgdXNlcidzIHNlbGVjdGVkIGxpbmUgZm9yIHRoZSBtaW5pbXVtIGFkY1BpY2tlZExpbmUgKDAgPSBhdCBsZWFzdCAxIGlzIG5vdCBwaWNrZWQpXG4gICAgICAgICAgICBjb25zdCBhZ2dyZWdhdGVkQWRjUGlja2VkTGluZSA9IGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgICAgIC5ub2RlKCdAc2FnZS94My1zdG9jay9QaWNrVGlja2V0TGluZScpXG4gICAgICAgICAgICAgICAgLmFnZ3JlZ2F0ZS5yZWFkKFxuICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICBhZGNQaWNrZWRMaW5lOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbWluOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRpc3RpbmN0Q291bnQ6IHRydWUsIC8vIHRvIGhhbmRsZSBlZGd5IGNhc2Ugb2YgcGljayB0aWNrZXQgY29udGFpbmluZyBvbmx5IDEgbGluZSwgd2hpY2ggaW4gdGhpcyBjYXNlIHRoaXMgd2lsbCBhZ2dyZWdhdGUgMCByZWNvcmRzXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICBmaWx0ZXI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAvLyBnZXQgYWxsIGxpbmVzIGZyb20gdGhpcyBwaWNrIHRpY2tldCBleGNlcHQgdGhlIHVzZXIncyBzZWxlY3RlZCBsaW5lXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcGlja1RpY2tldDogeyBfZXE6IHRoaXMucGlja1RpY2tldC52YWx1ZSB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHBpY2tUaWNrZXRMaW5lOiB7IF9uZTogTnVtYmVyKHRoaXMucGlja1RpY2tldExpbmUudmFsdWUpIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIClcbiAgICAgICAgICAgICAgICAuZXhlY3V0ZSgpO1xuXG4gICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgYWdncmVnYXRlZEFkY1BpY2tlZExpbmUuYWRjUGlja2VkTGluZS5kaXN0aW5jdENvdW50ID09PSAwIHx8IC8vIGRlbGl2ZXJhYmxlIGlmIHRoaXMgaXMgdGhlIG9ubHkgbGluZSBpbiB0aGlzIHBpY2sgdGlja2V0XG4gICAgICAgICAgICAgICAgYWdncmVnYXRlZEFkY1BpY2tlZExpbmUuYWRjUGlja2VkTGluZS5taW4gIT09IDAgLy8gZGVsaXZlcmFibGUgaWYgYWxsIG90aGVyIHBpY2sgdGlja2V0IGxpbmVzIGhhdmUgYWRjUGlja2VkTGluZSA9IDFcbiAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICAgIGxhc3RMaW5lID0gMTtcbiAgICAgICAgICAgICAgICBpc0RlbGl2ZXJhYmxlID0gYXdhaXQgZGlhbG9nQ29uZmlybWF0aW9uKFxuICAgICAgICAgICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgICAgICAgICAnd2FybicsXG4gICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctd2FybmluZy10aXRsZScsICdXYXJuaW5nJyksXG4gICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1jb25maXJtYXRpb24tc2V0LXRoZS1waWNrLXRpY2tldC10by1kZWxpdmVyYWJsZScsXG4gICAgICAgICAgICAgICAgICAgICAgICBgU2V0IHRoZSBwaWNrIHRpY2tldCB0byAnRGVsaXZlcmFibGUnID9gLFxuICAgICAgICAgICAgICAgICAgICApLFxuICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICBmdWxsU2NyZWVuOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgYWNjZXB0QnV0dG9uOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdGV4dDogdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2J1dHRvbi1hY2NlcHQteWVzJywgJ1llcycpLFxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIGNhbmNlbEJ1dHRvbjoge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRleHQ6IHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9idXR0b24tY2FuY2VsLW5vJywgJ05vJyksXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoaXNEZWxpdmVyYWJsZSkge1xuICAgICAgICAgICAgICAgIGlmICghdGhpcy5faXNOZWdhdGl2ZVN0b2NrQXV0aG9yaXplZCAmJiAodGhpcy5zaG9ydFBpY2sgfHwgKGF3YWl0IHRoaXMuX2dldFNob3J0YWdlKCkpKSkge1xuICAgICAgICAgICAgICAgICAgICBhd2FpdCBkaWFsb2dNZXNzYWdlKFxuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcyxcbiAgICAgICAgICAgICAgICAgICAgICAgICdlcnJvcicsXG4gICAgICAgICAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svZGlhbG9nLWVycm9yLXRpdGxlJywgJ0Vycm9yJyksXG4gICAgICAgICAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAnQHNhZ2UveDMtc3RvY2svcGFnZXNfX21vYmlsZV9waWNrX3RpY2tldF9saW5lc19fdGhlX3BpY2tpbmdfbGluZV9pc19pbl9zaG9ydGFnZV9hbmRfbmVnYXRpdmVfc3RvY2tfaXNfcHJvaGliaXRlZCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgJ1RoZSBwaWNraW5nIGxpbmUgaXMgaW4gc2hvcnRhZ2UgYW5kIG5lZ2F0aXZlIHN0b2NrIGlzIHByb2hpYml0ZWQuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgICAgICk7XG4gICAgICAgICAgICAgICAgICAgIGlzRGVsaXZlcmFibGUgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICAgICAgaXNOb3RTZXREZWxpdnJhYmxlID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKFxuICAgICAgICAgICAgICAgICAgICB0aGlzLnNob3J0UGljayAmJlxuICAgICAgICAgICAgICAgICAgICB0aGlzLmRlc3RpbmF0aW9uTG9jYXRpb24udmFsdWUgJiZcbiAgICAgICAgICAgICAgICAgICAgdGhpcy5kZXN0aW5hdGlvbkxvY2F0aW9uLnZhbHVlLmNvZGUgIT0gJydcbiAgICAgICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICAgICAgYXdhaXQgZGlhbG9nTWVzc2FnZShcbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMsXG4gICAgICAgICAgICAgICAgICAgICAgICAnZXJyb3InLFxuICAgICAgICAgICAgICAgICAgICAgICAgdWkubG9jYWxpemUoJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1lcnJvci10aXRsZScsICdFcnJvcicpLFxuICAgICAgICAgICAgICAgICAgICAgICAgdWkubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLXN0b2NrL3BhZ2VzX19tb2JpbGVfcGlja190aWNrZXRfbGluZXNfX2FfbG9jYXRpb25fY2FuX25vdF9iZV9tb2RpZmllZF9mb3JfYV9zdG9ja19vdXRfbGluZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgJ0EgbG9jYXRpb24gY2FuIG5vdCBiZSBtb2RpZmllZCBmb3IgYSBzdG9jay1vdXQgbGluZS4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgICAgICAgICAgaXNEZWxpdmVyYWJsZSA9IGZhbHNlO1xuICAgICAgICAgICAgICAgICAgICBpc05vdFNldERlbGl2cmFibGUgPSB0cnVlO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgcmVzdWx0ID0gYXdhaXQgdGhpcy5fY2FsbFByb2Nlc3NQaWNrQVBJKGlzRGVsaXZlcmFibGUpOyAvLyBDYWxsIEFQSVxuICAgICAgICAgICAgdGhpcy4kLmxvYWRlci5pc0hpZGRlbiA9IHRydWU7XG5cbiAgICAgICAgICAgIC8vIFNwZWNpYWwgY2FzZSB1bmFibGUgdG8gY29ubmVjdCBjaGVjayB0eXBlIG9mIGVycm9yIDpcbiAgICAgICAgICAgIGlmICghcmVzdWx0IHx8IHJlc3VsdCBpbnN0YW5jZW9mIEVycm9yKSB7XG4gICAgICAgICAgICAgICAgY29uc3Qgb3B0aW9uczogdWkuZGlhbG9ncy5EaWFsb2dPcHRpb25zID0ge1xuICAgICAgICAgICAgICAgICAgICBhY2NlcHRCdXR0b246IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRleHQ6IHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9idXR0b24tZ29iYWNrJywgJ0dvIGJhY2snKSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgY2FuY2VsQnV0dG9uOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICB0ZXh0OiB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svYnV0dG9uLWNhbmNlbCcsICdDYW5jZWwnKSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgc2l6ZTogJ3NtYWxsJyxcbiAgICAgICAgICAgICAgICAgICAgbWRDb250ZW50OiB0cnVlLFxuICAgICAgICAgICAgICAgIH07XG4gICAgICAgICAgICAgICAgbGV0IG1lc3NhZ2UgPSAnJztcblxuICAgICAgICAgICAgICAgIGlmICghcmVzdWx0Py5tZXNzYWdlKSB7XG4gICAgICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuJC5zb3VuZC5lcnJvcigpO1xuICAgICAgICAgICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgICAgICAgICBhd2FpdCBkaWFsb2dDb25maXJtYXRpb24oXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAnZXJyb3InLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctZXJyb3ItdGl0bGUnLCAnRXJyb3InKSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLXN0b2NrL3BhZ2VzX2NyZWF0aW9uX2Vycm9yX2Nvbm5leGlvbl93ZWJzZXJ2aWNlX2NvbnRhY3RfYWRtaW5pc3RyYXRvcicsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICdBbiBlcnJvciBoYXMgb2NjdXJyZWQgKGNvbm5lY3Rpb24gb3Igd2Vic2VydmljZSBlcnJvcikuIFBsZWFzZSBjb250YWN0IHlvdXIgYWRtaW5pc3RyYXRvci4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgb3B0aW9ucyxcbiAgICAgICAgICAgICAgICAgICAgICAgIClcbiAgICAgICAgICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBhd2FpdCB0aGlzLiQucm91dGVyLnJlZnJlc2goKTtcbiAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGF3YWl0IHRoaXMuJC5yb3V0ZXIuZW1wdHlQYWdlKCk7XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLiQucm91dGVyLmdvVG8oJ0BzYWdlL3gzLXN0b2NrL01vYmlsZVBpY2tUaWNrZXQnKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgY29uc3QgX21lc3NhZ2VzID0gPHN0cmluZ1tdPltdO1xuICAgICAgICAgICAgICAgICAgICBjb25zdCBfcmVzdWx0cyA9IDxhbnk+cmVzdWx0O1xuICAgICAgICAgICAgICAgICAgICBsZXQgX2RpYWdub3NlcyA9IF9yZXN1bHRzPy5kaWFnbm9zZXM7XG4gICAgICAgICAgICAgICAgICAgIGlmIChfZGlhZ25vc2VzPy5sZW5ndGggPiAxKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBfZGlhZ25vc2VzID0gX2RpYWdub3Nlcy5zcGxpY2UoMCwgX2RpYWdub3Nlcy5sZW5ndGggLSAxKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgIChcbiAgICAgICAgICAgICAgICAgICAgICAgIChfcmVzdWx0cz8uZXJyb3JzXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPyBfcmVzdWx0cy5lcnJvcnNbMF0/LmV4dGVuc2lvbnM/LmRpYWdub3Nlc1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDogKF9yZXN1bHRzPy5pbm5lckVycm9yPy5lcnJvcnNbMF0/LmV4dGVuc2lvbnM/LmRpYWdub3NlcyA/P1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgX3Jlc3VsdHMuZXh0ZW5zaW9ucz8uZGlhZ25vc2VzID8/XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBfZGlhZ25vc2VzKSkgPz8gW11cbiAgICAgICAgICAgICAgICAgICAgKVxuICAgICAgICAgICAgICAgICAgICAgICAgLmZpbHRlcigoZDogeyBzZXZlcml0eTogbnVtYmVyOyBtZXNzYWdlOiBhbnkgfSkgPT4gZC5zZXZlcml0eSA+IDIgJiYgZC5tZXNzYWdlKVxuICAgICAgICAgICAgICAgICAgICAgICAgLmZvckVhY2goKGQ6IHsgbWVzc2FnZTogYW55IH0pID0+IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb25zdCBfbWVzc2FnZSA9IGQubWVzc2FnZS5zcGxpdChgXFxuYCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgX21lc3NhZ2VzLnB1c2goLi4uX21lc3NhZ2UpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfSk7XG5cbiAgICAgICAgICAgICAgICAgICAgY29uc3QgX3Jlc3VsdCA9IF9tZXNzYWdlcy5sZW5ndGggPyA8c3RyaW5nW10+X21lc3NhZ2VzIDogPHN0cmluZ1tdPnJlc3VsdC5tZXNzYWdlLnNwbGl0KGBcXG5gKTtcblxuICAgICAgICAgICAgICAgICAgICBtZXNzYWdlID0gYCoqJHt1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1zdG9jay9wYWdlc19fbW9iaWxlX3BpY2tfdGlja2V0X2xpbmVfX25vdGlmaWNhdGlvbl9fdXBkYXRlX2Vycm9yJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICdBbiBlcnJvciBoYXMgb2NjdXJyZWQnLFxuICAgICAgICAgICAgICAgICAgICApfSoqXFxuXFxuYDtcblxuICAgICAgICAgICAgICAgICAgICBpZiAoX3Jlc3VsdC5sZW5ndGggPT09IDEpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIG1lc3NhZ2UgKz0gYCR7X3Jlc3VsdFswXX1gO1xuICAgICAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgbWVzc2FnZSArPSBfcmVzdWx0Lm1hcChpdGVtID0+IGAqICR7aXRlbX1gKS5qb2luKCdcXG4nKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgIGlmIChyZXN1bHQgaW5zdGFuY2VvZiBFcnJvcikge1xuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5fYWxsUGlja3MuZm9yRWFjaChmdW5jdGlvbiAocGljaykge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHBpY2suY29uZmlybWVkID0gMDtcbiAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5jb25maXJtZWRQaWNrcyA9IDA7XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLnF1YW50aXR5UGlja2VkLnZhbHVlID0gMDtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuZGlzcGxheVF1YW50aXR5UGlja2VkLnZhbHVlID1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svcXVhbnRpdHlQcmVwYXJlZCcsICdQaWNrZWQgcXVhbnRpdHk6ICcpICtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBgJHt1aS5mb3JtYXROdW1iZXJUb0N1cnJlbnRMb2NhbGUoXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIE51bWJlcih0aGlzLnF1YW50aXR5UGlja2VkLnZhbHVlKSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgTnVtYmVyKHRoaXMuX3VuaXRTdG9ja051bWJlck9mRGVjaW1hbHMpLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICl9ICR7dGhpcy5zdG9ja1VuaXQudmFsdWV9YDtcbiAgICAgICAgICAgICAgICAgICAgICAgIGlmICh0aGlzLl9hbGxQaWNrcy5sZW5ndGggPiAxKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5uZXh0QnV0dG9uLmlzRGlzYWJsZWQgPSBmYWxzZTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuJC5sb2FkZXIuaXNIaWRkZW4gPSB0cnVlO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgYXdhaXQgdGhpcy4kLnNvdW5kLmVycm9yKCk7XG4gICAgICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgICAgICBhd2FpdCBkaWFsb2dDb25maXJtYXRpb24oXG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgICAgICAgICAgICAgJ2Vycm9yJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctZXJyb3ItdGl0bGUnLCAnRXJyb3InKSxcbiAgICAgICAgICAgICAgICAgICAgICAgIG1lc3NhZ2UsXG4gICAgICAgICAgICAgICAgICAgICAgICBvcHRpb25zLFxuICAgICAgICAgICAgICAgICAgICApXG4gICAgICAgICAgICAgICAgKSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIC8vIElmIHdlIGNhbWUgZnJvbSBwcmVwYXJhdGlvbiBsaXN0IHNlZSBpZiB0aGUgbGlzdCBpcyBkb25lXG4gICAgICAgICAgICAvLyBDaGFuZ2UgbGFzdExpbmUgdG8gMCBpZiBpdCBpcyBub3QgZG9uZVxuICAgICAgICAgICAgaWYgKGxhc3RMaW5lICYmIHRoaXMucGlja0xpc3QudmFsdWUgIT0gJycpIHtcbiAgICAgICAgICAgICAgICBjb25zdCBhZ2dyZWdhdGVkTGlzdCA9IGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgICAgICAgICAubm9kZSgnQHNhZ2UveDMtc3RvY2svUGlja0xpc3QnKVxuICAgICAgICAgICAgICAgICAgICAuYWdncmVnYXRlLnJlYWQoXG4gICAgICAgICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcHJlcGFyYXRpb25MaXN0U2VxdWVuY2VOdW1iZXI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZGlzdGluY3RDb3VudDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBmaWx0ZXI6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcHJlcGFyYXRpb25MaXN0OiB0aGlzLnBpY2tMaXN0LnZhbHVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBwaWNrVGlja2V0TGluZTogeyBhZGNQaWNrZWRMaW5lOiAwIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIClcbiAgICAgICAgICAgICAgICAgICAgLmV4ZWN1dGUoKTtcbiAgICAgICAgICAgICAgICBpZiAoYWdncmVnYXRlZExpc3QucHJlcGFyYXRpb25MaXN0U2VxdWVuY2VOdW1iZXIuZGlzdGluY3RDb3VudCAhPT0gMCkge1xuICAgICAgICAgICAgICAgICAgICBsYXN0TGluZSA9IDA7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdGhpcy4kLnN0b3JhZ2UucmVtb3ZlKE1vYmlsZVBpY2tUaWNrZXRWaWV3UGlja1RpY2tldExpbmUuUElDS19USUNLRVRfTElORV9LRVkpO1xuXG4gICAgICAgICAgICAvKlxuICAgICAgICAgICAgICogRGlzcGxheSBpbmZvcm1hdGlvbiB3aGVuIHBpY2sgdGlja2V0IGlzIG9yIG5vdCBkZWxpdmVyYWJsZVxuICAgICAgICAgICAgICovXG5cbiAgICAgICAgICAgIGlmIChsYXN0TGluZSAmJiBpc0RlbGl2ZXJhYmxlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgICAgICAgICAgICBhd2FpdCBkaWFsb2dNZXNzYWdlKFxuICAgICAgICAgICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgICAgICAgICAnaW5mbycsXG4gICAgICAgICAgICAgICAgICAgIHVpLmxvY2FsaXplKCdAc2FnZS94My1zdG9jay9kaWFsb2ctaW5mb3JtYXRpb24tdGl0bGUnLCAnSW5mb3JtYXRpb24nKSxcbiAgICAgICAgICAgICAgICAgICAgaXNOb3RTZXREZWxpdnJhYmxlXG4gICAgICAgICAgICAgICAgICAgICAgICA/IHVpLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1tZXNzYWdlLXBpY2stdGlja2V0LWhhcy1iZWVuLXN1Ym1pdHRlZC1idXQtbm90LXNldC1hcy1kZWxpdmVyYWJsZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAnVGhlIHBpY2sgdGlja2V0IGhhcyBiZWVuIHVwZGF0ZWQgYnV0IGl0IGlzIG5vdCBzZXQgYXMgZGVsaXZlcmFibGUuJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgKVxuICAgICAgICAgICAgICAgICAgICAgICAgOiBpc0RlbGl2ZXJhYmxlXG4gICAgICAgICAgICAgICAgICAgICAgICAgID8gdWkubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICdAc2FnZS94My1zdG9jay9kaWFsb2ctbWVzc2FnZS1waWNrLXRpY2tldC1pcy1kZWxpdmVyYWJsZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICdUaGUgcGljayB0aWNrZXQgaXMgbm93IHNldCBhcyBkZWxpdmVyYWJsZS4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIClcbiAgICAgICAgICAgICAgICAgICAgICAgICAgOiB1aS5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgJ0BzYWdlL3gzLXN0b2NrL2RpYWxvZy1tZXNzYWdlLXBpY2stdGlja2V0LW5vdC1kZWxpdmVyYWJsZScsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICdUaGUgcGljayB0aWNrZXQgaXMgbm90IHNldCBhcyBkZWxpdmVyYWJsZS4nLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICksXG4gICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgLypcbiAgICAgICAgICAgICAqIFJldHVybiB0byBnZXQgYW5vdGhlciBwaWNrIHRpY2tldCBsaW5lIG9yIGdvIGJhY2sgdG8gcGFnZSBvbmVcbiAgICAgICAgICAgICAqL1xuICAgICAgICAgICAgdGhpcy4kLnNldFBhZ2VDbGVhbigpO1xuICAgICAgICAgICAgYXdhaXQgdGhpcy4kLnNvdW5kLnN1Y2Nlc3MoKTtcblxuICAgICAgICAgICAgaWYgKGxhc3RMaW5lKSB7XG4gICAgICAgICAgICAgICAgdGhpcy4kLnJvdXRlci5nb1RvKCdAc2FnZS94My1zdG9jay9Nb2JpbGVQaWNrVGlja2V0Jyk7XG4gICAgICAgICAgICB9IGVsc2UgaWYgKHRoaXMucGlja0xpc3QudmFsdWUgPT09ICcnKSB7XG4gICAgICAgICAgICAgICAgdGhpcy4kLnJvdXRlci5nb1RvKCdAc2FnZS94My1zdG9jay9Nb2JpbGVQaWNrVGlja2V0U2VsZWN0RnJvbVRpY2tldCcsIHtcbiAgICAgICAgICAgICAgICAgICAgbW9iaWxlU2V0dGluZ3M6IEpTT04uc3RyaW5naWZ5KHRoaXMuX21vYmlsZVNldHRpbmdzKSxcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgdGhpcy4kLnJvdXRlci5nb1RvKCdAc2FnZS94My1zdG9jay9Nb2JpbGVQaWNrVGlja2V0U2VsZWN0RnJvbUxpc3QnLCB7XG4gICAgICAgICAgICAgICAgICAgIG1vYmlsZVNldHRpbmdzOiBKU09OLnN0cmluZ2lmeSh0aGlzLl9tb2JpbGVTZXR0aW5ncyksXG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAvKlxuICAgICAqIENhbGwgdGhlIHVwZGF0ZVBpY2tUaWNrZXRMaW5lIG11dGF0aW9uIG9uIHRoZSBQaWNrIFRpY2tldCBMaW5lIG5vZGVcbiAgICAgKi9cbiAgICBwcml2YXRlIGFzeW5jIF9jYWxsUHJvY2Vzc1BpY2tBUEkoaXNEZWxpdmVyYWJsZTogYm9vbGVhbik6IFByb21pc2U8YW55PiB7XG4gICAgICAgIHRoaXMuJC5sb2FkZXIuaXNIaWRkZW4gPSBmYWxzZTtcbiAgICAgICAgLypcbiAgICAgICAgICogcHVzaCB0aGUgcGlja3MgdG8gdGhlIHBpY2tMaW5lcyBhcnJheVxuICAgICAgICAgKi9cbiAgICAgICAgY29uc3QgX3BhY2tpbmdVbml0OiAoc3RyaW5nIHwgdW5kZWZpbmVkKVtdID0gW107XG4gICAgICAgIGNvbnN0IF9wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3RvcjogKG51bWJlciB8IHVuZGVmaW5lZClbXSA9IFtdO1xuICAgICAgICBjb25zdCBfcXVhbnRpdHlJblBhY2tpbmdVbml0OiAobnVtYmVyIHwgdW5kZWZpbmVkKVtdID0gW107XG4gICAgICAgIGNvbnN0IF9xdWFudGl0eUluU3RvY2tVbml0OiAobnVtYmVyIHwgdW5kZWZpbmVkKVtdID0gW107XG4gICAgICAgIGNvbnN0IF9sb2NhdGlvbjogKHN0cmluZyB8IHVuZGVmaW5lZClbXSA9IFtdO1xuICAgICAgICBjb25zdCBfbG90OiAoc3RyaW5nIHwgdW5kZWZpbmVkKVtdID0gW107XG4gICAgICAgIGNvbnN0IF9zdWJsb3Q6IChzdHJpbmcgfCB1bmRlZmluZWQpW10gPSBbXTtcbiAgICAgICAgY29uc3QgX3NlcmlhbE51bWJlcjogKHN0cmluZyB8IHVuZGVmaW5lZClbXSA9IFtdO1xuICAgICAgICBjb25zdCBfc3RhdHVzOiAoc3RyaW5nIHwgdW5kZWZpbmVkKVtdID0gW107XG4gICAgICAgIGNvbnN0IF9zdG9ja0lkOiAobnVtYmVyIHwgdW5kZWZpbmVkKVtdID0gW107XG4gICAgICAgIGZvciAoY29uc3QgcGljayBvZiB0aGlzLl9hbGxQaWNrcykge1xuICAgICAgICAgICAgaWYgKHBpY2suY29uZmlybWVkICYmIHBpY2sucXVhbnRpdHlJblN0b2NrVW5pdCA+IDApIHtcbiAgICAgICAgICAgICAgICBfcGFja2luZ1VuaXQucHVzaChwaWNrLnBhY2tpbmdVbml0Q29kZSk7XG4gICAgICAgICAgICAgICAgX3BhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLnB1c2gocGljay5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvcik7XG4gICAgICAgICAgICAgICAgX3F1YW50aXR5SW5QYWNraW5nVW5pdC5wdXNoKHBpY2sucXVhbnRpdHlJblBhY2tpbmdVbml0KTtcbiAgICAgICAgICAgICAgICBfcXVhbnRpdHlJblN0b2NrVW5pdC5wdXNoKHBpY2sucXVhbnRpdHlJblN0b2NrVW5pdCk7XG4gICAgICAgICAgICAgICAgX2xvY2F0aW9uLnB1c2gocGljay5sb2NhdGlvbiA/PyAnJyk7XG4gICAgICAgICAgICAgICAgX2xvdC5wdXNoKHBpY2subG90ID8/ICcnKTtcbiAgICAgICAgICAgICAgICBfc3VibG90LnB1c2gocGljay5zdWJsb3QgPz8gJycpO1xuICAgICAgICAgICAgICAgIF9zZXJpYWxOdW1iZXIucHVzaChwaWNrLnNlcmlhbE51bWJlciA/PyAnJyk7XG4gICAgICAgICAgICAgICAgX3N0YXR1cy5wdXNoKHBpY2suc3RhdHVzKTtcbiAgICAgICAgICAgICAgICBfc3RvY2tJZC5wdXNoKHBpY2suc3RvY2tJZCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICAvKlxuICAgICAgICAgKiBNYWtlIHRoZSBtdXRhdGlvbiBjYWxsXG4gICAgICAgICAqL1xuICAgICAgICBjb25zdCBwaWNrVGlja2V0QXJnczogYW55ID0ge1xuICAgICAgICAgICAgZW50cnlUcmFuc2FjdGlvbjogdGhpcy50cmFuc2FjdGlvbi52YWx1ZSxcbiAgICAgICAgICAgIHBpY2tUaWNrZXQ6IHRoaXMucGlja1RpY2tldC52YWx1ZSxcbiAgICAgICAgICAgIHBpY2tUaWNrZXRMaW5lOiB0aGlzLnBpY2tUaWNrZXRMaW5lLnZhbHVlLFxuICAgICAgICAgICAgZGVzdGluYXRpb25Mb2NhdGlvbjogdGhpcy5kZXN0aW5hdGlvbkxvY2F0aW9uLnZhbHVlID8gdGhpcy5kZXN0aW5hdGlvbkxvY2F0aW9uLnZhbHVlLmNvZGUgOiAnJyxcbiAgICAgICAgICAgIHByb2R1Y3Q6IHRoaXMucHJvZHVjdC52YWx1ZSxcbiAgICAgICAgICAgIHNob3J0UGljazogdGhpcy5zaG9ydFBpY2ssXG4gICAgICAgICAgICBkZWxpdmVyYWJsZTogaXNEZWxpdmVyYWJsZSxcbiAgICAgICAgICAgIGRvY3VtZW50RGVzdGluYXRpb246ICh0aGlzLiQuc3RvcmFnZS5nZXQoJ21vYmlsZS1kb2N1bWVudC1kZXN0aW5hdGlvbicpIGFzIHN0cmluZykgPz8gJycsXG4gICAgICAgICAgICBwYWNraW5nVW5pdDogX3BhY2tpbmdVbml0LFxuICAgICAgICAgICAgcGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I6IF9wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3RvcixcbiAgICAgICAgICAgIHF1YW50aXR5SW5QYWNraW5nVW5pdDogX3F1YW50aXR5SW5QYWNraW5nVW5pdCxcbiAgICAgICAgICAgIHF1YW50aXR5SW5TdG9ja1VuaXQ6IF9xdWFudGl0eUluU3RvY2tVbml0LFxuICAgICAgICAgICAgbG9jYXRpb246IF9sb2NhdGlvbixcbiAgICAgICAgICAgIGxvdDogX2xvdCxcbiAgICAgICAgICAgIHN1YmxvdDogX3N1YmxvdCxcbiAgICAgICAgICAgIHNlcmlhbE51bWJlcjogX3NlcmlhbE51bWJlcixcbiAgICAgICAgICAgIHN0YXR1czogX3N0YXR1cyxcbiAgICAgICAgICAgIHN0b2NrSWQ6IF9zdG9ja0lkLFxuICAgICAgICAgICAgY3VzdG9tQm9vbGVhbjogdGhpcy5jdXN0b21Cb29sZWFuLnZhbHVlID8gdGhpcy5jdXN0b21Cb29sZWFuLnZhbHVlIDogbnVsbCxcbiAgICAgICAgICAgIGN1c3RvbURlY2ltYWw6IHRoaXMuY3VzdG9tRGVjaW1hbC52YWx1ZSA/IHRoaXMuY3VzdG9tRGVjaW1hbC52YWx1ZSA6IG51bGwsXG4gICAgICAgICAgICBjdXN0b21TdHJpbmc6IHRoaXMuY3VzdG9tU3RyaW5nLnZhbHVlID8gdGhpcy5jdXN0b21TdHJpbmcudmFsdWUgOiBudWxsLFxuICAgICAgICAgICAgY3VzdG9tRGF0ZTogdGhpcy5jdXN0b21EYXRlLnZhbHVlID8gdGhpcy5jdXN0b21EYXRlLnZhbHVlIDogbnVsbCxcbiAgICAgICAgfTtcblxuICAgICAgICB0cnkge1xuICAgICAgICAgICAgcmV0dXJuIGF3YWl0IHRoaXMuJC5ncmFwaFxuICAgICAgICAgICAgICAgIC5ub2RlKCdAc2FnZS94My1zdG9jay9QaWNrVGlja2V0TGluZScpXG4gICAgICAgICAgICAgICAgLm11dGF0aW9ucy51cGRhdGVQaWNrVGlja2V0TGluZShcbiAgICAgICAgICAgICAgICAgICAgeyBwaWNrVGlja2V0OiB0cnVlLCBwaWNrVGlja2V0TGluZTogdHJ1ZSB9LFxuICAgICAgICAgICAgICAgICAgICB7IHBhcmFtZXRlcnM6IHBpY2tUaWNrZXRBcmdzIH0sXG4gICAgICAgICAgICAgICAgKVxuICAgICAgICAgICAgICAgIC5leGVjdXRlKCk7XG4gICAgICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICAgICAgICByZXR1cm4gZXJyb3I7XG4gICAgICAgIH1cbiAgICB9XG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./lib/pages/mobile-pick-ticket-view-pick-ticket-line.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-pick-ticket-view-pick-ticket-line.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;