/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/manage-pages.ts":
/*!**********************************************!*\
  !*** ./lib/client-functions/manage-pages.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.readSerialNumberFromStockId = exports.handleFilterOnChange = exports.generateStockTableFilter = exports.removeFilters = exports.findSetting = exports.managePages = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * Initialize manage page\n * @param pageInstance current page\n * @param stockSite stock site\n * @param productSite partial product site object\n * @param flowType type of flow\n * @param errorMessage error messages missing settings\n * @param stockSearchFilters mandatory array to return settings\n */\n//todo:\nfunction managePages(pageInstance, stockSite, productSite, flowType, errorMessage, stockSearchFilters) {\n    // Initializing array when undefined\n    stockSearchFilters ??= [];\n    if (stockSearchFilters.length) {\n        // remove all items in array\n        stockSearchFilters.length = 0;\n    }\n    if (!pageInstance || !stockSite || !productSite || !flowType) {\n        throw new xtrem_shared_1.SystemError('Invalid arguments');\n    }\n    const _selectedMobileSettings = JSON.parse(pageInstance.$.queryParameters?.mobileSettings);\n    if (typesLib.strictEq(_selectedMobileSettings, null)) {\n        throw new Error(errorMessage);\n    }\n    // Store value in array only when usable and return true when done\n    const _pushSettings = (field) => {\n        if (typesLib.strictNe(field, 'none')) {\n            stockSearchFilters?.push(field);\n            return true;\n        }\n        return false;\n    };\n    // The fields are memorized until they meet the none type.\n    const _allPushed = _pushSettings(_selectedMobileSettings.stockField1) &&\n        _pushSettings(_selectedMobileSettings.stockField2) &&\n        _pushSettings(_selectedMobileSettings.stockField3) &&\n        _pushSettings(_selectedMobileSettings.stockField4) &&\n        _pushSettings(_selectedMobileSettings.stockField5) &&\n        _pushSettings(_selectedMobileSettings.stockField6) &&\n        _pushSettings(_selectedMobileSettings.stockField7) &&\n        _pushSettings(_selectedMobileSettings.stockField8);\n    if (pageInstance._pageMetadata.layoutFields?.location) {\n        if (!findSetting('location', stockSearchFilters) || typesLib.strictNe(productSite.isLocationManaged, true)) {\n            pageInstance['location'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.lot) {\n        if (!findSetting('lot', stockSearchFilters) || typesLib.strictEq((productSite?.product?.lotManagementMode ?? 'notManaged'), 'notManaged')) {\n            pageInstance['lot'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.sublot)\n        if (!findSetting('sublot', stockSearchFilters) || typesLib.strictNe((productSite?.product?.lotManagementMode ?? ''), 'lotAndSublot')) {\n            pageInstance['sublot'].isHidden = true;\n        }\n    if (pageInstance._pageMetadata.layoutFields?.serialNumber) {\n        if (!findSetting('serial', stockSearchFilters) ||\n            !['receivedIssued'].includes(productSite?.product?.serialNumberManagementMode ?? 'receivedIssued')) {\n            pageInstance['serialNumber'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.status) {\n        if (!findSetting('status', stockSearchFilters)) {\n            pageInstance['status'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.packingUnit) {\n        if (!findSetting('packingUnit', stockSearchFilters)) {\n            pageInstance['packingUnit'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor) {\n        if (!findSetting('pacStkConversionFactor', stockSearchFilters)) {\n            pageInstance['packingUnitToStockUnitConversionFactor'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.identifier1) {\n        if (!findSetting('identifier1', stockSearchFilters)) {\n            pageInstance['identifier1'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.identifier2) {\n        if (!findSetting('identifier2', stockSearchFilters)) {\n            pageInstance['identifier2'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.licensePlateNumber) {\n        if (typesLib.strictNe(productSite.isLicensePlateNumberManaged, true) ||\n            !findSetting('licensePlateNumber', stockSearchFilters)) {\n            pageInstance['licensePlateNumber'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField1) {\n        if (!findSetting('customField1', stockSearchFilters)) {\n            pageInstance['stockCustomField1'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField2) {\n        if (!findSetting('customField2', stockSearchFilters)) {\n            pageInstance['stockCustomField2'].isHidden = true;\n        }\n    }\n}\nexports.managePages = managePages;\n/**\n * Search if filter\n * @param field current search field\n * @param fields list of current filter\n * @returns true when found used filter parameter\n */\nfunction findSetting(field, fields) {\n    return typesLib.gte(fields.findIndex(fld => typesLib.strictEq(fld, field)), 0);\n}\nexports.findSetting = findSetting;\n/**\n * Remove filter (asynchronous for avoiding anticipated onChange)\n * @param pageInstance current page\n */\nasync function removeFilters(pageInstance) {\n    if (pageInstance._pageMetadata.layoutFields?.location)\n        pageInstance['location'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.lot)\n        pageInstance['lot'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.sublot)\n        pageInstance['sublot'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.serialNumber)\n        pageInstance['serialNumber'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.status)\n        pageInstance['status'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.packingUnit)\n        pageInstance['packingUnit'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor)\n        pageInstance['packingUnitToStockUnitConversionFactor'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.identifier1)\n        pageInstance['identifier1'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.identifier2)\n        pageInstance['identifier2'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.licensePlateNumber)\n        pageInstance['licensePlateNumber'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField1)\n        pageInstance['stockCustomField1'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField2)\n        pageInstance['stockCustomField2'].value = null;\n}\nexports.removeFilters = removeFilters;\nfunction generateStockTableFilter(pageInstance) {\n    const stockSite = pageInstance['_stockSite'];\n    const stockFilter = {\n        availableQuantity: { _gt: '0' },\n        //      quantityInPackingUnit: { _gt: '0' },\n        isBeingCounted: false,\n        owner: stockSite?.code,\n    };\n    let parameterLocation = pageInstance.$.queryParameters?.location;\n    if (!parameterLocation &&\n        pageInstance._pageMetadata.layoutFields?.location &&\n        pageInstance['location'].value) {\n        parameterLocation = pageInstance['location'].value?.code;\n    }\n    const quantityToPick = pageInstance['_quantityToPick'] ?? null;\n    const beginSerialNumber = pageInstance['serialNumber']?.value?.code ?? null;\n    const endSerialNumber = beginSerialNumber && quantityToPick ? _calculateEndingSerialNumber(beginSerialNumber, quantityToPick) : null;\n    const isFilterSerialNumber = pageInstance['_isFilterSerialNumber'] ?? false;\n    const filterLicensePlateNumber = pageInstance._pageMetadata.layoutFields?.licensePlateNumber\n        ? pageInstance['licensePlateNumber'].value?.code\n            ? { licensePlateNumber: { code: pageInstance['licensePlateNumber'].value.code } }\n            : {}\n        : pageInstance.$.queryParameters?.licensePlateNumberOrigin\n            ? { licensePlateNumber: { code: pageInstance.$.queryParameters.licensePlateNumberOrigin } }\n            : { licensePlateNumber: { code: { _in: [undefined, ''] } } };\n    return {\n        ...stockFilter,\n        ...(pageInstance._pageMetadata.layoutFields?.product &&\n            pageInstance['product'].value?.code && {\n            product: { product: { code: pageInstance['product'].value.code } },\n        }),\n        ...filterLicensePlateNumber,\n        ...(pageInstance._pageMetadata.layoutFields?.location &&\n            !pageInstance['location'].isHidden &&\n            pageInstance['location'].value && {\n            location: { code: parameterLocation },\n        }),\n        // lot and sublot are reference fields bound to the same Lot node\n        // so first check if sublot field is enabled with a value. If so, filter for both lot and sublot\n        // otherwise check if lot field is enabled with a value. If so filter for lot and additionally sublot, if applicable\n        ...((pageInstance._pageMetadata.layoutFields?.lot &&\n            !pageInstance['lot'].isHidden &&\n            pageInstance['lot'].value?.lot && {\n            lot: pageInstance['lot'].value.lot,\n            ...(pageInstance['lot'].value.sublot && {\n                sublot: pageInstance['lot'].value.sublot,\n            }),\n        }) ||\n            (pageInstance._pageMetadata.layoutFields?.sublot &&\n                !pageInstance['sublot'].isHidden &&\n                pageInstance['sublot'].value?.sublot && {\n                lot: pageInstance['sublot'].value.lot,\n                sublot: pageInstance['sublot'].value.sublot,\n            })),\n        //...(this.sublot.value?.sublot && { sublot: this.sublot.value.sublot }),\n        ...(pageInstance._pageMetadata.layoutFields?.serialNumber &&\n            !isFilterSerialNumber &&\n            !pageInstance['serialNumber'].isHidden &&\n            pageInstance['serialNumber'].value?.code && {\n            serialNumber: pageInstance['serialNumber'].value.code,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.serialNumber &&\n            isFilterSerialNumber &&\n            beginSerialNumber &&\n            endSerialNumber && {\n            serialNumber: {\n                _gte: beginSerialNumber,\n                //                  _lte: endSerialNumber,\n            },\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.status &&\n            !pageInstance['status'].isHidden &&\n            pageInstance['status'].value && { status: { code: pageInstance['status'].value } }),\n        // ...(this.packingUnit.value && { packingUnit: this._unitMap.get(this.packingUnit.value).unit }),\n        ...(pageInstance._pageMetadata.layoutFields?.packingUnit &&\n            !pageInstance['packingUnit'].isHidden &&\n            pageInstance['packingUnit'].value && {\n            packingUnit: { code: pageInstance['packingUnit'].value },\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor &&\n            !pageInstance['packingUnitToStockUnitConversionFactor'].isHidden &&\n            pageInstance['packingUnitToStockUnitConversionFactor'].value && {\n            packingUnitToStockUnitConversionFactor: pageInstance['packingUnitToStockUnitConversionFactor']\n                .value,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.identifier1 &&\n            !pageInstance['identifier1'].isHidden &&\n            pageInstance['identifier1'].value && { identifier1: pageInstance['identifier1'].value }),\n        ...(pageInstance._pageMetadata.layoutFields?.identifier2 &&\n            !pageInstance['identifier2'].isHidden &&\n            pageInstance['identifier2'].value && { identifier2: pageInstance['identifier2'].value }),\n        ...(pageInstance._pageMetadata.layoutFields?.stockCustomField1 &&\n            !pageInstance['stockCustomField1'].isHidden &&\n            pageInstance['stockCustomField1'].value && {\n            stockCustomField1: pageInstance['stockCustomField1'].value,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.stockCustomField2 &&\n            !pageInstance['stockCustomField2'].isHidden &&\n            pageInstance['stockCustomField2'].value && {\n            stockCustomField2: pageInstance['stockCustomField2'].value,\n        }),\n    };\n}\nexports.generateStockTableFilter = generateStockTableFilter;\nfunction _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n    return startingSerialNumber.replace(/\\d+$/, match => {\n        const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n        const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n        return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n    });\n}\nasync function handleFilterOnChange(pageInstance, field, filterCriterion = null) {\n    // if field value is cleared out during onChange, then delete the corresponding filter property in stock table's filter\n    const stockKey = field.id;\n    if (!stockKey) {\n        //throw new SystemError('Invalid stock property to filter');\n        return; // do nothing?\n    }\n    if (!pageInstance._pageMetadata.layoutFields?.stock) {\n        //throw new SystemError('Invalid stock property to pageInstance');\n        return; // do nothing?\n    }\n    const stock = pageInstance['stock'];\n    const stockChangeLines = pageInstance['_stockChangeLines'] ?? null;\n    const miscellaneousStockTransactionLines = pageInstance['_miscellaneousStockTransactionLines'] ?? null;\n    const currentLine = pageInstance['_currentLine'];\n    const currentStockChangeLine = stockChangeLines ? (stockChangeLines[currentLine] ?? null) : null;\n    const currentMiscellaneousStockTransactionLine = miscellaneousStockTransactionLines\n        ? (miscellaneousStockTransactionLines[currentLine] ?? null)\n        : null;\n    const quantityToPick = pageInstance['_quantityToPick'] ?? null;\n    const beginSerialNumber = pageInstance['serialNumber']?.value?.code ?? null;\n    const endSerialNumber = beginSerialNumber && quantityToPick ? _calculateEndingSerialNumber(beginSerialNumber, quantityToPick) : null;\n    const isFilterSerialNumber = pageInstance['_isFilterSerialNumber'] ?? false;\n    // When for the tuple the value is undefined, the key is removed from the filter.\n    if (!field.value) {\n        stock.filter = {\n            ...stock.filter,\n            ...(typesLib.strictEq(stockKey, 'location') && {\n                ...(typesLib.strictEq(pageInstance.$.page.id, 'MobileSubcontractTransferDetails') && {\n                    [stockKey]: { category: { _nin: ['subcontract', 'customer'] } },\n                }),\n                ...(typesLib.strictNe(pageInstance.$.page.id, 'MobileSubcontractTransferDetails') && { [stockKey]: undefined }),\n            }),\n            ...(!['location'].includes(stockKey) && { [stockKey]: undefined }),\n        };\n    }\n    else {\n        stock.filter = {\n            ...stock.filter,\n            ...(typesLib.strictEq(stockKey, 'packingUnit') &&\n                pageInstance._pageMetadata.layoutFields?.packingUnit && {\n                [stockKey]: {\n                    code: pageInstance[stockKey].value,\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'status') && {\n                [stockKey]: {\n                    code: filterCriterion ??\n                        (field instanceof ui.fields.Reference && field?.valueField\n                            ? { [field.valueField]: field.value[field.valueField] }\n                            : field.value),\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'serialNumber') &&\n                isFilterSerialNumber &&\n                beginSerialNumber &&\n                endSerialNumber && {\n                [stockKey]: {\n                    _gte: beginSerialNumber,\n                    //                      _lte: endSerialNumber,\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'serialNumber') &&\n                !isFilterSerialNumber && {\n                [stockKey]: {\n                    _eq: beginSerialNumber,\n                },\n            }),\n            // All other cases\n            ...(!['packingUnit', 'status', 'serialNumber'].includes(stockKey) && {\n                [stockKey]: filterCriterion ??\n                    (field instanceof ui.fields.Reference && field?.valueField\n                        ? { [field.valueField]: field.value[field.valueField] }\n                        : field.value),\n            }),\n        };\n        // stock.pageSize = 1000;\n    }\n    await _setStockQuantityInPackingUnit(pageInstance, stock, currentStockChangeLine ?? currentMiscellaneousStockTransactionLine);\n    if (!field.value) {\n        field.getNextField(true)?.focus();\n    }\n}\nexports.handleFilterOnChange = handleFilterOnChange;\n/**\n * _setStockQuantityInPackingUnit\n * @param pageInstance current page\n * @param stock stock table\n * @param currentStockLine stock line for lpnOperations or MiscellaneousIssue\n */\nasync function _setStockQuantityInPackingUnit(pageInstance, stock, currentStockLine) {\n    const _stockDetails = currentStockLine?.stockDetails;\n    if (_stockDetails) {\n        stock.selectedRecords.forEach((rowId) => {\n            const stockRecord = stock.getRecordValue(rowId);\n            if (stockRecord) {\n                const qtyTotal = _stockDetails.reduce((acc, curr) => {\n                    return typesLib.add(acc, Number(curr.quantityInPackingUnit));\n                }, 0);\n                stockRecord.quantityInPackingUnit = String(qtyTotal);\n                stock.setRecordValue(stockRecord);\n            }\n        });\n        await pageInstance.$.commitValueAndPropertyChanges();\n    }\n}\n/**\n * Read one serial number for a given stock id\n * @param pageInstance current page\n * @param stockId stock id\n * @param orderBy sort order\n * @returns serial number or null\n */\nasync function readSerialNumberFromStockId(pageInstance, stockId, orderBy) {\n    if (stockId) {\n        try {\n            const serialNumber = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n                .node('@sage/x3-stock-data/SerialNumber')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }, {\n                filter: { stockId },\n                orderBy: { code: orderBy },\n            }))\n                .execute());\n            if (serialNumber[0]) {\n                return serialNumber[0];\n            }\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-serial-number-node', 'Error loading serial number node'), String(e));\n        }\n    }\n    return null;\n}\nexports.readSerialNumberFromStockId = readSerialNumberFromStockId;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/manage-pages.ts\n");

/***/ }),

/***/ "./lib/client-functions/stock-management-rules.ts":
/*!********************************************************!*\
  !*** ./lib/client-functions/stock-management-rules.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.findDefaultLocation = exports.findStockManagementRules = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance) {\n    try {\n        //read the stock management rules\n        const stockManagementRules = await pageInstance.$.graph\n            .node('@sage/x3-stock-data/StockManagementRules')\n            .query(ui.queryUtils.edgesSelector({\n            productCategory: { code: true },\n            stockSite: { code: true },\n            transactionType: true,\n            stockMovementCode: { code: true },\n            defaultStatus: true,\n            locationNumber: true,\n            locationNumber2: true,\n            locationNumber3: true,\n            authorizedStatus: true,\n            authorizedSubstatus: true,\n            hasAnalysisRequest: true,\n            lotEntry: true,\n            lotByDefault: true,\n            outputLot: true,\n            isExclusiveEntryVersion: true,\n            activeVersion: true,\n            licensePlateNumberEntry: true,\n            versionStopped: true,\n            prototypeVersion: true,\n        }, {\n            filter: {\n                productCategory: { code: productCategory },\n                stockSite: { code: stockSite },\n                transactionType: transactionType,\n                stockMovementCode: { code: stockMovementCode },\n            },\n        }))\n            .execute();\n        if (typesLib.gt(stockManagementRules.edges.length, 0))\n            return stockManagementRules.edges[0].node;\n        else\n            return null;\n    }\n    catch (e) { }\n}\nasync function findStockManagementRules(stockSite, productCategory, transactionType, //TRSTYP, menu 704\nstockMovementCode, //TRSCOD\npageInstance) {\n    // for the stock site, the product category and the movement code\n    let stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for stock site and product category\n    stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category and movement code\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // general rules\n    stockManagementRules = await _readStockManagementRules(null, null, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    throw new Error(ui.localize('@sage/x3-stock/stock_management_rules__notification__no_management_rules_error', `Could not retrieve the management rules for your product category {{ productCategory }} and for the site {{ siteCode }}`, { productCategory: productCategory, siteCode: stockSite }));\n}\nexports.findStockManagementRules = findStockManagementRules;\nasync function _readProductCategorySite(stockSite, productCategory, pageInstance) {\n    try {\n        //read the product category site\n        const productCategorySite = await pageInstance.$.graph\n            .node('@sage/x3-master-data/productCategory')\n            .read({\n            stockSite: { code: true },\n            code: true,\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: true,\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n        }, \n        // TODO: find a better way if possible\n        `${stockSite}|${productCategory}`)\n            .execute();\n        return productCategorySite ?? null;\n    }\n    catch (e) {\n        return null;\n    }\n}\nasync function findDefaultLocation(productSite, stockManagementRules, pageInstance) {\n    // find the default location for the product site\n    const defaultLocation = productSite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n    if (defaultLocation &&\n        defaultLocation.node.defaultLocation &&\n        !defaultLocation.node.defaultLocation.match(/[* ! # ?]/))\n        return defaultLocation.node.defaultLocation;\n    // find the default location for the product category site\n    const ProductCategorySite = await _readProductCategorySite(productSite.stockSite.code, productSite.product.productCategory.code, pageInstance);\n    if (ProductCategorySite) {\n        const defaultLocationCateg = ProductCategorySite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n        if (defaultLocationCateg &&\n            defaultLocationCateg.node.defaultLocation &&\n            !defaultLocationCateg.node.defaultLocation.match(/[* ! # ?]/))\n            return defaultLocationCateg.node.defaultLocation;\n    }\n    return null;\n}\nexports.findDefaultLocation = findDefaultLocation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/stock-management-rules.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-pick-ticket-view-pick-ticket-line-global.ts":
/*!**********************************************************************!*\
  !*** ./lib/pages/mobile-pick-ticket-view-pick-ticket-line-global.ts ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nvar MobilePickTicketViewPickTicketLineGlobal_1;\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobilePickTicketViewPickTicketLineGlobal = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_count_serial_number_1 = __webpack_require__(/*! @sage/x3-stock-data/lib/client-functions/get-count-serial-number */ \"../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\");\nconst pat_converter_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/pat-converter */ \"../../shared/x3-system/lib/shared-functions/pat-converter.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst manage_pages_1 = __webpack_require__(/*! ../client-functions/manage-pages */ \"./lib/client-functions/manage-pages.ts\");\nconst stock_management_rules_1 = __webpack_require__(/*! ../client-functions/stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\nconst hideWhenEmptyValue = (value, rowValue) => {\n    return typesLib.strictNe(typeof value, 'number') && !value; // we don't want to hide numeric field with value of 0\n};\nlet MobilePickTicketViewPickTicketLineGlobal = class MobilePickTicketViewPickTicketLineGlobal extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this._stockFieldSettings = [];\n        this._unavailableStock = [];\n    }\n    static { MobilePickTicketViewPickTicketLineGlobal_1 = this; }\n    static { this.TRANSACTION_KEY = 'mobile-pick-ticket-entry-transaction'; }\n    static { this.DESTINATION_KEY = 'mobile-pick-ticket-destination-location'; }\n    static { this.DESTINATION_DISPLAY_KEY = 'mobile-pick-ticket-destination-location-display'; }\n    static { this.PICK_LIST_KEY = 'mobile-pick-ticket-pick-list'; }\n    static { this.PICK_TICKET_KEY = 'mobile-pick-ticket'; }\n    static { this.PICK_TICKET_LINE_KEY = 'mobile-pick-ticket-line'; }\n    async _getUnavailableStock() {\n        const response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-stock-data/Stock')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            activeQuantityInStockUnit: true,\n            allocatedActiveQuantity: true,\n            inProcessActiveQuantity: true,\n        }, {\n            filter: {\n                ...(0, manage_pages_1.generateStockTableFilter)(this),\n                ...{ location: { category: { _nin: ['subcontract', 'customer'] } } },\n                ...{ qualityAnalysisRequestId: { _eq: '' } },\n                ...{\n                    _fn: 'this.activeQuantityInStockUnit <= this.allocatedActiveQuantity + this.inProcessActiveQuantity',\n                },\n            },\n            first: 1000,\n        }))\n            .execute());\n        return response\n            .filter(stock => typesLib.lte(stock.activeQuantityInStockUnit, typesLib.add(stock.allocatedActiveQuantity, stock.inProcessActiveQuantity)))\n            .map(stock => {\n            return stock._id;\n        });\n    }\n    /*\n     *\n     *  Init functions\n     *\n     */\n    async _init() {\n        this.pickTicket.value = this.$.storage.get(MobilePickTicketViewPickTicketLineGlobal_1.PICK_TICKET_KEY).toString();\n        this.pickTicketLine.value = this.$.storage\n            .get(MobilePickTicketViewPickTicketLineGlobal_1.PICK_TICKET_LINE_KEY)\n            .toString();\n        this.stockSite.value = this.$.storage.get('mobile-selected-stock-site').toString();\n        this.pickList.value = this.$.storage.get(MobilePickTicketViewPickTicketLineGlobal_1.PICK_LIST_KEY).toString();\n        this.transaction.value = this.$.storage\n            .get(MobilePickTicketViewPickTicketLineGlobal_1.TRANSACTION_KEY)\n            .toString();\n        this.locationDestination.value = {\n            code: this.$.storage.get(MobilePickTicketViewPickTicketLineGlobal_1.DESTINATION_KEY).toString(),\n        };\n        this._mobileSettings = JSON.parse(this.$.queryParameters?.mobileSettings);\n        this._pickTicketLine = await this._getPickTicketLine();\n        this._productSite = await this._getProductSite(this._pickTicketLine.product.code);\n        this._transaction = await this._getTransaction(this.transaction.value);\n        this._stockSite = { code: this.stockSite.value };\n        this.stockUnit.value = this._productSite.product.stockUnit.code;\n        await this._getUnitDestinations(this._pickTicketLine.product.code);\n        this._currentPickStockLine = 0;\n        this._initTechnicalProperties();\n        await this._fieldsManagement();\n        this._pickStockLines = this.$.queryParameters.pickStockLines\n            ? JSON.parse(this.$.queryParameters.pickStockLines)\n            : [];\n        this._pickStockLines.forEach(pickStockLine => {\n            const _stock = this.stock.value.find(item => (pickStockLine.stockId && typesLib.strictEq(Number(pickStockLine.stockId), Number(item.stockId))) ||\n                (!pickStockLine.stockId &&\n                    (!pickStockLine.packingUnit || typesLib.strictEq(pickStockLine.packingUnit, item.packingUnit?.code)) &&\n                    (!pickStockLine.location || typesLib.strictEq(pickStockLine.location, item.location?.code)) &&\n                    (!pickStockLine.lot || typesLib.strictEq(pickStockLine.lot, item.lot)) &&\n                    (!pickStockLine.sublot || typesLib.strictEq(pickStockLine.sublot, item.sublot)) &&\n                    (!pickStockLine.serialNumber || typesLib.strictEq(pickStockLine.serialNumber, item.serialNumber)) &&\n                    (!pickStockLine.status || typesLib.strictEq(pickStockLine.status, item.status?.code))));\n            if (_stock) {\n                const _record = this.stock.getRecordValue(_stock._id);\n                if (_record) {\n                    this.stock.selectRecord(_stock._id);\n                }\n            }\n        });\n        this._displayPickedQuantity();\n        this.pickButton.isHidden = true;\n        this.shortageSwitch.isDisabled = true;\n    }\n    _displayPickedQuantity() {\n        this.titleQuantityToPick.value = 'Quantity to pick:';\n        this.quantityToPick.value = `${Number(this._pickTicketLine.quantityInStockUnit).toFixed(this._pickTicketLine.stockUnit?.numberOfDecimals)} ${this.stockUnit.value}`;\n        this.pickedQuantity.value = `Picked quantity: ${Number(this._getPickedQuantityInStockUnit()).toFixed(this._pickTicketLine.stockUnit?.numberOfDecimals)} ${this.stockUnit.value}`;\n        this._quantityToPick = typesLib.sub(Number(this._pickTicketLine.quantityInStockUnit), Number(this._getPickedQuantityInStockUnit()));\n    }\n    _getPickedQuantityInStockUnit() {\n        let pickedQuantity;\n        pickedQuantity = 0;\n        this._pickStockLines.forEach(pickStockLine => {\n            pickedQuantity = typesLib.add(pickedQuantity, pickStockLine.quantityInStockUnit);\n        });\n        return pickedQuantity;\n    }\n    _getPickedQuantityInStockInStockUnit() {\n        let pickedQuantity;\n        pickedQuantity = 0;\n        this._pickStockLines.forEach(pickStockLine => {\n            if (typesLib.strictEq(Number(pickStockLine.stockId), Number(this.stock.getRecordValue(this.gridBlock.selectedRecordId)?.stockId))) {\n                pickedQuantity = typesLib.add(pickedQuantity, pickStockLine.quantityInStockUnit);\n            }\n        });\n        return pickedQuantity;\n    }\n    _getQuantityInStockUnitToPick() {\n        return typesLib.min(typesLib.sub(Number(this.stock.getRecordValue(this.gridBlock.selectedRecordId)?.availableQuantityInStockUnit), (typesLib.strictEq(this.product.value?.serialNumberManagementMode, 'receivedIssued') ? 0\n            : this._getPickedQuantityInStockInStockUnit())), typesLib.sub(Number(this._pickTicketLine.quantityInStockUnit), (typesLib.strictEq(this.product.value?.serialNumberManagementMode, 'receivedIssued') ? 0\n            : this._getPickedQuantityInStockUnit())));\n    }\n    _getQuantityInPackingUnitToPick() {\n        return (typesLib.div(this._getQuantityInStockUnitToPick(), Number(this.packingUnitToStockUnitConversionFactorDestination.value)));\n    }\n    async _getPickTicketLine() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/PickTicketLine')\n            .query(ui.queryUtils.edgesSelector({\n            pickTicket: true,\n            pickTicketLine: true,\n            product: {\n                code: true,\n                localizedDescription1: true,\n                lotManagementMode: true,\n                serialNumberManagementMode: true,\n                isNegativeStockAuthorized: true,\n            },\n            quantityInStockUnit: true,\n            stockUnit: {\n                code: true,\n                numberOfDecimals: true,\n            },\n            packingUnitToStockUnitConversionFactor: true,\n            packingUnit: {\n                code: true,\n                numberOfDecimals: true,\n            },\n            allocatedQuantity: true,\n            shortageQuantity: true,\n            adcPickedLine: true,\n            allocatedLines: {\n                query: {\n                    edges: {\n                        node: {\n                            stockId: true,\n                            quantityInStockUnit: true,\n                            serialNumber: true,\n                            allocationType: true,\n                            stockLine: {\n                                lot: true,\n                                status: { code: true },\n                                sublot: true,\n                                serialNumber: true,\n                                location: {\n                                    code: true,\n                                },\n                                quantityInPackingUnit: true,\n                                quantityInStockUnit: true,\n                                packingUnitToStockUnitConversionFactor: true,\n                                packingUnit: {\n                                    code: true,\n                                },\n                                licensePlateNumber: { code: true },\n                                identifier1: true,\n                                identifier2: true,\n                            },\n                        },\n                    },\n                    __args: {\n                        first: 500,\n                    },\n                },\n            },\n        }, {\n            filter: {\n                pickTicket: { _eq: this.pickTicket.value },\n                pickTicketLine: Number(this.pickTicketLine.value),\n            },\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/notification-error-no-pick-ticket-line', 'Pick ticket line does not exist'));\n        }\n        return response.edges[0].node;\n    }\n    async _getProductSite(productCode) {\n        const response = await this.$.graph\n            .node('@sage/x3-master-data/ProductSite')\n            .query(ui.queryUtils.edgesSelector({\n            isLocationManaged: true,\n            isLicensePlateNumberManaged: true,\n            defaultInternalContainer: {\n                code: true,\n            },\n            stockSite: {\n                code: true,\n            },\n            product: {\n                code: true,\n                localizedDescription1: true,\n                lotManagementMode: true,\n                serialNumberManagementMode: true,\n                stockVersionMode: true,\n                expirationManagementMode: true,\n                serialSequenceNumber: true,\n                lotSequenceNumber: true,\n                stockManagementMode: true,\n                defaultPotencyInPercentage: true,\n                expirationLeadTime: true,\n                expirationTimeUnit: true,\n                useByDateCoefficient: true,\n                isNegativeStockAuthorized: true,\n                stockUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                productCategory: {\n                    code: true,\n                },\n                packingUnits: {\n                    query: {\n                        edges: {\n                            node: {\n                                packingUnit: {\n                                    code: true,\n                                    numberOfDecimals: true,\n                                },\n                                packingUnitToStockUnitConversionFactor: true,\n                                isPackingFactorEntryAllowed: true,\n                            },\n                        },\n                    },\n                },\n            },\n        }, {\n            filter: {\n                product: {\n                    code: productCode,\n                },\n                stockSite: {\n                    code: this.stockSite.value,\n                },\n            },\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/notification-error-no-product-site', 'Product site does not exist'));\n        }\n        return response.edges[0].node;\n    }\n    async _getUnitDestinations(productCode) {\n        const response = await this.$.graph\n            .node('@sage/x3-master-data/ProductPackingUnits')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n            packingUnit: {\n                code: true,\n            },\n        }, {\n            filter: {\n                code: productCode,\n            },\n        }))\n            .execute();\n        const options = [];\n        options.push(this.stockUnit.value);\n        if (response.edges && typesLib.gt(response.edges.length, 0)) {\n            response.edges.forEach(edge => {\n                options.push(edge.node.packingUnit.code);\n            });\n        }\n        this.packingUnit.options = options;\n        this.packingUnitDestination.options = options;\n    }\n    async _getTransaction(transactionCode) {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/StockEntryTransaction')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n            isEnterableDestinationLocation: true,\n            identifier1Destination: true,\n            identifier2Destination: true,\n            stockMovementCode: {\n                code: true,\n            },\n        }, {\n            filter: {\n                transactionType: 'pickTickets',\n                code: transactionCode,\n                isActive: true,\n            },\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/notification-error-no-transaction', 'Transaction does not exist'));\n        }\n        return response.edges[0].node;\n    }\n    async _getLastLine() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/PickTicketLine')\n            .aggregate.read({\n            _id: {\n                distinctCount: true,\n            },\n        }, {\n            filter: {\n                pickTicket: { _eq: this.pickTicket.value },\n                pickTicketLine: { _ne: Number(this.pickTicketLine.value) },\n                adcPickedLine: { _eq: 0 },\n            },\n        })\n            .execute();\n        return typesLib.strictEq(response._id?.distinctCount, 0);\n    }\n    async _getShortage() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/PickTicketLine')\n            .aggregate.read({\n            _id: {\n                distinctCount: true,\n            },\n        }, {\n            filter: {\n                pickTicket: { _eq: this.pickTicket.value },\n                //   product: { isNegativeStockAuthorized: false },\n                shortageQuantity: { _ne: '0' },\n            },\n        })\n            .execute();\n        return typesLib.strictNe(response._id?.distinctCount, 0);\n    }\n    async _getLastTicket() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/PickList')\n            .aggregate.read({\n            _id: {\n                distinctCount: true,\n            },\n        }, {\n            filter: {\n                preparationList: { _eq: this.pickList.value },\n                _or: [\n                    {\n                        pickTicketLine: {\n                            pickTicket: { _ne: this.pickTicket.value },\n                        },\n                    },\n                    {\n                        pickTicketLine: {\n                            pickTicketLine: { _ne: Number(this.pickTicketLine.value) },\n                        },\n                    },\n                ],\n                pickTicketLine: {\n                    adcPickedLine: { _eq: 0 },\n                },\n            },\n        })\n            .execute();\n        return typesLib.strictEq(response._id?.distinctCount, 0);\n    }\n    _initTechnicalProperties() {\n        this.product.value = {\n            code: this._productSite.product.code,\n            serialNumberManagementMode: this._productSite.product.serialNumberManagementMode,\n            lotManagementMode: this._productSite.product.lotManagementMode,\n            expirationManagementMode: this._productSite.product.expirationManagementMode,\n            stockUnit: {\n                code: this._productSite.product.stockUnit.code,\n                numberOfDecimals: this._productSite.product.stockUnit.numberOfDecimals,\n            },\n            isNegativeStockAuthorized: this._productSite.product.isNegativeStockAuthorized,\n        };\n        this.localizedDescription1.value = this._productSite.product.localizedDescription1;\n    }\n    /*\n     *\n     *  Fields management functions\n     *\n     */\n    async _onRowClick(recordId, rowItem) {\n        this.stockDetails.value = [rowItem]; // populate details list\n        this.gridBlock.selectedRecordId = recordId; // populate grid row block\n        this._stockId.value = rowItem.stockId;\n        const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n        if (typesLib.strictEq(this.product.value.serialNumberManagementMode, 'receivedIssued')) {\n            const currentPickStockLine = this._pickStockLines.findIndex(line => typesLib.strictEq(Number(line.stockId), Number(rowItem.stockId)));\n            if (typesLib.strictNe(currentPickStockLine, -1)) {\n                this._currentPickStockLine = currentPickStockLine;\n                this.stockUnit.value = currentRecord?.product?.product?.stockUnit.code ?? null;\n                this.quantityInStockUnitDestination.value = this._getQuantityInStockUnitToPick();\n                this.packingUnitDestination.value = currentRecord?.packingUnit?.code;\n                this.packingUnitDestinationDecimales.value = currentRecord?.packingUnit?.numberOfDecimals;\n                this.packingUnitToStockUnitConversionFactorDestination.value = Number(currentRecord?.packingUnitToStockUnitConversionFactor);\n                this.quantityInPackingUnitDestination.value = this._getQuantityInPackingUnitToPick();\n                this._stockId.value = currentRecord?.stockId ?? null;\n                await this.$.commitValueAndPropertyChanges();\n                await this.stock.validateWithDetails();\n                this.$.detailPanel.isHidden = false;\n                this.pickButton.isHidden = false;\n                return;\n            }\n        }\n        if (this._pickStockLines.find(line => typesLib.strictEq(Number(line.stockId), Number(rowItem.stockId)))) {\n            return;\n        }\n        this._pickStockLines.push({\n            packingUnit: currentRecord?.packingUnit?.code, //rowItem.packingUnit.code,\n            quantityInPackingUnit: 0, // Number(currentRecord?.quantityInPackingUnit), //Number(rowItem.quantityInPackingUnit),\n            packingUnitToStockUnitConversionFactor: Number(currentRecord?.packingUnitToStockUnitConversionFactor), //Number(rowItem.packingUnitToStockUnitConversionFactor),\n            quantityInStockUnit: 0, // Number(currentRecord?.quantityInStockUnit), //Number(rowItem.quantityInStockUnit),\n            location: currentRecord?.location?.code,\n            lot: currentRecord?.lot,\n            sublot: currentRecord?.sublot,\n            serialNumber: currentRecord?.serialNumber,\n            status: currentRecord?.status?.code,\n            stockId: Number(currentRecord?.stockId),\n        });\n        this._currentPickStockLine = typesLib.sub(this._pickStockLines.length, 1);\n        this.stockUnit.value = currentRecord?.product?.product?.stockUnit.code ?? null;\n        this.quantityInStockUnitDestination.value = this._getQuantityInStockUnitToPick();\n        this.packingUnitDestination.value = currentRecord?.packingUnit?.code;\n        this.packingUnitDestinationDecimales.value = currentRecord?.packingUnit?.numberOfDecimals;\n        this.packingUnitToStockUnitConversionFactorDestination.value = Number(currentRecord?.packingUnitToStockUnitConversionFactor);\n        this.quantityInPackingUnitDestination.value = this._getQuantityInPackingUnitToPick();\n        this._stockId.value = currentRecord?.stockId ?? null;\n        if (typesLib.strictEq(this.product.value.serialNumberManagementMode, 'globalReceivedIssued')) {\n            this.serialNumberLines.isHidden = false;\n            this.serialNumberLines.value = [];\n            this._pickStockLines.forEach(line => {\n                if (typesLib.strictEq(Number(line.stockId), Number(rowItem.stockId)) && line.serialNumber) {\n                    this.serialNumberLines.addRecord({\n                        quantity: Number(line.quantityInPackingUnit),\n                        startingSerialNumber: line.serialNumber,\n                        endingSerialNumber: Number(this._calculateEndingSerialNumber(line.serialNumber, Number(line.quantityInPackingUnit)).match(/\\d+$/)),\n                    });\n                }\n            });\n        }\n        await this.$.commitValueAndPropertyChanges();\n        await this.stock.validateWithDetails();\n        this.$.detailPanel.isHidden = false;\n        this.pickButton.isHidden = false;\n    }\n    async _fieldsManagement() {\n        this._lotManagement();\n        await this._miscellaneousFieldsManagement();\n        this._serialNumberManagement();\n        let productPackingList = (0, xtrem_client_1.extractEdges)(this._productSite.product.packingUnits.query).filter(productPacking => {\n            return !!productPacking.packingUnit?.code;\n        });\n        this._packingUnits = productPackingList.map(productPacking => {\n            return { node: productPacking };\n        });\n    }\n    async onChangeBody() {\n        let currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n        let currentQty = Number(this.quantityInPackingUnitDestination.value);\n        if (!currentQty || !this.startingSerialNumber.value) {\n            this.endingSerialNumber.value = null;\n            return;\n        }\n        this.startingSerialNumber.value.code = this.startingSerialNumber.value.code.toUpperCase();\n        if (typesLib.gt(currentQty, 1)) {\n            this.endingSerialNumber.value = this._calculateEndingSerialNumber(this.startingSerialNumber.value.code, currentQty);\n        }\n        else {\n            this.endingSerialNumber.value = this.startingSerialNumber.value.code;\n        }\n        if (await this._isSerialNumberAllocated(this.startingSerialNumber.value.code, this.endingSerialNumber.value)) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_lines__the_serial_number_already_allocated', 'Serial number already allocated.'));\n            this.startingSerialNumber.value = null;\n            this.endingSerialNumber.value = null;\n            this.startingSerialNumber.focus();\n            return;\n        }\n        if (typesLib.gt(currentQty, currentRecord.quantityInPackingUnit))\n            this.addSerialRange.isHidden = true;\n        else {\n            this.addSerialRange.isHidden = false;\n        }\n        await this.$.commitValueAndPropertyChanges();\n        let validationResult;\n        if ((validationResult = await this.endingSerialNumber.validate())) {\n            this.$.showToast(validationResult, { type: 'warning' });\n        }\n    }\n    _lotManagement() {\n        const lotNotManaged = typesLib.strictEq(this._productSite.product.lotManagementMode, 'notManaged');\n        this.lot.isHidden = lotNotManaged;\n        this.sublot.isHidden = lotNotManaged;\n        this.sublot.isHidden = typesLib.strictNe(this._productSite.product.lotManagementMode, 'lotAndSublot');\n    }\n    async _miscellaneousFieldsManagement() {\n        if (!(this.lot.isHidden || !!this._productSite.product.lotSequenceNumber) &&\n            ['lotAndSublot', 'mandatoryLot'].includes(this._productSite.product.lotManagementMode))\n            this.lot.isMandatory = true;\n        this._selectedStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(this.stockSite.value, this._productSite.product.productCategory.code, '26', this._transaction.stockMovementCode?.code, this);\n        this.status.options = await this._getStockStatus();\n    }\n    _serialNumberManagement() {\n        this.serialNumber.isHidden = ['notManaged', 'issued'].includes(this._productSite.product.serialNumberManagementMode);\n        if (['receivedIssued', 'globalReceivedIssued'].includes(this._productSite.product.serialNumberManagementMode)) {\n            if (typesLib.strictEq(this.lot.isHidden, false))\n                this.lot.isMandatory = false;\n            if (typesLib.strictEq(this.sublot.isHidden, false))\n                this.sublot.isMandatory = false;\n            if (typesLib.strictEq(this.status.isHidden, false))\n                this.status.isMandatory = false;\n            if (typesLib.strictEq(this.packingUnit.isHidden, false))\n                this.packingUnit.isMandatory = false;\n            if (typesLib.strictEq(this.packingUnitDestination.isHidden, false))\n                this.packingUnitDestination.isHidden = true;\n            if (typesLib.strictEq(this.packingUnitToStockUnitConversionFactorDestination.isHidden, false))\n                this.packingUnitToStockUnitConversionFactorDestination.isHidden = true;\n        }\n    }\n    /*\n     *\n     *  record management functions\n     *\n     */\n    _getQuantityInPackingUnitDestination(record) {\n        if (record.quantityInPackingUnitDestination) {\n            return Number(record.quantityInPackingUnitDestination);\n        }\n        else {\n            const packingUnitToStockUnitConversionFactor = Number(this._getPackingUnitToStockUnitConversionFactorDestination(record));\n            return packingUnitToStockUnitConversionFactor\n                ? typesLib.div(Number(this._getQuantityInStockUnitDestination(record)), Number(packingUnitToStockUnitConversionFactor)) : Number(this._getQuantityInStockUnitDestination(record));\n        }\n    }\n    _getQuantityInStockUnitDestination(record) {\n        if (record.quantityInStockUnitDestination) {\n            return Number(record.quantityInStockUnitDestination);\n        }\n        else {\n            let quantity;\n            quantity = this._getAvailableQuantityInStockUnit(record);\n            const pickStockLines = this.$.queryParameters.pickStockLines\n                ? JSON.parse(this.$.queryParameters.pickStockLines)\n                : [];\n            const pickStockLine = pickStockLines.find(item => (item.stockId && typesLib.strictEq(Number(item.stockId), Number(record.stockId))) ||\n                (!item.stockId &&\n                    (!item.packingUnit || typesLib.strictEq(item.packingUnit, record.packingUnit?.code)) &&\n                    (!item.location || typesLib.strictEq(item.location, record.location?.code)) &&\n                    (!item.lot || typesLib.strictEq(item.lot, record.lot)) &&\n                    (!item.sublot || typesLib.strictEq(item.sublot, record.sublot)) &&\n                    (!item.serialNumber || typesLib.strictEq(item.serialNumber, record.serialNumber)) &&\n                    (!item.status || typesLib.strictEq(item.status, record.status?.code))));\n            if (pickStockLine) {\n                quantity = Number(pickStockLine.quantityInStockUnit);\n            }\n            return quantity;\n        }\n    }\n    _getAvailableQuantityInPackingUnit(record) {\n        const packingUnitToStockUnitConversionFactor = Number(this._getPackingUnitToStockUnitConversionFactorDestination(record));\n        return packingUnitToStockUnitConversionFactor\n            ? typesLib.div(Number(this._getAvailableQuantityInStockUnit(record)), Number(packingUnitToStockUnitConversionFactor)) : Number(record.quantityInPackingUnit);\n    }\n    _getAvailableQuantityInStockUnit(record) {\n        if (record.availableQuantityInStockUnit) {\n            return Number(record.availableQuantityInStockUnit);\n        }\n        else {\n            return typesLib.sub(Number(record.quantityInStockUnit), Number(record.allocatedQuantity));\n        }\n    }\n    _getPackingUnitToStockUnitConversionFactorDestination(record) {\n        if (record.packingUnitToStockUnitConversionFactorDestination) {\n            return Number(record.packingUnitToStockUnitConversionFactorDestination);\n        }\n        else {\n            return Number(record.packingUnitToStockUnitConversionFactor);\n        }\n    }\n    _getPackingUnitDestination(record) {\n        if (record.packingUnitDestination) {\n            return record.packingUnitDestination;\n        }\n        else {\n            return record.packingUnit;\n        }\n    }\n    _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n        return startingSerialNumber.replace(/\\d+$/, match => {\n            const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n            const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n            return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n        });\n    }\n    async _isSerialNumberAllocated(startingSerialNumber, endingSerialNumber) {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/Allocation')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            serialNumber: true,\n            quantityInStockUnit: true,\n        }, {\n            filter: {\n                stockSite: { code: this.stockSite.value },\n                product: { code: this.product.value?.code },\n            },\n            first: 500,\n        }))\n            .execute();\n        let result;\n        result = false;\n        response.edges.forEach(item => {\n            if ((typesLib.gte(startingSerialNumber, item.node.serialNumber) && typesLib.lte(startingSerialNumber, this._calculateEndingSerialNumber(item.node.serialNumber, Number(item.node.quantityInStockUnit)))) ||\n                (typesLib.gte(endingSerialNumber, item.node.serialNumber) && typesLib.lte(endingSerialNumber, this._calculateEndingSerialNumber(item.node.serialNumber, Number(item.node.quantityInStockUnit)))) ||\n                (typesLib.gte(item.node.serialNumber, startingSerialNumber) && typesLib.lte(item.node.serialNumber, endingSerialNumber))) {\n                result = true;\n            }\n        });\n        return result;\n    }\n    async _getStockStatus() {\n        const selectedStatus = [];\n        this._selectedStockManagementRules.authorizedSubstatus.split(',').forEach(function (status) {\n            selectedStatus.push({ _regex: (0, pat_converter_1.getRegExp)(status).source });\n        });\n        const response = await this.$.graph\n            .node('@sage/x3-stock-data/StockStatus')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n        }, {\n            filter: {\n                code: { _or: selectedStatus },\n            },\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/pages__mobile_stock_change_details__notification__invalid_stock_status_error', 'No stock status'));\n        }\n        return response.edges.map((stockStatus) => stockStatus.node.code);\n    }\n    async onChangeLot() {\n        if (!this.lot.value) {\n            this.stock.filter = {\n                ...this.stock.filter,\n                lot: undefined,\n                ...(typesLib.strictEq(this.product.value?.lotManagementMode, 'lotAndSublot') && { sublot: undefined }),\n            };\n            if (!this.sublot.isHidden) {\n                this.sublot.value = null;\n            }\n            return;\n        }\n        if (!this.sublot.isHidden) {\n            this.sublot.value = this.lot.value; // update sublot field if available, for display purposes only\n        }\n        this.stock.filter = {\n            ...this.stock.filter,\n            lot: this.lot.value.lot,\n            ...(this.lot.value?.sublot && { sublot: this.lot.value.sublot }),\n        };\n        this.lot.getNextField(true)?.focus();\n    }\n    async _processPickPicket(isShortPick) {\n        this.$.storage.set(MobilePickTicketViewPickTicketLineGlobal_1.DESTINATION_KEY, this.locationDestination.value ? this.locationDestination.value.code : '');\n        let isDeliverable;\n        isDeliverable = false;\n        let isNotSetDelivrable;\n        isNotSetDelivrable = false;\n        const isLastLine = await this._getLastLine();\n        const isLastTicket = this.pickList.value ? await this._getLastTicket() : true;\n        if (isLastLine) {\n            isDeliverable = await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-stock/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-stock/dialog-confirmation-set-the-pick-ticket-to-deliverable', `Set the pick ticket to 'Deliverable' ?`), {\n                fullScreen: true,\n                acceptButton: {\n                    text: ui.localize('@sage/x3-stock/button-accept-yes', 'Yes'),\n                },\n                cancelButton: {\n                    text: ui.localize('@sage/x3-stock/button-cancel-no', 'No'),\n                },\n            });\n        }\n        if (isDeliverable) {\n            if (!this.product.value.isNegativeStockAuthorized && (isShortPick || (await this._getShortage()))) {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_lines__the_picking_line_is_in_shortage_and_negative_stock_is_prohibited', 'The picking line is in shortage and negative stock is prohibited.'));\n                isDeliverable = false;\n                isNotSetDelivrable = true;\n            }\n            else if (isShortPick && this.locationDestination.value && typesLib.ne(this.locationDestination.value.code, '')) {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_lines__a_location_can_not_be_modified_for_a_stock_out_line', 'A location can not be modified for a stock-out line.'));\n                isDeliverable = false;\n                isNotSetDelivrable = true;\n            }\n        }\n        const result = await this._callProcessPickAPI(isDeliverable, isShortPick);\n        this.$.loader.isHidden = true;\n        if (!result || result instanceof Error) {\n            const options = {\n                acceptButton: {\n                    text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                },\n                cancelButton: {\n                    text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                },\n                size: 'small',\n                mdContent: true,\n            };\n            let message = '';\n            if (!result?.message) {\n                await this.$.sound.error();\n                if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.'), options)) {\n                    await this.$.router.refresh();\n                }\n                else {\n                    await this.$.router.emptyPage();\n                    this.$.router.goTo('@sage/x3-stock/MobilePickTicket');\n                }\n                return;\n            }\n            else {\n                const _messages = [];\n                const _results = result;\n                let _diagnoses = _results?.diagnoses;\n                if (typesLib.gt(_diagnoses?.length, 1)) {\n                    _diagnoses = _diagnoses.splice(0, typesLib.sub(_diagnoses.length, 1));\n                }\n                ((_results?.errors\n                    ? _results.errors[0]?.extensions?.diagnoses\n                    : (_results?.innerError?.errors[0]?.extensions?.diagnoses ??\n                        _results.extensions?.diagnoses ??\n                        _diagnoses)) ?? [])\n                    .filter((d) => typesLib.gt(d.severity, 2) && d.message)\n                    .forEach((d) => {\n                    const _message = d.message.split(`\\n`);\n                    _messages.push(..._message);\n                });\n                const _result = _messages.length ? _messages : result.message.split(`\\n`);\n                message = `**${ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_line__notification__update_error', 'An error has occurred')}**\\n\\n`;\n                if (typesLib.strictEq(_result.length, 1)) {\n                    message = typesLib.add(message, `${_result[0]}`);\n                }\n                else {\n                    message = typesLib.add(message, _result.map(item => `* ${item}`).join('\\n'));\n                }\n                if (result instanceof Error) {\n                    this.$.loader.isHidden = true;\n                }\n            }\n            await this.$.sound.error();\n            if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), message, options)) {\n                return;\n            }\n            await this.$.router.emptyPage();\n            this.$.router.goTo('@sage/x3-stock/MobilePickTicket');\n        }\n        else {\n            this.$.storage.remove(MobilePickTicketViewPickTicketLineGlobal_1.PICK_TICKET_LINE_KEY);\n            if (isLastLine) {\n                await (0, dialogs_1.dialogMessage)(this, 'info', ui.localize('@sage/x3-stock/dialog-information-title', 'Information'), isNotSetDelivrable\n                    ? ui.localize('@sage/x3-stock/dialog-message-pick-ticket-has-been-submitted-but-not-set-as-deliverable', 'The pick ticket has been updated but it is not set as deliverable.')\n                    : isDeliverable\n                        ? ui.localize('@sage/x3-stock/dialog-message-pick-ticket-is-deliverable', 'The pick ticket is now set as deliverable.')\n                        : ui.localize('@sage/x3-stock/dialog-message-pick-ticket-not-deliverable', 'The pick ticket is not set as deliverable.'));\n            }\n            this.$.setPageClean();\n            await this.$.sound.success();\n            if (isLastLine && isLastTicket) {\n                this.$.router.goTo('@sage/x3-stock/MobilePickTicket');\n            }\n            else if (typesLib.strictEq(this.pickList.value, '')) {\n                this.$.router.goTo('@sage/x3-stock/MobilePickTicketSelectFromTicket', {\n                    mobileSettings: JSON.stringify(this._mobileSettings),\n                });\n            }\n            else {\n                this.$.router.goTo('@sage/x3-stock/MobilePickTicketSelectFromList', {\n                    mobileSettings: JSON.stringify(this._mobileSettings),\n                });\n            }\n        }\n    }\n    async _callProcessPickAPI(isDeliverable, isShortPick) {\n        this.$.loader.isHidden = false;\n        const _packingUnit = [];\n        const _packingUnitToStockUnitConversionFactor = [];\n        const _quantityInPackingUnit = [];\n        const _quantityInStockUnit = [];\n        const _location = [];\n        const _lot = [];\n        const _sublot = [];\n        const _serialNumber = [];\n        const _status = [];\n        const _stockId = [];\n        this._pickStockLines.forEach(pickStockLine => {\n            _packingUnit.push(pickStockLine.packingUnit);\n            _packingUnitToStockUnitConversionFactor.push(pickStockLine.packingUnitToStockUnitConversionFactor);\n            _quantityInPackingUnit.push(pickStockLine.quantityInPackingUnit);\n            _quantityInStockUnit.push(pickStockLine.quantityInStockUnit);\n            _location.push(pickStockLine.location ?? '');\n            _lot.push(pickStockLine.lot ?? '');\n            _sublot.push(pickStockLine.sublot ?? '');\n            _serialNumber.push(pickStockLine.serialNumber ?? '');\n            _status.push(pickStockLine.status);\n            _stockId.push(pickStockLine.stockId);\n        });\n        const pickTicketArgs = {\n            entryTransaction: this.transaction.value,\n            pickTicket: this._pickTicketLine.pickTicket,\n            pickTicketLine: this._pickTicketLine.pickTicketLine,\n            destinationLocation: this.locationDestination.value ? this.locationDestination.value.code : '',\n            product: this.product.value?.code,\n            shortPick: isShortPick,\n            deliverable: isDeliverable,\n            documentDestination: this.$.storage.get('mobile-document-destination') ?? '',\n            packingUnit: _packingUnit,\n            packingUnitToStockUnitConversionFactor: _packingUnitToStockUnitConversionFactor,\n            quantityInPackingUnit: _quantityInPackingUnit,\n            quantityInStockUnit: _quantityInStockUnit,\n            location: _location,\n            lot: _lot,\n            sublot: _sublot,\n            serialNumber: _serialNumber,\n            status: _status,\n            stockId: _stockId,\n            customBoolean: this.customBoolean.value ? this.customBoolean.value : null,\n            customDecimal: this.customDecimal.value ? this.customDecimal.value : null,\n            customString: this.customString.value ? this.customString.value : null,\n            customDate: this.customDate.value ? this.customDate.value : null,\n        };\n        try {\n            return await this.$.graph\n                .node('@sage/x3-stock/PickTicketLine')\n                .mutations.updatePickTicketLine({ pickTicket: true, pickTicketLine: true }, { parameters: pickTicketArgs })\n                .execute();\n        }\n        catch (error) {\n            return error;\n        }\n    }\n};\nexports.MobilePickTicketViewPickTicketLineGlobal = MobilePickTicketViewPickTicketLineGlobal;\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__pickTicket____title\", \"Pick ticket\"),\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"pickTicket\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__pickTicketLine____title\", \"Line\"),\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"pickTicketLine\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"localizedDescription1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"stockSite\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"transaction\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"pickList\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"quantityToPick\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"titleQuantityToPick\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        isTransient: false,\n        isTitleHidden: true,\n        isDisabled: true,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.select({\n                bind: 'lotManagementMode',\n                optionType: '@sage/x3-stock-data/LotManagementMode',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'serialNumberManagementMode',\n                optionType: '@sage/x3-master-data/SerialNumberManagement',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'expirationManagementMode',\n                optionType: '@sage/x3-master-data/ExpirationManagement',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'stockVersionMode',\n                optionType: '@sage/x3-stock-data/StockVersionMode',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                bind: 'stockUnit',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                bind: 'stockUnit',\n                valueField: 'numberOfDecimals',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isNegativeStockAuthorized',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        bind: 'isLocationManaged',\n        isTransient: false,\n        isHidden: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"isLocationManaged\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        bind: 'isLicensePlateNumberManaged',\n        isTransient: false,\n        isHidden: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"isLicensePlateNumberManaged\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__pickButton____title\", \"Submit\"),\n        shortcut: ['f2'],\n        buttonType: 'primary',\n        async onClick() {\n            if (typesLib.strictEq(this.product.value.serialNumberManagementMode, 'globalReceivedIssued')) {\n                if (!this.serialNumberLines.value.length) {\n                    await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_lines__notification__error_startingSerialNumberMandatory', 'You need to select the serial number and add it first.'));\n                    return;\n                }\n            }\n            else {\n                if (typesLib.lte(Number(this.quantityInPackingUnitDestination.value), 0)) {\n                    await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_lines__quantityInPackingUnitDestination_must_be_greater_than_0', 'The quantity to move must be greater than 0.'));\n                    return;\n                }\n            }\n            if (typesLib.strictEq(this.product.value.serialNumberManagementMode, 'globalReceivedIssued')) {\n                this._pickStockLines.pop();\n                this._currentPickStockLine = typesLib.sub(this._pickStockLines.length, 1);\n            }\n            else {\n                this._pickStockLines[this._currentPickStockLine].packingUnit =\n                    this.packingUnitDestination.value ?? undefined;\n                this._pickStockLines[this._currentPickStockLine].quantityInPackingUnit = Number(this.quantityInPackingUnitDestination.value);\n                this._pickStockLines[this._currentPickStockLine].packingUnitToStockUnitConversionFactor = Number(this.packingUnitToStockUnitConversionFactorDestination.value);\n                this._pickStockLines[this._currentPickStockLine].quantityInStockUnit = Number(this.quantityInStockUnitDestination.value);\n            }\n            this._displayPickedQuantity();\n            if (typesLib.gt(typesLib.sub(Number(this._pickTicketLine.quantityInStockUnit), this._getPickedQuantityInStockUnit()), 0)) {\n                this.stock.selectRecord(this.gridBlock.selectedRecordId);\n                const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n                let totalQuantityInPackingUnitDestination;\n                let totalQuantityInStockUnitDestination;\n                totalQuantityInPackingUnitDestination = 0;\n                totalQuantityInStockUnitDestination = 0;\n                this._pickStockLines.forEach(pickStockLine => {\n                    if (typesLib.strictEq(Number(pickStockLine.stockId), Number(currentRecord.stockId))) {\n                        totalQuantityInPackingUnitDestination = typesLib.add(totalQuantityInPackingUnitDestination, pickStockLine.quantityInPackingUnit);\n                        totalQuantityInStockUnitDestination = typesLib.add(totalQuantityInStockUnitDestination, pickStockLine.quantityInStockUnit);\n                    }\n                });\n                currentRecord.quantityInPackingUnitDestination = totalQuantityInPackingUnitDestination;\n                currentRecord.quantityInStockUnitDestination = totalQuantityInStockUnitDestination;\n                this.stock.setRecordValue(currentRecord);\n                this._displayPickedQuantity();\n                this.$.detailPanel.isHidden = true;\n                this.pickButton.isHidden = true;\n                this.shortageSwitch.isDisabled = false;\n                this.locationDestination.isDisabled = true;\n                await this.$.commitValueAndPropertyChanges();\n                if (this.serialNumber.value) {\n                    this.serialNumber.value = null;\n                    await (0, manage_pages_1.handleFilterOnChange)(this, this.serialNumber, null);\n                    this._unavailableStock = await this._getUnavailableStock();\n                    await this.stock.refresh();\n                    this.serialNumber.focus();\n                }\n            }\n            else {\n                await this._processPickPicket(false);\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"pickButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        icon: 'add',\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__addSerialRange____title\", \"Add...\"),\n        onError(error) {\n            switch (error.message) {\n                case '@sage/x3-stock/pages__mobile_pick_ticket_lines__notification__error_startingSerialNumber': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_pick_ticket_lines__notification__error_startingSerialNumber', 'The serial number is mandatory');\n                }\n                case '@sage/x3-stock/serial-number-range-overlap': {\n                    return ui.localize('@sage/x3-stock/serial-number-range-overlap', 'The serial numbers are overlapping. Enter another starting or ending serial number.');\n                }\n                case '@sage/x3-stock/pages__mobile_pick_ticket__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_pick_ticket__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move', 'Select the same amount of serial numbers in the range to match the quantity to move.');\n                }\n                case '@sage/x3-stock/serial-number-not-sequential': {\n                    return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n                }\n                default: {\n                    return error;\n                }\n            }\n        },\n        //shortcut: ['f2'], // TODO: Implement: What should the shortcut be for this button?\n        buttonType: 'secondary',\n        async onClick() {\n            if (!this.startingSerialNumber.value) {\n                throw new Error('@sage/x3-stock/pages__mobile_pick_ticket_lines__notification__error_startingSerialNumber');\n            }\n            // check that this will add any duplicates\n            const startNumberToAdd = this.startingSerialNumber.value.code.match(/\\d+$/);\n            const endNumberToAdd = Number(this.endingSerialNumber.value.match(/\\d+$/));\n            let serialNumberAlreadyUsed = false;\n            if (this.serialNumberLines.value.some(row => {\n                const rowStartMatch = row.startingSerialNumber.match(/\\d+$/);\n                const rowEndMatch = Number(row.endingSerialNumber.match(/\\d+$/));\n                // check if the 'beginning part' of the serial matches\n                if (typesLib.strictNe(row.startingSerialNumber.substring(0, typesLib.sub(row.startingSerialNumber.length, rowStartMatch.toString().length)), this.startingSerialNumber.value.code.substring(0, typesLib.sub(this.startingSerialNumber.value.code.length, startNumberToAdd.toString().length))))\n                    return false;\n                return typesLib.lte(Number(startNumberToAdd), rowEndMatch) && typesLib.gte(endNumberToAdd, Number(rowStartMatch));\n            })) {\n                serialNumberAlreadyUsed = true;\n            }\n            this._pickStockLines.forEach(line => {\n                if (line.serialNumber) {\n                    const startingSerialNumber = Number(line.serialNumber.match(/\\d+$/));\n                    const endingSerialNumber = Number(this._calculateEndingSerialNumber(line.serialNumber, Number(line.quantityInPackingUnit)).match(/\\d+$/));\n                    if (typesLib.lte(Number(startNumberToAdd), endingSerialNumber) && typesLib.gte(Number(endNumberToAdd), startingSerialNumber)) {\n                        serialNumberAlreadyUsed = true;\n                    }\n                }\n            });\n            if (serialNumberAlreadyUsed) {\n                throw new Error('@sage/x3-stock/serial-number-range-overlap');\n            }\n            if (typesLib.ne(this.endingSerialNumber.value, this._calculateEndingSerialNumber(this.startingSerialNumber.value?.code, Number(this.quantityInPackingUnitDestination.value)))) {\n                throw new Error('@sage/x3-stock/pages__mobile_pick_ticket__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move');\n            }\n            if (typesLib.strictNe((await (0, get_count_serial_number_1.getCountSerialNumber)(this, this.product.value?.code ?? '', this.stockSite.value, this._stockId.value, this.startingSerialNumber.value?.code ?? '', this.endingSerialNumber.value ?? '')), Number(this.quantityInPackingUnitDestination.value))) {\n                throw new Error('@sage/x3-stock/serial-number-not-sequential');\n            }\n            let currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n            this.serialNumberLines.addRecord({\n                quantity: this.quantityInPackingUnitDestination.value,\n                startingSerialNumber: this.startingSerialNumber.value.code,\n                endingSerialNumber: this.endingSerialNumber.value,\n            });\n            this._pickStockLines[this._currentPickStockLine].packingUnit =\n                this.packingUnitDestination.value ?? undefined;\n            this._pickStockLines[this._currentPickStockLine].quantityInPackingUnit = Number(this.quantityInPackingUnitDestination.value);\n            this._pickStockLines[this._currentPickStockLine].packingUnitToStockUnitConversionFactor = Number(this.packingUnitToStockUnitConversionFactorDestination.value);\n            this._pickStockLines[this._currentPickStockLine].quantityInStockUnit = Number(this.quantityInStockUnitDestination.value);\n            this._pickStockLines[this._currentPickStockLine].serialNumber = this.startingSerialNumber.value.code;\n            this.quantityInPackingUnitDestination.value = 0;\n            this.quantityInStockUnitDestination.value = 0;\n            this._pickStockLines.push({\n                packingUnit: this.packingUnitDestination.value ?? undefined,\n                quantityInPackingUnit: Number(this.quantityInPackingUnitDestination.value),\n                packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorDestination.value),\n                quantityInStockUnit: Number(this.quantityInStockUnitDestination.value),\n                location: currentRecord?.location?.code,\n                lot: currentRecord?.lot,\n                sublot: currentRecord?.sublot,\n                serialNumber: '',\n                status: currentRecord?.status?.code,\n                stockId: Number(currentRecord?.stockId),\n            });\n            this._currentPickStockLine = typesLib.sub(this._pickStockLines.length, 1);\n            this.startingSerialNumber.value = null;\n            this.endingSerialNumber.value = null;\n            await this.$.commitValueAndPropertyChanges();\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"addSerialRange\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"detailPanelSection\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"sectionHeader\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"pickedBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"bodyBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"detailsBlock\", void 0);\n__decorate([\n    ui.decorators.gridRowBlock({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n        boundTo() {\n            return this.stock;\n        },\n        fieldFilter(columnId) {\n            return false;\n        },\n        readOnlyOverride(columnId) {\n            return undefined;\n            // if undefined is returned, the original readOnly property is used from the column definition\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"gridBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"quantityBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"serialNumberBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"destinationBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"listSerialNumberBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.pickedBlock;\n        },\n        isTitleHidden: true,\n        isReadOnly: true,\n        isTransient: true,\n        isFullWidth: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"pickedQuantity\", void 0);\n__decorate([\n    ui.decorators.switchField({\n        parent() {\n            return this.pickedBlock;\n        },\n        isDisabled: false,\n        isHidden: false,\n        isReadOnly: false,\n        isTransient: true,\n        size: 'small',\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__shortageSwitch____title\", \"Shortage\"),\n        async onChange() {\n            if (this.shortageSwitch.value) {\n                const shortPick = await (0, dialogs_1.dialogConfirmation)(this, 'info', ui.localize('@sage/x3-stock/dialog-information-title', 'Information'), ui.localize('@sage/x3-stock/dialog-confirmation-pick-ticket-shortage-message', 'Create a shortage?'), {\n                    fullScreen: true,\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-stock/button-accept-yes', 'Yes'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-stock/button-cancel-no', 'No'),\n                    },\n                });\n                if (shortPick) {\n                    await this._processPickPicket(true);\n                }\n                this.shortageSwitch.value = false;\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"shortageSwitch\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__licensePlateNumber____title\", \"License plate number\"),\n        valueField: 'code',\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                _and: [{ status: 'inStock' }, { stockSite: { code: this.stockSite.value } }],\n            };\n        },\n        async onChange() {\n            if (this.licensePlateNumber.value?.location) {\n                this.location.value = this.licensePlateNumber.value.location;\n            }\n            if (!this.licensePlateNumber.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    licensePlateNumber: undefined,\n                };\n                if (!this.licensePlateNumber.isHidden) {\n                    this.licensePlateNumber.value = null;\n                }\n                return;\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                licensePlateNumber: { code: this.licensePlateNumber.value.code },\n            };\n            this.licensePlateNumber.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n            }),\n        ],\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__location____title\", \"Location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: false,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__location____placeholder\", \"Scan or select\\u2026\"),\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        isTransient: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            const locationFilter = {\n                stockSite: { code: this.stockSite.value },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n            return locationFilter;\n        },\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.location);\n            // await this._getStock();\n            this._unavailableStock = await this._getUnavailableStock();\n            await this.stock.refresh();\n            //   await this._removeStockNotAvailable();\n            if (this.location.value) {\n                this.location.getNextField(true)?.focus();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__location____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__location____columns__title__type\", \"Type\"),\n            }),\n        ],\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__lot____title\", \"Lot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__lot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LotsSites',\n        valueField: 'lot',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code },\n                storageSite: { code: this.stockSite.value ?? undefined },\n            };\n        },\n        async onChange() {\n            await this.onChangeLot();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__lot____columns__title__lot\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__lot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__sublot____title\", \"Sublot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__sublot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LotsSites',\n        valueField: 'sublot',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code },\n                storageSite: { code: this.stockSite.value ?? undefined },\n            };\n        },\n        async onChange() {\n            if (!this.sublot.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    lot: undefined,\n                    sublot: undefined,\n                };\n                if (!this.lot.isHidden) {\n                    this.lot.value = null;\n                }\n                return;\n            }\n            if (!this.lot.isHidden) {\n                this.lot.value = this.sublot.value;\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                lot: this.sublot.value.lot,\n                sublot: this.sublot.value.sublot,\n            };\n            this.sublot.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__sublot____columns__title__lot\", \"Lot\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__sublot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__serialNumber____title\", \"Serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__serialNumber____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code },\n                stockSite: { code: this.stockSite.value ?? undefined },\n                issueDocumentId: '',\n            };\n        },\n        async onChange() {\n            if (this.serialNumber.value && typesLib.strictEq(this.product.value?.serialNumberManagementMode, 'receivedIssued')) {\n                await (0, manage_pages_1.handleFilterOnChange)(this, this.serialNumber, this.serialNumber.value?.code);\n                // await this._getStock();\n                this._unavailableStock = await this._getUnavailableStock();\n                await this.stock.refresh();\n                //   await this._removeStockNotAvailable();\n                this.stock.value.forEach(line => {\n                    const currentRecord = this.stock.getRecordValue(line._id);\n                    this.stock.selectRecord(line._id);\n                    if (currentRecord &&\n                        !this._pickStockLines.find(pickStockLine => typesLib.strictEq(Number(pickStockLine.stockId), Number(currentRecord.stockId)))) {\n                        this._pickStockLines.push({\n                            packingUnit: currentRecord.packingUnit?.code,\n                            quantityInPackingUnit: Number(currentRecord.quantityInPackingUnit),\n                            packingUnitToStockUnitConversionFactor: Number(currentRecord.packingUnitToStockUnitConversionFactor),\n                            quantityInStockUnit: Number(currentRecord.quantityInStockUnit),\n                            location: currentRecord.location?.code,\n                            lot: currentRecord.lot,\n                            sublot: currentRecord.sublot,\n                            serialNumber: currentRecord.serialNumber,\n                            status: currentRecord.status?.code,\n                            stockId: Number(currentRecord.stockId),\n                        });\n                        currentRecord.quantityInPackingUnitDestination = 1;\n                        currentRecord.quantityInStockUnitDestination = 1;\n                        this.stock.setRecordValue(currentRecord);\n                        this._onRowClick(currentRecord._id, currentRecord);\n                    }\n                });\n                this._displayPickedQuantity();\n            }\n            else {\n                await (0, manage_pages_1.handleFilterOnChange)(this, this.serialNumber, this.serialNumber.value?.code);\n                // await this._getStock();\n                this._unavailableStock = await this._getUnavailableStock();\n                await this.stock.refresh();\n                //  await this._removeStockNotAvailable();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__serialNumber____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__status____title\", \"Status\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__status____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.status, this.status.value);\n            // await this._getStock();\n            this._unavailableStock = await this._getUnavailableStock();\n            await this.stock.refresh();\n            //   await this._removeStockNotAvailable();\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__packingUnit____title\", \"Unit\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__packingUnit____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.packingUnit, this.packingUnit.value);\n            // await this._getStock();\n            this._unavailableStock = await this._getUnavailableStock();\n            await this.stock.refresh();\n            //  await this._removeStockNotAvailable();\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"packingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__packingUnitToStockUnitConversionFactor____title\", \"Conversion factor\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__packingUnitToStockUnitConversionFactor____placeholder\", \"Scan...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        min: 0,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.packingUnitToStockUnitConversionFactor);\n            // await this._getStock();\n            this._unavailableStock = await this._getUnavailableStock();\n            await this.stock.refresh();\n            //  await this._removeStockNotAvailable();\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"packingUnitToStockUnitConversionFactor\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__identifier1____title\", \"Identifier 1\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__identifier1____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        // isHidden: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.identifier1);\n            // await this._getStock();\n            this._unavailableStock = await this._getUnavailableStock();\n            await this.stock.refresh();\n            //  await this._removeStockNotAvailable();\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__identifier2____title\", \"Identifier 2\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__identifier2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.identifier2);\n            // await this._getStock();\n            // await this._removeStockNotAvailable();\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"identifier2\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockCustomField1____title\", \"Stock custom field 1\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockCustomField1____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.stockCustomField1);\n            // await this._getStock();\n            this._unavailableStock = await this._getUnavailableStock();\n            await this.stock.refresh();\n            //  await this._removeStockNotAvailable();\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"stockCustomField1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockCustomField2____title\", \"Stock custom field 2\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockCustomField2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.stockCustomField2);\n            // await this._getStock();\n            this._unavailableStock = await this._getUnavailableStock();\n            await this.stock.refresh();\n            //   await this._removeStockNotAvailable();\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"stockCustomField2\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.bodyBlock;\n        },\n        node: '@sage/x3-stock-data/Stock',\n        isChangeIndicatorDisabled: false,\n        canFilter: false,\n        canSelect: true,\n        canExport: false,\n        canResizeColumns: false,\n        canUserHideColumns: false,\n        isTitleHidden: false,\n        isTransient: false,\n        isFullWidth: true,\n        isDisabled: false,\n        hasSearchBoxMobile: false,\n        cardView: true,\n        displayMode: ui.fields.TableDisplayMode.compact,\n        mobileCard: undefined,\n        // pageSize: 500,\n        orderBy: {\n            stockSite: 1,\n            stockId: 1,\n        },\n        filter() {\n            return {\n                ...(0, manage_pages_1.generateStockTableFilter)(this),\n                ...{ location: { category: { _nin: ['subcontract', 'customer'] } } },\n                ...{ qualityAnalysisRequestId: { _eq: '' } },\n                ...(typesLib.gt(this._unavailableStock.length, 0) && { _id: { _nin: this._unavailableStock } }),\n            };\n        },\n        columns: [\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnitDestination',\n                isReadOnly: true,\n                isHidden: false,\n                isTransient: true,\n                postfix(value, rowValue) {\n                    return `/ ${ui.formatNumberToCurrentLocale(Number(rowValue?.availableQuantityInPackingUnit), Number(rowValue?.packingUnitDestination?.numberOfDecimals))} ${String(rowValue?.packingUnitDestination?.code)}`;\n                },\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stock____columns__title\", \"PAC quantity\"),\n                isTitleHidden: false,\n                isMandatory: false,\n                isFullWidth: true,\n                scale(value, rowValue) {\n                    return rowValue?.packingUnitDestination?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnit',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'allocatedQuantity',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'activeQuantityInStockUnit',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'allocatedActiveQuantity',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'inProcessActiveQuantity',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'availableQuantityInPackingUnit',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInStockUnitDestination',\n                isReadOnly: true,\n                isHidden: true,\n                isTransient: true,\n                postfix(value, rowValue) {\n                    return `/ ${ui.formatNumberToCurrentLocale(Number(rowValue?.availableQuantityInStockUnit), Number(rowValue?.stockUnit.numberOfDecimals))} ${String(rowValue?.stockUnit.code)}`;\n                },\n                scale(value, rowValue) {\n                    return rowValue?.stockUnit.numberOfDecimals ?? 0;\n                },\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stock____columns__title__2\", \"stock quantity\"),\n                isTitleHidden: false,\n                isMandatory: false,\n                isFullWidth: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInStockUnit',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'availableQuantityInStockUnit',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-master-data/ProductSite',\n                isReadOnly: true,\n                isHidden: false,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: { product: { code: true } },\n                    }),\n                    ui.nestedFields.text({\n                        bind: { product: { serialNumberManagementMode: true } },\n                    }),\n                    ui.nestedFields.text({\n                        bind: { product: { stockUnit: { code: true } } },\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: { product: { stockUnit: { numberOfDecimals: true } } },\n                    }),\n                ],\n            }),\n            ui.nestedFields.reference({\n                bind: 'licensePlateNumber',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n                isReadOnly: true,\n                isHidden() {\n                    return this.licensePlateNumber.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                isReadOnly: true,\n                isHidden() {\n                    return this.lot.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                isReadOnly: true,\n                isHidden() {\n                    return this.sublot.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.link({\n                bind: 'globalSerialNumber',\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                isReadOnly: true,\n                isFullWidth: true,\n                maxLength: 20,\n                isHidden() {\n                    return this.serialNumber.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'status',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/StockStatus',\n                isReadOnly: true,\n                isHidden() {\n                    return this.status.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.technical({\n                bind: 'packingUnit',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                nestedFields: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: 'numberOfDecimals',\n                    }),\n                ],\n            }),\n            ui.nestedFields.technical({\n                bind: 'packingUnitDestination',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                isTransient: true,\n                nestedFields: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: 'numberOfDecimals',\n                    }),\n                ],\n            }),\n            ui.nestedFields.technical({\n                bind: 'stockUnit',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                isTransient: true,\n                nestedFields: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: 'numberOfDecimals',\n                    }),\n                ],\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactor',\n                isReadOnly: true,\n                isHidden() {\n                    return this.packingUnitToStockUnitConversionFactor.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactorDestination',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                isReadOnly: true,\n                isHidden() {\n                    return this.identifier1.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                isReadOnly: true,\n                isHidden() {\n                    return this.identifier2.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCustomField1',\n                isReadOnly: true,\n                isHidden() {\n                    return this.stockCustomField1.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCustomField2',\n                isReadOnly: true,\n                isHidden() {\n                    return this.stockCustomField2.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.technical({\n                bind: 'stockId',\n            }),\n            ui.nestedFields.technical({\n                bind: 'lotReference',\n                node: '@sage/x3-stock-data/Lot',\n                nestedFields: [\n                    ui.nestedFields.date({\n                        bind: 'expirationDate',\n                    }),\n                    ui.nestedFields.date({\n                        bind: 'useByDate',\n                    }),\n                    ui.nestedFields.text({\n                        bind: 'lotCustomField1',\n                    }),\n                    ui.nestedFields.text({\n                        bind: 'lotCustomField2',\n                    }),\n                    ui.nestedFields.reference({\n                        bind: 'majorVersion',\n                        node: '@sage/x3-master-data/MajorVersionStatus',\n                        valueField: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceExpirationDate',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceUseByDate',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lotReferenceMajorVersion',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.technical({\n                bind: 'owner',\n            }),\n        ],\n        onError(error) {\n            switch (error.message) {\n                case '@sage/x3-stock/serial-number-not-sequential': {\n                    return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n                }\n                default:\n                    return error;\n            }\n        },\n        async onRowSelected(recordId, rowItem) {\n            await this._onRowClick(recordId, rowItem);\n        },\n        async onRowUnselected(recordId, rowItem) {\n            let currentRecord = this.stock.getRecordValue(recordId);\n            if (currentRecord) {\n                let i = 0;\n                while (typesLib.lt(i, this._pickStockLines.length)) {\n                    if (typesLib.strictEq(Number(this._pickStockLines[i].stockId), Number(currentRecord.stockId))) {\n                        this._pickStockLines.splice(i, 1);\n                    }\n                    else {\n                        i = typesLib.add(i, 1);\n                    }\n                }\n                this._displayPickedQuantity();\n                currentRecord.quantityInPackingUnitDestination = currentRecord.availableQuantityInPackingUnit;\n                currentRecord.quantityInStockUnitDestination = currentRecord.availableQuantityInStockUnit;\n                this.stock.setRecordValue(currentRecord);\n            }\n        },\n        sortColumns(firstColumn, secondColumn) {\n            if (typesLib.strictEq(firstColumn.bind, secondColumn.bind))\n                return 0;\n            if (typesLib.strictEq(firstColumn.bind, 'quantityInPackingUnitDestination')) {\n                return typesLib.strictEq(secondColumn.bind, this._stockFieldSettings[0]) ? 1 : -1;\n            }\n            else if (typesLib.strictEq(secondColumn.bind, 'quantityInPackingUnitDestination')) {\n                return typesLib.strictEq(firstColumn.bind, this._stockFieldSettings[0]) ? -1 : 1;\n            }\n            for (const stockFieldSetting of Object.keys(this._stockFieldSettings)) {\n                if (!stockFieldSetting || typesLib.strictEq(stockFieldSetting, 'none'))\n                    break;\n                if (typesLib.strictEq(firstColumn.bind, stockFieldSetting))\n                    return -1;\n                if (typesLib.strictEq(secondColumn.bind, stockFieldSetting))\n                    return 1;\n            }\n            return 1;\n        },\n        mapServerRecord(record) {\n            const _record = {\n                ...record,\n                quantityInPackingUnitDestination: this._getQuantityInPackingUnitDestination(record).toString(),\n                quantityInStockUnitDestination: this._getQuantityInStockUnitDestination(record).toString(),\n                availableQuantityInPackingUnit: this._getAvailableQuantityInPackingUnit(record).toString(),\n                availableQuantityInStockUnit: this._getAvailableQuantityInStockUnit(record).toString(),\n                packingUnitDestination: this._getPackingUnitDestination(record),\n                packingUnitToStockUnitConversionFactorDestination: this._getPackingUnitToStockUnitConversionFactorDestination(record),\n                lotReferenceExpirationDate: record.lotReference?.expirationDate,\n                lotReferenceMajorVersion: record.lotReference?.majorVersion?.code,\n                lotReferenceUseByDate: record.lotReference?.useByDate,\n                stockUnit: record.product?.product.stockUnit,\n                globalSerialNumber: ui.localize('@sage/x3-stock/label-view-all', 'View list'),\n            };\n            return _record;\n        },\n        async onRowClick(recordId, rowItem) {\n            await this._onRowClick(recordId, rowItem);\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"stock\", void 0);\n__decorate([\n    ui.decorators.detailListField({\n        parent() {\n            return this.detailsBlock;\n        },\n        node: '@sage/x3-stock-data/Stock',\n        isTransient: true,\n        isFullWidth: true,\n        isTitleHidden: true,\n        fields: [\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-master-data/ProductSite',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title\", \"Product\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.reference({\n                bind: 'licensePlateNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__2\", \"License plate number\"),\n                valueField: 'code',\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__3\", \"Location\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__4\", \"Stock ID\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__5\", \"Lot\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__6\", \"Sublot\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'lotReferenceMajorVersion',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__7\", \"Major version\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceExpirationDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__8\", \"Expiration date\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value || typesLib.strictEq(this.product.value?.expirationManagementMode, 'notManaged');\n                },\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceUseByDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__9\", \"Use-by date\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value || typesLib.strictEq(this.product.value?.expirationManagementMode, 'notManaged');\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'lotCustomField1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__10\", \"Lot custom field 1\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value?.lotCustomField1;\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'lotCustomField2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__11\", \"Lot custom field 2\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value?.lotCustomField2;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__12\", \"Serial no.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.link({\n                bind: 'globalSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__13\", \"Serial no.\"),\n                isHidden() {\n                    return typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued');\n                },\n                async onClick(_id, rowData) {\n                    const options = {\n                        skipDirtyCheck: true,\n                    };\n                    try {\n                        await this.$.dialog.page('@sage/x3-stock/MobileGlobalSerialDetails', {\n                            product: this.product.value?.code ?? '',\n                            stockId: rowData.stockId,\n                            subtitle: this.localizedDescription1.value ?? '',\n                        }, options);\n                    }\n                    catch (error) {\n                        if (error) {\n                            this.$.showToast(error.message, { timeout: 10000, type: 'error' });\n                        }\n                    }\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnitDestination',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__14\", \"PAC quantity\"),\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n                postfix(value, rowValue) {\n                    return rowValue?.packingUnit.code;\n                },\n                scale(value, rowValue) {\n                    return rowValue?.packingUnit.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'availableQuantityInPackingUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__15\", \"Packing qty.\"),\n                isReadOnly: true,\n                isHidden: false,\n                postfix() {\n                    return this.stock.getRecordValue(this.gridBlock.selectedRecordId).packingUnit?.code;\n                },\n                scale() {\n                    return (this.stock.getRecordValue(this.gridBlock.selectedRecordId).packingUnit?.numberOfDecimals ?? 0);\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'packingUnit',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__16\", \"Unit\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                bind: 'packingUnit',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                valueField: 'numberOfDecimals',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactor',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__17\", \"Conversion factor\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'availableQuantityInStockUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__18\", \"Stock qty.\"),\n                isReadOnly: true,\n                isHidden: false,\n                postfix() {\n                    return this.product.value?.stockUnit?.code ?? '';\n                },\n                scale() {\n                    return this.product.value?.stockUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'allocatedQuantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__19\", \"Allocated qty.\"),\n                isReadOnly: true,\n                isHidden: false,\n                postfix() {\n                    return this.product.value?.stockUnit?.code ?? '';\n                },\n                scale() {\n                    return this.product.value?.stockUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'status',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__20\", \"Status\"),\n                isReadOnly: true,\n                node: '@sage/x3-stock-data/StockStatus',\n                columns: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__21\", \"Identifier 1\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockDetails____fields__title__22\", \"Identifier 2\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n        ],\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"stockDetails\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.quantityBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__packingUnitDestination____title\", \"PAC unit\"),\n        width: 'small',\n        isMandatory: true,\n        isTransient: true,\n        async onChange() {\n            const selectedValue = this.packingUnitDestination.value;\n            const packingUnitIndex = this._packingUnits\n                .map(packingUnit => packingUnit.node.packingUnit.code)\n                .indexOf(selectedValue);\n            if (typesLib.strictNe(packingUnitIndex, -1)) {\n                const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                this.packingUnitToStockUnitConversionFactorDestination.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n                this.packingUnitToStockUnitConversionFactorDestination.isDisabled =\n                    !selectedUnit.isPackingFactorEntryAllowed;\n                this.packingUnitDestinationDecimales.value = selectedUnit.packingUnit.numberOfDecimals;\n            }\n            else {\n                this.packingUnitToStockUnitConversionFactorDestination.value = 1;\n                this.packingUnitToStockUnitConversionFactorDestination.isDisabled = true;\n                this.packingUnitDestinationDecimales.value = 0;\n            }\n            if (typesLib.gt(this.packingUnitToStockUnitConversionFactorDestination.value, 0)) {\n                this.quantityInPackingUnitDestination.value = typesLib.div(this.quantityInStockUnitDestination.value, this.packingUnitToStockUnitConversionFactorDestination.value);\n                this.quantityInPackingUnitDestination.value = Number.parseFloat(this.quantityInPackingUnitDestination.value.toFixed(this.packingUnitDestinationDecimales.value ?? 0));\n            }\n            this.quantityInPackingUnitDestination.scale = this.packingUnitDestinationDecimales.value ?? 0;\n            this.packingUnitDestination.getNextField(true)?.focus();\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"packingUnitDestination\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.quantityBlock;\n        },\n        isTransient: true,\n        isHidden: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"packingUnitDestinationDecimales\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.quantityBlock;\n        },\n        postfix(value, rowValue) {\n            return `/ ${ui.formatNumberToCurrentLocale(this._getQuantityInPackingUnitToPick(), this.packingUnitDestinationDecimales.value ?? 0)} ${this.packingUnitDestination.value}`;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__quantityInPackingUnitDestination____title\", \"PAC quantity\"),\n        isTransient: true,\n        isFullWidth: true,\n        max() {\n            return this._getQuantityInPackingUnitToPick();\n        },\n        scale() {\n            return (this.stock.getRecordValue(this.gridBlock?.selectedRecordId)?.packingUnit\n                ?.numberOfDecimals ?? 0);\n        },\n        async onChange() {\n            if (typesLib.gt(this.packingUnitToStockUnitConversionFactorDestination.value, 0)) {\n                this.quantityInStockUnitDestination.value = typesLib.mul(this.quantityInPackingUnitDestination.value, this.packingUnitToStockUnitConversionFactorDestination.value);\n                this.quantityInStockUnitDestination.value = Number.parseFloat(this.quantityInStockUnitDestination.value.toFixed(this.stock.getRecordValue(this.gridBlock.selectedRecordId)?.stockUnit\n                    ?.numberOfDecimals));\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"quantityInPackingUnitDestination\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.quantityBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__packingUnitToStockUnitConversionFactorDestination____title\", \"conversion factor\"),\n        isDisabled: true,\n        isMandatory: true,\n        isTransient: true,\n        isFullWidth: true,\n        scale: 5,\n        onChange() {\n            if (typesLib.gt(this.packingUnitToStockUnitConversionFactorDestination.value, 0)) {\n                this.quantityInStockUnitDestination.value = typesLib.mul(this.quantityInPackingUnitDestination.value, this.packingUnitToStockUnitConversionFactorDestination.value);\n                this.quantityInStockUnitDestination.value = Number.parseFloat(this.quantityInStockUnitDestination.value.toFixed(this.stock.getRecordValue(this.gridBlock.selectedRecordId)?.stockUnit\n                    ?.numberOfDecimals));\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"packingUnitToStockUnitConversionFactorDestination\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__stockUnit____title\", \"Stock unit\"),\n        isDisabled: true,\n        isTransient: true,\n        parent() {\n            return this.quantityBlock;\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"stockUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.quantityBlock;\n        },\n        postfix(value, rowValue) {\n            return `/ ${ui.formatNumberToCurrentLocale(this._getQuantityInStockUnitToPick(), this._productSite.product.stockUnit.numberOfDecimals)} ${this._productSite.product.stockUnit.code}`;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__quantityInStockUnitDestination____title\", \"Stock quantity\"),\n        isMandatory: true,\n        isFullWidth: true,\n        isTransient: true,\n        validation: /^([0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals)\n        min: 0,\n        scale() {\n            return this._productSite.product.stockUnit.numberOfDecimals ?? 0;\n        },\n        max() {\n            return this._getQuantityInStockUnitToPick();\n        },\n        async onChange() {\n            if (typesLib.gt(this.packingUnitToStockUnitConversionFactorDestination.value, 0)) {\n                this.quantityInPackingUnitDestination.value = typesLib.div(this.quantityInStockUnitDestination.value, this.packingUnitToStockUnitConversionFactorDestination.value);\n                this.quantityInPackingUnitDestination.value = Number.parseFloat(this.quantityInPackingUnitDestination.value.toFixed(this.packingUnitDestinationDecimales.value ?? 0));\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"quantityInStockUnitDestination\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__startingSerialNumber____title\", \"Starting serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__startingSerialNumber____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        canFilter: false,\n        isDisabled: false,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        filter() {\n            return {\n                _and: [{ product: { code: this.product.value?.code } }, { stockId: this._stockId.value ?? undefined }],\n            };\n        },\n        async onChange() {\n            await this.onChangeBody();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__startingSerialNumber____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__startingSerialNumber____columns__title__product__code\", \"Product\"),\n                bind: 'product',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__startingSerialNumber____columns__title__stockId\", \"Stock ID\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"startingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__endingSerialNumber____title\", \"Ending serial number\"),\n        isMandatory: false,\n        isTransient: true,\n        isReadOnly: true,\n        isFullWidth: true,\n        async validation(value) {\n            if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued'))\n                return;\n            let currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n            let currentQty = Number(this.quantityInPackingUnitDestination.value);\n            if (typesLib.strictNe((await (0, get_count_serial_number_1.getCountSerialNumber)(this, this.product.value?.code ?? '', this.stockSite.value ?? '', this._stockId.value, this.startingSerialNumber.value?.code ?? '', this.endingSerialNumber.value ?? '')), currentQty)) {\n                return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n            }\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"endingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__locationDestination____title\", \"Destination location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: false,\n        isTransient: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__locationDestination____placeholder\", \"Scan or select...\"),\n        isAutoSelectEnabled: true,\n        width: 'large',\n        canFilter: false,\n        filter() {\n            const locationFilter = {\n                stockSite: { code: this._stockSite.code },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n            return locationFilter;\n        },\n        async onChange() {\n            if (this.locationDestination.value) {\n                //    this._getWarehouseFromLocation();\n                this.locationDestination.getNextField(true)?.focus();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__locationDestination____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__locationDestination____columns__title__type\", \"Type\"),\n            }),\n        ],\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"locationDestination\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        parent() {\n            return this.destinationBlock;\n        },\n        isHidden: true,\n        isReadOnly: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__customBoolean____title\", \"custom boolean\"),\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"customBoolean\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.destinationBlock;\n        },\n        isHidden: true,\n        isReadOnly: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__customDecimal____title\", \"custom decimal\"),\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"customDecimal\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.destinationBlock;\n        },\n        isHidden: true,\n        isReadOnly: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__customString____title\", \"custom text\"),\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"customString\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.destinationBlock;\n        },\n        isHidden: true,\n        isReadOnly: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__customDate____title\", \"custom date\"),\n        isTransient: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"customDate\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        isTransient: true,\n        isHidden: true,\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"_stockId\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.listSerialNumberBlock;\n        },\n        canFilter: false,\n        canSelect: false,\n        canExport: false,\n        canResizeColumns: false,\n        canUserHideColumns: false,\n        isTitleHidden: false,\n        isTransient: true, // (X3-257606) TODO: Issue: Deleting table row(s) that are loaded in a non-transient causes errors. After this is fixed, change this table back to isTransient: false\n        isFullWidth: true,\n        isDisabled: false,\n        mobileCard: undefined,\n        node: '@sage/x3-stock/StockCountSerialNumber',\n        columns: [\n            ui.nestedFields.text({\n                bind: 'startingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__serialNumberLines____columns__title__startingSerialNumber\", \"Starting serial Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__serialNumberLines____columns__title__quantity\", \"Quantity\"),\n                isReadOnly: true,\n                postfix(value, rowValue) {\n                    return this.stock.getRecordValue(this.gridBlock.selectedRecordId).packingUnit?.code;\n                },\n                scale() {\n                    return (this.stock.getRecordValue(this.gridBlock.selectedRecordId ?? '')?.packingUnit\n                        ?.numberOfDecimals ?? 0);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'endingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__serialNumberLines____columns__title__endingSerialNumber\", \"Ending Serial Number\"),\n                isReadOnly: true,\n            }),\n        ],\n        dropdownActions: [\n            {\n                icon: 'bin',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global__serialNumberLines____dropdownActions__title\", \"Delete\"),\n                async onClick(recordId) {\n                    const removedRecordSerialNumber = this.serialNumberLines.getRecordValue(recordId);\n                    const removedIndexSerialNumber = this._pickStockLines.findIndex(number => typesLib.strictEq(number.serialNumber, removedRecordSerialNumber.startingSerialNumber));\n                    this._pickStockLines.splice(removedIndexSerialNumber, 1);\n                    this.quantityInPackingUnitDestination.value = 0;\n                    this.quantityInStockUnitDestination.value = 0;\n                    this.serialNumberLines.removeRecord(recordId);\n                    this.startingSerialNumber.isDisabled = false;\n                    this._currentPickStockLine = typesLib.sub(this._currentPickStockLine, 1);\n                    await this.$.commitValueAndPropertyChanges();\n                },\n            },\n        ],\n        fieldActions() {\n            return [this.addSerialRange];\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal.prototype, \"serialNumberLines\", void 0);\nexports.MobilePickTicketViewPickTicketLineGlobal = MobilePickTicketViewPickTicketLineGlobal = MobilePickTicketViewPickTicketLineGlobal_1 = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global____title\", \"Pick ticket\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_pick_ticket_view_pick_ticket_line_global____subtitle\", \"Select stock\"),\n        node: '@sage/x3-master-data/ProductSite',\n        mode: 'default',\n        isTitleHidden: true,\n        isTransient: false,\n        navigationPanel: undefined,\n        headerCard() {\n            return {\n                title: this.pickTicket,\n                titleRight: this.pickTicketLine,\n                line2: this.product,\n                line2Right: this.localizedDescription1,\n                line3: this.titleQuantityToPick,\n                line3Right: this.quantityToPick,\n            };\n        },\n        businessActions() {\n            if (this.$.detailPanel?.isHidden) {\n                return [];\n            }\n            else {\n                return [this.pickButton];\n            }\n        },\n        async onLoad() {\n            await this._init();\n            if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                this.addSerialRange.isHidden = true;\n                this.serialNumberBlock.isHidden = true;\n                this.listSerialNumberBlock.isHidden = true;\n                this.serialNumberLines.isTitleHidden = true;\n                this.listSerialNumberBlock.isHidden = true;\n            }\n            this.serialNumberLines.title = 'Serial number(s) to move    ';\n            (0, manage_pages_1.managePages)(this, this.stockSite.value, { ...this.$.values, product: { ...this.product.value } }, '4', ui.localize('@sage/x3-stock/pages__mobile-settings__mandatory-settings-missing', 'Mandatory settings missing.'), this._stockFieldSettings);\n            // await this._getStock();\n            this._unavailableStock = await this._getUnavailableStock();\n            await this.stock.refresh();\n            // await this._removeStockNotAvailable();\n        },\n        detailPanel() {\n            return {\n                isCloseButtonHidden: true,\n                isTitleHidden: true,\n                isHidden: true,\n                isTransient: true,\n                header: this.detailPanelSection,\n                sections: [],\n                footerActions: [this.pickButton],\n            };\n        },\n    })\n], MobilePickTicketViewPickTicketLineGlobal);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-pick-ticket-view-pick-ticket-line-global.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts":
/*!**********************************************************************************!*\
  !*** ../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getCountSerialNumber = void 0;\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\n/**\n * async getCountSerialNumber for count number of serial numbers in range\n * @param _pageInstance this page\n * @param _productCode product code\n * @param _stockSiteCode  stock site code\n * @param _stockId optional stock id\n * @param _startingSerialNumberCode starting serial number\n * @param _endingSerialNumberCode  ending serial number\n * @param value to control\n * @returns counted serial number in range or throw exception\n */\nasync function getCountSerialNumber(_pageInstance, _productCode, _stockSiteCode, _stockId, _startingSerialNumberCode, _endingSerialNumberCode, value) {\n    // Create a readable payload, but removing CR/LF before to send request.\n    const _payload = `{\n        product: { code: '${_productCode}' },\n        stockSite: { code: '${_stockSiteCode}' },\n        ${_stockId ? `stockId: '${_stockId}',` : ''}\n        _and: [\n            {\n                code: { _gte: '${_startingSerialNumberCode}' },\n            },\n            {\n                code: { _lte: '${_endingSerialNumberCode}' },\n            },\n        ],\n    }`.replace(/[\\r\\n]/g, '');\n    try {\n        const response = await _pageInstance.$.graph.raw(`query {\n                        x3StockData{\n                            serialNumber {\n                                query(filter: \"${_payload}\") {\n                                    totalCount\n                                }\n                            }\n                        }\n                    }`);\n        return response?.x3StockData?.serialNumber?.query?.totalCount ?? 0;\n    }\n    catch (error) {\n        throw new xtrem_shared_1.BusinessRuleError(error?.message, error);\n    }\n}\nexports.getCountSerialNumber = getCountSerialNumber;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/shared-functions/pat-converter.ts":
/*!********************************************************************!*\
  !*** ../../shared/x3-system/lib/shared-functions/pat-converter.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.pat = exports.getRegExpForMultiplePat = exports.getRegExp = void 0;\n/**\n * Get the RegExp equivalent for the 4GL pattern given\n *\n * @param pattern The 4GL pattern you want to get the RegExp equivalent\n * @returns The RegExp\n */\nfunction getRegExp(pattern) {\n    const rule = \n    // escape RegExp spécial chars\n    pattern\n        .replace(/[-[\\]{}()+.,\\\\^$|\\s]/g, '\\\\$&')\n        // translate the pattern\n        .replace(/\\*/g, '.*')\n        .replace(/\\?/g, '.')\n        .replace(/#/g, '\\\\d')\n        .replace(/!/g, '[A-Za-z]');\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExp = getRegExp;\nfunction getRegExpForMultiplePat(multiplePattern) {\n    // const str1 = '(';\n    const rule = `${`(${\n    // convert each pattern individually and join them using |\n    multiplePattern\n        .split(',')\n        .map(multPat => getRegExp(multPat).source.replace(/\\^/g, '').replace(/\\$/g, ''))\n        .join('|')}`})`;\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExpForMultiplePat = getRegExpForMultiplePat;\n/**\n * Perform a 4GL pattern check\n *\n * @param text The text to be tested\n * @param pat The 4GL pattern to apply\n * @returns The result of the test as a boolean\n */\nfunction pat(text, pattern) {\n    return getRegExp(pattern).test(text);\n}\nexports.pat = pat;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/shared-functions/pat-converter.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-pick-ticket-view-pick-ticket-line-global.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;