import { ProductInput } from '@sage/x3-master-data-api';
import { GraphApi, MiscellaneousReceiptInput, StockEntryTransaction } from '@sage/x3-stock-api';
import * as ui from '@sage/xtrem-ui';
export type DeepPartial<T> = T extends Object ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : T;
type PartialStockEntryTransaction = DeepPartial<StockEntryTransaction>;
export type inputs = {
    miscellaneousReceipt: MiscellaneousReceiptInput & {
        id: string;
    };
    username: string;
    started: boolean;
    selectedTransaction: PartialStockEntryTransaction;
    selectedProduct?: ProductInput;
    destination?: string;
};
/** Created with X3 Etna Studio at 2020-01-21T16:10:32.247Z */
export declare class MobileMiscellaneousReceipt extends ui.Page<GraphApi> {
    savedObject: inputs;
    private _notifier;
    private _transactions;
    private _numberOfDecimalList;
    private _isLocationPreloaded;
    stockSite: ui.fields.Text;
    private _showErrors;
    private _showSuccess;
    private _showSeverityThreeAndFour;
    private _showSeverityOneAndTwo;
    createButton: ui.PageAction;
    mainSection: ui.containers.Section;
    transactionBlock: ui.containers.Block;
    productBlock: ui.containers.Block;
    miscellaneousReceiptLinesBlock: ui.containers.Block;
    effectiveDate: ui.fields.Date;
    transaction: ui.fields.DropdownList;
    product: ui.fields.Reference;
    miscellaneousReceiptLines: ui.fields.Table<any>;
    private _init;
    private _disablePage;
    private _readSavedObject;
    private _initSite;
    private _getIsLocationPreloaded;
    private _initDestination;
    private _initTransaction;
    private _initmiscellaneousReceiptLines;
    private _postInitmiscellaneousReceiptLines;
    private _setTransaction;
    private _checkStorage;
    private _reInitStorage;
    private _initStorage;
    private _saveMiscellaneousReceipt;
    prepareDataMutation(): void;
    private _callCreationAPI;
    private _mapMiscellaneousReceipt;
}
export {};
//# sourceMappingURL=mobile-miscellaneous-receipt.d.ts.map