/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/get-product-site.ts":
/*!**************************************************!*\
  !*** ./lib/client-functions/get-product-site.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getProductSite = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function getProductSite(pageInstance, productCode, siteCode, storageProductSite) {\n    if (!storageProductSite) {\n        // read product site record\n        const productSiteToReceive = await pageInstance.$.graph\n            .node('@sage/x3-master-data/ProductSite')\n            .read({\n            stockSite: { code: true },\n            isLocationManaged: true,\n            isLicensePlateNumberManaged: true,\n            defaultInternalContainer: {\n                code: true,\n            },\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: true,\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n            product: {\n                code: true,\n                localizedDescription1: true,\n                productCategory: {\n                    code: true,\n                },\n                lotManagementMode: true,\n                serialNumberManagementMode: true,\n                stockVersionMode: true,\n                expirationManagementMode: true,\n                serialSequenceNumber: true,\n                lotSequenceNumber: true,\n                stockManagementMode: true,\n                defaultPotencyInPercentage: true,\n                expirationLeadTime: true,\n                expirationTimeUnit: true,\n                useByDateCoefficient: true,\n                stockUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                packingUnits: {\n                    query: {\n                        edges: {\n                            node: {\n                                packingUnit: {\n                                    code: true,\n                                    numberOfDecimals: true,\n                                },\n                                packingUnitToStockUnitConversionFactor: true,\n                                isPackingFactorEntryAllowed: true,\n                            },\n                        },\n                    },\n                },\n            },\n        }, \n        // TODO: find a better way if possible\n        `${productCode}|${siteCode}`)\n            .execute();\n        // If an error occurred during the API call\n        if (!productSiteToReceive) {\n            pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__miscellaneous_receipt_details__notification__invalid_product_site_error', `Could not retrieve your product {{ productCode }} for the site {{ siteCode }}`, {\n                productCode: productCode,\n                siteCode: siteCode,\n            }), {\n                type: 'error',\n                timeout: 5000,\n            });\n            return pageInstance.$.router.goTo('@sage/x3-stock/MobileMiscellaneousReceipt', {\n                ReturnFromDetail: 'yes',\n            });\n        }\n        return productSiteToReceive;\n    }\n    else {\n        pageInstance.$.storage.remove('productSite');\n        return JSON.parse(storageProductSite);\n    }\n}\nexports.getProductSite = getProductSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/get-product-site.ts\n");

/***/ }),

/***/ "./lib/client-functions/get-unit-number-decimals.ts":
/*!**********************************************************!*\
  !*** ./lib/client-functions/get-unit-number-decimals.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GetNumberOfDecimals = exports.getNumberOfDecimal = exports.getUnitNumberOfDecimalList = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function getUnitNumberOfDecimalList(pageInstance) {\n    try {\n        const numberOfDecimalList = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n            numberOfDecimals: true,\n        }, {\n            first: 1000,\n        }))\n            .execute());\n        return numberOfDecimalList;\n    }\n    catch (e) {\n        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-stock/pages__utils__get_unit_number_decimals_error', 'Error loading unit'), String(e));\n        return [];\n    }\n}\nexports.getUnitNumberOfDecimalList = getUnitNumberOfDecimalList;\nfunction getNumberOfDecimal(list, unit) {\n    if (unit && list) {\n        const _unitOfMeasure = list.filter(uom => typesLib.strictEq(uom.code, unit));\n        return _unitOfMeasure[0]?.numberOfDecimals ?? 0;\n    }\n    return 0;\n}\nexports.getNumberOfDecimal = getNumberOfDecimal;\nfunction GetNumberOfDecimals(pageInstance, Unit) {\n    try {\n        const numberOfDecimals = pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .read({\n            _id: true,\n            numberOfDecimals: true,\n        }, `${Unit}`)\n            .execute();\n        return numberOfDecimals.numberOfDecimals;\n    }\n    catch (e) {\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-unit', 'Error loading unit'), String(e));\n    }\n}\nexports.GetNumberOfDecimals = GetNumberOfDecimals;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9saWIvY2xpZW50LWZ1bmN0aW9ucy9nZXQtdW5pdC1udW1iZXItZGVjaW1hbHMudHMiLCJtYXBwaW5ncyI6Ijs7OztBQUNBLDhKQUFrRjtBQUNsRiwyRkFBcUY7QUFDckYsdUVBQXFDO0FBRTlCLEtBQUssVUFBVSwwQkFBMEIsQ0FBQyxZQUFxQjtJQUNsRSxJQUFJLENBQUM7UUFDRCxNQUFNLG1CQUFtQixHQUFHLCtCQUFZLEVBQ3BDLE1BQU0sWUFBWSxDQUFDLENBQUMsQ0FBQyxLQUFLO2FBQ3JCLElBQUksQ0FBQyxvQ0FBb0MsQ0FBQzthQUMxQyxLQUFLLENBQ0YsRUFBRSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQ3ZCO1lBQ0ksSUFBSSxFQUFFLElBQUk7WUFDVixnQkFBZ0IsRUFBRSxJQUFJO1NBQ3pCLEVBQ0Q7WUFDSSxLQUFLLEVBQUUsSUFBSTtTQUNkLENBQ0osQ0FDSjthQUNBLE9BQU8sRUFBRSxDQUNqQixDQUFDO1FBQ0YsT0FBTyxtQkFBbUIsQ0FBQztJQUMvQixDQUFDO0lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztRQUNULFlBQVksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FDekIsT0FBTyxFQUNQLEVBQUUsQ0FBQyxRQUFRLENBQUMsNkRBQTZELEVBQUUsb0JBQW9CLENBQUMsRUFDaEcsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUNaLENBQUM7UUFDRixPQUFPLEVBQUUsQ0FBQztJQUNkLENBQUM7QUFDTCxDQUFDO0FBM0JELGdFQTJCQztBQUVELFNBQWdCLGtCQUFrQixDQUFDLElBQXNELEVBQUUsSUFBd0I7SUFDL0csSUFBSSxJQUFJLElBQUksSUFBSSxFQUFFLENBQUM7UUFDZixNQUFNLGNBQWMsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxFQUFFLG1CQUFDLEdBQUcsQ0FBQyxJQUFJLEVBQUssSUFBSSxFQUFDLENBQUM7UUFDN0QsT0FBTyxjQUFjLENBQUMsQ0FBQyxDQUFDLEVBQUUsZ0JBQWdCLElBQUksQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFDRCxPQUFPLENBQUMsQ0FBQztBQUNiLENBQUM7QUFORCxnREFNQztBQUNELFNBQWdCLG1CQUFtQixDQUFDLFlBQXFCLEVBQUUsSUFBWTtJQUNuRSxJQUFJLENBQUM7UUFDRCxNQUFNLGdCQUFnQixHQUFHLFlBQVksQ0FBQyxDQUFDLENBQUMsS0FBSzthQUN4QyxJQUFJLENBQUMsb0NBQW9DLENBQUM7YUFDMUMsSUFBSSxDQUNEO1lBQ0ksR0FBRyxFQUFFLElBQUk7WUFDVCxnQkFBZ0IsRUFBRSxJQUFJO1NBQ3pCLEVBQ0QsR0FBRyxJQUFJLEVBQUUsQ0FDWjthQUNBLE9BQU8sRUFBRSxDQUFDO1FBRWYsT0FBTyxnQkFBZ0IsQ0FBQyxnQkFBZ0IsQ0FBQztJQUM3QyxDQUFDO0lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztRQUNULDJCQUFhLEVBQ1QsWUFBWSxFQUNaLE9BQU8sRUFDUCxFQUFFLENBQUMsUUFBUSxDQUFDLG1DQUFtQyxFQUFFLG9CQUFvQixDQUFDLEVBQ3RFLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FDWixDQUFDO0lBQ04sQ0FBQztBQUNMLENBQUM7QUF0QkQsa0RBc0JDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uL2xpYi9jbGllbnQtZnVuY3Rpb25zL2dldC11bml0LW51bWJlci1kZWNpbWFscy50cz84NjQ0Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFVuaXRPZk1lYXN1cmUgfSBmcm9tICdAc2FnZS94My1tYXN0ZXItZGF0YS1hcGknO1xuaW1wb3J0IHsgZGlhbG9nTWVzc2FnZSB9IGZyb20gJ0BzYWdlL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL2RpYWxvZ3MnO1xuaW1wb3J0IHsgRXh0cmFjdEVkZ2VzLCBleHRyYWN0RWRnZXMsIEV4dHJhY3RFZGdlc1BhcnRpYWwgfSBmcm9tICdAc2FnZS94dHJlbS1jbGllbnQnO1xuaW1wb3J0ICogYXMgdWkgZnJvbSAnQHNhZ2UveHRyZW0tdWknO1xuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gZ2V0VW5pdE51bWJlck9mRGVjaW1hbExpc3QocGFnZUluc3RhbmNlOiB1aS5QYWdlKTogUHJvbWlzZTxFeHRyYWN0RWRnZXM8VW5pdE9mTWVhc3VyZT5bXT4ge1xuICAgIHRyeSB7XG4gICAgICAgIGNvbnN0IG51bWJlck9mRGVjaW1hbExpc3QgPSBleHRyYWN0RWRnZXM8VW5pdE9mTWVhc3VyZT4oXG4gICAgICAgICAgICBhd2FpdCBwYWdlSW5zdGFuY2UuJC5ncmFwaFxuICAgICAgICAgICAgICAgIC5ub2RlKCdAc2FnZS94My1tYXN0ZXItZGF0YS9Vbml0T2ZNZWFzdXJlJylcbiAgICAgICAgICAgICAgICAucXVlcnkoXG4gICAgICAgICAgICAgICAgICAgIHVpLnF1ZXJ5VXRpbHMuZWRnZXNTZWxlY3RvcihcbiAgICAgICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2RlOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIG51bWJlck9mRGVjaW1hbHM6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZpcnN0OiAxMDAwLFxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgICAgICApXG4gICAgICAgICAgICAgICAgLmV4ZWN1dGUoKSxcbiAgICAgICAgKTtcbiAgICAgICAgcmV0dXJuIG51bWJlck9mRGVjaW1hbExpc3Q7XG4gICAgfSBjYXRjaCAoZSkge1xuICAgICAgICBwYWdlSW5zdGFuY2UuJC5kaWFsb2cubWVzc2FnZShcbiAgICAgICAgICAgICdlcnJvcicsXG4gICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svcGFnZXNfX3V0aWxzX19nZXRfdW5pdF9udW1iZXJfZGVjaW1hbHNfZXJyb3InLCAnRXJyb3IgbG9hZGluZyB1bml0JyksXG4gICAgICAgICAgICBTdHJpbmcoZSksXG4gICAgICAgICk7XG4gICAgICAgIHJldHVybiBbXTtcbiAgICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXROdW1iZXJPZkRlY2ltYWwobGlzdDogRXh0cmFjdEVkZ2VzUGFydGlhbDxVbml0T2ZNZWFzdXJlPltdIHwgdW5kZWZpbmVkLCB1bml0OiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodW5pdCAmJiBsaXN0KSB7XG4gICAgICAgIGNvbnN0IF91bml0T2ZNZWFzdXJlID0gbGlzdC5maWx0ZXIodW9tID0+IHVvbS5jb2RlID09PSB1bml0KTtcbiAgICAgICAgcmV0dXJuIF91bml0T2ZNZWFzdXJlWzBdPy5udW1iZXJPZkRlY2ltYWxzID8/IDA7XG4gICAgfVxuICAgIHJldHVybiAwO1xufVxuZXhwb3J0IGZ1bmN0aW9uIEdldE51bWJlck9mRGVjaW1hbHMocGFnZUluc3RhbmNlOiB1aS5QYWdlLCBVbml0OiBzdHJpbmcpIHtcbiAgICB0cnkge1xuICAgICAgICBjb25zdCBudW1iZXJPZkRlY2ltYWxzID0gcGFnZUluc3RhbmNlLiQuZ3JhcGhcbiAgICAgICAgICAgIC5ub2RlKCdAc2FnZS94My1tYXN0ZXItZGF0YS9Vbml0T2ZNZWFzdXJlJylcbiAgICAgICAgICAgIC5yZWFkKFxuICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgX2lkOiB0cnVlLFxuICAgICAgICAgICAgICAgICAgICBudW1iZXJPZkRlY2ltYWxzOiB0cnVlLFxuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgYCR7VW5pdH1gLFxuICAgICAgICAgICAgKVxuICAgICAgICAgICAgLmV4ZWN1dGUoKTtcblxuICAgICAgICByZXR1cm4gbnVtYmVyT2ZEZWNpbWFscy5udW1iZXJPZkRlY2ltYWxzO1xuICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgICAgZGlhbG9nTWVzc2FnZShcbiAgICAgICAgICAgIHBhZ2VJbnN0YW5jZSxcbiAgICAgICAgICAgICdlcnJvcicsXG4gICAgICAgICAgICB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtc3RvY2svZXJyb3ItbG9hZGluZy11bml0JywgJ0Vycm9yIGxvYWRpbmcgdW5pdCcpLFxuICAgICAgICAgICAgU3RyaW5nKGUpLFxuICAgICAgICApO1xuICAgIH1cbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./lib/client-functions/get-unit-number-decimals.ts\n");

/***/ }),

/***/ "./lib/client-functions/manage-pages.ts":
/*!**********************************************!*\
  !*** ./lib/client-functions/manage-pages.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.readSerialNumberFromStockId = exports.handleFilterOnChange = exports.generateStockTableFilter = exports.removeFilters = exports.findSetting = exports.managePages = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * Initialize manage page\n * @param pageInstance current page\n * @param stockSite stock site\n * @param productSite partial product site object\n * @param flowType type of flow\n * @param errorMessage error messages missing settings\n * @param stockSearchFilters mandatory array to return settings\n */\n//todo:\nfunction managePages(pageInstance, stockSite, productSite, flowType, errorMessage, stockSearchFilters) {\n    // Initializing array when undefined\n    stockSearchFilters ??= [];\n    if (stockSearchFilters.length) {\n        // remove all items in array\n        stockSearchFilters.length = 0;\n    }\n    if (!pageInstance || !stockSite || !productSite || !flowType) {\n        throw new xtrem_shared_1.SystemError('Invalid arguments');\n    }\n    const _selectedMobileSettings = JSON.parse(pageInstance.$.queryParameters?.mobileSettings);\n    if (typesLib.strictEq(_selectedMobileSettings, null)) {\n        throw new Error(errorMessage);\n    }\n    // Store value in array only when usable and return true when done\n    const _pushSettings = (field) => {\n        if (typesLib.strictNe(field, 'none')) {\n            stockSearchFilters?.push(field);\n            return true;\n        }\n        return false;\n    };\n    // The fields are memorized until they meet the none type.\n    const _allPushed = _pushSettings(_selectedMobileSettings.stockField1) &&\n        _pushSettings(_selectedMobileSettings.stockField2) &&\n        _pushSettings(_selectedMobileSettings.stockField3) &&\n        _pushSettings(_selectedMobileSettings.stockField4) &&\n        _pushSettings(_selectedMobileSettings.stockField5) &&\n        _pushSettings(_selectedMobileSettings.stockField6) &&\n        _pushSettings(_selectedMobileSettings.stockField7) &&\n        _pushSettings(_selectedMobileSettings.stockField8);\n    if (pageInstance._pageMetadata.layoutFields?.location) {\n        if (!findSetting('location', stockSearchFilters) || typesLib.strictNe(productSite.isLocationManaged, true)) {\n            pageInstance['location'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.lot) {\n        if (!findSetting('lot', stockSearchFilters) || typesLib.strictEq((productSite?.product?.lotManagementMode ?? 'notManaged'), 'notManaged')) {\n            pageInstance['lot'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.sublot)\n        if (!findSetting('sublot', stockSearchFilters) || typesLib.strictNe((productSite?.product?.lotManagementMode ?? ''), 'lotAndSublot')) {\n            pageInstance['sublot'].isHidden = true;\n        }\n    if (pageInstance._pageMetadata.layoutFields?.serialNumber) {\n        if (!findSetting('serial', stockSearchFilters) ||\n            !['receivedIssued'].includes(productSite?.product?.serialNumberManagementMode ?? 'receivedIssued')) {\n            pageInstance['serialNumber'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.status) {\n        if (!findSetting('status', stockSearchFilters)) {\n            pageInstance['status'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.packingUnit) {\n        if (!findSetting('packingUnit', stockSearchFilters)) {\n            pageInstance['packingUnit'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor) {\n        if (!findSetting('pacStkConversionFactor', stockSearchFilters)) {\n            pageInstance['packingUnitToStockUnitConversionFactor'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.identifier1) {\n        if (!findSetting('identifier1', stockSearchFilters)) {\n            pageInstance['identifier1'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.identifier2) {\n        if (!findSetting('identifier2', stockSearchFilters)) {\n            pageInstance['identifier2'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.licensePlateNumber) {\n        if (typesLib.strictNe(productSite.isLicensePlateNumberManaged, true) ||\n            !findSetting('licensePlateNumber', stockSearchFilters)) {\n            pageInstance['licensePlateNumber'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField1) {\n        if (!findSetting('customField1', stockSearchFilters)) {\n            pageInstance['stockCustomField1'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField2) {\n        if (!findSetting('customField2', stockSearchFilters)) {\n            pageInstance['stockCustomField2'].isHidden = true;\n        }\n    }\n}\nexports.managePages = managePages;\n/**\n * Search if filter\n * @param field current search field\n * @param fields list of current filter\n * @returns true when found used filter parameter\n */\nfunction findSetting(field, fields) {\n    return typesLib.gte(fields.findIndex(fld => typesLib.strictEq(fld, field)), 0);\n}\nexports.findSetting = findSetting;\n/**\n * Remove filter (asynchronous for avoiding anticipated onChange)\n * @param pageInstance current page\n */\nasync function removeFilters(pageInstance) {\n    if (pageInstance._pageMetadata.layoutFields?.location)\n        pageInstance['location'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.lot)\n        pageInstance['lot'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.sublot)\n        pageInstance['sublot'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.serialNumber)\n        pageInstance['serialNumber'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.status)\n        pageInstance['status'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.packingUnit)\n        pageInstance['packingUnit'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor)\n        pageInstance['packingUnitToStockUnitConversionFactor'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.identifier1)\n        pageInstance['identifier1'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.identifier2)\n        pageInstance['identifier2'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.licensePlateNumber)\n        pageInstance['licensePlateNumber'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField1)\n        pageInstance['stockCustomField1'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField2)\n        pageInstance['stockCustomField2'].value = null;\n}\nexports.removeFilters = removeFilters;\nfunction generateStockTableFilter(pageInstance) {\n    const stockSite = pageInstance['_stockSite'];\n    const stockFilter = {\n        availableQuantity: { _gt: '0' },\n        //      quantityInPackingUnit: { _gt: '0' },\n        isBeingCounted: false,\n        owner: stockSite?.code,\n    };\n    let parameterLocation = pageInstance.$.queryParameters?.location;\n    if (!parameterLocation &&\n        pageInstance._pageMetadata.layoutFields?.location &&\n        pageInstance['location'].value) {\n        parameterLocation = pageInstance['location'].value?.code;\n    }\n    const quantityToPick = pageInstance['_quantityToPick'] ?? null;\n    const beginSerialNumber = pageInstance['serialNumber']?.value?.code ?? null;\n    const endSerialNumber = beginSerialNumber && quantityToPick ? _calculateEndingSerialNumber(beginSerialNumber, quantityToPick) : null;\n    const isFilterSerialNumber = pageInstance['_isFilterSerialNumber'] ?? false;\n    const filterLicensePlateNumber = pageInstance._pageMetadata.layoutFields?.licensePlateNumber\n        ? pageInstance['licensePlateNumber'].value?.code\n            ? { licensePlateNumber: { code: pageInstance['licensePlateNumber'].value.code } }\n            : {}\n        : pageInstance.$.queryParameters?.licensePlateNumberOrigin\n            ? { licensePlateNumber: { code: pageInstance.$.queryParameters.licensePlateNumberOrigin } }\n            : { licensePlateNumber: { code: { _in: [undefined, ''] } } };\n    return {\n        ...stockFilter,\n        ...(pageInstance._pageMetadata.layoutFields?.product &&\n            pageInstance['product'].value?.code && {\n            product: { product: { code: pageInstance['product'].value.code } },\n        }),\n        ...filterLicensePlateNumber,\n        ...(pageInstance._pageMetadata.layoutFields?.location &&\n            !pageInstance['location'].isHidden &&\n            pageInstance['location'].value && {\n            location: { code: parameterLocation },\n        }),\n        // lot and sublot are reference fields bound to the same Lot node\n        // so first check if sublot field is enabled with a value. If so, filter for both lot and sublot\n        // otherwise check if lot field is enabled with a value. If so filter for lot and additionally sublot, if applicable\n        ...((pageInstance._pageMetadata.layoutFields?.lot &&\n            !pageInstance['lot'].isHidden &&\n            pageInstance['lot'].value?.lot && {\n            lot: pageInstance['lot'].value.lot,\n            ...(pageInstance['lot'].value.sublot && {\n                sublot: pageInstance['lot'].value.sublot,\n            }),\n        }) ||\n            (pageInstance._pageMetadata.layoutFields?.sublot &&\n                !pageInstance['sublot'].isHidden &&\n                pageInstance['sublot'].value?.sublot && {\n                lot: pageInstance['sublot'].value.lot,\n                sublot: pageInstance['sublot'].value.sublot,\n            })),\n        //...(this.sublot.value?.sublot && { sublot: this.sublot.value.sublot }),\n        ...(pageInstance._pageMetadata.layoutFields?.serialNumber &&\n            !isFilterSerialNumber &&\n            !pageInstance['serialNumber'].isHidden &&\n            pageInstance['serialNumber'].value?.code && {\n            serialNumber: pageInstance['serialNumber'].value.code,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.serialNumber &&\n            isFilterSerialNumber &&\n            beginSerialNumber &&\n            endSerialNumber && {\n            serialNumber: {\n                _gte: beginSerialNumber,\n                //                  _lte: endSerialNumber,\n            },\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.status &&\n            !pageInstance['status'].isHidden &&\n            pageInstance['status'].value && { status: { code: pageInstance['status'].value } }),\n        // ...(this.packingUnit.value && { packingUnit: this._unitMap.get(this.packingUnit.value).unit }),\n        ...(pageInstance._pageMetadata.layoutFields?.packingUnit &&\n            !pageInstance['packingUnit'].isHidden &&\n            pageInstance['packingUnit'].value && {\n            packingUnit: { code: pageInstance['packingUnit'].value },\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor &&\n            !pageInstance['packingUnitToStockUnitConversionFactor'].isHidden &&\n            pageInstance['packingUnitToStockUnitConversionFactor'].value && {\n            packingUnitToStockUnitConversionFactor: pageInstance['packingUnitToStockUnitConversionFactor']\n                .value,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.identifier1 &&\n            !pageInstance['identifier1'].isHidden &&\n            pageInstance['identifier1'].value && { identifier1: pageInstance['identifier1'].value }),\n        ...(pageInstance._pageMetadata.layoutFields?.identifier2 &&\n            !pageInstance['identifier2'].isHidden &&\n            pageInstance['identifier2'].value && { identifier2: pageInstance['identifier2'].value }),\n        ...(pageInstance._pageMetadata.layoutFields?.stockCustomField1 &&\n            !pageInstance['stockCustomField1'].isHidden &&\n            pageInstance['stockCustomField1'].value && {\n            stockCustomField1: pageInstance['stockCustomField1'].value,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.stockCustomField2 &&\n            !pageInstance['stockCustomField2'].isHidden &&\n            pageInstance['stockCustomField2'].value && {\n            stockCustomField2: pageInstance['stockCustomField2'].value,\n        }),\n    };\n}\nexports.generateStockTableFilter = generateStockTableFilter;\nfunction _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n    return startingSerialNumber.replace(/\\d+$/, match => {\n        const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n        const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n        return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n    });\n}\nasync function handleFilterOnChange(pageInstance, field, filterCriterion = null) {\n    // if field value is cleared out during onChange, then delete the corresponding filter property in stock table's filter\n    const stockKey = field.id;\n    if (!stockKey) {\n        //throw new SystemError('Invalid stock property to filter');\n        return; // do nothing?\n    }\n    if (!pageInstance._pageMetadata.layoutFields?.stock) {\n        //throw new SystemError('Invalid stock property to pageInstance');\n        return; // do nothing?\n    }\n    const stock = pageInstance['stock'];\n    const stockChangeLines = pageInstance['_stockChangeLines'] ?? null;\n    const miscellaneousStockTransactionLines = pageInstance['_miscellaneousStockTransactionLines'] ?? null;\n    const currentLine = pageInstance['_currentLine'];\n    const currentStockChangeLine = stockChangeLines ? (stockChangeLines[currentLine] ?? null) : null;\n    const currentMiscellaneousStockTransactionLine = miscellaneousStockTransactionLines\n        ? (miscellaneousStockTransactionLines[currentLine] ?? null)\n        : null;\n    const quantityToPick = pageInstance['_quantityToPick'] ?? null;\n    const beginSerialNumber = pageInstance['serialNumber']?.value?.code ?? null;\n    const endSerialNumber = beginSerialNumber && quantityToPick ? _calculateEndingSerialNumber(beginSerialNumber, quantityToPick) : null;\n    const isFilterSerialNumber = pageInstance['_isFilterSerialNumber'] ?? false;\n    // When for the tuple the value is undefined, the key is removed from the filter.\n    if (!field.value) {\n        stock.filter = {\n            ...stock.filter,\n            ...(typesLib.strictEq(stockKey, 'location') && {\n                ...(typesLib.strictEq(pageInstance.$.page.id, 'MobileSubcontractTransferDetails') && {\n                    [stockKey]: { category: { _nin: ['subcontract', 'customer'] } },\n                }),\n                ...(typesLib.strictNe(pageInstance.$.page.id, 'MobileSubcontractTransferDetails') && { [stockKey]: undefined }),\n            }),\n            ...(!['location'].includes(stockKey) && { [stockKey]: undefined }),\n        };\n    }\n    else {\n        stock.filter = {\n            ...stock.filter,\n            ...(typesLib.strictEq(stockKey, 'packingUnit') &&\n                pageInstance._pageMetadata.layoutFields?.packingUnit && {\n                [stockKey]: {\n                    code: pageInstance[stockKey].value,\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'status') && {\n                [stockKey]: {\n                    code: filterCriterion ??\n                        (field instanceof ui.fields.Reference && field?.valueField\n                            ? { [field.valueField]: field.value[field.valueField] }\n                            : field.value),\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'serialNumber') &&\n                isFilterSerialNumber &&\n                beginSerialNumber &&\n                endSerialNumber && {\n                [stockKey]: {\n                    _gte: beginSerialNumber,\n                    //                      _lte: endSerialNumber,\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'serialNumber') &&\n                !isFilterSerialNumber && {\n                [stockKey]: {\n                    _eq: beginSerialNumber,\n                },\n            }),\n            // All other cases\n            ...(!['packingUnit', 'status', 'serialNumber'].includes(stockKey) && {\n                [stockKey]: filterCriterion ??\n                    (field instanceof ui.fields.Reference && field?.valueField\n                        ? { [field.valueField]: field.value[field.valueField] }\n                        : field.value),\n            }),\n        };\n        // stock.pageSize = 1000;\n    }\n    await _setStockQuantityInPackingUnit(pageInstance, stock, currentStockChangeLine ?? currentMiscellaneousStockTransactionLine);\n    if (!field.value) {\n        field.getNextField(true)?.focus();\n    }\n}\nexports.handleFilterOnChange = handleFilterOnChange;\n/**\n * _setStockQuantityInPackingUnit\n * @param pageInstance current page\n * @param stock stock table\n * @param currentStockLine stock line for lpnOperations or MiscellaneousIssue\n */\nasync function _setStockQuantityInPackingUnit(pageInstance, stock, currentStockLine) {\n    const _stockDetails = currentStockLine?.stockDetails;\n    if (_stockDetails) {\n        stock.selectedRecords.forEach((rowId) => {\n            const stockRecord = stock.getRecordValue(rowId);\n            if (stockRecord) {\n                const qtyTotal = _stockDetails.reduce((acc, curr) => {\n                    return typesLib.add(acc, Number(curr.quantityInPackingUnit));\n                }, 0);\n                stockRecord.quantityInPackingUnit = String(qtyTotal);\n                stock.setRecordValue(stockRecord);\n            }\n        });\n        await pageInstance.$.commitValueAndPropertyChanges();\n    }\n}\n/**\n * Read one serial number for a given stock id\n * @param pageInstance current page\n * @param stockId stock id\n * @param orderBy sort order\n * @returns serial number or null\n */\nasync function readSerialNumberFromStockId(pageInstance, stockId, orderBy) {\n    if (stockId) {\n        try {\n            const serialNumber = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n                .node('@sage/x3-stock-data/SerialNumber')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }, {\n                filter: { stockId },\n                orderBy: { code: orderBy },\n            }))\n                .execute());\n            if (serialNumber[0]) {\n                return serialNumber[0];\n            }\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-serial-number-node', 'Error loading serial number node'), String(e));\n        }\n    }\n    return null;\n}\nexports.readSerialNumberFromStockId = readSerialNumberFromStockId;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/manage-pages.ts\n");

/***/ }),

/***/ "./lib/client-functions/miscellaneous-issue-details-control.ts":
/*!*********************************************************************!*\
  !*** ./lib/client-functions/miscellaneous-issue-details-control.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getStockResults = exports.savedOriginalStockLines = exports._getStockStatus = exports._getQuantityToMove = exports._getMiscellaneousIssueLineStockDetail = exports._getquantityInPackingUnitRest = exports._getQuantityInPackingUnitOrigin = exports._saveDetail = exports._serialNumberManagement = exports._miscellaneousFieldsManagement = exports._initPackingUnitFields = exports._lotManagement = exports._onChangeBody = exports._fieldsManagement = exports._calculateLineQuantity = exports._nextSerialNumber = exports._calculateEndingSerialNumber = exports._saveMiscellaneousIssue = exports._getSavedInputs = exports._isStockJournalToRecord = exports._isLineToRecord = exports._onRowUnselected = exports._onRowSelected = exports._onRowClick = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst pat_converter_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/pat-converter */ \"../../shared/x3-system/lib/shared-functions/pat-converter.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst stock_management_rules_1 = __webpack_require__(/*! ./stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\n;\nfunction _onRowClickGlobalReceivedIssue(pageInstance, currentRecord) {\n    pageInstance.serialNumberLines.isHidden = false;\n    pageInstance.serialNumberLines.value = [];\n    pageInstance._miscellaneousIssueLines.forEach(line => {\n        if (_isLineToRecord(pageInstance, currentRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation)) {\n            line.stockDetails?.forEach((detail) => {\n                if (_isStockJournalToRecord(pageInstance, currentRecord, detail)) {\n                    pageInstance.serialNumberLines.addRecord({\n                        quantity: Number(detail.quantityInPackingUnit),\n                        startingSerialNumber: detail.serialNumber,\n                    });\n                }\n            });\n        }\n    });\n    pageInstance.stock.setRecordValue(currentRecord);\n}\nfunction _onRowClickNotGlobalReceivedIssue(pageInstance, currentRecord) {\n    let lineIndex = pageInstance._miscellaneousIssueLines.findIndex(line => _isLineToRecord(pageInstance, currentRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation));\n    if (typesLib.strictEq(lineIndex, -1)) {\n        lineIndex = typesLib.sub(pageInstance._miscellaneousIssueLines.push({\n            product: pageInstance.product.value?.code,\n            productDescription: pageInstance.product.value?.description1,\n            quantityInPackingUnit: 0,\n            packingUnit: currentRecord.packingUnit?.code,\n            packingUnitToStockUnitConversionFactor: currentRecord.packingUnitToStockUnitConversionFactor,\n            quantityInStockUnit: 0,\n            lineNumber: pageInstance._currentOperation,\n            stockDetails: [],\n        }), 1);\n    }\n    pageInstance._currentLine = lineIndex;\n    let detailIndex = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails?.findIndex((detail) => _isStockJournalToRecord(pageInstance, currentRecord, detail)) ?? -1;\n    if (typesLib.gt(detailIndex, -1)) {\n        const stockDetail = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails\n            ? [detailIndex]\n            : null;\n        if (stockDetail) {\n            stockDetail.quantityInPackingUnit = currentRecord.quantityInPackingUnit;\n            stockDetail.quantityInStockUnit = typesLib.mul(Number(currentRecord.quantityInPackingUnit), Number(currentRecord.packingUnitToStockUnitConversionFactor));\n            pageInstance._currentDetail = detailIndex;\n        }\n    }\n    else {\n        const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;\n        if (stockDetails) {\n            detailIndex = typesLib.sub(stockDetails.push({\n                packingUnit: currentRecord.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: currentRecord.packingUnitToStockUnitConversionFactor,\n                quantityInPackingUnit: Number(currentRecord.quantityInPackingUnit),\n                quantityInStockUnit: typesLib.mul(Number(currentRecord.quantityInPackingUnit), Number(currentRecord.packingUnitToStockUnitConversionFactor)),\n                location: currentRecord.location?.code,\n                licensePlateNumber: currentRecord.licensePlateNumber?.code ?? '',\n                lot: currentRecord.lot,\n                status: currentRecord.status?.code ?? '',\n                sublot: currentRecord.sublot,\n                serialNumber: currentRecord.serialNumber,\n                identifier1: currentRecord.identifier1,\n                identifier2: currentRecord.identifier2,\n                stockCustomField1: currentRecord.stockCustomField1,\n                stockCustomField2: currentRecord.stockCustomField2,\n                stockUnit: pageInstance._productSite.product.stockUnit.code,\n            }), 1);\n        }\n        else {\n            detailIndex = -1;\n        }\n        pageInstance._currentDetail = detailIndex;\n    }\n    _calculateLineQuantity(pageInstance._miscellaneousIssueLines[lineIndex], pageInstance);\n}\nasync function _onRowClick(pageInstance, recordId, rowItem) {\n    pageInstance.gridBlock.selectedRecordId = recordId; // populate grid row block\n    pageInstance._stockId.value = rowItem.stockId;\n    const currentRecord = pageInstance.stock.getRecordValue(pageInstance.gridBlock.selectedRecordId);\n    const originalStockLine = pageInstance._originalStockLines?.find(line => typesLib.strictEq(recordId, line.id));\n    rowItem.quantityInPackingUnit = String(originalStockLine?.quantityInPackingUnit);\n    rowItem.quantityInStockUnit = String(originalStockLine?.quantityInStockUnit);\n    rowItem.packingUnit.code = originalStockLine?.packingUnit.code;\n    rowItem.packingUnit.numberOfDecimals = originalStockLine?.packingUnit.numberOfDecimals;\n    pageInstance.stockDetails.value = [rowItem];\n    const selectedValue = originalStockLine?.packingUnit.code;\n    const packingUnitIndex = pageInstance._packingUnits\n        .map(packingUnit => packingUnit.node.packingUnit.code)\n        .indexOf(selectedValue);\n    if (typesLib.strictNe(packingUnitIndex, -1)) {\n        const selectedUnit = pageInstance._packingUnits[packingUnitIndex].node;\n        pageInstance.packingUnitToStockUnitConversionFactorToIssue.isDisabled =\n            !selectedUnit.isPackingFactorEntryAllowed;\n        pageInstance.quantityToMove.scale = selectedUnit.packingUnit.numberOfDecimals;\n    }\n    else {\n        pageInstance.packingUnitToStockUnitConversionFactorToIssue.isDisabled = true;\n        pageInstance.quantityToMove.scale = 0;\n    }\n    pageInstance.quantityToMove.value = null;\n    pageInstance.packingUnitToStockUnitConversionFactorToIssue.value = originalStockLine?.packingUnitToStockUnitConversionFactor ?? 1;\n    pageInstance.packingUnitToIssue.value = originalStockLine?.packingUnit.code;\n    const conversionFactor = pageInstance.packingUnitToStockUnitConversionFactorToIssue.value.toString();\n    const numberOfDec = (conversionFactor.includes('.')) ? conversionFactor.split('.')[1].length : 0;\n    pageInstance.packingUnitToStockUnitConversionFactorToIssue.scale = numberOfDec;\n    if (pageInstance._packingUnits.length) {\n        pageInstance.packingUnitToIssue.isDisabled = false;\n    }\n    currentRecord.quantityInStockUnit = originalStockLine?.quantityInStockUnit;\n    currentRecord.packingUnit.code = originalStockLine?.packingUnit.code;\n    currentRecord.quantityInPackingUnit = originalStockLine?.quantityInPackingUnit;\n    if (typesLib.strictEq(pageInstance._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n        _onRowClickGlobalReceivedIssue(pageInstance, currentRecord);\n    }\n    else {\n        _onRowClickNotGlobalReceivedIssue(pageInstance, currentRecord);\n    }\n    await pageInstance.$.commitValueAndPropertyChanges();\n    await pageInstance.stock.validateWithDetails();\n    if (pageInstance.$.detailPanel)\n        pageInstance.$.detailPanel.isHidden = false;\n    pageInstance.stock.setRecordValue(currentRecord);\n}\nexports._onRowClick = _onRowClick;\nasync function _onRowSelectedGlobalReceivedIssued(pageInstance, stockRecord, lineIndex) {\n    const responseSerialNumber = await pageInstance.$.graph\n        .node('@sage/x3-stock-data/SerialNumber')\n        .query(ui.queryUtils.edgesSelector({\n        code: true,\n    }, {\n        filter: {\n            stockId: stockRecord.stockId,\n            product: { code: pageInstance.product.value?.code },\n            stockSite: { code: pageInstance.site.value },\n        },\n        first: 1001,\n    }))\n        .execute();\n    let currentSerialNumber;\n    currentSerialNumber = '';\n    let beginSerialNumber;\n    beginSerialNumber = '';\n    let quantitySerialNumber;\n    quantitySerialNumber = 0;\n    for (const itemSerialNumber of responseSerialNumber.edges) {\n        if (typesLib.strictEq(beginSerialNumber, '')) {\n            beginSerialNumber = itemSerialNumber.node.code;\n            currentSerialNumber = itemSerialNumber.node.code;\n            quantitySerialNumber = 1;\n        }\n        else if (typesLib.strictEq(itemSerialNumber.node.code, _nextSerialNumber(currentSerialNumber))) {\n            var _v;\n            currentSerialNumber = itemSerialNumber.node.code;\n            _v = quantitySerialNumber, quantitySerialNumber = typesLib.add(quantitySerialNumber, 1), _v;\n        }\n        else {\n            const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;\n            if (stockDetails) {\n                pageInstance._currentDetail = typesLib.sub(stockDetails.push({\n                    packingUnit: stockRecord.packingUnit?.code,\n                    packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,\n                    quantityInPackingUnit: quantitySerialNumber,\n                    quantityInStockUnit: typesLib.mul(Number(quantitySerialNumber), Number(stockRecord.packingUnitToStockUnitConversionFactor)),\n                    location: stockRecord.location?.code,\n                    licensePlateNumber: stockRecord.licensePlateNumber?.code ?? '',\n                    lot: stockRecord.lot,\n                    status: stockRecord.status?.code ?? '',\n                    sublot: stockRecord.sublot,\n                    serialNumber: beginSerialNumber,\n                    identifier1: stockRecord.identifier1,\n                    identifier2: stockRecord.identifier2,\n                    stockCustomField1: stockRecord.stockCustomField1,\n                    stockCustomField2: stockRecord.stockCustomField2,\n                    stockUnit: pageInstance._productSite.product.stockUnit.code,\n                }), 1);\n            }\n            else {\n                pageInstance._currentDetail = -1;\n            }\n            beginSerialNumber = itemSerialNumber.node.code;\n            currentSerialNumber = itemSerialNumber.node.code;\n            quantitySerialNumber = 1;\n        }\n    }\n    if (typesLib.strictNe(beginSerialNumber, '') && typesLib.strictNe(quantitySerialNumber, 0)) {\n        const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;\n        if (stockDetails) {\n            pageInstance._currentDetail = typesLib.sub(stockDetails.push({\n                packingUnit: stockRecord.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,\n                quantityInPackingUnit: quantitySerialNumber,\n                quantityInStockUnit: typesLib.mul(Number(quantitySerialNumber), Number(stockRecord.packingUnitToStockUnitConversionFactor)),\n                location: stockRecord.location?.code,\n                licensePlateNumber: stockRecord.licensePlateNumber?.code ?? '',\n                lot: stockRecord.lot,\n                status: stockRecord.status?.code ?? '',\n                sublot: stockRecord.sublot,\n                serialNumber: beginSerialNumber,\n                identifier1: stockRecord.identifier1,\n                identifier2: stockRecord.identifier2,\n                stockCustomField1: stockRecord.stockCustomField1,\n                stockCustomField2: stockRecord.stockCustomField2,\n                stockUnit: pageInstance._productSite.product.stockUnit.code,\n            }), 1);\n        }\n        else {\n            pageInstance._currentDetail = -1;\n        }\n    }\n}\nfunction _onRowSelectedNotGlobalReceivedIssued(pageInstance, stockRecord, lineIndex) {\n    const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;\n    if (stockDetails) {\n        let detailIndex = stockDetails.findIndex(detail => _isStockJournalToRecord(pageInstance, stockRecord, detail));\n        if (typesLib.gt(detailIndex, -1)) {\n            const stockDetail = stockDetails[detailIndex];\n            stockDetail.quantityInPackingUnit = stockRecord.quantityInPackingUnit;\n            stockDetail.quantityInStockUnit = typesLib.mul(Number(stockRecord.quantityInPackingUnit), Number(stockRecord.packingUnitToStockUnitConversionFactor));\n            pageInstance._currentDetail = detailIndex;\n        }\n        else {\n            detailIndex = typesLib.sub(stockDetails.push({\n                packingUnit: stockRecord.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,\n                quantityInPackingUnit: Number(stockRecord.quantityInPackingUnit),\n                quantityInStockUnit: typesLib.mul(Number(stockRecord.quantityInPackingUnit), Number(stockRecord.packingUnitToStockUnitConversionFactor)),\n                location: stockRecord.location?.code,\n                licensePlateNumber: stockRecord.licensePlateNumber?.code ?? '',\n                lot: stockRecord.lot,\n                status: stockRecord.status?.code ?? '',\n                sublot: stockRecord.sublot,\n                serialNumber: stockRecord.serialNumber,\n                identifier1: stockRecord.identifier1,\n                identifier2: stockRecord.identifier2,\n                stockCustomField1: stockRecord.stockCustomField1,\n                stockCustomField2: stockRecord.stockCustomField2,\n                stockUnit: pageInstance._productSite.product.stockUnit.code,\n            }), 1);\n        }\n        pageInstance._currentDetail = detailIndex;\n    }\n}\nasync function _onRowSelected(pageInstance, recordId, _rowItem) {\n    const stockRecord = pageInstance.stock.getRecordValue(recordId);\n    if (stockRecord) {\n        pageInstance.stock.isDisabled = true;\n        let lineIndex = pageInstance._miscellaneousIssueLines.findIndex(line => _isLineToRecord(pageInstance, stockRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation));\n        if (typesLib.strictEq(lineIndex, -1)) {\n            lineIndex = typesLib.sub(pageInstance._miscellaneousIssueLines.push({\n                product: pageInstance.product.value?.code,\n                productDescription: pageInstance.product.value?.description1,\n                quantityInPackingUnit: 0,\n                packingUnit: stockRecord.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,\n                quantityInStockUnit: 0,\n                lineNumber: pageInstance._currentOperation,\n                stockDetails: [],\n            }), 1);\n        }\n        pageInstance._currentLine = lineIndex;\n        if (typesLib.strictEq(pageInstance._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n            _onRowSelectedGlobalReceivedIssued(pageInstance, stockRecord, lineIndex);\n        }\n        else {\n            _onRowSelectedNotGlobalReceivedIssued(pageInstance, stockRecord, lineIndex);\n        }\n        _calculateLineQuantity(pageInstance._miscellaneousIssueLines[lineIndex], pageInstance);\n        _saveMiscellaneousIssue(pageInstance);\n        stockRecord.quantityToMove = stockRecord.quantityInPackingUnit;\n        stockRecord.quantityInStockUnit = typesLib.mul(Number(stockRecord.quantityInPackingUnit), Number(stockRecord.packingUnitToStockUnitConversionFactor));\n        pageInstance.stock.setRecordValue(stockRecord);\n        pageInstance.stock.selectRecord(recordId);\n        pageInstance.stock.isDisabled = false;\n    }\n}\nexports._onRowSelected = _onRowSelected;\nasync function _onRowUnselected(pageInstance, recordId, _rowItem) {\n    const stockRecord = pageInstance.stock.getRecordValue(recordId);\n    if (stockRecord) {\n        let i;\n        i = 0;\n        pageInstance._miscellaneousIssueLines.forEach(line => {\n            if (_isLineToRecord(pageInstance, stockRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation)) {\n                let j;\n                j = 0;\n                line.stockDetails?.forEach(stock => {\n                    var _v;\n                    if (_isStockJournalToRecord(pageInstance, stockRecord, stock)) {\n                        line.stockDetails?.splice(j, 1);\n                    }\n                    _v = j, j = typesLib.add(j, 1), _v;\n                });\n            }\n        });\n        _saveMiscellaneousIssue(pageInstance);\n        const originalStockLine = pageInstance._originalStockLines?.find(line => typesLib.strictEq(recordId, line.id));\n        stockRecord.quantityToMove = originalStockLine?.quantityInPackingUnit;\n        stockRecord.packingUnit.code = originalStockLine?.packingUnit.code;\n        stockRecord.quantityInStockUnit = originalStockLine?.quantityInStockUnit;\n        stockRecord.quantityInPackingUnit = originalStockLine?.quantityInPackingUnit;\n        pageInstance.stock.setRecordValue(stockRecord);\n    }\n}\nexports._onRowUnselected = _onRowUnselected;\nfunction _isLineToRecord(_pageInstance, record, line) {\n    return typesLib.strictEq(line.product, record.product?.product.code);\n}\nexports._isLineToRecord = _isLineToRecord;\nfunction _isStockJournalToRecord(pageInstance, record, line) {\n    return (typesLib.strictEq(line.packingUnit, (record?.packingUnit?.code ?? '')) && typesLib.strictEq(line.packingUnitToStockUnitConversionFactor, record?.packingUnitToStockUnitConversionFactor) && typesLib.strictEq(line.location, record?.location?.code) && typesLib.strictEq(line.licensePlateNumber, (record?.licensePlateNumber?.code ?? '')) && typesLib.strictEq(line.lot, record?.lot) && typesLib.strictEq(line.status, (record?.status?.code ?? '')) && typesLib.strictEq(line.sublot, record?.sublot) &&\n        (typesLib.strictEq(line.serialNumber, record?.serialNumber) || typesLib.strictEq(pageInstance._serialNumberManagementMode, 'globalReceivedIssued')) && typesLib.strictEq(line.identifier1, record?.identifier1) && typesLib.strictEq(line.identifier2, record?.identifier2) && typesLib.strictEq(line.stockCustomField1, record?.stockCustomField1) && typesLib.strictEq(line.stockCustomField2, record?.stockCustomField2));\n}\nexports._isStockJournalToRecord = _isStockJournalToRecord;\nfunction _getSavedInputs(pageInstance) {\n    return JSON.parse(pageInstance.$.storage.get('mobile-miscellaneousIssue'));\n}\nexports._getSavedInputs = _getSavedInputs;\nfunction _saveMiscellaneousIssue(pageInstance) {\n    const miscellaneousIssueLines = pageInstance._miscellaneousIssueLines ?? null;\n    const savedInputs = _getSavedInputs(pageInstance);\n    savedInputs.miscellaneousIssue.miscellaneousIssueLines = miscellaneousIssueLines;\n    savedInputs.currentLine = pageInstance._currentLine;\n    savedInputs.currentDetail = pageInstance._currentDetail;\n    pageInstance.$.storage.set('mobile-miscellaneousIssue', JSON.stringify(savedInputs));\n}\nexports._saveMiscellaneousIssue = _saveMiscellaneousIssue;\nfunction _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n    return startingSerialNumber.replace(/\\d+$/, match => {\n        const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n        const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n        return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n    });\n}\nexports._calculateEndingSerialNumber = _calculateEndingSerialNumber;\nfunction _nextSerialNumber(currentSerialNumber) {\n    return currentSerialNumber.replace(/\\d+$/, match => {\n        const nextSerialNumber = (typesLib.add(Number(match), 1)).toString();\n        const lengthDiff = typesLib.max(typesLib.sub(nextSerialNumber.length, match.length), 0);\n        return nextSerialNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n    });\n}\nexports._nextSerialNumber = _nextSerialNumber;\nfunction _calculateLineQuantity(line, pageInstance) {\n    line.quantityInPackingUnit = 0;\n    line.quantityInStockUnit = 0;\n    line.stockDetails?.forEach(detail => {\n        // line.quantityInPackingUnit =\n        //     Number(line.quantityInPackingUnit) + Number((detail as StockJournalInput).quantityInPackingUnit);\n        line.quantityInStockUnit = typesLib.add(Number(line.quantityInStockUnit), Number(detail.quantityInStockUnit));\n        line.quantityInPackingUnit = typesLib.div(line.quantityInStockUnit, (pageInstance.packingUnitToStockUnitConversionFactorToIssue.value\n            ? pageInstance.packingUnitToStockUnitConversionFactorToIssue.value\n            : 1));\n    });\n    line.packingUnit = String(pageInstance.packingUnitToIssue.value);\n}\nexports._calculateLineQuantity = _calculateLineQuantity;\nasync function _fieldsManagement(pageInstance) {\n    _lotManagement(pageInstance);\n    await _miscellaneousFieldsManagement(pageInstance);\n    _initPackingUnitFields(pageInstance);\n    _serialNumberManagement(pageInstance);\n}\nexports._fieldsManagement = _fieldsManagement;\nasync function _onChangeBody(pageInstance) {\n    const currentRecord = pageInstance.gridBlock.selectedRecordId\n        ? pageInstance.stock.getRecordValue(pageInstance.gridBlock.selectedRecordId)\n        : null;\n    if (!currentRecord) {\n        return;\n    }\n    const currentQty = typesLib.mul(Number(pageInstance.quantityToMove.value), (Number(pageInstance.packingUnitToStockUnitConversionFactorToIssue.value)));\n    if (!currentQty || !pageInstance.startingSerialNumber.value || !pageInstance.startingSerialNumber.value.code) {\n        pageInstance.endingSerialNumber.value = null;\n        return;\n    }\n    pageInstance.startingSerialNumber.value.code = pageInstance.startingSerialNumber.value.code.toUpperCase();\n    if (typesLib.gt(currentQty, 1)) {\n        pageInstance.endingSerialNumber.value = _calculateEndingSerialNumber(pageInstance.startingSerialNumber.value.code, currentQty);\n    }\n    else {\n        pageInstance.endingSerialNumber.value = pageInstance.startingSerialNumber.value.code;\n    }\n    if (typesLib.gt(currentQty, currentRecord.quantityInPackingUnitOrigin))\n        pageInstance.addSerialRange.isHidden = true;\n    else {\n        pageInstance.addSerialRange.isHidden = false;\n    }\n    // validate range does not contain existing or non-existent serial numbers\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const validationResult = await pageInstance.endingSerialNumber.validate();\n    if (validationResult) {\n        pageInstance.$.showToast(validationResult, { type: 'warning' });\n    }\n}\nexports._onChangeBody = _onChangeBody;\nfunction _lotManagement(pageInstance) {\n    pageInstance.lot.isHidden = typesLib.strictEq(pageInstance._productSite.product.lotManagementMode, 'notManaged');\n    pageInstance.sublot.isHidden = typesLib.strictNe(pageInstance._productSite.product.lotManagementMode, 'lotAndSublot');\n}\nexports._lotManagement = _lotManagement;\nfunction _initPackingUnitFields(pageInstance) {\n    const productPackingList = (0, xtrem_client_1.extractEdges)(pageInstance._productSite.product.packingUnits.query).filter(productPacking => {\n        return !!productPacking.packingUnit?.code;\n    });\n    pageInstance._packingUnits = productPackingList.map(productPacking => {\n        return { node: productPacking };\n    });\n    const productPakingUnitSelectValues = productPackingList.map(productPacking => {\n        return `${productPacking.packingUnit.code}`;\n    });\n    pageInstance.packingUnit.options = [\n        pageInstance._productSite.product.stockUnit.code,\n        ...productPakingUnitSelectValues,\n    ];\n}\nexports._initPackingUnitFields = _initPackingUnitFields;\nasync function _miscellaneousFieldsManagement(pageInstance) {\n    if (!(pageInstance.lot.isHidden || !!pageInstance._productSite.product.lotSequenceNumber) &&\n        ['lotAndSublot', 'mandatoryLot'].includes(pageInstance._productSite.product.lotManagementMode))\n        pageInstance.lot.isMandatory = true;\n    const transaction = _getSavedInputs(pageInstance).selectedTransaction;\n    if (typesLib.strictEq(transaction.isStatusChange, true))\n        pageInstance.status.isMandatory = true;\n    pageInstance._selectedStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(pageInstance._stockSite.code, pageInstance._productSite.product.productCategory.code, '26', transaction.stockMovementCode?.code ?? null, pageInstance);\n    pageInstance.status.options = await _getStockStatus(pageInstance);\n}\nexports._miscellaneousFieldsManagement = _miscellaneousFieldsManagement;\nfunction _serialNumberManagement(pageInstance) {\n    pageInstance.serialNumber.isHidden = ['notManaged', 'issued'].includes(pageInstance._productSite.product.serialNumberManagementMode);\n    if (['receivedIssued', 'globalReceivedIssued'].includes(pageInstance._productSite.product.serialNumberManagementMode)) {\n        pageInstance.serialNumber.isMandatory = true;\n        if (typesLib.strictEq(pageInstance.lot.isHidden, false))\n            pageInstance.lot.isMandatory = false;\n        if (typesLib.strictEq(pageInstance.sublot.isHidden, false))\n            pageInstance.sublot.isMandatory = false;\n        if (typesLib.strictEq(pageInstance.status.isHidden, false))\n            pageInstance.status.isMandatory = false;\n        if (typesLib.strictEq(pageInstance.packingUnit.isHidden, false))\n            pageInstance.packingUnit.isMandatory = false;\n    }\n}\nexports._serialNumberManagement = _serialNumberManagement;\nfunction _saveDetail(pageInstance) {\n    const currentmiscellaneousIssueLines = pageInstance._miscellaneousIssueLines[pageInstance._currentLine];\n    pageInstance._miscellaneousIssueLines[pageInstance._currentLine] = {\n        ...currentmiscellaneousIssueLines,\n    };\n    _saveMiscellaneousIssue(pageInstance);\n}\nexports._saveDetail = _saveDetail;\nfunction _getQuantityInPackingUnitOrigin(pageInstance, record) {\n    if (record.quantityInPackingUnitOrigin) {\n        return record.quantityInPackingUnitOrigin;\n    }\n    else {\n        let miscellaneousIssueLines = pageInstance._miscellaneousIssueLines;\n        if (typesLib.strictEq(miscellaneousIssueLines, undefined)) {\n            miscellaneousIssueLines = _getSavedInputs(pageInstance).miscellaneousIssue.miscellaneousIssueLines ?? [];\n        }\n        let _quantityInPackingUnitOrigin;\n        _quantityInPackingUnitOrigin = Number(record.quantityInPackingUnit);\n        miscellaneousIssueLines.forEach(line => {\n            if (_isLineToRecord(pageInstance, record, line) && typesLib.strictNe(line.lineNumber, pageInstance._currentOperation)) {\n                line.stockDetails?.forEach(detail => {\n                    if (_isStockJournalToRecord(pageInstance, record, detail)) {\n                        _quantityInPackingUnitOrigin = typesLib.sub(Number(_quantityInPackingUnitOrigin), Number(detail.quantityInPackingUnit));\n                    }\n                });\n            }\n        });\n        return _quantityInPackingUnitOrigin;\n    }\n}\nexports._getQuantityInPackingUnitOrigin = _getQuantityInPackingUnitOrigin;\nfunction _getquantityInPackingUnitRest(pageInstance, record) {\n    let miscellaneousIssueLines = pageInstance._miscellaneousIssueLines;\n    if (typesLib.strictEq(miscellaneousIssueLines, undefined)) {\n        miscellaneousIssueLines = _getSavedInputs(pageInstance).miscellaneousIssue.miscellaneousIssueLines ?? [];\n    }\n    if (typesLib.strictEq(pageInstance._serialNumberManagementMode, undefined)) {\n        pageInstance._serialNumberManagementMode =\n            _getSavedInputs(pageInstance).selectedProduct?.serialNumberManagementMode;\n    }\n    let _quantityInPackingUnitRest = _getQuantityInPackingUnitOrigin(pageInstance, record);\n    if (typesLib.strictEq(pageInstance._serialNumberManagementMode, 'globalReceivedIssued')) {\n        pageInstance._miscellaneousIssueLines?.forEach(line => {\n            if (_isLineToRecord(pageInstance, record, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation)) {\n                line.stockDetails?.forEach(detail => {\n                    if (_isStockJournalToRecord(pageInstance, record, detail)) {\n                        _quantityInPackingUnitRest = typesLib.sub(Number(_quantityInPackingUnitRest), Number(detail.quantityInPackingUnit));\n                    }\n                });\n            }\n        });\n    }\n    return _quantityInPackingUnitRest;\n}\nexports._getquantityInPackingUnitRest = _getquantityInPackingUnitRest;\nfunction _getMiscellaneousIssueLineStockDetail(pageInstance, record) {\n    let miscellaneousIssueLines = pageInstance._miscellaneousIssueLines;\n    if (typesLib.strictEq(miscellaneousIssueLines, undefined)) {\n        miscellaneousIssueLines = _getSavedInputs(pageInstance).miscellaneousIssue.miscellaneousIssueLines ?? [];\n    }\n    const _line = miscellaneousIssueLines.find(line => _isLineToRecord(pageInstance, record, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation));\n    if (_line) {\n        return _line.stockDetails?.find(detail => _isStockJournalToRecord(pageInstance, record, detail));\n    }\n    else {\n        return undefined;\n    }\n}\nexports._getMiscellaneousIssueLineStockDetail = _getMiscellaneousIssueLineStockDetail;\nfunction _getQuantityToMove(pageInstance, record) {\n    const line = _getMiscellaneousIssueLineStockDetail(pageInstance, record);\n    let _quantityToMove;\n    if (line) {\n        _quantityToMove = Number(line.quantityInPackingUnit);\n    }\n    else {\n        _quantityToMove = Number(record.quantityInPackingUnit);\n    }\n    const _quantityInPackingUnitRest = _getquantityInPackingUnitRest(pageInstance, record);\n    if (typesLib.gt(Number(_quantityToMove), Number(_quantityInPackingUnitRest))) {\n        _quantityToMove = Number(_quantityInPackingUnitRest);\n    }\n    return _quantityToMove;\n}\nexports._getQuantityToMove = _getQuantityToMove;\nasync function _getStockStatus(pageInstance) {\n    const selectedStatus = [];\n    pageInstance._selectedStockManagementRules.authorizedSubstatus.split(',').forEach(function (status) {\n        selectedStatus.push({ _regex: (0, pat_converter_1.getRegExp)(status).source });\n    });\n    const response = await pageInstance.$.graph\n        .node('@sage/x3-stock-data/StockStatus')\n        .query(ui.queryUtils.edgesSelector({\n        _id: true,\n        code: true,\n    }, {\n        filter: {\n            code: { _or: selectedStatus },\n        },\n    }))\n        .execute();\n    if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n        throw new Error(ui.localize('@sage/x3-stock/pages__stock_change_details__notification__invalid_stock_status_error', 'No stock status'));\n    }\n    return response.edges.map((stockStatus) => stockStatus.node.code);\n}\nexports._getStockStatus = _getStockStatus;\nasync function savedOriginalStockLines(pageInstance) {\n    const page = pageInstance;\n    const _stockQueryResult = await getStockResults(page, page.stock.filter);\n    page._originalStockLines = [{}];\n    _stockQueryResult?.forEach((line) => {\n        if (typesLib.lt(page._originalStockLines.findIndex((element) => typesLib.strictEq(element.id, line._id)), 0)) {\n            page._originalStockLines.push({\n                id: line._id ?? '',\n                stockId: line.stockId ?? '',\n                packingUnit: line.packingUnit,\n                packingUnitToStockUnitConversionFactor: Number(line.packingUnitToStockUnitConversionFactor),\n                quantityInStockUnit: Number(line.quantityInStockUnit),\n                quantityInPackingUnit: Number(line.quantityInPackingUnit),\n            });\n        }\n    });\n    page._originalStockLines.splice(0, 1);\n}\nexports.savedOriginalStockLines = savedOriginalStockLines;\nasync function getStockResults(pageInstance, filter, maxResult = 500) {\n    const page = pageInstance;\n    return (0, xtrem_client_1.extractEdges)(await page.$.graph\n        .node('@sage/x3-stock-data/Stock')\n        .query(ui.queryUtils.edgesSelector({\n        owner: true,\n        qualityAnalysisRequestId: true,\n        allocatedQuantity: true,\n        quantityInStockUnit: true,\n        lotReference: {\n            majorVersion: {\n                _id: true,\n                code: true,\n            },\n            lotCustomField2: true,\n            lotCustomField1: true,\n            useByDate: true,\n            expirationDate: true,\n        },\n        stockId: true,\n        stockCustomField2: true,\n        stockCustomField1: true,\n        identifier2: true,\n        identifier1: true,\n        packingUnitToStockUnitConversionFactor: true,\n        packingUnit: {\n            code: true,\n            numberOfDecimals: true,\n        },\n        status: { code: true },\n        serialNumber: true,\n        sublot: true,\n        lot: true,\n        location: {\n            _id: true,\n            code: true,\n            category: true,\n        },\n        licensePlateNumber: { code: true },\n        product: {\n            product: {\n                _id: true,\n                code: true,\n                stockUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                serialNumberManagementMode: true,\n                lotManagementMode: true,\n                description1: true,\n                localizedDescription1: true,\n                expirationManagementMode: true,\n                productCategory: { code: true },\n                productSites: {\n                    query: {\n                        edges: {\n                            node: {\n                                stockSite: {\n                                    code: true\n                                },\n                            },\n                        },\n                    },\n                },\n            },\n        },\n        quantityInPackingUnit: true,\n        _id: true,\n        availableQuantity: true,\n        isBeingCounted: true,\n    }, {\n        filter,\n        first: typesLib.max(maxResult, 500),\n    }))\n        .execute());\n}\nexports.getStockResults = getStockResults;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/miscellaneous-issue-details-control.ts\n");

/***/ }),

/***/ "./lib/client-functions/stock-management-rules.ts":
/*!********************************************************!*\
  !*** ./lib/client-functions/stock-management-rules.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.findDefaultLocation = exports.findStockManagementRules = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance) {\n    try {\n        //read the stock management rules\n        const stockManagementRules = await pageInstance.$.graph\n            .node('@sage/x3-stock-data/StockManagementRules')\n            .query(ui.queryUtils.edgesSelector({\n            productCategory: { code: true },\n            stockSite: { code: true },\n            transactionType: true,\n            stockMovementCode: { code: true },\n            defaultStatus: true,\n            locationNumber: true,\n            locationNumber2: true,\n            locationNumber3: true,\n            authorizedStatus: true,\n            authorizedSubstatus: true,\n            hasAnalysisRequest: true,\n            lotEntry: true,\n            lotByDefault: true,\n            outputLot: true,\n            isExclusiveEntryVersion: true,\n            activeVersion: true,\n            licensePlateNumberEntry: true,\n            versionStopped: true,\n            prototypeVersion: true,\n        }, {\n            filter: {\n                productCategory: { code: productCategory },\n                stockSite: { code: stockSite },\n                transactionType: transactionType,\n                stockMovementCode: { code: stockMovementCode },\n            },\n        }))\n            .execute();\n        if (typesLib.gt(stockManagementRules.edges.length, 0))\n            return stockManagementRules.edges[0].node;\n        else\n            return null;\n    }\n    catch (e) { }\n}\nasync function findStockManagementRules(stockSite, productCategory, transactionType, //TRSTYP, menu 704\nstockMovementCode, //TRSCOD\npageInstance) {\n    // for the stock site, the product category and the movement code\n    let stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for stock site and product category\n    stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category and movement code\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // general rules\n    stockManagementRules = await _readStockManagementRules(null, null, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    throw new Error(ui.localize('@sage/x3-stock/stock_management_rules__notification__no_management_rules_error', `Could not retrieve the management rules for your product category {{ productCategory }} and for the site {{ siteCode }}`, { productCategory: productCategory, siteCode: stockSite }));\n}\nexports.findStockManagementRules = findStockManagementRules;\nasync function _readProductCategorySite(stockSite, productCategory, pageInstance) {\n    try {\n        //read the product category site\n        const productCategorySite = await pageInstance.$.graph\n            .node('@sage/x3-master-data/productCategory')\n            .read({\n            stockSite: { code: true },\n            code: true,\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: true,\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n        }, \n        // TODO: find a better way if possible\n        `${stockSite}|${productCategory}`)\n            .execute();\n        return productCategorySite ?? null;\n    }\n    catch (e) {\n        return null;\n    }\n}\nasync function findDefaultLocation(productSite, stockManagementRules, pageInstance) {\n    // find the default location for the product site\n    const defaultLocation = productSite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n    if (defaultLocation &&\n        defaultLocation.node.defaultLocation &&\n        !defaultLocation.node.defaultLocation.match(/[* ! # ?]/))\n        return defaultLocation.node.defaultLocation;\n    // find the default location for the product category site\n    const ProductCategorySite = await _readProductCategorySite(productSite.stockSite.code, productSite.product.productCategory.code, pageInstance);\n    if (ProductCategorySite) {\n        const defaultLocationCateg = ProductCategorySite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n        if (defaultLocationCateg &&\n            defaultLocationCateg.node.defaultLocation &&\n            !defaultLocationCateg.node.defaultLocation.match(/[* ! # ?]/))\n            return defaultLocationCateg.node.defaultLocation;\n    }\n    return null;\n}\nexports.findDefaultLocation = findDefaultLocation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/stock-management-rules.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-miscellaneous-issue-details.ts":
/*!*********************************************************!*\
  !*** ./lib/pages/mobile-miscellaneous-issue-details.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileMiscellaneousIssueDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_count_serial_number_1 = __webpack_require__(/*! @sage/x3-stock-data/lib/client-functions/get-count-serial-number */ \"../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst get_product_site_1 = __webpack_require__(/*! ../client-functions/get-product-site */ \"./lib/client-functions/get-product-site.ts\");\nconst get_unit_number_decimals_1 = __webpack_require__(/*! ../client-functions/get-unit-number-decimals */ \"./lib/client-functions/get-unit-number-decimals.ts\");\nconst manage_pages_1 = __webpack_require__(/*! ../client-functions/manage-pages */ \"./lib/client-functions/manage-pages.ts\");\nconst miscellaneous_issue_details_control_1 = __webpack_require__(/*! ../client-functions/miscellaneous-issue-details-control */ \"./lib/client-functions/miscellaneous-issue-details-control.ts\");\nconst hideWhenEmptyValue = (value) => {\n    return typesLib.strictNe(typeof value, 'number') && !value; // we don't want to hide numeric field with value of 0\n};\n/** Created with X3 Etna Studio at 2020-01-20T10:46:11.764Z */\nlet MobileMiscellaneousIssueDetails = class MobileMiscellaneousIssueDetails extends ui.Page {\n    constructor() {\n        /*\n         *\n         *  Technical properties\n         *\n         */\n        super(...arguments);\n        this._currentLine = 0;\n        this._currentDetail = 0;\n    }\n    /*\n     *\n     *  Init functions\n     *\n     */\n    async _init() {\n        const productCode = (0, miscellaneous_issue_details_control_1._getSavedInputs)(this).selectedProduct?.code ?? '';\n        this._miscellaneousIssueLines = (0, miscellaneous_issue_details_control_1._getSavedInputs)(this).miscellaneousIssue.miscellaneousIssueLines ?? [];\n        this._initSiteCodeField();\n        this._productSite = await (0, get_product_site_1.getProductSite)(this, productCode, this.site.value ?? '', '');\n        this._initPackingUnitFields();\n        this._initTechnicalProperties();\n        await (0, miscellaneous_issue_details_control_1._fieldsManagement)(this);\n    }\n    _initSiteCodeField() {\n        // assign site code\n        const siteCode = this.$.storage.get('mobile-selected-stock-site');\n        if (siteCode) {\n            this.site.value = siteCode;\n        }\n    }\n    _initTechnicalProperties() {\n        this.product.value = {\n            code: this._productSite.product.code,\n            serialNumberManagementMode: this._productSite.product.serialNumberManagementMode,\n            lotManagementMode: this._productSite.product.lotManagementMode,\n            expirationManagementMode: this._productSite.product.expirationManagementMode,\n            stockUnit: {\n                code: this._productSite.product.stockUnit.code,\n                numberOfDecimals: this._productSite.product.stockUnit.numberOfDecimals,\n            },\n        };\n        this.localizedDescription.value = this._productSite.product.localizedDescription1;\n    }\n    async _onChangeLot() {\n        if (!this.lot.value) {\n            this.stock.filter = {\n                ...this.stock.filter,\n                lot: undefined,\n                ...(typesLib.strictEq(this.product.value?.lotManagementMode, 'lotAndSublot') && { sublot: undefined }),\n            };\n            if (!this.sublot.isHidden) {\n                this.sublot.value = null;\n            }\n            return;\n        }\n        if (!this.sublot.isHidden) {\n            this.sublot.value = this.lot.value; // update sublot field if available, for display purposes only\n        }\n        this.stock.filter = {\n            ...this.stock.filter,\n            lot: this.lot.value.lot,\n            ...(this.lot.value?.sublot && { sublot: this.lot.value.sublot }),\n        };\n        this.lot.getNextField(true)?.focus();\n    }\n    async _onChangeSerialNumber() {\n        await (0, manage_pages_1.handleFilterOnChange)(this, this.serialNumber, this.serialNumber.value?.code);\n    }\n    _initPackingUnitFields() {\n        let productPackingList = (0, xtrem_client_1.extractEdges)(this._productSite.product.packingUnits.query).filter(productPacking => {\n            return !!productPacking.packingUnit?.code;\n        });\n        this._packingUnits = productPackingList.map(productPacking => {\n            return { node: productPacking };\n        });\n        let productPackingUnitSelectValues = productPackingList.map(productPacking => {\n            return `${productPacking.packingUnit.code}`;\n        });\n        this.packingUnitToIssue.options = [this._productSite.product.stockUnit.code, ...productPackingUnitSelectValues];\n        this.packingUnitToIssue.value = this.packingUnitToIssue.options[0];\n        this.packingUnitToStockUnitConversionFactorToIssue.value = 1;\n        this.packingUnitToIssue.value\n            ? (this.quantityToMove.scale = (0, get_unit_number_decimals_1.GetNumberOfDecimals)(this, this.packingUnitToIssue.value))\n            : (this.quantityToMove.scale = 0);\n    }\n};\nexports.MobileMiscellaneousIssueDetails = MobileMiscellaneousIssueDetails;\n__decorate([\n    ui.decorators.referenceField({\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        isTransient: false,\n        isTitleHidden: true,\n        //        isReadOnly: true,\n        isDisabled: true,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.select({\n                bind: 'lotManagementMode',\n                optionType: '@sage/x3-stock-data/LotManagementMode',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'serialNumberManagementMode',\n                optionType: '@sage/x3-master-data/SerialNumberManagement',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'expirationManagementMode',\n                optionType: '@sage/x3-master-data/ExpirationManagement',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'stockVersionMode',\n                optionType: '@sage/x3-stock-data/StockVersionMode',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                bind: 'stockUnit',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                bind: 'stockUnit',\n                valueField: 'numberOfDecimals',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        bind: 'isLocationManaged',\n        isTransient: false,\n        isHidden: true,\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"isLocationManaged\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        bind: 'isLicensePlateNumberManaged',\n        isTransient: false,\n        isHidden: true,\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"isLicensePlateNumberManaged\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n        size: 'small',\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"localizedDescription\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n        prefix: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__site____prefix\", \"Site\"),\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__nextButton____title\", \"Next\"),\n        shortcut: ['f2'], // TODO Implement: What should the shortcut be for this button?\n        buttonType: 'primary',\n        async onClick() {\n            if (typesLib.gt(this.stock.selectedRecords.length, 0)) {\n                await this.$.commitValueAndPropertyChanges();\n                this.$.setPageClean();\n                const savedInputs = (0, miscellaneous_issue_details_control_1._getSavedInputs)(this);\n                savedInputs.currentLine = this._currentLine;\n                savedInputs.currentDetail = this._currentDetail;\n                this.$.storage.set('mobile-miscellaneousIssue', JSON.stringify(savedInputs));\n                this.$.router.goTo('@sage/x3-stock/MobileMiscellaneousIssue', { ReturnFromDetail: 'yes' });\n            }\n            else {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__stock_change_lines__notification__no_stock_error', `Select at least one stock line.`));\n            }\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__helperCancelButton____title\", \"Cancel\"),\n        //shortcut: ['f2'], // TODO Implement: What should the shortcut be for this button?\n        buttonType: 'secondary',\n        async onClick() {\n            const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n            if (currentRecord) {\n                let i;\n                i = 0;\n                this._miscellaneousIssueLines.forEach(line => {\n                    if ((0, miscellaneous_issue_details_control_1._isLineToRecord)(this, currentRecord, line) && typesLib.strictEq(line.lineNumber, this._currentOperation)) {\n                        let j;\n                        j = 0;\n                        line.stockDetails?.forEach(stock => {\n                            var _v;\n                            if ((0, miscellaneous_issue_details_control_1._isStockJournalToRecord)(this, currentRecord, stock)) {\n                                line.stockDetails?.splice(j, 1);\n                            }\n                            _v = j, j = typesLib.add(j, 1), _v;\n                        });\n                    }\n                });\n            }\n            (0, miscellaneous_issue_details_control_1._saveMiscellaneousIssue)(this);\n            const originalStockLine = this._originalStockLines.find(line => typesLib.strictEq(currentRecord?._id, line.id));\n            currentRecord.quantityToMove = originalStockLine?.quantityInPackingUnit;\n            currentRecord.packingUnit = originalStockLine?.packingUnit;\n            currentRecord.quantityInStockUnit = originalStockLine?.quantityInStockUnit;\n            this.packingUnitToIssue.value = null;\n            this.stock.unselectRecord(this.gridBlock.selectedRecordId);\n            this.stock.setRecordValue(currentRecord);\n            this.$.detailPanel.isHidden = true;\n            this.nextButton.isHidden = false;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"helperCancelButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__helperSelectButton____title\", \"Select\"),\n        //shortcut: ['f2'], // TODO Implement: What should the shortcut be for this button?\n        buttonType: 'primary',\n        onError(error) {\n            if (typesLib.strictEq(error.message, '@sage/x3-stock/pages__stock_change_lines__notification__error_startingSerialNumberMandatory')) {\n                return ui.localize('@sage/x3-stock/pages__stock_change_lines__notification__error_startingSerialNumberMandatory', 'You need to select the serial number and add it first.');\n            }\n            else {\n                return error;\n            }\n        },\n        async onClick() {\n            await this.$.commitValueAndPropertyChanges();\n            const errors = await this.stock.validateWithDetails();\n            if (typesLib.strictEq(errors.length, 0)) {\n                const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n                if (typesLib.strictEq(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                    if (typesLib.strictEq(this.serialNumberLines.value.length, 0)) {\n                        throw new Error('@sage/x3-stock/pages__stock_change_lines__notification__error_startingSerialNumberMandatory');\n                    }\n                }\n                else {\n                    if (typesLib.lte(Number(this.quantityToMove.value), 0)) {\n                        await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__stock_change_lines__quantityInPackingUnitDestination_must_be_greater_than_0', 'The quantity to issue must be greater than 0.'));\n                        return;\n                    }\n                }\n                if (typesLib.gt(typesLib.mul((this.quantityToMove.value ? Number(this.quantityToMove.value) : 0), (this.packingUnitToStockUnitConversionFactorToIssue.value\n                    ? Number(this.packingUnitToStockUnitConversionFactorToIssue.value)\n                    : 1)), Number(typesLib.sub(currentRecord.quantityInStockUnit, currentRecord.allocatedQuantity)))) {\n                    await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), `${ui.localize('@sage/x3-stock/pages__stock_change_lines__enter_a_quantity_less_than_or_equal_to_the_stock_quantity_minus_allocated_quantity', 'Enter a quantity less than or equal to the stock quantity minus the allocated quantity.')}`);\n                    this.quantityToMove.value = null;\n                    return;\n                }\n                this.stock.selectRecord(this.gridBlock.selectedRecordId);\n                if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                    let lineIndex = this._miscellaneousIssueLines.findIndex(line => (0, miscellaneous_issue_details_control_1._isLineToRecord)(this, currentRecord, line) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n                    if (typesLib.strictEq(lineIndex, -1)) {\n                        lineIndex = typesLib.sub(this._miscellaneousIssueLines.push({\n                            product: this.product.value.code,\n                            productDescription: this.product.value.description1,\n                            quantityInPackingUnit: 0,\n                            packingUnit: this.packingUnitToIssue.value\n                                ? this.packingUnitToIssue.value\n                                : currentRecord.packingUnit.code,\n                            packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorToIssue.value),\n                            lineNumber: this._currentOperation,\n                            stockDetails: [],\n                        }), 1);\n                    }\n                    else {\n                        this._miscellaneousIssueLines[lineIndex].packingUnit = this.packingUnitToIssue.value\n                            ? this.packingUnitToIssue.value\n                            : currentRecord.packingUnit.code;\n                        this._miscellaneousIssueLines[lineIndex].packingUnitToStockUnitConversionFactor = Number(this.packingUnitToStockUnitConversionFactorToIssue.value);\n                        this._miscellaneousIssueLines[lineIndex].quantityInPackingUnit = Number(this.quantityToMove.value);\n                    }\n                    const detailIndex = this._miscellaneousIssueLines[lineIndex].stockDetails.findIndex(detail => (0, miscellaneous_issue_details_control_1._isStockJournalToRecord)(this, currentRecord, detail));\n                    if (typesLib.gt(detailIndex, -1)) {\n                        this._miscellaneousIssueLines[lineIndex].stockDetails[detailIndex].quantityInPackingUnit = typesLib.div((typesLib.mul(Number(this.quantityToMove.value), (this.packingUnitToStockUnitConversionFactorToIssue.value\n                            ? this.packingUnitToStockUnitConversionFactorToIssue.value\n                            : 0))), (currentRecord.packingUnitToStockUnitConversionFactor\n                            ? currentRecord.packingUnitToStockUnitConversionFactor\n                            : 1)),\n                            (this._miscellaneousIssueLines[lineIndex].stockDetails[detailIndex].quantityInStockUnit = typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToIssue.value)));\n                    }\n                    else {\n                        this._miscellaneousIssueLines[lineIndex].stockDetails?.push({\n                            packingUnit: currentRecord.packingUnit?.code,\n                            packingUnitToStockUnitConversionFactor: currentRecord.packingUnitToStockUnitConversionFactor,\n                            quantityInPackingUnit: Number(this.quantityToMove.value),\n                            quantityInStockUnit: typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToIssue.value)),\n                            location: currentRecord.location?.code,\n                            licensePlateNumber: currentRecord.licensePlateNumber?.code ?? undefined,\n                            lot: currentRecord.lot ?? undefined,\n                            status: currentRecord.status?.code ?? undefined,\n                            sublot: currentRecord.sublot ?? undefined,\n                            serialNumber: currentRecord.serialNumber ?? undefined,\n                            identifier1: currentRecord.identifier1 ?? undefined,\n                            identifier2: currentRecord.identifier2 ?? undefined,\n                            stockCustomField1: currentRecord.stockCustomField1 ?? undefined,\n                            stockCustomField2: currentRecord.stockCustomField2 ?? undefined,\n                            stockUnit: this.product.value?.stockUnit?.code,\n                        });\n                    }\n                    (0, miscellaneous_issue_details_control_1._calculateLineQuantity)(this._miscellaneousIssueLines[lineIndex], this);\n                    (0, miscellaneous_issue_details_control_1._saveDetail)(this);\n                }\n                let qtyTotalInPackingUnit;\n                qtyTotalInPackingUnit = 0;\n                this._miscellaneousIssueLines.forEach(line => {\n                    if ((0, miscellaneous_issue_details_control_1._isLineToRecord)(this, currentRecord, line) && typesLib.strictEq(line.lineNumber, this._currentOperation)) {\n                        line.stockDetails?.forEach(detail => {\n                            if ((0, miscellaneous_issue_details_control_1._isStockJournalToRecord)(this, currentRecord, detail)) {\n                                qtyTotalInPackingUnit = typesLib.add(qtyTotalInPackingUnit, Number(detail.quantityInPackingUnit));\n                            }\n                        });\n                    }\n                });\n                const originalStockLine = this._originalStockLines?.find(line => typesLib.strictEq(this.gridBlock.selectedRecordId, line.id));\n                currentRecord.quantityToMove = this.quantityToMove.value;\n                currentRecord.quantityInPackingUnit = originalStockLine?.quantityInPackingUnit;\n                currentRecord.quantityInStockUnit = typesLib.mul(qtyTotalInPackingUnit, Number(currentRecord.packingUnitToStockUnitConversionFactor));\n                const packingUnitIndex = this._packingUnits\n                    .map(packingUnit => packingUnit.node.packingUnit.code)\n                    .indexOf(this.packingUnitToIssue.value ?? '');\n                if (typesLib.strictNe(packingUnitIndex, -1)) {\n                    const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                    currentRecord.packingUnit = selectedUnit.packingUnit;\n                }\n                else {\n                    currentRecord.packingUnit.code = this.packingUnitToIssue.value;\n                }\n                this.stock.setRecordValue(currentRecord);\n                this.packingUnitToIssue.value = null;\n            }\n            this.$.detailPanel.isHidden = true;\n            this.nextButton.isHidden = false;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"helperSelectButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        icon: 'add',\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__addSerialRange____title\", \"Add...\"),\n        onError(error) {\n            switch (error.message) {\n                case '@sage/x3-stock/pages__mobile_miscellaneous-issue-details_lines__notification__error_startingSerialNumber': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_miscellaneous-issue-details_lines__notification__error_startingSerialNumber', 'The serial number is mandatory');\n                }\n                case '@sage/x3-stock/serial-number-range-overlap': {\n                    return ui.localize('@sage/x3-stock/serial-number-range-overlap', 'The serial numbers are overlapping. Enter another starting or ending serial number.');\n                }\n                case '@sage/x3-stock/pages__mobile_miscellaneous-issue-details__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_miscellaneous-issue-details__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move', 'Select the same amount of serial numbers in the range to match the quantity to issue.');\n                }\n                case '@sage/x3-stock/serial-number-not-sequential': {\n                    return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n                }\n                default: {\n                    return error;\n                }\n            }\n        },\n        buttonType: 'secondary',\n        async onClick() {\n            if (!this.startingSerialNumber.value) {\n                throw new Error('@sage/x3-stock/pages__mobile_miscellaneous-issue-details_lines__notification__error_startingSerialNumber');\n            }\n            const _productCode = String(this._productSite?.product?.code);\n            // check that this will add any duplicates\n            const startNumberToAdd = Number(this.startingSerialNumber.value?.code?.match(/\\d+$/));\n            const endNumberToAdd = Number(this.endingSerialNumber.value?.match(/\\d+$/));\n            let serialNumberAlreadyUsed;\n            serialNumberAlreadyUsed = false;\n            if (this.serialNumberLines.value.some(row => {\n                const rowStartMatch = row.startingSerialNumber.match(/\\d+$/);\n                const rowEndMatch = Number(row.endingSerialNumber.match(/\\d+$/));\n                // check if the 'beginning part' of the serial matches\n                if (typesLib.strictNe(row.startingSerialNumber.substring(0, typesLib.sub(row.startingSerialNumber.length, rowStartMatch.toString().length)), this.startingSerialNumber.value?.code?.substring(0, typesLib.sub(this.startingSerialNumber.value?.code?.length, startNumberToAdd.toString().length))))\n                    return false;\n                return typesLib.lte(Number(startNumberToAdd), rowEndMatch) && typesLib.gte(endNumberToAdd, Number(rowStartMatch));\n            })) {\n                serialNumberAlreadyUsed = true;\n            }\n            this._miscellaneousIssueLines.forEach(line => {\n                const serialNumberPrefix1 = this.startingSerialNumber.value?.code?.match(/^(.*?)(?=\\d+$)/);\n                if (typesLib.strictEq(line.product, _productCode) && line.stockDetails?.length && line.stockDetails[0].serialNumber) {\n                    const serialNumberPrefix2 = line?.stockDetails[0]?.serialNumber?.match(/^(.*?)(?=\\d+$)/);\n                    if (typesLib.strictEq(serialNumberPrefix1, serialNumberPrefix2)) {\n                        const startingSerialNumber = Number(line.stockDetails[0].serialNumber.match(/\\d+$/));\n                        const endingSerialNumber = Number((0, miscellaneous_issue_details_control_1._calculateEndingSerialNumber)(line.stockDetails[0].serialNumber, Number(line.quantityInPackingUnit)).match(/\\d+$/));\n                        if (typesLib.lte(Number(startNumberToAdd), endingSerialNumber) && typesLib.gte(Number(endNumberToAdd), startingSerialNumber)) {\n                            serialNumberAlreadyUsed = true;\n                        }\n                    }\n                }\n            });\n            if (serialNumberAlreadyUsed) {\n                throw new Error('@sage/x3-stock/serial-number-range-overlap');\n            }\n            if (typesLib.strictNe(this.endingSerialNumber.value, (0, miscellaneous_issue_details_control_1._calculateEndingSerialNumber)(String(this.startingSerialNumber.value?.code), (typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToIssue.value)))))) {\n                throw new Error('@sage/x3-stock/pages__mobile_miscellaneous-issue-details__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move');\n            }\n            if (typesLib.strictNe((await (0, get_count_serial_number_1.getCountSerialNumber)(this, _productCode, String(this._stockSite?.code), this._stockId.value, String(this.startingSerialNumber.value?.code), String(this.endingSerialNumber.value))), (typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToIssue.value))))) {\n                throw new Error('@sage/x3-stock/serial-number-not-sequential');\n            }\n            const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n            this.serialNumberLines.addRecord({\n                quantity: typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToIssue.value)),\n                startingSerialNumber: this.startingSerialNumber.value.code,\n                endingSerialNumber: this.endingSerialNumber.value,\n            });\n            let lineIndex = this._miscellaneousIssueLines.findIndex(line => (0, miscellaneous_issue_details_control_1._isLineToRecord)(this, currentRecord, line) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n            if (typesLib.strictEq(lineIndex, -1)) {\n                lineIndex = typesLib.sub(this._miscellaneousIssueLines.push({\n                    product: this.product.value.code,\n                    productDescription: this.product.value.description1,\n                    quantityInPackingUnit: 0,\n                    packingUnit: this.packingUnitToIssue.value\n                        ? this.packingUnitToIssue.value : currentRecord.packingUnit.code,\n                    packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorToIssue.value),\n                    lineNumber: this._currentOperation,\n                    stockDetails: [],\n                }), 1);\n            }\n            this._miscellaneousIssueLines[lineIndex].stockDetails?.push({\n                packingUnit: currentRecord.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: currentRecord.packingUnitToStockUnitConversionFactor,\n                quantityInPackingUnit: typesLib.div((typesLib.mul(Number(this.quantityToMove.value), (this.packingUnitToStockUnitConversionFactorToIssue.value\n                    ? this.packingUnitToStockUnitConversionFactorToIssue.value\n                    : 0))), (currentRecord.packingUnitToStockUnitConversionFactor\n                    ? currentRecord.packingUnitToStockUnitConversionFactor\n                    : 1)),\n                quantityInStockUnit: typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToIssue.value)),\n                location: currentRecord.location?.code,\n                licensePlateNumber: currentRecord.licensePlateNumber?.code ?? undefined,\n                lot: currentRecord.lot ?? undefined,\n                status: currentRecord.status?.code ?? undefined,\n                sublot: currentRecord.sublot ?? undefined,\n                serialNumber: this.startingSerialNumber.value?.code ?? undefined,\n                identifier1: currentRecord.identifier1 ?? undefined,\n                identifier2: currentRecord.identifier2 ?? undefined,\n                stockCustomField1: currentRecord.stockCustomField1 ?? undefined,\n                stockCustomField2: currentRecord.stockCustomField2 ?? undefined,\n                stockUnit: this.product.value?.stockUnit?.code,\n            });\n            (0, miscellaneous_issue_details_control_1._calculateLineQuantity)(this._miscellaneousIssueLines[lineIndex], this);\n            (0, miscellaneous_issue_details_control_1._saveDetail)(this);\n            // currentRecord.quantityToMove = String(0);\n            // this.quantityToMove.value = 0;\n            this.stock.setRecordValue(currentRecord);\n            this.startingSerialNumber.value = null;\n            this.endingSerialNumber.value = null;\n            await this.$.commitValueAndPropertyChanges();\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"addSerialRange\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.section({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__detailPanelSection____title\", \"Stock change\"),\n        isTitleHidden: true,\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"detailPanelSection\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"sectionHeader\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"bodyBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"detailsBlock\", void 0);\n__decorate([\n    ui.decorators.gridRowBlock({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n        boundTo() {\n            return this.stock;\n        },\n        fieldFilter() {\n            return false;\n        },\n        readOnlyOverride() {\n            return undefined;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"gridBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"quantityBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"serialNumberBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"destinationBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"listSerialNumberBlock\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__licensePlateNumber____title\", \"License plate number\"),\n        valueField: 'code',\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                _and: [{ status: 'inStock' }, { stockSite: { code: this._stockSite.code } }],\n            };\n        },\n        async onChange() {\n            if (this.licensePlateNumber.value?.location) {\n                this.location.value = this.licensePlateNumber.value.location;\n            }\n            if (!this.licensePlateNumber.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    licensePlateNumber: undefined,\n                };\n                if (!this.licensePlateNumber.isHidden) {\n                    this.licensePlateNumber.value = null;\n                }\n                return;\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                licensePlateNumber: { code: this.licensePlateNumber.value.code },\n            };\n            this.licensePlateNumber.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n            }),\n        ],\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__location____title\", \"Location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: false,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__location____placeholder\", \"Scan or select\\u2026\"),\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        isTransient: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            const locationFilter = {\n                stockSite: { code: this._stockSite.code },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n            return locationFilter;\n        },\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.location);\n            if (this.location.value) {\n                this.location.getNextField(true)?.focus();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__location____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__location____columns__title__type\", \"Type\"),\n            }),\n        ],\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__lot____title\", \"Lot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__lot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LotsSites',\n        valueField: 'lot',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code },\n                storageSite: { code: this.site.value ?? undefined },\n            };\n        },\n        /*  async onInputValueChange(this, rawData: string): Promise<void> {\n            await this.scanBarCode(this.lot, rawData);\n        }, */\n        async onChange() {\n            await this._onChangeLot();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__lot____columns__title__lot\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__lot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__sublot____title\", \"Sublot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__sublot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LotsSites',\n        valueField: 'sublot',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code },\n                storageSite: { code: this.site.value ?? undefined },\n            };\n        },\n        async onChange() {\n            if (!this.sublot.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    lot: undefined,\n                    sublot: undefined,\n                };\n                if (!this.lot.isHidden) {\n                    this.lot.value = null;\n                }\n                return;\n            }\n            if (!this.lot.isHidden) {\n                this.lot.value = this.sublot.value;\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                lot: this.sublot.value.lot,\n                sublot: this.sublot.value.sublot,\n            };\n            this.sublot.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__sublot____columns__title__lot\", \"Lot\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__sublot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__serialNumber____title\", \"Serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__serialNumber____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product?.value?.code },\n                stockSite: { code: this.site.value ?? undefined },\n                issueDocumentId: '',\n            };\n        },\n        /*  async onInputValueChange(this, rawData: string): Promise<void> {\n            await this.scanBarCode(this.serialNumber, rawData);\n        }, */\n        async onChange() {\n            await this._onChangeSerialNumber();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__serialNumber____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__status____title\", \"Status\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__status____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.status, this.status.value);\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__packingUnit____title\", \"Unit\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__packingUnit____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.packingUnit, this.packingUnit.value);\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"packingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__packingUnitToStockUnitConversionFactor____title\", \"Conversion factor\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__packingUnitToStockUnitConversionFactor____placeholder\", \"Enter...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        min: 0,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.packingUnitToStockUnitConversionFactor);\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"packingUnitToStockUnitConversionFactor\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__identifier1____title\", \"Identifier 1\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__identifier1____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        // isHidden: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.identifier1);\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__identifier2____title\", \"Identifier 2\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__identifier2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.identifier2);\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"identifier2\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockCustomField1____title\", \"Stock custom field 1\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockCustomField1____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.stockCustomField1);\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"stockCustomField1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockCustomField2____title\", \"Stock custom field 2\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockCustomField2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.stockCustomField2);\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"stockCustomField2\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.bodyBlock;\n        },\n        node: '@sage/x3-stock-data/Stock',\n        isChangeIndicatorDisabled: false,\n        canFilter: false,\n        canSelect: true,\n        canExport: false,\n        canResizeColumns: false,\n        canUserHideColumns: false,\n        isTitleHidden: false,\n        isTransient: false,\n        isFullWidth: true,\n        isDisabled: false,\n        hasSearchBoxMobile: false,\n        cardView: true,\n        displayMode: ui.fields.TableDisplayMode.compact,\n        mobileCard: undefined,\n        orderBy: {\n            stockSite: 1,\n            stockId: 1,\n        },\n        filter() {\n            return {\n                ...(0, manage_pages_1.generateStockTableFilter)(this),\n                location: { category: { _nin: ['subcontract', 'customer'] } },\n            };\n        },\n        columns: [\n            ui.nestedFields.numeric({\n                bind: 'quantityToMove',\n                isReadOnly: true,\n                isHidden: false, // special field that always gets displayed\n                isTransient: true,\n                postfix(_value, rowValue) {\n                    const currentRecord = (this.gridBlock?.selectedRecordId) ? this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '') : undefined;\n                    if (currentRecord && typesLib.strictEq(rowValue?.stockId, currentRecord.stockId)) {\n                        if (this.packingUnitToIssue.value) {\n                            return ` ${String(this.packingUnitToIssue.value)}`;\n                        }\n                        else {\n                            return ` ${String(currentRecord.packingUnit.code ?? rowValue?.packingUnit?.code ?? '')}`;\n                        }\n                    }\n                    else {\n                        return ` ${String(rowValue?.packingUnit?.code)}`;\n                    }\n                },\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stock____columns__title\", \"Quantity to move\"), // this is important to display a title in the grid row block\n                isTitleHidden: false,\n                isMandatory: false,\n                isFullWidth: true,\n                max(rowValue) {\n                    return rowValue.quantityInPackingUnitOrigin;\n                },\n                scale(value, rowValue) {\n                    return rowValue?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnit',\n                isHidden: false,\n                isTitleHidden: true,\n                isTransient: false,\n                postfix(_value, rowValue) {\n                    const originalStockLine = this._originalStockLines.find(line => typesLib.strictEq(rowValue?._id, line.id));\n                    return originalStockLine?.packingUnit.code;\n                },\n                scale(value, rowValue) {\n                    const originalStockLine = this._originalStockLines.find(line => typesLib.strictEq(rowValue?._id, line.id));\n                    return originalStockLine?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnitRest',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-master-data/ProductSite',\n                isReadOnly: true,\n                isHidden: true,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: { product: { code: true } },\n                    }),\n                    ui.nestedFields.text({\n                        bind: { product: { serialNumberManagementMode: true } },\n                    }),\n                ],\n            }),\n            ui.nestedFields.reference({\n                bind: 'licensePlateNumber',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n                isReadOnly: true,\n                isHidden: true,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n                isReadOnly: true,\n                isHidden: false,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                isReadOnly: true,\n                isHidden() {\n                    return this.lot.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                isReadOnly: true,\n                isHidden() {\n                    return this.sublot.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.link({\n                bind: 'globalSerialNumber',\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                isReadOnly: true,\n                isHidden() {\n                    return this.serialNumber.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'status',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/StockStatus',\n                isHidden() {\n                    return this.status.isHidden ?? false;\n                },\n                columns: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.reference({\n                bind: 'packingUnit',\n                valueField: 'code',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                isHidden: true,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: 'numberOfDecimals',\n                    }),\n                ],\n            }),\n            ui.nestedFields.reference({\n                bind: 'originalPackingUnit',\n                valueField: 'code',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                isHidden: true,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: 'numberOfDecimals',\n                    }),\n                ],\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactor',\n                isReadOnly: true,\n                isHidden() {\n                    return this.packingUnitToStockUnitConversionFactor.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnitOrigin',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                isReadOnly: true,\n                isHidden() {\n                    return this.identifier1.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                isReadOnly: true,\n                isHidden() {\n                    return this.identifier2.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCustomField1',\n                isReadOnly: true,\n                isHidden() {\n                    return this.stockCustomField1.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCustomField2',\n                isReadOnly: true,\n                isHidden() {\n                    return this.stockCustomField2.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockId',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.technical({\n                bind: 'lotReference',\n                node: '@sage/x3-stock-data/Lot',\n                nestedFields: [\n                    ui.nestedFields.date({\n                        bind: 'expirationDate',\n                    }),\n                    ui.nestedFields.date({\n                        bind: 'useByDate',\n                    }),\n                    ui.nestedFields.text({\n                        bind: 'lotCustomField1',\n                    }),\n                    ui.nestedFields.text({\n                        bind: 'lotCustomField2',\n                    }),\n                    ui.nestedFields.reference({\n                        bind: 'majorVersion',\n                        node: '@sage/x3-master-data/MajorVersionStatus',\n                        valueField: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceExpirationDate',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceUseByDate',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lotReferenceMajorVersion',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInStockUnit',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.technical({\n                bind: 'allocatedQuantity',\n            }),\n            ui.nestedFields.technical({\n                bind: 'qualityAnalysisRequestId',\n            }),\n            ui.nestedFields.technical({\n                bind: 'owner',\n            }),\n            ui.nestedFields.technical({\n                bind: 'originalQuantityInStockUnit',\n            }),\n        ],\n        onError(error) {\n            if (typesLib.strictEq(error.message, '@sage/x3-stock/serial-number-not-sequential')) {\n                return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n            }\n            else {\n                return error;\n            }\n        },\n        async onRowSelected(recordId, rowItem) {\n            await (0, miscellaneous_issue_details_control_1._onRowSelected)(this, recordId, rowItem);\n        },\n        async onRowUnselected(recordId, rowItem) {\n            await (0, miscellaneous_issue_details_control_1._onRowUnselected)(this, recordId, rowItem);\n        },\n        sortColumns(firstColumn, secondColumn) {\n            if (typesLib.strictEq(firstColumn.bind, secondColumn.bind))\n                return 0;\n            if (typesLib.strictEq(firstColumn.bind, 'quantityToMove')) {\n                return typesLib.strictEq(secondColumn.bind, this._stockFieldSettings[0]) ? 1 : -1;\n            }\n            else if (typesLib.strictEq(secondColumn.bind, 'quantityToMove')) {\n                return typesLib.strictEq(firstColumn.bind, this._stockFieldSettings[0]) ? -1 : 1;\n            }\n            for (const stockFieldSetting of Object.keys(this._stockFieldSettings)) {\n                if (!stockFieldSetting || typesLib.strictEq(stockFieldSetting, 'none'))\n                    break;\n                if (typesLib.strictEq(firstColumn.bind, stockFieldSetting))\n                    return -1;\n                if (typesLib.strictEq(secondColumn.bind, stockFieldSetting))\n                    return 1;\n            }\n            return 1;\n        },\n        mapServerRecord(record) {\n            return {\n                ...record,\n                quantityInPackingUnitOrigin: (0, miscellaneous_issue_details_control_1._getQuantityInPackingUnitOrigin)(this, record),\n                quantityInPackingUnitRest: (0, miscellaneous_issue_details_control_1._getquantityInPackingUnitRest)(this, record),\n                quantityToMove: (0, miscellaneous_issue_details_control_1._getQuantityToMove)(this, record).toString(),\n                lotReferenceExpirationDate: record.lotReference?.expirationDate,\n                lotReferenceMajorVersion: record.lotReference?.majorVersion?.code,\n                lotReferenceUseByDate: record.lotReference?.useByDate,\n                globalSerialNumber: ui.localize('@sage/x3-stock/label-view-all', 'View list'),\n            };\n        },\n        async onRowClick(recordId, rowItem) {\n            await (0, miscellaneous_issue_details_control_1._onRowClick)(this, recordId, rowItem);\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"stock\", void 0);\n__decorate([\n    ui.decorators.detailListField({\n        parent() {\n            return this.detailsBlock;\n        },\n        node: '@sage/x3-stock-data/Stock',\n        isTransient: true,\n        isFullWidth: true,\n        isTitleHidden: true,\n        fields: [\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-master-data/ProductSite',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title\", \"Product\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.reference({\n                bind: 'licensePlateNumber',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__2\", \"License plate number\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__3\", \"Location\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__4\", \"Lot\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__5\", \"Sublot\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'lotReferenceMajorVersion',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__6\", \"Major version\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceExpirationDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__7\", \"Expiration date\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return typesLib.strictEq(this.product.value.expirationManagementMode, 'notManaged') || !value;\n                },\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceUseByDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__8\", \"Use-by date\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return typesLib.strictEq(this.product.value.expirationManagementMode, 'notManaged') || !value;\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'lotCustomField1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__9\", \"Lot custom field 1\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value?.lotCustomField1;\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'lotCustomField2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__10\", \"Lot custom field 2\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value?.lotCustomField2;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__11\", \"Serial no.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.link({\n                bind: 'globalSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__12\", \"Serial no.\"),\n                isHidden() {\n                    return typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued');\n                },\n                async onClick(_id) {\n                    this.$.setPageClean();\n                    this.$.router.goTo('@sage/x3-stock/MobileGlobalSerialDetails', {\n                        product: String(this.product.value?.code),\n                        stockId: String(this.stock.getRecordValue(this.gridBlock.selectedRecordId)?.stockId),\n                        subtitle: String(this.localizedDescription.value),\n                    });\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityToMove',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__13\", \"Quantity to move\"),\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n                postfix(_value, rowValue) {\n                    return rowValue?.packingUnit?.code ?? '';\n                },\n                scale(value, rowValue) {\n                    return rowValue?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__14\", \"Packing qty.\"),\n                isReadOnly: true,\n                isHidden: false,\n                postfix() {\n                    const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n                    const originalStockLine = this._originalStockLines.find(line => typesLib.strictEq(currentRecord?._id, line.id));\n                    return originalStockLine?.packingUnit.code ?? '';\n                },\n                scale(value, rowValue) {\n                    return rowValue?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'packingUnit',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__15\", \"Unit\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactor',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__16\", \"Conversion factor\"),\n                isReadOnly: true,\n                isHidden: false,\n                scale(value, rowValue) {\n                    const conversionFactor = rowValue?.packingUnitToStockUnitConversionFactor.toString();\n                    const numberOfDec = (conversionFactor.includes('.')) ? conversionFactor.split('.')[1].length : 0;\n                    return numberOfDec;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInStockUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__17\", \"Stock qty.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n                postfix() {\n                    return this.product.value?.stockUnit?.code ?? '';\n                },\n                scale() {\n                    return this.product.value?.stockUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'allocatedQuantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__18\", \"Allocated qty.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n                postfix() {\n                    return this.product.value?.stockUnit?.code ?? '';\n                },\n                scale() {\n                    return this.product.value?.stockUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'status',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/StockStatus',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__19\", \"Status\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__20\", \"Identifier 1\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__21\", \"Identifier 2\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'owner',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__stockDetails____fields__title__22\", \"Owner\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"stockDetails\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.quantityBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__packingUnitToIssue____title\", \"Unit\"),\n        width: 'small',\n        options: ['UN'],\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__packingUnitToIssue____placeholder\", \"Select...\"),\n        isMandatory: true,\n        isTransient: true,\n        isDisabled: true,\n        async onChange() {\n            if (!this.packingUnitToIssue.value)\n                return;\n            const selectedValue = this.packingUnitToIssue.value;\n            const packingUnitIndex = this._packingUnits\n                .map(packingUnit => packingUnit.node.packingUnit.code)\n                .indexOf(selectedValue);\n            if (typesLib.strictNe(packingUnitIndex, -1)) {\n                const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                this.quantityToMove.scale = selectedUnit.packingUnit.numberOfDecimals;\n                this.packingUnitToStockUnitConversionFactorToIssue.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n                this.packingUnitToStockUnitConversionFactorToIssue.isDisabled =\n                    !selectedUnit.isPackingFactorEntryAllowed;\n                const conversionFactor = this.packingUnitToStockUnitConversionFactorToIssue.value.toString();\n                const numberOfDec = (conversionFactor.includes('.')) ? conversionFactor.split('.')[1].length : 0;\n                this.packingUnitToStockUnitConversionFactorToIssue.scale = numberOfDec;\n            }\n            else {\n                this.packingUnitToStockUnitConversionFactorToIssue.value = 1;\n                this.packingUnitToStockUnitConversionFactorToIssue.isDisabled = true;\n                this.quantityToMove.scale = 0;\n            }\n            this.quantityToMove.value = null;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"packingUnitToIssue\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.quantityBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__packingUnitToStockUnitConversionFactorToIssue____title\", \"Conversion factor\"),\n        isDisabled: false,\n        isMandatory: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__packingUnitToStockUnitConversionFactorToIssue____placeholder\", \"Enter...\"),\n        isTransient: true,\n        async onChange() {\n            if (!this.packingUnitToStockUnitConversionFactorToIssue.value)\n                return;\n            const selectedValue = this.packingUnitToIssue.value ?? '';\n            const packingUnitIndex = this._packingUnits\n                .map(packingUnit => packingUnit.node.packingUnit.code)\n                .indexOf(selectedValue);\n            if (typesLib.strictNe(packingUnitIndex, -1)) {\n                const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                this.quantityToMove.scale = selectedUnit.packingUnit.numberOfDecimals;\n            }\n            else {\n                this.packingUnitToStockUnitConversionFactorToIssue.value = 1;\n                this.packingUnitToStockUnitConversionFactorToIssue.isDisabled = true;\n                this.quantityToMove.scale = 0;\n            }\n            this.quantityToMove.value = null;\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"packingUnitToStockUnitConversionFactorToIssue\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.quantityBlock;\n        },\n        postfix(_value, _rowValue) {\n            return ` ${this.packingUnitToIssue.value}`;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__quantityToMove____title\", \"Quantity to issue\"), // this is important to display a title in the grid row block\n        isMandatory: false,\n        isFullWidth: true,\n        isTransient: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__quantityToMove____placeholder\", \"Enter...\"),\n        scale() {\n            return (this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '')?.packingUnit\n                ?.numberOfDecimals ?? 0);\n        },\n        async onChange() {\n            const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n            currentRecord.quantityToMove = String(this.quantityToMove.value);\n            this.stock.setRecordValue(currentRecord);\n            await this.$.commitValueAndPropertyChanges();\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"quantityToMove\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__startingSerialNumber____title\", \"Starting serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__startingSerialNumber____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        canFilter: false,\n        isDisabled: false,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        filter() {\n            const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n            return {\n                _and: [{ product: { code: this.product.value?.code } }, { stockId: currentRecord?.stockId }],\n            };\n        },\n        async onChange() {\n            await (0, miscellaneous_issue_details_control_1._onChangeBody)(this);\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__startingSerialNumber____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__startingSerialNumber____columns__title__product__code\", \"Product\"),\n                bind: 'product',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__startingSerialNumber____columns__title__stockId\", \"Stock ID\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"startingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__endingSerialNumber____title\", \"Ending serial number\"),\n        isMandatory: false,\n        isTransient: true,\n        isReadOnly: true,\n        isFullWidth: true,\n        async validation(_value) {\n            if (typesLib.strictEq(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                const currentQty = (typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToIssue.value)));\n                if (typesLib.strictNe((await (0, get_count_serial_number_1.getCountSerialNumber)(this, String(this._productSite?.product?.code), String(this._stockSite?.code), this._stockId.value, String(this.startingSerialNumber.value?.code), String(this.endingSerialNumber.value), _value)), currentQty)) {\n                    return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n                }\n                else {\n                    return '';\n                }\n            }\n            else {\n                return '';\n            }\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"endingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        isTransient: true,\n        isHidden: true,\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"_stockId\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.listSerialNumberBlock;\n        },\n        canFilter: false,\n        canSelect: false,\n        canExport: false,\n        canResizeColumns: false,\n        canUserHideColumns: false,\n        isTitleHidden: false,\n        isTransient: true, // (X3-257606) TODO Issue: Deleting table row(s) that are loaded in a non-transient causes errors. After this is fixed, change this table back to isTransient: false\n        isFullWidth: true,\n        isDisabled: false,\n        node: '@sage/x3-stock/StockCountSerialNumber',\n        mobileCard: undefined,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'startingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__serialNumberLines____columns__title__startingSerialNumber\", \"Starting serial Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__serialNumberLines____columns__title__quantity\", \"Quantity\"),\n                isReadOnly: true,\n                postfix(_value, _rowValue) {\n                    return this.stock.getRecordValue(this.gridBlock.selectedRecordId).packingUnit?.code ?? '';\n                },\n                scale() {\n                    return (this.stock.getRecordValue(this.gridBlock.selectedRecordId ?? '')?.packingUnit\n                        ?.numberOfDecimals ?? 0);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'endingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__serialNumberLines____columns__title__endingSerialNumber\", \"Ending Serial Number\"),\n                isReadOnly: true,\n            }),\n        ],\n        dropdownActions: [\n            {\n                icon: 'bin',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details__serialNumberLines____dropdownActions__title\", \"Delete\"),\n                onClick(recordId) {\n                    // line removal in the saved object\n                    const removedRecordSerialNumber = this.serialNumberLines.getRecordValue(recordId);\n                    const removedIndexSerialNumber = this._miscellaneousIssueLines.findIndex(number => typesLib.strictEq(number.stockDetails[0].serialNumber, removedRecordSerialNumber.startingSerialNumber));\n                    this._miscellaneousIssueLines.splice(removedIndexSerialNumber, 1);\n                    (0, miscellaneous_issue_details_control_1._saveMiscellaneousIssue)(this);\n                    //calculation of the new qty\n                    const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n                    // currentRecord.quantityToMove = String(0);\n                    this.stock.setRecordValue(currentRecord);\n                    //remove from the card\n                    this.serialNumberLines.removeRecord(recordId);\n                    this.startingSerialNumber.isDisabled = false;\n                },\n            },\n        ],\n        fieldActions() {\n            return [this.addSerialRange];\n        },\n    })\n], MobileMiscellaneousIssueDetails.prototype, \"serialNumberLines\", void 0);\nexports.MobileMiscellaneousIssueDetails = MobileMiscellaneousIssueDetails = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details____title\", \"Miscellaneous issue\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_issue_details____subtitle\", \"Enter stock details\"),\n        module: 'x3-stock',\n        node: '@sage/x3-master-data/ProductSite',\n        mode: 'default',\n        isTitleHidden: true,\n        navigationPanel: undefined,\n        headerCard() {\n            return {\n                title: this.product,\n                line2: this.localizedDescription,\n            };\n        },\n        businessActions() {\n            return [this.nextButton];\n        },\n        async onLoad() {\n            if (!(0, miscellaneous_issue_details_control_1._getSavedInputs)(this)?.selectedProduct) {\n                // this.clearAllCompositeDataAndStorage(adcApplicationGs1Key);\n                // return;\n            }\n            this._stockSite = JSON.parse(this.$.queryParameters.stockSite);\n            // Form an array of stock input settings in the order from stockField1 to stockField8\n            const mobileSettings = JSON.parse(this.$.queryParameters.mobileSettings);\n            this._stockFieldSettings = [\n                mobileSettings.stockField1,\n                mobileSettings.stockField2,\n                mobileSettings.stockField3,\n                mobileSettings.stockField4,\n                mobileSettings.stockField5,\n                mobileSettings.stockField6,\n                mobileSettings.stockField7,\n                mobileSettings.stockField8,\n            ]; // to guarantee the ordering of the mobileSettings field\n            this._miscellaneousIssueLines = (0, miscellaneous_issue_details_control_1._getSavedInputs)(this).miscellaneousIssue.miscellaneousIssueLines ?? [];\n            this._currentLine = (0, miscellaneous_issue_details_control_1._getSavedInputs)(this).currentLine;\n            this._currentDetail = (0, miscellaneous_issue_details_control_1._getSavedInputs)(this).currentDetail;\n            this._currentOperation = (0, miscellaneous_issue_details_control_1._getSavedInputs)(this).currentOperation;\n            this._serialNumberManagementMode = (0, miscellaneous_issue_details_control_1._getSavedInputs)(this).selectedProduct?.serialNumberManagementMode;\n            await this._init();\n            if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                this.addSerialRange.isHidden = true;\n                this.serialNumberBlock.isHidden = true;\n                this.listSerialNumberBlock.isHidden = true;\n                this.serialNumberLines.isTitleHidden = true;\n                this.listSerialNumberBlock.isHidden = true;\n            }\n            this.serialNumberLines.title = 'Serial number(s) to move    ';\n            (0, manage_pages_1.managePages)(this, this._stockSite.code, { ...this.$.values, product: { ...this.product.value } }, '3', ui.localize('@sage/x3-stock/pages__settings__mandatory-settings-missing', 'Mandatory settings missing.'), this._stockFieldSettings);\n            (0, miscellaneous_issue_details_control_1.savedOriginalStockLines)(this);\n            await this.stock.refresh();\n        },\n        detailPanel() {\n            return {\n                isCloseButtonHidden: true,\n                isTitleHidden: true,\n                isHidden: true,\n                isTransient: true,\n                header: this.detailPanelSection,\n                sections: [],\n                footerActions: [this.helperCancelButton, this.helperSelectButton],\n            };\n        },\n    })\n    // export class MobileMiscellaneousIssueDetails extends SupportServiceManagementGs1Page<GraphApi> {\n], MobileMiscellaneousIssueDetails);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-miscellaneous-issue-details.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts":
/*!**********************************************************************************!*\
  !*** ../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getCountSerialNumber = void 0;\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\n/**\n * async getCountSerialNumber for count number of serial numbers in range\n * @param _pageInstance this page\n * @param _productCode product code\n * @param _stockSiteCode  stock site code\n * @param _stockId optional stock id\n * @param _startingSerialNumberCode starting serial number\n * @param _endingSerialNumberCode  ending serial number\n * @param value to control\n * @returns counted serial number in range or throw exception\n */\nasync function getCountSerialNumber(_pageInstance, _productCode, _stockSiteCode, _stockId, _startingSerialNumberCode, _endingSerialNumberCode, value) {\n    // Create a readable payload, but removing CR/LF before to send request.\n    const _payload = `{\n        product: { code: '${_productCode}' },\n        stockSite: { code: '${_stockSiteCode}' },\n        ${_stockId ? `stockId: '${_stockId}',` : ''}\n        _and: [\n            {\n                code: { _gte: '${_startingSerialNumberCode}' },\n            },\n            {\n                code: { _lte: '${_endingSerialNumberCode}' },\n            },\n        ],\n    }`.replace(/[\\r\\n]/g, '');\n    try {\n        const response = await _pageInstance.$.graph.raw(`query {\n                        x3StockData{\n                            serialNumber {\n                                query(filter: \"${_payload}\") {\n                                    totalCount\n                                }\n                            }\n                        }\n                    }`);\n        return response?.x3StockData?.serialNumber?.query?.totalCount ?? 0;\n    }\n    catch (error) {\n        throw new xtrem_shared_1.BusinessRuleError(error?.message, error);\n    }\n}\nexports.getCountSerialNumber = getCountSerialNumber;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/shared-functions/pat-converter.ts":
/*!********************************************************************!*\
  !*** ../../shared/x3-system/lib/shared-functions/pat-converter.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.pat = exports.getRegExpForMultiplePat = exports.getRegExp = void 0;\n/**\n * Get the RegExp equivalent for the 4GL pattern given\n *\n * @param pattern The 4GL pattern you want to get the RegExp equivalent\n * @returns The RegExp\n */\nfunction getRegExp(pattern) {\n    const rule = \n    // escape RegExp spécial chars\n    pattern\n        .replace(/[-[\\]{}()+.,\\\\^$|\\s]/g, '\\\\$&')\n        // translate the pattern\n        .replace(/\\*/g, '.*')\n        .replace(/\\?/g, '.')\n        .replace(/#/g, '\\\\d')\n        .replace(/!/g, '[A-Za-z]');\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExp = getRegExp;\nfunction getRegExpForMultiplePat(multiplePattern) {\n    // const str1 = '(';\n    const rule = `${`(${\n    // convert each pattern individually and join them using |\n    multiplePattern\n        .split(',')\n        .map(multPat => getRegExp(multPat).source.replace(/\\^/g, '').replace(/\\$/g, ''))\n        .join('|')}`})`;\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExpForMultiplePat = getRegExpForMultiplePat;\n/**\n * Perform a 4GL pattern check\n *\n * @param text The text to be tested\n * @param pat The 4GL pattern to apply\n * @returns The result of the test as a boolean\n */\nfunction pat(text, pattern) {\n    return getRegExp(pattern).test(text);\n}\nexports.pat = pat;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/shared-functions/pat-converter.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-miscellaneous-issue-details.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;