import { GraphApi } from '@sage/x3-stock-api';
import { LotsSites, SerialNumber, Stock } from '@sage/x3-stock-data-api';
import * as ui from '@sage/xtrem-ui';
export declare class MobileMiscellaneousIssueByIdentifierDetails extends ui.Page<GraphApi> {
    private _packingUnits;
    private _productSite;
    private _miscellaneousIssueLines;
    private _stockSite;
    private _identifier;
    private _selectedLineIndex;
    private _selectedLineId;
    private _stockQueryResult;
    private _notifier;
    private _selectedIdentifierValues;
    private _originalStockLines;
    site: ui.fields.Text;
    nextButton: ui.PageAction;
    searchButton: ui.PageAction;
    helperCancelButton: ui.PageAction;
    helperSelectButton: ui.PageAction;
    addSerialRange: ui.PageAction;
    mainSection: ui.containers.Section;
    detailPanelSection: ui.containers.Section;
    bodyBlock: ui.containers.Block;
    detailsBlock: ui.containers.Block;
    gridBlock: ui.containers.GridRowBlock;
    quantityBlock: ui.containers.Block;
    numberSerialBlock: ui.containers.Block;
    listSerialNumberBlock: ui.containers.Block;
    product: ui.fields.Reference;
    lot: ui.fields.Reference<LotsSites>;
    sublot: ui.fields.Text;
    serialNumber: ui.fields.Reference<SerialNumber>;
    location: ui.fields.Reference;
    identifier1: ui.fields.Text;
    identifier2: ui.fields.Text;
    licensePlateNumber: ui.fields.Reference;
    status: ui.fields.Select;
    packingUnit: ui.fields.Select;
    packingUnitToStockUnitConversionFactor: ui.fields.Numeric;
    stockCustomField1: ui.fields.Text;
    stockCustomField2: ui.fields.Text;
    selectAllSwitch: ui.fields.Switch;
    lineSeparator: ui.fields.Separator;
    stock: ui.fields.Table<Stock>;
    stockDetails: ui.fields.DetailList<Stock>;
    packingUnitToIssue: ui.fields.DropdownList;
    packingUnitToStockUnitConversionFactorToIssue: ui.fields.Numeric;
    quantityToMove: ui.fields.Numeric;
    startingSerialNumber: ui.fields.Reference<SerialNumber>;
    endingSerialNumber: ui.fields.Text;
    serialNumberLines: ui.fields.Table<any>;
    private _activeSelectButton;
    private _init;
    private _getSavedInputs;
    private _initSiteCodeField;
    private _onChangeBody;
    /**
     * Select or create miscIssueLine from current card item with(out) global serialization
     * before to allow edit in detail grid :
     * - initialize quantity to issue, stockDetails with row...
     * - Search existing line(s) in miscellaneousIssueLines array
     * - for product with global serial : retrieve all existing serials numbers.
     * - for other product, create line when missing.
     * @param recordId Current record ID
     * @param recordIndex Current record index
     * @param rowItem Current stock record
     */
    private _onRowClick;
    /**
     * Select or create miscIssueLine from current card item without global serialization
     * - Select current record with optional autoSelect
     * - update or create line for card without global serialization (unique stock detail)
     * - update record information
     * @param recordId Current record ID
     * @param recordIndex Current record index
     * @param autoSelect  True for init quantity to issue from record
     */
    private _onSelect;
    /**
     * Calculated total quantity remaining for given record
     * @param _currentRecord Calculate remaining quantity to issue for current stock record
     * @param _miscIssueLines Stock change lines to reevaluate
     * @returns quantity remaining
     */
    private _calcQuantityRemaining;
    /**
     * Unselect stockRecord from current card item without global serialization
     * @param recordId Current record ID
     * @param recordIndex Current record index
     */
    private _onDeselect;
    private _saveDetail;
    private _saveMiscIssue;
    private _calculateMiscLineQuantity;
    private _getMiscIssueLines;
    private _getQuantityInPackingUnitOrigin;
    private _getQuantityInPackingUnitRest;
    /**
     * Return cumulated stock quantities to issue for current line
     * @param _currentMiscIssueLine current stock change line
     * @returns cumulated quantities
     */
    private _getStockDetailToMoveInPackingUnit;
    private _getMiscIssueLine;
    private _getQuantityToMove;
    private _onSearch;
    private _onSelectAllLines;
    private _onDeselectAllLines;
    private _activeSwitchAndButtonSearch;
    /**
     * Return a index of record sorted stock table.
     * @param recordId Current record ID
     * @returns index in sorted array
     */
    private _getLineIndex;
    private _initPackingUnitFields;
}
//# sourceMappingURL=mobile-miscellaneous-issue-by-identifier-details.d.ts.map