/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/pages/mobile-location-reorder.ts":
/*!**********************************************!*\
  !*** ./lib/pages/mobile-location-reorder.ts ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileLocationReorder = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst get_selected_stock_site_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-selected-stock-site */ \"../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\");\nconst stock_control_1 = __webpack_require__(/*! @sage/x3-stock-data/build/lib/menu-items/stock-control */ \"../../shared/x3-stock-data/build/lib/menu-items/stock-control.js\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nlet MobileLocationReorder = class MobileLocationReorder extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this.entryTransactions = [];\n    }\n    async _initializePage() {\n        await this._initializeSite();\n        //Only initialize the rest of the page if the siteField is defined\n        if (this.siteField.value) {\n            await this.initializeTransactions();\n            await this.initializeStorageList();\n            this._showPage();\n        }\n        else {\n            this._disablePage();\n        }\n    }\n    _showPage() {\n        this.mainSection.isHidden = false;\n    }\n    _disablePage() {\n        this.mainSection.isHidden = false;\n        this.transaction.isDisabled = true;\n        this.storageList.isDisabled = true;\n    }\n    async _initializeSite() {\n        this.siteField.value = await (0, get_selected_stock_site_1.getSelectedStockSite)(this, ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));\n    }\n    async initializeTransactions() {\n        await this.getTransactions();\n        this.setTransactions();\n    }\n    async getTransactions() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/StockEntryTransaction')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n            isLocationReplenishable: true,\n            isConsumptionArea: true,\n            isShortages: true,\n        }, {\n            filter: {\n                transactionType: 'reorderPlan',\n                isAutomaticDetermination: false,\n                isActive: true,\n            },\n        }))\n            .execute();\n        for (const transactions of response.edges) {\n            this.entryTransactions.push({\n                code: transactions.node.code,\n                isLocationReplenishable: transactions.node.isLocationReplenishable,\n                isConsumptions: transactions.node.isConsumptionArea,\n                isShortages: transactions.node.isShortages,\n            });\n        }\n    }\n    setTransactions() {\n        let transactionCodes = [];\n        for (const singleTransaction of this.entryTransactions) {\n            transactionCodes.push(singleTransaction.code);\n        }\n        if (typesLib.strictEq(transactionCodes.length, 0)) {\n            this._disablePage();\n        }\n        else {\n            this.transaction.options = transactionCodes;\n            this.transaction.value = this.transaction.options[0];\n            if (typesLib.eq(this.entryTransactions.length, 1)) {\n                this.transaction.isHidden = true;\n                this.storageList.focus();\n            }\n        }\n        this.transaction.focus();\n    }\n    async initializeStorageList() {\n        let replenishableTransactions = new Set();\n        let consumptionTransactions = new Set();\n        let shortagesTransactions = new Set();\n        for (const transactions of this.entryTransactions) {\n            if (transactions.isLocationReplenishable) {\n                replenishableTransactions.add(transactions.code);\n            }\n            if (transactions.isConsumptions) {\n                consumptionTransactions.add(transactions.code);\n            }\n            if (transactions.isShortages) {\n                shortagesTransactions.add(transactions.code);\n            }\n        }\n        let replenishableStorageListNumbers = [];\n        let consumptionsStorageListNumbers = [];\n        let shortagesStorageListNumers = [];\n        if (replenishableTransactions.has(this.transaction.value)) {\n            replenishableStorageListNumbers = await this.getReplenishableStorageListNumbers();\n        }\n        if (consumptionTransactions.has(this.transaction.value)) {\n            consumptionsStorageListNumbers = await this.getConsumptionsStorageListNumbers();\n        }\n        if (shortagesTransactions.has(this.transaction.value)) {\n            shortagesStorageListNumers = await this.getShortagesStorageListNumbers();\n        }\n        let storageListNumbers = this.removeDuplicates(replenishableStorageListNumbers, consumptionsStorageListNumbers, shortagesStorageListNumers);\n        storageListNumbers.sort();\n        return (this.storageList.options = storageListNumbers);\n    }\n    async getReplenishableStorageListNumbers() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/StockReorder')\n            .aggregate.query((0, xtrem_client_1.aggregateEdgesSelector)({\n            group: {\n                documentNumber: {\n                    _by: 'value',\n                },\n            },\n            values: {\n                documentNumber: {\n                    min: false,\n                    max: false,\n                    sum: false,\n                    avg: false,\n                    distinctCount: true,\n                },\n            },\n        }, {\n            filter: {\n                stockSite: this.siteField.value,\n                documentNumber: {\n                    _ne: '',\n                },\n            },\n            first: 500,\n        }))\n            .execute();\n        let storageLists = [];\n        for (const storagelist of response.edges) {\n            storageLists.push(storagelist.node.group.documentNumber);\n        }\n        return storageLists;\n    }\n    async getConsumptionsStorageListNumbers() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/Allocation')\n            .aggregate.query((0, xtrem_client_1.aggregateEdgesSelector)({\n            group: {\n                storageListNumber: {\n                    _by: 'value',\n                },\n            },\n            values: {\n                storageListNumber: {\n                    min: false,\n                    max: false,\n                    sum: false,\n                    avg: false,\n                    distinctCount: true,\n                },\n            },\n        }, {\n            filter: {\n                stockSite: {\n                    code: this.siteField.value,\n                },\n                allocationType: 'detailed',\n                storageListNumber: {\n                    _ne: '',\n                },\n                documentNumber: {\n                    _ne: '',\n                },\n                documentType: {\n                    _in: ['salesOrder', 'workOrder', 'subcontractOrder'],\n                },\n                _or: [\n                    {\n                        defaultLocation: {\n                            _ne: '',\n                        },\n                    },\n                    {\n                        defaultLocationType: {\n                            _ne: '',\n                        },\n                    },\n                ],\n            },\n            first: 500,\n        }))\n            .execute();\n        let storageLists = [];\n        for (const storagelist of response.edges) {\n            storageLists.push(storagelist.node.group.storageListNumber);\n        }\n        return storageLists;\n    }\n    async getShortagesStorageListNumbers() {\n        const response = await this.$.graph\n            .node('@sage/x3-stock/Allocation')\n            .aggregate.query((0, xtrem_client_1.aggregateEdgesSelector)({\n            group: {\n                storageListNumber: {\n                    _by: 'value',\n                },\n            },\n            values: {\n                storageListNumber: {\n                    min: false,\n                    max: false,\n                    sum: false,\n                    avg: false,\n                    distinctCount: true,\n                },\n            },\n        }, {\n            filter: {\n                stockSite: this.siteField.value,\n                storageListNumber: {\n                    _ne: '',\n                },\n                documentNumber: {\n                    _ne: '',\n                },\n                allocationType: 'detailedShortage',\n                location: {\n                    _ne: '',\n                },\n            },\n            first: 500,\n        }))\n            .execute();\n        let storageLists = [];\n        for (const storagelist of response.edges) {\n            storageLists.push(storagelist.node.group.storageListNumber);\n        }\n        return storageLists;\n    }\n    removeDuplicates(replenishableStorageListNumbers, consumptionsStorageListNumbers, shortagesStorageListNumers) {\n        let set = new Set();\n        for (const item of replenishableStorageListNumbers) {\n            set.add(item);\n        }\n        for (const item of consumptionsStorageListNumbers) {\n            set.add(item);\n        }\n        for (const item of shortagesStorageListNumers) {\n            set.add(item);\n        }\n        return Array.from(set);\n    }\n    async _tryToRoute() {\n        this.$.setPageClean();\n        this.$.router.goTo('@sage/x3-stock/MobileLocationReorderTodo', {\n            stockSite: this.siteField.value,\n            storageListNumber: this.storageList.value,\n            entryTransaction: this.transaction.value,\n        });\n    }\n};\nexports.MobileLocationReorder = MobileLocationReorder;\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n        isHidden: true,\n    })\n], MobileLocationReorder.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileLocationReorder.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder__transaction____title\", \"Transaction\"),\n        isMandatory: true,\n        isTransient: true,\n        isHidden: false,\n        isDisabled: false,\n        onChange() {\n            this.initializeStorageList();\n        },\n    })\n], MobileLocationReorder.prototype, \"transaction\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.mainBlock;\n        },\n        isHidden: true,\n    })\n], MobileLocationReorder.prototype, \"siteField\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder__storageList____title\", \"Storage list\"),\n        isMandatory: true,\n        isTransient: true,\n        isHidden: false,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder__storageList____placeholder\", \"Scan or select...\"),\n        isFullWidth: true,\n        async onChange() {\n            if (!this.storageList.value)\n                return;\n            await this.initializeStorageList();\n            await this._tryToRoute();\n        },\n    })\n], MobileLocationReorder.prototype, \"storageList\", void 0);\nexports.MobileLocationReorder = MobileLocationReorder = __decorate([\n    ui.decorators.page({\n        isTitleHidden: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder____title\", \"Location reordering\"),\n        menuItem: stock_control_1.stockControl,\n        priority: 300,\n        isTransient: false,\n        authorizationCode: 'CWSALR',\n        access: { node: '@sage/x3-inventory/StockReorder' },\n        skipDirtyCheck: true,\n        async onLoad() {\n            await this._initializePage();\n        },\n    })\n], MobileLocationReorder);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-location-reorder.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts":
/*!***********************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getSelectedStockSite = void 0;\nconst dialogs_1 = __webpack_require__(/*! ./dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\n/**\n * Return selected stock site for current application\n * @param pageInstance Current page instance\n * @param errorTitle error title when no default site exist\n * @param errorMessage error message when no default site exist\n * @returns default site or null\n */\nasync function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {\n    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');\n    if (!selectedSite) {\n        // Please note that there asynchronous processing is not prefixed by an await on purpose\n        // so that it can be processed in parallel and not block the main process.\n        // Be careful not to leave the current page before the user has closed this dialog box.\n        pageInstance.$.sound.error();\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);\n        return null;\n    }\n    else {\n        return selectedSite.toString();\n    }\n}\nexports.getSelectedStockSite = getSelectedStockSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/build/lib/menu-items/stock-control.js":
/*!************************************************************************!*\
  !*** ../../shared/x3-stock-data/build/lib/menu-items/stock-control.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.stockControl = void 0;\nexports.stockControl = {\n    id: '@sage/x3-stock-data/stock-control-root',\n    priority: 200,\n    title: 'Stock control',\n    icon: 'squares_nine',\n};\n//# sourceMappingURL=stock-control.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvc3RvY2stY29udHJvbC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL3h0cmVtQXJ0aWZhY3QvLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvc3RvY2stY29udHJvbC5qcz9kNTQ5Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5zdG9ja0NvbnRyb2wgPSB2b2lkIDA7XG5leHBvcnRzLnN0b2NrQ29udHJvbCA9IHtcbiAgICBpZDogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvc3RvY2stY29udHJvbC1yb290JyxcbiAgICBwcmlvcml0eTogMjAwLFxuICAgIHRpdGxlOiAnU3RvY2sgY29udHJvbCcsXG4gICAgaWNvbjogJ3NxdWFyZXNfbmluZScsXG59O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9c3RvY2stY29udHJvbC5qcy5tYXAiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/build/lib/menu-items/stock-control.js\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-location-reorder.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;