/// <reference types="@sage/x3-system/api" />
import { ProductInput } from '@sage/x3-master-data-api';
import { StockChangeInput, StockEntryTransaction } from '@sage/x3-stock-api';
import { SiteInput } from '@sage/x3-system-api';
import * as ui from '@sage/xtrem-ui';
type DeepPartial<T> = T extends Object ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : T;
type PartialStockTransaction = DeepPartial<StockEntryTransaction>;
export type inputsIntersiteTransfer = {
    intersiteTransfer: StockChangeInput & {
        id?: string;
    };
    username: string;
    currentLine?: number;
    currentOperation?: number;
    started: boolean;
    selectedTransaction: PartialStockTransaction;
    selectedProduct?: ProductInput;
    destinationCode?: string;
    printingMode?: string;
    siteDestination?: SiteInput;
};
export declare class MobileIntersiteTransfer extends ui.Page {
    savedObject: inputsIntersiteTransfer;
    private _transactions;
    private _matchSiteDestination;
    private _notifier;
    private _mobileSettings;
    private _currentOperation;
    private _numberOfDecimalList;
    stockSite: ui.fields.Text;
    createButton: ui.PageAction;
    mainSection: ui.containers.Section;
    firstBlock: ui.containers.Block;
    effectiveDate: ui.fields.Date;
    transaction: ui.fields.DropdownList;
    secondBlock: ui.containers.Block;
    siteDestination: ui.fields.Reference;
    product: ui.fields.Reference;
    intersiteTransferLinesBlock: ui.containers.Block;
    intersiteTransferLines: ui.fields.Table<any>;
    private _init;
    private _disablePage;
    private _initSite;
    private _initTransaction;
    private _setTransaction;
    private _readSavedObject;
    private _checkStorage;
    private _reInitStorage;
    private _initStorage;
    private _saveInterSiteTransfer;
    private _initStockChangeLines;
    private _mapIntersiteTransfer;
    private _postInitStockChangeLines;
    private _createValues;
    private _fetchSiteDestination;
    prepareDataMutation(): StockChangeInput;
    private _callCreationAPI;
}
export {};
//# sourceMappingURL=mobile-intersite-transfer.d.ts.map