/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/get-unit-number-decimals.ts":
/*!**********************************************************!*\
  !*** ./lib/client-functions/get-unit-number-decimals.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GetNumberOfDecimals = exports.getNumberOfDecimal = exports.getUnitNumberOfDecimalList = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function getUnitNumberOfDecimalList(pageInstance) {\n    try {\n        const numberOfDecimalList = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n            numberOfDecimals: true,\n        }, {\n            first: 1000,\n        }))\n            .execute());\n        return numberOfDecimalList;\n    }\n    catch (e) {\n        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-stock/pages__utils__get_unit_number_decimals_error', 'Error loading unit'), String(e));\n        return [];\n    }\n}\nexports.getUnitNumberOfDecimalList = getUnitNumberOfDecimalList;\nfunction getNumberOfDecimal(list, unit) {\n    if (unit && list) {\n        const _unitOfMeasure = list.filter(uom => typesLib.strictEq(uom.code, unit));\n        return _unitOfMeasure[0]?.numberOfDecimals ?? 0;\n    }\n    return 0;\n}\nexports.getNumberOfDecimal = getNumberOfDecimal;\nfunction GetNumberOfDecimals(pageInstance, Unit) {\n    try {\n        const numberOfDecimals = pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .read({\n            _id: true,\n            numberOfDecimals: true,\n        }, `${Unit}`)\n            .execute();\n        return numberOfDecimals.numberOfDecimals;\n    }\n    catch (e) {\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-unit', 'Error loading unit'), String(e));\n    }\n}\nexports.GetNumberOfDecimals = GetNumberOfDecimals;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/get-unit-number-decimals.ts\n");

/***/ }),

/***/ "./lib/client-functions/manage-pages.ts":
/*!**********************************************!*\
  !*** ./lib/client-functions/manage-pages.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.readSerialNumberFromStockId = exports.handleFilterOnChange = exports.generateStockTableFilter = exports.removeFilters = exports.findSetting = exports.managePages = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * Initialize manage page\n * @param pageInstance current page\n * @param stockSite stock site\n * @param productSite partial product site object\n * @param flowType type of flow\n * @param errorMessage error messages missing settings\n * @param stockSearchFilters mandatory array to return settings\n */\n//todo:\nfunction managePages(pageInstance, stockSite, productSite, flowType, errorMessage, stockSearchFilters) {\n    // Initializing array when undefined\n    stockSearchFilters ??= [];\n    if (stockSearchFilters.length) {\n        // remove all items in array\n        stockSearchFilters.length = 0;\n    }\n    if (!pageInstance || !stockSite || !productSite || !flowType) {\n        throw new xtrem_shared_1.SystemError('Invalid arguments');\n    }\n    const _selectedMobileSettings = JSON.parse(pageInstance.$.queryParameters?.mobileSettings);\n    if (typesLib.strictEq(_selectedMobileSettings, null)) {\n        throw new Error(errorMessage);\n    }\n    // Store value in array only when usable and return true when done\n    const _pushSettings = (field) => {\n        if (typesLib.strictNe(field, 'none')) {\n            stockSearchFilters?.push(field);\n            return true;\n        }\n        return false;\n    };\n    // The fields are memorized until they meet the none type.\n    const _allPushed = _pushSettings(_selectedMobileSettings.stockField1) &&\n        _pushSettings(_selectedMobileSettings.stockField2) &&\n        _pushSettings(_selectedMobileSettings.stockField3) &&\n        _pushSettings(_selectedMobileSettings.stockField4) &&\n        _pushSettings(_selectedMobileSettings.stockField5) &&\n        _pushSettings(_selectedMobileSettings.stockField6) &&\n        _pushSettings(_selectedMobileSettings.stockField7) &&\n        _pushSettings(_selectedMobileSettings.stockField8);\n    if (pageInstance._pageMetadata.layoutFields?.location) {\n        if (!findSetting('location', stockSearchFilters) || typesLib.strictNe(productSite.isLocationManaged, true)) {\n            pageInstance['location'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.lot) {\n        if (!findSetting('lot', stockSearchFilters) || typesLib.strictEq((productSite?.product?.lotManagementMode ?? 'notManaged'), 'notManaged')) {\n            pageInstance['lot'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.sublot)\n        if (!findSetting('sublot', stockSearchFilters) || typesLib.strictNe((productSite?.product?.lotManagementMode ?? ''), 'lotAndSublot')) {\n            pageInstance['sublot'].isHidden = true;\n        }\n    if (pageInstance._pageMetadata.layoutFields?.serialNumber) {\n        if (!findSetting('serial', stockSearchFilters) ||\n            !['receivedIssued'].includes(productSite?.product?.serialNumberManagementMode ?? 'receivedIssued')) {\n            pageInstance['serialNumber'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.status) {\n        if (!findSetting('status', stockSearchFilters)) {\n            pageInstance['status'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.packingUnit) {\n        if (!findSetting('packingUnit', stockSearchFilters)) {\n            pageInstance['packingUnit'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor) {\n        if (!findSetting('pacStkConversionFactor', stockSearchFilters)) {\n            pageInstance['packingUnitToStockUnitConversionFactor'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.identifier1) {\n        if (!findSetting('identifier1', stockSearchFilters)) {\n            pageInstance['identifier1'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.identifier2) {\n        if (!findSetting('identifier2', stockSearchFilters)) {\n            pageInstance['identifier2'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.licensePlateNumber) {\n        if (typesLib.strictNe(productSite.isLicensePlateNumberManaged, true) ||\n            !findSetting('licensePlateNumber', stockSearchFilters)) {\n            pageInstance['licensePlateNumber'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField1) {\n        if (!findSetting('customField1', stockSearchFilters)) {\n            pageInstance['stockCustomField1'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField2) {\n        if (!findSetting('customField2', stockSearchFilters)) {\n            pageInstance['stockCustomField2'].isHidden = true;\n        }\n    }\n}\nexports.managePages = managePages;\n/**\n * Search if filter\n * @param field current search field\n * @param fields list of current filter\n * @returns true when found used filter parameter\n */\nfunction findSetting(field, fields) {\n    return typesLib.gte(fields.findIndex(fld => typesLib.strictEq(fld, field)), 0);\n}\nexports.findSetting = findSetting;\n/**\n * Remove filter (asynchronous for avoiding anticipated onChange)\n * @param pageInstance current page\n */\nasync function removeFilters(pageInstance) {\n    if (pageInstance._pageMetadata.layoutFields?.location)\n        pageInstance['location'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.lot)\n        pageInstance['lot'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.sublot)\n        pageInstance['sublot'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.serialNumber)\n        pageInstance['serialNumber'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.status)\n        pageInstance['status'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.packingUnit)\n        pageInstance['packingUnit'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor)\n        pageInstance['packingUnitToStockUnitConversionFactor'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.identifier1)\n        pageInstance['identifier1'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.identifier2)\n        pageInstance['identifier2'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.licensePlateNumber)\n        pageInstance['licensePlateNumber'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField1)\n        pageInstance['stockCustomField1'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField2)\n        pageInstance['stockCustomField2'].value = null;\n}\nexports.removeFilters = removeFilters;\nfunction generateStockTableFilter(pageInstance) {\n    const stockSite = pageInstance['_stockSite'];\n    const stockFilter = {\n        availableQuantity: { _gt: '0' },\n        //      quantityInPackingUnit: { _gt: '0' },\n        isBeingCounted: false,\n        owner: stockSite?.code,\n    };\n    let parameterLocation = pageInstance.$.queryParameters?.location;\n    if (!parameterLocation &&\n        pageInstance._pageMetadata.layoutFields?.location &&\n        pageInstance['location'].value) {\n        parameterLocation = pageInstance['location'].value?.code;\n    }\n    const quantityToPick = pageInstance['_quantityToPick'] ?? null;\n    const beginSerialNumber = pageInstance['serialNumber']?.value?.code ?? null;\n    const endSerialNumber = beginSerialNumber && quantityToPick ? _calculateEndingSerialNumber(beginSerialNumber, quantityToPick) : null;\n    const isFilterSerialNumber = pageInstance['_isFilterSerialNumber'] ?? false;\n    const filterLicensePlateNumber = pageInstance._pageMetadata.layoutFields?.licensePlateNumber\n        ? pageInstance['licensePlateNumber'].value?.code\n            ? { licensePlateNumber: { code: pageInstance['licensePlateNumber'].value.code } }\n            : {}\n        : pageInstance.$.queryParameters?.licensePlateNumberOrigin\n            ? { licensePlateNumber: { code: pageInstance.$.queryParameters.licensePlateNumberOrigin } }\n            : { licensePlateNumber: { code: { _in: [undefined, ''] } } };\n    return {\n        ...stockFilter,\n        ...(pageInstance._pageMetadata.layoutFields?.product &&\n            pageInstance['product'].value?.code && {\n            product: { product: { code: pageInstance['product'].value.code } },\n        }),\n        ...filterLicensePlateNumber,\n        ...(pageInstance._pageMetadata.layoutFields?.location &&\n            !pageInstance['location'].isHidden &&\n            pageInstance['location'].value && {\n            location: { code: parameterLocation },\n        }),\n        // lot and sublot are reference fields bound to the same Lot node\n        // so first check if sublot field is enabled with a value. If so, filter for both lot and sublot\n        // otherwise check if lot field is enabled with a value. If so filter for lot and additionally sublot, if applicable\n        ...((pageInstance._pageMetadata.layoutFields?.lot &&\n            !pageInstance['lot'].isHidden &&\n            pageInstance['lot'].value?.lot && {\n            lot: pageInstance['lot'].value.lot,\n            ...(pageInstance['lot'].value.sublot && {\n                sublot: pageInstance['lot'].value.sublot,\n            }),\n        }) ||\n            (pageInstance._pageMetadata.layoutFields?.sublot &&\n                !pageInstance['sublot'].isHidden &&\n                pageInstance['sublot'].value?.sublot && {\n                lot: pageInstance['sublot'].value.lot,\n                sublot: pageInstance['sublot'].value.sublot,\n            })),\n        //...(this.sublot.value?.sublot && { sublot: this.sublot.value.sublot }),\n        ...(pageInstance._pageMetadata.layoutFields?.serialNumber &&\n            !isFilterSerialNumber &&\n            !pageInstance['serialNumber'].isHidden &&\n            pageInstance['serialNumber'].value?.code && {\n            serialNumber: pageInstance['serialNumber'].value.code,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.serialNumber &&\n            isFilterSerialNumber &&\n            beginSerialNumber &&\n            endSerialNumber && {\n            serialNumber: {\n                _gte: beginSerialNumber,\n                //                  _lte: endSerialNumber,\n            },\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.status &&\n            !pageInstance['status'].isHidden &&\n            pageInstance['status'].value && { status: { code: pageInstance['status'].value } }),\n        // ...(this.packingUnit.value && { packingUnit: this._unitMap.get(this.packingUnit.value).unit }),\n        ...(pageInstance._pageMetadata.layoutFields?.packingUnit &&\n            !pageInstance['packingUnit'].isHidden &&\n            pageInstance['packingUnit'].value && {\n            packingUnit: { code: pageInstance['packingUnit'].value },\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor &&\n            !pageInstance['packingUnitToStockUnitConversionFactor'].isHidden &&\n            pageInstance['packingUnitToStockUnitConversionFactor'].value && {\n            packingUnitToStockUnitConversionFactor: pageInstance['packingUnitToStockUnitConversionFactor']\n                .value,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.identifier1 &&\n            !pageInstance['identifier1'].isHidden &&\n            pageInstance['identifier1'].value && { identifier1: pageInstance['identifier1'].value }),\n        ...(pageInstance._pageMetadata.layoutFields?.identifier2 &&\n            !pageInstance['identifier2'].isHidden &&\n            pageInstance['identifier2'].value && { identifier2: pageInstance['identifier2'].value }),\n        ...(pageInstance._pageMetadata.layoutFields?.stockCustomField1 &&\n            !pageInstance['stockCustomField1'].isHidden &&\n            pageInstance['stockCustomField1'].value && {\n            stockCustomField1: pageInstance['stockCustomField1'].value,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.stockCustomField2 &&\n            !pageInstance['stockCustomField2'].isHidden &&\n            pageInstance['stockCustomField2'].value && {\n            stockCustomField2: pageInstance['stockCustomField2'].value,\n        }),\n    };\n}\nexports.generateStockTableFilter = generateStockTableFilter;\nfunction _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n    return startingSerialNumber.replace(/\\d+$/, match => {\n        const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n        const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n        return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n    });\n}\nasync function handleFilterOnChange(pageInstance, field, filterCriterion = null) {\n    // if field value is cleared out during onChange, then delete the corresponding filter property in stock table's filter\n    const stockKey = field.id;\n    if (!stockKey) {\n        //throw new SystemError('Invalid stock property to filter');\n        return; // do nothing?\n    }\n    if (!pageInstance._pageMetadata.layoutFields?.stock) {\n        //throw new SystemError('Invalid stock property to pageInstance');\n        return; // do nothing?\n    }\n    const stock = pageInstance['stock'];\n    const stockChangeLines = pageInstance['_stockChangeLines'] ?? null;\n    const miscellaneousStockTransactionLines = pageInstance['_miscellaneousStockTransactionLines'] ?? null;\n    const currentLine = pageInstance['_currentLine'];\n    const currentStockChangeLine = stockChangeLines ? (stockChangeLines[currentLine] ?? null) : null;\n    const currentMiscellaneousStockTransactionLine = miscellaneousStockTransactionLines\n        ? (miscellaneousStockTransactionLines[currentLine] ?? null)\n        : null;\n    const quantityToPick = pageInstance['_quantityToPick'] ?? null;\n    const beginSerialNumber = pageInstance['serialNumber']?.value?.code ?? null;\n    const endSerialNumber = beginSerialNumber && quantityToPick ? _calculateEndingSerialNumber(beginSerialNumber, quantityToPick) : null;\n    const isFilterSerialNumber = pageInstance['_isFilterSerialNumber'] ?? false;\n    // When for the tuple the value is undefined, the key is removed from the filter.\n    if (!field.value) {\n        stock.filter = {\n            ...stock.filter,\n            ...(typesLib.strictEq(stockKey, 'location') && {\n                ...(typesLib.strictEq(pageInstance.$.page.id, 'MobileSubcontractTransferDetails') && {\n                    [stockKey]: { category: { _nin: ['subcontract', 'customer'] } },\n                }),\n                ...(typesLib.strictNe(pageInstance.$.page.id, 'MobileSubcontractTransferDetails') && { [stockKey]: undefined }),\n            }),\n            ...(!['location'].includes(stockKey) && { [stockKey]: undefined }),\n        };\n    }\n    else {\n        stock.filter = {\n            ...stock.filter,\n            ...(typesLib.strictEq(stockKey, 'packingUnit') &&\n                pageInstance._pageMetadata.layoutFields?.packingUnit && {\n                [stockKey]: {\n                    code: pageInstance[stockKey].value,\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'status') && {\n                [stockKey]: {\n                    code: filterCriterion ??\n                        (field instanceof ui.fields.Reference && field?.valueField\n                            ? { [field.valueField]: field.value[field.valueField] }\n                            : field.value),\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'serialNumber') &&\n                isFilterSerialNumber &&\n                beginSerialNumber &&\n                endSerialNumber && {\n                [stockKey]: {\n                    _gte: beginSerialNumber,\n                    //                      _lte: endSerialNumber,\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'serialNumber') &&\n                !isFilterSerialNumber && {\n                [stockKey]: {\n                    _eq: beginSerialNumber,\n                },\n            }),\n            // All other cases\n            ...(!['packingUnit', 'status', 'serialNumber'].includes(stockKey) && {\n                [stockKey]: filterCriterion ??\n                    (field instanceof ui.fields.Reference && field?.valueField\n                        ? { [field.valueField]: field.value[field.valueField] }\n                        : field.value),\n            }),\n        };\n        // stock.pageSize = 1000;\n    }\n    await _setStockQuantityInPackingUnit(pageInstance, stock, currentStockChangeLine ?? currentMiscellaneousStockTransactionLine);\n    if (!field.value) {\n        field.getNextField(true)?.focus();\n    }\n}\nexports.handleFilterOnChange = handleFilterOnChange;\n/**\n * _setStockQuantityInPackingUnit\n * @param pageInstance current page\n * @param stock stock table\n * @param currentStockLine stock line for lpnOperations or MiscellaneousIssue\n */\nasync function _setStockQuantityInPackingUnit(pageInstance, stock, currentStockLine) {\n    const _stockDetails = currentStockLine?.stockDetails;\n    if (_stockDetails) {\n        stock.selectedRecords.forEach((rowId) => {\n            const stockRecord = stock.getRecordValue(rowId);\n            if (stockRecord) {\n                const qtyTotal = _stockDetails.reduce((acc, curr) => {\n                    return typesLib.add(acc, Number(curr.quantityInPackingUnit));\n                }, 0);\n                stockRecord.quantityInPackingUnit = String(qtyTotal);\n                stock.setRecordValue(stockRecord);\n            }\n        });\n        await pageInstance.$.commitValueAndPropertyChanges();\n    }\n}\n/**\n * Read one serial number for a given stock id\n * @param pageInstance current page\n * @param stockId stock id\n * @param orderBy sort order\n * @returns serial number or null\n */\nasync function readSerialNumberFromStockId(pageInstance, stockId, orderBy) {\n    if (stockId) {\n        try {\n            const serialNumber = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n                .node('@sage/x3-stock-data/SerialNumber')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }, {\n                filter: { stockId },\n                orderBy: { code: orderBy },\n            }))\n                .execute());\n            if (serialNumber[0]) {\n                return serialNumber[0];\n            }\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-serial-number-node', 'Error loading serial number node'), String(e));\n        }\n    }\n    return null;\n}\nexports.readSerialNumberFromStockId = readSerialNumberFromStockId;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/manage-pages.ts\n");

/***/ }),

/***/ "./lib/client-functions/miscellaneous-issue-details-control.ts":
/*!*********************************************************************!*\
  !*** ./lib/client-functions/miscellaneous-issue-details-control.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getStockResults = exports.savedOriginalStockLines = exports._getStockStatus = exports._getQuantityToMove = exports._getMiscellaneousIssueLineStockDetail = exports._getquantityInPackingUnitRest = exports._getQuantityInPackingUnitOrigin = exports._saveDetail = exports._serialNumberManagement = exports._miscellaneousFieldsManagement = exports._initPackingUnitFields = exports._lotManagement = exports._onChangeBody = exports._fieldsManagement = exports._calculateLineQuantity = exports._nextSerialNumber = exports._calculateEndingSerialNumber = exports._saveMiscellaneousIssue = exports._getSavedInputs = exports._isStockJournalToRecord = exports._isLineToRecord = exports._onRowUnselected = exports._onRowSelected = exports._onRowClick = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst pat_converter_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/pat-converter */ \"../../shared/x3-system/lib/shared-functions/pat-converter.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst stock_management_rules_1 = __webpack_require__(/*! ./stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\n;\nfunction _onRowClickGlobalReceivedIssue(pageInstance, currentRecord) {\n    pageInstance.serialNumberLines.isHidden = false;\n    pageInstance.serialNumberLines.value = [];\n    pageInstance._miscellaneousIssueLines.forEach(line => {\n        if (_isLineToRecord(pageInstance, currentRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation)) {\n            line.stockDetails?.forEach((detail) => {\n                if (_isStockJournalToRecord(pageInstance, currentRecord, detail)) {\n                    pageInstance.serialNumberLines.addRecord({\n                        quantity: Number(detail.quantityInPackingUnit),\n                        startingSerialNumber: detail.serialNumber,\n                    });\n                }\n            });\n        }\n    });\n    pageInstance.stock.setRecordValue(currentRecord);\n}\nfunction _onRowClickNotGlobalReceivedIssue(pageInstance, currentRecord) {\n    let lineIndex = pageInstance._miscellaneousIssueLines.findIndex(line => _isLineToRecord(pageInstance, currentRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation));\n    if (typesLib.strictEq(lineIndex, -1)) {\n        lineIndex = typesLib.sub(pageInstance._miscellaneousIssueLines.push({\n            product: pageInstance.product.value?.code,\n            productDescription: pageInstance.product.value?.description1,\n            quantityInPackingUnit: 0,\n            packingUnit: currentRecord.packingUnit?.code,\n            packingUnitToStockUnitConversionFactor: currentRecord.packingUnitToStockUnitConversionFactor,\n            quantityInStockUnit: 0,\n            lineNumber: pageInstance._currentOperation,\n            stockDetails: [],\n        }), 1);\n    }\n    pageInstance._currentLine = lineIndex;\n    let detailIndex = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails?.findIndex((detail) => _isStockJournalToRecord(pageInstance, currentRecord, detail)) ?? -1;\n    if (typesLib.gt(detailIndex, -1)) {\n        const stockDetail = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails\n            ? [detailIndex]\n            : null;\n        if (stockDetail) {\n            stockDetail.quantityInPackingUnit = currentRecord.quantityInPackingUnit;\n            stockDetail.quantityInStockUnit = typesLib.mul(Number(currentRecord.quantityInPackingUnit), Number(currentRecord.packingUnitToStockUnitConversionFactor));\n            pageInstance._currentDetail = detailIndex;\n        }\n    }\n    else {\n        const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;\n        if (stockDetails) {\n            detailIndex = typesLib.sub(stockDetails.push({\n                packingUnit: currentRecord.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: currentRecord.packingUnitToStockUnitConversionFactor,\n                quantityInPackingUnit: Number(currentRecord.quantityInPackingUnit),\n                quantityInStockUnit: typesLib.mul(Number(currentRecord.quantityInPackingUnit), Number(currentRecord.packingUnitToStockUnitConversionFactor)),\n                location: currentRecord.location?.code,\n                licensePlateNumber: currentRecord.licensePlateNumber?.code ?? '',\n                lot: currentRecord.lot,\n                status: currentRecord.status?.code ?? '',\n                sublot: currentRecord.sublot,\n                serialNumber: currentRecord.serialNumber,\n                identifier1: currentRecord.identifier1,\n                identifier2: currentRecord.identifier2,\n                stockCustomField1: currentRecord.stockCustomField1,\n                stockCustomField2: currentRecord.stockCustomField2,\n                stockUnit: pageInstance._productSite.product.stockUnit.code,\n            }), 1);\n        }\n        else {\n            detailIndex = -1;\n        }\n        pageInstance._currentDetail = detailIndex;\n    }\n    _calculateLineQuantity(pageInstance._miscellaneousIssueLines[lineIndex], pageInstance);\n}\nasync function _onRowClick(pageInstance, recordId, rowItem) {\n    pageInstance.gridBlock.selectedRecordId = recordId; // populate grid row block\n    pageInstance._stockId.value = rowItem.stockId;\n    const currentRecord = pageInstance.stock.getRecordValue(pageInstance.gridBlock.selectedRecordId);\n    const originalStockLine = pageInstance._originalStockLines?.find(line => typesLib.strictEq(recordId, line.id));\n    rowItem.quantityInPackingUnit = String(originalStockLine?.quantityInPackingUnit);\n    rowItem.quantityInStockUnit = String(originalStockLine?.quantityInStockUnit);\n    rowItem.packingUnit.code = originalStockLine?.packingUnit.code;\n    rowItem.packingUnit.numberOfDecimals = originalStockLine?.packingUnit.numberOfDecimals;\n    pageInstance.stockDetails.value = [rowItem];\n    const selectedValue = originalStockLine?.packingUnit.code;\n    const packingUnitIndex = pageInstance._packingUnits\n        .map(packingUnit => packingUnit.node.packingUnit.code)\n        .indexOf(selectedValue);\n    if (typesLib.strictNe(packingUnitIndex, -1)) {\n        const selectedUnit = pageInstance._packingUnits[packingUnitIndex].node;\n        pageInstance.packingUnitToStockUnitConversionFactorToIssue.isDisabled =\n            !selectedUnit.isPackingFactorEntryAllowed;\n        pageInstance.quantityToMove.scale = selectedUnit.packingUnit.numberOfDecimals;\n    }\n    else {\n        pageInstance.packingUnitToStockUnitConversionFactorToIssue.isDisabled = true;\n        pageInstance.quantityToMove.scale = 0;\n    }\n    pageInstance.quantityToMove.value = null;\n    pageInstance.packingUnitToStockUnitConversionFactorToIssue.value = originalStockLine?.packingUnitToStockUnitConversionFactor ?? 1;\n    pageInstance.packingUnitToIssue.value = originalStockLine?.packingUnit.code;\n    const conversionFactor = pageInstance.packingUnitToStockUnitConversionFactorToIssue.value.toString();\n    const numberOfDec = (conversionFactor.includes('.')) ? conversionFactor.split('.')[1].length : 0;\n    pageInstance.packingUnitToStockUnitConversionFactorToIssue.scale = numberOfDec;\n    if (pageInstance._packingUnits.length) {\n        pageInstance.packingUnitToIssue.isDisabled = false;\n    }\n    currentRecord.quantityInStockUnit = originalStockLine?.quantityInStockUnit;\n    currentRecord.packingUnit.code = originalStockLine?.packingUnit.code;\n    currentRecord.quantityInPackingUnit = originalStockLine?.quantityInPackingUnit;\n    if (typesLib.strictEq(pageInstance._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n        _onRowClickGlobalReceivedIssue(pageInstance, currentRecord);\n    }\n    else {\n        _onRowClickNotGlobalReceivedIssue(pageInstance, currentRecord);\n    }\n    await pageInstance.$.commitValueAndPropertyChanges();\n    await pageInstance.stock.validateWithDetails();\n    if (pageInstance.$.detailPanel)\n        pageInstance.$.detailPanel.isHidden = false;\n    pageInstance.stock.setRecordValue(currentRecord);\n}\nexports._onRowClick = _onRowClick;\nasync function _onRowSelectedGlobalReceivedIssued(pageInstance, stockRecord, lineIndex) {\n    const responseSerialNumber = await pageInstance.$.graph\n        .node('@sage/x3-stock-data/SerialNumber')\n        .query(ui.queryUtils.edgesSelector({\n        code: true,\n    }, {\n        filter: {\n            stockId: stockRecord.stockId,\n            product: { code: pageInstance.product.value?.code },\n            stockSite: { code: pageInstance.site.value },\n        },\n        first: 1001,\n    }))\n        .execute();\n    let currentSerialNumber;\n    currentSerialNumber = '';\n    let beginSerialNumber;\n    beginSerialNumber = '';\n    let quantitySerialNumber;\n    quantitySerialNumber = 0;\n    for (const itemSerialNumber of responseSerialNumber.edges) {\n        if (typesLib.strictEq(beginSerialNumber, '')) {\n            beginSerialNumber = itemSerialNumber.node.code;\n            currentSerialNumber = itemSerialNumber.node.code;\n            quantitySerialNumber = 1;\n        }\n        else if (typesLib.strictEq(itemSerialNumber.node.code, _nextSerialNumber(currentSerialNumber))) {\n            var _v;\n            currentSerialNumber = itemSerialNumber.node.code;\n            _v = quantitySerialNumber, quantitySerialNumber = typesLib.add(quantitySerialNumber, 1), _v;\n        }\n        else {\n            const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;\n            if (stockDetails) {\n                pageInstance._currentDetail = typesLib.sub(stockDetails.push({\n                    packingUnit: stockRecord.packingUnit?.code,\n                    packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,\n                    quantityInPackingUnit: quantitySerialNumber,\n                    quantityInStockUnit: typesLib.mul(Number(quantitySerialNumber), Number(stockRecord.packingUnitToStockUnitConversionFactor)),\n                    location: stockRecord.location?.code,\n                    licensePlateNumber: stockRecord.licensePlateNumber?.code ?? '',\n                    lot: stockRecord.lot,\n                    status: stockRecord.status?.code ?? '',\n                    sublot: stockRecord.sublot,\n                    serialNumber: beginSerialNumber,\n                    identifier1: stockRecord.identifier1,\n                    identifier2: stockRecord.identifier2,\n                    stockCustomField1: stockRecord.stockCustomField1,\n                    stockCustomField2: stockRecord.stockCustomField2,\n                    stockUnit: pageInstance._productSite.product.stockUnit.code,\n                }), 1);\n            }\n            else {\n                pageInstance._currentDetail = -1;\n            }\n            beginSerialNumber = itemSerialNumber.node.code;\n            currentSerialNumber = itemSerialNumber.node.code;\n            quantitySerialNumber = 1;\n        }\n    }\n    if (typesLib.strictNe(beginSerialNumber, '') && typesLib.strictNe(quantitySerialNumber, 0)) {\n        const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;\n        if (stockDetails) {\n            pageInstance._currentDetail = typesLib.sub(stockDetails.push({\n                packingUnit: stockRecord.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,\n                quantityInPackingUnit: quantitySerialNumber,\n                quantityInStockUnit: typesLib.mul(Number(quantitySerialNumber), Number(stockRecord.packingUnitToStockUnitConversionFactor)),\n                location: stockRecord.location?.code,\n                licensePlateNumber: stockRecord.licensePlateNumber?.code ?? '',\n                lot: stockRecord.lot,\n                status: stockRecord.status?.code ?? '',\n                sublot: stockRecord.sublot,\n                serialNumber: beginSerialNumber,\n                identifier1: stockRecord.identifier1,\n                identifier2: stockRecord.identifier2,\n                stockCustomField1: stockRecord.stockCustomField1,\n                stockCustomField2: stockRecord.stockCustomField2,\n                stockUnit: pageInstance._productSite.product.stockUnit.code,\n            }), 1);\n        }\n        else {\n            pageInstance._currentDetail = -1;\n        }\n    }\n}\nfunction _onRowSelectedNotGlobalReceivedIssued(pageInstance, stockRecord, lineIndex) {\n    const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;\n    if (stockDetails) {\n        let detailIndex = stockDetails.findIndex(detail => _isStockJournalToRecord(pageInstance, stockRecord, detail));\n        if (typesLib.gt(detailIndex, -1)) {\n            const stockDetail = stockDetails[detailIndex];\n            stockDetail.quantityInPackingUnit = stockRecord.quantityInPackingUnit;\n            stockDetail.quantityInStockUnit = typesLib.mul(Number(stockRecord.quantityInPackingUnit), Number(stockRecord.packingUnitToStockUnitConversionFactor));\n            pageInstance._currentDetail = detailIndex;\n        }\n        else {\n            detailIndex = typesLib.sub(stockDetails.push({\n                packingUnit: stockRecord.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,\n                quantityInPackingUnit: Number(stockRecord.quantityInPackingUnit),\n                quantityInStockUnit: typesLib.mul(Number(stockRecord.quantityInPackingUnit), Number(stockRecord.packingUnitToStockUnitConversionFactor)),\n                location: stockRecord.location?.code,\n                licensePlateNumber: stockRecord.licensePlateNumber?.code ?? '',\n                lot: stockRecord.lot,\n                status: stockRecord.status?.code ?? '',\n                sublot: stockRecord.sublot,\n                serialNumber: stockRecord.serialNumber,\n                identifier1: stockRecord.identifier1,\n                identifier2: stockRecord.identifier2,\n                stockCustomField1: stockRecord.stockCustomField1,\n                stockCustomField2: stockRecord.stockCustomField2,\n                stockUnit: pageInstance._productSite.product.stockUnit.code,\n            }), 1);\n        }\n        pageInstance._currentDetail = detailIndex;\n    }\n}\nasync function _onRowSelected(pageInstance, recordId, _rowItem) {\n    const stockRecord = pageInstance.stock.getRecordValue(recordId);\n    if (stockRecord) {\n        pageInstance.stock.isDisabled = true;\n        let lineIndex = pageInstance._miscellaneousIssueLines.findIndex(line => _isLineToRecord(pageInstance, stockRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation));\n        if (typesLib.strictEq(lineIndex, -1)) {\n            lineIndex = typesLib.sub(pageInstance._miscellaneousIssueLines.push({\n                product: pageInstance.product.value?.code,\n                productDescription: pageInstance.product.value?.description1,\n                quantityInPackingUnit: 0,\n                packingUnit: stockRecord.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,\n                quantityInStockUnit: 0,\n                lineNumber: pageInstance._currentOperation,\n                stockDetails: [],\n            }), 1);\n        }\n        pageInstance._currentLine = lineIndex;\n        if (typesLib.strictEq(pageInstance._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n            _onRowSelectedGlobalReceivedIssued(pageInstance, stockRecord, lineIndex);\n        }\n        else {\n            _onRowSelectedNotGlobalReceivedIssued(pageInstance, stockRecord, lineIndex);\n        }\n        _calculateLineQuantity(pageInstance._miscellaneousIssueLines[lineIndex], pageInstance);\n        _saveMiscellaneousIssue(pageInstance);\n        stockRecord.quantityToMove = stockRecord.quantityInPackingUnit;\n        stockRecord.quantityInStockUnit = typesLib.mul(Number(stockRecord.quantityInPackingUnit), Number(stockRecord.packingUnitToStockUnitConversionFactor));\n        pageInstance.stock.setRecordValue(stockRecord);\n        pageInstance.stock.selectRecord(recordId);\n        pageInstance.stock.isDisabled = false;\n    }\n}\nexports._onRowSelected = _onRowSelected;\nasync function _onRowUnselected(pageInstance, recordId, _rowItem) {\n    const stockRecord = pageInstance.stock.getRecordValue(recordId);\n    if (stockRecord) {\n        let i;\n        i = 0;\n        pageInstance._miscellaneousIssueLines.forEach(line => {\n            if (_isLineToRecord(pageInstance, stockRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation)) {\n                let j;\n                j = 0;\n                line.stockDetails?.forEach(stock => {\n                    var _v;\n                    if (_isStockJournalToRecord(pageInstance, stockRecord, stock)) {\n                        line.stockDetails?.splice(j, 1);\n                    }\n                    _v = j, j = typesLib.add(j, 1), _v;\n                });\n            }\n        });\n        _saveMiscellaneousIssue(pageInstance);\n        const originalStockLine = pageInstance._originalStockLines?.find(line => typesLib.strictEq(recordId, line.id));\n        stockRecord.quantityToMove = originalStockLine?.quantityInPackingUnit;\n        stockRecord.packingUnit.code = originalStockLine?.packingUnit.code;\n        stockRecord.quantityInStockUnit = originalStockLine?.quantityInStockUnit;\n        stockRecord.quantityInPackingUnit = originalStockLine?.quantityInPackingUnit;\n        pageInstance.stock.setRecordValue(stockRecord);\n    }\n}\nexports._onRowUnselected = _onRowUnselected;\nfunction _isLineToRecord(_pageInstance, record, line) {\n    return typesLib.strictEq(line.product, record.product?.product.code);\n}\nexports._isLineToRecord = _isLineToRecord;\nfunction _isStockJournalToRecord(pageInstance, record, line) {\n    return (typesLib.strictEq(line.packingUnit, (record?.packingUnit?.code ?? '')) && typesLib.strictEq(line.packingUnitToStockUnitConversionFactor, record?.packingUnitToStockUnitConversionFactor) && typesLib.strictEq(line.location, record?.location?.code) && typesLib.strictEq(line.licensePlateNumber, (record?.licensePlateNumber?.code ?? '')) && typesLib.strictEq(line.lot, record?.lot) && typesLib.strictEq(line.status, (record?.status?.code ?? '')) && typesLib.strictEq(line.sublot, record?.sublot) &&\n        (typesLib.strictEq(line.serialNumber, record?.serialNumber) || typesLib.strictEq(pageInstance._serialNumberManagementMode, 'globalReceivedIssued')) && typesLib.strictEq(line.identifier1, record?.identifier1) && typesLib.strictEq(line.identifier2, record?.identifier2) && typesLib.strictEq(line.stockCustomField1, record?.stockCustomField1) && typesLib.strictEq(line.stockCustomField2, record?.stockCustomField2));\n}\nexports._isStockJournalToRecord = _isStockJournalToRecord;\nfunction _getSavedInputs(pageInstance) {\n    return JSON.parse(pageInstance.$.storage.get('mobile-miscellaneousIssue'));\n}\nexports._getSavedInputs = _getSavedInputs;\nfunction _saveMiscellaneousIssue(pageInstance) {\n    const miscellaneousIssueLines = pageInstance._miscellaneousIssueLines ?? null;\n    const savedInputs = _getSavedInputs(pageInstance);\n    savedInputs.miscellaneousIssue.miscellaneousIssueLines = miscellaneousIssueLines;\n    savedInputs.currentLine = pageInstance._currentLine;\n    savedInputs.currentDetail = pageInstance._currentDetail;\n    pageInstance.$.storage.set('mobile-miscellaneousIssue', JSON.stringify(savedInputs));\n}\nexports._saveMiscellaneousIssue = _saveMiscellaneousIssue;\nfunction _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n    return startingSerialNumber.replace(/\\d+$/, match => {\n        const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n        const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n        return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n    });\n}\nexports._calculateEndingSerialNumber = _calculateEndingSerialNumber;\nfunction _nextSerialNumber(currentSerialNumber) {\n    return currentSerialNumber.replace(/\\d+$/, match => {\n        const nextSerialNumber = (typesLib.add(Number(match), 1)).toString();\n        const lengthDiff = typesLib.max(typesLib.sub(nextSerialNumber.length, match.length), 0);\n        return nextSerialNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n    });\n}\nexports._nextSerialNumber = _nextSerialNumber;\nfunction _calculateLineQuantity(line, pageInstance) {\n    line.quantityInPackingUnit = 0;\n    line.quantityInStockUnit = 0;\n    line.stockDetails?.forEach(detail => {\n        // line.quantityInPackingUnit =\n        //     Number(line.quantityInPackingUnit) + Number((detail as StockJournalInput).quantityInPackingUnit);\n        line.quantityInStockUnit = typesLib.add(Number(line.quantityInStockUnit), Number(detail.quantityInStockUnit));\n        line.quantityInPackingUnit = typesLib.div(line.quantityInStockUnit, (pageInstance.packingUnitToStockUnitConversionFactorToIssue.value\n            ? pageInstance.packingUnitToStockUnitConversionFactorToIssue.value\n            : 1));\n    });\n    line.packingUnit = String(pageInstance.packingUnitToIssue.value);\n}\nexports._calculateLineQuantity = _calculateLineQuantity;\nasync function _fieldsManagement(pageInstance) {\n    _lotManagement(pageInstance);\n    await _miscellaneousFieldsManagement(pageInstance);\n    _initPackingUnitFields(pageInstance);\n    _serialNumberManagement(pageInstance);\n}\nexports._fieldsManagement = _fieldsManagement;\nasync function _onChangeBody(pageInstance) {\n    const currentRecord = pageInstance.gridBlock.selectedRecordId\n        ? pageInstance.stock.getRecordValue(pageInstance.gridBlock.selectedRecordId)\n        : null;\n    if (!currentRecord) {\n        return;\n    }\n    const currentQty = typesLib.mul(Number(pageInstance.quantityToMove.value), (Number(pageInstance.packingUnitToStockUnitConversionFactorToIssue.value)));\n    if (!currentQty || !pageInstance.startingSerialNumber.value || !pageInstance.startingSerialNumber.value.code) {\n        pageInstance.endingSerialNumber.value = null;\n        return;\n    }\n    pageInstance.startingSerialNumber.value.code = pageInstance.startingSerialNumber.value.code.toUpperCase();\n    if (typesLib.gt(currentQty, 1)) {\n        pageInstance.endingSerialNumber.value = _calculateEndingSerialNumber(pageInstance.startingSerialNumber.value.code, currentQty);\n    }\n    else {\n        pageInstance.endingSerialNumber.value = pageInstance.startingSerialNumber.value.code;\n    }\n    if (typesLib.gt(currentQty, currentRecord.quantityInPackingUnitOrigin))\n        pageInstance.addSerialRange.isHidden = true;\n    else {\n        pageInstance.addSerialRange.isHidden = false;\n    }\n    // validate range does not contain existing or non-existent serial numbers\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const validationResult = await pageInstance.endingSerialNumber.validate();\n    if (validationResult) {\n        pageInstance.$.showToast(validationResult, { type: 'warning' });\n    }\n}\nexports._onChangeBody = _onChangeBody;\nfunction _lotManagement(pageInstance) {\n    pageInstance.lot.isHidden = typesLib.strictEq(pageInstance._productSite.product.lotManagementMode, 'notManaged');\n    pageInstance.sublot.isHidden = typesLib.strictNe(pageInstance._productSite.product.lotManagementMode, 'lotAndSublot');\n}\nexports._lotManagement = _lotManagement;\nfunction _initPackingUnitFields(pageInstance) {\n    const productPackingList = (0, xtrem_client_1.extractEdges)(pageInstance._productSite.product.packingUnits.query).filter(productPacking => {\n        return !!productPacking.packingUnit?.code;\n    });\n    pageInstance._packingUnits = productPackingList.map(productPacking => {\n        return { node: productPacking };\n    });\n    const productPakingUnitSelectValues = productPackingList.map(productPacking => {\n        return `${productPacking.packingUnit.code}`;\n    });\n    pageInstance.packingUnit.options = [\n        pageInstance._productSite.product.stockUnit.code,\n        ...productPakingUnitSelectValues,\n    ];\n}\nexports._initPackingUnitFields = _initPackingUnitFields;\nasync function _miscellaneousFieldsManagement(pageInstance) {\n    if (!(pageInstance.lot.isHidden || !!pageInstance._productSite.product.lotSequenceNumber) &&\n        ['lotAndSublot', 'mandatoryLot'].includes(pageInstance._productSite.product.lotManagementMode))\n        pageInstance.lot.isMandatory = true;\n    const transaction = _getSavedInputs(pageInstance).selectedTransaction;\n    if (typesLib.strictEq(transaction.isStatusChange, true))\n        pageInstance.status.isMandatory = true;\n    pageInstance._selectedStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(pageInstance._stockSite.code, pageInstance._productSite.product.productCategory.code, '26', transaction.stockMovementCode?.code ?? null, pageInstance);\n    pageInstance.status.options = await _getStockStatus(pageInstance);\n}\nexports._miscellaneousFieldsManagement = _miscellaneousFieldsManagement;\nfunction _serialNumberManagement(pageInstance) {\n    pageInstance.serialNumber.isHidden = ['notManaged', 'issued'].includes(pageInstance._productSite.product.serialNumberManagementMode);\n    if (['receivedIssued', 'globalReceivedIssued'].includes(pageInstance._productSite.product.serialNumberManagementMode)) {\n        pageInstance.serialNumber.isMandatory = true;\n        if (typesLib.strictEq(pageInstance.lot.isHidden, false))\n            pageInstance.lot.isMandatory = false;\n        if (typesLib.strictEq(pageInstance.sublot.isHidden, false))\n            pageInstance.sublot.isMandatory = false;\n        if (typesLib.strictEq(pageInstance.status.isHidden, false))\n            pageInstance.status.isMandatory = false;\n        if (typesLib.strictEq(pageInstance.packingUnit.isHidden, false))\n            pageInstance.packingUnit.isMandatory = false;\n    }\n}\nexports._serialNumberManagement = _serialNumberManagement;\nfunction _saveDetail(pageInstance) {\n    const currentmiscellaneousIssueLines = pageInstance._miscellaneousIssueLines[pageInstance._currentLine];\n    pageInstance._miscellaneousIssueLines[pageInstance._currentLine] = {\n        ...currentmiscellaneousIssueLines,\n    };\n    _saveMiscellaneousIssue(pageInstance);\n}\nexports._saveDetail = _saveDetail;\nfunction _getQuantityInPackingUnitOrigin(pageInstance, record) {\n    if (record.quantityInPackingUnitOrigin) {\n        return record.quantityInPackingUnitOrigin;\n    }\n    else {\n        let miscellaneousIssueLines = pageInstance._miscellaneousIssueLines;\n        if (typesLib.strictEq(miscellaneousIssueLines, undefined)) {\n            miscellaneousIssueLines = _getSavedInputs(pageInstance).miscellaneousIssue.miscellaneousIssueLines ?? [];\n        }\n        let _quantityInPackingUnitOrigin;\n        _quantityInPackingUnitOrigin = Number(record.quantityInPackingUnit);\n        miscellaneousIssueLines.forEach(line => {\n            if (_isLineToRecord(pageInstance, record, line) && typesLib.strictNe(line.lineNumber, pageInstance._currentOperation)) {\n                line.stockDetails?.forEach(detail => {\n                    if (_isStockJournalToRecord(pageInstance, record, detail)) {\n                        _quantityInPackingUnitOrigin = typesLib.sub(Number(_quantityInPackingUnitOrigin), Number(detail.quantityInPackingUnit));\n                    }\n                });\n            }\n        });\n        return _quantityInPackingUnitOrigin;\n    }\n}\nexports._getQuantityInPackingUnitOrigin = _getQuantityInPackingUnitOrigin;\nfunction _getquantityInPackingUnitRest(pageInstance, record) {\n    let miscellaneousIssueLines = pageInstance._miscellaneousIssueLines;\n    if (typesLib.strictEq(miscellaneousIssueLines, undefined)) {\n        miscellaneousIssueLines = _getSavedInputs(pageInstance).miscellaneousIssue.miscellaneousIssueLines ?? [];\n    }\n    if (typesLib.strictEq(pageInstance._serialNumberManagementMode, undefined)) {\n        pageInstance._serialNumberManagementMode =\n            _getSavedInputs(pageInstance).selectedProduct?.serialNumberManagementMode;\n    }\n    let _quantityInPackingUnitRest = _getQuantityInPackingUnitOrigin(pageInstance, record);\n    if (typesLib.strictEq(pageInstance._serialNumberManagementMode, 'globalReceivedIssued')) {\n        pageInstance._miscellaneousIssueLines?.forEach(line => {\n            if (_isLineToRecord(pageInstance, record, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation)) {\n                line.stockDetails?.forEach(detail => {\n                    if (_isStockJournalToRecord(pageInstance, record, detail)) {\n                        _quantityInPackingUnitRest = typesLib.sub(Number(_quantityInPackingUnitRest), Number(detail.quantityInPackingUnit));\n                    }\n                });\n            }\n        });\n    }\n    return _quantityInPackingUnitRest;\n}\nexports._getquantityInPackingUnitRest = _getquantityInPackingUnitRest;\nfunction _getMiscellaneousIssueLineStockDetail(pageInstance, record) {\n    let miscellaneousIssueLines = pageInstance._miscellaneousIssueLines;\n    if (typesLib.strictEq(miscellaneousIssueLines, undefined)) {\n        miscellaneousIssueLines = _getSavedInputs(pageInstance).miscellaneousIssue.miscellaneousIssueLines ?? [];\n    }\n    const _line = miscellaneousIssueLines.find(line => _isLineToRecord(pageInstance, record, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation));\n    if (_line) {\n        return _line.stockDetails?.find(detail => _isStockJournalToRecord(pageInstance, record, detail));\n    }\n    else {\n        return undefined;\n    }\n}\nexports._getMiscellaneousIssueLineStockDetail = _getMiscellaneousIssueLineStockDetail;\nfunction _getQuantityToMove(pageInstance, record) {\n    const line = _getMiscellaneousIssueLineStockDetail(pageInstance, record);\n    let _quantityToMove;\n    if (line) {\n        _quantityToMove = Number(line.quantityInPackingUnit);\n    }\n    else {\n        _quantityToMove = Number(record.quantityInPackingUnit);\n    }\n    const _quantityInPackingUnitRest = _getquantityInPackingUnitRest(pageInstance, record);\n    if (typesLib.gt(Number(_quantityToMove), Number(_quantityInPackingUnitRest))) {\n        _quantityToMove = Number(_quantityInPackingUnitRest);\n    }\n    return _quantityToMove;\n}\nexports._getQuantityToMove = _getQuantityToMove;\nasync function _getStockStatus(pageInstance) {\n    const selectedStatus = [];\n    pageInstance._selectedStockManagementRules.authorizedSubstatus.split(',').forEach(function (status) {\n        selectedStatus.push({ _regex: (0, pat_converter_1.getRegExp)(status).source });\n    });\n    const response = await pageInstance.$.graph\n        .node('@sage/x3-stock-data/StockStatus')\n        .query(ui.queryUtils.edgesSelector({\n        _id: true,\n        code: true,\n    }, {\n        filter: {\n            code: { _or: selectedStatus },\n        },\n    }))\n        .execute();\n    if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n        throw new Error(ui.localize('@sage/x3-stock/pages__stock_change_details__notification__invalid_stock_status_error', 'No stock status'));\n    }\n    return response.edges.map((stockStatus) => stockStatus.node.code);\n}\nexports._getStockStatus = _getStockStatus;\nasync function savedOriginalStockLines(pageInstance) {\n    const page = pageInstance;\n    const _stockQueryResult = await getStockResults(page, page.stock.filter);\n    page._originalStockLines = [{}];\n    _stockQueryResult?.forEach((line) => {\n        if (typesLib.lt(page._originalStockLines.findIndex((element) => typesLib.strictEq(element.id, line._id)), 0)) {\n            page._originalStockLines.push({\n                id: line._id ?? '',\n                stockId: line.stockId ?? '',\n                packingUnit: line.packingUnit,\n                packingUnitToStockUnitConversionFactor: Number(line.packingUnitToStockUnitConversionFactor),\n                quantityInStockUnit: Number(line.quantityInStockUnit),\n                quantityInPackingUnit: Number(line.quantityInPackingUnit),\n            });\n        }\n    });\n    page._originalStockLines.splice(0, 1);\n}\nexports.savedOriginalStockLines = savedOriginalStockLines;\nasync function getStockResults(pageInstance, filter, maxResult = 500) {\n    const page = pageInstance;\n    return (0, xtrem_client_1.extractEdges)(await page.$.graph\n        .node('@sage/x3-stock-data/Stock')\n        .query(ui.queryUtils.edgesSelector({\n        owner: true,\n        qualityAnalysisRequestId: true,\n        allocatedQuantity: true,\n        quantityInStockUnit: true,\n        lotReference: {\n            majorVersion: {\n                _id: true,\n                code: true,\n            },\n            lotCustomField2: true,\n            lotCustomField1: true,\n            useByDate: true,\n            expirationDate: true,\n        },\n        stockId: true,\n        stockCustomField2: true,\n        stockCustomField1: true,\n        identifier2: true,\n        identifier1: true,\n        packingUnitToStockUnitConversionFactor: true,\n        packingUnit: {\n            code: true,\n            numberOfDecimals: true,\n        },\n        status: { code: true },\n        serialNumber: true,\n        sublot: true,\n        lot: true,\n        location: {\n            _id: true,\n            code: true,\n            category: true,\n        },\n        licensePlateNumber: { code: true },\n        product: {\n            product: {\n                _id: true,\n                code: true,\n                stockUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                serialNumberManagementMode: true,\n                lotManagementMode: true,\n                description1: true,\n                localizedDescription1: true,\n                expirationManagementMode: true,\n                productCategory: { code: true },\n                productSites: {\n                    query: {\n                        edges: {\n                            node: {\n                                stockSite: {\n                                    code: true\n                                },\n                            },\n                        },\n                    },\n                },\n            },\n        },\n        quantityInPackingUnit: true,\n        _id: true,\n        availableQuantity: true,\n        isBeingCounted: true,\n    }, {\n        filter,\n        first: typesLib.max(maxResult, 500),\n    }))\n        .execute());\n}\nexports.getStockResults = getStockResults;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/miscellaneous-issue-details-control.ts\n");

/***/ }),

/***/ "./lib/client-functions/stock-management-rules.ts":
/*!********************************************************!*\
  !*** ./lib/client-functions/stock-management-rules.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.findDefaultLocation = exports.findStockManagementRules = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance) {\n    try {\n        //read the stock management rules\n        const stockManagementRules = await pageInstance.$.graph\n            .node('@sage/x3-stock-data/StockManagementRules')\n            .query(ui.queryUtils.edgesSelector({\n            productCategory: { code: true },\n            stockSite: { code: true },\n            transactionType: true,\n            stockMovementCode: { code: true },\n            defaultStatus: true,\n            locationNumber: true,\n            locationNumber2: true,\n            locationNumber3: true,\n            authorizedStatus: true,\n            authorizedSubstatus: true,\n            hasAnalysisRequest: true,\n            lotEntry: true,\n            lotByDefault: true,\n            outputLot: true,\n            isExclusiveEntryVersion: true,\n            activeVersion: true,\n            licensePlateNumberEntry: true,\n            versionStopped: true,\n            prototypeVersion: true,\n        }, {\n            filter: {\n                productCategory: { code: productCategory },\n                stockSite: { code: stockSite },\n                transactionType: transactionType,\n                stockMovementCode: { code: stockMovementCode },\n            },\n        }))\n            .execute();\n        if (typesLib.gt(stockManagementRules.edges.length, 0))\n            return stockManagementRules.edges[0].node;\n        else\n            return null;\n    }\n    catch (e) { }\n}\nasync function findStockManagementRules(stockSite, productCategory, transactionType, //TRSTYP, menu 704\nstockMovementCode, //TRSCOD\npageInstance) {\n    // for the stock site, the product category and the movement code\n    let stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for stock site and product category\n    stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category and movement code\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // general rules\n    stockManagementRules = await _readStockManagementRules(null, null, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    throw new Error(ui.localize('@sage/x3-stock/stock_management_rules__notification__no_management_rules_error', `Could not retrieve the management rules for your product category {{ productCategory }} and for the site {{ siteCode }}`, { productCategory: productCategory, siteCode: stockSite }));\n}\nexports.findStockManagementRules = findStockManagementRules;\nasync function _readProductCategorySite(stockSite, productCategory, pageInstance) {\n    try {\n        //read the product category site\n        const productCategorySite = await pageInstance.$.graph\n            .node('@sage/x3-master-data/productCategory')\n            .read({\n            stockSite: { code: true },\n            code: true,\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: true,\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n        }, \n        // TODO: find a better way if possible\n        `${stockSite}|${productCategory}`)\n            .execute();\n        return productCategorySite ?? null;\n    }\n    catch (e) {\n        return null;\n    }\n}\nasync function findDefaultLocation(productSite, stockManagementRules, pageInstance) {\n    // find the default location for the product site\n    const defaultLocation = productSite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n    if (defaultLocation &&\n        defaultLocation.node.defaultLocation &&\n        !defaultLocation.node.defaultLocation.match(/[* ! # ?]/))\n        return defaultLocation.node.defaultLocation;\n    // find the default location for the product category site\n    const ProductCategorySite = await _readProductCategorySite(productSite.stockSite.code, productSite.product.productCategory.code, pageInstance);\n    if (ProductCategorySite) {\n        const defaultLocationCateg = ProductCategorySite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n        if (defaultLocationCateg &&\n            defaultLocationCateg.node.defaultLocation &&\n            !defaultLocationCateg.node.defaultLocation.match(/[* ! # ?]/))\n            return defaultLocationCateg.node.defaultLocation;\n    }\n    return null;\n}\nexports.findDefaultLocation = findDefaultLocation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/stock-management-rules.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-intersite-transfer-details.ts":
/*!********************************************************!*\
  !*** ./lib/pages/mobile-intersite-transfer-details.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileIntersiteTransferDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_count_serial_number_1 = __webpack_require__(/*! @sage/x3-stock-data/lib/client-functions/get-count-serial-number */ \"../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\");\nconst pat_converter_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/pat-converter */ \"../../shared/x3-system/lib/shared-functions/pat-converter.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst get_unit_number_decimals_1 = __webpack_require__(/*! ../client-functions/get-unit-number-decimals */ \"./lib/client-functions/get-unit-number-decimals.ts\");\nconst manage_pages_1 = __webpack_require__(/*! ../client-functions/manage-pages */ \"./lib/client-functions/manage-pages.ts\");\nconst miscellaneous_issue_details_control_1 = __webpack_require__(/*! ../client-functions/miscellaneous-issue-details-control */ \"./lib/client-functions/miscellaneous-issue-details-control.ts\");\nconst stock_management_rules_1 = __webpack_require__(/*! ../client-functions/stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\nconst hideWhenEmptyValue = (value, rowValue) => {\n    return typesLib.strictNe(typeof value, 'number') && !value; // we don't want to hide numeric field with value of 0\n};\nlet MobileIntersiteTransferDetails = class MobileIntersiteTransferDetails extends ui.Page {\n    constructor() {\n        /*\n         *\n         *  Technical properties\n         *\n         */\n        super(...arguments);\n        this._currentLine = 0;\n        this._stockFieldSettings = [];\n    }\n    _activeSelectButton() {\n        const currentRecord = this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '');\n    }\n    /*\n     *\n     *  Init functions\n     *\n     */\n    async _init() {\n        const savedInputs = this._getSavedInputs();\n        const storageProductSite = savedInputs?.selectedProduct;\n        this._stockChangeLines = savedInputs?.intersiteTransfer?.stockChangeLines ?? [];\n        this._initSiteCodeField();\n        this._productSite = await this._getProductSite(storageProductSite?.code ?? '');\n        this._initTechnicalProperties();\n        await this._fieldsManagement();\n    }\n    _getSavedInputs() {\n        return JSON.parse(this.$.storage.get('mobile-intersiteTransfer'));\n    }\n    async _getProductSite(storageProductSite) {\n        if (storageProductSite) {\n            const productCode = storageProductSite;\n            const productSiteToReceive = await this.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .read({\n                isLocationManaged: true,\n                isLicensePlateNumberManaged: true,\n                defaultInternalContainer: {\n                    code: true,\n                },\n                product: {\n                    code: true,\n                    localizedDescription1: true,\n                    lotManagementMode: true,\n                    serialNumberManagementMode: true,\n                    stockVersionMode: true,\n                    expirationManagementMode: true,\n                    serialSequenceNumber: true,\n                    lotSequenceNumber: true,\n                    stockManagementMode: true,\n                    defaultPotencyInPercentage: true,\n                    expirationLeadTime: true,\n                    expirationTimeUnit: true,\n                    useByDateCoefficient: true,\n                    stockUnit: {\n                        code: true,\n                        numberOfDecimals: true,\n                    },\n                    productCategory: {\n                        code: true,\n                    },\n                    packingUnits: {\n                        query: {\n                            edges: {\n                                node: {\n                                    packingUnit: {\n                                        code: true,\n                                        numberOfDecimals: true,\n                                    },\n                                    packingUnitToStockUnitConversionFactor: true,\n                                    isPackingFactorEntryAllowed: true,\n                                },\n                            },\n                        },\n                    },\n                },\n            }, `${productCode}|${this._siteDestination?.code}`)\n                .execute();\n            return productSiteToReceive;\n        }\n    }\n    _initSiteCodeField() {\n        const siteCode = this.$.storage.get('mobile-selected-stock-site');\n        if (siteCode) {\n            this.site.value = siteCode;\n        }\n    }\n    _initTechnicalProperties() {\n        this.product.value = {\n            code: this._productSite.product.code,\n            serialNumberManagementMode: this._productSite.product.serialNumberManagementMode,\n            lotManagementMode: this._productSite.product.lotManagementMode,\n            expirationManagementMode: this._productSite.product.expirationManagementMode,\n            stockUnit: {\n                code: this._productSite.product.stockUnit.code,\n                numberOfDecimals: this._productSite.product.stockUnit.numberOfDecimals,\n            },\n        };\n        this.localizedDescription.value = this._productSite.product.localizedDescription1;\n    }\n    /*\n     *\n     *  Fields management functions\n     *\n     */\n    async _onRowClick(recordId, rowItem) {\n        const _record = this.stock.getRecordValue(recordId);\n        const _stockId = Number(rowItem.stockId);\n        this.gridBlock.selectedRecordId = recordId; // populate grid row block\n        this._stockId.value = String(_stockId);\n        const originalStockLine = this._originalStockLines?.find(line => typesLib.strictEq(recordId, line.id));\n        rowItem.quantityInPackingUnit = String(originalStockLine?.quantityInPackingUnit);\n        rowItem.quantityInStockUnit = String(originalStockLine?.quantityInStockUnit);\n        rowItem.packingUnit.code = originalStockLine?.packingUnit.code;\n        rowItem.packingUnit.numberOfDecimals = originalStockLine?.packingUnit.numberOfDecimals;\n        this.stockDetails.value = [rowItem];\n        const selectedValue = originalStockLine?.packingUnit.code;\n        const packingUnitIndex = this._packingUnits\n            .map(packingUnit => packingUnit.node.packingUnit.code)\n            .indexOf(selectedValue);\n        if (typesLib.strictNe(packingUnitIndex, -1)) {\n            const selectedUnit = this._packingUnits[packingUnitIndex].node;\n            this.packingUnitToStockUnitConversionFactorToTransfer.isDisabled =\n                !selectedUnit.isPackingFactorEntryAllowed;\n            this.quantityToMove.scale = selectedUnit.packingUnit.numberOfDecimals;\n            this.packingUnitToStockUnitConversionFactorDestination.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n        }\n        else {\n            this.packingUnitToStockUnitConversionFactorToTransfer.isDisabled = true;\n            this.packingUnitToStockUnitConversionFactorDestination.value = 1;\n            this.quantityToMove.scale = 0;\n        }\n        this.quantityToMove.value = null;\n        this.packingUnitToStockUnitConversionFactorToTransfer.value =\n            originalStockLine?.packingUnitToStockUnitConversionFactor ?? 1;\n        this.packingUnitToTransfer.value = originalStockLine?.packingUnit.code;\n        const conversionFactor = this.packingUnitToStockUnitConversionFactorToTransfer.value.toString();\n        const numberOfDec = conversionFactor.includes('.') ? conversionFactor.split('.')[1].length : 0;\n        this.packingUnitToStockUnitConversionFactorToTransfer.scale = numberOfDec;\n        this.packingUnitToStockUnitConversionFactorDestination.scale = numberOfDec;\n        if (this._packingUnits.length) {\n            this.packingUnitToTransfer.isDisabled = false;\n        }\n        _record.quantityInStockUnit = originalStockLine?.quantityInStockUnit;\n        _record.packingUnit.code = originalStockLine?.packingUnit.code;\n        _record.quantityInPackingUnit = originalStockLine?.quantityInPackingUnit;\n        if (_record.licensePlateNumberDestination) {\n            this.licensePlateNumberDestination.value = {\n                code: _record?.licensePlateNumberDestination,\n            };\n        }\n        else {\n            this.licensePlateNumberDestination.value = null;\n        }\n        if (_record?.locationDestination) {\n            this.locationDestination.value = { code: _record?.locationDestination };\n        }\n        else {\n            this.locationDestination.value = null;\n        }\n        if (typesLib.strictNe(this.statusDestination.options?.findIndex(line => typesLib.strictEq(line, _record?.statusDestination)), -1)) {\n            this.statusDestination.value = _record?.statusDestination;\n        }\n        this.packingUnitDestination.value = _record.packingUnit.code;\n        this.locationDestination.isReadOnly = typesLib.strictNe((_record?.licensePlateNumberDestination ?? ''), '');\n        if (typesLib.strictEq(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n            this.serialNumberLines.isHidden = false;\n            this.serialNumberLines.value = [];\n        }\n        else {\n            const lineIndex = this._stockChangeLines.findIndex(line => typesLib.strictEq(Number(line?.stockId), _stockId) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n            // this._stockChangeLines.splice(lineIndex, 1);\n            this._currentLine = this._stockChangeLines.length;\n            this._stockChangeLines.push({\n                product: this.product?.value?.code,\n                stockId: rowItem.stockId,\n                lineNumber: this._currentOperation,\n                quantityInPackingUnit: rowItem.quantityInPackingUnit,\n                packingUnit: _record.packingUnit?.code,\n                packingUnitToStockUnitConversionFactor: rowItem.packingUnitToStockUnitConversionFactor,\n                stockDetails: [\n                    {\n                        quantityInPackingUnit: rowItem.quantityInPackingUnit,\n                        quantityInStockUnit: rowItem.quantityInStockUnit,\n                    },\n                ],\n            });\n        }\n        this._activeSelectButton();\n        await this.$.commitValueAndPropertyChanges();\n        await this.stock.validateWithDetails();\n        this.$.detailPanel.isHidden = false;\n        this.stock.setRecordValue(_record);\n        this._saveStockChange();\n    }\n    async _fieldsManagement() {\n        this._lotManagement();\n        await this._miscellaneousFieldsManagement();\n        this._initPackingUnitFields();\n        this._serialNumberManagement();\n    }\n    async _onChangeBody() {\n        let _currentRecord = this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '');\n        const currentQty = typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value));\n        if (!_currentRecord || !currentQty || !this.startingSerialNumber.value) {\n            this.endingSerialNumber.value = null;\n            return;\n        }\n        this.startingSerialNumber.value.code = this.startingSerialNumber.value?.code?.toUpperCase();\n        if (typesLib.gt(currentQty, 1)) {\n            this.endingSerialNumber.value = this._calculateEndingSerialNumber(this.startingSerialNumber.value?.code ?? '', currentQty);\n        }\n        else {\n            this.endingSerialNumber.value = this.startingSerialNumber.value?.code ?? '';\n        }\n        if (typesLib.gt(currentQty, _currentRecord.quantityInPackingUnitOrigin))\n            this.addSerialRange.isHidden = true;\n        else {\n            this.addSerialRange.isHidden = false;\n        }\n        await this.$.commitValueAndPropertyChanges();\n        let validationResult;\n        if ((validationResult = await this.endingSerialNumber.validate())) {\n            this.$.showToast(validationResult, { type: 'warning' });\n        }\n    }\n    _lotManagement() {\n        const lotNotManaged = typesLib.strictEq(this._productSite.product.lotManagementMode, 'notManaged');\n        this.lot.isHidden = lotNotManaged;\n        this.sublot.isHidden = lotNotManaged;\n        this.sublot.isHidden = typesLib.strictNe(this._productSite.product.lotManagementMode, 'lotAndSublot');\n    }\n    _initPackingUnitFields() {\n        let productPackingList = (0, xtrem_client_1.extractEdges)(this._productSite.product.packingUnits.query).filter(productPacking => {\n            return !!productPacking.packingUnit?.code;\n        });\n        this._packingUnits = productPackingList.map(productPacking => {\n            return { node: productPacking };\n        });\n        let productPackingUnitSelectValues = productPackingList.map(productPacking => {\n            return `${productPacking.packingUnit.code}`;\n        });\n        this.packingUnitToTransfer.options = [\n            this._productSite.product.stockUnit.code,\n            ...productPackingUnitSelectValues,\n        ];\n        this.packingUnitToTransfer.value = this.packingUnitToTransfer.options[0];\n        this.packingUnitToStockUnitConversionFactorToTransfer.value = 1;\n        this.packingUnitToTransfer.value\n            ? (this.quantityToMove.scale = (0, get_unit_number_decimals_1.GetNumberOfDecimals)(this, this.packingUnitToTransfer.value))\n            : (this.quantityToMove.scale = 0);\n        this.packingUnit.options = [this._productSite.product.stockUnit.code, ...productPackingUnitSelectValues];\n        this.packingUnitDestination.options = [\n            this._productSite.product.stockUnit.code,\n            ...productPackingUnitSelectValues,\n        ];\n    }\n    async _miscellaneousFieldsManagement() {\n        if (!(this.lot.isHidden || !!this._productSite.product.lotSequenceNumber) &&\n            ['lotAndSublot', 'mandatoryLot'].includes(this._productSite.product.lotManagementMode)) {\n            this.lot.isMandatory = true;\n        }\n        this.licensePlateNumberDestination.isHidden = !this._productSite.isLicensePlateNumberManaged;\n        const transaction = this._getSavedInputs().selectedTransaction;\n        this.statusDestination.isHidden = !transaction.isStatusChange;\n        this.packingUnitDestination.isHidden = !transaction.isUnitChange;\n        this.packingUnitToStockUnitConversionFactorDestination.isHidden = !transaction.isUnitChange;\n        this._selectedStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(this._stockSite.code, this._productSite.product.productCategory.code, '27', transaction.stockMovementCode?.code ?? '', this);\n        this.status.options = await this._getStockStatus();\n        this._selectedStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(this._siteDestination?.code ?? '', this._productSite.product.productCategory.code, '28', transaction.stockMovementCode?.code ?? '', this);\n        this.statusDestination.options = await this._getStockStatus();\n    }\n    _serialNumberManagement() {\n        this.serialNumber.isHidden = ['notManaged', 'issued'].includes(this._productSite.product.serialNumberManagementMode);\n        if (['receivedIssued', 'globalReceivedIssued'].includes(this._productSite.product.serialNumberManagementMode)) {\n            this.serialNumber.isMandatory = true;\n            if (typesLib.strictEq(this.lot.isHidden, false))\n                this.lot.isMandatory = false;\n            if (typesLib.strictEq(this.sublot.isHidden, false))\n                this.sublot.isMandatory = false;\n            if (typesLib.strictEq(this.status.isHidden, false))\n                this.status.isMandatory = false;\n            if (typesLib.strictEq(this.packingUnit.isHidden, false))\n                this.packingUnit.isMandatory = false;\n            if (typesLib.strictEq(this.packingUnitDestination.isHidden, false))\n                this.packingUnitDestination.isHidden = true;\n            if (typesLib.strictEq(this.packingUnitToStockUnitConversionFactorDestination.isHidden, false))\n                this.packingUnitToStockUnitConversionFactorDestination.isHidden = true;\n        }\n    }\n    /*\n     *\n     *  record management functions\n     *\n     */\n    _saveDetail() {\n        let currentStockChangeLines = this._stockChangeLines[this._currentLine];\n        this._stockChangeLines[this._currentLine] = {\n            ...currentStockChangeLines,\n        };\n        this._saveStockChange();\n    }\n    _saveStockChange() {\n        const savedInputs = this._getSavedInputs();\n        savedInputs.intersiteTransfer.stockChangeLines = this._stockChangeLines;\n        savedInputs.currentLine = this._currentLine;\n        this.$.storage.set('mobile-intersiteTransfer', JSON.stringify(savedInputs));\n    }\n    _getQuantityInPackingUnitOrigin(record) {\n        if (record.quantityInPackingUnitOrigin) {\n            return record.quantityInPackingUnitOrigin;\n        }\n        else {\n            if (typesLib.strictEq(this._stockChangeLines, undefined)) {\n                this._stockChangeLines = this._getSavedInputs().intersiteTransfer?.stockChangeLines ?? [];\n            }\n            let _quantityInPackingUnitOrigin = Number(record.quantityInPackingUnit);\n            this._stockChangeLines?.forEach(line => {\n                if (typesLib.strictEq(Number(line.stockId), Number(record.stockId)) && typesLib.strictNe(line.lineNumber, this._currentOperation)) {\n                    _quantityInPackingUnitOrigin = typesLib.sub(Number(_quantityInPackingUnitOrigin), Number(line.quantityInPackingUnitDestination));\n                }\n            });\n            return _quantityInPackingUnitOrigin;\n        }\n    }\n    _getquantityInPackingUnitRest(record) {\n        if (typesLib.strictEq(this._stockChangeLines, undefined)) {\n            this._stockChangeLines = this._getSavedInputs().intersiteTransfer?.stockChangeLines ?? [];\n        }\n        if (typesLib.strictEq(this._serialNumberManagementMode, undefined)) {\n            this._serialNumberManagementMode = this._getSavedInputs().selectedProduct?.serialNumberManagementMode;\n        }\n        let _quantityInPackingUnitRest = this._getQuantityInPackingUnitOrigin(record);\n        if (typesLib.strictEq(this._serialNumberManagementMode, 'globalReceivedIssued')) {\n            this._stockChangeLines?.forEach(line => {\n                if (typesLib.strictEq(Number(line.stockId), Number(record.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation)) {\n                    _quantityInPackingUnitRest = typesLib.sub(Number(_quantityInPackingUnitRest), Number(line.quantityInPackingUnitDestination));\n                }\n            });\n        }\n        return _quantityInPackingUnitRest;\n    }\n    _getStockChangeLine(record) {\n        if (typesLib.strictEq(this._stockChangeLines, undefined)) {\n            this._stockChangeLines = this._getSavedInputs().intersiteTransfer?.stockChangeLines ?? [];\n        }\n        return this._stockChangeLines?.find(line => typesLib.strictEq(Number(line.stockId), Number(record.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n    }\n    _getQuantityToMove(record) {\n        const line = this._getStockChangeLine(record);\n        let _quantityToMove;\n        if (line) {\n            _quantityToMove = typesLib.div((typesLib.mul(Number(line.quantityInPackingUnitDestination), Number(line.packingUnitToStockUnitConversionFactorDestination))), Number(record.packingUnitToStockUnitConversionFactor));\n        }\n        else {\n            _quantityToMove = Number(record.quantityInPackingUnit);\n        }\n        const _quantityInPackingUnitRest = this._getquantityInPackingUnitRest(record);\n        if (typesLib.gt(Number(_quantityToMove), Number(_quantityInPackingUnitRest))) {\n            _quantityToMove = Number(_quantityInPackingUnitRest);\n        }\n        return _quantityToMove;\n    }\n    _getLicensePlateNumberDestination(record) {\n        const line = this._getStockChangeLine(record);\n        if (line) {\n            return line.licensePlateNumberDestination;\n        }\n        else {\n            return '';\n        }\n    }\n    _getLocationDestination(record) {\n        const line = this._getStockChangeLine(record);\n        if (line) {\n            return line.locationDestination;\n        }\n        else {\n            if (typesLib.strictNe(record.licensePlateNumberDestination, '')) {\n                return record.licensePlateNumberDestination?.location?.code;\n            }\n            else {\n                return '';\n            }\n        }\n    }\n    _getPackingUnitToStockUnitConversionFactorDestination(record) {\n        const line = this._getStockChangeLine(record);\n        if (line) {\n            return Number(line.packingUnitToStockUnitConversionFactorDestination);\n        }\n        else {\n            return Number(record.packingUnitToStockUnitConversionFactor);\n        }\n    }\n    _getPackingUnitDestination(record) {\n        const line = this._getStockChangeLine(record);\n        if (line) {\n            return { code: line.packingUnitDestination };\n        }\n        else {\n            return undefined;\n        }\n    }\n    _getStatusDestination(record) {\n        const line = this._getStockChangeLine(record);\n        if (line) {\n            return line.statusDestination;\n        }\n        else {\n            return '';\n        }\n    }\n    _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n        return startingSerialNumber.replace(/\\d+$/, match => {\n            const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n            const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n            return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n        });\n    }\n    async _getStockStatus() {\n        const selectedStatus = [];\n        this._selectedStockManagementRules.authorizedSubstatus.split(',').forEach(function (status) {\n            selectedStatus.push({ _regex: (0, pat_converter_1.getRegExp)(status).source });\n        });\n        const response = await this.$.graph\n            .node('@sage/x3-stock-data/StockStatus')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n        }, {\n            filter: {\n                code: { _or: selectedStatus },\n            },\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/pages__mobile_stock_change_details__notification__invalid_stock_status_error', 'No stock status'));\n        }\n        return response.edges.map((stockStatus) => stockStatus.node.code);\n    }\n};\nexports.MobileIntersiteTransferDetails = MobileIntersiteTransferDetails;\n__decorate([\n    ui.decorators.referenceField({\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        isTransient: false,\n        isTitleHidden: true,\n        isDisabled: true,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.select({\n                bind: 'lotManagementMode',\n                optionType: '@sage/x3-master-data/LotManagementMode',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'serialNumberManagementMode',\n                optionType: '@sage/x3-master-data/SerialNumberManagement',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'expirationManagementMode',\n                optionType: '@sage/x3-master-data/ExpirationManagement',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'stockVersionMode',\n                optionType: '@sage/x3-stock-data/StockVersionMode',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                bind: 'stockUnit',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                bind: 'stockUnit',\n                valueField: 'numberOfDecimals',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileIntersiteTransferDetails.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        bind: 'isLocationManaged',\n        isTransient: false,\n        isHidden: true,\n    })\n], MobileIntersiteTransferDetails.prototype, \"isLocationManaged\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        bind: 'isLicensePlateNumberManaged',\n        isTransient: false,\n        isHidden: true,\n    })\n], MobileIntersiteTransferDetails.prototype, \"isLicensePlateNumberManaged\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n        size: 'small',\n    })\n], MobileIntersiteTransferDetails.prototype, \"localizedDescription\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n        prefix: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__site____prefix\", \"Site \"),\n    })\n], MobileIntersiteTransferDetails.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__nextButton____title\", \"Next\"),\n        shortcut: ['f2'],\n        buttonType: 'primary',\n        async onClick() {\n            if (typesLib.gt(this.stock.selectedRecords.length, 0)) {\n                await this.$.commitValueAndPropertyChanges();\n                this.$.setPageClean();\n                const savedInputs = this._getSavedInputs();\n                savedInputs.currentLine = this._currentLine;\n                this.$.storage.set('mobile-intersiteTransfer', JSON.stringify(savedInputs));\n                this.$.router.goTo('@sage/x3-stock/MobileIntersiteTransfer', { ReturnFromDetail: 'yes' });\n            }\n            else {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_stock_change_lines__mobile_stock_error', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_stock_change_lines__notification__no_stock_error', `Select at least one stock line.`));\n            }\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__helperCancelButton____title\", \"Cancel\"),\n        buttonType: 'secondary',\n        async onClick() {\n            const recordId = this.gridBlock?.selectedRecordId ?? '';\n            if (recordId) {\n                const currentRecord = this.stock.getRecordValue(recordId);\n                if (currentRecord) {\n                    let i = 0;\n                    while (typesLib.lt(i, this._stockChangeLines.length)) {\n                        if (typesLib.strictEq(Number(this._stockChangeLines[i].stockId), Number(currentRecord.stockId)) && typesLib.strictEq(Number(this._stockChangeLines[i].lineNumber), Number(this._currentOperation))) {\n                            this._stockChangeLines.splice(i, 1);\n                        }\n                        else {\n                            i = typesLib.add(i, 1);\n                        }\n                    }\n                    this._saveStockChange();\n                    const originalStockLine = this._originalStockLines.find(line => typesLib.strictEq(currentRecord?._id, line.id));\n                    currentRecord.quantityToMove = originalStockLine?.quantityInPackingUnit;\n                    currentRecord.packingUnit = originalStockLine?.packingUnit;\n                    currentRecord.quantityInStockUnit = originalStockLine?.quantityInStockUnit;\n                    this.packingUnitToTransfer.value = null;\n                    this.stock.unselectRecord(recordId);\n                    this.stock.setRecordValue(currentRecord);\n                    this.$.detailPanel.isHidden = true;\n                    this.nextButton.isHidden = false;\n                }\n            }\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"helperCancelButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__helperSelectButton____title\", \"Select\"),\n        buttonType: 'primary',\n        onError(error) {\n            switch (error.message) {\n                case '@sage/x3-stock/pages__mobile_stock_change_lines__notification__error_startingSerialNumberMandatory': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_stock_change_lines__notification__error_startingSerialNumberMandatory', 'You need to select the serial number and add it first.');\n                }\n                default: {\n                    return error;\n                }\n            }\n        },\n        async onClick() {\n            await this.$.commitValueAndPropertyChanges();\n            const errors = await this.stock.validateWithDetails();\n            if (typesLib.strictEq(errors.length, 0)) {\n                const _recordId = this.gridBlock?.selectedRecordId;\n                let _currentRecord = this.stock.getRecordValue(_recordId ?? '');\n                if (_currentRecord) {\n                    if (typesLib.strictEq(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                        if (typesLib.strictEq(this.serialNumberLines.value.length, 0)) {\n                            throw new Error('@sage/x3-stock/pages__mobile_stock_change_lines__notification__error_startingSerialNumberMandatory');\n                        }\n                    }\n                    else {\n                        if (typesLib.lte(Number(this.quantityToMove.value), 0)) {\n                            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_stock_change_lines__mobile_stock_error', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_stock_change_lines__quantityInPackingUnitDestination_must_be_greater_than_0', 'The quantity to move must be greater than 0.'));\n                            this.$.setPageClean();\n                            return;\n                        }\n                        if (!this.locationDestination.value) {\n                            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_intersite_transfer_lines__mobile_stock_error', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_intersite_transfer_lines__destination_location_is_mandatory', 'The destination location is mandatory.'));\n                            this.$.setPageClean();\n                            return;\n                        }\n                    }\n                    if (_currentRecord.qualityAnalysisRequestId) {\n                        await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_intersite_transfer_lines__mobile_stock_error', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_intersite_transfer_lines__intersite_transfer_is_impossible_on_a_line_in_quality_control', 'Intersite transfer is impossible on a line in quality control.'));\n                        this.$.setPageClean();\n                        return;\n                    }\n                    if (typesLib.gt(typesLib.mul((this.quantityToMove.value ? Number(this.quantityToMove.value) : 0), (this.packingUnitToStockUnitConversionFactorToTransfer.value\n                        ? Number(this.packingUnitToStockUnitConversionFactorToTransfer.value)\n                        : 1)), Number(typesLib.sub(_currentRecord.quantityInStockUnit, _currentRecord.allocatedQuantity)))) {\n                        await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_stock_change_lines__mobile_stock_error', 'Error'), `${ui.localize('@sage/x3-stock/pages__stock_change_lines__enter_a_quantity_less_than_or_equal_to_the_stock_quantity_minus_allocated_quantity', 'Enter a quantity less than or equal to the stock quantity minus the allocated quantity.')}`);\n                        this.quantityToMove.value = null;\n                        return;\n                    }\n                    if (_recordId && _currentRecord) {\n                        this.stock.selectRecord(_recordId);\n                        const lineIndex = this._stockChangeLines.findIndex(line => typesLib.strictEq(Number(line.stockId), Number(_currentRecord.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n                        if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                            if (typesLib.gt(lineIndex, -1)) {\n                                this._stockChangeLines[lineIndex].packingUnitDestination = this.packingUnitDestination\n                                    .value\n                                    ? this.packingUnitDestination.value\n                                    : this._stockChangeLines[lineIndex].packingUnit;\n                                this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactorDestination =\n                                    this.packingUnitToStockUnitConversionFactorDestination.value\n                                        ? Number(this.packingUnitToStockUnitConversionFactorDestination.value)\n                                        : this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactor;\n                                this._stockChangeLines[lineIndex].packingUnit = this.packingUnitToTransfer.value\n                                    ? this.packingUnitToTransfer.value\n                                    : _currentRecord.packingUnit.code;\n                                this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactor = Number(this.packingUnitToStockUnitConversionFactorToTransfer.value);\n                                this._stockChangeLines[lineIndex].quantityInPackingUnit = Number(this.quantityToMove.value);\n                                const _stockDetails = this._stockChangeLines[lineIndex]?.stockDetails;\n                                if (_stockDetails) {\n                                    const _stockJournal = _stockDetails[0];\n                                    _stockJournal.quantityInPackingUnit = typesLib.div((typesLib.mul(Number(this.quantityToMove.value), (this.packingUnitToStockUnitConversionFactorToTransfer.value\n                                        ? this.packingUnitToStockUnitConversionFactorToTransfer.value\n                                        : 0))), (this.packingUnitToStockUnitConversionFactorDestination.value\n                                        ? this.packingUnitToStockUnitConversionFactorDestination.value\n                                        : (_currentRecord.packingUnitToStockUnitConversionFactor ?? 1)));\n                                    _stockJournal.quantityInStockUnit = typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value));\n                                    if (this.locationDestination.value) {\n                                        _stockJournal.location = this.locationDestination.value.code;\n                                    }\n                                    else {\n                                        _stockJournal.location = _currentRecord.location?.code;\n                                    }\n                                    if (this.statusDestination.value) {\n                                        _stockJournal.status = this.statusDestination.value;\n                                    }\n                                    else {\n                                        _stockJournal.status = _currentRecord.status?.code;\n                                    }\n                                    if (this.packingUnitDestination.value) {\n                                        _stockJournal.packingUnit = this.packingUnitDestination.value;\n                                    }\n                                    else {\n                                        _stockJournal.packingUnit = _currentRecord?.packingUnit?.code;\n                                    }\n                                    _stockJournal.packingUnitToStockUnitConversionFactor = Number(this.packingUnitToStockUnitConversionFactorDestination.value);\n                                    _stockJournal.serialNumber = _currentRecord?.serialNumber ?? undefined;\n                                    _stockJournal.identifier1 = _currentRecord?.identifier1 ?? undefined;\n                                    _stockJournal.identifier2 = _currentRecord?.identifier2 ?? undefined;\n                                    _stockJournal.licensePlateNumber = this.licensePlateNumberDestination.value?.code;\n                                    _stockJournal.stockUnit = this.product.value?.stockUnit?.code;\n                                }\n                            }\n                            else {\n                                this._stockChangeLines[this._currentLine] = {\n                                    product: this.product.value?.code,\n                                    stockId: String(_currentRecord.stockId),\n                                    productDescription: this.product.value?.description1,\n                                    quantityInPackingUnit: Number(this.quantityToMove.value),\n                                    packingUnit: this.packingUnitToTransfer.value\n                                        ? this.packingUnitToTransfer.value\n                                        : _currentRecord.packingUnit.code,\n                                    packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorToTransfer.value),\n                                    lineNumber: this._currentOperation,\n                                    packingUnitDestination: this.packingUnitDestination.value\n                                        ? this.packingUnitDestination.value\n                                        : _currentRecord.packingUnit?.code,\n                                    stockDetails: [\n                                        {\n                                            packingUnit: _currentRecord.packingUnit?.code,\n                                            packingUnitToStockUnitConversionFactor: _currentRecord.packingUnitToStockUnitConversionFactor,\n                                            quantityInPackingUnit: Number(this.quantityToMove.value),\n                                            quantityInStockUnit: typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value)),\n                                            location: this.locationDestination.value\n                                                ? this.locationDestination.value.code\n                                                : _currentRecord.location?.code,\n                                            status: this.statusDestination.value\n                                                ? this.statusDestination.value\n                                                : _currentRecord.status?.code,\n                                            serialNumber: _currentRecord.serialNumber ?? undefined,\n                                            identifier1: _currentRecord.identifier1 ?? undefined,\n                                            identifier2: _currentRecord.identifier2 ?? undefined,\n                                            licensePlateNumber: this.licensePlateNumberDestination.value?.code,\n                                            stockUnit: this.product.value?.stockUnit?.code,\n                                        },\n                                    ],\n                                };\n                            }\n                        }\n                        let qtyTotalInPackingUnit = 0;\n                        let qtyTotalInStockUnit = 0;\n                        this._stockChangeLines.forEach(line => {\n                            if (typesLib.strictEq(Number(line.stockId), Number(_currentRecord.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation)) {\n                                line.stockDetails?.forEach(stockLine => {\n                                    qtyTotalInStockUnit = typesLib.add(qtyTotalInStockUnit, Number(stockLine.quantityInStockUnit));\n                                    qtyTotalInPackingUnit = typesLib.add(qtyTotalInPackingUnit, typesLib.div((typesLib.mul(Number(Number(stockLine.quantityInPackingUnit)), Number(stockLine.packingUnitToStockUnitConversionFactor))), Number(line.packingUnitToStockUnitConversionFactor)));\n                                });\n                            }\n                        });\n                        this._stockChangeLines[lineIndex].quantityInPackingUnitDestination = typesLib.div((typesLib.mul(Number(qtyTotalInPackingUnit), Number(this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactor))), Number(this.packingUnitToStockUnitConversionFactorDestination.value));\n                        this._stockChangeLines[lineIndex].quantityInStockUnitDestination = typesLib.mul(Number(qtyTotalInPackingUnit), Number(this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactor));\n                        this._stockChangeLines[lineIndex].quantityInPackingUnit = Number(qtyTotalInPackingUnit);\n                        this._saveDetail();\n                        const originalStockLine = this._originalStockLines?.find(line => typesLib.strictEq(this.gridBlock.selectedRecordId, line.id));\n                        _currentRecord.quantityToMove = this.quantityToMove.value;\n                        _currentRecord.quantityInPackingUnit = originalStockLine?.quantityInPackingUnit;\n                        _currentRecord.quantityInStockUnit = qtyTotalInStockUnit;\n                        const packingUnitIndex = this._packingUnits\n                            .map(packingUnit => packingUnit.node.packingUnit.code)\n                            .indexOf(this.packingUnitToTransfer.value ?? '');\n                        if (typesLib.strictNe(packingUnitIndex, -1)) {\n                            const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                            _currentRecord.packingUnit = selectedUnit.packingUnit;\n                            _currentRecord.quantityToMove = Number(typesLib.div(qtyTotalInStockUnit, Number(selectedUnit.packingUnitToStockUnitConversionFactor)));\n                        }\n                        else {\n                            _currentRecord.packingUnit.code = this.packingUnitToTransfer.value;\n                        }\n                        _currentRecord.quantityInStockUnitDestination = typesLib.mul(qtyTotalInPackingUnit, Number(_currentRecord.packingUnitToStockUnitConversionFactor));\n                        _currentRecord.locationDestination = this.locationDestination.value\n                            ? this.locationDestination.value\n                            : _currentRecord?.location;\n                        _currentRecord.licensePlateNumberDestination =\n                            this.licensePlateNumberDestination.value;\n                        _currentRecord.statusDestination = this.statusDestination.value\n                            ? this.statusDestination.value\n                            : _currentRecord?.status;\n                        _currentRecord.packingUnitDestination =\n                            typesLib.strictNe(this.packingUnitDestination.value, '') ? { code: this.packingUnitDestination.value }\n                                : null;\n                        _currentRecord.packingUnitToStockUnitConversionFactorDestination =\n                            this.packingUnitToStockUnitConversionFactorDestination.value;\n                        this.stock.setRecordValue(_currentRecord);\n                    }\n                }\n            }\n            this.$.detailPanel.isHidden = true;\n            this.nextButton.isHidden = false;\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"helperSelectButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        icon: 'add',\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__addSerialRange____title\", \"Add...\"),\n        onError(error) {\n            switch (error.message) {\n                case '@sage/x3-stock/pages__mobile_stock_change_lines__notification__error_startingSerialNumber': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_stock_change_lines__notification__error_startingSerialNumber', 'The serial number is mandatory');\n                }\n                case '@sage/x3-stock/serial-number-range-overlap': {\n                    return ui.localize('@sage/x3-stock/serial-number-range-overlap', 'The serial numbers are overlapping. Enter another starting or ending serial number.');\n                }\n                case '@sage/x3-stock/pages__mobile_stock_change__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_stock_change__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move', 'Select the same amount of serial numbers in the range to match the quantity to move.');\n                }\n                case '@sage/x3-stock/serial-number-not-sequential': {\n                    return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n                }\n                default: {\n                    return error;\n                }\n            }\n        },\n        buttonType: 'secondary',\n        async onClick() {\n            if (!this.startingSerialNumber.value) {\n                throw new Error('@sage/x3-stock/pages__mobile_stock_change_lines__notification__error_startingSerialNumber');\n            }\n            if (!this.locationDestination.value) {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_intersite_transfer_lines__mobile_stock_error', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_intersite_transfer_lines__destination_location_is_mandatory', 'The destination location is mandatory.'));\n                this.$.setPageClean();\n                return;\n            }\n            // check that this will add any duplicates\n            const startNumberToAdd = this.startingSerialNumber?.value?.code?.match(/\\d+$/);\n            const endNumberToAdd = Number(this.endingSerialNumber?.value?.match(/\\d+$/));\n            let serialNumberAlreadyUsed = false;\n            if (this.serialNumberLines.value.some(row => {\n                const rowStartMatch = row.startingSerialNumber.match(/\\d+$/);\n                const rowEndMatch = Number(row.endingSerialNumber.match(/\\d+$/));\n                // check if the 'beginning part' of the serial matches\n                if (!startNumberToAdd || typesLib.strictNe(row.startingSerialNumber.substring(0, typesLib.sub(row.startingSerialNumber.length, rowStartMatch.toString().length)), this.startingSerialNumber?.value?.code?.substring(0, typesLib.sub(this.startingSerialNumber.value.code.length, startNumberToAdd.toString().length))))\n                    return false;\n                return typesLib.lte(Number(startNumberToAdd), rowEndMatch) && typesLib.gte(endNumberToAdd, Number(rowStartMatch));\n            })) {\n                serialNumberAlreadyUsed = true;\n            }\n            this._stockChangeLines.forEach(line => {\n                if (typesLib.strictEq(line.product, this.product?.value?.code) && line.serialNumber) {\n                    const startingSerialNumber = Number(line.serialNumber.match(/\\d+$/));\n                    const endingSerialNumber = Number(this._calculateEndingSerialNumber(line.serialNumber, typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value))).match(/\\d+$/));\n                    if (typesLib.lte(Number(startNumberToAdd), endingSerialNumber) && typesLib.gte(Number(endNumberToAdd), startingSerialNumber)) {\n                        serialNumberAlreadyUsed = true;\n                    }\n                }\n            });\n            if (serialNumberAlreadyUsed) {\n                throw new Error('@sage/x3-stock/serial-number-range-overlap');\n            }\n            if (typesLib.ne(this.endingSerialNumber.value, this._calculateEndingSerialNumber(this.startingSerialNumber?.value?.code ?? '', typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value))))) {\n                throw new Error('@sage/x3-stock/pages__mobile_stock_change__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move');\n            }\n            if (typesLib.strictNe((await (0, get_count_serial_number_1.getCountSerialNumber)(this, this.product.value?.code ?? '', this._stockSite.code, this._stockId.value ?? '', this.startingSerialNumber.value?.code ?? '', this.endingSerialNumber.value ?? '', '')), typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value)))) {\n                throw new Error('@sage/x3-stock/serial-number-not-sequential');\n            }\n            const _currentRecord = this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '');\n            if (_currentRecord) {\n                this.serialNumberLines.addRecord({\n                    quantity: typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value)),\n                    startingSerialNumber: this.startingSerialNumber.value.code,\n                    endingSerialNumber: this.endingSerialNumber.value,\n                });\n                const lineIndex = this._stockChangeLines.findIndex(line => typesLib.strictEq(Number(line?.stockId), Number(_currentRecord.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n                if (typesLib.gt(lineIndex, -1)) {\n                    this._currentLine = lineIndex;\n                    this._stockChangeLines[this._currentLine] = {\n                        ...this._stockChangeLines[this._currentLine],\n                        packingUnitDestination: this.packingUnitDestination.value\n                            ? this.packingUnitDestination.value\n                            : _currentRecord.packingUnit?.code,\n                        packingUnitToStockUnitConversionFactorDestination: this\n                            .packingUnitToStockUnitConversionFactorDestination.value\n                            ? Number(this.packingUnitToStockUnitConversionFactorDestination.value)\n                            : _currentRecord.packingUnitToStockUnitConversionFactor,\n                    };\n                    this._stockChangeLines[this._currentLine].stockDetails?.push({\n                        packingUnit: this.packingUnitDestination.value\n                            ? this.packingUnitDestination.value\n                            : _currentRecord.packingUnit?.code,\n                        packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorDestination.value),\n                        quantityInPackingUnit: Number(typesLib.div((typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value))), Number(this.packingUnitToStockUnitConversionFactorDestination.value))),\n                        quantityInStockUnit: typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value)),\n                        location: this.locationDestination.value\n                            ? this.locationDestination.value.code\n                            : _currentRecord.location?.code,\n                        status: this.statusDestination.value\n                            ? this.statusDestination.value\n                            : _currentRecord.status?.code,\n                        serialNumber: this.startingSerialNumber.value.code,\n                        endingSerialNumber: this.endingSerialNumber.value,\n                        identifier1: _currentRecord.identifier1 ?? undefined,\n                        identifier2: _currentRecord.identifier2 ?? undefined,\n                        licensePlateNumber: this.licensePlateNumberDestination.value?.code,\n                        stockUnit: this._productSite.product?.stockUnit?.code,\n                    });\n                }\n                else {\n                    this._stockChangeLines.push({\n                        product: this.product?.value?.code,\n                        stockId: String(_currentRecord.stockId),\n                        productDescription: this.product?.value?.description1,\n                        quantityInPackingUnit: Number(this.quantityToMove.value),\n                        packingUnit: this.packingUnitToTransfer.value\n                            ? this.packingUnitToTransfer.value\n                            : _currentRecord?.packingUnit?.code,\n                        packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorToTransfer.value),\n                        packingUnitToStockUnitConversionFactorDestination: this\n                            .packingUnitToStockUnitConversionFactorDestination.value\n                            ? Number(this.packingUnitToStockUnitConversionFactorDestination.value)\n                            : _currentRecord.packingUnitToStockUnitConversionFactor,\n                        lineNumber: this._currentOperation,\n                        packingUnitDestination: this.packingUnitDestination.value\n                            ? this.packingUnitDestination.value\n                            : _currentRecord.packingUnit?.code,\n                        stockDetails: [\n                            {\n                                packingUnit: this.packingUnitDestination.value\n                                    ? this.packingUnitDestination.value\n                                    : _currentRecord.packingUnit?.code,\n                                packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorDestination.value),\n                                quantityInPackingUnit: typesLib.div((typesLib.mul(Number(this.quantityToMove.value), (this.packingUnitToStockUnitConversionFactorToTransfer.value\n                                    ? this.packingUnitToStockUnitConversionFactorToTransfer.value\n                                    : 0))), (Number(_currentRecord.packingUnitToStockUnitConversionFactor)\n                                    ? Number(_currentRecord.packingUnitToStockUnitConversionFactor)\n                                    : 1)),\n                                quantityInStockUnit: typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value)),\n                                location: this.locationDestination.value\n                                    ? this.locationDestination.value.code\n                                    : _currentRecord.location?.code,\n                                status: this.statusDestination.value\n                                    ? this.statusDestination.value\n                                    : _currentRecord.status?.code,\n                                serialNumber: this.startingSerialNumber.value?.code,\n                                endingSerialNumber: this.endingSerialNumber?.value,\n                                identifier1: _currentRecord.identifier1 ?? undefined,\n                                identifier2: _currentRecord.identifier2 ?? undefined,\n                                licensePlateNumber: this.licensePlateNumberDestination.value?.code,\n                                stockUnit: this._productSite.product?.stockUnit?.code,\n                            },\n                        ],\n                    });\n                }\n                let qtyTotalInPackingUnit = 0;\n                let qtyTotalInStockUnit = 0;\n                this._stockChangeLines.forEach(line => {\n                    if (typesLib.strictEq(Number(line.stockId), Number(_currentRecord.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation)) {\n                        line.stockDetails?.forEach(stockLine => {\n                            qtyTotalInStockUnit = typesLib.add(qtyTotalInStockUnit, Number(stockLine.quantityInStockUnit));\n                            qtyTotalInPackingUnit = typesLib.add(qtyTotalInPackingUnit, typesLib.div((typesLib.mul(Number(Number(stockLine.quantityInPackingUnit)), Number(stockLine.packingUnitToStockUnitConversionFactor))), Number(line.packingUnitToStockUnitConversionFactor)));\n                        });\n                        line.quantityInPackingUnit = qtyTotalInPackingUnit;\n                    }\n                });\n                this._saveDetail();\n                this.stock.setRecordValue(_currentRecord);\n                this.startingSerialNumber.value = null;\n                this.endingSerialNumber.value = null;\n                await this.$.commitValueAndPropertyChanges();\n            }\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"addSerialRange\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileIntersiteTransferDetails.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.section({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__detailPanelSection____title\", \"Stock change\"),\n        isTitleHidden: true,\n    })\n], MobileIntersiteTransferDetails.prototype, \"detailPanelSection\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileIntersiteTransferDetails.prototype, \"sectionHeader\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"bodyBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"detailsBlock\", void 0);\n__decorate([\n    ui.decorators.gridRowBlock({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n        boundTo() {\n            return this.stock;\n        },\n        fieldFilter(columnId) {\n            return false;\n        },\n        readOnlyOverride(columnId) {\n            return undefined;\n            // if undefined is returned, the original readOnly property is used from the column definition\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"gridBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"quantityBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"serialNumberBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"destinationBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"listSerialNumberBlock\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__licensePlateNumber____title\", \"License plate number\"),\n        valueField: 'code',\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                _and: [{ status: 'inStock' }, { stockSite: { code: this._stockSite.code } }],\n            };\n        },\n        async onChange() {\n            if (this.licensePlateNumber.value?.location) {\n                this.location.value = this.licensePlateNumber.value.location;\n            }\n            if (!this.licensePlateNumber.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    licensePlateNumber: undefined,\n                };\n                if (!this.licensePlateNumber.isHidden) {\n                    this.licensePlateNumber.value = null;\n                }\n                return;\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                licensePlateNumber: { code: this.licensePlateNumber.value.code },\n            };\n            this.licensePlateNumber.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n            }),\n        ],\n    })\n], MobileIntersiteTransferDetails.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__location____title\", \"Location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: false,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__location____placeholder\", \"Scan or select\\u2026\"),\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        isTransient: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            const locationFilter = {\n                stockSite: { code: this._stockSite.code },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n            return locationFilter;\n        },\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.location);\n            if (this.location.value) {\n                this.location.getNextField(true)?.focus();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__location____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__location____columns__title__type\", \"Type\"),\n            }),\n        ],\n    })\n], MobileIntersiteTransferDetails.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__lot____title\", \"Lot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__lot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LotsSites',\n        valueField: 'lot',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code ?? '' },\n                storageSite: { code: this.site.value ?? '' },\n            };\n        },\n        async onChange() {\n            if (!this.lot.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    lot: undefined,\n                    ...(typesLib.strictEq(this.product.value?.lotManagementMode, 'lotAndSublot') && { sublot: undefined }),\n                };\n                if (!this.sublot.isHidden) {\n                    this.sublot.value = null;\n                }\n                return;\n            }\n            if (!this.sublot.isHidden) {\n                this.sublot.value = this.lot.value; // update sublot field if available, for display purposes only\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                lot: this.lot.value.lot,\n                ...(this.lot.value?.sublot && { sublot: this.lot.value.sublot }),\n            };\n            this.lot.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__lot____columns__title__lot\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__lot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileIntersiteTransferDetails.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__sublot____title\", \"Sublot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__sublot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LotsSites',\n        valueField: 'sublot',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code ?? '' },\n                storageSite: { code: this.site.value ?? '' },\n            };\n        },\n        async onChange() {\n            if (!this.sublot.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    lot: undefined,\n                    sublot: undefined,\n                };\n                if (!this.lot.isHidden) {\n                    this.lot.value = null;\n                }\n                return;\n            }\n            if (!this.lot.isHidden) {\n                this.lot.value = this.sublot.value;\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                lot: this.sublot.value.lot,\n                sublot: this.sublot.value.sublot,\n            };\n            this.sublot.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__sublot____columns__title__lot\", \"Lot\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__sublot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileIntersiteTransferDetails.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__serialNumber____title\", \"Serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__serialNumber____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code ?? '' },\n                stockSite: { code: this.site.value ?? '' },\n                issueDocumentId: '',\n            };\n        },\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.serialNumber, this.serialNumber.value?.code);\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__serialNumber____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileIntersiteTransferDetails.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__status____title\", \"Status\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__status____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.status, this.status.value);\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnit____title\", \"Unit\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnit____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.packingUnit, this.packingUnit.value);\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"packingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnitToStockUnitConversionFactor____title\", \"Conversion factor\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnitToStockUnitConversionFactor____placeholder\", \"Scan...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        min: 0,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.packingUnitToStockUnitConversionFactor);\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"packingUnitToStockUnitConversionFactor\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__identifier1____title\", \"Identifier 1\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__identifier1____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.identifier1);\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__identifier2____title\", \"Identifier 2\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__identifier2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.identifier2);\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"identifier2\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockCustomField1____title\", \"Stock custom field 1\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockCustomField1____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.stockCustomField1);\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"stockCustomField1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockCustomField2____title\", \"Stock custom field 2\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockCustomField2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.stockCustomField2);\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"stockCustomField2\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.bodyBlock;\n        },\n        node: '@sage/x3-stock-data/Stock',\n        isChangeIndicatorDisabled: false,\n        canFilter: false,\n        canSelect: true,\n        canExport: false,\n        canResizeColumns: false,\n        canUserHideColumns: false,\n        isTitleHidden: false,\n        isTransient: false,\n        isFullWidth: true,\n        isDisabled: false,\n        hasSearchBoxMobile: false,\n        cardView: true,\n        displayMode: ui.fields.TableDisplayMode.compact,\n        mobileCard: undefined,\n        orderBy: {\n            stockSite: 1,\n            stockId: 1,\n        },\n        filter() {\n            return {\n                ...(0, manage_pages_1.generateStockTableFilter)(this),\n                location: { category: { _nin: ['subcontract', 'customer'] } },\n            };\n        },\n        columns: [\n            ui.nestedFields.numeric({\n                bind: 'quantityToMove',\n                isReadOnly: true,\n                isHidden: false, // special field that always gets displayed\n                isTransient: true,\n                postfix(value, rowValue) {\n                    const currentRecord = this.gridBlock?.selectedRecordId\n                        ? this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '')\n                        : undefined;\n                    if (currentRecord && typesLib.strictEq(rowValue?.stockId, currentRecord.stockId)) {\n                        if (this.packingUnitToTransfer.value) {\n                            return ` ${String(this.packingUnitToTransfer.value)}`;\n                        }\n                        else {\n                            return ` ${String(currentRecord.packingUnit.code ?? rowValue?.packingUnit?.code ?? '')}`;\n                        }\n                    }\n                    else {\n                        return ` ${String(rowValue?.packingUnit?.code)}`;\n                    }\n                },\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stock____columns__title\", \"Quantity to move\"), // this is important to display a title in the grid row block\n                isTitleHidden: false,\n                isMandatory: false,\n                isFullWidth: true,\n                max(rowValue) {\n                    return rowValue?.quantityInPackingUnitOrigin ?? 0;\n                },\n                scale(_value, rowValue) {\n                    return rowValue?.packingUnit?.numberOfDecimals;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnit',\n                isHidden: false,\n                isTitleHidden: true,\n                isTransient: false,\n                postfix(_value, rowValue) {\n                    const originalStockLine = this._originalStockLines.find(line => typesLib.strictEq(rowValue?._id, line.id));\n                    return originalStockLine?.packingUnit.code;\n                },\n                scale(value, rowValue) {\n                    const originalStockLine = this._originalStockLines.find(line => typesLib.strictEq(rowValue?._id, line.id));\n                    return originalStockLine?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnitRest',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-master-data/ProductSite',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stock____columns__title__product__product__code\", \"Product\"),\n                isReadOnly: true,\n                isHidden: true,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: { product: { code: true } },\n                    }),\n                    ui.nestedFields.text({\n                        bind: { product: { serialNumberManagementMode: true } },\n                    }),\n                    ui.nestedFields.text({\n                        bind: { product: { stockUnit: { code: true } } },\n                    }),\n                ],\n            }),\n            ui.nestedFields.reference({\n                bind: 'licensePlateNumber',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n                isReadOnly: true,\n                isHidden: true,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.reference({\n                bind: 'locationDestination',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                isReadOnly: true,\n                isHidden() {\n                    return this.lot.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                isReadOnly: true,\n                isHidden() {\n                    return this.sublot.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.link({\n                bind: 'globalSerialNumber',\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                isReadOnly: true,\n                isHidden() {\n                    return this.serialNumber.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'status',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/StockStatus',\n                isReadOnly: true,\n                isHidden() {\n                    return this.status.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'statusDestination',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.technical({\n                bind: 'packingUnit',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                nestedFields: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: 'numberOfDecimals',\n                    }),\n                ],\n            }),\n            ui.nestedFields.reference({\n                bind: 'originalPackingUnit',\n                valueField: 'code',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                isHidden: true,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: 'numberOfDecimals',\n                    }),\n                ],\n            }),\n            ui.nestedFields.technical({\n                bind: 'packingUnitDestination',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                isTransient: true,\n                nestedFields: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactor',\n                isReadOnly: true,\n                isHidden() {\n                    return this.packingUnitToStockUnitConversionFactor.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockUnit',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnitOrigin',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactorDestination',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                isReadOnly: true,\n                isHidden() {\n                    return this.identifier1.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                isReadOnly: true,\n                isHidden() {\n                    return this.identifier2.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCustomField1',\n                isReadOnly: true,\n                isHidden() {\n                    return this.stockCustomField1.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCustomField2',\n                isReadOnly: true,\n                isHidden() {\n                    return this.stockCustomField2.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.technical({\n                bind: 'stockId',\n            }),\n            ui.nestedFields.technical({\n                bind: 'lotReference',\n                node: '@sage/x3-stock-data/Lot',\n                nestedFields: [\n                    ui.nestedFields.date({\n                        bind: 'expirationDate',\n                    }),\n                    ui.nestedFields.date({\n                        bind: 'useByDate',\n                    }),\n                    ui.nestedFields.text({\n                        bind: 'lotCustomField1',\n                    }),\n                    ui.nestedFields.text({\n                        bind: 'lotCustomField2',\n                    }),\n                    ui.nestedFields.reference({\n                        bind: 'majorVersion',\n                        node: '@sage/x3-master-data/MajorVersionStatus',\n                        valueField: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceExpirationDate',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceUseByDate',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lotReferenceMajorVersion',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.technical({\n                bind: 'quantityInStockUnit',\n            }),\n            ui.nestedFields.technical({\n                bind: 'allocatedQuantity',\n            }),\n            ui.nestedFields.technical({\n                bind: 'qualityAnalysisRequestId',\n            }),\n            ui.nestedFields.technical({\n                bind: 'owner',\n            }),\n        ],\n        onError(error) {\n            switch (error.message) {\n                case '@sage/x3-stock/serial-number-not-sequential': {\n                    return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n                }\n                default:\n                    return error;\n            }\n        },\n        async onRowSelected(recordId, rowItem) {\n            await this._onRowClick(recordId, rowItem);\n        },\n        async onRowUnselected(recordId, rowItem) {\n            let stockRecord = this.stock.getRecordValue(recordId);\n            if (stockRecord) {\n                let i = 0;\n                while (typesLib.lt(i, this._stockChangeLines.length)) {\n                    if (typesLib.strictEq(Number(this._stockChangeLines[i].stockId), Number(stockRecord.stockId)) && typesLib.strictEq(Number(this._stockChangeLines[i].lineNumber), Number(this._currentOperation))) {\n                        this._stockChangeLines.splice(i, 1);\n                    }\n                    else {\n                        i = typesLib.add(i, 1);\n                    }\n                }\n                stockRecord.quantityToMove = stockRecord.quantityInPackingUnitOrigin;\n                this.stock.setRecordValue(stockRecord);\n                this._saveStockChange();\n            }\n        },\n        sortColumns(firstColumn, secondColumn) {\n            if (typesLib.strictEq(firstColumn.bind, secondColumn.bind))\n                return 0;\n            if (typesLib.strictEq(firstColumn.bind, 'quantityToMove')) {\n                return typesLib.strictEq(secondColumn.bind, this._stockFieldSettings[0]) ? 1 : -1;\n            }\n            else if (typesLib.strictEq(secondColumn.bind, 'quantityToMove')) {\n                return typesLib.strictEq(firstColumn.bind, this._stockFieldSettings[0]) ? -1 : 1;\n            }\n            for (const stockFieldSetting of Object.keys(this._stockFieldSettings)) {\n                if (!stockFieldSetting || typesLib.strictEq(stockFieldSetting, 'none'))\n                    break;\n                if (typesLib.strictEq(firstColumn.bind, stockFieldSetting))\n                    return -1;\n                if (typesLib.strictEq(secondColumn.bind, stockFieldSetting))\n                    return 1;\n            }\n            return 1;\n        },\n        mapServerRecord(record) {\n            const _record = {\n                ...record,\n                quantityInPackingUnitOrigin: this._getQuantityInPackingUnitOrigin(record),\n                quantityInPackingUnitRest: this._getquantityInPackingUnitRest(record),\n                quantityToMove: this._getQuantityToMove(record).toString(),\n                locationDestination: this._getLocationDestination(record),\n                licensePlateNumberDestination: this._getLicensePlateNumberDestination(record),\n                statusDestination: this._getStatusDestination(record),\n                packingUnitDestination: this._getPackingUnitDestination(record),\n                packingUnitToStockUnitConversionFactorDestination: this._getPackingUnitToStockUnitConversionFactorDestination(record),\n                lotReferenceExpirationDate: record.lotReference?.expirationDate,\n                lotReferenceUseByDate: record.lotReference?.useByDate,\n                lotReferenceMajorVersion: record.lotReference?.majorVersion?.code,\n                stockUnit: record.product?.product?.stockUnit?.code,\n                globalSerialNumber: ui.localize('@sage/x3-stock/label-view-all', 'View list'),\n            };\n            return _record;\n        },\n        async onRowClick(recordId, rowItem) {\n            await this._onRowClick(recordId, rowItem);\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"stock\", void 0);\n__decorate([\n    ui.decorators.detailListField({\n        parent() {\n            return this.detailsBlock;\n        },\n        node: '@sage/x3-stock-data/Stock',\n        isTransient: true,\n        isFullWidth: true,\n        isTitleHidden: true,\n        fields: [\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-master-data/ProductSite',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title\", \"Product\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.reference({\n                bind: 'licensePlateNumber',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__2\", \"License plate number\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__3\", \"Location\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__4\", \"Stock ID\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__5\", \"Lot\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__6\", \"Sublot\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: { majorVersion: { code: true } },\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__7\", \"Major version\"),\n                isReadOnly: true,\n                isHidden: (value) => {\n                    return !value?.majorVersion;\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'expirationDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__8\", \"Expiration date\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return (!this.product.value || typesLib.strictEq(this.product.value.expirationManagementMode, 'notManaged') ||\n                        !value?.expirationDate || typesLib.gt(Date.parse(value.expirationDate), Date.now()));\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'useByDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__9\", \"Use-by date\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return (!this.product.value || typesLib.strictEq(this.product.value.expirationManagementMode, 'notManaged') ||\n                        !value?.useByDate || typesLib.gt(Date.parse(value.useByDate), Date.now()));\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'lotCustomField1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__10\", \"Lot custom field 1\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value?.lotCustomField1;\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'lotCustomField2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__11\", \"Lot custom field 2\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value?.lotCustomField2;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__12\", \"Serial no.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.link({\n                bind: 'globalSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__13\", \"Serial no.\"),\n                isHidden() {\n                    return typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued');\n                },\n                async onClick(_id, rowData) {\n                    const options = {\n                        skipDirtyCheck: true,\n                    };\n                    try {\n                        await this.$.dialog.page('@sage/x3-stock/MobileGlobalSerialDetails', {\n                            product: this.product.value?.code ?? '',\n                            stockId: rowData.stockId,\n                            subtitle: this.localizedDescription.value ?? '',\n                        }, options);\n                    }\n                    catch (error) {\n                        if (error) {\n                            this.$.showToast(error.message, { timeout: 10000, type: 'error' });\n                        }\n                    }\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityToMove',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__14\", \"Quantity to move\"),\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n                postfix(value, rowValue) {\n                    return rowValue?.packingUnit.code;\n                },\n                scale(value, rowValue) {\n                    return rowValue?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__15\", \"Packing qty.\"),\n                isReadOnly: true,\n                isHidden: false,\n                postfix(value, rowValue) {\n                    const currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId);\n                    const originalStockLine = this._originalStockLines.find(line => typesLib.strictEq(currentRecord?._id, line.id));\n                    return originalStockLine?.packingUnit.code ?? '';\n                },\n                scale(value, rowValue) {\n                    return rowValue?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'packingUnit',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__16\", \"Unit\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactor',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__17\", \"Conversion factor\"),\n                isReadOnly: true,\n                isHidden: false,\n                scale(value, rowValue) {\n                    const conversionFactor = rowValue?.packingUnitToStockUnitConversionFactor.toString();\n                    const numberOfDec = conversionFactor.includes('.') ? conversionFactor.split('.')[1].length : 0;\n                    return numberOfDec;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInStockUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__18\", \"Stock qty.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n                postfix() {\n                    return this.product.value?.stockUnit?.code ?? '';\n                },\n                scale() {\n                    return this.product.value?.stockUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__19\", \"Stock unit\"),\n                isReadOnly: true,\n                isTransient: false,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'allocatedQuantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__20\", \"Allocated qty.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n                postfix() {\n                    return this.product.value?.stockUnit?.code ?? '';\n                },\n                scale() {\n                    return this.product.value?.stockUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'status',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/StockStatus',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__21\", \"Status\"),\n                isReadOnly: true,\n                isHidden: (value) => {\n                    return !value?.code;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__22\", \"Identifier 1\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__23\", \"Identifier 2\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'qualityAnalysisRequestId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__24\", \"Analysis req.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'owner',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__stockDetails____fields__title__25\", \"Owner\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileIntersiteTransferDetails.prototype, \"stockDetails\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.quantityBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnitToTransfer____title\", \"Unit\"),\n        width: 'small',\n        options: ['UN'],\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnitToTransfer____placeholder\", \"Select...\"),\n        isMandatory: true,\n        isTransient: true,\n        isDisabled: true,\n        async onChange() {\n            if (!this.packingUnitToTransfer.value)\n                return;\n            const selectedValue = this.packingUnitToTransfer.value;\n            const packingUnitIndex = this._packingUnits\n                .map(packingUnit => packingUnit.node.packingUnit.code)\n                .indexOf(selectedValue);\n            if (typesLib.strictNe(packingUnitIndex, -1)) {\n                const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                this.quantityToMove.scale = selectedUnit.packingUnit.numberOfDecimals;\n                this.packingUnitToStockUnitConversionFactorToTransfer.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n                this.packingUnitToStockUnitConversionFactorToTransfer.isDisabled =\n                    !selectedUnit.isPackingFactorEntryAllowed;\n                const conversionFactor = this.packingUnitToStockUnitConversionFactorToTransfer.value.toString();\n                const numberOfDec = conversionFactor.includes('.') ? conversionFactor.split('.')[1].length : 0;\n                this.packingUnitToStockUnitConversionFactorToTransfer.scale = numberOfDec;\n            }\n            else {\n                this.packingUnitToStockUnitConversionFactorToTransfer.value = 1;\n                this.packingUnitToStockUnitConversionFactorToTransfer.isDisabled = true;\n                this.quantityToMove.scale = 0;\n            }\n            this.quantityToMove.value = null;\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"packingUnitToTransfer\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.quantityBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnitToStockUnitConversionFactorToTransfer____title\", \"Conversion factor\"),\n        isDisabled: false,\n        isMandatory: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnitToStockUnitConversionFactorToTransfer____placeholder\", \"Enter...\"),\n        isTransient: true,\n        async onChange() {\n            if (!this.packingUnitToStockUnitConversionFactorToTransfer.value)\n                return;\n            const selectedValue = this.packingUnitToTransfer.value ?? '';\n            const packingUnitIndex = this._packingUnits\n                .map(packingUnit => packingUnit.node.packingUnit.code)\n                .indexOf(selectedValue);\n            if (typesLib.strictNe(packingUnitIndex, -1)) {\n                const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                this.quantityToMove.scale = selectedUnit.packingUnit.numberOfDecimals;\n            }\n            else {\n                this.packingUnitToStockUnitConversionFactorToTransfer.value = 1;\n                this.packingUnitToStockUnitConversionFactorToTransfer.isDisabled = true;\n                this.quantityToMove.scale = 0;\n            }\n            this.quantityToMove.value = null;\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"packingUnitToStockUnitConversionFactorToTransfer\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.quantityBlock;\n        },\n        postfix(value, rowValue) {\n            return ` ${this.packingUnitToTransfer.value}`;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__quantityToMove____title\", \"Quantity to move\"),\n        isMandatory: false,\n        isFullWidth: true,\n        isTransient: true,\n        max() {\n            return this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '')\n                ?.quantityInPackingUnitRest;\n        },\n        scale() {\n            return (this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '')?.packingUnit\n                ?.numberOfDecimals ?? 0);\n        },\n        async onChange() {\n            const _currentRecord = this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '');\n            if (_currentRecord) {\n                _currentRecord.quantityToMove = String(this.quantityToMove.value);\n                this.stock.setRecordValue(_currentRecord);\n                await this.$.commitValueAndPropertyChanges();\n            }\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"quantityToMove\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__startingSerialNumber____title\", \"Starting serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__startingSerialNumber____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        canFilter: false,\n        isDisabled: false,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        filter() {\n            return {\n                _and: [{ product: { code: this.product.value?.code } }, { stockId: this._stockId.value ?? undefined }],\n            };\n        },\n        async onChange() {\n            await this._onChangeBody();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__startingSerialNumber____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__startingSerialNumber____columns__title__product__code\", \"Product\"),\n                bind: 'product',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileIntersiteTransferDetails.prototype, \"startingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__endingSerialNumber____title\", \"Ending serial number\"),\n        isMandatory: false,\n        isTransient: true,\n        isReadOnly: true,\n        isFullWidth: true,\n        async validation(value) {\n            if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued'))\n                return;\n            const _currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId ?? '');\n            const _currentQty = typesLib.mul(Number(this.quantityToMove.value), Number(this.packingUnitToStockUnitConversionFactorToTransfer.value));\n            if (typesLib.strictNe((await (0, get_count_serial_number_1.getCountSerialNumber)(this, this.product.value?.code ?? '', this._stockSite.code, this._stockId.value ?? '', this.startingSerialNumber.value?.code ?? '', this.endingSerialNumber.value ?? '', value)), _currentQty)) {\n                return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n            }\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"endingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__licensePlateNumberDestination____title\", \"Destination license plate number\"),\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        valueField: 'code',\n        isMandatory: false,\n        isTransient: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__licensePlateNumberDestination____placeholder\", \"Scan or select...\"),\n        isAutoSelectEnabled: true,\n        width: 'large',\n        canFilter: false,\n        filter() {\n            const licensePlateNumberFilter = {\n                stockSite: { code: this._siteDestination?.code },\n                isActive: { _eq: true },\n                _or: [\n                    {\n                        isSingleProduct: { _eq: true },\n                        stock: { _atLeast: 1, product: { product: { code: this.product.value?.code } } },\n                    },\n                    { isSingleProduct: { _eq: true }, stock: { _none: true } },\n                    { isSingleProduct: { _in: [false, null] } },\n                ],\n            };\n            return licensePlateNumberFilter;\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__licensePlateNumberDestination____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Location',\n                bind: 'location',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__licensePlateNumberDestination____columns__title__location__code\", \"Location\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__licensePlateNumberDestination____columns__title__status\", \"Status\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isActive',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSingleProduct',\n                isHidden: true,\n            }),\n        ],\n        async onChange() {\n            this._activeSelectButton();\n            if (this.licensePlateNumberDestination.value) {\n                if (this.licensePlateNumberDestination.value.location) {\n                    this.locationDestination.value = this.licensePlateNumberDestination.value.location;\n                    this.locationDestination.isDisabled = true;\n                }\n                else {\n                    this.locationDestination.isDisabled = false;\n                    this.locationDestination.value = null;\n                }\n                this.licensePlateNumberDestination.getNextField(true)?.focus();\n            }\n            else {\n                this.locationDestination.isDisabled = false;\n                this.locationDestination.value = null;\n            }\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"licensePlateNumberDestination\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__locationDestination____title\", \"Destination location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: true,\n        isTransient: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__locationDestination____placeholder\", \"Scan or select...\"),\n        isAutoSelectEnabled: true,\n        width: 'large',\n        canFilter: false,\n        filter() {\n            const locationFilter = {\n                stockSite: { code: this._siteDestination?.code },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n            return locationFilter;\n        },\n        async onChange() {\n            this._activeSelectButton();\n            if (this.locationDestination.value) {\n                this.locationDestination.getNextField(true)?.focus();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__locationDestination____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__locationDestination____columns__title__type\", \"Type\"),\n            }),\n        ],\n    })\n], MobileIntersiteTransferDetails.prototype, \"locationDestination\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__statusDestination____title\", \"Destination Status\"),\n        width: 'small',\n        isMandatory: false,\n        isTransient: true,\n        onChange() {\n            this._activeSelectButton();\n            if (this.statusDestination.value) {\n                this.statusDestination.getNextField(true)?.focus();\n            }\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"statusDestination\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnitDestination____title\", \"Destination unit\"),\n        width: 'small',\n        options: ['UN'],\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnitDestination____placeholder\", \"Select...\"),\n        isMandatory: true,\n        isTransient: true,\n        isDisabled: false,\n        async onChange() {\n            if (!this.packingUnitDestination.value)\n                return;\n            const selectedValue = this.packingUnitDestination.value;\n            const packingUnitIndex = this._packingUnits\n                .map(packingUnit => packingUnit.node.packingUnit.code)\n                .indexOf(selectedValue);\n            if (typesLib.strictNe(packingUnitIndex, -1)) {\n                const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                this.packingUnitToStockUnitConversionFactorDestination.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n                this.packingUnitToStockUnitConversionFactorDestination.isDisabled =\n                    !selectedUnit.isPackingFactorEntryAllowed;\n                const conversionFactor = this.packingUnitToStockUnitConversionFactorDestination.value.toString();\n                const numberOfDec = conversionFactor.includes('.') ? conversionFactor.split('.')[1].length : 0;\n                this.packingUnitToStockUnitConversionFactorDestination.scale = numberOfDec;\n            }\n            else {\n                this.packingUnitToStockUnitConversionFactorDestination.value = 1;\n                this.packingUnitToStockUnitConversionFactorDestination.isDisabled = true;\n            }\n            this._activeSelectButton();\n            this.packingUnitDestination.getNextField(true)?.focus();\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"packingUnitDestination\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__packingUnitToStockUnitConversionFactorDestination____title\", \"Destination conversion factor\"),\n        isDisabled: true,\n        isMandatory: false,\n        isTransient: true,\n        scale: 5,\n        onChange() {\n            this._activeSelectButton();\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"packingUnitToStockUnitConversionFactorDestination\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        isTransient: true,\n        isHidden: true,\n    })\n], MobileIntersiteTransferDetails.prototype, \"_stockId\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.listSerialNumberBlock;\n        },\n        canFilter: false,\n        canSelect: false,\n        canExport: false,\n        canResizeColumns: false,\n        canUserHideColumns: false,\n        isTitleHidden: false,\n        isTransient: true,\n        isFullWidth: true,\n        isDisabled: false,\n        node: '@sage/x3-stock/StockCountSerialNumber',\n        mobileCard: undefined,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'startingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__serialNumberLines____columns__title__startingSerialNumber\", \"Starting serial Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__serialNumberLines____columns__title__quantity\", \"Quantity\"),\n                isReadOnly: true,\n                postfix(value, rowValue) {\n                    return this.stock.getRecordValue(this.gridBlock.selectedRecordId ?? '')?.packingUnit?.code ?? '';\n                },\n                scale() {\n                    return (this.stock.getRecordValue(this.gridBlock?.selectedRecordId)?.packingUnit?.numberOfDecimals ?? 0);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'endingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__serialNumberLines____columns__title__endingSerialNumber\", \"Ending Serial Number\"),\n                isReadOnly: true,\n            }),\n        ],\n        dropdownActions: [\n            {\n                icon: 'bin',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details__serialNumberLines____dropdownActions__title\", \"Delete\"),\n                onClick(recordId) {\n                    // line removal in the saved object\n                    const removedRecordSerialNumber = this.serialNumberLines.getRecordValue(recordId);\n                    if (removedRecordSerialNumber) {\n                        const removedIndexSerialNumber = this._stockChangeLines[this._currentLine].stockDetails?.findIndex(number => typesLib.strictEq(number.serialNumber, removedRecordSerialNumber?.startingSerialNumber));\n                        if (removedIndexSerialNumber) {\n                            this._stockChangeLines[this._currentLine].stockDetails?.splice(removedIndexSerialNumber, 1);\n                        }\n                        this._saveDetail();\n                        // Clear quantity of this._currentLine\n                        const _currentRecord = this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '');\n                        if (_currentRecord) {\n                            // (_currentRecord as any).quantityToMove = String(0);\n                            this.stock.setRecordValue(_currentRecord);\n                        }\n                        //remove from the card\n                        this.serialNumberLines.removeRecord(recordId);\n                    }\n                    this.startingSerialNumber.isDisabled = false;\n                },\n            },\n        ],\n        fieldActions() {\n            return [this.addSerialRange];\n        },\n    })\n], MobileIntersiteTransferDetails.prototype, \"serialNumberLines\", void 0);\nexports.MobileIntersiteTransferDetails = MobileIntersiteTransferDetails = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details____title\", \"Intersite\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_intersite_transfer_details____subtitle\", \"Enter stock details\"),\n        module: 'x3-stock',\n        node: '@sage/x3-master-data/ProductSite',\n        mode: 'default',\n        isTitleHidden: true,\n        isTransient: false,\n        navigationPanel: undefined,\n        headerCard() {\n            return {\n                title: this.product,\n                line2: this.localizedDescription,\n            };\n        },\n        businessActions() {\n            return [this.nextButton];\n        },\n        async onLoad() {\n            if (!this._getSavedInputs()?.selectedProduct) {\n                return;\n            }\n            this._stockSite = JSON.parse(this.$.queryParameters.stockSite);\n            const _savedInputs = this._getSavedInputs();\n            this._stockChangeLines = _savedInputs?.intersiteTransfer?.stockChangeLines ?? [];\n            this._currentLine = _savedInputs?.currentLine ?? 0;\n            this._currentOperation = _savedInputs?.currentOperation ?? 0;\n            this._serialNumberManagementMode = _savedInputs?.selectedProduct?.serialNumberManagementMode ?? undefined;\n            this._siteDestination = _savedInputs?.siteDestination ?? undefined;\n            await this._init();\n            if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                this.addSerialRange.isHidden = true;\n                this.serialNumberBlock.isHidden = true;\n                this.listSerialNumberBlock.isHidden = true;\n                this.serialNumberLines.isTitleHidden = true;\n                this.listSerialNumberBlock.isHidden = true;\n            }\n            this.serialNumberLines.title = 'Serial number(s) to move    ';\n            (0, manage_pages_1.managePages)(this, this._stockSite.code, { ...this.$.values, product: { ...this.product.value } }, '3', ui.localize('@sage/x3-stock/pages__mobile-settings__mandatory-settings-missing', 'Mandatory settings missing.'), this._stockFieldSettings);\n            (0, miscellaneous_issue_details_control_1.savedOriginalStockLines)(this);\n            await this.stock.refresh();\n        },\n        detailPanel() {\n            return {\n                isCloseButtonHidden: true,\n                isTitleHidden: true,\n                isHidden: true,\n                isTransient: true,\n                header: this.detailPanelSection,\n                sections: [],\n                footerActions: [this.helperCancelButton, this.helperSelectButton],\n            };\n        },\n    })\n], MobileIntersiteTransferDetails);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-intersite-transfer-details.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts":
/*!**********************************************************************************!*\
  !*** ../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getCountSerialNumber = void 0;\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\n/**\n * async getCountSerialNumber for count number of serial numbers in range\n * @param _pageInstance this page\n * @param _productCode product code\n * @param _stockSiteCode  stock site code\n * @param _stockId optional stock id\n * @param _startingSerialNumberCode starting serial number\n * @param _endingSerialNumberCode  ending serial number\n * @param value to control\n * @returns counted serial number in range or throw exception\n */\nasync function getCountSerialNumber(_pageInstance, _productCode, _stockSiteCode, _stockId, _startingSerialNumberCode, _endingSerialNumberCode, value) {\n    // Create a readable payload, but removing CR/LF before to send request.\n    const _payload = `{\n        product: { code: '${_productCode}' },\n        stockSite: { code: '${_stockSiteCode}' },\n        ${_stockId ? `stockId: '${_stockId}',` : ''}\n        _and: [\n            {\n                code: { _gte: '${_startingSerialNumberCode}' },\n            },\n            {\n                code: { _lte: '${_endingSerialNumberCode}' },\n            },\n        ],\n    }`.replace(/[\\r\\n]/g, '');\n    try {\n        const response = await _pageInstance.$.graph.raw(`query {\n                        x3StockData{\n                            serialNumber {\n                                query(filter: \"${_payload}\") {\n                                    totalCount\n                                }\n                            }\n                        }\n                    }`);\n        return response?.x3StockData?.serialNumber?.query?.totalCount ?? 0;\n    }\n    catch (error) {\n        throw new xtrem_shared_1.BusinessRuleError(error?.message, error);\n    }\n}\nexports.getCountSerialNumber = getCountSerialNumber;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/shared-functions/pat-converter.ts":
/*!********************************************************************!*\
  !*** ../../shared/x3-system/lib/shared-functions/pat-converter.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.pat = exports.getRegExpForMultiplePat = exports.getRegExp = void 0;\n/**\n * Get the RegExp equivalent for the 4GL pattern given\n *\n * @param pattern The 4GL pattern you want to get the RegExp equivalent\n * @returns The RegExp\n */\nfunction getRegExp(pattern) {\n    const rule = \n    // escape RegExp spécial chars\n    pattern\n        .replace(/[-[\\]{}()+.,\\\\^$|\\s]/g, '\\\\$&')\n        // translate the pattern\n        .replace(/\\*/g, '.*')\n        .replace(/\\?/g, '.')\n        .replace(/#/g, '\\\\d')\n        .replace(/!/g, '[A-Za-z]');\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExp = getRegExp;\nfunction getRegExpForMultiplePat(multiplePattern) {\n    // const str1 = '(';\n    const rule = `${`(${\n    // convert each pattern individually and join them using |\n    multiplePattern\n        .split(',')\n        .map(multPat => getRegExp(multPat).source.replace(/\\^/g, '').replace(/\\$/g, ''))\n        .join('|')}`})`;\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExpForMultiplePat = getRegExpForMultiplePat;\n/**\n * Perform a 4GL pattern check\n *\n * @param text The text to be tested\n * @param pat The 4GL pattern to apply\n * @returns The result of the test as a boolean\n */\nfunction pat(text, pattern) {\n    return getRegExp(pattern).test(text);\n}\nexports.pat = pat;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/shared-functions/pat-converter.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-intersite-transfer-details.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;