import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, decimal, integer, Reference, date } from '@sage/xtrem-core';
export declare class Storage extends Node {
    readonly stockId: Promise<decimal | null>;
    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly documentNumber: Promise<string>;
    readonly documentLineNumber: Promise<integer | null>;
    readonly storageSite: Reference<sageX3System.nodes.Site>;
    readonly originOfPutaway: Promise<sageX3StockData.enums.OriginOfPutAwayPlan | null>;
    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly sourceDocumentNumber: Promise<string>;
    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
    readonly allocationDate: Promise<date | null>;
    readonly status: Reference<sageX3StockData.nodes.StockStatus | null>;
    readonly location: Reference<sageX3StockData.nodes.Location | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly activeQuantityInStockUnit: Promise<decimal | null>;
    readonly putawayStatus: Promise<sageX3StockData.enums.PutAwayPlanSituation | null>;
    readonly storageListNumber: Promise<string>;
    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly quantityInPackingUnit: Promise<decimal | null>;
    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly quantityInStockUnit: Promise<decimal | null>;
    readonly storageListDate: Promise<date | null>;
    readonly movementDescription: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly isQualityControlManagement: Promise<sageX3MasterData.enums.SubjectToControl | null>;
    readonly qualityControlFrequency: Promise<integer | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
}
//# sourceMappingURL=storage.d.ts.map