"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageDetails = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const joins = {
    referenceJoins: {
        storageSite: {
            code: 'storageSite',
        },
        status: {
            code: 'status',
        },
        location: {
            async stockSite() {
                return (await this.storage)?.storageSite;
            },
            code: 'location',
        },
        packingUnit: {
            code: 'packingUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        warehouse: {
            code: 'warehouse',
        },
        majorVersion: {
            async product() {
                return (await this.storage)?.product;
            },
            code: 'majorVersion',
        },
        licensePlateNumber: {
            code: 'licensePlateNumber',
        },
        storage: {
            stockId: 'stockId',
            documentType: 'documentType',
            documentNumber: 'documentNumber',
            documentLineNumber: 'documentLineNumber',
        },
    },
};
let StorageDetails = class StorageDetails extends xtrem_core_1.Node {
    static processPutaway(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'StorageDetails', 'processPutaway', parameters);
    }
};
exports.StorageDetails = StorageDetails;
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOCOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StorageDetails.prototype, "stockId", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYP',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], StorageDetails.prototype, "documentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "documentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRLIN',
    })
], StorageDetails.prototype, "documentLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SRGSEQ',
    })
], StorageDetails.prototype, "storageSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOSEQTWS',
    })
], StorageDetails.prototype, "storageTWSSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], StorageDetails.prototype, "storageSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORICOD',
        dataType: () => sageX3StockData.enums.originOfPutAwayPlanDatatype,
    })
], StorageDetails.prototype, "originSource", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRGPPS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "storageListNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CREPPS',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StorageDetails.prototype, "storageDetailsListDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSLOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "supplierLot", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "lot", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SLO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "sublot", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STA',
        columnType: 'string',
        node: () => sageX3StockData.nodes.StockStatus,
    })
], StorageDetails.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOCTYP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "locationType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOC',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], StorageDetails.prototype, "location", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SERNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "startingSerialNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SERNUMF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "endingSerialNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], StorageDetails.prototype, "packingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPCU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StorageDetails.prototype, "quantityInPackingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StorageDetails.prototype, "packingUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], StorageDetails.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StorageDetails.prototype, "quantityInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StorageDetails.prototype, "expirationDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WSTOFLG',
    })
], StorageDetails.prototype, "entryOkIndicator", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GESLOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "lotSource", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StorageDetails.prototype, "potency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StorageDetails.prototype, "internationalUnitPotency", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REFPER',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StorageDetails.prototype, "expirationReference", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHL',
    })
], StorageDetails.prototype, "shelfLife", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USRFLD1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "lotUserArea1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USRFLD2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "lotUserArea2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USRFLD3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StorageDetails.prototype, "lotUserArea3", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USRFLD4',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StorageDetails.prototype, "lotUserArea4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StorageDetails.prototype, "activeQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PALNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "identifier1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "identifier2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRH',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], StorageDetails.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFLD1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.SfdActivityCode],
    })
], StorageDetails.prototype, "stockUserArea1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFLD2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.SfdActivityCode],
    })
], StorageDetails.prototype, "stockUserArea2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
    })
], StorageDetails.prototype, "majorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StorageDetails.prototype, "minorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LPNNUM',
        columnType: 'string',
        node: () => sageX3StockData.nodes.LicensePlateNumber,
        serviceOptions: () => [sageX3System.serviceOptions.LpnActivityCode],
    })
], StorageDetails.prototype, "licensePlateNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnType: 'integer',
        node: () => sageX3Stock.nodes.Storage,
    })
], StorageDetails.prototype, "storage", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ProcessPutaway */
        isPublished: true,
        authorizationCode: 'CWSSSL',
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    stockEntryTransaction: {
                        isMandatory: true,
                        type: 'string',
                    },
                    storageSite: {
                        isMandatory: true,
                        type: 'string',
                    },
                    stockId: {
                        isMandatory: true,
                        type: 'decimal',
                    },
                    documentType: {
                        isMandatory: true,
                        type: 'enum',
                        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
                    },
                    documentNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    documentLineNumber: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    storageSequenceNumber: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    quantityInPackingUnit: {
                        isMandatory: true,
                        type: 'decimal',
                    },
                    lot: {
                        isMandatory: true,
                        type: 'string',
                    },
                    sublot: {
                        isMandatory: true,
                        type: 'string',
                    },
                    startingSerialNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    endingSerialNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    status: {
                        isMandatory: true,
                        type: 'string',
                    },
                    container: {
                        isMandatory: true,
                        type: 'string',
                    },
                    licensePlateNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    location: {
                        isMandatory: true,
                        type: 'string',
                    },
                    locationType: {
                        isMandatory: true,
                        type: 'string',
                    },
                    quantityInStockUnit: {
                        isMandatory: true,
                        type: 'decimal',
                    },
                    labelDestination: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                stockEntryTransaction: {
                    isMandatory: true,
                    type: 'string',
                },
                storageSite: {
                    isMandatory: true,
                    type: 'string',
                },
                stockId: {
                    isMandatory: true,
                    type: 'decimal',
                },
                documentType: {
                    isMandatory: true,
                    type: 'enum',
                    dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
                },
                documentNumber: {
                    isMandatory: true,
                    type: 'string',
                },
                documentLineNumber: {
                    isMandatory: true,
                    type: 'integer',
                },
                storageSequenceNumber: {
                    isMandatory: true,
                    type: 'integer',
                },
                quantityInPackingUnit: {
                    isMandatory: true,
                    type: 'decimal',
                },
                lot: {
                    isMandatory: true,
                    type: 'string',
                },
                sublot: {
                    isMandatory: true,
                    type: 'string',
                },
                startingSerialNumber: {
                    isMandatory: true,
                    type: 'string',
                },
                endingSerialNumber: {
                    isMandatory: true,
                    type: 'string',
                },
                status: {
                    isMandatory: true,
                    type: 'string',
                },
                container: {
                    isMandatory: true,
                    type: 'string',
                },
                licensePlateNumber: {
                    isMandatory: true,
                    type: 'string',
                },
                location: {
                    isMandatory: true,
                    type: 'string',
                },
                locationType: {
                    isMandatory: true,
                    type: 'string',
                },
                quantityInStockUnit: {
                    isMandatory: true,
                    type: 'decimal',
                },
                labelDestination: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], StorageDetails, "processPutaway", null);
exports.StorageDetails = StorageDetails = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STOSRGW',
        keyPropertyNames: ['stockId', 'documentType', 'documentNumber', 'documentLineNumber', 'storageSequenceNumber'],
        indexes: [
            {
                orderBy: {
                    stockId: 1,
                    documentType: 1,
                    documentNumber: 1,
                    documentLineNumber: 1,
                    storageSequenceNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: [
                'stockId',
                'documentType',
                'documentNumber',
                'documentLineNumber',
                'storageSequenceNumber',
            ],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StorageDetails);
//# sourceMappingURL=storage-details.js.map