import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, decimal, integer, Reference, date, Context } from '@sage/xtrem-core';
import * as sageX3Stock from '..';
export declare class StorageDetails extends Node {
    readonly stockId: Promise<decimal | null>;
    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly documentNumber: Promise<string>;
    readonly documentLineNumber: Promise<integer | null>;
    readonly storageSequenceNumber: Promise<integer | null>;
    readonly storageTWSSequenceNumber: Promise<integer | null>;
    readonly storageSite: Reference<sageX3System.nodes.Site>;
    readonly originSource: Promise<sageX3StockData.enums.OriginOfPutAwayPlan | null>;
    readonly storageListNumber: Promise<string>;
    readonly storageDetailsListDate: Promise<date | null>;
    readonly supplierLot: Promise<string>;
    readonly lot: Promise<string>;
    readonly sublot: Promise<string>;
    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
    readonly locationType: Promise<string>;
    readonly location: Reference<sageX3StockData.nodes.Location | null>;
    readonly startingSerialNumber: Promise<string>;
    readonly endingSerialNumber: Promise<string>;
    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly quantityInPackingUnit: Promise<decimal | null>;
    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly quantityInStockUnit: Promise<decimal | null>;
    readonly expirationDate: Promise<date | null>;
    readonly entryOkIndicator: Promise<integer | null>;
    readonly lotSource: Promise<string>;
    readonly potency: Promise<decimal | null>;
    readonly internationalUnitPotency: Promise<decimal | null>;
    readonly expirationReference: Promise<date | null>;
    readonly shelfLife: Promise<integer | null>;
    readonly lotUserArea1: Promise<string>;
    readonly lotUserArea2: Promise<string>;
    readonly lotUserArea3: Promise<decimal | null>;
    readonly lotUserArea4: Promise<date | null>;
    readonly activeQuantity: Promise<decimal | null>;
    readonly identifier1: Promise<string>;
    readonly identifier2: Promise<string>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly stockUserArea1: Promise<string>;
    readonly stockUserArea2: Promise<string>;
    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorVersion: Promise<string>;
    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
    readonly storage: Reference<sageX3Stock.nodes.Storage | null>;
    static processPutaway(context: Context, parameters: {
        stockEntryTransaction: string;
        storageSite: string;
        stockId: decimal;
        documentType: sageX3StockData.enums.EntryTypeEnum;
        documentNumber: string;
        documentLineNumber: number;
        storageSequenceNumber: number;
        quantityInPackingUnit: decimal;
        lot: string;
        sublot: string;
        startingSerialNumber: string;
        endingSerialNumber: string;
        status: string;
        container: string;
        licensePlateNumber: string;
        location: string;
        locationType: string;
        quantityInStockUnit: decimal;
        labelDestination: string;
    }): Promise<{
        stockEntryTransaction: string;
        storageSite: string;
        stockId: decimal;
        documentType: sageX3StockData.enums.EntryTypeEnum;
        documentNumber: string;
        documentLineNumber: number;
        storageSequenceNumber: number;
        quantityInPackingUnit: decimal;
        lot: string;
        sublot: string;
        startingSerialNumber: string;
        endingSerialNumber: string;
        status: string;
        container: string;
        licensePlateNumber: string;
        location: string;
        locationType: string;
        quantityInStockUnit: decimal;
        labelDestination: string;
    }>;
}
//# sourceMappingURL=storage-details.d.ts.map