import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, date, Context } from '@sage/xtrem-core';
export declare class StockReorder extends Node {
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly destinationLocation: Promise<string>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly category: Promise<sageX3StockData.enums.LocationCategory | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly documentNumber: Promise<string>;
    readonly documentLineNumber: Promise<integer | null>;
    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly quantityInPackingUnit: Promise<decimal | null>;
    readonly potencyDefault: Promise<decimal | null>;
    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly quantityInStockUnit: Promise<decimal | null>;
    readonly activeQuantityInStockUnit: Promise<decimal | null>;
    readonly requirementDate: Promise<date | null>;
    readonly status: Promise<sageX3StockData.enums.ReorderSituation | null>;
    readonly activeOriginalStockQuantity: Promise<decimal | null>;
    readonly isClosed: Promise<boolean>;
    readonly processingTime: Promise<string>;
    readonly movementDescription: Promise<string>;
    static processReorder(context: Context, parameters: {
        stockEntryTransaction: string;
        documentNumber: string;
        documentLine: number;
        stockSite: string;
        destinationLocation: string;
        source: number;
        stockId: number;
        stockSequence: number;
        product: string;
        fromLocation: string;
        lot: string;
        sublot: string;
        serialNumber: string;
        status: string;
        identifier1: string;
        identifier2: string;
        licensePlateNumber: string;
        packingUnit: string;
        packingUnitToStockUnitConversionFactor: decimal;
        packingQuantity: decimal;
    }): Promise<{
        stockEntryTransaction: string;
        documentNumber: string;
        documentLine: number;
        stockSite: string;
        destinationLocation: string;
        source: number;
        stockId: number;
        stockSequence: number;
        product: string;
        fromLocation: string;
        lot: string;
        sublot: string;
        serialNumber: string;
        status: string;
        identifier1: string;
        identifier2: string;
        licensePlateNumber: string;
        packingUnit: string;
        packingUnitToStockUnitConversionFactor: decimal;
        packingQuantity: decimal;
    }>;
}
//# sourceMappingURL=stock-reorder.d.ts.map