"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockEntryTransaction = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        accessCode: {
            access: 'accessCode',
        },
        stockMovementCode: {
            glossaryId() {
                return 14;
            },
            code: 'stockMovementCode',
        },
        document: {
            reportName: 'document',
        },
        defaultStockMovementGroup: {
            glossaryId() {
                return 9;
            },
            code: 'defaultStockMovementGroup',
        },
        stockAutomaticJournal: {
            code: 'stockAutomaticJournal',
        },
        companyOrSiteGroup: {
            group: 'companyOrSiteGroup',
        },
        stockMovementGroup: {
            glossaryId() {
                return 9;
            },
            code: 'stockMovementGroup',
        },
    },
};
let StockEntryTransaction = class StockEntryTransaction extends xtrem_core_1.Node {
};
exports.StockEntryTransaction = StockEntryTransaction;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SRTTYP',
        dataType: () => sageX3StockData.enums.typeOfStockTransactionDatatype,
    })
], StockEntryTransaction.prototype, "transactionType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRTNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockEntryTransaction.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], StockEntryTransaction.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        provides: ['accessCode'],
        isNullable: true,
        columnName: 'ACSCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], StockEntryTransaction.prototype, "accessCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 14,
            },
            control: {
                glossaryId: 14,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], StockEntryTransaction.prototype, "stockMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DOCNAM',
        columnType: 'string',
        node: () => sageX3System.nodes.GenericPrintReport,
    })
], StockEntryTransaction.prototype, "document", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DOCFLG',
    })
], StockEntryTransaction.prototype, "isAutomaticallyPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSFAMDEF',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 9,
            },
            control: {
                glossaryId: 9,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], StockEntryTransaction.prototype, "defaultStockMovementGroup", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPSLOTCOD1',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], StockEntryTransaction.prototype, "supplierLot", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDECOD1',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], StockEntryTransaction.prototype, "identifier1Detail", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDECOD2',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], StockEntryTransaction.prototype, "identifier2Detail", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRNCOD1',
        dataType: () => sageX3StockData.enums.labelPrintingDatatype,
    })
], StockEntryTransaction.prototype, "printingMode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPERFLG',
    })
], StockEntryTransaction.prototype, "isLotExpirationDateAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPOTFLG',
    })
], StockEntryTransaction.prototype, "isLotPotencyAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB1FLG',
    })
], StockEntryTransaction.prototype, "isLotCustomField1Allowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB2FLG',
    })
], StockEntryTransaction.prototype, "isLotCustomField2Allowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB3FLG',
    })
], StockEntryTransaction.prototype, "isLotCustomField3Allowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB4FLG',
    })
], StockEntryTransaction.prototype, "isLotCustomField4Allowed", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENTCOD',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.AutomaticJournal,
    })
], StockEntryTransaction.prototype, "stockAutomaticJournal", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
    })
], StockEntryTransaction.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GFY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.SiteGroupings,
    })
], StockEntryTransaction.prototype, "companyOrSiteGroup", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STKFLG',
    })
], StockEntryTransaction.prototype, "isAutomaticDetermination", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BETFCYCOD',
        dataType: () => sageX3StockData.enums.destinationChoiceDatatype,
    })
], StockEntryTransaction.prototype, "stockChangeDestination", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHGEMPCOD',
    })
], StockEntryTransaction.prototype, "isLocationChange", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHGSTACOD',
    })
], StockEntryTransaction.prototype, "isStatusChange", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHGPCUCOD',
    })
], StockEntryTransaction.prototype, "isUnitChange", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHGEMPTOT',
    })
], StockEntryTransaction.prototype, "ischangeInMass", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIOQTY',
        dataType: () => sageX3StockData.enums.qtyPreChargedDatatype,
    })
], StockEntryTransaction.prototype, "preloadedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSFAM',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 9,
            },
            control: {
                glossaryId: 9,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], StockEntryTransaction.prototype, "stockMovementGroup", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDEDSTCOD1',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], StockEntryTransaction.prototype, "identifier1Destination", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDEDSTCOD2',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], StockEntryTransaction.prototype, "identifier2Destination", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOCREO',
    })
], StockEntryTransaction.prototype, "isLocationReplenishable", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSMREO',
    })
], StockEntryTransaction.prototype, "isConsumptionArea", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHTREO',
    })
], StockEntryTransaction.prototype, "isShortages", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDECOD01',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], StockEntryTransaction.prototype, "identifier1Entry", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDECOD02',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], StockEntryTransaction.prototype, "identifier2Entry", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLGLOCDES',
    })
], StockEntryTransaction.prototype, "isEnterableDestinationLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CHGWRHCOD',
    })
], StockEntryTransaction.prototype, "isEnterableDestinationWarehouse", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGACC',
        dataType: () => sageX3StockData.enums.stockChangeAccessDatatype,
    })
], StockEntryTransaction.prototype, "stockChangeAccessMode", void 0);
exports.StockEntryTransaction = StockEntryTransaction = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STKTRS',
        keyPropertyNames: ['transactionType', 'code'],
        indexes: [
            {
                orderBy: {
                    transactionType: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['transactionType', 'code'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StockEntryTransaction);
//# sourceMappingURL=stock-entry-transaction.js.map