import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, date, integer, Reference, Collection } from '@sage/xtrem-core';
import * as sageX3Stock from '..';
export declare class StockCountSession extends Node {
    readonly stockCountSession: Promise<string>;
    readonly stockCountSessionDescription: Promise<string>;
    readonly stockCountSessionType: Promise<sageX3StockData.enums.StockCountType | null>;
    readonly stockCountSessionMode: Promise<sageX3StockData.enums.StockCountListChoice | null>;
    readonly stockCountSessionStatus: Promise<sageX3StockData.enums.StockCountSessionStatus | null>;
    readonly stockCountDate: Promise<date | null>;
    readonly stockCountSortCode: Promise<sageX3StockData.enums.StockTakeSequence | null>;
    readonly isGlobal: Promise<boolean>;
    readonly maximumNumberOfLines: Promise<integer | null>;
    readonly maximumPercentLimit: Promise<integer | null>;
    readonly numberOfProducts: Promise<integer | null>;
    readonly numberOfPositionsInLocationCode: Promise<integer | null>;
    readonly productFormula: Promise<string>;
    readonly fromProduct: Reference<sageX3MasterData.nodes.Product | null>;
    readonly toProduct: Reference<sageX3MasterData.nodes.Product | null>;
    readonly isNonUsableProductSelected: Promise<boolean>;
    readonly fromLocationType: Promise<string>;
    readonly toLocationType: Promise<string>;
    readonly fromLocation: Reference<sageX3StockData.nodes.Location | null>;
    readonly toLocation: Reference<sageX3StockData.nodes.Location | null>;
    readonly fromCategory: Reference<sageX3MasterData.nodes.ProductCategory | null>;
    readonly toCategory: Reference<sageX3MasterData.nodes.ProductCategory | null>;
    readonly fromBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly toBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly fromBuyer: Reference<sageX3System.nodes.User | null>;
    readonly toBuyer: Reference<sageX3System.nodes.User | null>;
    readonly fromLot: Promise<string>;
    readonly toLot: Promise<string>;
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly stockCycleCountClassA: Promise<boolean>;
    readonly numberOfProductsSelectedInClassA: Promise<integer | null>;
    readonly numberOfCountsInClassA: Promise<integer | null>;
    readonly stockCycleCountClassB: Promise<boolean>;
    readonly numberOfProductsSelectedInClassB: Promise<integer | null>;
    readonly numberOfCountsInClassB: Promise<integer | null>;
    readonly stockCycleCountClassC: Promise<boolean>;
    readonly numberOfProductsSelectedInClassC: Promise<integer | null>;
    readonly numberOfCountsInClassC: Promise<integer | null>;
    readonly stockCycleCountClassD: Promise<boolean>;
    readonly numberOfProductsSelectedInClassD: Promise<integer | null>;
    readonly numberOfCountsInClassD: Promise<integer | null>;
    readonly isReceiptLocation: Promise<boolean>;
    readonly isStorageLocation: Promise<boolean>;
    readonly isPickingLocation: Promise<boolean>;
    readonly isWorkStationLocation: Promise<boolean>;
    readonly isDockLocation: Promise<boolean>;
    readonly isShopLocation: Promise<boolean>;
    readonly isReturnLocation: Promise<boolean>;
    readonly productsWithZeroStock: Promise<boolean>;
    readonly isMultilist: Promise<boolean>;
    readonly productFormula2: Promise<string>;
    readonly stockFormula: Promise<string>;
    readonly locationFormula: Promise<string>;
    readonly warehouseFormula: Promise<string>;
    readonly productWarehouseFormula: Promise<string>;
    readonly fromWarehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly toWarehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly productWarehouse: Promise<boolean>;
    readonly isMultipleCount: Promise<boolean>;
    readonly fromStatisticalGroups: Collection<sageX3Stock.nodes.StockCountSessionFromStatisticalGroups>;
    readonly toStatisticalGroups: Collection<sageX3Stock.nodes.StockCountSessionToStatisticalGroups>;
}
//# sourceMappingURL=stock-count-session.d.ts.map