"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockCountSerialNumber = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const joins = {
    referenceJoins: {
        stockCountListNumber: {
            stockCountSessionNumber: 'stockCountSessionNumber',
            stockCountListNumber: 'stockCountListNumber',
        },
        stockSite: {
            code: 'stockSite',
        },
    },
};
let StockCountSerialNumber = class StockCountSerialNumber extends xtrem_core_1.Node {
};
exports.StockCountSerialNumber = StockCountSerialNumber;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUNSSSNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSerialNumber.prototype, "stockCountSessionNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNLISNUM',
        columnType: 'string',
        node: () => sageX3Stock.nodes.StockCountList,
    })
], StockCountSerialNumber.prototype, "stockCountListNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SERSEQ',
    })
], StockCountSerialNumber.prototype, "serialNumberSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SERIND',
    })
], StockCountSerialNumber.prototype, "serialNumberIndexNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SERDEB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSerialNumber.prototype, "startingSerialNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SERFIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSerialNumber.prototype, "endingSerialNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTY',
    })
], StockCountSerialNumber.prototype, "quantity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECART',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSerialNumber.prototype, "stockCountVariance", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], StockCountSerialNumber.prototype, "stockSite", void 0);
exports.StockCountSerialNumber = StockCountSerialNumber = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CUNSERDET',
        keyPropertyNames: [
            'stockCountSessionNumber',
            'stockCountListNumber',
            'serialNumberSequenceNumber',
            'serialNumberIndexNumber',
        ],
        indexes: [
            {
                orderBy: {
                    stockCountSessionNumber: 1,
                    stockCountListNumber: 1,
                    serialNumberSequenceNumber: 1,
                    serialNumberIndexNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: [
                'stockCountSessionNumber',
                'stockCountListNumber',
                'serialNumberSequenceNumber',
                'serialNumberIndexNumber',
            ],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StockCountSerialNumber);
//# sourceMappingURL=stock-count-serial-number.js.map