import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection, Context } from '@sage/xtrem-core';
import * as sageX3Stock from '..';
export declare class StockCountListDetail extends Node {
    readonly stockCountSessionNumber: Promise<string>;
    readonly stockCountList: Reference<sageX3Stock.nodes.StockCountList | null>;
    readonly productRankNumber: Promise<integer | null>;
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly owner: Promise<string>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly lot: Promise<string>;
    readonly sublot: Promise<string>;
    readonly location: Reference<sageX3StockData.nodes.Location | null>;
    readonly status: Promise<string>;
    readonly abcClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
    readonly stockCountDate: Promise<date | null>;
    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly countedStockInPackingUnit: Promise<decimal | null>;
    readonly countedStockInStockUnit: Promise<decimal | null>;
    readonly isZeroStock: Promise<boolean>;
    readonly quantityInPackingUnit: Promise<decimal | null>;
    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly quantityInStockUnit: Promise<decimal | null>;
    readonly isOriginOfLineNote: Promise<sageX3StockData.enums.EnteredStockLineStatus | null>;
    readonly stockId: Promise<decimal | null>;
    readonly stockCountCostCode: Promise<sageX3StockData.enums.CostSource | null>;
    readonly stockCountUnitCost: Promise<decimal | null>;
    readonly stockCountNetCost: Promise<decimal | null>;
    readonly allocationDate: Promise<date | null>;
    readonly serialNumber: Promise<string>;
    readonly isStockCountLocked: Promise<sageX3StockData.enums.BlockedStock | null>;
    readonly stockCountListStatus: Promise<sageX3StockData.enums.StockCountDetailStatus | null>;
    readonly identifier1: Promise<string>;
    readonly identifier2: Promise<string>;
    readonly qualityAnalysisRequestId: Promise<string>;
    readonly orderPrice: Promise<decimal | null>;
    readonly potency: Promise<decimal | null>;
    readonly expirationReferenceDate: Promise<date | null>;
    readonly expirationDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly recontrolDate: Promise<date | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorVersion: Promise<string>;
    readonly stockUserArea1: Promise<string>;
    readonly stockUserArea2: Promise<string>;
    readonly countedStockInPackingUnit1: Promise<decimal | null>;
    readonly countedStockInStockUnit1: Promise<decimal | null>;
    readonly isZeroStock1: Promise<boolean>;
    readonly countedStockInPackingUnit2: Promise<decimal | null>;
    readonly countedStockInStockUnit2: Promise<decimal | null>;
    readonly isZeroStock2: Promise<boolean>;
    readonly serialNumberSequenceNumber: Promise<integer | null>;
    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
    readonly serialNumberLines: Collection<sageX3Stock.nodes.StockCountSerialNumber>;
    readonly stockCountSession: Reference<sageX3Stock.nodes.StockCountSession | null>;
    readonly stockLine: Reference<sageX3StockData.nodes.Stock | null>;
    static processCount(context: Context, parameters: {
        stockCountSessionNumber: string;
        stockCountListNumber: string;
        productRankNumber: number;
        product: string;
        licensePlateNumber: string;
        location: string;
        lot: string;
        sublot: string;
        serialNumber: string;
        status: string;
        majorVersion: string;
        minorVersion: string;
        packingUnit: string;
        countedStockInPackingUnit: decimal;
        packingUnitToStockUnitConversionFactor: decimal;
        multiCountNumber: number;
        serialNumberQuantity: decimal[];
        startingSerialNumber: string[];
        endingSerialNumber: string[];
        serialNumberVariance: string[];
    }): Promise<{
        stockCountSessionNumber: string;
        stockCountListNumber: string;
    }>;
    static renumberCountList(context: Context, parameters: {
        stockCountSessionNumber: string;
        stockCountListNumber: string;
    }): Promise<{
        stockCountSessionNumber: string;
        stockCountListNumber: string;
    }>;
}
//# sourceMappingURL=stock-count-list-detail.d.ts.map