"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PickTicket = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const joins = {
    referenceJoins: {
        stockSite: {
            code: 'stockSite',
        },
        company: {
            code: 'company',
        },
        deliveryType: {
            code: 'deliveryType',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        soldToCustomer: {
            code: 'soldToCustomer',
        },
        shipToCustomerAddress: {
            customer: 'soldToCustomer',
            shipToAddress: 'shipToCustomerAddress',
        },
        carrier: {
            code: 'carrier',
        },
        stockMovementCode: {
            glossaryId() {
                return 14;
            },
            code: 'stockMovementCode',
        },
        weightUnit: {
            code: 'weightUnit',
        },
        picker: {
            code: 'picker',
        },
    },
    collectionJoins: {
        pickTicketLines: {
            pickTicket: 'id',
        },
    },
};
let PickTicket = class PickTicket extends xtrem_core_1.Node {
};
exports.PickTicket = PickTicket;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicket.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PickTicket.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], PickTicket.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIPRH',
        dataType: () => sageX3StockData.enums.pickingNoteSourceDatatype,
    })
], PickTicket.prototype, "sourcePickTicket", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRLNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicket.prototype, "pickListNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SDHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicket.prototype, "salesDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDHTYP',
        columnType: 'string',
        node: () => sageX3SalesData.nodes.SalesDeliveryType,
    })
], PickTicket.prototype, "deliveryType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCORD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], PickTicket.prototype, "soldToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ShipToCustomerAddress,
    })
], PickTicket.prototype, "shipToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHIDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PickTicket.prototype, "shipmentDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PickTicket.prototype, "deliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPTNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], PickTicket.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DRN',
        dataType: () => sageX3SalesData.enums.routeCodeDatatype,
    })
], PickTicket.prototype, "routeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRECOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicket.prototype, "preparationCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVFLG',
        dataType: () => sageX3StockData.enums.pickingNoteStatusDatatype,
    })
], PickTicket.prototype, "pickTicketStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PACFLG',
    })
], PickTicket.prototype, "isPacked", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PACNBR',
    })
], PickTicket.prototype, "numberOfPackages", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRNNPR',
    })
], PickTicket.prototype, "isPickTicketPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 14,
            },
            control: {
                glossaryId: 14,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], PickTicket.prototype, "stockMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PickTicket.prototype, "weightUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GROWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickTicket.prototype, "grossWeight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickTicket.prototype, "netWeight", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRPTEX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicket.prototype, "pickTicketHeaderText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRPTEX2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicket.prototype, "pickTicketFooterText", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PREUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], PickTicket.prototype, "picker", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Stock.nodes.PickTicketLine,
        isMutable: true,
        dependsOn: ['id'],
    })
], PickTicket.prototype, "pickTicketLines", void 0);
exports.PickTicket = PickTicket = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STOPREH',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PickTicket);
//# sourceMappingURL=pick-ticket.js.map