"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PickTicketLine = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PhysicalFlowsData = require("@sage/x3-physical-flows-data");
const sageX3StockData = require("@sage/x3-stock-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const joins = {
    referenceJoins: {
        product: {
            code: 'product',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        packingUnit: {
            code: 'packingUnit',
        },
        packaging: {
            code: 'packaging',
        },
    },
    collectionJoins: {
        allocatedLines: {
            documentType() {
                return 'picking';
            },
            documentNumber: 'pickTicket',
            documentLineNumber: 'pickTicketLine',
        },
    },
};
let PickTicketLine = class PickTicketLine extends xtrem_core_1.Node {
    static updatePickTicketLine(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'PickTicketLine', 'updatePickTicketLine', parameters);
    }
};
exports.PickTicketLine = PickTicketLine;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicketLine.prototype, "pickTicket", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRELIN',
    })
], PickTicketLine.prototype, "pickTicketLine", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORITYP',
        dataType: () => sageX3StockData.enums.preparationSourceDatatype,
    })
], PickTicketLine.prototype, "sourcePickTicketType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORINUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicketLine.prototype, "sourcePickTicket", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORILIN',
    })
], PickTicketLine.prototype, "sourcePickTicketLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORISEQ',
    })
], PickTicketLine.prototype, "sourcePickTicketSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORITYPSCO',
    })
], PickTicketLine.prototype, "sourcePickTicketSubcontractType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PickTicketLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicketLine.prototype, "productDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REOLOC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicketLine.prototype, "subcontractReorderLocation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SEQ',
    })
], PickTicketLine.prototype, "allocationSequence", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickTicketLine.prototype, "quantityInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PACQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickTicketLine.prototype, "packedQuantityInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PickTicketLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickTicketLine.prototype, "allocatedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickTicketLine.prototype, "shortageQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLTYP',
        dataType: () => sageX3MasterData.enums.typeOfAllocationDatatype,
    })
], PickTicketLine.prototype, "allocationType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OALQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickTicketLine.prototype, "quantityAllocatedOnSalesOrderInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOMGTCOD',
        dataType: () => sageX3MasterData.enums.stockManagementDatatype,
    })
], PickTicketLine.prototype, "stockManagementMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PickTicketLine.prototype, "packingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickTicketLine.prototype, "packingUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOCDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicketLine.prototype, "destinationLocation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOCTYPDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicketLine.prototype, "destinationLocationType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCK',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.Packaging,
    })
], PickTicketLine.prototype, "packaging", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCKCAP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickTicketLine.prototype, "packagingCapacity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRPTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickTicketLine.prototype, "pickTicketLineText", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLGVT',
    })
], PickTicketLine.prototype, "adcPickedLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FLGANN',
    })
], PickTicketLine.prototype, "canceledLine", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCKFLG',
    })
], PickTicketLine.prototype, "isPacked", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Stock.nodes.Allocation,
        isMutable: true,
        dependsOn: ['pickTicket', 'pickTicketLine'],
    })
], PickTicketLine.prototype, "allocatedLines", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: UpdatePickTicketLine */
        isPublished: true,
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    entryTransaction: {
                        isMandatory: true,
                        type: 'string',
                    },
                    pickTicket: {
                        isMandatory: true,
                        type: 'string',
                    },
                    pickTicketLine: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    destinationLocation: {
                        isMandatory: true,
                        type: 'string',
                    },
                    product: {
                        isMandatory: true,
                        type: 'string',
                    },
                    shortPick: {
                        isMandatory: true,
                        type: 'boolean',
                    },
                    deliverable: {
                        isMandatory: true,
                        type: 'boolean',
                    },
                    documentDestination: {
                        isMandatory: true,
                        type: 'string',
                    },
                    packingUnit: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    packingUnitToStockUnitConversionFactor: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'decimal',
                        },
                    },
                    quantityInPackingUnit: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'decimal',
                        },
                    },
                    quantityInStockUnit: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'decimal',
                        },
                    },
                    location: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    lot: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    sublot: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    serialNumber: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    status: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    stockId: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'integer',
                        },
                    },
                    customBoolean: {
                        isMandatory: true,
                        type: 'boolean',
                    },
                    customDecimal: {
                        isMandatory: true,
                        type: 'decimal',
                    },
                    customString: {
                        isMandatory: true,
                        type: 'string',
                    },
                    customDate: {
                        isMandatory: true,
                        type: 'date',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                pickTicket: {
                    isMandatory: true,
                    type: 'string',
                },
                pickTicketLine: {
                    isMandatory: true,
                    type: 'integer',
                },
            },
        },
    })
], PickTicketLine, "updatePickTicketLine", null);
exports.PickTicketLine = PickTicketLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STOPRED',
        keyPropertyNames: ['pickTicket', 'pickTicketLine'],
        indexes: [
            {
                orderBy: {
                    pickTicket: 1,
                    pickTicketLine: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['pickTicket', 'pickTicketLine'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PickTicketLine);
//# sourceMappingURL=pick-ticket-line.js.map