import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import { Node, integer, Reference, decimal, Collection, Context, DateValue } from '@sage/xtrem-core';
import * as sageX3Stock from '..';
export declare class PickTicketLine extends Node {
    readonly pickTicket: Promise<string>;
    readonly pickTicketLine: Promise<integer | null>;
    readonly sourcePickTicketType: Promise<sageX3StockData.enums.PreparationSource | null>;
    readonly sourcePickTicket: Promise<string>;
    readonly sourcePickTicketLine: Promise<integer | null>;
    readonly sourcePickTicketSequenceNumber: Promise<integer | null>;
    readonly sourcePickTicketSubcontractType: Promise<integer | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly productDescription: Promise<string>;
    readonly subcontractReorderLocation: Promise<string>;
    readonly allocationSequence: Promise<integer | null>;
    readonly quantityInStockUnit: Promise<decimal | null>;
    readonly packedQuantityInStockUnit: Promise<decimal | null>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly allocatedQuantity: Promise<decimal | null>;
    readonly shortageQuantity: Promise<decimal | null>;
    readonly allocationType: Promise<sageX3MasterData.enums.TypeOfAllocation | null>;
    readonly quantityAllocatedOnSalesOrderInStockUnit: Promise<decimal | null>;
    readonly stockManagementMode: Promise<sageX3MasterData.enums.StockManagement | null>;
    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly destinationLocation: Promise<string>;
    readonly destinationLocationType: Promise<string>;
    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
    readonly packagingCapacity: Promise<decimal | null>;
    readonly pickTicketLineText: Promise<string>;
    readonly adcPickedLine: Promise<integer | null>;
    readonly canceledLine: Promise<integer | null>;
    readonly isPacked: Promise<boolean>;
    readonly allocatedLines: Collection<sageX3Stock.nodes.Allocation>;
    static updatePickTicketLine(context: Context, parameters: {
        entryTransaction: string;
        pickTicket: string;
        pickTicketLine: number;
        destinationLocation: string;
        product: string;
        shortPick: boolean;
        deliverable: boolean;
        documentDestination: string;
        packingUnit: string[];
        packingUnitToStockUnitConversionFactor: decimal[];
        quantityInPackingUnit: decimal[];
        quantityInStockUnit: decimal[];
        location: string[];
        lot: string[];
        sublot: string[];
        serialNumber: string[];
        status: string[];
        stockId: number[];
        customBoolean: boolean;
        customDecimal: decimal;
        customString: string;
        customDate: DateValue;
    }): Promise<{
        pickTicket: string;
        pickTicketLine: number;
    }>;
}
//# sourceMappingURL=pick-ticket-line.d.ts.map