import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3Stock from '..';
export declare class MiscellaneousReceipt extends Node {
    readonly entryType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly id: Promise<string>;
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly effectiveDate: Promise<date | null>;
    readonly documentDescription: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly sourceDocumentId: Promise<string>;
    readonly isDisassembly: Promise<boolean>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly disassemblyValue: Promise<decimal | null>;
    readonly miscellaneousReceiptLines: Collection<sageX3Stock.nodes.MiscellaneousReceiptLine>;
    readonly destination: Promise<string>;
    readonly transaction: Promise<string>;
    readonly dimensions: Collection<sageX3Stock.nodes.MiscellaneousReceiptDimensions>;
}
//# sourceMappingURL=miscellaneous-receipt.d.ts.map