"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MiscellaneousIssue = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const joins = {
    referenceJoins: {
        stockSite: {
            code: 'stockSite',
        },
        project: {
            id: 'project',
        },
        stockMovementGroup: {
            glossaryId() {
                return 9;
            },
            code: 'stockMovementGroup',
        },
        stockMovementCode: {
            glossaryId() {
                return 14;
            },
            code: 'stockMovementCode',
        },
        stockAutomaticJournal: {
            code: 'stockAutomaticJournal',
        },
        warehouse: {
            code: 'warehouse',
        },
    },
    collectionJoins: {
        miscellaneousIssueLines: {
            entryType: 'entryType',
            id: 'id',
        },
    },
};
let MiscellaneousIssue = class MiscellaneousIssue extends xtrem_core_1.Node {
};
exports.MiscellaneousIssue = MiscellaneousIssue;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYP',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], MiscellaneousIssue.prototype, "entryType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], MiscellaneousIssue.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], MiscellaneousIssue.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IPTDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], MiscellaneousIssue.prototype, "effectiveDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], MiscellaneousIssue.prototype, "documentDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], MiscellaneousIssue.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSFAM',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 9,
            },
            control: {
                glossaryId: 9,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], MiscellaneousIssue.prototype, "stockMovementGroup", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 14,
            },
            control: {
                glossaryId: 14,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], MiscellaneousIssue.prototype, "stockMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENTCOD',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.AutomaticJournal,
    })
], MiscellaneousIssue.prototype, "stockAutomaticJournal", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYPORI',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], MiscellaneousIssue.prototype, "sourceDocumentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUMORI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], MiscellaneousIssue.prototype, "sourceDocumentId", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DBYFLG',
    })
], MiscellaneousIssue.prototype, "isDisassembly", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRHE',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], MiscellaneousIssue.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DBYDEV',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], MiscellaneousIssue.prototype, "disassemblyValue", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Stock.nodes.MiscellaneousIssueLine,
        isMutable: true,
        dependsOn: ['entryType', 'id'],
    })
], MiscellaneousIssue.prototype, "miscellaneousIssueLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], MiscellaneousIssue.prototype, "destination", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], MiscellaneousIssue.prototype, "transaction", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Stock.nodes.MiscellaneousIssueDimensions,
    })
], MiscellaneousIssue.prototype, "dimensions", void 0);
exports.MiscellaneousIssue = MiscellaneousIssue = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SMVTH',
        keyPropertyNames: ['entryType', 'id'],
        indexes: [
            {
                orderBy: {
                    entryType: 1,
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['entryType', 'id'],
        }),
        getFilters() {
            return [{ entryType: 'miscellaneousIssue' }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
    })
], MiscellaneousIssue);
//# sourceMappingURL=miscellaneous-issue.js.map