import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3Stock from '..';
export declare class LpnOperationsLine extends Node {
    readonly stockChangeId: Promise<string>;
    readonly lineNumber: Promise<integer | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly productDescription: Promise<string>;
    readonly owner: Promise<string>;
    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly quantityInPackingUnit: Promise<decimal | null>;
    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
    readonly locationType: Promise<string>;
    readonly location: Reference<sageX3StockData.nodes.Location | null>;
    readonly lot: Promise<string>;
    readonly sublot: Promise<string>;
    readonly serialNumber: Promise<string>;
    readonly endingSerialNumber: Promise<string>;
    readonly identifier1: Promise<string>;
    readonly identifier2: Promise<string>;
    readonly qualityAnalysisRequestId: Promise<string>;
    readonly packingUnitDestination: Promise<string>;
    readonly quantityInPackingUnitDestination: Promise<decimal | null>;
    readonly packingUnitToStockUnitConversionFactorDestination: Promise<decimal | null>;
    readonly quantityInStockUnitDestination: Promise<decimal | null>;
    readonly isQualityAnalysisRequested: Promise<boolean>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly importLine: Promise<integer | null>;
    readonly stockCustomField1: Promise<string>;
    readonly stockCustomField2: Promise<string>;
    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
    readonly lpnOperations: Reference<sageX3Stock.nodes.LpnOperations>;
    readonly stockDetails: Collection<sageX3StockData.nodes.StockJournal>;
    readonly stockId: Promise<string>;
    readonly stockSite: Promise<string>;
}
//# sourceMappingURL=lpn-operations-line.d.ts.map