import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, decimal, integer, date, Collection } from '@sage/xtrem-core';
import * as sageX3Stock from '..';
export declare class Allocation extends Node {
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly stockId: Promise<decimal | null>;
    readonly sequenceNumber: Promise<integer | null>;
    readonly allocationEndDate: Promise<date | null>;
    readonly allocationType: Promise<sageX3MasterData.enums.TypeOfAllocation | null>;
    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly documentNumber: Promise<string>;
    readonly documentLineNumber: Promise<integer | null>;
    readonly documentSequenceNumber: Promise<integer | null>;
    readonly quantityInStockUnit: Promise<decimal | null>;
    readonly activeQuantityInStockUnit: Promise<decimal | null>;
    readonly warehouse: Promise<string>;
    readonly location: Promise<string>;
    readonly lot: Promise<string>;
    readonly sublot: Promise<string>;
    readonly status: Promise<string>;
    readonly serialNumber: Promise<string>;
    readonly consumptionLocation: Promise<string>;
    readonly defaultWarehouse: Promise<string>;
    readonly defaultLocation: Promise<string>;
    readonly defaultLocationType: Promise<string>;
    readonly storageQuantityInStockUnit: Promise<decimal | null>;
    readonly storageListNumber: Promise<string>;
    readonly storageListLineNumber: Promise<integer | null>;
    readonly pickingNumber: Promise<string>;
    readonly requirementDate: Promise<date | null>;
    readonly transactionDescription: Promise<string>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly deliveryAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress | null>;
    readonly typeOfSupply: Promise<sageX3MasterData.enums.MaterialReplenishType | null>;
    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly stockLine: Reference<sageX3StockData.nodes.Stock | null>;
    readonly reorderLine: Collection<sageX3Stock.nodes.StockReorder>;
}
//# sourceMappingURL=allocation.d.ts.map