"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStockUnitCode = exports.getDistinctCountOfSublots = exports.getDistinctCountOfLots = exports.getDistinctCountOfLocations = exports.getDistinctCountOfStockQuantity = exports.getCountOfStockRecords = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
function getCountOfStockRecords(productSite) {
    return productSite.stock.length;
}
exports.getCountOfStockRecords = getCountOfStockRecords;
function getDistinctCountOfStockQuantity(productSite) {
    return productSite.stock.reduce(async (accumulator, item) => typesLib.add(accumulator, ((await item.quantityInStockUnit) ?? 0)), 0);
}
exports.getDistinctCountOfStockQuantity = getDistinctCountOfStockQuantity;
async function getDistinctCountOfLocations(productSite) {
    return (await productSite.stock.reduce(async (prevValue, item) => {
        if ((await item.location) && typesLib.strictEq(prevValue.indexOf(await (await item.location).code), -1)) {
            prevValue.push(await (await item.location).code);
        }
        return prevValue;
    }, [])).length;
}
exports.getDistinctCountOfLocations = getDistinctCountOfLocations;
async function getDistinctCountOfLots(productSite) {
    if (typesLib.strictEq((await (await productSite.product).lotManagementMode), 'notManaged')) {
        return 0;
    }
    return (await productSite.stock.reduce(async (prevValue, item) => {
        if ((await item.lot) && typesLib.strictEq(prevValue.indexOf(await item.lot), -1)) {
            prevValue.push(await item.lot);
        }
        return prevValue;
    }, [])).length;
}
exports.getDistinctCountOfLots = getDistinctCountOfLots;
async function getDistinctCountOfSublots(productSite) {
    if (typesLib.strictNe((await (await productSite.product).lotManagementMode), 'lotAndSublot')) {
        return 0;
    }
    return (await productSite.stock.reduce(async (prevValue, item) => {
        if ((await item.sublot) && typesLib.strictEq(prevValue.indexOf(await item.sublot), -1)) {
            prevValue.push(await item.sublot);
        }
        return prevValue;
    }, [])).length;
}
exports.getDistinctCountOfSublots = getDistinctCountOfSublots;
async function getStockUnitCode(productSite) {
    return (await (await productSite.product).stockUnit).code;
}
exports.getStockUnitCode = getStockUnitCode;
//# sourceMappingURL=product-site-functions.js.map