"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductSiteExtension = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PhysicalFlowsData = require("@sage/x3-physical-flows-data");
const sageX3StockData = require("@sage/x3-stock-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const joins = {
    referenceJoins: {
        packaging: {
            code: 'packaging',
        },
    },
    collectionJoins: {
        stock: {
            product: 'product',
            stockSite: 'stockSite',
        },
    },
};
let ProductSiteExtension = class ProductSiteExtension extends xtrem_core_1.NodeExtension {
};
exports.ProductSiteExtension = ProductSiteExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCK',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.Packaging,
    })
], ProductSiteExtension.prototype, "packaging", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3StockData.nodes.Stock,
        dependsOn: ['product', 'stockSite'],
    })
], ProductSiteExtension.prototype, "stock", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageX3Stock.nodeFunctions.getCountOfStockRecords(this);
        },
        dependsOn: ['product'],
    })
], ProductSiteExtension.prototype, "countOfStockRecords", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageX3Stock.nodeFunctions.getDistinctCountOfLocations(this);
        },
        dependsOn: ['stock'],
    })
], ProductSiteExtension.prototype, "distinctCountOfLocations", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageX3Stock.nodeFunctions.getDistinctCountOfLots(this);
        },
        dependsOn: ['stock'],
    })
], ProductSiteExtension.prototype, "distinctCountOfLots", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isNullable: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        computeValue() {
            return sageX3Stock.nodeFunctions.getDistinctCountOfStockQuantity(this);
        },
        dependsOn: ['stock'],
    })
], ProductSiteExtension.prototype, "distinctCountOfStockQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isNullable: true,
        computeValue() {
            return sageX3Stock.nodeFunctions.getDistinctCountOfSublots(this);
        },
        dependsOn: ['stock'],
    })
], ProductSiteExtension.prototype, "distinctCountOfSublots", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        computeValue() {
            return sageX3Stock.nodeFunctions.getStockUnitCode(this);
        },
        dependsOn: ['product'],
    })
], ProductSiteExtension.prototype, "stockUnitCode", void 0);
exports.ProductSiteExtension = ProductSiteExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3MasterData.nodes.ProductSite,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], ProductSiteExtension);
//# sourceMappingURL=product-site-extension.js.map