"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStockResults = exports.savedOriginalStockLines = exports._getStockStatus = exports._getQuantityToMove = exports._getMiscellaneousIssueLineStockDetail = exports._getquantityInPackingUnitRest = exports._getQuantityInPackingUnitOrigin = exports._saveDetail = exports._serialNumberManagement = exports._miscellaneousFieldsManagement = exports._initPackingUnitFields = exports._lotManagement = exports._onChangeBody = exports._fieldsManagement = exports._calculateLineQuantity = exports._nextSerialNumber = exports._calculateEndingSerialNumber = exports._saveMiscellaneousIssue = exports._getSavedInputs = exports._isStockJournalToRecord = exports._isLineToRecord = exports._onRowUnselected = exports._onRowSelected = exports._onRowClick = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const pat_converter_1 = require("@sage/x3-system/lib/shared-functions/pat-converter");
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
const stock_management_rules_1 = require("./stock-management-rules");
;
function _onRowClickGlobalReceivedIssue(pageInstance, currentRecord) {
    pageInstance.serialNumberLines.isHidden = false;
    pageInstance.serialNumberLines.value = [];
    pageInstance._miscellaneousIssueLines.forEach(line => {
        if (_isLineToRecord(pageInstance, currentRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation)) {
            line.stockDetails?.forEach((detail) => {
                if (_isStockJournalToRecord(pageInstance, currentRecord, detail)) {
                    pageInstance.serialNumberLines.addRecord({
                        quantity: Number(detail.quantityInPackingUnit),
                        startingSerialNumber: detail.serialNumber,
                    });
                }
            });
        }
    });
    pageInstance.stock.setRecordValue(currentRecord);
}
function _onRowClickNotGlobalReceivedIssue(pageInstance, currentRecord) {
    let lineIndex = pageInstance._miscellaneousIssueLines.findIndex(line => _isLineToRecord(pageInstance, currentRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation));
    if (typesLib.strictEq(lineIndex, -1)) {
        lineIndex = typesLib.sub(pageInstance._miscellaneousIssueLines.push({
            product: pageInstance.product.value?.code,
            productDescription: pageInstance.product.value?.description1,
            quantityInPackingUnit: 0,
            packingUnit: currentRecord.packingUnit?.code,
            packingUnitToStockUnitConversionFactor: currentRecord.packingUnitToStockUnitConversionFactor,
            quantityInStockUnit: 0,
            lineNumber: pageInstance._currentOperation,
            stockDetails: [],
        }), 1);
    }
    pageInstance._currentLine = lineIndex;
    let detailIndex = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails?.findIndex((detail) => _isStockJournalToRecord(pageInstance, currentRecord, detail)) ?? -1;
    if (typesLib.gt(detailIndex, -1)) {
        const stockDetail = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails
            ? [detailIndex]
            : null;
        if (stockDetail) {
            stockDetail.quantityInPackingUnit = currentRecord.quantityInPackingUnit;
            stockDetail.quantityInStockUnit = typesLib.mul(Number(currentRecord.quantityInPackingUnit), Number(currentRecord.packingUnitToStockUnitConversionFactor));
            pageInstance._currentDetail = detailIndex;
        }
    }
    else {
        const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;
        if (stockDetails) {
            detailIndex = typesLib.sub(stockDetails.push({
                packingUnit: currentRecord.packingUnit?.code,
                packingUnitToStockUnitConversionFactor: currentRecord.packingUnitToStockUnitConversionFactor,
                quantityInPackingUnit: Number(currentRecord.quantityInPackingUnit),
                quantityInStockUnit: typesLib.mul(Number(currentRecord.quantityInPackingUnit), Number(currentRecord.packingUnitToStockUnitConversionFactor)),
                location: currentRecord.location?.code,
                licensePlateNumber: currentRecord.licensePlateNumber?.code ?? '',
                lot: currentRecord.lot,
                status: currentRecord.status?.code ?? '',
                sublot: currentRecord.sublot,
                serialNumber: currentRecord.serialNumber,
                identifier1: currentRecord.identifier1,
                identifier2: currentRecord.identifier2,
                stockCustomField1: currentRecord.stockCustomField1,
                stockCustomField2: currentRecord.stockCustomField2,
                stockUnit: pageInstance._productSite.product.stockUnit.code,
            }), 1);
        }
        else {
            detailIndex = -1;
        }
        pageInstance._currentDetail = detailIndex;
    }
    _calculateLineQuantity(pageInstance._miscellaneousIssueLines[lineIndex], pageInstance);
}
async function _onRowClick(pageInstance, recordId, rowItem) {
    pageInstance.gridBlock.selectedRecordId = recordId; // populate grid row block
    pageInstance._stockId.value = rowItem.stockId;
    const currentRecord = pageInstance.stock.getRecordValue(pageInstance.gridBlock.selectedRecordId);
    const originalStockLine = pageInstance._originalStockLines?.find(line => typesLib.strictEq(recordId, line.id));
    rowItem.quantityInPackingUnit = String(originalStockLine?.quantityInPackingUnit);
    rowItem.quantityInStockUnit = String(originalStockLine?.quantityInStockUnit);
    rowItem.packingUnit.code = originalStockLine?.packingUnit.code;
    rowItem.packingUnit.numberOfDecimals = originalStockLine?.packingUnit.numberOfDecimals;
    pageInstance.stockDetails.value = [rowItem];
    const selectedValue = originalStockLine?.packingUnit.code;
    const packingUnitIndex = pageInstance._packingUnits
        .map(packingUnit => packingUnit.node.packingUnit.code)
        .indexOf(selectedValue);
    if (typesLib.strictNe(packingUnitIndex, -1)) {
        const selectedUnit = pageInstance._packingUnits[packingUnitIndex].node;
        pageInstance.packingUnitToStockUnitConversionFactorToIssue.isDisabled =
            !selectedUnit.isPackingFactorEntryAllowed;
        pageInstance.quantityToMove.scale = selectedUnit.packingUnit.numberOfDecimals;
    }
    else {
        pageInstance.packingUnitToStockUnitConversionFactorToIssue.isDisabled = true;
        pageInstance.quantityToMove.scale = 0;
    }
    pageInstance.quantityToMove.value = null;
    pageInstance.packingUnitToStockUnitConversionFactorToIssue.value = originalStockLine?.packingUnitToStockUnitConversionFactor ?? 1;
    pageInstance.packingUnitToIssue.value = originalStockLine?.packingUnit.code;
    const conversionFactor = pageInstance.packingUnitToStockUnitConversionFactorToIssue.value.toString();
    const numberOfDec = (conversionFactor.includes('.')) ? conversionFactor.split('.')[1].length : 0;
    pageInstance.packingUnitToStockUnitConversionFactorToIssue.scale = numberOfDec;
    if (pageInstance._packingUnits.length) {
        pageInstance.packingUnitToIssue.isDisabled = false;
    }
    currentRecord.quantityInStockUnit = originalStockLine?.quantityInStockUnit;
    currentRecord.packingUnit.code = originalStockLine?.packingUnit.code;
    currentRecord.quantityInPackingUnit = originalStockLine?.quantityInPackingUnit;
    if (typesLib.strictEq(pageInstance._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {
        _onRowClickGlobalReceivedIssue(pageInstance, currentRecord);
    }
    else {
        _onRowClickNotGlobalReceivedIssue(pageInstance, currentRecord);
    }
    await pageInstance.$.commitValueAndPropertyChanges();
    await pageInstance.stock.validateWithDetails();
    if (pageInstance.$.detailPanel)
        pageInstance.$.detailPanel.isHidden = false;
    pageInstance.stock.setRecordValue(currentRecord);
}
exports._onRowClick = _onRowClick;
async function _onRowSelectedGlobalReceivedIssued(pageInstance, stockRecord, lineIndex) {
    const responseSerialNumber = await pageInstance.$.graph
        .node('@sage/x3-stock-data/SerialNumber')
        .query(ui.queryUtils.edgesSelector({
        code: true,
    }, {
        filter: {
            stockId: stockRecord.stockId,
            product: { code: pageInstance.product.value?.code },
            stockSite: { code: pageInstance.site.value },
        },
        first: 1001,
    }))
        .execute();
    let currentSerialNumber;
    currentSerialNumber = '';
    let beginSerialNumber;
    beginSerialNumber = '';
    let quantitySerialNumber;
    quantitySerialNumber = 0;
    for (const itemSerialNumber of responseSerialNumber.edges) {
        if (typesLib.strictEq(beginSerialNumber, '')) {
            beginSerialNumber = itemSerialNumber.node.code;
            currentSerialNumber = itemSerialNumber.node.code;
            quantitySerialNumber = 1;
        }
        else if (typesLib.strictEq(itemSerialNumber.node.code, _nextSerialNumber(currentSerialNumber))) {
            var _v;
            currentSerialNumber = itemSerialNumber.node.code;
            _v = quantitySerialNumber, quantitySerialNumber = typesLib.add(quantitySerialNumber, 1), _v;
        }
        else {
            const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;
            if (stockDetails) {
                pageInstance._currentDetail = typesLib.sub(stockDetails.push({
                    packingUnit: stockRecord.packingUnit?.code,
                    packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,
                    quantityInPackingUnit: quantitySerialNumber,
                    quantityInStockUnit: typesLib.mul(Number(quantitySerialNumber), Number(stockRecord.packingUnitToStockUnitConversionFactor)),
                    location: stockRecord.location?.code,
                    licensePlateNumber: stockRecord.licensePlateNumber?.code ?? '',
                    lot: stockRecord.lot,
                    status: stockRecord.status?.code ?? '',
                    sublot: stockRecord.sublot,
                    serialNumber: beginSerialNumber,
                    identifier1: stockRecord.identifier1,
                    identifier2: stockRecord.identifier2,
                    stockCustomField1: stockRecord.stockCustomField1,
                    stockCustomField2: stockRecord.stockCustomField2,
                    stockUnit: pageInstance._productSite.product.stockUnit.code,
                }), 1);
            }
            else {
                pageInstance._currentDetail = -1;
            }
            beginSerialNumber = itemSerialNumber.node.code;
            currentSerialNumber = itemSerialNumber.node.code;
            quantitySerialNumber = 1;
        }
    }
    if (typesLib.strictNe(beginSerialNumber, '') && typesLib.strictNe(quantitySerialNumber, 0)) {
        const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;
        if (stockDetails) {
            pageInstance._currentDetail = typesLib.sub(stockDetails.push({
                packingUnit: stockRecord.packingUnit?.code,
                packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,
                quantityInPackingUnit: quantitySerialNumber,
                quantityInStockUnit: typesLib.mul(Number(quantitySerialNumber), Number(stockRecord.packingUnitToStockUnitConversionFactor)),
                location: stockRecord.location?.code,
                licensePlateNumber: stockRecord.licensePlateNumber?.code ?? '',
                lot: stockRecord.lot,
                status: stockRecord.status?.code ?? '',
                sublot: stockRecord.sublot,
                serialNumber: beginSerialNumber,
                identifier1: stockRecord.identifier1,
                identifier2: stockRecord.identifier2,
                stockCustomField1: stockRecord.stockCustomField1,
                stockCustomField2: stockRecord.stockCustomField2,
                stockUnit: pageInstance._productSite.product.stockUnit.code,
            }), 1);
        }
        else {
            pageInstance._currentDetail = -1;
        }
    }
}
function _onRowSelectedNotGlobalReceivedIssued(pageInstance, stockRecord, lineIndex) {
    const stockDetails = pageInstance._miscellaneousIssueLines[lineIndex].stockDetails;
    if (stockDetails) {
        let detailIndex = stockDetails.findIndex(detail => _isStockJournalToRecord(pageInstance, stockRecord, detail));
        if (typesLib.gt(detailIndex, -1)) {
            const stockDetail = stockDetails[detailIndex];
            stockDetail.quantityInPackingUnit = stockRecord.quantityInPackingUnit;
            stockDetail.quantityInStockUnit = typesLib.mul(Number(stockRecord.quantityInPackingUnit), Number(stockRecord.packingUnitToStockUnitConversionFactor));
            pageInstance._currentDetail = detailIndex;
        }
        else {
            detailIndex = typesLib.sub(stockDetails.push({
                packingUnit: stockRecord.packingUnit?.code,
                packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,
                quantityInPackingUnit: Number(stockRecord.quantityInPackingUnit),
                quantityInStockUnit: typesLib.mul(Number(stockRecord.quantityInPackingUnit), Number(stockRecord.packingUnitToStockUnitConversionFactor)),
                location: stockRecord.location?.code,
                licensePlateNumber: stockRecord.licensePlateNumber?.code ?? '',
                lot: stockRecord.lot,
                status: stockRecord.status?.code ?? '',
                sublot: stockRecord.sublot,
                serialNumber: stockRecord.serialNumber,
                identifier1: stockRecord.identifier1,
                identifier2: stockRecord.identifier2,
                stockCustomField1: stockRecord.stockCustomField1,
                stockCustomField2: stockRecord.stockCustomField2,
                stockUnit: pageInstance._productSite.product.stockUnit.code,
            }), 1);
        }
        pageInstance._currentDetail = detailIndex;
    }
}
async function _onRowSelected(pageInstance, recordId, _rowItem) {
    const stockRecord = pageInstance.stock.getRecordValue(recordId);
    if (stockRecord) {
        pageInstance.stock.isDisabled = true;
        let lineIndex = pageInstance._miscellaneousIssueLines.findIndex(line => _isLineToRecord(pageInstance, stockRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation));
        if (typesLib.strictEq(lineIndex, -1)) {
            lineIndex = typesLib.sub(pageInstance._miscellaneousIssueLines.push({
                product: pageInstance.product.value?.code,
                productDescription: pageInstance.product.value?.description1,
                quantityInPackingUnit: 0,
                packingUnit: stockRecord.packingUnit?.code,
                packingUnitToStockUnitConversionFactor: stockRecord.packingUnitToStockUnitConversionFactor,
                quantityInStockUnit: 0,
                lineNumber: pageInstance._currentOperation,
                stockDetails: [],
            }), 1);
        }
        pageInstance._currentLine = lineIndex;
        if (typesLib.strictEq(pageInstance._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {
            _onRowSelectedGlobalReceivedIssued(pageInstance, stockRecord, lineIndex);
        }
        else {
            _onRowSelectedNotGlobalReceivedIssued(pageInstance, stockRecord, lineIndex);
        }
        _calculateLineQuantity(pageInstance._miscellaneousIssueLines[lineIndex], pageInstance);
        _saveMiscellaneousIssue(pageInstance);
        stockRecord.quantityToMove = stockRecord.quantityInPackingUnit;
        stockRecord.quantityInStockUnit = typesLib.mul(Number(stockRecord.quantityInPackingUnit), Number(stockRecord.packingUnitToStockUnitConversionFactor));
        pageInstance.stock.setRecordValue(stockRecord);
        pageInstance.stock.selectRecord(recordId);
        pageInstance.stock.isDisabled = false;
    }
}
exports._onRowSelected = _onRowSelected;
async function _onRowUnselected(pageInstance, recordId, _rowItem) {
    const stockRecord = pageInstance.stock.getRecordValue(recordId);
    if (stockRecord) {
        let i;
        i = 0;
        pageInstance._miscellaneousIssueLines.forEach(line => {
            if (_isLineToRecord(pageInstance, stockRecord, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation)) {
                let j;
                j = 0;
                line.stockDetails?.forEach(stock => {
                    var _v;
                    if (_isStockJournalToRecord(pageInstance, stockRecord, stock)) {
                        line.stockDetails?.splice(j, 1);
                    }
                    _v = j, j = typesLib.add(j, 1), _v;
                });
            }
        });
        _saveMiscellaneousIssue(pageInstance);
        const originalStockLine = pageInstance._originalStockLines?.find(line => typesLib.strictEq(recordId, line.id));
        stockRecord.quantityToMove = originalStockLine?.quantityInPackingUnit;
        stockRecord.packingUnit.code = originalStockLine?.packingUnit.code;
        stockRecord.quantityInStockUnit = originalStockLine?.quantityInStockUnit;
        stockRecord.quantityInPackingUnit = originalStockLine?.quantityInPackingUnit;
        pageInstance.stock.setRecordValue(stockRecord);
    }
}
exports._onRowUnselected = _onRowUnselected;
function _isLineToRecord(_pageInstance, record, line) {
    return typesLib.strictEq(line.product, record.product?.product.code);
}
exports._isLineToRecord = _isLineToRecord;
function _isStockJournalToRecord(pageInstance, record, line) {
    return (typesLib.strictEq(line.packingUnit, (record?.packingUnit?.code ?? '')) && typesLib.strictEq(line.packingUnitToStockUnitConversionFactor, record?.packingUnitToStockUnitConversionFactor) && typesLib.strictEq(line.location, record?.location?.code) && typesLib.strictEq(line.licensePlateNumber, (record?.licensePlateNumber?.code ?? '')) && typesLib.strictEq(line.lot, record?.lot) && typesLib.strictEq(line.status, (record?.status?.code ?? '')) && typesLib.strictEq(line.sublot, record?.sublot) &&
        (typesLib.strictEq(line.serialNumber, record?.serialNumber) || typesLib.strictEq(pageInstance._serialNumberManagementMode, 'globalReceivedIssued')) && typesLib.strictEq(line.identifier1, record?.identifier1) && typesLib.strictEq(line.identifier2, record?.identifier2) && typesLib.strictEq(line.stockCustomField1, record?.stockCustomField1) && typesLib.strictEq(line.stockCustomField2, record?.stockCustomField2));
}
exports._isStockJournalToRecord = _isStockJournalToRecord;
function _getSavedInputs(pageInstance) {
    return JSON.parse(pageInstance.$.storage.get('mobile-miscellaneousIssue'));
}
exports._getSavedInputs = _getSavedInputs;
function _saveMiscellaneousIssue(pageInstance) {
    const miscellaneousIssueLines = pageInstance._miscellaneousIssueLines ?? null;
    const savedInputs = _getSavedInputs(pageInstance);
    savedInputs.miscellaneousIssue.miscellaneousIssueLines = miscellaneousIssueLines;
    savedInputs.currentLine = pageInstance._currentLine;
    savedInputs.currentDetail = pageInstance._currentDetail;
    pageInstance.$.storage.set('mobile-miscellaneousIssue', JSON.stringify(savedInputs));
}
exports._saveMiscellaneousIssue = _saveMiscellaneousIssue;
function _calculateEndingSerialNumber(startingSerialNumber, quantity) {
    return startingSerialNumber.replace(/\d+$/, match => {
        const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();
        const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);
        return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');
    });
}
exports._calculateEndingSerialNumber = _calculateEndingSerialNumber;
function _nextSerialNumber(currentSerialNumber) {
    return currentSerialNumber.replace(/\d+$/, match => {
        const nextSerialNumber = (typesLib.add(Number(match), 1)).toString();
        const lengthDiff = typesLib.max(typesLib.sub(nextSerialNumber.length, match.length), 0);
        return nextSerialNumber.padStart(typesLib.add(match.length, lengthDiff), '0');
    });
}
exports._nextSerialNumber = _nextSerialNumber;
function _calculateLineQuantity(line, pageInstance) {
    line.quantityInPackingUnit = 0;
    line.quantityInStockUnit = 0;
    line.stockDetails?.forEach(detail => {
        // line.quantityInPackingUnit =
        //     Number(line.quantityInPackingUnit) + Number((detail as StockJournalInput).quantityInPackingUnit);
        line.quantityInStockUnit = typesLib.add(Number(line.quantityInStockUnit), Number(detail.quantityInStockUnit));
        line.quantityInPackingUnit = typesLib.div(line.quantityInStockUnit, (pageInstance.packingUnitToStockUnitConversionFactorToIssue.value
            ? pageInstance.packingUnitToStockUnitConversionFactorToIssue.value
            : 1));
    });
    line.packingUnit = String(pageInstance.packingUnitToIssue.value);
}
exports._calculateLineQuantity = _calculateLineQuantity;
async function _fieldsManagement(pageInstance) {
    _lotManagement(pageInstance);
    await _miscellaneousFieldsManagement(pageInstance);
    _initPackingUnitFields(pageInstance);
    _serialNumberManagement(pageInstance);
}
exports._fieldsManagement = _fieldsManagement;
async function _onChangeBody(pageInstance) {
    const currentRecord = pageInstance.gridBlock.selectedRecordId
        ? pageInstance.stock.getRecordValue(pageInstance.gridBlock.selectedRecordId)
        : null;
    if (!currentRecord) {
        return;
    }
    const currentQty = typesLib.mul(Number(pageInstance.quantityToMove.value), (Number(pageInstance.packingUnitToStockUnitConversionFactorToIssue.value)));
    if (!currentQty || !pageInstance.startingSerialNumber.value || !pageInstance.startingSerialNumber.value.code) {
        pageInstance.endingSerialNumber.value = null;
        return;
    }
    pageInstance.startingSerialNumber.value.code = pageInstance.startingSerialNumber.value.code.toUpperCase();
    if (typesLib.gt(currentQty, 1)) {
        pageInstance.endingSerialNumber.value = _calculateEndingSerialNumber(pageInstance.startingSerialNumber.value.code, currentQty);
    }
    else {
        pageInstance.endingSerialNumber.value = pageInstance.startingSerialNumber.value.code;
    }
    if (typesLib.gt(currentQty, currentRecord.quantityInPackingUnitOrigin))
        pageInstance.addSerialRange.isHidden = true;
    else {
        pageInstance.addSerialRange.isHidden = false;
    }
    // validate range does not contain existing or non-existent serial numbers
    await pageInstance.$.commitValueAndPropertyChanges();
    const validationResult = await pageInstance.endingSerialNumber.validate();
    if (validationResult) {
        pageInstance.$.showToast(validationResult, { type: 'warning' });
    }
}
exports._onChangeBody = _onChangeBody;
function _lotManagement(pageInstance) {
    pageInstance.lot.isHidden = typesLib.strictEq(pageInstance._productSite.product.lotManagementMode, 'notManaged');
    pageInstance.sublot.isHidden = typesLib.strictNe(pageInstance._productSite.product.lotManagementMode, 'lotAndSublot');
}
exports._lotManagement = _lotManagement;
function _initPackingUnitFields(pageInstance) {
    const productPackingList = (0, xtrem_client_1.extractEdges)(pageInstance._productSite.product.packingUnits.query).filter(productPacking => {
        return !!productPacking.packingUnit?.code;
    });
    pageInstance._packingUnits = productPackingList.map(productPacking => {
        return { node: productPacking };
    });
    const productPakingUnitSelectValues = productPackingList.map(productPacking => {
        return `${productPacking.packingUnit.code}`;
    });
    pageInstance.packingUnit.options = [
        pageInstance._productSite.product.stockUnit.code,
        ...productPakingUnitSelectValues,
    ];
}
exports._initPackingUnitFields = _initPackingUnitFields;
async function _miscellaneousFieldsManagement(pageInstance) {
    if (!(pageInstance.lot.isHidden || !!pageInstance._productSite.product.lotSequenceNumber) &&
        ['lotAndSublot', 'mandatoryLot'].includes(pageInstance._productSite.product.lotManagementMode))
        pageInstance.lot.isMandatory = true;
    const transaction = _getSavedInputs(pageInstance).selectedTransaction;
    if (typesLib.strictEq(transaction.isStatusChange, true))
        pageInstance.status.isMandatory = true;
    pageInstance._selectedStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(pageInstance._stockSite.code, pageInstance._productSite.product.productCategory.code, '26', transaction.stockMovementCode?.code ?? null, pageInstance);
    pageInstance.status.options = await _getStockStatus(pageInstance);
}
exports._miscellaneousFieldsManagement = _miscellaneousFieldsManagement;
function _serialNumberManagement(pageInstance) {
    pageInstance.serialNumber.isHidden = ['notManaged', 'issued'].includes(pageInstance._productSite.product.serialNumberManagementMode);
    if (['receivedIssued', 'globalReceivedIssued'].includes(pageInstance._productSite.product.serialNumberManagementMode)) {
        pageInstance.serialNumber.isMandatory = true;
        if (typesLib.strictEq(pageInstance.lot.isHidden, false))
            pageInstance.lot.isMandatory = false;
        if (typesLib.strictEq(pageInstance.sublot.isHidden, false))
            pageInstance.sublot.isMandatory = false;
        if (typesLib.strictEq(pageInstance.status.isHidden, false))
            pageInstance.status.isMandatory = false;
        if (typesLib.strictEq(pageInstance.packingUnit.isHidden, false))
            pageInstance.packingUnit.isMandatory = false;
    }
}
exports._serialNumberManagement = _serialNumberManagement;
function _saveDetail(pageInstance) {
    const currentmiscellaneousIssueLines = pageInstance._miscellaneousIssueLines[pageInstance._currentLine];
    pageInstance._miscellaneousIssueLines[pageInstance._currentLine] = {
        ...currentmiscellaneousIssueLines,
    };
    _saveMiscellaneousIssue(pageInstance);
}
exports._saveDetail = _saveDetail;
function _getQuantityInPackingUnitOrigin(pageInstance, record) {
    if (record.quantityInPackingUnitOrigin) {
        return record.quantityInPackingUnitOrigin;
    }
    else {
        let miscellaneousIssueLines = pageInstance._miscellaneousIssueLines;
        if (typesLib.strictEq(miscellaneousIssueLines, undefined)) {
            miscellaneousIssueLines = _getSavedInputs(pageInstance).miscellaneousIssue.miscellaneousIssueLines ?? [];
        }
        let _quantityInPackingUnitOrigin;
        _quantityInPackingUnitOrigin = Number(record.quantityInPackingUnit);
        miscellaneousIssueLines.forEach(line => {
            if (_isLineToRecord(pageInstance, record, line) && typesLib.strictNe(line.lineNumber, pageInstance._currentOperation)) {
                line.stockDetails?.forEach(detail => {
                    if (_isStockJournalToRecord(pageInstance, record, detail)) {
                        _quantityInPackingUnitOrigin = typesLib.sub(Number(_quantityInPackingUnitOrigin), Number(detail.quantityInPackingUnit));
                    }
                });
            }
        });
        return _quantityInPackingUnitOrigin;
    }
}
exports._getQuantityInPackingUnitOrigin = _getQuantityInPackingUnitOrigin;
function _getquantityInPackingUnitRest(pageInstance, record) {
    let miscellaneousIssueLines = pageInstance._miscellaneousIssueLines;
    if (typesLib.strictEq(miscellaneousIssueLines, undefined)) {
        miscellaneousIssueLines = _getSavedInputs(pageInstance).miscellaneousIssue.miscellaneousIssueLines ?? [];
    }
    if (typesLib.strictEq(pageInstance._serialNumberManagementMode, undefined)) {
        pageInstance._serialNumberManagementMode =
            _getSavedInputs(pageInstance).selectedProduct?.serialNumberManagementMode;
    }
    let _quantityInPackingUnitRest = _getQuantityInPackingUnitOrigin(pageInstance, record);
    if (typesLib.strictEq(pageInstance._serialNumberManagementMode, 'globalReceivedIssued')) {
        pageInstance._miscellaneousIssueLines?.forEach(line => {
            if (_isLineToRecord(pageInstance, record, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation)) {
                line.stockDetails?.forEach(detail => {
                    if (_isStockJournalToRecord(pageInstance, record, detail)) {
                        _quantityInPackingUnitRest = typesLib.sub(Number(_quantityInPackingUnitRest), Number(detail.quantityInPackingUnit));
                    }
                });
            }
        });
    }
    return _quantityInPackingUnitRest;
}
exports._getquantityInPackingUnitRest = _getquantityInPackingUnitRest;
function _getMiscellaneousIssueLineStockDetail(pageInstance, record) {
    let miscellaneousIssueLines = pageInstance._miscellaneousIssueLines;
    if (typesLib.strictEq(miscellaneousIssueLines, undefined)) {
        miscellaneousIssueLines = _getSavedInputs(pageInstance).miscellaneousIssue.miscellaneousIssueLines ?? [];
    }
    const _line = miscellaneousIssueLines.find(line => _isLineToRecord(pageInstance, record, line) && typesLib.strictEq(line.lineNumber, pageInstance._currentOperation));
    if (_line) {
        return _line.stockDetails?.find(detail => _isStockJournalToRecord(pageInstance, record, detail));
    }
    else {
        return undefined;
    }
}
exports._getMiscellaneousIssueLineStockDetail = _getMiscellaneousIssueLineStockDetail;
function _getQuantityToMove(pageInstance, record) {
    const line = _getMiscellaneousIssueLineStockDetail(pageInstance, record);
    let _quantityToMove;
    if (line) {
        _quantityToMove = Number(line.quantityInPackingUnit);
    }
    else {
        _quantityToMove = Number(record.quantityInPackingUnit);
    }
    const _quantityInPackingUnitRest = _getquantityInPackingUnitRest(pageInstance, record);
    if (typesLib.gt(Number(_quantityToMove), Number(_quantityInPackingUnitRest))) {
        _quantityToMove = Number(_quantityInPackingUnitRest);
    }
    return _quantityToMove;
}
exports._getQuantityToMove = _getQuantityToMove;
async function _getStockStatus(pageInstance) {
    const selectedStatus = [];
    pageInstance._selectedStockManagementRules.authorizedSubstatus.split(',').forEach(function (status) {
        selectedStatus.push({ _regex: (0, pat_converter_1.getRegExp)(status).source });
    });
    const response = await pageInstance.$.graph
        .node('@sage/x3-stock-data/StockStatus')
        .query(ui.queryUtils.edgesSelector({
        _id: true,
        code: true,
    }, {
        filter: {
            code: { _or: selectedStatus },
        },
    }))
        .execute();
    if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {
        throw new Error(ui.localize('@sage/x3-stock/pages__stock_change_details__notification__invalid_stock_status_error', 'No stock status'));
    }
    return response.edges.map((stockStatus) => stockStatus.node.code);
}
exports._getStockStatus = _getStockStatus;
async function savedOriginalStockLines(pageInstance) {
    const page = pageInstance;
    const _stockQueryResult = await getStockResults(page, page.stock.filter);
    page._originalStockLines = [{}];
    _stockQueryResult?.forEach((line) => {
        if (typesLib.lt(page._originalStockLines.findIndex((element) => typesLib.strictEq(element.id, line._id)), 0)) {
            page._originalStockLines.push({
                id: line._id ?? '',
                stockId: line.stockId ?? '',
                packingUnit: line.packingUnit,
                packingUnitToStockUnitConversionFactor: Number(line.packingUnitToStockUnitConversionFactor),
                quantityInStockUnit: Number(line.quantityInStockUnit),
                quantityInPackingUnit: Number(line.quantityInPackingUnit),
            });
        }
    });
    page._originalStockLines.splice(0, 1);
}
exports.savedOriginalStockLines = savedOriginalStockLines;
async function getStockResults(pageInstance, filter, maxResult = 500) {
    const page = pageInstance;
    return (0, xtrem_client_1.extractEdges)(await page.$.graph
        .node('@sage/x3-stock-data/Stock')
        .query(ui.queryUtils.edgesSelector({
        owner: true,
        qualityAnalysisRequestId: true,
        allocatedQuantity: true,
        quantityInStockUnit: true,
        lotReference: {
            majorVersion: {
                _id: true,
                code: true,
            },
            lotCustomField2: true,
            lotCustomField1: true,
            useByDate: true,
            expirationDate: true,
        },
        stockId: true,
        stockCustomField2: true,
        stockCustomField1: true,
        identifier2: true,
        identifier1: true,
        packingUnitToStockUnitConversionFactor: true,
        packingUnit: {
            code: true,
            numberOfDecimals: true,
        },
        status: { code: true },
        serialNumber: true,
        sublot: true,
        lot: true,
        location: {
            _id: true,
            code: true,
            category: true,
        },
        licensePlateNumber: { code: true },
        product: {
            product: {
                _id: true,
                code: true,
                stockUnit: {
                    code: true,
                    numberOfDecimals: true,
                },
                serialNumberManagementMode: true,
                lotManagementMode: true,
                description1: true,
                localizedDescription1: true,
                expirationManagementMode: true,
                productCategory: { code: true },
                productSites: {
                    query: {
                        edges: {
                            node: {
                                stockSite: {
                                    code: true
                                },
                            },
                        },
                    },
                },
            },
        },
        quantityInPackingUnit: true,
        _id: true,
        availableQuantity: true,
        isBeingCounted: true,
    }, {
        filter,
        first: typesLib.max(maxResult, 500),
    }))
        .execute());
}
exports.getStockResults = getStockResults;
//# sourceMappingURL=miscellaneous-issue-details-control.js.map