/// <reference types="@sage/x3-system/api" />
import { Product, ProductSite, SerialNumberManagement } from '@sage/x3-master-data-api';
import { MiscellaneousIssueLineInput } from '@sage/x3-stock-api';
import { LotsSites, SerialNumber, Stock, StockJournalInput, StockManagementRules } from '@sage/x3-stock-data-api';
import { Site } from '@sage/x3-system-api';
import { Filter, ExtractEdges } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';
import { inputsMiscIssue } from '../pages/mobile-miscellaneous-issue';
interface PageMiscellaneousIssueDetailFields {
    stock: ui.fields.Table<Stock>;
    _miscellaneousIssueLines: MiscellaneousIssueLineInput[];
    _productSite: ProductSite;
    _currentOperation: number;
    product: ui.fields.Reference<Product>;
    stockDetails: ui.fields.DetailList<Stock>;
    gridBlock: ui.containers.GridRowBlock;
    _stockId: ui.fields.Text;
    quantityToMove: ui.fields.Numeric;
    packingUnitToStockUnitConversionFactorToIssue: ui.fields.Numeric;
    packingUnitToIssue: ui.fields.DropdownList;
    serialNumberLines: ui.fields.Table<any>;
    site: ui.fields.Text;
    _currentLine: number;
    _currentDetail: number;
    _serialNumberManagementMode: SerialNumberManagement | undefined;
    startingSerialNumber: ui.fields.Reference<SerialNumber>;
    endingSerialNumber: ui.fields.Text;
    addSerialRange: ui.PageAction;
    lot: ui.fields.Reference<LotsSites>;
    sublot: ui.fields.Reference<LotsSites>;
    packingUnit: ui.fields.Select;
    _packingUnits: packingUnit[];
    _stockSite: Site;
    status: ui.fields.Select;
    _selectedStockManagementRules: StockManagementRules;
    serialNumber: ui.fields.Reference<SerialNumber>;
    _originalStockLines: originalStockLine[];
}
export type packingUnit = {
    node: {
        packingUnit: {
            code: string;
            numberOfDecimals: number;
        };
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
    };
};
export interface originalStockLine {
    id: string;
    stockId: string;
    packingUnit: any;
    packingUnitToStockUnitConversionFactor: number;
    quantityInPackingUnit: number;
    quantityInStockUnit: number;
    quantityInPackingUnitIssue: number;
}
export type PageMiscellaneousIssueDetail = ui.Page & PageMiscellaneousIssueDetailFields;
export declare function _onRowClick(pageInstance: PageMiscellaneousIssueDetail, recordId: string, rowItem: Stock): Promise<void>;
export declare function _onRowSelected(pageInstance: PageMiscellaneousIssueDetail, recordId: string, _rowItem: Stock): Promise<void>;
export declare function _onRowUnselected(pageInstance: PageMiscellaneousIssueDetail, recordId: string, _rowItem: Stock): Promise<void>;
export declare function _isLineToRecord(_pageInstance: PageMiscellaneousIssueDetail, record: any, line: Partial<MiscellaneousIssueLineInput>): boolean;
export declare function _isStockJournalToRecord(pageInstance: PageMiscellaneousIssueDetail, record: any, line: Partial<StockJournalInput>): boolean;
export declare function _getSavedInputs(pageInstance: PageMiscellaneousIssueDetail): inputsMiscIssue;
export declare function _saveMiscellaneousIssue(pageInstance: PageMiscellaneousIssueDetail): void;
export declare function _calculateEndingSerialNumber(startingSerialNumber: string, quantity: number): string;
export declare function _nextSerialNumber(currentSerialNumber: string): string;
export declare function _calculateLineQuantity(line: Partial<MiscellaneousIssueLineInput>, pageInstance: PageMiscellaneousIssueDetail): void;
export declare function _fieldsManagement(pageInstance: PageMiscellaneousIssueDetail): Promise<void>;
export declare function _onChangeBody(pageInstance: PageMiscellaneousIssueDetail): Promise<void>;
export declare function _lotManagement(pageInstance: PageMiscellaneousIssueDetail): void;
export declare function _initPackingUnitFields(pageInstance: PageMiscellaneousIssueDetail): void;
export declare function _miscellaneousFieldsManagement(pageInstance: PageMiscellaneousIssueDetail): Promise<void>;
export declare function _serialNumberManagement(pageInstance: PageMiscellaneousIssueDetail): void;
export declare function _saveDetail(pageInstance: PageMiscellaneousIssueDetail): void;
export declare function _getQuantityInPackingUnitOrigin(pageInstance: PageMiscellaneousIssueDetail, record: Partial<Stock>): number;
export declare function _getquantityInPackingUnitRest(pageInstance: PageMiscellaneousIssueDetail, record: Partial<Stock>): number;
export declare function _getMiscellaneousIssueLineStockDetail(pageInstance: PageMiscellaneousIssueDetail, record: Partial<Stock>): Partial<StockJournalInput> | undefined;
export declare function _getQuantityToMove(pageInstance: PageMiscellaneousIssueDetail, record: Partial<Stock>): number;
export declare function _getStockStatus(pageInstance: PageMiscellaneousIssueDetail): Promise<string[]>;
export declare function savedOriginalStockLines(pageInstance: ui.Page): Promise<void>;
export declare function getStockResults(pageInstance: ui.Page, filter: Filter<Stock>, maxResult?: number): Promise<ExtractEdges<Stock>[]>;
export {};
//# sourceMappingURL=miscellaneous-issue-details-control.d.ts.map