"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetNumberOfDecimals = exports.getNumberOfDecimal = exports.getUnitNumberOfDecimalList = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const dialogs_1 = require("@sage/x3-master-data/lib/client-functions/dialogs");
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
async function getUnitNumberOfDecimalList(pageInstance) {
    try {
        const numberOfDecimalList = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph
            .node('@sage/x3-master-data/UnitOfMeasure')
            .query(ui.queryUtils.edgesSelector({
            code: true,
            numberOfDecimals: true,
        }, {
            first: 1000,
        }))
            .execute());
        return numberOfDecimalList;
    }
    catch (e) {
        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-stock/pages__utils__get_unit_number_decimals_error', 'Error loading unit'), String(e));
        return [];
    }
}
exports.getUnitNumberOfDecimalList = getUnitNumberOfDecimalList;
function getNumberOfDecimal(list, unit) {
    if (unit && list) {
        const _unitOfMeasure = list.filter(uom => typesLib.strictEq(uom.code, unit));
        return _unitOfMeasure[0]?.numberOfDecimals ?? 0;
    }
    return 0;
}
exports.getNumberOfDecimal = getNumberOfDecimal;
function GetNumberOfDecimals(pageInstance, Unit) {
    try {
        const numberOfDecimals = pageInstance.$.graph
            .node('@sage/x3-master-data/UnitOfMeasure')
            .read({
            _id: true,
            numberOfDecimals: true,
        }, `${Unit}`)
            .execute();
        return numberOfDecimals.numberOfDecimals;
    }
    catch (e) {
        (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-unit', 'Error loading unit'), String(e));
    }
}
exports.GetNumberOfDecimals = GetNumberOfDecimals;
//# sourceMappingURL=get-unit-number-decimals.js.map