"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotifyAndWait = void 0;
class NotifyAndWait {
    constructor(instance) {
        this.pageInstance = instance;
    }
    async showAndWait(message, type, timeout) {
        await _notifyAndWait(this.pageInstance, message, type, timeout);
    }
    show(message, type, timeout) {
        _notify(this.pageInstance, message, type, timeout);
    }
}
exports.NotifyAndWait = NotifyAndWait;
function _notifyAndWait(pageInstance, localizedNotificationText, type, timeout) {
    return new Promise(resolve => {
        _notify(pageInstance, localizedNotificationText, type, timeout);
        setTimeout(resolve, timeout);
    });
}
function _notify(pageInstance, localizedNotificationText, type, timeout = 5000) {
    pageInstance.$.showToast(localizedNotificationText, { type: type, timeout });
}
//# sourceMappingURL=display.js.map