"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductSiteDefaultLocations = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3StockData = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'NDL'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            product: 'product',
            stockSite: 'stockSite',
        },
    },
};
let ProductSiteDefaultLocations = class ProductSiteDefaultLocations extends xtrem_core_1.Node {
};
exports.ProductSiteDefaultLocations = ProductSiteDefaultLocations;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], ProductSiteDefaultLocations.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ITMREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductSiteDefaultLocations.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'STOFCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductSiteDefaultLocations.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ProductSite,
    })
], ProductSiteDefaultLocations.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOCNUM',
        dataType: () => sageX3StockData.enums.titleOfLocationDatatype,
    })
], ProductSiteDefaultLocations.prototype, "locationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEFLOCTYP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductSiteDefaultLocations.prototype, "defaultLocationType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEFLOC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductSiteDefaultLocations.prototype, "defaultLocation", void 0);
exports.ProductSiteDefaultLocations = ProductSiteDefaultLocations = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ITMFACILIT',
        keyPropertyNames: ['denormalizedIndex', 'product', 'stockSite'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], ProductSiteDefaultLocations);
//# sourceMappingURL=product-site-default-locations.js.map