"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductCategoryPackingUnits = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'NUC'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            stockSite: 'stockSite',
            code: 'code',
        },
        unit: {
            code: 'unit',
        },
        labelFormat: {
            reportName: 'labelFormat',
        },
    },
};
let ProductCategoryPackingUnits = class ProductCategoryPackingUnits extends xtrem_core_1.Node {
};
exports.ProductCategoryPackingUnits = ProductCategoryPackingUnits;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], ProductCategoryPackingUnits.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'STOFCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductCategoryPackingUnits.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TCLCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductCategoryPackingUnits.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ProductCategory,
    })
], ProductCategoryPackingUnits.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], ProductCategoryPackingUnits.prototype, "unit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProductCategoryPackingUnits.prototype, "packingUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DACPCUCOE',
    })
], ProductCategoryPackingUnits.prototype, "isPackingFactorEntryAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCURUL',
        dataType: () => sageX3MasterData.enums.unpackingRulesPacDatatype,
    })
], ProductCategoryPackingUnits.prototype, "issuingPackingRule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LBEFMT',
        columnType: 'string',
        node: () => sageX3System.nodes.GenericPrintReport,
    })
], ProductCategoryPackingUnits.prototype, "labelFormat", void 0);
exports.ProductCategoryPackingUnits = ProductCategoryPackingUnits = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ITMCATEG',
        keyPropertyNames: ['denormalizedIndex', 'stockSite', 'code'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], ProductCategoryPackingUnits);
//# sourceMappingURL=product-category-packing-units.js.map