"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicensePlateNumber = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3StockData = require("..");
const joins = {
    referenceJoins: {
        stockSite: {
            code: 'stockSite',
        },
        warehouse: {
            code: 'warehouse',
        },
        location: {
            stockSite: 'stockSite',
            code: 'location',
        },
        container: {
            code: 'container',
        },
        masterLicensePlateNumber: {
            code: 'masterLicensePlateNumber',
        },
    },
    collectionJoins: {
        stock: {
            licensePlateNumber: 'code',
        },
    },
};
let LicensePlateNumber = class LicensePlateNumber extends xtrem_core_1.Node {
};
exports.LicensePlateNumber = LicensePlateNumber;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LPNNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], LicensePlateNumber.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], LicensePlateNumber.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRH',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], LicensePlateNumber.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'LOCTYP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], LicensePlateNumber.prototype, "locationType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOC',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], LicensePlateNumber.prototype, "location", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TCTRNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Container,
    })
], LicensePlateNumber.prototype, "container", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
    })
], LicensePlateNumber.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MONITMFLG',
    })
], LicensePlateNumber.prototype, "isSingleProduct", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MONLOTFLG',
    })
], LicensePlateNumber.prototype, "isSingleLot", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LPNFDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], LicensePlateNumber.prototype, "firstDateOfUse", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LPNLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], LicensePlateNumber.prototype, "lastDateOfUse", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LPNMASTER',
        columnType: 'string',
        node: () => sageX3StockData.nodes.LicensePlateNumber,
    })
], LicensePlateNumber.prototype, "masterLicensePlateNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LPNSTAT',
        dataType: () => sageX3StockData.enums.containerStatusDatatype,
    })
], LicensePlateNumber.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRTFLG',
    })
], LicensePlateNumber.prototype, "isPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYP',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], LicensePlateNumber.prototype, "documentEntryType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], LicensePlateNumber.prototype, "documentEntry", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3StockData.nodes.Stock,
        dependsOn: ['code'],
    })
], LicensePlateNumber.prototype, "stock", void 0);
exports.LicensePlateNumber = LicensePlateNumber = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'LPN',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], LicensePlateNumber);
//# sourceMappingURL=license-plate-number.js.map