"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductCategoryExtension = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3StockData = require("..");
const joins = {
    collectionJoins: {
        stockManagementRules: {
            productCategory: 'code',
            stockSite: 'stockSite',
        },
    },
};
let ProductCategoryExtension = class ProductCategoryExtension extends xtrem_core_1.NodeExtension {
};
exports.ProductCategoryExtension = ProductCategoryExtension;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOTMGTCOD',
        dataType: () => sageX3StockData.enums.lotManagementModeDatatype,
    })
], ProductCategoryExtension.prototype, "lotManagementMode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRKCOD',
        dataType: () => sageX3StockData.enums.traceabilityManagementModeDatatype,
    })
], ProductCategoryExtension.prototype, "traceabilityManagementMode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRKLEV',
        dataType: () => sageX3StockData.enums.traceabilityLevelDatatype,
    })
], ProductCategoryExtension.prototype, "traceabilityLevel", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BRDCOD',
        dataType: () => sageX3StockData.enums.materialCostGroupDatatype,
    })
], ProductCategoryExtension.prototype, "materialCostGroup", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REOMGTCOD',
        dataType: () => sageX3StockData.enums.reorderingManagementModeDatatype,
    })
], ProductCategoryExtension.prototype, "reorderingManagementMode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCSTO',
        dataType: () => sageX3StockData.enums.stockVersionModeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], ProductCategoryExtension.prototype, "stockVersionMode", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3StockData.nodes.StockManagementRules,
        isMutable: true,
        dependsOn: ['code', 'stockSite'],
    })
], ProductCategoryExtension.prototype, "stockManagementRules", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3StockData.nodes.ProductCategoryDefaultLocations,
    })
], ProductCategoryExtension.prototype, "defaultLocations", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3StockData.nodes.ProductCategoryOverheads,
    })
], ProductCategoryExtension.prototype, "overheads", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3StockData.nodes.ProductCategoryPackingUnits,
    })
], ProductCategoryExtension.prototype, "packingUnits", void 0);
exports.ProductCategoryExtension = ProductCategoryExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3MasterData.nodes.ProductCategory,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], ProductCategoryExtension);
//# sourceMappingURL=product-category-extension.js.map