import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
export declare enum StockMovementTypeEnum {
    allReceipts = 1,
    allIssues = 2,
    miscellaneousReceipts = 3,
    miscellaneousIssues = 4,
    supplierReceipts = 5,
    customerShipments = 6,
    workOrderReceipts = 7,
    workOrderIssues = 8,
    locationChange = 9,
    qualityControl = 10,
    statusChange = 11,
    intersiteTransferReceipt = 12,
    returnOfReceipt = 13,
    deliveryReturn = 14,
    counting = 15,
    intersiteTransfer = 16,
    transferForSubcontracting = 17,
    receiptForSubcontracting = 18,
    loanDelivery = 19,
    loanReturn = 20,
    returnToStock = 21
}
export interface StockMovementType$EnumInterface {
    allReceipts: 1;
    allIssues: 2;
    miscellaneousReceipts: 3;
    miscellaneousIssues: 4;
    supplierReceipts: 5;
    customerShipments: 6;
    workOrderReceipts: 7;
    workOrderIssues: 8;
    locationChange: 9;
    qualityControl: 10;
    statusChange: 11;
    intersiteTransferReceipt: 12;
    returnOfReceipt: 13;
    deliveryReturn: 14;
    counting: 15;
    intersiteTransfer: 16;
    transferForSubcontracting: 17;
    receiptForSubcontracting: 18;
    loanDelivery: 19;
    loanReturn: 20;
    returnToStock: 21;
}
export type StockMovementType = keyof StockMovementType$EnumInterface;
export declare const stockMovementTypeDatatype: X3EnumDataType<keyof StockMovementType$EnumInterface, unknown>;
//# sourceMappingURL=stock-movement-type.d.ts.map