declare module '@sage/x3-stock-data-api-partial' {
    import type {
        BomCodes,
        BomRouting,
        BusinessPartner,
        Container,
        Customer,
        CustomerProduct,
        CustomerProductInput,
        Package as SageX3MasterData$Package,
        Product,
        ProductCategory,
        ProductCategoryStatisticalGroups,
        ProductCategoryStatisticalGroupsBinding,
        ProductCategoryStatisticalGroupsInput,
        ProductPackingUnits,
        ProductPackingUnitsBinding,
        ProductPackingUnitsInput,
        ProductSite,
        ProductSiteInput,
        ProductStatisticalGroups,
        ProductStatisticalGroupsBinding,
        ProductStatisticalGroupsInput,
        ProductVersion,
        ProductVersionInput,
        Supplier,
        SupplierProduct,
        SupplierProductInput,
        TechnicalSheet,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type {
        CostType,
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type { Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type {
        Access,
        Company,
        GenericPrintReport,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AbcClassCalculation$Enum {
        calculationWithoutUpdate: 1;
        calculationWithUpdate: 2;
        updateOnly: 3;
    }
    export type AbcClassCalculation = keyof AbcClassCalculation$Enum;
    export interface AbreviationsMenu252$Enum {
        x1: 1;
        substituteValue2: 2;
        d: 3;
        b: 4;
        x: 5;
    }
    export type AbreviationsMenu252 = keyof AbreviationsMenu252$Enum;
    export interface AdcFlowType$Enum {
        issueFlow: 1;
        stockChange: 2;
        containerOperation: 3;
        pickTicket: 4;
    }
    export type AdcFlowType = keyof AdcFlowType$Enum;
    export interface AdjustmentOfStockShortages$Enum {
        noProcessing: 1;
        suspendedTransactions: 2;
        shortagesOnNonValidatedIssues: 3;
        shortagesOnOrderWo: 4;
    }
    export type AdjustmentOfStockShortages = keyof AdjustmentOfStockShortages$Enum;
    export interface AllocationMessages$Enum {
        cancelled: 1;
    }
    export type AllocationMessages = keyof AllocationMessages$Enum;
    export interface AssemblyType$Enum {
        assembly: 1;
        disassembly: 2;
    }
    export type AssemblyType = keyof AssemblyType$Enum;
    export interface AssignmentMode$Enum {
        simple: 1;
        multiple: 2;
    }
    export type AssignmentMode = keyof AssignmentMode$Enum;
    export interface AverageCostInitialization$Enum {
        monthly: 1;
        annual: 2;
        moving: 3;
    }
    export type AverageCostInitialization = keyof AverageCostInitialization$Enum;
    export interface BlockedStock$Enum {
        no: 1;
        yes: 2;
        partial: 3;
    }
    export type BlockedStock = keyof BlockedStock$Enum;
    export interface CalendarCorrection$Enum {
        no: 1;
        value: 2;
        quantity: 3;
    }
    export type CalendarCorrection = keyof CalendarCorrection$Enum;
    export interface CatalogTypes$Enum {
        tablesAtable: 1;
        functionsAfonction: 2;
        objectsAobjet: 3;
        screensAmsk: 4;
        subProgramsAsubprog: 5;
        programsAprog: 6;
        reportsAreport: 7;
        windowsAwindow: 8;
        inquiriesAconsult: 9;
    }
    export type CatalogTypes = keyof CatalogTypes$Enum;
    export interface ChooseQuantityColumn$Enum {
        no: 1;
        stockUnitColumn: 2;
        salesUnitColumn: 3;
    }
    export type ChooseQuantityColumn = keyof ChooseQuantityColumn$Enum;
    export interface ChooseStandardProcess$Enum {
        forSelections: 1;
        forScenarios: 2;
        masterScenario: 3;
    }
    export type ChooseStandardProcess = keyof ChooseStandardProcess$Enum;
    export interface CombinedTransactions$Enum {
        no: 1;
        prodCompWithoutScrap: 2;
        prodCompWithScrap: 3;
        onlyCompWithoutScrap: 4;
        onlyCompWithScrap: 5;
    }
    export type CombinedTransactions = keyof CombinedTransactions$Enum;
    export interface ComponentRequirements$Enum {
        byProduct: 1;
        byLevelProduct: 2;
        byLevelParentProduct: 3;
        byBom: 4;
    }
    export type ComponentRequirements = keyof ComponentRequirements$Enum;
    export interface ComponentRounding2727$Enum {
        theNearest: 1;
        higher: 2;
        lower: 3;
    }
    export type ComponentRounding2727 = keyof ComponentRounding2727$Enum;
    export interface ComponentRounding2728$Enum {
        toTheNearest: 1;
        higher: 2;
        lower: 3;
    }
    export type ComponentRounding2728 = keyof ComponentRounding2728$Enum;
    export interface ComponentRounding$Enum {
        theNearest: 1;
        higher: 2;
        lower: 3;
    }
    export type ComponentRounding = keyof ComponentRounding$Enum;
    export interface ConfigScenariosEntryMode$Enum {
        standard: 1;
        assisted: 2;
        questionByQuestion: 3;
    }
    export type ConfigScenariosEntryMode = keyof ConfigScenariosEntryMode$Enum;
    export interface ConfiguratorActions$Enum {
        noAction: 1;
        noSelection: 2;
        select0Or1Line: 3;
        select1Line: 4;
        select0ToNLines: 5;
        select1ToNLines: 6;
        reWork: 7;
        information: 8;
        blocking: 9;
    }
    export type ConfiguratorActions = keyof ConfiguratorActions$Enum;
    export interface ConfiguratorFieldControl$Enum {
        mandatoryEntry: 1;
        optionalEntry: 2;
        display: 3;
        hidden: 4;
    }
    export type ConfiguratorFieldControl = keyof ConfiguratorFieldControl$Enum;
    export interface ConfiguratorSelectionType$Enum {
        selectProducts: 1;
        selectOptionsVariants: 2;
    }
    export type ConfiguratorSelectionType = keyof ConfiguratorSelectionType$Enum;
    export interface ConfiguratorSymbolOrigin$Enum {
        user: 1;
        system2: 2;
        system3: 3;
        system4: 4;
    }
    export type ConfiguratorSymbolOrigin = keyof ConfiguratorSymbolOrigin$Enum;
    export interface ConfiguratorSystemVariables$Enum {
        site: 1;
        processDate: 2;
        currency: 3;
        log: 4;
        bpNumber: 5;
        bpReference: 6;
        purgeDate: 7;
        parentProductQuantity: 8;
        noHistory: 9;
        listOfParentProducts: 10;
        listComponents: 11;
        parentProduct: 12;
        routing: 13;
        totalCost: 14;
        materialCost: 15;
        machineCost: 16;
        laborCost: 17;
        subcontractCost: 18;
        overheadCost: 19;
        calculatedUnitCost: 20;
        productNumber: 21;
        productDescription: 22;
        productLine: 23;
        numField1: 24;
        numField2: 25;
        numField3: 26;
        numField4: 27;
        numField5: 28;
        numField6: 29;
        alphaField1: 30;
        alphaField2: 31;
        alphaField3: 32;
        alphaField4: 33;
        alphaField5: 34;
        alphaField6: 35;
        linkTableOk: 36;
        roundedVariableCalculation: 37;
        manageLevelSettting: 38;
        masterScenario: 39;
        selectionTableFilter: 40;
        referenceOfParentProduct: 41;
        genericDesig1: 42;
        genericDesig2: 43;
        genericDesig3: 44;
        memoPurgeDelay: 45;
        dynamicAmount: 46;
        dynamicTable: 47;
        blowDownTheBill: 48;
        bomCode: 49;
        referenceBomCode: 50;
        routingCode: 51;
        referenceRoutingCode: 52;
        supplierProduct: 53;
        customerProduct: 54;
        supplierProductDescription: 55;
        customerProductDescription: 56;
        filterForResponseTable: 57;
    }
    export type ConfiguratorSystemVariables = keyof ConfiguratorSystemVariables$Enum;
    export interface ConsolidationsPrevisionsRoun$Enum {
        noRounding: 1;
        roundToTheNearest: 2;
        roundDown: 3;
        roundUp: 4;
    }
    export type ConsolidationsPrevisionsRoun = keyof ConsolidationsPrevisionsRoun$Enum;
    export interface ConstraintsOptionsVariants$Enum {
        mandatoryChoice: 1;
        linkedWith: 2;
        notAllowedWith: 3;
    }
    export type ConstraintsOptionsVariants = keyof ConstraintsOptionsVariants$Enum;
    export interface ConsumptionReorderPlanSort$Enum {
        location: 1;
        product: 2;
        sourceLocation: 3;
        sourceProduct: 4;
    }
    export type ConsumptionReorderPlanSort = keyof ConsumptionReorderPlanSort$Enum;
    export interface ContainerStatus$Enum {
        free: 1;
        inStock: 2;
    }
    export type ContainerStatus = keyof ContainerStatus$Enum;
    export interface CostSource$Enum {
        entered: 1;
        standardCost: 2;
        revisedStandardCost: 3;
        lastCost: 4;
        historicalAuc: 5;
        fifoCost: 6;
        lotAverageCost: 7;
        orderCost: 8;
        lifoCost: 9;
        lastPurchasePrice: 10;
    }
    export type CostSource = keyof CostSource$Enum;
    export interface CountAndAucDifferences$Enum {
        noAucModification: 1;
        adjustment: 2;
        differenceAdjustment03: 3;
        differenceAdjustment0: 4;
    }
    export type CountAndAucDifferences = keyof CountAndAucDifferences$Enum;
    export interface CountDifferenceAdjustment$Enum {
        formerPrices: 1;
        newPrices: 2;
    }
    export type CountDifferenceAdjustment = keyof CountDifferenceAdjustment$Enum;
    export interface CountWorksheetSelection$Enum {
        manualEntry: 1;
        cycleCounting: 2;
        annualCount: 3;
        zeroStockCount: 4;
    }
    export type CountWorksheetSelection = keyof CountWorksheetSelection$Enum;
    export interface CrystalReportStock$Enum {
        dummyValue: 0;
    }
    export type CrystalReportStock = keyof CrystalReportStock$Enum;
    export interface DefaultLot$Enum {
        none: 1;
        supplierLot: 2;
        documentNumber: 3;
    }
    export type DefaultLot = keyof DefaultLot$Enum;
    export interface DefaultUom$Enum {
        stockUnit: 1;
        productPurchaseUnit: 2;
        supplierPurchaseUnit: 3;
        productPackingUnit1: 4;
        productPackingUnit2: 5;
        supplierPackingUnit: 6;
        productSalesUnit: 7;
        documentLineUnit: 8;
    }
    export type DefaultUom = keyof DefaultUom$Enum;
    export interface DefinitionLevel2742$Enum {
        file: 1;
        category: 2;
        categoryWithMovementCode: 3;
        siteCategory: 4;
        siteCategoryWithMovementCode: 5;
    }
    export type DefinitionLevel2742 = keyof DefinitionLevel2742$Enum;
    export interface DestinationChoice$Enum {
        internal: 1;
        intersite: 2;
        customer: 3;
        subcontractTransfer: 4;
        subcontractReturn: 5;
    }
    export type DestinationChoice = keyof DestinationChoice$Enum;
    export interface DetailStockSelection$Enum {
        lot: 1;
        serial: 2;
        unitQuantity: 3;
    }
    export type DetailStockSelection = keyof DetailStockSelection$Enum;
    export interface DimensionCostGroup$Enum {
        subtotal1: 1;
        subtotal2: 2;
        subtotal3: 3;
        subtotal4: 4;
        subtotal5: 5;
        subtotal6: 6;
        subtotal7: 7;
        subtotal8: 8;
        subtotal9: 9;
        subtotal10: 10;
        subtotal11: 11;
        subtotal12: 12;
        subtotal13: 13;
        subtotal14: 14;
        subtotal15: 15;
    }
    export type DimensionCostGroup = keyof DimensionCostGroup$Enum;
    export interface DocumentCategory$Enum {
        no: 1;
        sales: 2;
        production: 3;
        internal: 4;
    }
    export type DocumentCategory = keyof DocumentCategory$Enum;
    export interface DocumentForLabels$Enum {
        receipt: 1;
        workOrder: 2;
        customerReturn: 3;
        productionReporting: 4;
        miscellaneousStock: 5;
        materialReturn: 6;
    }
    export type DocumentForLabels = keyof DocumentForLabels$Enum;
    export interface Element$Enum {
        programSrcAdx: 1;
        reportRpt: 2;
        screenDico: 3;
        functionDico: 4;
        objectDico: 5;
        windowDico: 6;
        inquiryDico: 7;
        actionDico: 8;
        reportDico: 9;
    }
    export type Element = keyof Element$Enum;
    export interface EnteredStockLineStatus$Enum {
        newLine: 1;
        oldLine: 2;
        changedUnit: 3;
        notControlled: 4;
        controlled: 5;
        analysisRequested: 6;
        suspended: 7;
    }
    export type EnteredStockLineStatus = keyof EnteredStockLineStatus$Enum;
    export interface EntryTypeEnum$Enum {
        customer: 1;
        salesOrder: 2;
        picking: 3;
        delivery: 4;
        salesInvoice: 5;
        receipt: 6;
        transferInactive: 7;
        supplierReturn: 8;
        count: 9;
        workOrder: 10;
        suggestion: 11;
        productionTracking: 12;
        customerReturn: 13;
        purchaseOrder: 14;
        productionDeclaration: 15;
        miscellaneousStockInactive: 16;
        supplierInvoice: 17;
        salesCredit: 18;
        miscellaneousReceipt: 19;
        miscellaneousIssue: 20;
        locationChangeInactive: 21;
        intersiteTransferInactive: 22;
        intersiteTransferReceiptInactive: 23;
        transferForSubcontractingInactive: 24;
        receiptForSubcontractingInactive: 25;
        returnToStockInactive: 26;
        putawayPlan: 27;
        qualityControl: 28;
        stockChange: 29;
        valueChange: 30;
        assembly: 31;
        disassembly: 32;
        serviceRequest: 33;
        reorderPlan: 34;
        lotModification: 35;
        subcontractOrder: 36;
        trackingWoWo: 37;
        shipment: 38;
        transport: 39;
        project: 40;
    }
    export type EntryTypeEnum = keyof EntryTypeEnum$Enum;
    export interface ExpirationLeadTimeUnits$Enum {
        calendarDays: 1;
        month: 2;
    }
    export type ExpirationLeadTimeUnits = keyof ExpirationLeadTimeUnits$Enum;
    export interface ExpirationTakenIntoAccount$Enum {
        no: 1;
        yes: 2;
        yesWithMargin: 3;
    }
    export type ExpirationTakenIntoAccount = keyof ExpirationTakenIntoAccount$Enum;
    export interface FiclotvcrStatusSourceDoc$Enum {
        delivery: 1;
        analysisRequest: 2;
    }
    export type FiclotvcrStatusSourceDoc = keyof FiclotvcrStatusSourceDoc$Enum;
    export interface FilterCoefficient$Enum {
        noFilter: 1;
        coefficient2: 2;
        coefficient3: 3;
        coefficient: 4;
    }
    export type FilterCoefficient = keyof FilterCoefficient$Enum;
    export interface FilterLocation$Enum {
        noFilter: 1;
        localLocation: 2;
        location1Product: 3;
        location2Product: 4;
        location3Product: 5;
    }
    export type FilterLocation = keyof FilterLocation$Enum;
    export interface ForecastGrouping$Enum {
        weekByWeek: 1;
        totalOverWeek1: 2;
        totalOverWeek2: 3;
        totalOverWeek3: 4;
        totalOverLastWeek: 5;
    }
    export type ForecastGrouping = keyof ForecastGrouping$Enum;
    export interface InterCompany$Enum {
        displayAll: 1;
        onlyDisplayIntercompanyOrders: 2;
        doNotDisplayIntercompanyOrders: 3;
    }
    export type InterCompany = keyof InterCompany$Enum;
    export interface JournalTypeSelection$Enum {
        allTypes: 1;
        customer: 2;
        salesOrder: 3;
        preparation: 4;
        shipment: 5;
        salesInvoice: 6;
        receipt: 7;
        transfer: 8;
        supplierReturn: 9;
        count: 10;
        workOrder: 11;
        suggestedWorkOrder: 12;
        productionTracking: 13;
        customerReturn: 14;
        purchaseOrder: 15;
        productionDeclaration: 16;
        miscellaneousStockInactive: 17;
        purchaseInvoice: 18;
        salesCredit: 19;
        miscellaneousReceipt: 20;
        miscellaneousIssue: 21;
        locationChange: 22;
        intersiteTransfer: 23;
        intersiteTransferReceipt: 24;
        subcontractTransfer: 25;
        subcontractReceipt: 26;
        stockReturn: 27;
        putAwayPlan: 28;
        qualityControl: 29;
        stockChange: 30;
        valueChange: 31;
        assembly: 32;
        disassembly: 33;
        serviceRequest: 34;
        reorderConsumptionPlan: 35;
        lotModification: 36;
        subcontractOrder: 37;
        trackingWithoutWorkOrder: 38;
    }
    export type JournalTypeSelection = keyof JournalTypeSelection$Enum;
    export interface LabelPrinting$Enum {
        noPrint: 1;
        stockLabel: 2;
        substituteValue3: 3;
        transfertDocument: 4;
        analysisDocument: 5;
        createdContainerLabel: 6;
        stockLabelAndCreatedContainerLabel: 7;
    }
    export type LabelPrinting = keyof LabelPrinting$Enum;
    export interface LateSuggestionEndDate$Enum {
        firstPossibleDate: 1;
        firstPossibleDateLeadtime: 2;
    }
    export type LateSuggestionEndDate = keyof LateSuggestionEndDate$Enum;
    export interface LicensePlateNumberEntry$Enum {
        optional: 1;
        mandatory: 2;
    }
    export type LicensePlateNumberEntry = keyof LicensePlateNumberEntry$Enum;
    export interface LineGrouping$Enum {
        noGrouping: 1;
        groupLinesOnTheScreen: 2;
        stA: 3;
        stQ: 4;
        stAQ: 5;
        stR: 6;
        stAR: 7;
        stQR: 8;
        stAQR: 9;
    }
    export type LineGrouping = keyof LineGrouping$Enum;
    export interface LineType2731$Enum {
        parentProduct: 1;
        component: 2;
    }
    export type LineType2731 = keyof LineType2731$Enum;
    export interface LocalMenu$Enum {
        localMenu1: 1;
        localMenu: 2;
    }
    export type LocalMenu = keyof LocalMenu$Enum;
    export interface LocationCategory$Enum {
        internal: 1;
        dock: 2;
        customer: 3;
        subcontract: 4;
    }
    export type LocationCategory = keyof LocationCategory$Enum;
    export interface LocationTypeSequence$Enum {
        locationTypeAlternateTypes: 1;
        allLocationTypesAlternateTypes: 2;
    }
    export type LocationTypeSequence = keyof LocationTypeSequence$Enum;
    export interface LocationType$Enum {
        dedicatedSingleProduct: 1;
        dedicatedMultipleProduct: 2;
        dynamicSingleProduct: 3;
        dynamicMultipleProduct: 4;
        unlimitedArrangement: 5;
        stockAtBusinessPartner: 6;
        subcontract: 7;
    }
    export type LocationType = keyof LocationType$Enum;
    export interface LotCharacteristicsLevel$Enum {
        sublot: 1;
        lot: 2;
    }
    export type LotCharacteristicsLevel = keyof LotCharacteristicsLevel$Enum;
    export interface LotClassification$Enum {
        byLot: 1;
        fifo: 2;
        fefo: 3;
    }
    export type LotClassification = keyof LotClassification$Enum;
    export interface LotManagementMode$Enum {
        notManaged: 1;
        optionalLot: 2;
        mandatoryLot: 3;
        lotAndSublot: 4;
    }
    export type LotManagementMode = keyof LotManagementMode$Enum;
    export interface LotModifType$Enum {
        lotCharacteristicsModification: 1;
        renumberingMixingAndSplitting: 2;
    }
    export type LotModifType = keyof LotModifType$Enum;
    export interface ManufactureLeadTimeMrpMp$Enum {
        productLeadTimes: 1;
        routingProductLeadTimes: 2;
        alwaysRoutingLeadTimes: 3;
    }
    export type ManufactureLeadTimeMrpMp = keyof ManufactureLeadTimeMrpMp$Enum;
    export interface MaterialCostGroup$Enum {
        materialCost1: 1;
        materialCost2: 2;
        materialCost3: 3;
        materialCost4: 4;
        materialCost5: 5;
        materialCost6: 6;
        materialCost7: 7;
        materialCost8: 8;
        materialCost9: 9;
        materialCost10: 10;
        materialCost11: 11;
        materialCost12: 12;
        materialCost13: 13;
        materialCost14: 14;
        materialCost15: 15;
        materialCost16: 16;
        materialCost17: 17;
        materialCost18: 18;
        materialCost19: 19;
        materialCost20: 20;
    }
    export type MaterialCostGroup = keyof MaterialCostGroup$Enum;
    export interface MaterialRequirementsPlanning$Enum {
        masterProductionPlanning: 1;
        materialRequirementsPlanning: 2;
    }
    export type MaterialRequirementsPlanning = keyof MaterialRequirementsPlanning$Enum;
    export interface ModeOfOperation$Enum {
        group: 1;
        split: 2;
        unlink: 3;
    }
    export type ModeOfOperation = keyof ModeOfOperation$Enum;
    export interface ModificationLotType$Enum {
        renumbering: 1;
        mixing: 2;
    }
    export type ModificationLotType = keyof ModificationLotType$Enum;
    export interface Module750$Enum {
        entry1: 1;
        entry2: 2;
    }
    export type Module750 = keyof Module750$Enum;
    export interface MonthlyStockProcessControl$Enum {
        noControl: 1;
        nonBlockingControl: 2;
        blockingControl: 3;
    }
    export type MonthlyStockProcessControl = keyof MonthlyStockProcessControl$Enum;
    export interface MonthlyStockProcess$Enum {
        noCorrectionOfPreviousMovements: 1;
        correctionOfPreviousMovements: 2;
    }
    export type MonthlyStockProcess = keyof MonthlyStockProcess$Enum;
    export interface MrpPhases$Enum {
        initialization: 1;
        previousPurgeProcess: 2;
        productExtraction: 3;
        unused: 4;
        wipExtraction: 5;
        calculationSuggestions: 6;
        wipUpdate: 7;
        print: 8;
        totalDuration: 9;
    }
    export type MrpPhases = keyof MrpPhases$Enum;
    export interface NoYesIndifferent$Enum {
        no: 1;
        yes: 2;
        indifferent: 3;
    }
    export type NoYesIndifferent = keyof NoYesIndifferent$Enum;
    export interface OccupationCode$Enum {
        free: 1;
        occupied: 2;
        freeOccupied: 3;
    }
    export type OccupationCode = keyof OccupationCode$Enum;
    export interface OptionsVariantsEntry$Enum {
        enter0Or1: 1;
        freeEntry: 2;
        noEntry: 3;
    }
    export type OptionsVariantsEntry = keyof OptionsVariantsEntry$Enum;
    export interface OrdersToBeReplanned$Enum {
        wof: 1;
        wop: 2;
        pof: 3;
        pop: 4;
        trf: 5;
        trp: 6;
        eof: 7;
        eop: 8;
    }
    export type OrdersToBeReplanned = keyof OrdersToBeReplanned$Enum;
    export interface OriginOfPutAwayPlan$Enum {
        awaitingPutAway: 1;
        replenishment: 2;
    }
    export type OriginOfPutAwayPlan = keyof OriginOfPutAwayPlan$Enum;
    export interface PackingSequence$Enum {
        no: 1;
        free: 2;
        newLot: 3;
    }
    export type PackingSequence = keyof PackingSequence$Enum;
    export interface PackingSort$Enum {
        document: 1;
        package: 2;
        deliveredCustomer: 3;
        picker: 4;
    }
    export type PackingSort = keyof PackingSort$Enum;
    export interface PackingType$Enum {
        declarative: 1;
        postpacking: 2;
    }
    export type PackingType = keyof PackingType$Enum;
    export interface PalletContainerManagement$Enum {
        notManaged: 1;
        freeEntry: 2;
        controlledEntry: 3;
        automaticAssignment: 4;
    }
    export type PalletContainerManagement = keyof PalletContainerManagement$Enum;
    export interface PickTicketSorting$Enum {
        shippingDate: 1;
        pickTicketNumber: 2;
        shipToCustomer: 3;
        picker: 4;
    }
    export type PickTicketSorting = keyof PickTicketSorting$Enum;
    export interface PickingNoteSource$Enum {
        order: 1;
        loanOrder: 2;
        subcontractRequirement: 3;
    }
    export type PickingNoteSource = keyof PickingNoteSource$Enum;
    export interface PickingNoteStatus$Enum {
        inProcess: 1;
        deliverable: 2;
        delivered: 3;
        canceled: 4;
    }
    export type PickingNoteStatus = keyof PickingNoteStatus$Enum;
    export interface PlanningTransactions$Enum {
        enterpriseWorkbench: 1;
        productWorkbench: 2;
        orderGrouping: 3;
        operationWorkbench: 4;
        materialIssueWorkbench: 5;
        productionWorkbench: 6;
        materialReturnWorkbench: 7;
        weighingPlan: 8;
        trackingWorkbenchMonitoring: 9;
        technicalRecordWorkbench: 10;
    }
    export type PlanningTransactions = keyof PlanningTransactions$Enum;
    export interface PreparationCodeSetup$Enum {
        substituteValue1: 1;
        product: 2;
        productCategory: 3;
        productGroup1: 4;
        productGroup2: 5;
        productGroup3: 6;
        productGroup4: 7;
        productGroup5: 8;
        customer: 9;
        customerCategory: 10;
        customerGroup1: 11;
        customerGroup2: 12;
        customerGroup3: 13;
        customerGroup4: 14;
        customerGroup5: 15;
    }
    export type PreparationCodeSetup = keyof PreparationCodeSetup$Enum;
    export interface PreparationPlanSort$Enum {
        documentNumber: 1;
        shipmentDate: 2;
        product: 3;
    }
    export type PreparationPlanSort = keyof PreparationPlanSort$Enum;
    export interface PreparationSource$Enum {
        order: 1;
        loanOrder: 2;
        subcontractRepl: 3;
        subcontractShortage: 4;
    }
    export type PreparationSource = keyof PreparationSource$Enum;
    export interface PriceAccount$Enum {
        standardCost: 1;
        revisedStandardCost: 2;
    }
    export type PriceAccount = keyof PriceAccount$Enum;
    export interface PriceColumn$Enum {
        noCalculation: 1;
        formula: 2;
        basePrice: 3;
        priceList: 4;
        standardCost: 5;
        revisedStandardCost: 6;
        lastPrice: 7;
        calculatedByScenario: 8;
        budget: 9;
    }
    export type PriceColumn = keyof PriceColumn$Enum;
    export interface ProductLineFieldTitles$Enum {
        notDefined: 1;
        metal: 2;
        size: 3;
        ground: 4;
        finishing: 5;
        gears: 6;
        chainSets: 7;
        withDecimal: 8;
    }
    export type ProductLineFieldTitles = keyof ProductLineFieldTitles$Enum;
    export interface ProposalType$Enum {
        cancelsAndReplaces: 1;
        complement: 2;
        virtual: 3;
    }
    export type ProposalType = keyof ProposalType$Enum;
    export interface PrototypeOrActiveVersion$Enum {
        no: 1;
        yesExceptOnHold: 2;
        yes: 3;
    }
    export type PrototypeOrActiveVersion = keyof PrototypeOrActiveVersion$Enum;
    export interface PutAwayPlanSituation$Enum {
        awaitingPutAway: 1;
        putAwayPlan: 2;
    }
    export type PutAwayPlanSituation = keyof PutAwayPlanSituation$Enum;
    export interface QtyAssemblyDisassembly$Enum {
        withoutShrinkage: 1;
        withShrinkage: 2;
    }
    export type QtyAssemblyDisassembly = keyof QtyAssemblyDisassembly$Enum;
    export interface QtyPreCharged$Enum {
        allNotAllocatedAllocated: 1;
        notAllocated: 2;
        allocated: 3;
    }
    export type QtyPreCharged = keyof QtyPreCharged$Enum;
    export interface QualityFilter1$Enum {
        statusA: 1;
        statusQ: 2;
        statusAq: 3;
        statusR: 4;
        statusAr: 5;
        statusQr: 6;
        statusAqr: 7;
    }
    export type QualityFilter1 = keyof QualityFilter1$Enum;
    export interface QualityFilter$Enum {
        a: 1;
        q: 2;
        aQ: 3;
        r: 4;
        aR: 5;
        qR: 6;
        aQR: 7;
    }
    export type QualityFilter = keyof QualityFilter$Enum;
    export interface QuantityType$Enum {
        physicalQuantity: 1;
        activeQuantity: 2;
    }
    export type QuantityType = keyof QuantityType$Enum;
    export interface RePlanningSelection$Enum {
        noProcessing: 1;
        messagesOnly: 2;
        simulation: 3;
    }
    export type RePlanningSelection = keyof RePlanningSelection$Enum;
    export interface ReleaseModeManagement$Enum {
        immediately: 1;
        temporarilyBlocked: 2;
        blocked: 3;
    }
    export type ReleaseModeManagement = keyof ReleaseModeManagement$Enum;
    export interface ReorderCalculationMethod$Enum {
        entered: 1;
        calculated: 2;
    }
    export type ReorderCalculationMethod = keyof ReorderCalculationMethod$Enum;
    export interface ReorderSelectionOutsideOfM$Enum {
        no: 1;
        yes: 2;
        calculationOnly: 3;
    }
    export type ReorderSelectionOutsideOfM = keyof ReorderSelectionOutsideOfM$Enum;
    export interface ReorderSituation$Enum {
        waitingReorder: 1;
        reorderPlan: 2;
    }
    export type ReorderSituation = keyof ReorderSituation$Enum;
    export interface ReorderingManagementMode$Enum {
        notManaged: 1;
        byMrp: 2;
        byMps: 3;
        byRop: 4;
        byPeriod: 5;
    }
    export type ReorderingManagementMode = keyof ReorderingManagementMode$Enum;
    export interface ReplanDate$Enum {
        none: 1;
        early: 2;
        late: 3;
        earlyLate: 4;
    }
    export type ReplanDate = keyof ReplanDate$Enum;
    export interface ReplanQuantities$Enum {
        none: 1;
        decrease: 2;
        increase: 3;
        decreaseIncrease: 4;
    }
    export type ReplanQuantities = keyof ReplanQuantities$Enum;
    export interface ReplanningSortOrder$Enum {
        byProduct: 1;
        byOrderType: 2;
        byMessageType: 3;
        byDate: 4;
    }
    export type ReplanningSortOrder = keyof ReplanningSortOrder$Enum;
    export interface ReplenishmentSource$Enum {
        replenishment: 1;
        consumption: 2;
        shortage: 3;
    }
    export type ReplenishmentSource = keyof ReplenishmentSource$Enum;
    export interface SafetyStockReconstitution$Enum {
        always: 1;
        atFirstRequirement: 2;
    }
    export type SafetyStockReconstitution = keyof SafetyStockReconstitution$Enum;
    export interface ScenarioLineType$Enum {
        selectParentProduct: 1;
        createParentProduct: 2;
        selectComponents: 3;
        listComponents: 4;
        createComponents: 5;
        unused: 6;
        listOperations: 7;
        createOperations: 8;
        finalControls: 9;
    }
    export type ScenarioLineType = keyof ScenarioLineType$Enum;
    export interface SearchEquivalence$Enum {
        noSearch: 1;
        searchEquivalence: 2;
        alwaysCreate: 3;
        searchAutomaticSelection: 4;
    }
    export type SearchEquivalence = keyof SearchEquivalence$Enum;
    export interface SegmentTypeEdi$Enum {
        moaMonetaryAmount: 1;
        pcdPercentage: 2;
        qtyQuantity: 3;
        cuxCurrency: 4;
        dtmDate: 5;
        rffReference: 6;
        nadCtaComAddress: 7;
        ftxText: 8;
        cciCavOgaOrganization: 9;
        notManaged: 10;
    }
    export type SegmentTypeEdi = keyof SegmentTypeEdi$Enum;
    export interface SelectDateOfPutAwayPlan$Enum {
        creationDate: 1;
        allocationDate: 2;
    }
    export type SelectDateOfPutAwayPlan = keyof SelectDateOfPutAwayPlan$Enum;
    export interface SelectStockMovementDates$Enum {
        creationDate: 1;
        allocationDate: 2;
    }
    export type SelectStockMovementDates = keyof SelectStockMovementDates$Enum;
    export interface SelectionClassification$Enum {
        productNumber: 1;
        orderNumber: 2;
        subcontractor: 3;
    }
    export type SelectionClassification = keyof SelectionClassification$Enum;
    export interface SelectionOfSerialNos$Enum {
        add: 1;
        subtract: 2;
    }
    export type SelectionOfSerialNos = keyof SelectionOfSerialNos$Enum;
    export interface SequenceOfLots$Enum {
        byLot: 1;
        fifo: 2;
        fefo: 3;
        lifo: 4;
    }
    export type SequenceOfLots = keyof SequenceOfLots$Enum;
    export interface SequenceSelection$Enum {
        productNumber: 1;
        productDescription: 2;
        searchKey: 3;
        productLine: 4;
        cfgDocumentNumber: 5;
    }
    export type SequenceSelection = keyof SequenceSelection$Enum;
    export interface SerialNumberCount$Enum {
        none: 1;
        notControlled: 2;
        validated: 3;
    }
    export type SerialNumberCount = keyof SerialNumberCount$Enum;
    export interface SortByCoef$Enum {
        no: 1;
        descending: 2;
        ascending: 3;
    }
    export type SortByCoef = keyof SortByCoef$Enum;
    export interface SortPutAwayPlan$Enum {
        none: 1;
        allocationDate: 2;
        product: 3;
        location: 4;
        journalTypeNumber: 5;
    }
    export type SortPutAwayPlan = keyof SortPutAwayPlan$Enum;
    export interface StockChangeAccess$Enum {
        stockLine: 1;
        containerNumber: 2;
    }
    export type StockChangeAccess = keyof StockChangeAccess$Enum;
    export interface StockCountDetailStatus$Enum {
        toBeCounted: 1;
        counted: 2;
        abandoned: 3;
        validated: 4;
    }
    export type StockCountDetailStatus = keyof StockCountDetailStatus$Enum;
    export interface StockCountGroupingStatus$Enum {
        toBeCounted: 1;
        counted: 2;
        abandon: 3;
        validated: 4;
        substituteValue5: 5;
        substituteValue6: 6;
        insertNull: 7;
        partialCount: 8;
        substituteValue9: 9;
        partialValidation: 10;
    }
    export type StockCountGroupingStatus = keyof StockCountGroupingStatus$Enum;
    export interface StockCountLinesSelection$Enum {
        all: 1;
        counted: 2;
        toBeCounted: 3;
        countedWithVariances: 4;
        counted1: 5;
        counted2: 6;
    }
    export type StockCountLinesSelection = keyof StockCountLinesSelection$Enum;
    export interface StockCountListChoice$Enum {
        manualSelection: 1;
        cycleStockCount: 2;
        annualStockCount: 3;
    }
    export type StockCountListChoice = keyof StockCountListChoice$Enum;
    export interface StockCountSessionStatus$Enum {
        inCreation: 1;
        toBeCounted: 2;
        closed: 3;
    }
    export type StockCountSessionStatus = keyof StockCountSessionStatus$Enum;
    export interface StockCountStatusList$Enum {
        toBeCounted: 1;
        cancelled: 2;
        counted: 3;
        partialValidation: 4;
        validated: 5;
        closed: 6;
    }
    export type StockCountStatusList = keyof StockCountStatusList$Enum;
    export interface StockCountType$Enum {
        product: 1;
        locations: 2;
    }
    export type StockCountType = keyof StockCountType$Enum;
    export interface StockDataCalculationErrors$Enum {
        nullCalculationResult: 1;
        insufficientHistory: 2;
        undefinedHistoryProcessing: 3;
        undefinedServiceRate: 4;
        absentServiceRate: 5;
        nullOrderProcessingCost: 6;
        nullStockCarryingCost: 7;
        nullProductStandardCost: 8;
    }
    export type StockDataCalculationErrors = keyof StockDataCalculationErrors$Enum;
    export interface StockInquiries$Enum {
        stockBySite: 1;
        stockByLotLocation: 2;
        lotLocationDetails: 3;
        locationsByWarehouse: 4;
        dedicatedLocations: 5;
        locationsByProduct: 6;
        substituteValue7: 7;
        substituteValue8: 8;
        expiredStock: 9;
        serialNumbers: 10;
        stockTransactions: 11;
        stockAtDate: 12;
        projectedStock: 13;
        forwardTraceability: 14;
        backwardTraceability: 15;
        suspendedTransactions: 16;
        productsBeingCounted: 17;
        availableStock: 18;
        documentTraceability: 19;
        majorVersions: 20;
        minorVersions: 21;
    }
    export type StockInquiries = keyof StockInquiries$Enum;
    export interface StockInquiryClassification$Enum {
        site: 1;
        product: 2;
        lot: 3;
        location: 4;
        status: 5;
        unit: 6;
        allocationDate7: 7;
        serialNumber: 8;
        allocationDate: 9;
        dateCreated10: 10;
        dateCreated: 11;
        identifier1: 12;
    }
    export type StockInquiryClassification = keyof StockInquiryClassification$Enum;
    export interface StockIssueCode$Enum {
        byLot: 1;
        fifo: 2;
        fefo: 3;
    }
    export type StockIssueCode = keyof StockIssueCode$Enum;
    export interface StockMovementDateChoice$Enum {
        creationDate: 1;
        allocationDate: 2;
        postingDate: 3;
    }
    export type StockMovementDateChoice = keyof StockMovementDateChoice$Enum;
    export interface StockMovementType$Enum {
        allReceipts: 1;
        allIssues: 2;
        miscellaneousReceipts: 3;
        miscellaneousIssues: 4;
        supplierReceipts: 5;
        customerShipments: 6;
        workOrderReceipts: 7;
        workOrderIssues: 8;
        locationChange: 9;
        qualityControl: 10;
        statusChange: 11;
        intersiteTransferReceipt: 12;
        returnOfReceipt: 13;
        deliveryReturn: 14;
        counting: 15;
        intersiteTransfer: 16;
        transferForSubcontracting: 17;
        receiptForSubcontracting: 18;
        loanDelivery: 19;
        loanReturn: 20;
        returnToStock: 21;
    }
    export type StockMovementType = keyof StockMovementType$Enum;
    export interface StockMvtOrigin$Enum {
        aucun: 1;
        documentOfOrigin: 2;
        ligneDocument: 3;
        receipts: 4;
        document: 5;
    }
    export type StockMvtOrigin = keyof StockMvtOrigin$Enum;
    export interface StockPosting$Enum {
        no: 1;
        yes: 2;
        yesAutoDeletion: 3;
    }
    export type StockPosting = keyof StockPosting$Enum;
    export interface StockSearchFilter$Enum {
        none: 1;
        location: 2;
        lot: 3;
        sublot: 4;
        serial: 5;
        status: 6;
        packingUnit: 7;
        pacStkConversionFactor: 8;
        identifier1: 9;
        identifier2: 10;
        licensePlateNumber: 11;
        customField1: 12;
        customField2: 13;
    }
    export type StockSearchFilter = keyof StockSearchFilter$Enum;
    export interface StockSequenceNumbers$Enum {
        chronologicalStock: 1;
        qualityAnalysis: 2;
        chronologicalFifo: 3;
        palletNumbers: 4;
        containerNumbers: 5;
        transfers: 6;
        counts: 7;
        globalLotNumber: 8;
        wipHistory: 9;
        miscellaneousReceiptTransactionDocument: 10;
        miscellaneousIssueTransactionDocument: 11;
        configurator: 12;
        serialNumber: 13;
        stockCountSessions: 14;
        stockChanges: 15;
        putAwayPlanReport: 16;
        assembly: 17;
        disassembly: 18;
        putAwayPlanReorderPlan: 19;
        consumptionAreaReorder: 20;
        suggestions: 21;
        valueChange: 22;
        pickingList: 23;
        pickTicket: 24;
        packingPackageNumber: 25;
    }
    export type StockSequenceNumbers = keyof StockSequenceNumbers$Enum;
    export interface StockShortageAdjustment$Enum {
        noProcess: 1;
        suspendedTransactions: 2;
        backordersMaterialIssues: 3;
        backordersSalesOrders: 4;
    }
    export type StockShortageAdjustment = keyof StockShortageAdjustment$Enum;
    export interface StockStatusEnum$Enum {
        accepted: 1;
        qualityControl: 2;
        rejected: 3;
    }
    export type StockStatusEnum = keyof StockStatusEnum$Enum;
    export interface StockTakeSequence$Enum {
        productLocation: 1;
        locationProduct: 2;
    }
    export type StockTakeSequence = keyof StockTakeSequence$Enum;
    export interface StockTransactionStatus$Enum {
        updated: 1;
        suspended: 2;
    }
    export type StockTransactionStatus = keyof StockTransactionStatus$Enum;
    export interface StockTransactionType$Enum {
        miscellaneousReceipt: 1;
        miscellaneousIssue: 2;
        supplierReceipt: 3;
        customerDelivery: 4;
        workOrderReceipt: 5;
        workOrderIssue: 6;
        locationChange: 7;
        qualityControl: 8;
        statusChange: 9;
        intersiteTransferReceiptNotActive: 10;
        receiptReturn: 11;
        deliveryReturn: 12;
        count: 13;
        intersiteTransfer: 14;
        transferForSubcontractNotActive: 15;
        subcontractReceipt: 16;
        loanDelivery: 17;
        loanDeliveryReturn: 18;
        stockReturn: 19;
        subcontractDelivery: 20;
        resplitting: 21;
        putawayPlan: 22;
        valueChange: 23;
        serviceRequest: 24;
        replenishment: 25;
        stockChange: 26;
        internalTransferIssue: 27;
        internalTransferReceipt: 28;
        subcontractIssue: 29;
        loanReceiptNotActive: 30;
        loanReceiptReturnNotActive: 31;
        subcontractReceiptReturn: 32;
        subcontractDeliveryReturn: 33;
        analysisRequest: 34;
        stockValueAdjustment: 35;
        licensePlateNumberChange: 36;
    }
    export type StockTransactionType = keyof StockTransactionType$Enum;
    export interface StockTransactionValidation$Enum {
        noValidation: 1;
        withoutSummary: 2;
        withSummary: 3;
    }
    export type StockTransactionValidation = keyof StockTransactionValidation$Enum;
    export interface StockUserDefinedFields$Enum {
        lotCustomText1: 1;
        lotCustomText2: 2;
        lotCustomNumber: 3;
        lotCustomDate: 4;
    }
    export type StockUserDefinedFields = keyof StockUserDefinedFields$Enum;
    export interface StockVersionMode$Enum {
        no: 1;
        major: 2;
        majorAndMinor: 3;
    }
    export type StockVersionMode = keyof StockVersionMode$Enum;
    export interface StorageLocationCode$Enum {
        empty: 1;
        occupied: 2;
        full: 3;
    }
    export type StorageLocationCode = keyof StorageLocationCode$Enum;
    export interface SubcontractType$Enum {
        site: 1;
        supplier: 2;
    }
    export type SubcontractType = keyof SubcontractType$Enum;
    export interface SuggestedLocation$Enum {
        none: 1;
        storageLocation: 2;
        receivingLocation: 3;
        pickingLocation: 4;
        floorStockLocation: 5;
        bpLocation: 6;
    }
    export type SuggestedLocation = keyof SuggestedLocation$Enum;
    export interface SuggestedLocations$Enum {
        allLocations: 1;
        basedOnProductSetup: 2;
    }
    export type SuggestedLocations = keyof SuggestedLocations$Enum;
    export interface SuggestionSplitting$Enum {
        none: 1;
        parallel: 2;
        successive: 3;
    }
    export type SuggestionSplitting = keyof SuggestionSplitting$Enum;
    export interface SupplyType$Enum {
        external: 1;
        internalIntersite: 2;
        externalAndInternal: 3;
    }
    export type SupplyType = keyof SupplyType$Enum;
    export interface SymbolControl$Enum {
        noControl: 1;
        listOfValues: 2;
        table: 3;
        formsTemplates: 4;
        ranges: 5;
        miscellaneousTable: 6;
    }
    export type SymbolControl = keyof SymbolControl$Enum;
    export interface SymbolType$Enum {
        question: 1;
        variable: 2;
        scenario: 3;
        selection: 4;
        optionsVariants: 5;
        linkTable: 6;
        procedure: 7;
        message: 8;
        formsTemplates: 9;
        free10: 10;
        comment: 11;
        entryPoint: 12;
        masterProduct: 13;
        productSite: 14;
        productTotals: 15;
        soldProducts: 16;
        bomHeader: 17;
        bomDetail: 18;
        routeHeader: 19;
        routeOperation: 20;
        productSales: 21;
        operationScheduling: 22;
        productCosts: 23;
        materialCost: 24;
        machineCost: 25;
        laborCost: 26;
        subcontractCost: 27;
        supplierProduct: 28;
        free: 29;
        formula: 30;
    }
    export type SymbolType = keyof SymbolType$Enum;
    export interface TakeQcStockIntoAccount$Enum {
        no: 1;
        yesInStartingStock: 2;
        yesAtDateEndControl: 3;
    }
    export type TakeQcStockIntoAccount = keyof TakeQcStockIntoAccount$Enum;
    export interface TitleOfLocationForStockManagementRules$Enum {
        v0: 1;
        receipt: 2;
        stock: 3;
        picking: 4;
        workstation: 5;
        delivery: 6;
        store: 7;
        customerReturn: 8;
        returnFromReturn: 9;
        toBeDefined: 10;
        toBeDefined1: 11;
        toBeDefined2: 12;
    }
    export type TitleOfLocationForStockManagementRules = keyof TitleOfLocationForStockManagementRules$Enum;
    export interface TitleOfLocation$Enum {
        receipt: 1;
        stock: 2;
        picking: 3;
        workstation: 4;
        delivery: 5;
        store: 6;
        customerReturn: 7;
        returnFromReturn: 8;
        toBeDefined: 9;
        toBeDefined1: 10;
        toBeDefined2: 11;
    }
    export type TitleOfLocation = keyof TitleOfLocation$Enum;
    export interface TraceLevelInStockUpdates$Enum {
        noTrace: 1;
        standardTraceMessages: 2;
        detailedTraceTableUpdates: 3;
        detailedTraceFieldUpdates: 4;
    }
    export type TraceLevelInStockUpdates = keyof TraceLevelInStockUpdates$Enum;
    export interface TraceabilityLevel$Enum {
        byDefault: 1;
        lot: 2;
        subLot: 3;
        serialNumber: 4;
    }
    export type TraceabilityLevel = keyof TraceabilityLevel$Enum;
    export interface TraceabilityManagementMode$Enum {
        noTraceability: 1;
        detailedTraceability: 2;
        summaryTraceability: 3;
    }
    export type TraceabilityManagementMode = keyof TraceabilityManagementMode$Enum;
    export interface TransactionLocationManagemen$Enum {
        noEntry: 1;
        freeEntry: 2;
        accordingToProduct: 3;
        accordingToTransaction: 4;
        automatic: 5;
    }
    export type TransactionLocationManagemen = keyof TransactionLocationManagemen$Enum;
    export interface TransactionLotManagement$Enum {
        free: 1;
        newLot: 2;
        supplierLot: 3;
        receiptNumberWorkOrderNumber: 4;
        fifoAllLots: 5;
        fifoUnexpiredLots: 6;
        fifoExpiredLots: 7;
        fefoAllLots: 8;
        fefoUnexpiredLots: 9;
        fefoExpiredLots: 10;
        accordingToProduct: 11;
    }
    export type TransactionLotManagement = keyof TransactionLotManagement$Enum;
    export interface TransactionStatus$Enum {
        accordingToProductOrder: 1;
        statusA: 2;
        statusQ: 3;
        statusAQ: 4;
        statusR: 5;
        statusAR: 6;
        statusQR: 7;
        statusAQR: 8;
    }
    export type TransactionStatus = keyof TransactionStatus$Enum;
    export interface TransactionTypeSelection$Enum {
        allTypes: 1;
        miscellaneousReceipt: 2;
        miscellaneousIssue: 3;
        supplierReceipt: 4;
        customerShipment: 5;
        workOrderReceipt: 6;
        workOrderIssue: 7;
        locationChange: 8;
        qualityControl: 9;
        statusChange: 10;
        transferReceipt: 11;
        returnReceipt: 12;
        deliveryReturn: 13;
        stockCount: 14;
    }
    export type TransactionTypeSelection = keyof TransactionTypeSelection$Enum;
    export interface TransferReplenishmentStatus$Enum {
        pending: 1;
        allocated: 2;
        beingShipped: 3;
    }
    export type TransferReplenishmentStatus = keyof TransferReplenishmentStatus$Enum;
    export interface TransferSelection$Enum {
        site: 1;
        customer: 2;
        supplier: 3;
    }
    export type TransferSelection = keyof TransferSelection$Enum;
    export interface TypeOfCalculationTable$Enum {
        simpleCalculationTable: 1;
        conversionTable: 2;
        doubleEntryTable: 3;
    }
    export type TypeOfCalculationTable = keyof TypeOfCalculationTable$Enum;
    export interface TypeOfCostCalculation$Enum {
        noCalculation: 1;
        productCost: 2;
        referenceProductCost: 3;
        zeroCost: 4;
        priceNotFound: 5;
        calculated: 6;
        zeroCalculated: 7;
        intermediateCalculation: 8;
    }
    export type TypeOfCostCalculation = keyof TypeOfCostCalculation$Enum;
    export interface TypeOfStockTransaction$Enum {
        miscellaneousReceipt: 1;
        miscellaneousIssue: 2;
        stockChange: 3;
        lotModification: 4;
        putawayPlan: 5;
        counting: 6;
        assemblyDisassembly: 7;
        qualityControl: 8;
        reorderPlan: 9;
        shipmentPickingPlan: 10;
        packing: 11;
        pickTickets: 12;
    }
    export type TypeOfStockTransaction = keyof TypeOfStockTransaction$Enum;
    export interface ValuationMethod758$Enum {
        none: 1;
        managementControl: 2;
        specific: 3;
    }
    export type ValuationMethod758 = keyof ValuationMethod758$Enum;
    export interface ValuationMethod$Enum {
        standardCost: 1;
        revisedStandardCost: 2;
        lastCost: 3;
        movingAverageCost: 4;
        fifoCost: 5;
        averageLotCost: 6;
        orderCost: 7;
        lifoCost: 8;
        primaryIssueMethod: 9;
        budgetCost: 10;
        simulatedCost: 11;
        priceList: 12;
        secondaryIssueMethod: 13;
    }
    export type ValuationMethod = keyof ValuationMethod$Enum;
    export interface ValuationVarianceAbsorption$Enum {
        no: 1;
        absorptionOnSite: 2;
        absorptionOnSiteLot: 3;
    }
    export type ValuationVarianceAbsorption = keyof ValuationVarianceAbsorption$Enum;
    export interface ValueChange$Enum {
        global: 1;
        fifo: 2;
        lot: 3;
    }
    export type ValueChange = keyof ValueChange$Enum;
    export interface VersionEntered$Enum {
        exclusive: 1;
        priority: 2;
    }
    export type VersionEntered = keyof VersionEntered$Enum;
    export interface VersionStopped$Enum {
        no: 1;
        noUnlessException: 2;
        yes: 3;
    }
    export type VersionStopped = keyof VersionStopped$Enum;
    export interface WipClassification$Enum {
        byProduct: 1;
        byOrderType: 2;
        byDocumentType: 3;
    }
    export type WipClassification = keyof WipClassification$Enum;
    export interface WipProtection$Enum {
        no: 1;
        always: 2;
        accordingToProduct: 3;
    }
    export type WipProtection = keyof WipProtection$Enum;
    export interface LicensePlateNumber extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        stockSite: Site;
        warehouse: Warehouse;
        locationType: string;
        location: Location;
        container: Container;
        isActive: boolean;
        isSingleProduct: boolean;
        isSingleLot: boolean;
        firstDateOfUse: string;
        lastDateOfUse: string;
        masterLicensePlateNumber: LicensePlateNumber;
        status: ContainerStatus;
        isPrinted: boolean;
        documentEntryType: EntryTypeEnum;
        documentEntry: string;
        stock: ClientCollection<Stock>;
    }
    export interface LicensePlateNumberInput extends ClientNodeInput {
        code?: string;
        stockSite?: string;
        warehouse?: string;
        locationType?: string;
        location?: string;
        container?: string;
        isActive?: boolean | string;
        isSingleProduct?: boolean | string;
        isSingleLot?: boolean | string;
        firstDateOfUse?: string;
        lastDateOfUse?: string;
        masterLicensePlateNumber?: string;
        status?: ContainerStatus;
        isPrinted?: boolean | string;
        documentEntryType?: EntryTypeEnum;
        documentEntry?: string;
    }
    export interface LicensePlateNumberBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        stockSite: Site;
        warehouse: Warehouse;
        locationType: string;
        location: Location;
        container: Container;
        isActive: boolean;
        isSingleProduct: boolean;
        isSingleLot: boolean;
        firstDateOfUse: string;
        lastDateOfUse: string;
        masterLicensePlateNumber: LicensePlateNumber;
        status: ContainerStatus;
        isPrinted: boolean;
        documentEntryType: EntryTypeEnum;
        documentEntry: string;
        stock: ClientCollection<Stock>;
    }
    export interface LicensePlateNumber$Lookups {
        stockSite: QueryOperation<Site>;
        warehouse: QueryOperation<Warehouse>;
        location: QueryOperation<Location>;
        container: QueryOperation<Container>;
        masterLicensePlateNumber: QueryOperation<LicensePlateNumber>;
    }
    export interface LicensePlateNumber$Operations {
        query: QueryOperation<LicensePlateNumber>;
        read: ReadOperation<LicensePlateNumber>;
        aggregate: {
            read: AggregateReadOperation<LicensePlateNumber>;
            query: AggregateQueryOperation<LicensePlateNumber>;
        };
        lookups(dataOrId: string | { data: LicensePlateNumberInput }): LicensePlateNumber$Lookups;
        getDefaults: GetDefaultsOperation<LicensePlateNumber>;
    }
    export interface Location extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        warehouse: Warehouse;
        availability: StorageLocationCode;
        type: string;
        category: LocationCategory;
        isSingleProduct: boolean;
        isDedicated: boolean;
        authorizedSubstatus: string;
        isBlocked: boolean;
        isBeingCounted: boolean;
        stock: ClientCollection<Stock>;
    }
    export interface LocationInput extends ClientNodeInput {
        stockSite?: string;
        code?: string;
        warehouse?: string;
        availability?: StorageLocationCode;
        type?: string;
        category?: LocationCategory;
        isSingleProduct?: boolean | string;
        isDedicated?: boolean | string;
        authorizedSubstatus?: string;
        isBlocked?: boolean | string;
        isBeingCounted?: boolean | string;
    }
    export interface LocationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        warehouse: Warehouse;
        availability: StorageLocationCode;
        type: string;
        category: LocationCategory;
        isSingleProduct: boolean;
        isDedicated: boolean;
        authorizedSubstatus: string;
        isBlocked: boolean;
        isBeingCounted: boolean;
        stock: ClientCollection<Stock>;
    }
    export interface Location$Lookups {
        stockSite: QueryOperation<Site>;
        warehouse: QueryOperation<Warehouse>;
    }
    export interface Location$Operations {
        query: QueryOperation<Location>;
        read: ReadOperation<Location>;
        aggregate: {
            read: AggregateReadOperation<Location>;
            query: AggregateQueryOperation<Location>;
        };
        lookups(dataOrId: string | { data: LocationInput }): Location$Lookups;
        getDefaults: GetDefaultsOperation<Location>;
    }
    export interface Lot extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        code: string;
        sublot: string;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        supplierLot: string;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        lotCreationDate: string;
        expirationReferenceDate: string;
        shelfLife: integer;
        expirationDate: string;
        potency: string;
        internationalUnitPotency: string;
        supplier: Supplier;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        checkLeadTime: integer;
        recontrolDate: string;
        useByDateCoefficient: string;
        useByDate: string;
        controlDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        stock: ClientCollection<Stock>;
    }
    export interface LotInput extends ClientNodeInput {
        product?: string;
        code?: string;
        sublot?: string;
        documentType?: EntryTypeEnum;
        documentId?: string;
        documentLine?: integer | string;
        supplierLot?: string;
        lotCustomField1?: string;
        lotCustomField2?: string;
        lotCustomField3?: decimal | string;
        lotCustomField4?: string;
        lotCreationDate?: string;
        expirationReferenceDate?: string;
        shelfLife?: integer | string;
        expirationDate?: string;
        potency?: decimal | string;
        internationalUnitPotency?: decimal | string;
        supplier?: string;
        expirationTimeUnit?: ExpirationLeadTimeUnits;
        recontrolTimeUnit?: ExpirationLeadTimeUnits;
        checkLeadTime?: integer | string;
        recontrolDate?: string;
        useByDateCoefficient?: decimal | string;
        useByDate?: string;
        controlDate?: string;
        majorVersion?: string;
        minorVersion?: string;
    }
    export interface LotBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        code: string;
        sublot: string;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        supplierLot: string;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        lotCreationDate: string;
        expirationReferenceDate: string;
        shelfLife: integer;
        expirationDate: string;
        potency: string;
        internationalUnitPotency: string;
        supplier: Supplier;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        checkLeadTime: integer;
        recontrolDate: string;
        useByDateCoefficient: string;
        useByDate: string;
        controlDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        stock: ClientCollection<Stock>;
    }
    export interface Lot$Lookups {
        product: QueryOperation<Product>;
        supplier: QueryOperation<Supplier>;
        majorVersion: QueryOperation<MajorVersionStatus>;
    }
    export interface Lot$Operations {
        query: QueryOperation<Lot>;
        read: ReadOperation<Lot>;
        aggregate: {
            read: AggregateReadOperation<Lot>;
            query: AggregateQueryOperation<Lot>;
        };
        lookups(dataOrId: string | { data: LotInput }): Lot$Lookups;
        getDefaults: GetDefaultsOperation<Lot>;
    }
    export interface LotsSites extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        lot: string;
        sublot: string;
        storageSite: Site;
        acceptedQuantityAStatus: string;
        qcQStatus: string;
        rejectedQuantityRStatus: string;
        averageCost: string;
        aucBaseQuantity: string;
        aucBaseAmount: string;
        mapSubConCost: string;
        invoicingElement: string;
        mapMaterialOh: string;
        mapMachineOh: string;
        mapLaborOh: string;
        mapSubConOh: string;
        mapSubConCost1: string;
        invoicingElement1: string;
        mapMaterialOh1: string;
        mapMachineOh1: string;
        mapLaborOh1: string;
        mapSubConOh1: string;
        lastReceiptDate: string;
        lastIssueDate: string;
        lastCountDate: string;
        stock: ClientCollection<Stock>;
    }
    export interface LotsSitesInput extends ClientNodeInput {
        product?: string;
        lot?: string;
        sublot?: string;
        storageSite?: string;
        acceptedQuantityAStatus?: decimal | string;
        qcQStatus?: decimal | string;
        rejectedQuantityRStatus?: decimal | string;
        averageCost?: decimal | string;
        aucBaseQuantity?: decimal | string;
        aucBaseAmount?: decimal | string;
        mapSubConCost?: decimal | string;
        invoicingElement?: decimal | string;
        mapMaterialOh?: decimal | string;
        mapMachineOh?: decimal | string;
        mapLaborOh?: decimal | string;
        mapSubConOh?: decimal | string;
        mapSubConCost1?: decimal | string;
        invoicingElement1?: decimal | string;
        mapMaterialOh1?: decimal | string;
        mapMachineOh1?: decimal | string;
        mapLaborOh1?: decimal | string;
        mapSubConOh1?: decimal | string;
        lastReceiptDate?: string;
        lastIssueDate?: string;
        lastCountDate?: string;
        stock?: Partial<StockInput>[];
    }
    export interface LotsSitesBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        lot: string;
        sublot: string;
        storageSite: Site;
        acceptedQuantityAStatus: string;
        qcQStatus: string;
        rejectedQuantityRStatus: string;
        averageCost: string;
        aucBaseQuantity: string;
        aucBaseAmount: string;
        mapSubConCost: string;
        invoicingElement: string;
        mapMaterialOh: string;
        mapMachineOh: string;
        mapLaborOh: string;
        mapSubConOh: string;
        mapSubConCost1: string;
        invoicingElement1: string;
        mapMaterialOh1: string;
        mapMachineOh1: string;
        mapLaborOh1: string;
        mapSubConOh1: string;
        lastReceiptDate: string;
        lastIssueDate: string;
        lastCountDate: string;
        stock: ClientCollection<Stock>;
    }
    export interface LotsSites$Lookups {
        product: QueryOperation<Product>;
        storageSite: QueryOperation<Site>;
    }
    export interface LotsSites$Operations {
        query: QueryOperation<LotsSites>;
        read: ReadOperation<LotsSites>;
        aggregate: {
            read: AggregateReadOperation<LotsSites>;
            query: AggregateQueryOperation<LotsSites>;
        };
        lookups(dataOrId: string | { data: LotsSitesInput }): LotsSites$Lookups;
        getDefaults: GetDefaultsOperation<LotsSites>;
    }
    export interface MajorVersionStatus extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        code: string;
        description: string;
        shortDescription: string;
        status: VersionStatus;
        startDate: string;
        endDate: string;
        isSubjectToException: boolean;
        exceptionDate: string;
        isOnHold: boolean;
        minorVersions: ClientCollection<ProductVersion>;
    }
    export interface MajorVersionStatusInput extends ClientNodeInput {
        product?: string;
        code?: string;
        description?: string;
        shortDescription?: string;
        status?: VersionStatus;
        startDate?: string;
        endDate?: string;
        isSubjectToException?: boolean | string;
        exceptionDate?: string;
        isOnHold?: boolean | string;
        minorVersions?: Partial<ProductVersionInput>[];
    }
    export interface MajorVersionStatusBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        code: string;
        description: string;
        shortDescription: string;
        status: VersionStatus;
        startDate: string;
        endDate: string;
        isSubjectToException: boolean;
        exceptionDate: string;
        isOnHold: boolean;
        minorVersions: ClientCollection<ProductVersion>;
    }
    export interface MajorVersionStatus$Lookups {
        product: QueryOperation<Product>;
    }
    export interface MajorVersionStatus$Operations {
        query: QueryOperation<MajorVersionStatus>;
        read: ReadOperation<MajorVersionStatus>;
        aggregate: {
            read: AggregateReadOperation<MajorVersionStatus>;
            query: AggregateQueryOperation<MajorVersionStatus>;
        };
        lookups(dataOrId: string | { data: MajorVersionStatusInput }): MajorVersionStatus$Lookups;
        getDefaults: GetDefaultsOperation<MajorVersionStatus>;
    }
    export interface MobileSettings extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        flowType: AdcFlowType;
        stockField1: StockSearchFilter;
        stockField2: StockSearchFilter;
        stockField3: StockSearchFilter;
        stockField4: StockSearchFilter;
        stockField5: StockSearchFilter;
        stockField6: StockSearchFilter;
        stockField7: StockSearchFilter;
        stockField8: StockSearchFilter;
    }
    export interface MobileSettingsInput extends ClientNodeInput {
        stockSite?: string;
        flowType?: AdcFlowType;
        stockField1?: StockSearchFilter;
        stockField2?: StockSearchFilter;
        stockField3?: StockSearchFilter;
        stockField4?: StockSearchFilter;
        stockField5?: StockSearchFilter;
        stockField6?: StockSearchFilter;
        stockField7?: StockSearchFilter;
        stockField8?: StockSearchFilter;
    }
    export interface MobileSettingsBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        flowType: AdcFlowType;
        stockField1: StockSearchFilter;
        stockField2: StockSearchFilter;
        stockField3: StockSearchFilter;
        stockField4: StockSearchFilter;
        stockField5: StockSearchFilter;
        stockField6: StockSearchFilter;
        stockField7: StockSearchFilter;
        stockField8: StockSearchFilter;
    }
    export interface MobileSettings$Lookups {
        stockSite: QueryOperation<Site>;
    }
    export interface MobileSettings$Operations {
        query: QueryOperation<MobileSettings>;
        read: ReadOperation<MobileSettings>;
        aggregate: {
            read: AggregateReadOperation<MobileSettings>;
            query: AggregateQueryOperation<MobileSettings>;
        };
        lookups(dataOrId: string | { data: MobileSettingsInput }): MobileSettings$Lookups;
        getDefaults: GetDefaultsOperation<MobileSettings>;
    }
    export interface OverheadFormulaCodes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        overhead: string;
        trigger: Trigger;
    }
    export interface OverheadFormulaCodesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        overhead?: string;
        trigger?: Trigger;
    }
    export interface OverheadFormulaCodesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        overhead: string;
        trigger: Trigger;
    }
    export interface OverheadFormulaCodes$Operations {
        query: QueryOperation<OverheadFormulaCodes>;
        read: ReadOperation<OverheadFormulaCodes>;
        aggregate: {
            read: AggregateReadOperation<OverheadFormulaCodes>;
            query: AggregateQueryOperation<OverheadFormulaCodes>;
        };
        getDefaults: GetDefaultsOperation<OverheadFormulaCodes>;
    }
    export interface Overhead extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        overhead: string;
        localizedDescription: string;
        localizedShortDescription: string;
        formulaCodes: ClientCollection<OverheadFormulaCodes>;
    }
    export interface OverheadInput extends ClientNodeInput {
        overhead?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        formulaCodes?: Partial<OverheadFormulaCodesInput>[];
    }
    export interface OverheadBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        overhead: string;
        localizedDescription: string;
        localizedShortDescription: string;
        formulaCodes: ClientCollection<OverheadFormulaCodesBinding>;
    }
    export interface Overhead$Operations {
        query: QueryOperation<Overhead>;
        read: ReadOperation<Overhead>;
        aggregate: {
            read: AggregateReadOperation<Overhead>;
            query: AggregateQueryOperation<Overhead>;
        };
        getDefaults: GetDefaultsOperation<Overhead>;
    }
    export interface ProductCategoryDefaultLocations extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        locationNumber: TitleOfLocation;
        defaultLocationType: string;
        defaultLocation: string;
    }
    export interface ProductCategoryDefaultLocationsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        stockSite?: string;
        code?: string;
        locationNumber?: TitleOfLocation;
        defaultLocationType?: string;
        defaultLocation?: string;
    }
    export interface ProductCategoryDefaultLocationsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        locationNumber: TitleOfLocation;
        defaultLocationType: string;
        defaultLocation: string;
    }
    export interface ProductCategoryDefaultLocations$Operations {
        query: QueryOperation<ProductCategoryDefaultLocations>;
        read: ReadOperation<ProductCategoryDefaultLocations>;
        aggregate: {
            read: AggregateReadOperation<ProductCategoryDefaultLocations>;
            query: AggregateQueryOperation<ProductCategoryDefaultLocations>;
        };
        getDefaults: GetDefaultsOperation<ProductCategoryDefaultLocations>;
    }
    export interface ProductCategoryOverheads extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        transactionType: StockTransactionType;
        overhead: Overhead;
        isLowerLevelOverheadIncluded: boolean;
    }
    export interface ProductCategoryOverheadsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        stockSite?: string;
        code?: string;
        transactionType?: StockTransactionType;
        overhead?: string;
        isLowerLevelOverheadIncluded?: boolean | string;
    }
    export interface ProductCategoryOverheadsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        transactionType: StockTransactionType;
        overhead: Overhead;
        isLowerLevelOverheadIncluded: boolean;
    }
    export interface ProductCategoryOverheads$Lookups {
        overhead: QueryOperation<Overhead>;
    }
    export interface ProductCategoryOverheads$Operations {
        query: QueryOperation<ProductCategoryOverheads>;
        read: ReadOperation<ProductCategoryOverheads>;
        aggregate: {
            read: AggregateReadOperation<ProductCategoryOverheads>;
            query: AggregateQueryOperation<ProductCategoryOverheads>;
        };
        lookups(dataOrId: string | { data: ProductCategoryOverheadsInput }): ProductCategoryOverheads$Lookups;
        getDefaults: GetDefaultsOperation<ProductCategoryOverheads>;
    }
    export interface ProductCategoryPackingUnits extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        unit: UnitOfMeasure;
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
        issuingPackingRule: UnpackingRulesPac;
        labelFormat: GenericPrintReport;
    }
    export interface ProductCategoryPackingUnitsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        stockSite?: string;
        code?: string;
        unit?: string;
        packingUnitToStockUnitConversionFactor?: decimal | string;
        isPackingFactorEntryAllowed?: boolean | string;
        issuingPackingRule?: UnpackingRulesPac;
        labelFormat?: string;
    }
    export interface ProductCategoryPackingUnitsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        stockSite: string;
        code: string;
        unit: UnitOfMeasure;
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
        issuingPackingRule: UnpackingRulesPac;
        labelFormat: GenericPrintReport;
    }
    export interface ProductCategoryPackingUnits$Lookups {
        unit: QueryOperation<UnitOfMeasure>;
        labelFormat: QueryOperation<GenericPrintReport>;
    }
    export interface ProductCategoryPackingUnits$Operations {
        query: QueryOperation<ProductCategoryPackingUnits>;
        read: ReadOperation<ProductCategoryPackingUnits>;
        aggregate: {
            read: AggregateReadOperation<ProductCategoryPackingUnits>;
            query: AggregateQueryOperation<ProductCategoryPackingUnits>;
        };
        lookups(dataOrId: string | { data: ProductCategoryPackingUnitsInput }): ProductCategoryPackingUnits$Lookups;
        getDefaults: GetDefaultsOperation<ProductCategoryPackingUnits>;
    }
    export interface ProductSiteDefaultLocations extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        product: string;
        stockSite: string;
        locationNumber: TitleOfLocation;
        defaultLocationType: string;
        defaultLocation: string;
    }
    export interface ProductSiteDefaultLocationsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        product?: string;
        stockSite?: string;
        locationNumber?: TitleOfLocation;
        defaultLocationType?: string;
        defaultLocation?: string;
    }
    export interface ProductSiteDefaultLocationsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        product: string;
        stockSite: string;
        locationNumber: TitleOfLocation;
        defaultLocationType: string;
        defaultLocation: string;
    }
    export interface ProductSiteDefaultLocations$Operations {
        query: QueryOperation<ProductSiteDefaultLocations>;
        read: ReadOperation<ProductSiteDefaultLocations>;
        aggregate: {
            read: AggregateReadOperation<ProductSiteDefaultLocations>;
            query: AggregateQueryOperation<ProductSiteDefaultLocations>;
        };
        getDefaults: GetDefaultsOperation<ProductSiteDefaultLocations>;
    }
    export interface ProductSiteInternalContainers extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        product: string;
        stockSite: string;
        internalContainer: Container;
    }
    export interface ProductSiteInternalContainersInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        product?: string;
        stockSite?: string;
        internalContainer?: string;
    }
    export interface ProductSiteInternalContainersBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        product: string;
        stockSite: string;
        internalContainer: Container;
    }
    export interface ProductSiteInternalContainers$Lookups {
        internalContainer: QueryOperation<Container>;
    }
    export interface ProductSiteInternalContainers$Operations {
        query: QueryOperation<ProductSiteInternalContainers>;
        read: ReadOperation<ProductSiteInternalContainers>;
        aggregate: {
            read: AggregateReadOperation<ProductSiteInternalContainers>;
            query: AggregateQueryOperation<ProductSiteInternalContainers>;
        };
        lookups(dataOrId: string | { data: ProductSiteInternalContainersInput }): ProductSiteInternalContainers$Lookups;
        getDefaults: GetDefaultsOperation<ProductSiteInternalContainers>;
    }
    export interface SerialNumber extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        code: string;
        stockSite: Site;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        receiptDate: string;
        receiptSite: Site;
        receiptDocumentType: EntryTypeEnum;
        receiptDocumentId: string;
        receiptDocumentLine: integer;
        customer: Customer;
        issueDocumentType: EntryTypeEnum;
        issueDocumentId: string;
        issueDocumentLine: integer;
        issueDate: string;
        warrantyEndDate: string;
        stockId: string;
        stockLine: Stock;
    }
    export interface SerialNumberInput extends ClientNodeInput {
        product?: string;
        code?: string;
        stockSite?: string;
        documentType?: EntryTypeEnum;
        documentId?: string;
        documentLine?: integer | string;
        receiptDate?: string;
        receiptSite?: string;
        receiptDocumentType?: EntryTypeEnum;
        receiptDocumentId?: string;
        receiptDocumentLine?: integer | string;
        customer?: string;
        issueDocumentType?: EntryTypeEnum;
        issueDocumentId?: string;
        issueDocumentLine?: integer | string;
        issueDate?: string;
        warrantyEndDate?: string;
        stockId?: decimal | string;
        stockLine?: decimal | string;
    }
    export interface SerialNumberBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        code: string;
        stockSite: Site;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        receiptDate: string;
        receiptSite: Site;
        receiptDocumentType: EntryTypeEnum;
        receiptDocumentId: string;
        receiptDocumentLine: integer;
        customer: Customer;
        issueDocumentType: EntryTypeEnum;
        issueDocumentId: string;
        issueDocumentLine: integer;
        issueDate: string;
        warrantyEndDate: string;
        stockId: string;
        stockLine: Stock;
    }
    export interface SerialNumber$Lookups {
        product: QueryOperation<Product>;
        stockSite: QueryOperation<Site>;
        receiptSite: QueryOperation<Site>;
        customer: QueryOperation<Customer>;
        stockLine: QueryOperation<Stock>;
    }
    export interface SerialNumber$Operations {
        query: QueryOperation<SerialNumber>;
        read: ReadOperation<SerialNumber>;
        aggregate: {
            read: AggregateReadOperation<SerialNumber>;
            query: AggregateQueryOperation<SerialNumber>;
        };
        lookups(dataOrId: string | { data: SerialNumberInput }): SerialNumber$Lookups;
        getDefaults: GetDefaultsOperation<SerialNumber>;
    }
    export interface StockJournal extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        isUpdated: boolean;
        product: Product;
        effectiveDate: string;
        sequence: integer;
        index: integer;
        fifoDate: string;
        fifoTime: string;
        fifoTier: string;
        owner: string;
        lot: string;
        sublot: string;
        supplierLot: string;
        location: Location;
        warehouse: Warehouse;
        serialNumber: string;
        transactionType: StockTransactionType;
        stockMovementGroup: MiscellaneousTable;
        movementDescription: string;
        project: ProjectLink;
        businessPartner: BusinessPartner;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        documentTypeOriginal: EntryTypeEnum;
        documentIdOriginal: string;
        documentLineOriginal: integer;
        documentSequenceOriginal: integer;
        adjustementType: EntryTypeEnum;
        adjustementDocumentId: string;
        adjustementDocumentLineId: integer;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        packingUnit: UnitOfMeasure;
        quantityInPackingUnit: string;
        packingUnitToStockUnitConversionFactor: string;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        orginialPackingUnit: UnitOfMeasure;
        originalPackingUnitToStockUnitConversionFactor: string;
        orderAmount: string;
        movementValue: string;
        orderVariance: string;
        movementVariance: string;
        orderCost: string;
        valuedCost: string;
        costSource: CostSource;
        secondaryMovementValue: string;
        secondaryMovementVariance: string;
        secondaryValuedCost: string;
        secondaryCostSource: CostSource;
        isAdjusted: boolean;
        varianceNotAbsorbed: string;
        secondaryVarianceNotAbsorbed: string;
        expirationDate: string;
        status: StockStatus;
        potency: string;
        internationalUnitPotency: string;
        activQuantity: string;
        qualityAnalysisRequestId: string;
        isPrinted: boolean;
        isAdjustedMovement: boolean;
        labelFormat: GenericPrintReport;
        numberOfLabels: integer;
        financialSite: Site;
        hasStockInterfacePosted: boolean;
        hasStockAccountingPosted: boolean;
        hasStockAccountingPostedSecondary: boolean;
        identifier1: string;
        identifier2: string;
        intercompany: boolean;
        useByDate: string;
        recontrolDate: string;
        accountingDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        startingSerialNumber: string;
        stockCustomField1: string;
        endingSerialNumber: string;
        stockCustomField2: string;
        licensePlateNumber: LicensePlateNumber;
    }
    export interface StockJournalInput extends ClientNodeInput {
        stockSite?: string;
        isUpdated?: boolean | string;
        product?: string;
        effectiveDate?: string;
        sequence?: integer | string;
        index?: integer | string;
        fifoDate?: string;
        fifoTime?: string;
        fifoTier?: decimal | string;
        owner?: string;
        lot?: string;
        sublot?: string;
        supplierLot?: string;
        location?: string;
        warehouse?: string;
        serialNumber?: string;
        transactionType?: StockTransactionType;
        stockMovementGroup?: string;
        movementDescription?: string;
        project?: string;
        businessPartner?: string;
        documentType?: EntryTypeEnum;
        documentId?: string;
        documentLine?: integer | string;
        documentTypeOriginal?: EntryTypeEnum;
        documentIdOriginal?: string;
        documentLineOriginal?: integer | string;
        documentSequenceOriginal?: integer | string;
        adjustementType?: EntryTypeEnum;
        adjustementDocumentId?: string;
        adjustementDocumentLineId?: integer | string;
        lotCustomField1?: string;
        lotCustomField2?: string;
        lotCustomField3?: decimal | string;
        lotCustomField4?: string;
        packingUnit?: string;
        quantityInPackingUnit?: decimal | string;
        packingUnitToStockUnitConversionFactor?: decimal | string;
        quantityInStockUnit?: decimal | string;
        stockUnit?: string;
        orginialPackingUnit?: string;
        originalPackingUnitToStockUnitConversionFactor?: decimal | string;
        orderAmount?: decimal | string;
        movementValue?: decimal | string;
        orderVariance?: decimal | string;
        movementVariance?: decimal | string;
        orderCost?: decimal | string;
        valuedCost?: decimal | string;
        costSource?: CostSource;
        secondaryMovementValue?: decimal | string;
        secondaryMovementVariance?: decimal | string;
        secondaryValuedCost?: decimal | string;
        secondaryCostSource?: CostSource;
        isAdjusted?: boolean | string;
        varianceNotAbsorbed?: decimal | string;
        secondaryVarianceNotAbsorbed?: decimal | string;
        expirationDate?: string;
        status?: string;
        potency?: decimal | string;
        internationalUnitPotency?: decimal | string;
        activQuantity?: decimal | string;
        qualityAnalysisRequestId?: string;
        isPrinted?: boolean | string;
        isAdjustedMovement?: boolean | string;
        labelFormat?: string;
        numberOfLabels?: integer | string;
        financialSite?: string;
        hasStockInterfacePosted?: boolean | string;
        hasStockAccountingPosted?: boolean | string;
        hasStockAccountingPostedSecondary?: boolean | string;
        identifier1?: string;
        identifier2?: string;
        intercompany?: boolean | string;
        useByDate?: string;
        recontrolDate?: string;
        accountingDate?: string;
        majorVersion?: string;
        minorVersion?: string;
        startingSerialNumber?: string;
        stockCustomField1?: string;
        endingSerialNumber?: string;
        stockCustomField2?: string;
        licensePlateNumber?: string;
    }
    export interface StockJournalBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        isUpdated: boolean;
        product: Product;
        effectiveDate: string;
        sequence: integer;
        index: integer;
        fifoDate: string;
        fifoTime: string;
        fifoTier: string;
        owner: string;
        lot: string;
        sublot: string;
        supplierLot: string;
        location: Location;
        warehouse: Warehouse;
        serialNumber: string;
        transactionType: StockTransactionType;
        stockMovementGroup: MiscellaneousTable;
        movementDescription: string;
        project: ProjectLink;
        businessPartner: BusinessPartner;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        documentTypeOriginal: EntryTypeEnum;
        documentIdOriginal: string;
        documentLineOriginal: integer;
        documentSequenceOriginal: integer;
        adjustementType: EntryTypeEnum;
        adjustementDocumentId: string;
        adjustementDocumentLineId: integer;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        packingUnit: UnitOfMeasure;
        quantityInPackingUnit: string;
        packingUnitToStockUnitConversionFactor: string;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        orginialPackingUnit: UnitOfMeasure;
        originalPackingUnitToStockUnitConversionFactor: string;
        orderAmount: string;
        movementValue: string;
        orderVariance: string;
        movementVariance: string;
        orderCost: string;
        valuedCost: string;
        costSource: CostSource;
        secondaryMovementValue: string;
        secondaryMovementVariance: string;
        secondaryValuedCost: string;
        secondaryCostSource: CostSource;
        isAdjusted: boolean;
        varianceNotAbsorbed: string;
        secondaryVarianceNotAbsorbed: string;
        expirationDate: string;
        status: StockStatus;
        potency: string;
        internationalUnitPotency: string;
        activQuantity: string;
        qualityAnalysisRequestId: string;
        isPrinted: boolean;
        isAdjustedMovement: boolean;
        labelFormat: GenericPrintReport;
        numberOfLabels: integer;
        financialSite: Site;
        hasStockInterfacePosted: boolean;
        hasStockAccountingPosted: boolean;
        hasStockAccountingPostedSecondary: boolean;
        identifier1: string;
        identifier2: string;
        intercompany: boolean;
        useByDate: string;
        recontrolDate: string;
        accountingDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        startingSerialNumber: string;
        stockCustomField1: string;
        endingSerialNumber: string;
        stockCustomField2: string;
        licensePlateNumber: LicensePlateNumber;
    }
    export interface StockJournal$Lookups {
        stockSite: QueryOperation<Site>;
        product: QueryOperation<Product>;
        location: QueryOperation<Location>;
        warehouse: QueryOperation<Warehouse>;
        stockMovementGroup: QueryOperation<MiscellaneousTable>;
        project: QueryOperation<ProjectLink>;
        businessPartner: QueryOperation<BusinessPartner>;
        packingUnit: QueryOperation<UnitOfMeasure>;
        stockUnit: QueryOperation<UnitOfMeasure>;
        orginialPackingUnit: QueryOperation<UnitOfMeasure>;
        status: QueryOperation<StockStatus>;
        labelFormat: QueryOperation<GenericPrintReport>;
        financialSite: QueryOperation<Site>;
        majorVersion: QueryOperation<MajorVersionStatus>;
        licensePlateNumber: QueryOperation<LicensePlateNumber>;
    }
    export interface StockJournal$Operations {
        query: QueryOperation<StockJournal>;
        read: ReadOperation<StockJournal>;
        aggregate: {
            read: AggregateReadOperation<StockJournal>;
            query: AggregateQueryOperation<StockJournal>;
        };
        lookups(dataOrId: string | { data: StockJournalInput }): StockJournal$Lookups;
        getDefaults: GetDefaultsOperation<StockJournal>;
    }
    export interface StockManagementRules extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        productCategory: ProductCategory;
        stockSite: Site;
        transactionType: StockTransactionType;
        stockMovementCode: MiscellaneousTable;
        locationNumber: TitleOfLocationForStockManagementRules;
        locationNumber2: TitleOfLocationForStockManagementRules;
        locationNumber3: TitleOfLocationForStockManagementRules;
        authorizedStatus: QualityFilter1;
        authorizedSubstatus: string;
        defaultStatus: string;
        formula: string;
        hasAnalysisRequest: boolean;
        lotEntry: PackingSequence;
        lotByDefault: DefaultLot;
        outputLot: LotIssueExpirationUbd;
        prototypeVersion: PrototypeOrActiveVersion;
        activeVersion: PrototypeOrActiveVersion;
        versionStopped: VersionStopped;
        isExclusiveEntryVersion: boolean;
        licensePlateNumberEntry: LicensePlateNumberEntry;
    }
    export interface StockManagementRulesInput extends ClientNodeInput {
        productCategory?: string;
        stockSite?: string;
        transactionType?: StockTransactionType;
        stockMovementCode?: string;
        locationNumber?: TitleOfLocationForStockManagementRules;
        locationNumber2?: TitleOfLocationForStockManagementRules;
        locationNumber3?: TitleOfLocationForStockManagementRules;
        authorizedStatus?: QualityFilter1;
        authorizedSubstatus?: string;
        defaultStatus?: string;
        formula?: string;
        hasAnalysisRequest?: boolean | string;
        lotEntry?: PackingSequence;
        lotByDefault?: DefaultLot;
        outputLot?: LotIssueExpirationUbd;
        prototypeVersion?: PrototypeOrActiveVersion;
        activeVersion?: PrototypeOrActiveVersion;
        versionStopped?: VersionStopped;
        isExclusiveEntryVersion?: boolean | string;
        licensePlateNumberEntry?: LicensePlateNumberEntry;
    }
    export interface StockManagementRulesBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        productCategory: ProductCategory;
        stockSite: Site;
        transactionType: StockTransactionType;
        stockMovementCode: MiscellaneousTable;
        locationNumber: TitleOfLocationForStockManagementRules;
        locationNumber2: TitleOfLocationForStockManagementRules;
        locationNumber3: TitleOfLocationForStockManagementRules;
        authorizedStatus: QualityFilter1;
        authorizedSubstatus: string;
        defaultStatus: string;
        formula: string;
        hasAnalysisRequest: boolean;
        lotEntry: PackingSequence;
        lotByDefault: DefaultLot;
        outputLot: LotIssueExpirationUbd;
        prototypeVersion: PrototypeOrActiveVersion;
        activeVersion: PrototypeOrActiveVersion;
        versionStopped: VersionStopped;
        isExclusiveEntryVersion: boolean;
        licensePlateNumberEntry: LicensePlateNumberEntry;
    }
    export interface StockManagementRules$Lookups {
        productCategory: QueryOperation<ProductCategory>;
        stockSite: QueryOperation<Site>;
        stockMovementCode: QueryOperation<MiscellaneousTable>;
    }
    export interface StockManagementRules$Operations {
        query: QueryOperation<StockManagementRules>;
        read: ReadOperation<StockManagementRules>;
        aggregate: {
            read: AggregateReadOperation<StockManagementRules>;
            query: AggregateQueryOperation<StockManagementRules>;
        };
        lookups(dataOrId: string | { data: StockManagementRulesInput }): StockManagementRules$Lookups;
        getDefaults: GetDefaultsOperation<StockManagementRules>;
    }
    export interface StockStatus extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        expiredQStatus: StockStatus;
        expiredRStatus: StockStatus;
    }
    export interface StockStatusInput extends ClientNodeInput {
        code?: string;
        description?: string;
        localizedDescription?: string;
        shortDescription?: string;
        localizedShortDescription?: string;
        expiredQStatus?: string;
        expiredRStatus?: string;
    }
    export interface StockStatusBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        expiredQStatus: StockStatus;
        expiredRStatus: StockStatus;
    }
    export interface StockStatus$Lookups {
        expiredQStatus: QueryOperation<StockStatus>;
        expiredRStatus: QueryOperation<StockStatus>;
    }
    export interface StockStatus$Operations {
        query: QueryOperation<StockStatus>;
        read: ReadOperation<StockStatus>;
        aggregate: {
            read: AggregateReadOperation<StockStatus>;
            query: AggregateQueryOperation<StockStatus>;
        };
        lookups(dataOrId: string | { data: StockStatusInput }): StockStatus$Lookups;
        getDefaults: GetDefaultsOperation<StockStatus>;
    }
    export interface Stock extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        stockId: string;
        owner: string;
        product: ProductSite;
        lot: string;
        sublot: string;
        supplierLot: string;
        identifier1: string;
        identifier2: string;
        status: StockStatus;
        location: Location;
        locationType: string;
        locationCategory: LocationCategory;
        warehouse: Warehouse;
        serialNumber: string;
        receiptDate: string;
        packingUnit: UnitOfMeasure;
        packingUnitToStockUnitConversionFactor: string;
        quantityInPackingUnit: string;
        quantityInStockUnit: string;
        activeQuantityInStockUnit: string;
        originalPackingUnit: UnitOfMeasure;
        originalQuantityInPackingUnit: string;
        originalQuantityInStockUnit: string;
        qualityAnalysisRequestId: string;
        allocatedQuantity: string;
        allocatedActiveQuantity: string;
        inProcessQuantity: string;
        inProcessActiveQuantity: string;
        editedFlag: integer;
        lastReceiptDate: string;
        lastIssueDate: string;
        lastCountDate: string;
        isBeingCounted: boolean;
        countWorksheet: string;
        majorVersion: MajorVersionStatus;
        stockCustomField1: string;
        stockCustomField2: string;
        project: ProjectLink;
        licensePlateNumber: LicensePlateNumber;
        productCollection: ClientCollection<Product>;
        lotReference: Lot;
        availableQuantity: string;
    }
    export interface StockInput extends ClientNodeInput {
        stockSite?: string;
        stockId?: decimal | string;
        owner?: string;
        product?: string;
        lot?: string;
        sublot?: string;
        supplierLot?: string;
        identifier1?: string;
        identifier2?: string;
        status?: string;
        location?: string;
        locationType?: string;
        locationCategory?: LocationCategory;
        warehouse?: string;
        serialNumber?: string;
        receiptDate?: string;
        packingUnit?: string;
        packingUnitToStockUnitConversionFactor?: decimal | string;
        quantityInPackingUnit?: decimal | string;
        quantityInStockUnit?: decimal | string;
        activeQuantityInStockUnit?: decimal | string;
        originalPackingUnit?: string;
        originalQuantityInPackingUnit?: decimal | string;
        originalQuantityInStockUnit?: decimal | string;
        qualityAnalysisRequestId?: string;
        allocatedQuantity?: decimal | string;
        allocatedActiveQuantity?: decimal | string;
        inProcessQuantity?: decimal | string;
        inProcessActiveQuantity?: decimal | string;
        editedFlag?: integer | string;
        lastReceiptDate?: string;
        lastIssueDate?: string;
        lastCountDate?: string;
        isBeingCounted?: boolean | string;
        countWorksheet?: string;
        majorVersion?: string;
        stockCustomField1?: string;
        stockCustomField2?: string;
        project?: string;
        licensePlateNumber?: string;
        lotReference?: string;
    }
    export interface StockBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        stockId: string;
        owner: string;
        product: ProductSite;
        lot: string;
        sublot: string;
        supplierLot: string;
        identifier1: string;
        identifier2: string;
        status: StockStatus;
        location: Location;
        locationType: string;
        locationCategory: LocationCategory;
        warehouse: Warehouse;
        serialNumber: string;
        receiptDate: string;
        packingUnit: UnitOfMeasure;
        packingUnitToStockUnitConversionFactor: string;
        quantityInPackingUnit: string;
        quantityInStockUnit: string;
        activeQuantityInStockUnit: string;
        originalPackingUnit: UnitOfMeasure;
        originalQuantityInPackingUnit: string;
        originalQuantityInStockUnit: string;
        qualityAnalysisRequestId: string;
        allocatedQuantity: string;
        allocatedActiveQuantity: string;
        inProcessQuantity: string;
        inProcessActiveQuantity: string;
        editedFlag: integer;
        lastReceiptDate: string;
        lastIssueDate: string;
        lastCountDate: string;
        isBeingCounted: boolean;
        countWorksheet: string;
        majorVersion: MajorVersionStatus;
        stockCustomField1: string;
        stockCustomField2: string;
        project: ProjectLink;
        licensePlateNumber: LicensePlateNumber;
        productCollection: ClientCollection<Product>;
        lotReference: Lot;
        availableQuantity: string;
    }
    export interface Stock$Lookups {
        stockSite: QueryOperation<Site>;
        product: QueryOperation<ProductSite>;
        status: QueryOperation<StockStatus>;
        location: QueryOperation<Location>;
        warehouse: QueryOperation<Warehouse>;
        packingUnit: QueryOperation<UnitOfMeasure>;
        originalPackingUnit: QueryOperation<UnitOfMeasure>;
        majorVersion: QueryOperation<MajorVersionStatus>;
        project: QueryOperation<ProjectLink>;
        licensePlateNumber: QueryOperation<LicensePlateNumber>;
        lotReference: QueryOperation<Lot>;
    }
    export interface Stock$Operations {
        query: QueryOperation<Stock>;
        read: ReadOperation<Stock>;
        aggregate: {
            read: AggregateReadOperation<Stock>;
            query: AggregateQueryOperation<Stock>;
        };
        lookups(dataOrId: string | { data: StockInput }): Stock$Lookups;
        getDefaults: GetDefaultsOperation<Stock>;
    }
    export interface Warehouse extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        shortDescription: string;
        stockSite: Site;
    }
    export interface WarehouseInput extends ClientNodeInput {
        code?: string;
        description?: string;
        shortDescription?: string;
        stockSite?: string;
    }
    export interface WarehouseBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        description: string;
        shortDescription: string;
        stockSite: Site;
    }
    export interface Warehouse$Lookups {
        stockSite: QueryOperation<Site>;
    }
    export interface Warehouse$Operations {
        query: QueryOperation<Warehouse>;
        read: ReadOperation<Warehouse>;
        aggregate: {
            read: AggregateReadOperation<Warehouse>;
            query: AggregateQueryOperation<Warehouse>;
        };
        lookups(dataOrId: string | { data: WarehouseInput }): Warehouse$Lookups;
        getDefaults: GetDefaultsOperation<Warehouse>;
    }
    export interface ProductCategoryExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroups>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocations>;
        overheads: ClientCollection<ProductCategoryOverheads>;
        packingUnits: ClientCollection<ProductCategoryPackingUnits>;
    }
    export interface ProductCategoryInputExtension {
        stockSite?: string;
        code?: string;
        description?: string;
        localizedDescription?: string;
        shortDescription?: string;
        localizedShortDescription?: string;
        isSold?: boolean | string;
        productSequenceNumber?: string;
        creationMethod?: ProductCreationMode;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticUnit?: string;
        euUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        euUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseConversionFactorEntryAllowed?: boolean | string;
        isSalesConversionFactorEntryAllowed?: boolean | string;
        weightUnit?: string;
        stockUnitWeight?: decimal | string;
        volumeUnit?: string;
        stockUnitVolume?: decimal | string;
        labelFormatForStockUnit?: string;
        stockManagementMode?: StockManagement;
        managementMode?: StandardProductCode;
        isNegativeStockAuthorized?: boolean | string;
        lotSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        serialSequenceNumber?: string;
        valuationMethod?: string;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        userAccessCode?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        buyer?: string;
        planner?: string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        salesPriceOrigin?: PriceOrigin;
        percentagePricePurchaseApplied?: decimal | string;
        configuratorProductLine?: string;
        isLocationManaged?: boolean | string;
        salesOrderAllocationRule?: string;
        workOrderAllocationRule?: string;
        shipmentAllocationRule?: string;
        materialConsumptionAllocationRule?: string;
        transferAllocationRule?: string;
        subcontractReplenishmentAllocationRule?: string;
        subcontractConsumptionAllocationRule?: string;
        afterSalesAllocationRule?: string;
        isStatusAAuthorizedInGlobalAllocation?: boolean | string;
        isStatusQAuthorizedInGlobalAllocation?: boolean | string;
        isStatusRAuthorizedInGlobalAllocation?: boolean | string;
        abcClass?: ProductAbcClass;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        shrinkagePercent?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningRequestHorizon?: integer | string;
        planningRequestHorizonTimeUnit?: LeadTimeUnit;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        stockCoverageInWeeks?: integer | string;
        safetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        isReleasedIfShortage?: boolean | string;
        automaticClosingPercentage?: decimal | string;
        salesDeliveryTolerance?: decimal | string;
        salesMinimumQuantity?: decimal | string;
        salesMaximumQuantity?: decimal | string;
        isLoanAuthorized?: boolean | string;
        isBackToBackOrderManaged?: boolean | string;
        directBackToBackOrderQuantity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTool?: boolean | string;
        isDeliverable?: boolean | string;
        isIntermediary?: boolean | string;
        isMaintenance?: boolean | string;
        packagingCapacity?: decimal | string;
        assignmentRules?: string;
        isStockDetailedInPacking?: boolean | string;
        technicalSheet?: string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        afterSalesWarehouse?: string;
        canBeCapitalized?: boolean | string;
        isPackingManaged?: boolean | string;
        sageSalesTax?: string;
        saftProductType?: SafTProductType;
        freightClass?: string;
        freightCommodityCode?: string;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        inventoryProductType?: ProductType;
        containerManagement?: boolean | string;
        statisticalGroups?: Partial<ProductCategoryStatisticalGroupsInput>[];
        costType?: string;
        lotManagementMode?: LotManagementMode;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        materialCostGroup?: MaterialCostGroup;
        reorderingManagementMode?: ReorderingManagementMode;
        stockVersionMode?: StockVersionMode;
        stockManagementRules?: Partial<StockManagementRulesInput>[];
        defaultLocations?: Partial<ProductCategoryDefaultLocationsInput>[];
        overheads?: Partial<ProductCategoryOverheadsInput>[];
        packingUnits?: Partial<ProductCategoryPackingUnitsInput>[];
    }
    export interface ProductCategoryBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroupsBinding>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocationsBinding>;
        overheads: ClientCollection<ProductCategoryOverheadsBinding>;
        packingUnits: ClientCollection<ProductCategoryPackingUnitsBinding>;
    }
    export interface ProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnits>;
        statisticalGroups: ClientCollection<ProductStatisticalGroups>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
    }
    export interface ProductInputExtension {
        code?: string;
        company?: string;
        productCategory?: string;
        searchKey?: string;
        description1?: string;
        description2?: string;
        description3?: string;
        localizedDescription1?: string;
        localizedDescription2?: string;
        localizedDescription3?: string;
        managementMode?: StandardProductCode;
        standard?: string;
        upc?: string;
        productStatus?: ProductStatus;
        isPrototype?: boolean | string;
        defaultPotencyInPercentage?: decimal | string;
        defaultPotencyInInternationalUnit?: decimal | string;
        serviceLifeStartDate?: string;
        serviceLifeEndDate?: string;
        storageSheet?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticalUnit?: string;
        eeUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseFactorEntryAllowed?: boolean | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        isSalesFactorEntryAllowed?: boolean | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        eeUnitToStockUnitConversionFactor?: decimal | string;
        weightUnit?: string;
        productWeight?: decimal | string;
        volumeUnit?: string;
        productVolume?: decimal | string;
        lotSequenceNumber?: string;
        serialSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        expirationLeadTime?: integer | string;
        checkLeadTime?: integer | string;
        isNegativeStockAuthorized?: boolean | string;
        costGroup?: string;
        userAccessCode?: string;
        alternateProduct?: string;
        isIntrastatDeclarationSubmitted?: boolean | string;
        intrastatCommodity?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        buyer?: string;
        planner?: string;
        reorderLeadTime?: integer | string;
        purchaseBasePrice?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        exemptionFlag?: string;
        taxFlagStatusLocal?: string;
        configuratorProductLine?: string;
        configuratorNumericField1?: decimal | string;
        configuratorNumericField2?: decimal | string;
        configuratorNumericField3?: decimal | string;
        configuratorNumericField4?: decimal | string;
        configuratorNumericField5?: decimal | string;
        configuratorNumericField6?: decimal | string;
        configuratorAlphaField1?: string;
        configuratorAlphaField2?: string;
        configuratorAlphaField3?: string;
        configuratorAlphaField4?: string;
        configuratorAlphaField5?: string;
        configuratorAlphaField6?: string;
        configurationJournal?: string;
        configuratorBusinessPartner?: string;
        configuratorBusinessPartnerReference?: string;
        configuratorReferenceProduct?: string;
        configuratorPurgeDate?: string;
        isInstalledBaseCreated?: boolean | string;
        voucherCategory?: string;
        tokensToBeCredited?: integer | string;
        creditUnit?: string;
        labelFormatForStockUnit?: string;
        bomCodeForAfterSales?: integer | string;
        productTypeForAfterSales?: TypeOfProduct;
        isAfterSalesProductIssuedByDefault?: boolean | string;
        daysUnit?: string;
        hourUnit?: string;
        minuteUnit?: string;
        productDensity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTools?: boolean | string;
        isDeliverable?: boolean | string;
        isSold?: boolean | string;
        isIntermediary?: boolean | string;
        isCapitalized?: boolean | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        intrastatFederalStateOrRegion?: string;
        plmProductReference?: string;
        plmLinkedDocuments?: string;
        plmProductHistory?: string;
        sageSalesTax?: string;
        allergens?: string;
        allergenChangeDate?: string;
        allergenBomCode?: integer | string;
        saftProductType?: SafTProductType;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        productType?: ProductType;
        globalTradeItemNumber?: string;
        supplierProduct?: Partial<SupplierProductInput>[];
        customerProduct?: Partial<CustomerProductInput>[];
        manufacturingText?: TextStream;
        picture?: BinaryStream;
        purchasingText?: TextStream;
        packingUnits?: Partial<ProductPackingUnitsInput>[];
        statisticalGroups?: Partial<ProductStatisticalGroupsInput>[];
        costType?: string;
        stockManagementMode?: StockManagement;
        lotManagementMode?: LotManagementMode;
        materialCostGroup?: MaterialCostGroup;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        expirationTimeUnit?: ExpirationLeadTimeUnits;
        recontrolTimeUnit?: ExpirationLeadTimeUnits;
        stockVersionMode?: StockVersionMode;
    }
    export interface ProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnitsBinding>;
        statisticalGroups: ClientCollection<ProductStatisticalGroupsBinding>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
    }
    export interface ProductSiteExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        stockSite: Site;
        isBeingCounted: boolean;
        countWorksheet: string;
        abcClass: ProductAbcClass;
        isLocationManaged: boolean;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        numberOfStockCoverageWeeks: integer;
        multilevelLeadTime: string;
        qualityControlLeadTime: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningDemandHorizon: integer;
        planningDemandHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        productionLeadTime: string;
        pickingLeadTime: string;
        reductionFactor: integer;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        safetyStock: string;
        calculatedSafetyStock: string;
        reorderingThreshold: string;
        calculatedReorderingThreshold: string;
        reorderingMaximumStock: string;
        calculatedReorderingMaximumStock: string;
        economicOrderQuantity: string;
        calculatedEconomicOrderQuantity: string;
        technicalLotQuantity: string;
        shrinkagePercentage: string;
        planner: User;
        buyer: User;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        productionRouting: string;
        costRouting: string;
        roughCut: string;
        productionRoutingCode: BomRouting;
        costRoutingCode: BomRouting;
        roughCutCapacityPlanningRoutingCode: BomRouting;
        isReleasedIfShortage: boolean;
        isShrinkedWithRelease: boolean;
        yearOfLastMonthlyUpdate: integer;
        monthOfLastMonthlyUpdate: integer;
        lastAnnualUpdate: integer;
        automaticClosingPercentage: string;
        configurationCode: string;
        storageHandling: string;
        weighingAccessCode: string;
        weighingTolerance: string;
        productTolerance: string;
        valuationMethod: string;
        prorataQuantityAdjustment: string;
        protectionWip: boolean;
        packagingCapacity: string;
        stockManagementMode: StockManagement;
        assignmentRule: string;
        isStockDetailedInPacking: boolean;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        qualityControlFrequency: integer;
        numberOfEntriesSinceLastQualityControl: integer;
        sampling: SamplingType;
        samplingMode: SamplingMode;
        samplingGeneralCheckLevel: GeneralControlLevel;
        samplingAcceptableQualityLevel: AcceptableQualityLevel;
        qualityControlFrequencyToReview: integer;
        qualityEntriesProcess: integer;
        recontrolLeadTime: integer;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionsWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        isPackingManaged: boolean;
        freightClass: string;
        freightCommodityCode: string;
        isLicensePlateNumberManaged: boolean;
        products: ClientCollection<Product>;
        reorderingManagementMode: ReorderingManagementMode;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        defaultInternalContainer: Container;
        defaultLocations: ClientCollection<ProductSiteDefaultLocations>;
        internalContainers: ClientCollection<ProductSiteInternalContainers>;
    }
    export interface ProductSiteInputExtension {
        product?: string;
        stockSite?: string;
        isBeingCounted?: boolean | string;
        countWorksheet?: string;
        abcClass?: ProductAbcClass;
        isLocationManaged?: boolean | string;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        numberOfStockCoverageWeeks?: integer | string;
        multilevelLeadTime?: decimal | string;
        qualityControlLeadTime?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningDemandHorizon?: integer | string;
        planningDemandHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        productionLeadTime?: decimal | string;
        pickingLeadTime?: decimal | string;
        reductionFactor?: integer | string;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        safetyStock?: decimal | string;
        calculatedSafetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        calculatedReorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        calculatedReorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        calculatedEconomicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        shrinkagePercentage?: decimal | string;
        planner?: string;
        buyer?: string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        productionRouting?: string;
        costRouting?: string;
        roughCut?: string;
        productionRoutingCode?: integer | string;
        costRoutingCode?: integer | string;
        roughCutCapacityPlanningRoutingCode?: integer | string;
        isReleasedIfShortage?: boolean | string;
        isShrinkedWithRelease?: boolean | string;
        yearOfLastMonthlyUpdate?: integer | string;
        monthOfLastMonthlyUpdate?: integer | string;
        lastAnnualUpdate?: integer | string;
        automaticClosingPercentage?: decimal | string;
        configurationCode?: string;
        storageHandling?: string;
        weighingAccessCode?: string;
        weighingTolerance?: decimal | string;
        productTolerance?: decimal | string;
        valuationMethod?: string;
        prorataQuantityAdjustment?: decimal | string;
        protectionWip?: boolean | string;
        packagingCapacity?: decimal | string;
        stockManagementMode?: StockManagement;
        assignmentRule?: string;
        isStockDetailedInPacking?: boolean | string;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        qualityControlFrequency?: integer | string;
        numberOfEntriesSinceLastQualityControl?: integer | string;
        sampling?: SamplingType;
        samplingMode?: SamplingMode;
        samplingGeneralCheckLevel?: GeneralControlLevel;
        samplingAcceptableQualityLevel?: AcceptableQualityLevel;
        qualityControlFrequencyToReview?: integer | string;
        qualityEntriesProcess?: integer | string;
        recontrolLeadTime?: integer | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionsWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        isPackingManaged?: boolean | string;
        freightClass?: string;
        freightCommodityCode?: string;
        isLicensePlateNumberManaged?: boolean | string;
        reorderingManagementMode?: ReorderingManagementMode;
        recontrolTimeUnit?: ExpirationLeadTimeUnits;
        defaultInternalContainer?: string;
        defaultLocations?: Partial<ProductSiteDefaultLocationsInput>[];
        internalContainers?: Partial<ProductSiteInternalContainersInput>[];
    }
    export interface ProductSiteBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        stockSite: Site;
        isBeingCounted: boolean;
        countWorksheet: string;
        abcClass: ProductAbcClass;
        isLocationManaged: boolean;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        numberOfStockCoverageWeeks: integer;
        multilevelLeadTime: string;
        qualityControlLeadTime: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningDemandHorizon: integer;
        planningDemandHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        productionLeadTime: string;
        pickingLeadTime: string;
        reductionFactor: integer;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        safetyStock: string;
        calculatedSafetyStock: string;
        reorderingThreshold: string;
        calculatedReorderingThreshold: string;
        reorderingMaximumStock: string;
        calculatedReorderingMaximumStock: string;
        economicOrderQuantity: string;
        calculatedEconomicOrderQuantity: string;
        technicalLotQuantity: string;
        shrinkagePercentage: string;
        planner: User;
        buyer: User;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        productionRouting: string;
        costRouting: string;
        roughCut: string;
        productionRoutingCode: BomRouting;
        costRoutingCode: BomRouting;
        roughCutCapacityPlanningRoutingCode: BomRouting;
        isReleasedIfShortage: boolean;
        isShrinkedWithRelease: boolean;
        yearOfLastMonthlyUpdate: integer;
        monthOfLastMonthlyUpdate: integer;
        lastAnnualUpdate: integer;
        automaticClosingPercentage: string;
        configurationCode: string;
        storageHandling: string;
        weighingAccessCode: string;
        weighingTolerance: string;
        productTolerance: string;
        valuationMethod: string;
        prorataQuantityAdjustment: string;
        protectionWip: boolean;
        packagingCapacity: string;
        stockManagementMode: StockManagement;
        assignmentRule: string;
        isStockDetailedInPacking: boolean;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        qualityControlFrequency: integer;
        numberOfEntriesSinceLastQualityControl: integer;
        sampling: SamplingType;
        samplingMode: SamplingMode;
        samplingGeneralCheckLevel: GeneralControlLevel;
        samplingAcceptableQualityLevel: AcceptableQualityLevel;
        qualityControlFrequencyToReview: integer;
        qualityEntriesProcess: integer;
        recontrolLeadTime: integer;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionsWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        isPackingManaged: boolean;
        freightClass: string;
        freightCommodityCode: string;
        isLicensePlateNumberManaged: boolean;
        products: ClientCollection<Product>;
        reorderingManagementMode: ReorderingManagementMode;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        defaultInternalContainer: Container;
        defaultLocations: ClientCollection<ProductSiteDefaultLocationsBinding>;
        internalContainers: ClientCollection<ProductSiteInternalContainersBinding>;
    }
    export interface ProductSiteExtension$Lookups {
        defaultInternalContainer: QueryOperation<Container>;
    }
    export interface ProductSiteExtension$Operations {
        lookups(dataOrId: string | { data: ProductSiteInput }): ProductSiteExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-stock-data/LicensePlateNumber': LicensePlateNumber$Operations;
        '@sage/x3-stock-data/Location': Location$Operations;
        '@sage/x3-stock-data/Lot': Lot$Operations;
        '@sage/x3-stock-data/LotsSites': LotsSites$Operations;
        '@sage/x3-stock-data/MajorVersionStatus': MajorVersionStatus$Operations;
        '@sage/x3-stock-data/MobileSettings': MobileSettings$Operations;
        '@sage/x3-stock-data/OverheadFormulaCodes': OverheadFormulaCodes$Operations;
        '@sage/x3-stock-data/Overhead': Overhead$Operations;
        '@sage/x3-stock-data/ProductCategoryDefaultLocations': ProductCategoryDefaultLocations$Operations;
        '@sage/x3-stock-data/ProductCategoryOverheads': ProductCategoryOverheads$Operations;
        '@sage/x3-stock-data/ProductCategoryPackingUnits': ProductCategoryPackingUnits$Operations;
        '@sage/x3-stock-data/ProductSiteDefaultLocations': ProductSiteDefaultLocations$Operations;
        '@sage/x3-stock-data/ProductSiteInternalContainers': ProductSiteInternalContainers$Operations;
        '@sage/x3-stock-data/SerialNumber': SerialNumber$Operations;
        '@sage/x3-stock-data/StockJournal': StockJournal$Operations;
        '@sage/x3-stock-data/StockManagementRules': StockManagementRules$Operations;
        '@sage/x3-stock-data/StockStatus': StockStatus$Operations;
        '@sage/x3-stock-data/Stock': Stock$Operations;
        '@sage/x3-stock-data/Warehouse': Warehouse$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3MasterData$Package,
            SageX3ProjectManagementData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-stock-data-api' {
    export type * from '@sage/x3-stock-data-api-partial';
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-stock-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type {
        ProductBindingExtension,
        ProductCategoryBindingExtension,
        ProductCategoryExtension,
        ProductCategoryInputExtension,
        ProductExtension,
        ProductInputExtension,
        ProductSiteBindingExtension,
        ProductSiteExtension,
        ProductSiteExtension$Lookups,
        ProductSiteExtension$Operations,
        ProductSiteInputExtension,
    } from '@sage/x3-stock-data-api';
    export interface ProductCategory extends ProductCategoryExtension {}
    export interface ProductCategoryBinding extends ProductCategoryBindingExtension {}
    export interface ProductCategoryInput extends ProductCategoryInputExtension {}
    export interface Product extends ProductExtension {}
    export interface ProductBinding extends ProductBindingExtension {}
    export interface ProductInput extends ProductInputExtension {}
    export interface ProductSite extends ProductSiteExtension {}
    export interface ProductSiteBinding extends ProductSiteBindingExtension {}
    export interface ProductSiteInput extends ProductSiteInputExtension {}
    export interface ProductSite$Lookups extends ProductSiteExtension$Lookups {}
    export interface ProductSite$Operations extends ProductSiteExtension$Operations {}
}
