"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesQuote = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const joins = {
    referenceJoins: {
        quoteType: {
            code: 'quoteType',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        company: {
            code: 'company',
        },
        salesSite: {
            code: 'salesSite',
        },
        soldToCustomer: {
            code: 'soldToCustomer',
        },
        salesOrderType: {
            code: 'salesOrderType',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        shipToCustomerAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'soldToCustomer',
            code: 'shipToCustomerAddress',
        },
        soldToCustomerAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'soldToCustomer',
            code: 'soldToCustomerAddress',
        },
        soldToCustomerCountry: {
            code: 'soldToCustomerCountry',
        },
        soldToCustomerContact: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'soldToCustomer',
            code: 'soldToCustomerContact',
        },
        shipToCustomerCountry: {
            code: 'shipToCustomerCountry',
        },
        shipToCustomerContact: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'soldToCustomer',
            code: 'shipToCustomerContact',
        },
        currency: {
            code: 'currency',
        },
        project: {
            id: 'project',
        },
        soldToCustomerLanguage: {
            code: 'soldToCustomerLanguage',
        },
        taxRule: {
            code: 'taxRule',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        entityUseCode: {
            glossaryId() {
                return 202;
            },
            code: 'entityUseCode',
        },
        shippingSite: {
            code: 'shippingSite',
        },
        earlyDiscountOrLateCharge: {
            code: 'earlyDiscountOrLateCharge',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        paymentTerm: {
            code: 'paymentTerm',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
            line() {
                return 1;
            },
        },
        salesOrder: {
            id: 'salesOrder',
        },
        salesProforma: {
            id: 'salesProforma',
        },
        incoterm: {
            code: 'incoterm',
        },
        forwardingAgent: {
            code: 'forwardingAgent',
        },
        forwardingAgentAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'forwardingAgent',
            code: 'forwardingAgentAddress',
        },
        priceStructure: {
            customerOrSupplier() {
                return 'customer';
            },
            code: 'priceStructure',
        },
        weightUnitForDistributionOnLines: {
            code: 'weightUnitForDistributionOnLines',
        },
        volumeUnitForDistributionOnLines: {
            code: 'volumeUnitForDistributionOnLines',
        },
        quoteHeaderTextRef: {
            code: 'quoteHeaderTextKey',
        },
        quoteFooterTextRef: {
            code: 'quoteFooterTextKey',
        },
    },
    collectionJoins: {
        salesQuoteLines: {
            salesQuote: 'id',
        },
    },
};
const compositeReferences = {
    quoteFooterTextRef: {
        quoteFooterText: 'text',
    },
    quoteHeaderTextRef: {
        quoteHeaderText: 'text',
    },
};
let SalesQuote = class SalesQuote extends xtrem_core_1.Node {
};
exports.SalesQuote = SalesQuote;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SQHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SQHTYP',
        columnType: 'string',
        node: () => sageX3SalesData.nodes.SalesQuoteType,
    })
], SalesQuote.prototype, "quoteType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], SalesQuote.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SALFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesQuote.prototype, "salesSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCORD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], SalesQuote.prototype, "soldToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUSQUOREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "customerQuoteReference", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QUODAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesQuote.prototype, "quoteDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLYDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesQuote.prototype, "validityDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DAYLTI',
    })
], SalesQuote.prototype, "deliveryLeadTime", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOHTYP',
        columnType: 'string',
        node: () => sageX3SalesData.nodes.SalesOrderType,
    })
], SalesQuote.prototype, "salesOrderType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], SalesQuote.prototype, "shipToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAORD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], SalesQuote.prototype, "soldToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "soldToCustomerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "soldToCustomerCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "soldToCustomerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SalesQuote.prototype, "soldToCustomerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "soldToCustomerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNCNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerContact,
    })
], SalesQuote.prototype, "soldToCustomerContact", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "shipToCustomerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "shipToCustomerCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "shipToCustomerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPDCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SalesQuote.prototype, "shipToCustomerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "shipToCustomerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNDNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerContact,
    })
], SalesQuote.prototype, "shipToCustomerContact", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPIEECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesQuote.prototype, "billToCustomerEuropeanUnionVatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], SalesQuote.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], SalesQuote.prototype, "currencyRateType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "currencyRate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], SalesQuote.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], SalesQuote.prototype, "soldToCustomerLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VACBPR',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.TaxRule,
    })
], SalesQuote.prototype, "taxRule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SSTENTCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 202,
            },
            control: {
                glossaryId: 202,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], SalesQuote.prototype, "entityUseCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesQuote.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRITYP',
        dataType: () => sageX3MasterData.enums.priceAmountTaxTaxDatatype,
    })
], SalesQuote.prototype, "priceIncludingOrExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUONOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "linesAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUOATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "linesAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUONOTL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "linesAmountExcludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUOATIL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "linesAmountIncludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUOINVNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "totalAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUOINVATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "totalAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUOINVNOTL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "totalAmountExcludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUOINVATIL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "totalAmountIncludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PFMTOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "totalMargin", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.EarlyDiscountLateCharge,
    })
], SalesQuote.prototype, "earlyDiscountOrLateCharge", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTE',
        columnType: 'string',
        filters: {
            lookup: {
                line: 1,
            },
            control: {
                line: 1,
            },
        },
        node: () => sageX3InvoicingData.nodes.PaymentTerm,
    })
], SalesQuote.prototype, "paymentTerm", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBYPRC',
    })
], SalesQuote.prototype, "probabilityPercentage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesOrder,
    })
], SalesQuote.prototype, "salesOrder", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesQuote.prototype, "orderDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDNBR',
    })
], SalesQuote.prototype, "numberOfOrders", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CFMLINNBR',
    })
], SalesQuote.prototype, "numberOfValidatedLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINNBR',
    })
], SalesQuote.prototype, "numberOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUOSTA',
        dataType: () => sageX3SalesData.enums.quoteStatusDatatype,
    })
], SalesQuote.prototype, "quoteStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'APPFLG',
        dataType: () => sageX3MasterData.enums.noInPartInFullDatatype,
    })
], SalesQuote.prototype, "signatureStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QUOPRN',
    })
], SalesQuote.prototype, "isQuotePrinted", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COPNBR',
    })
], SalesQuote.prototype, "numberOfQuoteCopies", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SQHTEX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "quoteHeaderTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SQHTEX2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "quoteFooterTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRFNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoice,
    })
], SalesQuote.prototype, "salesProforma", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECICT',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Incoterm,
    })
], SalesQuote.prototype, "incoterm", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECLOC',
        dataType: () => sageX3MasterData.enums.countryLocationDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesQuote.prototype, "intrastatTransportLocation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ICTCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuote.prototype, "incotermTown", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], SalesQuote.prototype, "forwardingAgent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], SalesQuote.prototype, "forwardingAgentAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GEOCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuote.prototype, "geographicCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSCTYFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuote.prototype, "insideCityLimits", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VTT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuote.prototype, "vertexTransactionType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuote.prototype, "taxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuote.prototype, "taxableAmount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLISTC',
        columnType: 'string',
        filters: {
            lookup: {
                customerOrSupplier: 'customer',
            },
            control: {
                customerOrSupplier: 'customer',
            },
        },
        node: () => sageX3InvoicingData.nodes.PriceStructure,
    })
], SalesQuote.prototype, "priceStructure", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPTOTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "totalQuantityDistributedOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPTOTWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "totalWeightDistributedOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPTOTVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuote.prototype, "totalVolumeDistributedOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesQuote.prototype, "weightUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesQuote.prototype, "volumeUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADRVAL',
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], SalesQuote.prototype, "isValidatedAddress", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REVNUM',
    })
], SalesQuote.prototype, "revisionNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SQHCFMFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesQuote.prototype, "hasElectronicSignature", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SQHNUMEND',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesQuote.prototype, "finalNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SQHVALDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesQuote.prototype, "validationDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Sales.nodes.SalesQuoteLine,
        isMutable: true,
        dependsOn: ['id'],
    })
], SalesQuote.prototype, "salesQuoteLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesQuote.prototype, "quoteHeaderTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesQuote.prototype, "quoteFooterTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesQuote.prototype, "quoteFooterText", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesQuote.prototype, "quoteHeaderText", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteDimensions,
    })
], SalesQuote.prototype, "dimensions", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteDiscountOrChargeCalculationRules,
    })
], SalesQuote.prototype, "discountOrChargeCalculationRules", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteInvoicingElements,
    })
], SalesQuote.prototype, "invoicingElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteSalesReps,
    })
], SalesQuote.prototype, "salesReps", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteShipToCustomerAddressLines,
    })
], SalesQuote.prototype, "shipToCustomerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteShipToCustomerCompanyNames,
    })
], SalesQuote.prototype, "shipToCustomerCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteSoldToCustomerAddressLines,
    })
], SalesQuote.prototype, "soldToCustomerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteSoldToCustomerCompanyNames,
    })
], SalesQuote.prototype, "soldToCustomerCompanyNames", void 0);
exports.SalesQuote = SalesQuote = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SQUOTE',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SalesQuote);
//# sourceMappingURL=sales-quote.js.map