"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesQuoteLine = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const joins = {
    referenceJoins: {
        salesQuote: {
            id: 'salesQuote',
        },
        company: {
            code: 'company',
        },
        salesSite: {
            code: 'salesSite',
        },
        soldToCustomer: {
            code: 'soldToCustomer',
        },
        product: {
            code: 'product',
        },
        majorProductVersion: {
            product: 'product',
            code: 'majorProductVersion',
        },
        minorProductVersion: {
            product: 'product',
            majorVersion: 'majorProductVersion',
            minorVersion: 'minorProductVersion',
            type() {
                return 'stock';
            },
        },
        salesRep1: {
            code: 'salesRep1',
        },
        salesRep2: {
            code: 'salesRep2',
        },
        priceReason: {
            code: 'priceReason',
        },
        discountOrCharge1Reason: {
            code: 'discountOrCharge1Reason',
        },
        discountOrCharge2Reason: {
            code: 'discountOrCharge2Reason',
        },
        discountOrCharge3Reason: {
            code: 'discountOrCharge3Reason',
        },
        discountOrCharge4Reason: {
            code: 'discountOrCharge4Reason',
        },
        discountOrCharge5Reason: {
            code: 'discountOrCharge5Reason',
        },
        discountOrCharge6Reason: {
            code: 'discountOrCharge6Reason',
        },
        discountOrCharge7Reason: {
            code: 'discountOrCharge7Reason',
        },
        discountOrCharge8Reason: {
            code: 'discountOrCharge8Reason',
        },
        discountOrCharge9Reason: {
            code: 'discountOrCharge9Reason',
        },
        salesUnit: {
            code: 'salesUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        shipToCustomerAddress: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'soldToCustomer',
            code: 'shipToCustomerAddress',
        },
        shippingSite: {
            code: 'shippingSite',
        },
        shipToCustomerContact: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'soldToCustomer',
            code: 'shipToCustomerContact',
        },
        salesOrder: {
            id: 'salesOrder',
        },
        salesOrderLine: {
            salesOrder: 'salesOrder',
            lineNumber: 'salesOrderLine',
            sequenceNumber: 'salesOrderLine',
        },
        weightUnitForDistributionOnLines: {
            code: 'weightUnitForDistributionOnLines',
        },
        volumeUnitForDistributionOnLines: {
            code: 'volumeUnitForDistributionOnLines',
        },
        project: {
            id: 'project',
        },
        sageSalesTax: {
            glossaryId() {
                return 203;
            },
            code: 'sageSalesTax',
        },
        quoteLineTextRef: {
            code: 'quoteLineTextKey',
        },
    },
};
const compositeReferences = {
    quoteLineTextRef: {
        quoteLineText: 'text',
    },
};
let SalesQuoteLine = class SalesQuoteLine extends xtrem_core_1.Node {
};
exports.SalesQuoteLine = SalesQuoteLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SQHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesQuote,
    })
], SalesQuoteLine.prototype, "salesQuote", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SQDLIN',
    })
], SalesQuoteLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], SalesQuoteLine.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SALFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesQuoteLine.prototype, "salesSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCORD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesQuoteLine.prototype, "soldToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QUODAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesQuoteLine.prototype, "quoteDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DAYLTI',
    })
], SalesQuoteLine.prototype, "deliveryLeadTime", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], SalesQuoteLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SalesQuoteLine.prototype, "majorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMIN',
        columnType: 'string',
        filters: {
            lookup: {
                type: 'stock',
            },
            control: {
                type: 'stock',
            },
        },
        node: () => sageX3MasterData.nodes.ProductVersion,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], SalesQuoteLine.prototype, "minorProductVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuoteLine.prototype, "productDescriptionInUserLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuoteLine.prototype, "productDescriptionInCustomerLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REP1',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesQuoteLine.prototype, "salesRep1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPRAT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re1ActivityCode],
    })
], SalesQuoteLine.prototype, "salesRep1CommissionRate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REP2',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SalesRep,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesQuoteLine.prototype, "salesRep2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPRAT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Re2ActivityCode],
    })
], SalesQuoteLine.prototype, "salesRep2CommissionRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REPCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "salesRepCommissionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GROPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "grossPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIREN',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
    })
], SalesQuoteLine.prototype, "priceReason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "netPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PFM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "margin", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRINOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "netPriceExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRIATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "netPriceIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "costPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp1ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp2ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp3ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp4ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp5ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge5", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp6ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge6", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp7ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge7", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp8ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge8", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Sp9ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge9", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN1',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp1ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge1Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN2',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp2ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge2Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN3',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp3ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge3Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN4',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp4ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge4Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN5',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp5ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge5Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN6',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp6ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge6Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN7',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp7ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge7Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN8',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp8ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge8Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN9',
        columnType: 'integer',
        node: () => sageX3SalesData.nodes.SalesPriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Sp9ActivityCode],
    })
], SalesQuoteLine.prototype, "discountOrCharge9Reason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "calculatedTaxableBase1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "calculatedTaxableBase2", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DSPLINFLG',
    })
], SalesQuoteLine.prototype, "isLineWithDistributedInvoicingElement", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "quoteQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesQuoteLine.prototype, "salesUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesQuoteLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SAUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "salesUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], SalesQuoteLine.prototype, "shipToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesQuoteLine.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNDNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerContact,
    })
], SalesQuoteLine.prototype, "shipToCustomerContact", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINTYP',
        dataType: () => sageX3SalesData.enums.lineTypeDatatype,
    })
], SalesQuoteLine.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FOCFLG',
        dataType: () => sageX3SalesData.enums.freeDatatype,
    })
], SalesQuoteLine.prototype, "freeProduct", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORILIN',
    })
], SalesQuoteLine.prototype, "freeProductLineSource", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesOrder,
    })
], SalesQuoteLine.prototype, "salesOrder", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOPLIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesOrderLine,
    })
], SalesQuoteLine.prototype, "salesOrderLine", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORDFLG',
    })
], SalesQuoteLine.prototype, "isOrdered", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "orderedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SQDTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesQuoteLine.prototype, "quoteLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GEOCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuoteLine.prototype, "geographicCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSCTYFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuoteLine.prototype, "insideCityLimits", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXGEOFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuoteLine.prototype, "isTaxedGeographically", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuoteLine.prototype, "isTaxable", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TAXREGFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuoteLine.prototype, "isRecordedTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RATTAXLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuoteLine.prototype, "taxRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAXLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesQuoteLine.prototype, "taxableAmount", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OCNPRNBOM',
    })
], SalesQuoteLine.prototype, "isComponentPrintedOnAcknowledgement", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NDEPRNBOM',
    })
], SalesQuoteLine.prototype, "isComponentPrintedOnPackingSlip", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INVPRNBOM',
    })
], SalesQuoteLine.prototype, "isComponentPrintedOnInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPLINWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "weightDistributedOnLine", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPLINVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesQuoteLine.prototype, "volumeDistributedOnLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesQuoteLine.prototype, "weightUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesQuoteLine.prototype, "volumeUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], SalesQuoteLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IMPNUMLIG',
    })
], SalesQuoteLine.prototype, "importLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SSTCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 203,
            },
            control: {
                glossaryId: 203,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], SalesQuoteLine.prototype, "sageSalesTax", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DLVFLG',
    })
], SalesQuoteLine.prototype, "isDeliverable", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINREVNUM',
    })
], SalesQuoteLine.prototype, "lineRevisionNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesQuoteLine.prototype, "quoteLineTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesQuoteLine.prototype, "quoteLineText", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteLineDistributedInvoicingElements,
    })
], SalesQuoteLine.prototype, "distributedInvoicingElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesQuoteLineTaxes,
    })
], SalesQuoteLine.prototype, "taxes", void 0);
exports.SalesQuoteLine = SalesQuoteLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SQUOTED',
        keyPropertyNames: ['salesQuote', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    salesQuote: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['lineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SalesQuoteLine);
//# sourceMappingURL=sales-quote-line.js.map