"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesOrder = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Sales = require("..");
const joins = {
    referenceJoins: {
        company: {
            code: 'company',
        },
        salesOrderType: {
            code: 'salesOrderType',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        salesSite: {
            code: 'salesSite',
        },
        soldToCustomer: {
            code: 'soldToCustomer',
        },
        billToCustomer: {
            code: 'billToCustomer',
        },
        payByBusinessPartner: {
            code: 'payByBusinessPartner',
        },
        payByBusinessPartnerAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'payByBusinessPartner',
            code: 'payByBusinessPartnerAddress',
        },
        groupCustomer: {
            code: 'groupCustomer',
        },
        shipToCustomerAddress: {
            customer: 'soldToCustomer',
            shipToAddress: 'shipToCustomerAddress',
        },
        project: {
            id: 'project',
        },
        soldToCustomerAddress: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'soldToCustomer',
            code: 'soldToCustomerAddress',
        },
        soldToCustomerCountry: {
            code: 'soldToCustomerCountry',
        },
        soldToCustomerContact: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'soldToCustomer',
            code: 'soldToCustomerContact',
        },
        billToCustomerAddress: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'billToCustomer',
            code: 'billToCustomerAddress',
        },
        billToCustomerCountry: {
            code: 'billToCustomerCountry',
        },
        billToCustomerContact: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'billToCustomer',
            code: 'billToCustomerContact',
        },
        shipToCustomerCountry: {
            code: 'shipToCustomerCountry',
        },
        shipToCustomerContact: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'soldToCustomer',
            code: 'shipToCustomerContact',
        },
        currency: {
            code: 'currency',
        },
        soldToCustomerLanguage: {
            code: 'soldToCustomerLanguage',
        },
        taxRule: {
            code: 'taxRule',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        entityUseCode: {
            glossaryId() {
                return 202;
            },
            code: 'entityUseCode',
        },
        paymentTerm: {
            code: 'paymentTerm',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
            line() {
                return 1;
            },
        },
        earlyDiscountOrLateCharge: {
            code: 'earlyDiscountOrLateCharge',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        carrier: {
            code: 'carrier',
        },
        deliveryMode: {
            code: 'deliveryMode',
        },
        shippingSite: {
            code: 'shippingSite',
        },
        salesQuote: {
            id: 'salesQuote',
        },
        sourceSite: {
            code: 'sourceSite',
        },
        salesProforma: {
            id: 'salesProforma',
        },
        lastSalesDelivery: {
            id: 'lastSalesDelivery',
        },
        lastSalesInvoice: {
            id: 'lastSalesInvoice',
        },
        incoterm: {
            code: 'incoterm',
        },
        forwardingAgent: {
            code: 'forwardingAgent',
        },
        forwardingAgentAddress: {
            entityType() {
                return 'businessPartner';
            },
            customer: 'forwardingAgent',
            code: 'forwardingAgentAddress',
        },
        closingReason: {
            glossaryId() {
                return 201;
            },
            code: 'closingReason',
        },
        priceStructure: {
            customerOrSupplier() {
                return 'customer';
            },
            code: 'priceStructure',
        },
        weightUnitForDistributionOnLines: {
            code: 'weightUnitForDistributionOnLines',
        },
        volumeUnitForDistributionOnLines: {
            code: 'volumeUnitForDistributionOnLines',
        },
        deliveryType: {
            code: 'deliveryType',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        manualHoldReason: {
            glossaryId() {
                return 204;
            },
            code: 'manualHoldReason',
        },
        manualHoldOrReleaseUser: {
            code: 'manualHoldOrReleaseUser',
        },
        previousManualHoldReason: {
            glossaryId() {
                return 204;
            },
            code: 'previousManualHoldReason',
        },
        previousManualHoldOrReleaseUser: {
            code: 'previousManualHoldOrReleaseUser',
        },
        invoicingTerm: {
            code: 'invoicingTerm',
            async legislation() {
                return (await (await this.company).legislation)?.code;
            },
        },
        orderHeaderTextRef: {
            code: 'orderHeaderTextKey',
        },
        orderFooterTextRef: {
            code: 'orderFooterTextKey',
        },
    },
    collectionJoins: {
        salesOrderLines: {
            salesOrder: 'id',
        },
    },
};
const compositeReferences = {
    orderFooterTextRef: {
        orderFooterText: 'text',
    },
    orderHeaderTextRef: {
        orderHeaderText: 'text',
    },
};
let SalesOrder = class SalesOrder extends xtrem_core_1.Node {
};
exports.SalesOrder = SalesOrder;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], SalesOrder.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOHTYP',
        columnType: 'string',
        node: () => sageX3SalesData.nodes.SalesOrderType,
    })
], SalesOrder.prototype, "salesOrderType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOHCAT',
        dataType: () => sageX3SalesData.enums.orderCategoryDatatype,
    })
], SalesOrder.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SALFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesOrder.prototype, "salesSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCORD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesOrder.prototype, "soldToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesOrder.prototype, "billToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCPYR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], SalesOrder.prototype, "payByBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAPYR',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], SalesOrder.prototype, "payByBusinessPartnerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCGRU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], SalesOrder.prototype, "groupCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ShipToCustomerAddress,
    })
], SalesOrder.prototype, "shipToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUSORDREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "customerOrderReference", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADLREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], SalesOrder.prototype, "additionnalReference", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], SalesOrder.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "orderDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "shipmentDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEMDLVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "requestedDeliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LNDRTNDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "loanReturnDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DAYLTI',
    })
], SalesOrder.prototype, "deliveryLeadTime", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAORD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], SalesOrder.prototype, "soldToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "soldToCustomerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "soldToCustomerCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "soldToCustomerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPCCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SalesOrder.prototype, "soldToCustomerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "soldToCustomerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerContact,
    })
], SalesOrder.prototype, "soldToCustomerContact", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], SalesOrder.prototype, "billToCustomerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPIPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "billToCustomerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPICTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "billToCustomerCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPISAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "billToCustomerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPICRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SalesOrder.prototype, "billToCustomerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPICRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "billToCustomerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPIEECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesOrder.prototype, "billToCustomerEuropeanUnionVatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNINAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerContact,
    })
], SalesOrder.prototype, "billToCustomerContact", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "shipToCustomerPostalCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "shipToCustomerCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "shipToCustomerState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPDCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SalesOrder.prototype, "shipToCustomerCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPDCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "shipToCustomerCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNDNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerContact,
    })
], SalesOrder.prototype, "shipToCustomerContact", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], SalesOrder.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], SalesOrder.prototype, "currencyRateType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "currencyRate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], SalesOrder.prototype, "soldToCustomerLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VACBPR',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.TaxRule,
    })
], SalesOrder.prototype, "taxRule", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SSTENTCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 202,
            },
            control: {
                glossaryId: 202,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], SalesOrder.prototype, "entityUseCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTE',
        columnType: 'string',
        filters: {
            lookup: {
                line: 1,
            },
            control: {
                line: 1,
            },
        },
        node: () => sageX3InvoicingData.nodes.PaymentTerm,
    })
], SalesOrder.prototype, "paymentTerm", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.EarlyDiscountLateCharge,
    })
], SalesOrder.prototype, "earlyDiscountOrLateCharge", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPTNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], SalesOrder.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MDL',
        columnType: 'string',
        node: () => sageX3PurchasingData.nodes.DeliveryMode,
    })
], SalesOrder.prototype, "deliveryMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesOrder.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DRN',
        dataType: () => sageX3SalesData.enums.routeCodeDatatype,
    })
], SalesOrder.prototype, "routeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVPIO',
        dataType: () => sageX3SalesData.enums.deliveryPriorityDatatype,
    })
], SalesOrder.prototype, "deliveryPriority", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORDCLE',
    })
], SalesOrder.prototype, "isOrderClosingAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ODL',
    })
], SalesOrder.prototype, "mustContainOneOrderPerDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DME',
        dataType: () => sageX3SalesData.enums.partialDeliveryDatatype,
    })
], SalesOrder.prototype, "partialDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IME',
        dataType: () => sageX3SalesData.enums.invoicingModeDatatype,
    })
], SalesOrder.prototype, "invoicingMode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OCNFLG',
    })
], SalesOrder.prototype, "mustPrintAcknowledgment", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OCNPRN',
    })
], SalesOrder.prototype, "isAcknowledgmentPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COPNBR',
    })
], SalesOrder.prototype, "numberOfAcknowledgmentCopies", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SOHTEX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "orderHeaderTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'SOHTEX2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "orderFooterTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SQHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesQuote,
    })
], SalesOrder.prototype, "salesQuote", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETFCY',
    })
], SalesOrder.prototype, "isIntersite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETCPY',
    })
], SalesOrder.prototype, "isIntercompany", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SalesOrder.prototype, "sourceSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRFNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoice,
    })
], SalesOrder.prototype, "salesProforma", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASDLVNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesDelivery,
    })
], SalesOrder.prototype, "lastSalesDelivery", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASDLVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "lastSalesDeliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASINVNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoice,
    })
], SalesOrder.prototype, "lastSalesInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LASINVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "lastSalesInvoiceDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRITYP',
        dataType: () => sageX3MasterData.enums.priceAmountTaxTaxDatatype,
    })
], SalesOrder.prototype, "priceIncludingOrExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDNOTL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountExcludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDATIL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountIncludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDINVNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "totalAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDINVATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "totalAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDINVNOTL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "totalAmountExcludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDINVATIL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "totalAmountIncludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLRNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountRemainingToDeliverExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLRATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountRemainingToDeliverIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PFMTOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "totalMargin", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLTYP',
        dataType: () => sageX3MasterData.enums.allocationTypeDatatype,
    })
], SalesOrder.prototype, "allocationType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UNL',
    })
], SalesOrder.prototype, "isUnlocked", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINNBR',
    })
], SalesOrder.prototype, "numberOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLELINNBR',
    })
], SalesOrder.prototype, "numberOfClosedLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLLINNBR',
    })
], SalesOrder.prototype, "numberOfLinesToAllocate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVLINNBR',
    })
], SalesOrder.prototype, "numberOfDeliveredLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVLINNBR',
    })
], SalesOrder.prototype, "numberOfInvoicedLines", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORDSTA',
        dataType: () => sageX3SalesData.enums.orderStatusDatatype,
    })
], SalesOrder.prototype, "orderStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ALLSTA',
        dataType: () => sageX3MasterData.enums.allocationStatusDatatype,
    })
], SalesOrder.prototype, "allocationStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVSTA',
        dataType: () => sageX3Sales.enums.salesDeliveryStatusDatatype,
    })
], SalesOrder.prototype, "deliveryStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVSTA',
        dataType: () => sageX3Sales.enums.salesInvoiceStatusDatatype,
    })
], SalesOrder.prototype, "invoicedStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDTSTA',
        dataType: () => sageX3SalesData.enums.creditStatusDatatype,
    })
], SalesOrder.prototype, "creditLevelStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'APPFLG',
        dataType: () => sageX3MasterData.enums.noInPartInFullDatatype,
    })
], SalesOrder.prototype, "signatureStatus", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REVNUM',
    })
], SalesOrder.prototype, "revisionNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHIADECOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "shipperOrReceiverCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECICT',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Incoterm,
    })
], SalesOrder.prototype, "incoterm", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECLOC',
        dataType: () => sageX3MasterData.enums.countryLocationDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], SalesOrder.prototype, "intrastatTransportLocation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ICTCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "incotermTown", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], SalesOrder.prototype, "forwardingAgent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.CustomerAddress,
    })
], SalesOrder.prototype, "forwardingAgentAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GEOCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrder.prototype, "geographicCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INSCTYFLG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrder.prototype, "insideCityLimits", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VTT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrder.prototype, "vertexTransactionType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrder.prototype, "taxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KusActivityCode],
    })
], SalesOrder.prototype, "taxableAmount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCLREN',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 201,
            },
            control: {
                glossaryId: 201,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesOrder.prototype, "closingReason", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "closingDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPGTYP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "marketingOperationType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLISTC',
        columnType: 'string',
        filters: {
            lookup: {
                customerOrSupplier: 'customer',
            },
            control: {
                customerOrSupplier: 'customer',
            },
        },
        node: () => sageX3InvoicingData.nodes.PriceStructure,
    })
], SalesOrder.prototype, "priceStructure", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPTOTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "totalQuantityDistributedOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPTOTWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "totalWeightDistributedOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPTOTVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "totalVolumeDistributedOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesOrder.prototype, "weightUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], SalesOrder.prototype, "volumeUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SDHTYP',
        columnType: 'string',
        node: () => sageX3SalesData.nodes.SalesDeliveryType,
    })
], SalesOrder.prototype, "deliveryType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HLDSTA',
        dataType: () => sageX3SalesData.enums.holdStatusDatatype,
    })
], SalesOrder.prototype, "manualHoldStatus", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HLDCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 204,
            },
            control: {
                glossaryId: 204,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesOrder.prototype, "manualHoldReason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HLDUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], SalesOrder.prototype, "manualHoldOrReleaseUser", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HLDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "manualHoldOrReleaseDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HLDTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "manualHoldOrReleaseTime", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HLDCODP',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 204,
            },
            control: {
                glossaryId: 204,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], SalesOrder.prototype, "previousManualHoldReason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HLDUSRP',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], SalesOrder.prototype, "previousManualHoldOrReleaseUser", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'HLDDATP',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "previousManualHoldOrReleaseDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HLDTIMP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "previousManualHoldOrReleaseTime", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CDTSTAP',
        dataType: () => sageX3SalesData.enums.creditStatusDatatype,
    })
], SalesOrder.prototype, "previousCreditLevelStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADRVAL',
        serviceOptions: () => [sageX3System.serviceOptions.LtaActivityCode],
    })
], SalesOrder.prototype, "isValidatedAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEMDLVHOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Edix3ActivityCode],
    })
], SalesOrder.prototype, "requestedDeliveryTime", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVCND',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.InvoicingTerm,
    })
], SalesOrder.prototype, "invoicingTerm", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRINVCNDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], SalesOrder.prototype, "scheduledInvoiceStartDueDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INRNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountRemainingToInvoiceExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INRATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountRemainingToInvoiceIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INRSCHNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountExcludingTaxforScheduledInvoicesRemainingToInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INRSCHATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], SalesOrder.prototype, "linesAmountIncludingTaxforScheduledInvoicesRemainingToInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DRAFTSTATUS',
    })
], SalesOrder.prototype, "draftStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DRAFTREJ',
    })
], SalesOrder.prototype, "isRejectedDraft", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DRAFTREJREN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "rejectedDraftReason", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOHCFMFLG',
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesOrder.prototype, "hasElectronicSignature", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOHNUMEND',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesOrder.prototype, "finalNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SOHVALDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], SalesOrder.prototype, "validationDate", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Sales.nodes.SalesOrderLine,
        isMutable: true,
        dependsOn: ['id'],
    })
], SalesOrder.prototype, "salesOrderLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesOrder.prototype, "orderHeaderTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], SalesOrder.prototype, "orderFooterTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesOrder.prototype, "orderFooterText", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], SalesOrder.prototype, "orderHeaderText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SalesOrder.prototype, "_x3Transaction", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderBillToCustomerAddressLines,
    })
], SalesOrder.prototype, "billToCustomerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderBillToCustomerCompanyNames,
    })
], SalesOrder.prototype, "billToCustomerCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderCustomerStatisticalGroups,
    })
], SalesOrder.prototype, "customerStatisticalGroups", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderDimensions,
    })
], SalesOrder.prototype, "dimensions", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderDiscountOrChargeCalculationRules,
    })
], SalesOrder.prototype, "discountOrChargeCalculationRules", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderInvoicingElements,
    })
], SalesOrder.prototype, "invoicingElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderSalesReps,
    })
], SalesOrder.prototype, "salesReps", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderShipToCustomerAddressLines,
    })
], SalesOrder.prototype, "shipToCustomerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderShipToCustomerCompanyNames,
    })
], SalesOrder.prototype, "shipToCustomerCompanyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderSoldToCustomerAddressLines,
    })
], SalesOrder.prototype, "soldToCustomerAddressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Sales.nodes.SalesOrderSoldToCustomerCompanyNames,
    })
], SalesOrder.prototype, "soldToCustomerCompanyNames", void 0);
exports.SalesOrder = SalesOrder = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SORDER',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        getFilters() {
            return [{ category: { _nin: ['openOrder'] } }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
        canUpdate: true,
        canDelete: true,
        canDeleteMany: true,
    })
], SalesOrder);
//# sourceMappingURL=sales-order.js.map