import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, decimal, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesOrder extends Node {
    readonly id: Promise<string>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly salesOrderType: Reference<sageX3SalesData.nodes.SalesOrderType | null>;
    readonly category: Promise<sageX3SalesData.enums.OrderCategory | null>;
    readonly salesSite: Reference<sageX3System.nodes.Site>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly payByBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
    readonly customerOrderReference: Promise<string>;
    readonly additionnalReference: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly orderDate: Promise<date>;
    readonly shipmentDate: Promise<date | null>;
    readonly requestedDeliveryDate: Promise<date | null>;
    readonly loanReturnDate: Promise<date | null>;
    readonly deliveryLeadTime: Promise<integer | null>;
    readonly soldToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly soldToCustomerPostalCode: Promise<string>;
    readonly soldToCustomerCity: Promise<string>;
    readonly soldToCustomerState: Promise<string>;
    readonly soldToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly soldToCustomerCountryName: Promise<string>;
    readonly soldToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly billToCustomerPostalCode: Promise<string>;
    readonly billToCustomerCity: Promise<string>;
    readonly billToCustomerState: Promise<string>;
    readonly billToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly billToCustomerCountryName: Promise<string>;
    readonly billToCustomerEuropeanUnionVatNumber: Promise<string>;
    readonly billToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly shipToCustomerPostalCode: Promise<string>;
    readonly shipToCustomerCity: Promise<string>;
    readonly shipToCustomerState: Promise<string>;
    readonly shipToCustomerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly shipToCustomerCountryName: Promise<string>;
    readonly shipToCustomerContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly currencyRateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly currencyRate: Promise<decimal | null>;
    readonly soldToCustomerLanguage: Reference<sageX3System.nodes.Language | null>;
    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
    readonly entityUseCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
    readonly deliveryPriority: Promise<sageX3SalesData.enums.DeliveryPriority | null>;
    readonly isOrderClosingAllowed: Promise<boolean>;
    readonly mustContainOneOrderPerDelivery: Promise<boolean>;
    readonly partialDelivery: Promise<sageX3SalesData.enums.PartialDelivery | null>;
    readonly invoicingMode: Promise<sageX3SalesData.enums.InvoicingMode | null>;
    readonly mustPrintAcknowledgment: Promise<boolean>;
    readonly isAcknowledgmentPrinted: Promise<boolean>;
    readonly numberOfAcknowledgmentCopies: Promise<integer | null>;
    readonly orderHeaderTextKey: Promise<string>;
    readonly orderFooterTextKey: Promise<string>;
    readonly salesQuote: Reference<sageX3Sales.nodes.SalesQuote | null>;
    readonly isIntersite: Promise<boolean>;
    readonly isIntercompany: Promise<boolean>;
    readonly sourceSite: Reference<sageX3System.nodes.Site | null>;
    readonly salesProforma: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly lastSalesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
    readonly lastSalesDeliveryDate: Promise<date | null>;
    readonly lastSalesInvoice: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly lastSalesInvoiceDate: Promise<date | null>;
    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly linesAmountExcludingTax: Promise<decimal | null>;
    readonly linesAmountIncludingTax: Promise<decimal | null>;
    readonly linesAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly linesAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountExcludingTax: Promise<decimal | null>;
    readonly totalAmountIncludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly linesAmountRemainingToDeliverExcludingTax: Promise<decimal | null>;
    readonly linesAmountRemainingToDeliverIncludingTax: Promise<decimal | null>;
    readonly totalMargin: Promise<decimal | null>;
    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType | null>;
    readonly isUnlocked: Promise<boolean>;
    readonly numberOfLines: Promise<integer | null>;
    readonly numberOfClosedLines: Promise<integer | null>;
    readonly numberOfLinesToAllocate: Promise<integer | null>;
    readonly numberOfDeliveredLines: Promise<integer | null>;
    readonly numberOfInvoicedLines: Promise<integer | null>;
    readonly orderStatus: Promise<sageX3SalesData.enums.OrderStatus | null>;
    readonly allocationStatus: Promise<sageX3MasterData.enums.AllocationStatus | null>;
    readonly deliveryStatus: Promise<sageX3Sales.enums.SalesDeliveryStatus | null>;
    readonly invoicedStatus: Promise<sageX3Sales.enums.SalesInvoiceStatus | null>;
    readonly creditLevelStatus: Promise<sageX3SalesData.enums.CreditStatus | null>;
    readonly signatureStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
    readonly revisionNumber: Promise<integer | null>;
    readonly shipperOrReceiverCode: Promise<string>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly incotermTown: Promise<string>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly geographicCode: Promise<string>;
    readonly insideCityLimits: Promise<string>;
    readonly vertexTransactionType: Promise<string>;
    readonly taxAmount: Promise<decimal | null>;
    readonly taxableAmount: Promise<decimal | null>;
    readonly closingReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly closingDate: Promise<date | null>;
    readonly marketingOperationType: Promise<string>;
    readonly priceStructure: Reference<sageX3InvoicingData.nodes.PriceStructure | null>;
    readonly totalQuantityDistributedOnLines: Promise<decimal | null>;
    readonly totalWeightDistributedOnLines: Promise<decimal | null>;
    readonly totalVolumeDistributedOnLines: Promise<decimal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly deliveryType: Reference<sageX3SalesData.nodes.SalesDeliveryType | null>;
    readonly manualHoldStatus: Promise<sageX3SalesData.enums.HoldStatus | null>;
    readonly manualHoldReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly manualHoldOrReleaseUser: Reference<sageX3System.nodes.User | null>;
    readonly manualHoldOrReleaseDate: Promise<date | null>;
    readonly manualHoldOrReleaseTime: Promise<string>;
    readonly previousManualHoldReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly previousManualHoldOrReleaseUser: Reference<sageX3System.nodes.User | null>;
    readonly previousManualHoldOrReleaseDate: Promise<date | null>;
    readonly previousManualHoldOrReleaseTime: Promise<string>;
    readonly previousCreditLevelStatus: Promise<sageX3SalesData.enums.CreditStatus | null>;
    readonly isValidatedAddress: Promise<boolean>;
    readonly requestedDeliveryTime: Promise<string>;
    readonly invoicingTerm: Reference<sageX3InvoicingData.nodes.InvoicingTerm | null>;
    readonly scheduledInvoiceStartDueDate: Promise<date | null>;
    readonly linesAmountRemainingToInvoiceExcludingTax: Promise<decimal | null>;
    readonly linesAmountRemainingToInvoiceIncludingTax: Promise<decimal | null>;
    readonly linesAmountExcludingTaxforScheduledInvoicesRemainingToInvoice: Promise<decimal | null>;
    readonly linesAmountIncludingTaxforScheduledInvoicesRemainingToInvoice: Promise<decimal | null>;
    readonly draftStatus: Promise<integer | null>;
    readonly isRejectedDraft: Promise<boolean>;
    readonly rejectedDraftReason: Promise<string>;
    readonly hasElectronicSignature: Promise<boolean>;
    readonly finalNumber: Promise<string>;
    readonly validationDate: Promise<date | null>;
    readonly salesOrderLines: Collection<sageX3Sales.nodes.SalesOrderLine>;
    readonly orderHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly orderFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly orderFooterText: Promise<TextStream>;
    readonly orderHeaderText: Promise<TextStream>;
    readonly _x3Transaction: Promise<string>;
    readonly billToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesOrderBillToCustomerAddressLines>;
    readonly billToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesOrderBillToCustomerCompanyNames>;
    readonly customerStatisticalGroups: Collection<sageX3Sales.nodes.SalesOrderCustomerStatisticalGroups>;
    readonly dimensions: Collection<sageX3Sales.nodes.SalesOrderDimensions>;
    readonly discountOrChargeCalculationRules: Collection<sageX3Sales.nodes.SalesOrderDiscountOrChargeCalculationRules>;
    readonly invoicingElements: Collection<sageX3Sales.nodes.SalesOrderInvoicingElements>;
    readonly salesReps: Collection<sageX3Sales.nodes.SalesOrderSalesReps>;
    readonly shipToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesOrderShipToCustomerAddressLines>;
    readonly shipToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesOrderShipToCustomerCompanyNames>;
    readonly soldToCustomerAddressLines: Collection<sageX3Sales.nodes.SalesOrderSoldToCustomerAddressLines>;
    readonly soldToCustomerCompanyNames: Collection<sageX3Sales.nodes.SalesOrderSoldToCustomerCompanyNames>;
}
//# sourceMappingURL=sales-order.d.ts.map