import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3Sales from '..';
export declare class SalesOrderQuantityLine extends Node {
    readonly salesOrder: Reference<sageX3Sales.nodes.SalesOrder>;
    readonly lineNumber: Promise<integer | null>;
    readonly sequenceNumber: Reference<sageX3Sales.nodes.SalesOrderLine | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly category: Promise<sageX3SalesData.enums.OrderCategory>;
    readonly salesSite: Reference<sageX3System.nodes.Site>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Promise<string>;
    readonly shippingSite: Reference<sageX3System.nodes.Site>;
    readonly locationReference: Promise<string>;
    readonly orderDate: Promise<date | null>;
    readonly requestedDeliveryDate: Promise<date | null>;
    readonly requestedDeliveryTime: Promise<string>;
    readonly latestDeliveryTime: Promise<string>;
    readonly latestDeliveryDate: Promise<date | null>;
    readonly requestedDeliveryReference: Promise<string>;
    readonly importLineNumber: Promise<integer | null>;
    readonly shipmentDate: Promise<date | null>;
    readonly shipmentTime: Promise<string>;
    readonly expectedDeliveryDate: Promise<date | null>;
    readonly lineStatus: Promise<sageX3MasterData.enums.LineStatus | null>;
    readonly isInvoiced: Promise<boolean>;
    readonly workInProgressStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
    readonly workInProgressOrderNumber: Promise<string>;
    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
    readonly exclusiveLotFilter: Promise<string>;
    readonly exclusiveStockStatusFilter: Promise<string>;
    readonly preferentialStockLocationFilter: Reference<sageX3StockData.nodes.Location | null>;
    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType | null>;
    readonly isLineWithDistributedInvoicingElement: Promise<boolean>;
    readonly quantityInSalesUnitInitiallyOrdered: Promise<decimal | null>;
    readonly quantityInSalesUnitOrdered: Promise<decimal>;
    readonly quantityInSalesUnitShortage: Promise<decimal | null>;
    readonly quantityInSalesUnitAllocated: Promise<decimal | null>;
    readonly quantityInSalesUnitOnDeliveryOrScheduledInvoice: Promise<decimal | null>;
    readonly quantityInSalesUnitDelivered: Promise<decimal | null>;
    readonly quantityInSalesUnitInvoiced: Promise<decimal | null>;
    readonly quantityInSalesUnitToDeliverForProductsNotManagedInStock: Promise<decimal | null>;
    readonly quantityInSalesUnitOnPickList: Promise<decimal | null>;
    readonly quantityInSalesUnitInPreparation: Promise<decimal | null>;
    readonly quantityInSalesUnitPrepared: Promise<decimal | null>;
    readonly quantityInStockUnitOrdered: Promise<decimal>;
    readonly quantityInStockUnitShortage: Promise<decimal | null>;
    readonly quantityInStockUnitAllocated: Promise<decimal | null>;
    readonly quantityInStockUnitOnDeliveryOrScheduledInvoice: Promise<decimal | null>;
    readonly quantityInStockUnitDelivered: Promise<decimal | null>;
    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
    readonly quantityInStockUnitToDeliverForProductsNotManagedInStock: Promise<decimal | null>;
    readonly quantityInStockUnitOnPickList: Promise<decimal | null>;
    readonly quantityInStockUnitInPreparation: Promise<decimal | null>;
    readonly quantityInStockUnitPrepared: Promise<decimal | null>;
    readonly preparationCode: Promise<string>;
    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
    readonly deliveryPriority: Promise<sageX3SalesData.enums.DeliveryPriority | null>;
    readonly completeDeliveryPriority: Promise<integer | null>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
    readonly deliveryLeadTime: Promise<integer | null>;
    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
    readonly packagingCapacity: Promise<decimal | null>;
    readonly orderLineTextKey: Promise<string>;
    readonly salesDelivery: Reference<sageX3Sales.nodes.SalesDelivery | null>;
    readonly salesDeliveryLineNumber: Reference<sageX3Sales.nodes.SalesDeliveryLine | null>;
    readonly productSource: Promise<sageX3SalesData.enums.SourceOfShipment | null>;
    readonly backToBackOrderNumber: Promise<string>;
    readonly backToBackOrderLineNumber: Promise<integer | null>;
    readonly backToBackOrderSequenceNumber: Promise<integer | null>;
    readonly geographicCode: Promise<string>;
    readonly insideCityLimits: Promise<string>;
    readonly isTaxedGeographically: Promise<string>;
    readonly isTaxable: Promise<boolean>;
    readonly isRecordedTax: Promise<boolean>;
    readonly taxRate: Promise<decimal | null>;
    readonly taxableAmount: Promise<decimal | null>;
    readonly isComponentPrintedOnAcknowledgement: Promise<boolean>;
    readonly isComponentPrintedOnPackingSlip: Promise<boolean>;
    readonly isComponentPrintedOnInvoice: Promise<boolean>;
    readonly closingReason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly closingDate: Promise<date | null>;
    readonly tokenManagement: Promise<decimal | null>;
    readonly weightDistributedOnLine: Promise<decimal | null>;
    readonly volumeDistributedOnLine: Promise<decimal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly useByDate: Promise<date | null>;
    readonly isDeliverable: Promise<boolean>;
    readonly invoicedAmount: Promise<decimal | null>;
    readonly distributedInvoicingElements: Collection<sageX3Sales.nodes.SalesOrderQuantityLineDistributedInvoicingElements>;
}
//# sourceMappingURL=sales-order-quantity-line.d.ts.map